# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.limit_range import LimitRange
from wandelbots_api_client.v2.models.pose import Pose
from wandelbots_api_client.v2.models.single_motion_group_collision_scene import SingleMotionGroupCollisionScene
from typing import Optional, Set
from typing_extensions import Self

class InverseKinematicsRequest(BaseModel):
    """
    InverseKinematicsRequest
    """ # noqa: E501
    motion_group_model: StrictStr = Field(description="String identifiying the model of a motion group.")
    tcp_poses: List[Pose] = Field(description="List of TCP poses for which the inverse solutions are computed. ")
    tcp_offset: Optional[Pose] = None
    mounting: Optional[Pose] = Field(default=None, description="Offset from the world frame to the motion group base.")
    joint_position_limits: Optional[List[LimitRange]] = Field(default=None, description="Joint position limits in [rad], indexed starting from base. ")
    collision_scenes: Optional[Dict[str, SingleMotionGroupCollisionScene]] = Field(default=None, description="Collision scenes to be respected by the motion planner. Each contains the single motion group which is planned for. Scenes are checked individually along the trajectory and independently of other scenes. To respect the safety zones of the controller, fetch the safety zones, link and tool shapes from the controller and add one scene made up of those. To respect the safety zones of the controller and check for collision: 1. Fetch the safety zones, link and tool shapes from the controller. 2. Add the fetched zones, links and tools to a scene. 3. Create other scenes from your own 3D data as needed. 4. Execute this endpoint. 5. The response highlights the scenes in which a collision was detected by key. ")
    __properties: ClassVar[List[str]] = ["motion_group_model", "tcp_poses", "tcp_offset", "mounting", "joint_position_limits", "collision_scenes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InverseKinematicsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tcp_poses (list)
        _items = []
        if self.tcp_poses:
            for _item in self.tcp_poses:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['tcp_poses'] = _items
        # override the default output from pydantic by calling `to_dict()` of tcp_offset
        if self.tcp_offset:
            _dict['tcp_offset'] = self.tcp_offset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mounting
        if self.mounting:
            _dict['mounting'] = self.mounting.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in joint_position_limits (list)
        _items = []
        if self.joint_position_limits:
            for _item in self.joint_position_limits:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['joint_position_limits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in collision_scenes (dict)
        _field_dict = {}
        if self.collision_scenes:
            for _key in self.collision_scenes:
                if self.collision_scenes[_key]:
                    _field_dict[_key] = self.collision_scenes[_key].to_dict()
            _dict['collision_scenes'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InverseKinematicsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group_model": obj.get("motion_group_model"),
            "tcp_poses": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                Pose.from_dict(_item) if hasattr(Pose, 'from_dict') else _item
                # <<< End modification
                for _item in obj["tcp_poses"]
            ] if obj.get("tcp_poses") is not None else None,
            "tcp_offset": Pose.from_dict(obj["tcp_offset"]) if obj.get("tcp_offset") is not None else None,
            "mounting": Pose.from_dict(obj["mounting"]) if obj.get("mounting") is not None else None,
            "joint_position_limits": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                LimitRange.from_dict(_item) if hasattr(LimitRange, 'from_dict') else _item
                # <<< End modification
                for _item in obj["joint_position_limits"]
            ] if obj.get("joint_position_limits") is not None else None,
            "collision_scenes": dict(
                (_k, SingleMotionGroupCollisionScene.from_dict(_v))
                for _k, _v in obj["collision_scenes"].items()
            )
            if obj.get("collision_scenes") is not None
            else None
        })
        return _obj


