# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.paused_by_user import PausedByUser
from wandelbots_api_client.v2.models.paused_near_collision import PausedNearCollision
from wandelbots_api_client.v2.models.paused_near_joint_limit import PausedNearJointLimit
from wandelbots_api_client.v2.models.paused_on_io import PausedOnIO
from wandelbots_api_client.v2.models.running import Running
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

JOGGINGDETAILSSTATE_ONE_OF_SCHEMAS = ["PausedByUser", "PausedNearCollision", "PausedNearJointLimit", "PausedOnIO", "Running"]

class JoggingDetailsState(BaseModel):
    """
    JoggingDetailsState
    """
    # data type: Running
    oneof_schema_1_validator: Optional[Running] = None
    # data type: PausedByUser
    oneof_schema_2_validator: Optional[PausedByUser] = None
    # data type: PausedOnIO
    oneof_schema_3_validator: Optional[PausedOnIO] = None
    # data type: PausedNearJointLimit
    oneof_schema_4_validator: Optional[PausedNearJointLimit] = None
    # data type: PausedNearCollision
    oneof_schema_5_validator: Optional[PausedNearCollision] = None
    actual_instance: Optional[Union[PausedByUser, PausedNearCollision, PausedNearJointLimit, PausedOnIO, Running]] = None
    one_of_schemas: Set[str] = { "PausedByUser", "PausedNearCollision", "PausedNearJointLimit", "PausedOnIO", "Running" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = JoggingDetailsState.model_construct()
        error_messages = []
        match = 0
        # validate data type: Running
        if not isinstance(v, Running):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Running`")
        else:
            match += 1
        # validate data type: PausedByUser
        if not isinstance(v, PausedByUser):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PausedByUser`")
        else:
            match += 1
        # validate data type: PausedOnIO
        if not isinstance(v, PausedOnIO):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PausedOnIO`")
        else:
            match += 1
        # validate data type: PausedNearJointLimit
        if not isinstance(v, PausedNearJointLimit):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PausedNearJointLimit`")
        else:
            match += 1
        # validate data type: PausedNearCollision
        if not isinstance(v, PausedNearCollision):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PausedNearCollision`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in JoggingDetailsState with oneOf schemas: PausedByUser, PausedNearCollision, PausedNearJointLimit, PausedOnIO, Running. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in JoggingDetailsState with oneOf schemas: PausedByUser, PausedNearCollision, PausedNearJointLimit, PausedOnIO, Running. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("kind")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `kind` in the input.")

        # check if data type is `PausedByUser`
        if _data_type == "PausedByUser":
            instance.actual_instance = PausedByUser.from_json(json_str)
            return instance

        # check if data type is `PausedNearCollision`
        if _data_type == "PausedNearCollision":
            instance.actual_instance = PausedNearCollision.from_json(json_str)
            return instance

        # check if data type is `PausedNearJointLimit`
        if _data_type == "PausedNearJointLimit":
            instance.actual_instance = PausedNearJointLimit.from_json(json_str)
            return instance

        # check if data type is `PausedOnIO`
        if _data_type == "PausedOnIO":
            instance.actual_instance = PausedOnIO.from_json(json_str)
            return instance

        # check if data type is `Running`
        if _data_type == "Running":
            instance.actual_instance = Running.from_json(json_str)
            return instance

        # deserialize data into Running
        try:
            instance.actual_instance = Running.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PausedByUser
        try:
            instance.actual_instance = PausedByUser.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PausedOnIO
        try:
            instance.actual_instance = PausedOnIO.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PausedNearJointLimit
        try:
            instance.actual_instance = PausedNearJointLimit.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PausedNearCollision
        try:
            instance.actual_instance = PausedNearCollision.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into JoggingDetailsState with oneOf schemas: PausedByUser, PausedNearCollision, PausedNearJointLimit, PausedOnIO, Running. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into JoggingDetailsState with oneOf schemas: PausedByUser, PausedNearCollision, PausedNearJointLimit, PausedOnIO, Running. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], PausedByUser, PausedNearCollision, PausedNearJointLimit, PausedOnIO, Running]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


