# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.limit_set import LimitSet
from wandelbots_api_client.v2.models.operation_limits import OperationLimits
from typing import Optional, Set
from typing_extensions import Self

class LimitConfig(BaseModel):
    """
    LimitConfig
    """ # noqa: E501
    physical_limits: Optional[LimitSet] = None
    operation_limits: Optional[OperationLimits] = None
    __properties: ClassVar[List[str]] = ["physical_limits", "operation_limits"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LimitConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of physical_limits
        if self.physical_limits:
            _dict['physical_limits'] = self.physical_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operation_limits
        if self.operation_limits:
            _dict['operation_limits'] = self.operation_limits.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LimitConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "physical_limits": LimitSet.from_dict(obj["physical_limits"]) if obj.get("physical_limits") is not None else None,
            "operation_limits": OperationLimits.from_dict(obj["operation_limits"]) if obj.get("operation_limits") is not None else None
        })
        return _obj


