# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class RRTConnectAlgorithm(BaseModel):
    """
    <!-- theme: danger -->  > **Experimental**  RRT Connect algorithm configuration for collision-free path planning. Rapidly-exploring Random Trees (RRT) builds trees of valid configurations by randomly sampling the joint space and connecting feasible points. RRT Connect grows two trees simultaneously from start and target positions until they meet. This is a custom implementation optimized for manipulator kinematics and collision checking in industrial contexts. 
    """ # noqa: E501
    algorithm_name: StrictStr = Field(description="Algorithm discriminator. ")
    max_iterations: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=10000, description="Maximum number of iterations for the RRT Connect algorithm. Higher values increase likelihood of success, but also computation time. ")
    __properties: ClassVar[List[str]] = ["algorithm_name", "max_iterations"]

    @field_validator('algorithm_name')
    def algorithm_name_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['RRTConnectAlgorithm']):
            raise ValueError("must be one of enum values ('RRTConnectAlgorithm')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RRTConnectAlgorithm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RRTConnectAlgorithm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "algorithm_name": obj.get("algorithm_name"),
            "max_iterations": obj.get("max_iterations") if obj.get("max_iterations") is not None else 10000
        })
        return _obj


