# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.joint_limit_exceeded import JointLimitExceeded
from wandelbots_api_client.models.out_of_workspace import OutOfWorkspace
from wandelbots_api_client.models.safety_zone_violation import SafetyZoneViolation
from wandelbots_api_client.models.singularity import Singularity
from typing import Optional, Set
from typing_extensions import Self

class PlanFailedResponse(BaseModel):
    """
    Starting point of motion is invalid. Therefore, planning a motion is not possible.
    """ # noqa: E501
    description: Optional[StrictStr] = None
    start_joints_missing: Optional[Dict[str, Any]] = Field(default=None, description="Error in case no start joint position was provided. Every motion needs to start with a joint position as reference to uniquely define the kinematic configuration of the motion-group at the start the motion.")
    commands_missing: Optional[Dict[str, Any]] = Field(default=None, description="Error in case no motion commands were provided. Every planning needs to have at least one motion command to describe the path to be followed.")
    joint_limit_exceeded: Optional[JointLimitExceeded] = None
    singularity: Optional[Singularity] = None
    safety_zone_violation: Optional[SafetyZoneViolation] = None
    out_of_workspace: Optional[OutOfWorkspace] = None
    __properties: ClassVar[List[str]] = ["description", "start_joints_missing", "commands_missing", "joint_limit_exceeded", "singularity", "safety_zone_violation", "out_of_workspace"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanFailedResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of joint_limit_exceeded
        if self.joint_limit_exceeded:
            _dict['joint_limit_exceeded'] = self.joint_limit_exceeded.to_dict()
        # override the default output from pydantic by calling `to_dict()` of singularity
        if self.singularity:
            _dict['singularity'] = self.singularity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of safety_zone_violation
        if self.safety_zone_violation:
            _dict['safety_zone_violation'] = self.safety_zone_violation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of out_of_workspace
        if self.out_of_workspace:
            _dict['out_of_workspace'] = self.out_of_workspace.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanFailedResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "start_joints_missing": obj.get("start_joints_missing"),
            "commands_missing": obj.get("commands_missing"),
            "joint_limit_exceeded": JointLimitExceeded.from_dict(obj["joint_limit_exceeded"]) if obj.get("joint_limit_exceeded") is not None else None,
            "singularity": Singularity.from_dict(obj["singularity"]) if obj.get("singularity") is not None else None,
            "safety_zone_violation": SafetyZoneViolation.from_dict(obj["safety_zone_violation"]) if obj.get("safety_zone_violation") is not None else None,
            "out_of_workspace": OutOfWorkspace.from_dict(obj["out_of_workspace"]) if obj.get("out_of_workspace") is not None else None
        })
        return _obj


