# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.profinet_io_direction import ProfinetIODirection
from wandelbots_api_client.v2.models.profinet_io_type_enum import ProfinetIOTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class ProfinetIO(BaseModel):
    """
    ProfinetIO
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the input/output value. This is a human-readable identifier for the value. It can be used to distinguish between different inputs/outputs in the system. ")
    type: ProfinetIOTypeEnum
    direction: ProfinetIODirection = Field(description="The direction of the input/output value, indicating whether it is an input or output for the device. ")
    byte_address: Annotated[int, Field(strict=True, ge=0)] = Field(description="The byte address of the input/output value in the PROFINET device. The byte address is used to locate the specific input/output within the device's memory or data structure. ")
    bit_address: Optional[Annotated[int, Field(le=7, strict=True, ge=0)]] = Field(default=None, description="The bit address of the input/output value within the byte or word address. The bit address is used to specify the exact bit within the byte or word that corresponds to the input/output value. ")
    io: StrictStr = Field(description="The unique identifier for the input/output value. This identifier is used to reference the specific input/output in the NOVA system. ")
    __properties: ClassVar[List[str]] = ["name", "type", "direction", "byte_address", "bit_address", "io"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProfinetIO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProfinetIO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "direction": obj.get("direction"),
            "byte_address": obj.get("byte_address"),
            "bit_address": obj.get("bit_address"),
            "io": obj.get("io")
        })
        return _obj


