# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PyripheryPyraeRobotRobotConfiguration(BaseModel):
    """
    Configuration of a RAE Robot  Args:     model_name: Type of the robot that is initialized on the RAE     host: Host of the real robot. A virtual robot is used when \"localhost\" is given     motion_group_id: Motion group id of the robot     rae_host: Host of the RAEe     rae_port: Port of the RAE
    """ # noqa: E501
    type: Optional[StrictStr] = 'robot'
    identifier: Optional[StrictStr] = 'robot'
    host: Optional[StrictStr] = 'virtual-ur10e'
    controller_model_name: Optional[StrictStr] = 'UniversalRobots::Controller'
    motion_group_id: Optional[StrictStr] = None
    rae_host: Optional[StrictStr] = 'rae'
    rae_port: Optional[StrictInt] = 50051
    __properties: ClassVar[List[str]] = ["type", "identifier", "host", "controller_model_name", "motion_group_id", "rae_host", "rae_port"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['robot', 'robot_planner']):
            raise ValueError("must be one of enum values ('robot', 'robot_planner')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PyripheryPyraeRobotRobotConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if motion_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.motion_group_id is None and "motion_group_id" in self.model_fields_set:
            _dict['motion_group_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PyripheryPyraeRobotRobotConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type") if obj.get("type") is not None else 'robot',
            "identifier": obj.get("identifier") if obj.get("identifier") is not None else 'robot',
            "host": obj.get("host") if obj.get("host") is not None else 'virtual-ur10e',
            "controller_model_name": obj.get("controller_model_name") if obj.get("controller_model_name") is not None else 'UniversalRobots::Controller',
            "motion_group_id": obj.get("motion_group_id"),
            "rae_host": obj.get("rae_host") if obj.get("rae_host") is not None else 'rae',
            "rae_port": obj.get("rae_port") if obj.get("rae_port") is not None else 50051
        })
        return _obj


