# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.bus_io_profinet_default_route import BusIOProfinetDefaultRoute
from wandelbots_api_client.v2.models.bus_io_profinet_network import BusIOProfinetNetwork
from typing import Optional, Set
from typing_extensions import Self

class BusIOProfinet(BaseModel):
    """
    PROFINET BUS inputs/outputs service configuration. 
    """ # noqa: E501
    bus_type: Optional[StrictStr] = 'profinet'
    config_file_content: Optional[StrictStr] = Field(default=None, description="Content of Configuration XML file for PROFINET device, typically known as PND_IOD.xml. Leave empty for the default configuration.  Refer to the official PROFINET driver documentation for further information. ")
    network_config: Optional[BusIOProfinetNetwork] = Field(default=None, description="Used to enable IP communication through the same physical interface while PN Driver is running.")
    mac: StrictStr = Field(description="MAC address of the physical ethernet interface that you want to use for PROFINET communication.")
    default_route: BusIOProfinetDefaultRoute
    __properties: ClassVar[List[str]] = ["bus_type", "config_file_content", "network_config", "mac", "default_route"]

    @field_validator('bus_type')
    def bus_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['profinet']):
            raise ValueError("must be one of enum values ('profinet')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusIOProfinet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network_config
        if self.network_config:
            _dict['network_config'] = self.network_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_route
        if self.default_route:
            _dict['default_route'] = self.default_route.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusIOProfinet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bus_type": obj.get("bus_type") if obj.get("bus_type") is not None else 'profinet',
            "config_file_content": obj.get("config_file_content"),
            "network_config": BusIOProfinetNetwork.from_dict(obj["network_config"]) if obj.get("network_config") is not None else None,
            "mac": obj.get("mac"),
            "default_route": BusIOProfinetDefaultRoute.from_dict(obj["default_route"]) if obj.get("default_route") is not None else None
        })
        return _obj


