# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class ControllerDescription(BaseModel):
    """
    The data type to describe a robot controller.
    """ # noqa: E501
    connected_motion_groups: List[StrictStr]
    supports_freedrive: StrictBool = Field(description="Can this controller be moved through freedrive (true), or not (false).")
    supports_control: StrictBool = Field(description="Can this controller be controlled with NOVA (true) or is it only possible to read data (false).")
    supports_safety_zones: StrictBool = Field(description="True if NOVA supports reading safety zone-, tool- and link-geometries for this motion group. Safety zones are used to define areas where the robot should slow down or stop. If false, NOVA can't guarantee that the executed motions respect safety zones defined on the controller. ")
    __properties: ClassVar[List[str]] = ["connected_motion_groups", "supports_freedrive", "supports_control", "supports_safety_zones"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ControllerDescription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ControllerDescription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "connected_motion_groups": obj.get("connected_motion_groups"),
            "supports_freedrive": obj.get("supports_freedrive"),
            "supports_control": obj.get("supports_control"),
            "supports_safety_zones": obj.get("supports_safety_zones")
        })
        return _obj


