# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.add_trajectory_error import AddTrajectoryError
from typing import Optional, Set
from typing_extensions import Self

class InitializeMovementResponse(BaseModel):
    """
    Response for InitializeMovementRequest message. 
    """ # noqa: E501
    message: Optional[StrictStr] = Field(default=None, description="Error message in case of invalid InitializeMovementRequest.")
    add_trajectory_error: Optional[AddTrajectoryError] = Field(default=None, description="Error can occur if joint trajectory was added by [InitializeMovementRequest](InitializeMovementRequest) and the trajectory is invalid. ")
    kind: StrictStr
    __properties: ClassVar[List[str]] = ["message", "add_trajectory_error", "kind"]

    @field_validator('kind')
    def kind_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['INITIALIZE_RECEIVED']):
            raise ValueError("must be one of enum values ('INITIALIZE_RECEIVED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InitializeMovementResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of add_trajectory_error
        if self.add_trajectory_error:
            _dict['add_trajectory_error'] = self.add_trajectory_error.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InitializeMovementResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message": obj.get("message"),
            "add_trajectory_error": AddTrajectoryError.from_dict(obj["add_trajectory_error"]) if obj.get("add_trajectory_error") is not None else None,
            "kind": obj.get("kind")
        })
        return _obj


