# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.models.joints import Joints
from typing import Optional, Set
from typing_extensions import Self

class LimitsOverride(BaseModel):
    """
    If a limit is not set, the default value will be used.
    """ # noqa: E501
    joint_velocity_limits: Optional[Joints] = Field(default=None, description="Maximum joint velocity in [rad/s] for each joint. Either leave this field empty or set a value for each joint. ")
    joint_acceleration_limits: Optional[Joints] = Field(default=None, description="Maximum joint acceleration in [rad/s^2] for each joint. Either leave this field empty or set a value for each joint. ")
    tcp_velocity_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maximum allowed TCP velocity in [mm/s]. ")
    tcp_acceleration_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maximum allowed TCP acceleration in [mm/s^2]. ")
    tcp_orientation_velocity_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maximum allowed TCP rotation velocity in [rad/s]. ")
    tcp_orientation_acceleration_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maximum allowed TCP rotation acceleration in [rad/s^2]. ")
    __properties: ClassVar[List[str]] = ["joint_velocity_limits", "joint_acceleration_limits", "tcp_velocity_limit", "tcp_acceleration_limit", "tcp_orientation_velocity_limit", "tcp_orientation_acceleration_limit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LimitsOverride from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of joint_velocity_limits
        if self.joint_velocity_limits:
            _dict['joint_velocity_limits'] = self.joint_velocity_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_acceleration_limits
        if self.joint_acceleration_limits:
            _dict['joint_acceleration_limits'] = self.joint_acceleration_limits.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LimitsOverride from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "joint_velocity_limits": Joints.from_dict(obj["joint_velocity_limits"]) if obj.get("joint_velocity_limits") is not None else None,
            "joint_acceleration_limits": Joints.from_dict(obj["joint_acceleration_limits"]) if obj.get("joint_acceleration_limits") is not None else None,
            "tcp_velocity_limit": obj.get("tcp_velocity_limit"),
            "tcp_acceleration_limit": obj.get("tcp_acceleration_limit"),
            "tcp_orientation_velocity_limit": obj.get("tcp_orientation_velocity_limit"),
            "tcp_orientation_acceleration_limit": obj.get("tcp_orientation_acceleration_limit")
        })
        return _obj


