# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.models.joints import Joints
from wandelbots_api_client.models.pose import Pose
from typing import Optional, Set
from typing_extensions import Self

class TrajectorySample(BaseModel):
    """
    A sample of a trajectory is a single point of the trajectory at a specific location.
    """ # noqa: E501
    tcp_pose: Optional[Pose] = None
    tcp_velocity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="[mm/s]")
    tcp_acceleration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="[mm/s^2]")
    tcp_orientation_velocity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="[rad/s]")
    tcp_orientation_acceleration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="[rad/s^2]")
    joint_position: Optional[Joints] = None
    joint_velocity: Optional[Joints] = None
    joint_acceleration: Optional[Joints] = None
    joint_torques: Optional[Joints] = None
    time: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="[s]")
    location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="location on trajectory")
    __properties: ClassVar[List[str]] = ["tcp_pose", "tcp_velocity", "tcp_acceleration", "tcp_orientation_velocity", "tcp_orientation_acceleration", "joint_position", "joint_velocity", "joint_acceleration", "joint_torques", "time", "location_on_trajectory"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrajectorySample from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tcp_pose
        if self.tcp_pose:
            _dict['tcp_pose'] = self.tcp_pose.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_position
        if self.joint_position:
            _dict['joint_position'] = self.joint_position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_velocity
        if self.joint_velocity:
            _dict['joint_velocity'] = self.joint_velocity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_acceleration
        if self.joint_acceleration:
            _dict['joint_acceleration'] = self.joint_acceleration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_torques
        if self.joint_torques:
            _dict['joint_torques'] = self.joint_torques.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrajectorySample from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tcp_pose": Pose.from_dict(obj["tcp_pose"]) if obj.get("tcp_pose") is not None else None,
            "tcp_velocity": obj.get("tcp_velocity"),
            "tcp_acceleration": obj.get("tcp_acceleration"),
            "tcp_orientation_velocity": obj.get("tcp_orientation_velocity"),
            "tcp_orientation_acceleration": obj.get("tcp_orientation_acceleration"),
            "joint_position": Joints.from_dict(obj["joint_position"]) if obj.get("joint_position") is not None else None,
            "joint_velocity": Joints.from_dict(obj["joint_velocity"]) if obj.get("joint_velocity") is not None else None,
            "joint_acceleration": Joints.from_dict(obj["joint_acceleration"]) if obj.get("joint_acceleration") is not None else None,
            "joint_torques": Joints.from_dict(obj["joint_torques"]) if obj.get("joint_torques") is not None else None,
            "time": obj.get("time"),
            "location_on_trajectory": obj.get("location_on_trajectory")
        })
        return _obj


