# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from wandelbots_api_client.v2.models.motion_command import MotionCommand
from wandelbots_api_client.v2.models.motion_group_setup import MotionGroupSetup
from typing import Optional, Set
from typing_extensions import Self

class PlanTrajectoryRequest(BaseModel):
    """
    PlanTrajectoryRequest
    """ # noqa: E501
    motion_group_setup: MotionGroupSetup = Field(description="The data to assemble the robot setup can be retrieved from [getMotionGroupDescription](getMotionGroupDescription) endpoint.")
    start_joint_position: List[Union[StrictFloat, StrictInt]]
    motion_commands: List[MotionCommand] = Field(description="List of motion commands. A command consists of a path definition (line, circle, joint_ptp, cartesian_ptp, cubic_spline), blending, and limits override. ")
    __properties: ClassVar[List[str]] = ["motion_group_setup", "start_joint_position", "motion_commands"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanTrajectoryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of motion_group_setup
        if self.motion_group_setup:
            _dict['motion_group_setup'] = self.motion_group_setup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in motion_commands (list)
        _items = []
        if self.motion_commands:
            for _item in self.motion_commands:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['motion_commands'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanTrajectoryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group_setup": MotionGroupSetup.from_dict(obj["motion_group_setup"]) if obj.get("motion_group_setup") is not None else None,
            "start_joint_position": obj.get("start_joint_position"),
            "motion_commands": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                MotionCommand.from_dict(_item) if hasattr(MotionCommand, 'from_dict') else _item
                # <<< End modification
                for _item in obj["motion_commands"]
            ] if obj.get("motion_commands") is not None else None
        })
        return _obj


