# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.models.box3 import Box3
from wandelbots_api_client.models.capsule3 import Capsule3
from wandelbots_api_client.models.convex_hull3 import ConvexHull3
from wandelbots_api_client.models.cylinder3 import Cylinder3
from wandelbots_api_client.models.plane3 import Plane3
from wandelbots_api_client.models.rectangle3 import Rectangle3
from wandelbots_api_client.models.rectangular_capsule3 import RectangularCapsule3
from wandelbots_api_client.models.sphere3 import Sphere3
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

COLLIDEROUTPUTSHAPE_ONE_OF_SCHEMAS = ["Box3", "Capsule3", "ConvexHull3", "Cylinder3", "Plane3", "Rectangle3", "RectangularCapsule3", "Sphere3"]

class ColliderOutputShape(BaseModel):
    """
    ColliderOutputShape
    """
    # data type: Sphere3
    oneof_schema_1_validator: Optional[Sphere3] = None
    # data type: Box3
    oneof_schema_2_validator: Optional[Box3] = None
    # data type: Rectangle3
    oneof_schema_3_validator: Optional[Rectangle3] = None
    # data type: Plane3
    oneof_schema_4_validator: Optional[Plane3] = None
    # data type: Cylinder3
    oneof_schema_5_validator: Optional[Cylinder3] = None
    # data type: Capsule3
    oneof_schema_6_validator: Optional[Capsule3] = None
    # data type: RectangularCapsule3
    oneof_schema_7_validator: Optional[RectangularCapsule3] = None
    # data type: ConvexHull3
    oneof_schema_8_validator: Optional[ConvexHull3] = None
    actual_instance: Optional[Union[Box3, Capsule3, ConvexHull3, Cylinder3, Plane3, Rectangle3, RectangularCapsule3, Sphere3]] = None
    one_of_schemas: Set[str] = { "Box3", "Capsule3", "ConvexHull3", "Cylinder3", "Plane3", "Rectangle3", "RectangularCapsule3", "Sphere3" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ColliderOutputShape.model_construct()
        error_messages = []
        match = 0
        # validate data type: Sphere3
        if not isinstance(v, Sphere3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Sphere3`")
        else:
            match += 1
        # validate data type: Box3
        if not isinstance(v, Box3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Box3`")
        else:
            match += 1
        # validate data type: Rectangle3
        if not isinstance(v, Rectangle3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Rectangle3`")
        else:
            match += 1
        # validate data type: Plane3
        if not isinstance(v, Plane3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Plane3`")
        else:
            match += 1
        # validate data type: Cylinder3
        if not isinstance(v, Cylinder3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Cylinder3`")
        else:
            match += 1
        # validate data type: Capsule3
        if not isinstance(v, Capsule3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Capsule3`")
        else:
            match += 1
        # validate data type: RectangularCapsule3
        if not isinstance(v, RectangularCapsule3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RectangularCapsule3`")
        else:
            match += 1
        # validate data type: ConvexHull3
        if not isinstance(v, ConvexHull3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ConvexHull3`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ColliderOutputShape with oneOf schemas: Box3, Capsule3, ConvexHull3, Cylinder3, Plane3, Rectangle3, RectangularCapsule3, Sphere3. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ColliderOutputShape with oneOf schemas: Box3, Capsule3, ConvexHull3, Cylinder3, Plane3, Rectangle3, RectangularCapsule3, Sphere3. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into Sphere3
        try:
            instance.actual_instance = Sphere3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Box3
        try:
            instance.actual_instance = Box3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Rectangle3
        try:
            instance.actual_instance = Rectangle3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Plane3
        try:
            instance.actual_instance = Plane3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Cylinder3
        try:
            instance.actual_instance = Cylinder3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Capsule3
        try:
            instance.actual_instance = Capsule3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RectangularCapsule3
        try:
            instance.actual_instance = RectangularCapsule3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ConvexHull3
        try:
            instance.actual_instance = ConvexHull3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ColliderOutputShape with oneOf schemas: Box3, Capsule3, ConvexHull3, Cylinder3, Plane3, Rectangle3, RectangularCapsule3, Sphere3. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ColliderOutputShape with oneOf schemas: Box3, Capsule3, ConvexHull3, Cylinder3, Plane3, Rectangle3, RectangularCapsule3, Sphere3. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Box3, Capsule3, ConvexHull3, Cylinder3, Plane3, Rectangle3, RectangularCapsule3, Sphere3]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


