# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.box import Box
from wandelbots_api_client.v2.models.capsule import Capsule
from wandelbots_api_client.v2.models.convex_hull import ConvexHull
from wandelbots_api_client.v2.models.cylinder import Cylinder
from wandelbots_api_client.v2.models.plane import Plane
from wandelbots_api_client.v2.models.rectangle import Rectangle
from wandelbots_api_client.v2.models.rectangular_capsule import RectangularCapsule
from wandelbots_api_client.v2.models.sphere import Sphere
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

COLLIDERSHAPE_ONE_OF_SCHEMAS = ["Box", "Capsule", "ConvexHull", "Cylinder", "Plane", "Rectangle", "RectangularCapsule", "Sphere"]

class ColliderShape(BaseModel):
    """
    ColliderShape
    """
    # data type: Sphere
    oneof_schema_1_validator: Optional[Sphere] = None
    # data type: Box
    oneof_schema_2_validator: Optional[Box] = None
    # data type: Rectangle
    oneof_schema_3_validator: Optional[Rectangle] = None
    # data type: Plane
    oneof_schema_4_validator: Optional[Plane] = None
    # data type: Cylinder
    oneof_schema_5_validator: Optional[Cylinder] = None
    # data type: Capsule
    oneof_schema_6_validator: Optional[Capsule] = None
    # data type: RectangularCapsule
    oneof_schema_7_validator: Optional[RectangularCapsule] = None
    # data type: ConvexHull
    oneof_schema_8_validator: Optional[ConvexHull] = None
    actual_instance: Optional[Union[Box, Capsule, ConvexHull, Cylinder, Plane, Rectangle, RectangularCapsule, Sphere]] = None
    one_of_schemas: Set[str] = { "Box", "Capsule", "ConvexHull", "Cylinder", "Plane", "Rectangle", "RectangularCapsule", "Sphere" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ColliderShape.model_construct()
        error_messages = []
        match = 0
        # validate data type: Sphere
        if not isinstance(v, Sphere):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Sphere`")
        else:
            match += 1
        # validate data type: Box
        if not isinstance(v, Box):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Box`")
        else:
            match += 1
        # validate data type: Rectangle
        if not isinstance(v, Rectangle):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Rectangle`")
        else:
            match += 1
        # validate data type: Plane
        if not isinstance(v, Plane):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Plane`")
        else:
            match += 1
        # validate data type: Cylinder
        if not isinstance(v, Cylinder):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Cylinder`")
        else:
            match += 1
        # validate data type: Capsule
        if not isinstance(v, Capsule):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Capsule`")
        else:
            match += 1
        # validate data type: RectangularCapsule
        if not isinstance(v, RectangularCapsule):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RectangularCapsule`")
        else:
            match += 1
        # validate data type: ConvexHull
        if not isinstance(v, ConvexHull):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ConvexHull`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ColliderShape with oneOf schemas: Box, Capsule, ConvexHull, Cylinder, Plane, Rectangle, RectangularCapsule, Sphere. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ColliderShape with oneOf schemas: Box, Capsule, ConvexHull, Cylinder, Plane, Rectangle, RectangularCapsule, Sphere. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("shape_type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `shape_type` in the input.")

        # check if data type is `Box`
        if _data_type == "box":
            instance.actual_instance = Box.from_json(json_str)
            return instance

        # check if data type is `Capsule`
        if _data_type == "capsule":
            instance.actual_instance = Capsule.from_json(json_str)
            return instance

        # check if data type is `ConvexHull`
        if _data_type == "convex_hull":
            instance.actual_instance = ConvexHull.from_json(json_str)
            return instance

        # check if data type is `Cylinder`
        if _data_type == "cylinder":
            instance.actual_instance = Cylinder.from_json(json_str)
            return instance

        # check if data type is `Plane`
        if _data_type == "plane":
            instance.actual_instance = Plane.from_json(json_str)
            return instance

        # check if data type is `Rectangle`
        if _data_type == "rectangle":
            instance.actual_instance = Rectangle.from_json(json_str)
            return instance

        # check if data type is `RectangularCapsule`
        if _data_type == "rectangular_capsule":
            instance.actual_instance = RectangularCapsule.from_json(json_str)
            return instance

        # check if data type is `Sphere`
        if _data_type == "sphere":
            instance.actual_instance = Sphere.from_json(json_str)
            return instance

        # check if data type is `Box`
        if _data_type == "Box":
            instance.actual_instance = Box.from_json(json_str)
            return instance

        # check if data type is `Capsule`
        if _data_type == "Capsule":
            instance.actual_instance = Capsule.from_json(json_str)
            return instance

        # check if data type is `ConvexHull`
        if _data_type == "ConvexHull":
            instance.actual_instance = ConvexHull.from_json(json_str)
            return instance

        # check if data type is `Cylinder`
        if _data_type == "Cylinder":
            instance.actual_instance = Cylinder.from_json(json_str)
            return instance

        # check if data type is `Plane`
        if _data_type == "Plane":
            instance.actual_instance = Plane.from_json(json_str)
            return instance

        # check if data type is `Rectangle`
        if _data_type == "Rectangle":
            instance.actual_instance = Rectangle.from_json(json_str)
            return instance

        # check if data type is `RectangularCapsule`
        if _data_type == "RectangularCapsule":
            instance.actual_instance = RectangularCapsule.from_json(json_str)
            return instance

        # check if data type is `Sphere`
        if _data_type == "Sphere":
            instance.actual_instance = Sphere.from_json(json_str)
            return instance

        # deserialize data into Sphere
        try:
            instance.actual_instance = Sphere.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Box
        try:
            instance.actual_instance = Box.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Rectangle
        try:
            instance.actual_instance = Rectangle.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Plane
        try:
            instance.actual_instance = Plane.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Cylinder
        try:
            instance.actual_instance = Cylinder.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Capsule
        try:
            instance.actual_instance = Capsule.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RectangularCapsule
        try:
            instance.actual_instance = RectangularCapsule.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ConvexHull
        try:
            instance.actual_instance = ConvexHull.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ColliderShape with oneOf schemas: Box, Capsule, ConvexHull, Cylinder, Plane, Rectangle, RectangularCapsule, Sphere. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ColliderShape with oneOf schemas: Box, Capsule, ConvexHull, Cylinder, Plane, Rectangle, RectangularCapsule, Sphere. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Box, Capsule, ConvexHull, Cylinder, Plane, Rectangle, RectangularCapsule, Sphere]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


