# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.profinet_sub_slot_description import ProfinetSubSlotDescription
from typing import Optional, Set
from typing_extensions import Self

class ProfinetSlotDescription(BaseModel):
    """
    An array of PROFINET slots.  PROFINET models each device’s input/output hardware as a hierarchy of slots (modules) and subslots (submodules). A slot can represent a physical or virtual input/output card and each subslot one of its individual channels or functions. Every slot and subslot has unique identifiers that the controller uses to map cyclic input/output data and parameter records to its process image. This slot/subslot separation enables e.g., addressing each input/output stream when establishing input/output application relations (I/O-AR). 
    """ # noqa: E501
    number: Annotated[int, Field(strict=True, ge=0)] = Field(description="The number/index of the PROFINET slot. Per default, slot 0 is reserved for the device access point (DAP). Slots that are part of the cyclic input/output data exchange start at number 1. ")
    api: Annotated[int, Field(strict=True, ge=0)] = Field(description="The application process identifier (API) number of the PROFINET input. The API identifies the application relation (AR) that is using the slot. ")
    subslots: List[ProfinetSubSlotDescription] = Field(description="An array of PROFINET subslots. ")
    __properties: ClassVar[List[str]] = ["number", "api", "subslots"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProfinetSlotDescription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in subslots (list)
        _items = []
        if self.subslots:
            for _item in self.subslots:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['subslots'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProfinetSlotDescription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "number": obj.get("number"),
            "api": obj.get("api"),
            "subslots": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                ProfinetSubSlotDescription.from_dict(_item) if hasattr(ProfinetSubSlotDescription, 'from_dict') else _item
                # <<< End modification
                for _item in obj["subslots"]
            ] if obj.get("subslots") is not None else None
        })
        return _obj


