# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.program_run_state import ProgramRunState
from typing import Optional, Set
from typing_extensions import Self

class ProgramRun(BaseModel):
    """
    Holds the state of a program run.
    """ # noqa: E501
    run: StrictStr = Field(description="Unique identifier of the program run")
    program: StrictStr = Field(description="Unique identifier of the program")
    state: ProgramRunState = Field(description="State of the program run")
    logs: Optional[StrictStr] = Field(default=None, description="Logs of the program run")
    stdout: Optional[StrictStr] = Field(default=None, description="Stdout of the program run")
    stderr: Optional[StrictStr] = Field(default=None, description="Stderr of the program run")
    error: Optional[StrictStr] = Field(default=None, description="Error message of the program run, if any")
    traceback: Optional[StrictStr] = Field(default=None, description="Traceback of the program run, if any")
    start_time: Optional[datetime] = Field(default=None, description="Start time of the program run")
    end_time: Optional[datetime] = Field(default=None, description="End time of the program run")
    input_data: Optional[Dict[str, Any]] = Field(default=None, description="Input data of the program run")
    __properties: ClassVar[List[str]] = ["run", "program", "state", "logs", "stdout", "stderr", "error", "traceback", "start_time", "end_time", "input_data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "run": obj.get("run"),
            "program": obj.get("program"),
            "state": obj.get("state"),
            "logs": obj.get("logs"),
            "stdout": obj.get("stdout"),
            "stderr": obj.get("stderr"),
            "error": obj.get("error"),
            "traceback": obj.get("traceback"),
            "start_time": obj.get("start_time"),
            "end_time": obj.get("end_time"),
            "input_data": obj.get("input_data")
        })
        return _obj


