# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.jogging_paused_by_user import JoggingPausedByUser
from wandelbots_api_client.v2.models.jogging_paused_near_collision import JoggingPausedNearCollision
from wandelbots_api_client.v2.models.jogging_paused_near_joint_limit import JoggingPausedNearJointLimit
from wandelbots_api_client.v2.models.jogging_paused_on_io import JoggingPausedOnIO
from wandelbots_api_client.v2.models.jogging_running import JoggingRunning
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

JOGGINGDETAILSSTATE_ONE_OF_SCHEMAS = ["JoggingPausedByUser", "JoggingPausedNearCollision", "JoggingPausedNearJointLimit", "JoggingPausedOnIO", "JoggingRunning"]

class JoggingDetailsState(BaseModel):
    """
    JoggingDetailsState
    """
    # data type: JoggingRunning
    oneof_schema_1_validator: Optional[JoggingRunning] = None
    # data type: JoggingPausedByUser
    oneof_schema_2_validator: Optional[JoggingPausedByUser] = None
    # data type: JoggingPausedOnIO
    oneof_schema_3_validator: Optional[JoggingPausedOnIO] = None
    # data type: JoggingPausedNearJointLimit
    oneof_schema_4_validator: Optional[JoggingPausedNearJointLimit] = None
    # data type: JoggingPausedNearCollision
    oneof_schema_5_validator: Optional[JoggingPausedNearCollision] = None
    actual_instance: Optional[Union[JoggingPausedByUser, JoggingPausedNearCollision, JoggingPausedNearJointLimit, JoggingPausedOnIO, JoggingRunning]] = None
    one_of_schemas: Set[str] = { "JoggingPausedByUser", "JoggingPausedNearCollision", "JoggingPausedNearJointLimit", "JoggingPausedOnIO", "JoggingRunning" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = JoggingDetailsState.model_construct()
        error_messages = []
        match = 0
        # validate data type: JoggingRunning
        if not isinstance(v, JoggingRunning):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JoggingRunning`")
        else:
            match += 1
        # validate data type: JoggingPausedByUser
        if not isinstance(v, JoggingPausedByUser):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JoggingPausedByUser`")
        else:
            match += 1
        # validate data type: JoggingPausedOnIO
        if not isinstance(v, JoggingPausedOnIO):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JoggingPausedOnIO`")
        else:
            match += 1
        # validate data type: JoggingPausedNearJointLimit
        if not isinstance(v, JoggingPausedNearJointLimit):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JoggingPausedNearJointLimit`")
        else:
            match += 1
        # validate data type: JoggingPausedNearCollision
        if not isinstance(v, JoggingPausedNearCollision):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JoggingPausedNearCollision`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in JoggingDetailsState with oneOf schemas: JoggingPausedByUser, JoggingPausedNearCollision, JoggingPausedNearJointLimit, JoggingPausedOnIO, JoggingRunning. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in JoggingDetailsState with oneOf schemas: JoggingPausedByUser, JoggingPausedNearCollision, JoggingPausedNearJointLimit, JoggingPausedOnIO, JoggingRunning. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("kind")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `kind` in the input.")

        # check if data type is `JoggingPausedByUser`
        if _data_type == "PAUSED_BY_USER":
            instance.actual_instance = JoggingPausedByUser.from_json(json_str)
            return instance

        # check if data type is `JoggingPausedNearCollision`
        if _data_type == "PAUSED_NEAR_COLLISION":
            instance.actual_instance = JoggingPausedNearCollision.from_json(json_str)
            return instance

        # check if data type is `JoggingPausedNearJointLimit`
        if _data_type == "PAUSED_NEAR_JOINT_LIMIT":
            instance.actual_instance = JoggingPausedNearJointLimit.from_json(json_str)
            return instance

        # check if data type is `JoggingPausedOnIO`
        if _data_type == "PAUSED_ON_IO":
            instance.actual_instance = JoggingPausedOnIO.from_json(json_str)
            return instance

        # check if data type is `JoggingRunning`
        if _data_type == "RUNNING":
            instance.actual_instance = JoggingRunning.from_json(json_str)
            return instance

        # check if data type is `JoggingPausedByUser`
        if _data_type == "JoggingPausedByUser":
            instance.actual_instance = JoggingPausedByUser.from_json(json_str)
            return instance

        # check if data type is `JoggingPausedNearCollision`
        if _data_type == "JoggingPausedNearCollision":
            instance.actual_instance = JoggingPausedNearCollision.from_json(json_str)
            return instance

        # check if data type is `JoggingPausedNearJointLimit`
        if _data_type == "JoggingPausedNearJointLimit":
            instance.actual_instance = JoggingPausedNearJointLimit.from_json(json_str)
            return instance

        # check if data type is `JoggingPausedOnIO`
        if _data_type == "JoggingPausedOnIO":
            instance.actual_instance = JoggingPausedOnIO.from_json(json_str)
            return instance

        # check if data type is `JoggingRunning`
        if _data_type == "JoggingRunning":
            instance.actual_instance = JoggingRunning.from_json(json_str)
            return instance

        # deserialize data into JoggingRunning
        try:
            instance.actual_instance = JoggingRunning.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JoggingPausedByUser
        try:
            instance.actual_instance = JoggingPausedByUser.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JoggingPausedOnIO
        try:
            instance.actual_instance = JoggingPausedOnIO.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JoggingPausedNearJointLimit
        try:
            instance.actual_instance = JoggingPausedNearJointLimit.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JoggingPausedNearCollision
        try:
            instance.actual_instance = JoggingPausedNearCollision.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into JoggingDetailsState with oneOf schemas: JoggingPausedByUser, JoggingPausedNearCollision, JoggingPausedNearJointLimit, JoggingPausedOnIO, JoggingRunning. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into JoggingDetailsState with oneOf schemas: JoggingPausedByUser, JoggingPausedNearCollision, JoggingPausedNearJointLimit, JoggingPausedOnIO, JoggingRunning. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], JoggingPausedByUser, JoggingPausedNearCollision, JoggingPausedNearJointLimit, JoggingPausedOnIO, JoggingRunning]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


