# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.profinet_io_direction import ProfinetIODirection
from wandelbots_api_client.v2.models.profinet_io_type_enum import ProfinetIOTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class ProfinetIOData(BaseModel):
    """
    ProfinetIOData
    """ # noqa: E501
    description: StrictStr = Field(description="Descriptive name or note for the input/output variable. ")
    type: ProfinetIOTypeEnum
    direction: ProfinetIODirection = Field(description="The direction of the input/output variable, indicating whether it is an input or output for the PROFINET device, e.g. NOVA's PROFINET service. ")
    byte_address: Annotated[int, Field(strict=True, ge=0)] = Field(description="The byte address of the input/output variable in the PROFINET device, e.g. NOVA's PROFINET service. The byte address is used to locate the specific input/output variable within the device's memory or data structure. ")
    bit_address: Optional[Annotated[int, Field(le=7, strict=True, ge=0)]] = Field(default=None, description="The bit address of the input/output variable within the byte or word address. The bit address is used to specify the exact bit within the byte or word that corresponds to the input/output variable. ")
    __properties: ClassVar[List[str]] = ["description", "type", "direction", "byte_address", "bit_address"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProfinetIOData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProfinetIOData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "type": obj.get("type"),
            "direction": obj.get("direction"),
            "byte_address": obj.get("byte_address"),
            "bit_address": obj.get("bit_address")
        })
        return _obj


