# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.2.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.initialize_movement_response import InitializeMovementResponse
from wandelbots_api_client.v2.models.movement_error_response import MovementErrorResponse
from wandelbots_api_client.v2.models.pause_movement_response import PauseMovementResponse
from wandelbots_api_client.v2.models.playback_speed_response import PlaybackSpeedResponse
from wandelbots_api_client.v2.models.start_movement_response import StartMovementResponse
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

EXECUTETRAJECTORYRESPONSE_ONE_OF_SCHEMAS = ["InitializeMovementResponse", "MovementErrorResponse", "PauseMovementResponse", "PlaybackSpeedResponse", "StartMovementResponse"]

class ExecuteTrajectoryResponse(BaseModel):
    """
    ExecuteTrajectoryResponse
    """
    # data type: InitializeMovementResponse
    oneof_schema_1_validator: Optional[InitializeMovementResponse] = None
    # data type: StartMovementResponse
    oneof_schema_2_validator: Optional[StartMovementResponse] = None
    # data type: PauseMovementResponse
    oneof_schema_3_validator: Optional[PauseMovementResponse] = None
    # data type: PlaybackSpeedResponse
    oneof_schema_4_validator: Optional[PlaybackSpeedResponse] = None
    # data type: MovementErrorResponse
    oneof_schema_5_validator: Optional[MovementErrorResponse] = None
    actual_instance: Optional[Union[InitializeMovementResponse, MovementErrorResponse, PauseMovementResponse, PlaybackSpeedResponse, StartMovementResponse]] = None
    one_of_schemas: Set[str] = { "InitializeMovementResponse", "MovementErrorResponse", "PauseMovementResponse", "PlaybackSpeedResponse", "StartMovementResponse" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ExecuteTrajectoryResponse.model_construct()
        error_messages = []
        match = 0
        # validate data type: InitializeMovementResponse
        if not isinstance(v, InitializeMovementResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InitializeMovementResponse`")
        else:
            match += 1
        # validate data type: StartMovementResponse
        if not isinstance(v, StartMovementResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StartMovementResponse`")
        else:
            match += 1
        # validate data type: PauseMovementResponse
        if not isinstance(v, PauseMovementResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PauseMovementResponse`")
        else:
            match += 1
        # validate data type: PlaybackSpeedResponse
        if not isinstance(v, PlaybackSpeedResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PlaybackSpeedResponse`")
        else:
            match += 1
        # validate data type: MovementErrorResponse
        if not isinstance(v, MovementErrorResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MovementErrorResponse`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ExecuteTrajectoryResponse with oneOf schemas: InitializeMovementResponse, MovementErrorResponse, PauseMovementResponse, PlaybackSpeedResponse, StartMovementResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ExecuteTrajectoryResponse with oneOf schemas: InitializeMovementResponse, MovementErrorResponse, PauseMovementResponse, PlaybackSpeedResponse, StartMovementResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("kind")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `kind` in the input.")

        # check if data type is `InitializeMovementResponse`
        if _data_type == "INITIALIZE_RECEIVED":
            instance.actual_instance = InitializeMovementResponse.from_json(json_str)
            return instance

        # check if data type is `MovementErrorResponse`
        if _data_type == "MOTION_ERROR":
            instance.actual_instance = MovementErrorResponse.from_json(json_str)
            return instance

        # check if data type is `PauseMovementResponse`
        if _data_type == "PAUSE_RECEIVED":
            instance.actual_instance = PauseMovementResponse.from_json(json_str)
            return instance

        # check if data type is `PlaybackSpeedResponse`
        if _data_type == "PLAYBACK_SPEED_RECEIVED":
            instance.actual_instance = PlaybackSpeedResponse.from_json(json_str)
            return instance

        # check if data type is `StartMovementResponse`
        if _data_type == "START_RECEIVED":
            instance.actual_instance = StartMovementResponse.from_json(json_str)
            return instance

        # deserialize data into InitializeMovementResponse
        try:
            instance.actual_instance = InitializeMovementResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StartMovementResponse
        try:
            instance.actual_instance = StartMovementResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PauseMovementResponse
        try:
            instance.actual_instance = PauseMovementResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PlaybackSpeedResponse
        try:
            instance.actual_instance = PlaybackSpeedResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MovementErrorResponse
        try:
            instance.actual_instance = MovementErrorResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ExecuteTrajectoryResponse with oneOf schemas: InitializeMovementResponse, MovementErrorResponse, PauseMovementResponse, PlaybackSpeedResponse, StartMovementResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ExecuteTrajectoryResponse with oneOf schemas: InitializeMovementResponse, MovementErrorResponse, PauseMovementResponse, PlaybackSpeedResponse, StartMovementResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], InitializeMovementResponse, MovementErrorResponse, PauseMovementResponse, PlaybackSpeedResponse, StartMovementResponse]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


