# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.2.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.initialize_jogging_response import InitializeJoggingResponse
from wandelbots_api_client.v2.models.joint_velocity_response import JointVelocityResponse
from wandelbots_api_client.v2.models.movement_error_response import MovementErrorResponse
from wandelbots_api_client.v2.models.pause_jogging_response import PauseJoggingResponse
from wandelbots_api_client.v2.models.tcp_velocity_response import TcpVelocityResponse
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

EXECUTEJOGGINGRESPONSE_ONE_OF_SCHEMAS = ["InitializeJoggingResponse", "JointVelocityResponse", "MovementErrorResponse", "PauseJoggingResponse", "TcpVelocityResponse"]

class ExecuteJoggingResponse(BaseModel):
    """
    ExecuteJoggingResponse
    """
    # data type: InitializeJoggingResponse
    oneof_schema_1_validator: Optional[InitializeJoggingResponse] = None
    # data type: PauseJoggingResponse
    oneof_schema_2_validator: Optional[PauseJoggingResponse] = None
    # data type: TcpVelocityResponse
    oneof_schema_3_validator: Optional[TcpVelocityResponse] = None
    # data type: JointVelocityResponse
    oneof_schema_4_validator: Optional[JointVelocityResponse] = None
    # data type: MovementErrorResponse
    oneof_schema_5_validator: Optional[MovementErrorResponse] = None
    actual_instance: Optional[Union[InitializeJoggingResponse, JointVelocityResponse, MovementErrorResponse, PauseJoggingResponse, TcpVelocityResponse]] = None
    one_of_schemas: Set[str] = { "InitializeJoggingResponse", "JointVelocityResponse", "MovementErrorResponse", "PauseJoggingResponse", "TcpVelocityResponse" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ExecuteJoggingResponse.model_construct()
        error_messages = []
        match = 0
        # validate data type: InitializeJoggingResponse
        if not isinstance(v, InitializeJoggingResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InitializeJoggingResponse`")
        else:
            match += 1
        # validate data type: PauseJoggingResponse
        if not isinstance(v, PauseJoggingResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PauseJoggingResponse`")
        else:
            match += 1
        # validate data type: TcpVelocityResponse
        if not isinstance(v, TcpVelocityResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TcpVelocityResponse`")
        else:
            match += 1
        # validate data type: JointVelocityResponse
        if not isinstance(v, JointVelocityResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JointVelocityResponse`")
        else:
            match += 1
        # validate data type: MovementErrorResponse
        if not isinstance(v, MovementErrorResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MovementErrorResponse`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ExecuteJoggingResponse with oneOf schemas: InitializeJoggingResponse, JointVelocityResponse, MovementErrorResponse, PauseJoggingResponse, TcpVelocityResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ExecuteJoggingResponse with oneOf schemas: InitializeJoggingResponse, JointVelocityResponse, MovementErrorResponse, PauseJoggingResponse, TcpVelocityResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("kind")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `kind` in the input.")

        # check if data type is `InitializeJoggingResponse`
        if _data_type == "INITIALIZE_RECEIVED":
            instance.actual_instance = InitializeJoggingResponse.from_json(json_str)
            return instance

        # check if data type is `JointVelocityResponse`
        if _data_type == "JOINT_VELOCITY_RECEIVED":
            instance.actual_instance = JointVelocityResponse.from_json(json_str)
            return instance

        # check if data type is `MovementErrorResponse`
        if _data_type == "MOTION_ERROR":
            instance.actual_instance = MovementErrorResponse.from_json(json_str)
            return instance

        # check if data type is `PauseJoggingResponse`
        if _data_type == "PAUSE_RECEIVED":
            instance.actual_instance = PauseJoggingResponse.from_json(json_str)
            return instance

        # check if data type is `TcpVelocityResponse`
        if _data_type == "TCP_VELOCITY_RECEIVED":
            instance.actual_instance = TcpVelocityResponse.from_json(json_str)
            return instance

        # deserialize data into InitializeJoggingResponse
        try:
            instance.actual_instance = InitializeJoggingResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PauseJoggingResponse
        try:
            instance.actual_instance = PauseJoggingResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TcpVelocityResponse
        try:
            instance.actual_instance = TcpVelocityResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JointVelocityResponse
        try:
            instance.actual_instance = JointVelocityResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MovementErrorResponse
        try:
            instance.actual_instance = MovementErrorResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ExecuteJoggingResponse with oneOf schemas: InitializeJoggingResponse, JointVelocityResponse, MovementErrorResponse, PauseJoggingResponse, TcpVelocityResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ExecuteJoggingResponse with oneOf schemas: InitializeJoggingResponse, JointVelocityResponse, MovementErrorResponse, PauseJoggingResponse, TcpVelocityResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], InitializeJoggingResponse, JointVelocityResponse, MovementErrorResponse, PauseJoggingResponse, TcpVelocityResponse]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


