# generated by datamodel-codegen:
#   filename:  public.openapi.yaml
#   timestamp: 2026-01-29T15:06:00+00:00

from __future__ import annotations

from datetime import date
from enum import Enum
from ipaddress import IPv4Address
from pathlib import Path
from typing import Annotated, Any, Literal

from pydantic import AwareDatetime, BaseModel, EmailStr, Field, RootModel
from .virtual_controller_types import VirtualControllerTypes


class NameList(RootModel):
    """
    A list of names
    """

    root: list[str]
    """
    A list of names
    """

    def __getitem__(self, index: int) -> str:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: str) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class CellName(RootModel):
    root: Annotated[str, Field(pattern='^[a-z][a-z0-9-]{0,30}[a-z0-9]$')] = 'cell'
    """
    A unique name for the cell used as an identifier for addressing the cell in all API calls.
    It must be a valid k8s label name as defined by [RFC 1123](https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-label-names).

    """


class CellDescription(RootModel):
    root: Annotated[str, Field(max_length=200)]
    """
    A description of the cell.

    """


class EgmServer(BaseModel):
    """
    The EGM server runs inside of the cell, thus its IP must be in the same network as the 'controller_ip'
    """

    ip: str
    port: int


class AbbController(BaseModel):
    """
    The configuration of a physical ABB robot controller has to contain IP address.
    Additionally an EGM server configuration has to be specified in order to control the robot.
    Deploying the server is a functionality of this API.

    """

    kind: Literal['AbbController'] = 'AbbController'
    controller_ip: str
    controller_port: int
    """
    Default values: 80, 443. If custom value is set, field is required.

    """
    egm_server: EgmServer
    """
    The EGM server runs inside of the cell, thus its IP must be in the same network as the 'controller_ip'
    """


class FanucController(BaseModel):
    """
    The configuration of a physical FANUC robot controller has to contain IP address of the controller.
    """

    kind: Literal['FanucController'] = 'FanucController'
    controller_ip: str


class RsiServer(BaseModel):
    """
    The RSI server runs inside of the cell.
    """

    ip: str
    port: int


class KukaController(BaseModel):
    """
    The configuration of a physical KUKA robot controller has to contain an IP address.
    Additionally an RSI server configuration has to be specified in order to control the robot.
    Deploying the server is a functionality of this API.

    """

    kind: Literal['KukaController'] = 'KukaController'
    controller_ip: str
    controller_port: int
    rsi_server: RsiServer
    """
    The RSI server runs inside of the cell.
    """
    slow_cycle_rate: bool | None = False
    """
    If true, uses slower cycle time of 12ms instead of 4ms.

    """


class UniversalrobotsController(BaseModel):
    """
    The configuration of a physical Universal Robots controller has to contain IP address of the controller.
    """

    kind: Literal['UniversalrobotsController'] = 'UniversalrobotsController'
    controller_ip: str


class Manufacturer(Enum):
    ABB = 'abb'
    FANUC = 'fanuc'
    KUKA = 'kuka'
    UNIVERSALROBOTS = 'universalrobots'
    YASKAWA = 'yaskawa'


class VirtualController(BaseModel):
    """
    The configuration of a virtual robot controller has to contain the manufacturer string,
    an optional joint position string array and either a preset `type` **or** the complete JSON configuration.

    """

    kind: Literal['VirtualController'] = 'VirtualController'
    manufacturer: Manufacturer
    type: Annotated[
        str | None,
        Field(
            examples=[
                'abb-irb1200_7',
                'abb-irb1010_037_15',
                'abb-irb2600ID_200_8',
                'fanuc-arc_mate_120iD12L',
                'fanuc-crx10ial',
                'fanuc-lr_mate_200iD4S',
                'fanuc-r2000ic125l',
                'kuka-kr10_r1100_2',
                'kuka-kr210_r2700_extra',
                'kuka-lbr_iisy_11_r1300',
                'universalrobots-ur10cb',
                'yaskawa-ar1440',
                'yaskawa-gp180-120',
                'yaskawa-hc20dtp',
            ]
        ),
    ] = None
    """
    Preset type of the virtual robot controller.
    See [getRobotConfigurations](getRobotConfigurations) for supported types.

    """
    json_: Annotated[str | None, Field(alias='json')] = None
    """
    Complete JSON configuration of the virtual robot controller.
    Can be obtained from the physical controller's configuration via [getVirtualControllerConfiguration](getVirtualControllerConfiguration).
    If provided, the `type` field should not be used.

    """
    initial_joint_position: str | None = None
    """
    Initial joint position of the first motion group from the virtual robot controller.
    Provides the joint position as a JSON array of float values in radians, where the array length
    must match the robot's degrees of freedom (DOF), e.g., `"[0, 0, 0, 0, 0, 0]"` for a 6-DOF robot.
    If the provided array length does not match the robot's DOF, the array will be adjusted: if it is longer, extra values will be truncated;
    if it is shorter, missing values will be filled with zeros.

    """


class YaskawaController(BaseModel):
    """
    The configuration of a physical Yaskawa robot controller has to contain IP address of the controller.
    """

    kind: Literal['YaskawaController'] = 'YaskawaController'
    controller_ip: str


class RobotController(BaseModel):
    """
    The configuration of a physical or virtual robot controller.
    """

    name: Annotated[str, Field(pattern='^[a-z][a-z0-9-]{0,61}[a-z0-9]$')]
    """
    Unique name of controller within the cell.
    It must be a valid k8s label name as defined by [RFC 1035](https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#rfc-1035-label-names).

    """
    configuration: Annotated[
        AbbController
        | FanucController
        | KukaController
        | UniversalrobotsController
        | VirtualController
        | YaskawaController,
        Field(discriminator='kind'),
    ]


class ImageCredentials(BaseModel):
    """
    User provided credentials for creating a secret to pull an image from a registry.

    """

    registry: str
    user: str
    password: str


class Secret(BaseModel):
    name: str


class ContainerImage(BaseModel):
    """
    A user provided, custom container image and the required credentials to pull it from a registry.

    """

    image: Annotated[str, Field(min_length=1)]
    """
    The location of a container image in the form of `<registry>/<image>:<tag>`.
    """
    credentials: ImageCredentials | None = None
    secrets: list[Secret] | None = None
    """
    Known secrets for authentication with the container registry.
    """


class ContainerEnvironmentItem(BaseModel):
    name: str
    value: str


class ContainerEnvironment(RootModel):
    """
    A list of environment variables with name and their value.
    These can be used to configure the containerized application, and turn features on or off.

    """

    root: list[ContainerEnvironmentItem]
    """
    A list of environment variables with name and their value.
    These can be used to configure the containerized application, and turn features on or off.

    """

    def __getitem__(self, index: int) -> ContainerEnvironmentItem:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: ContainerEnvironmentItem) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class Capacity(RootModel):
    root: Annotated[
        str,
        Field(
            examples=['100Mi'], pattern='^[0-9]+(\\\\.[0-9]+)?(Ki|Mi|Gi|Ti|Pi|Ei|B)?$'
        ),
    ]
    """
    The amount of requested storage capacity.
    """


class ContainerStorage(BaseModel):
    """
    The path and capacity of a volume that retains data across application restarts.
    The maximal requestable capacity is 300Mi.
    If you need more capacity consider using [storeObject](storeObject).

    """

    mount_path: Annotated[Path, Field(examples=['/data'])]
    capacity: Capacity
    """
    The amount of local storage available for the application.

    **NOTE:** The capacity can NEVER be reduced!

    """


class ContainerResources(BaseModel):
    """
    Additional resources that the application requires.
    """

    intel_gpu: Annotated[int | None, Field(ge=0, le=1)] = None
    """
    Number of GPUs the application requires.
    """
    memory_limit: Annotated[str | None, Field(examples=['1000Mi'])] = None
    """
    The maximum memory allocated to this application.
    """


class App(BaseModel):
    """
    An App is defined by a webserver, packed inside a container, serving a web-application.

    """

    name: Annotated[str, Field(min_length=1, pattern='^[a-z][a-z0-9-]{0,61}[a-z0-9]$')]
    """
    The name of the provided application.
    The name must be unique within the cell and is used as a identifier for addressing the application in all API calls
    , e.g., when updating the application.

    It also defines where the application is reachable (/$cell/$name).

    It must be a valid k8s label name as defined by [RFC 1035](https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#rfc-1035-label-names).

    """
    app_icon: Annotated[str, Field(min_length=1)]
    """
    The path of the icon for the App (/$cell/$name/$app_icon).
    """
    container_image: ContainerImage
    port: int | None = 8080
    """
    The port the containerized webserver is listening on.
    """
    environment: ContainerEnvironment | None = None
    storage: ContainerStorage | None = None
    resources: ContainerResources | None = None
    health_path: str | None = None
    """
    Defines the URL path suffix used to check the application's health status. The complete health check URL
    is constructed as `/$cell/$name/$health_path`. When the application is working as expected,
    the endpoint returns an HTTP 200 status code.

    If not specified, the system will default to using the application icon path suffix
    (the value of `app_icon`) as the health check endpoint, resulting in `/$cell/$name/$app_icon`.

    If the health check fails (no response or non-200 status code), the system will
    automatically restart the application container to restore service.

    """
    diagnosis_path: str | None = None
    """
    Defines the URL path suffix used to provide an endpoint for diagnosis data collection.
    The complete diagnosis check URL is constructed as `/$cell/$name/$diagnosis_path`.

    The endpoint is called when a diagnosis package is requested via the diagnosis API.
    The endpoint needs to return the data within a zip file `application/zip` response.

    """


class Cell(BaseModel):
    """
    To create a robot cell, only a valid name is required.
    Once created, a robot cell provides access to the Wandelbots NOVA foundation services.
    The configuration can be customized, e.g., robot controllers, also within apps.

    """

    name: Annotated[CellName, Field(default_factory=lambda: CellName('cell'))]
    description: CellDescription | None = None
    controllers: list[RobotController] | None = None
    apps: list[App] | None = None


class Error(BaseModel):
    code: str | None = None
    message: str


class OperatingState(Enum):
    """
    The operating state.
    """

    ACTIVE = 'ACTIVE'
    INACTIVE = 'INACTIVE'


class ServiceGroup(Enum):
    SYSTEM_SERVICE = 'SystemService'
    CELL_SERVICE = 'CellService'
    ROBOT_CONTROLLER = 'RobotController'
    APP = 'App'


class ServiceStatusSeverity(Enum):
    INFO = 'INFO'
    WARNING = 'WARNING'
    ERROR = 'ERROR'


class ServiceStatusPhase(Enum):
    TERMINATING = 'Terminating'
    INITIALIZED = 'Initialized'
    RUNNING = 'Running'
    NO_READY = 'NoReady'
    COMPLETED = 'Completed'
    CONTAINER_CREATING = 'ContainerCreating'
    POD_INITIALIZING = 'PodInitializing'
    UNKNOWN = 'Unknown'
    CRASH_LOOP_BACK_OFF = 'CrashLoopBackOff'
    ERROR = 'Error'
    IMAGE_PULL_BACK_OFF = 'ImagePullBackOff'
    OOM_KILLED = 'OOMKilled'
    PENDING = 'Pending'
    EVICTED = 'Evicted'


class Status(BaseModel):
    severity: ServiceStatusSeverity
    code: ServiceStatusPhase
    reason: str | None = None


class ServiceStatus(BaseModel):
    service: str
    group: ServiceGroup
    status: Status


class ServiceStatusList(RootModel):
    root: list[ServiceStatus]

    def __getitem__(self, index: int) -> ServiceStatus:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: ServiceStatus) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class ServiceStatusResponse(BaseModel):
    """
    Response containing both the overall operating state of the cell and detailed status information for each service within the cell.

    The operating state indicates whether the cell is active or inactive, while the service statuses provide specific health and operational
    information for individual service running in the cell.

    """

    operating_state: OperatingState
    service_status: ServiceStatusList


class BusIOProfinetIpConfig(BaseModel):
    """
    Network configuration or IPv4 record of the virtual ethernet interface (pnio1) created by the PROFINET driver.
    The IPv4 record is used in combination with the Name of Station (NoS) to identify your device in the PROFINET network.

    The `ip_config` will be used as IPv4 record if no REMA XML file is already present on your machine and no `rema_xml_content` is provided.

    """

    ip: Annotated[str, Field(examples=['192.168.1.100'])]
    """
    IP address for the device's virtual ethernet interface (pnio1).
    """
    netmask: Annotated[str, Field(examples=['255.255.255.0'])]
    """
    Network mask for the device's virtual ethernet interface (pnio1).
    """
    gateway: Annotated[str, Field(examples=['192.168.178.1'])]
    """
    Gateway for connections to other devices outside of the virtual ethernet interface's subnet.
    """


class BusIOProfinetNetwork(BaseModel):
    device_name: Annotated[str | None, Field(examples=['pnDevice'])] = None
    """
    Name of Station (NoS) of the PROFINET device. The NoS is used in combination with IPv4 record to identify your device in the PROFINET network.
    The `device_name` will be used as NoS if no REMA XML file is already present on your machine and no `rema_xml_content` is provided.

    """
    ip_config: BusIOProfinetIpConfig | None = None
    rema_xml_content: str | None = None
    """
    Content of the PROFINET REMA XML file.
    Is used when PROFINET service is added for the first time to create the REMA XML file that holds data to be kept for the next session.
    Stores information like IP address, Name of Station (NoS) and hardware configuration.
    If you use a PROFINET controller to assign an IP address to the PROFINET device, this information will be written to the REMA XML file.

    Refer to the PDF version of the "PN Driver I/O Base programming interface" documentation for more information and an example REMA file.

    """


class BusIOProfinetDefaultRoute(BaseModel):
    """
    Current default route configuration of your NOVA instance.
    The default route is a setting that tells data where to go if there isn’t a specific path already known for its destination.
    Usually this will be the path to your router, enabling accessing the internet.
    On Linux, use `ip route show` to view your default routes and match the output
    `default via <gateway> dev <interface> ...` to get your gateway and interface.

    """

    gateway: Annotated[str, Field(examples=['192.168.124.1'])]
    """
    Gateway for the default route.
    """
    interface: Annotated[str, Field(examples=['enp3s0'])]
    """
    Interface for the default route.
    """


class BusIOProfinet(BaseModel):
    """
    PROFINET BUS inputs/outputs service configuration.

    """

    bus_type: Literal['profinet'] = 'profinet'
    network_config: BusIOProfinetNetwork | None = None
    """
    Used to enable IP communication through the same physical ethernet interface while PROFINET driver is active.

    """
    plc_ip: Annotated[str, Field(examples=['192.168.1.100'])]
    """
    IP address of the PLC to establish PROFINET communication with.

    The IP address is used to configure the host machine's firewall. The firewall configuration is applied while the BUS input/output service is active.
    Without proper firewall configuration, PROFINET device discovery, configuration exchanges,
    and real-time cyclic data communication will fail.

    """
    mac: Annotated[str, Field(examples=['00:11:22:33:44:55'])]
    """
    MAC address of the physical ethernet interface that you want to use for PROFINET communication.

    """
    default_route: Annotated[
        BusIOProfinetDefaultRoute | None, Field(deprecated=True)
    ] = None


class BusIOProfinetVirtual(BaseModel):
    """
    Virtual PROFINET BUS inputs/outputs service configuration.

    """

    bus_type: Literal['profinet_virtual'] = 'profinet_virtual'


class BusIOModbusTCPServer(BaseModel):
    network_type: Literal['tcp'] | None = None
    port: Annotated[int, Field(examples=[502], ge=1, le=65534)]
    """
    Port number of the MODBUS server to establish communication with.

    """


class BusIOModbusServer(BaseModel):
    """
    MODBUS server inputs/outputs service configuration.

    """

    bus_type: Literal['modbus_server'] = 'modbus_server'
    network: BusIOModbusTCPServer
    connections: Annotated[int, Field(examples=[2], ge=0, le=255)]
    """
    Number of connections this MODBUS server can handle.

    """
    coils_size: Annotated[int, Field(examples=[10], ge=0, le=65535)]
    """
    Size of the Coils memory area.

    """
    discrete_inputs_size: Annotated[int, Field(examples=[10], ge=0, le=65535)]
    """
    Size of the Discrete Inputs memory area.

    """
    holding_registers_size: Annotated[int, Field(examples=[10], ge=0, le=65535)]
    """
    Size of the Holding Registers memory area.

    """
    input_registers_size: Annotated[int, Field(examples=[10], ge=0, le=65535)]
    """
    Size of the Input Registers memory area.

    """


class BusIOModbusTCPClient(BaseModel):
    network_type: Literal['tcp'] | None = None
    ip: Annotated[str, Field(examples=['192.168.1.100'])]
    """
    IP address of the MODBUS server to establish communication with.

    """
    port: Annotated[int, Field(examples=[502], ge=1, le=65534)]
    """
    Port number of the MODBUS server to establish communication with.

    """


class BusIOModbusClient(BaseModel):
    """
    MODBUS client inputs/outputs service configuration.

    """

    bus_type: Literal['modbus_client'] = 'modbus_client'
    network: BusIOModbusTCPClient


class BusIOModbusVirtual(BaseModel):
    """
    Virtual MODBUS inputs/outputs service configuration.

    """

    bus_type: Literal['modbus_virtual'] = 'modbus_virtual'


class BusIOType(RootModel):
    root: Annotated[
        BusIOProfinet
        | BusIOProfinetVirtual
        | BusIOModbusServer
        | BusIOModbusClient
        | BusIOModbusVirtual,
        Field(discriminator='bus_type'),
    ]


class ReleaseChannel(Enum):
    """
    The channel that defines what a new Wandelbots NOVA version is.

      * `next` the over all latest version
      * `stable` newes patch of the current version

    """

    STABLE = 'stable'
    NEXT = 'next'


class UpdateNovaVersionRequest(BaseModel):
    """
    An update is defined by the indicated Wandelbots NOVA release channel.

    """

    channel: ReleaseChannel


class ConnectionType(Enum):
    """
    Type of the active network link (e.g., ethernet, wifi, cellular, vpn, unknown).

    """

    ETHERNET = 'ethernet'
    WIFI = 'wifi'
    CELLULAR = 'cellular'
    VPN = 'vpn'
    UNKNOWN = 'unknown'


class NetworkState(BaseModel):
    internet_connected: bool
    """
    Indicates whether the system is connected to the internet.

    """
    connection_type: ConnectionType | None = None
    """
    Type of the active network link (e.g., ethernet, wifi, cellular, vpn, unknown).

    """
    signal_strength: int | None = None
    """
    Received signal strength in dBm for wireless interfaces; negative values indicate weaker signals.

    """
    link_quality: Annotated[float | None, Field(ge=0.0, le=1.0)] = None
    """
    Normalized link quality metric from 0 (poor) to 1 (excellent) when provided by the interface.

    """
    latency_ms: float | None = None
    """
    Round-trip latency to the probe endpoint measured in milliseconds.

    """
    bandwidth_mbps: float | None = None
    """
    Estimated downstream bandwidth in megabits per second based on the probe.

    """


class NetworkInterface(BaseModel):
    name: str
    """
    The name of the network interface.

    """
    ip: IPv4Address
    """
    The IPv4 address assigned to the network interface.

    """
    mac: str
    """
    The MAC address of the network interface.

    """
    cidr: str
    """
    The CIDR notation of the network interface.
    Example: "192.168.1.0/24"

    """


class NetworkInterfaces(RootModel):
    """
    Array of network interface configurations.
    """

    root: list[NetworkInterface]
    """
    Array of network interface configurations.
    """

    def __getitem__(self, index: int) -> NetworkInterface:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: NetworkInterface) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class NetworkDevice(BaseModel):
    ip: IPv4Address
    """
    The IPv4 address assigned to the network device.

    """
    mac: str
    """
    The MAC address of the network device.

    """
    vendor: str | None = None
    """
    The vendor of the network device.

    """


class ArpScanResponse(RootModel):
    """
    Array of network devices.
    """

    root: list[NetworkDevice]
    """
    Array of network devices.
    """

    def __getitem__(self, index: int) -> NetworkDevice:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: NetworkDevice) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class ConfigurationResourceId(RootModel):
    root: str
    """
    Identifier of a configuration resource.
    """


class Metadata(RootModel):
    """
    Additional metadata to add to the backup
    """

    root: dict[str, str]


class ConfigurationArchive(RootModel):
    root: bytes
    """
    Binary data representing a configuration archive.
    """


class ConfigurationArchiveStatusCreating(BaseModel):
    status: Literal['creating'] = 'creating'
    """
    Backup is in progress.
    """
    progress: Annotated[float, Field(ge=0.0, le=1.0)]
    """
    Current completion ratio (0 – 1).
    """


class ConfigurationArchiveStatusError(BaseModel):
    status: Literal['error'] = 'error'
    message: str
    """
    Human-readable explanation of the failure.
    """


class ConfigurationArchiveStatusSuccess(BaseModel):
    status: Literal['success'] = 'success'
    """
    Backup successfully created.
    """


class ConfigurationArchiveStatus(RootModel):
    root: Annotated[
        ConfigurationArchiveStatusCreating
        | ConfigurationArchiveStatusError
        | ConfigurationArchiveStatusSuccess,
        Field(discriminator='status'),
    ]
    """
    Result of a backup operation.
    """


class LicenseStatusEnum(Enum):
    OK = 'OK'
    EXPIRED = 'EXPIRED'
    SUSPENDED = 'SUSPENDED'
    GRACE_PERIOD_OVER = 'GRACE_PERIOD_OVER'
    NOT_FOUND = 'NOT_FOUND'


class LicenseStatus(BaseModel):
    """
    Status of the license.
    """

    status: LicenseStatusEnum
    message: str


class License(BaseModel):
    product_name: str
    """
    Name of the licensed product.
    """
    owner_email: EmailStr
    """
    Mail address of the license owner.
    """
    license_key: str
    """
    Identification key of the license.
    """
    license_expiry_date: date | None = None
    """
    Expiration date of the license.
    """
    grace_period_expiry_date: AwareDatetime
    """
    End date of grace period, given if instance is not connected to internet.
    """
    consumed_activations: int
    """
    Amount of times the license was activated.
    """
    allowed_activations: int
    """
    Amount of times the license can be activated.
    """
    feature_limitations: dict[str, int] | None = None
    """
    Feature limitations of the license.
    """
    feature_flags: list[str] | None = None
    """
    Features enabled by a license.
    """
    status: LicenseStatus


class ActivateLicenseRequest(BaseModel):
    """
    The authentication token to fetch the license from the license server.
    """

    owner_refresh_token: str


class Sphere(BaseModel):
    """
    Defines a spherical shape centred around the origin.
    """

    shape_type: Literal['sphere'] = 'sphere'
    radius: float
    """
    The radius of the sphere in [mm].
    """


class BoxType(Enum):
    """
    The box type defines if the box is hollow or full.
    """

    HOLLOW = 'HOLLOW'
    FULL = 'FULL'


class Box(BaseModel):
    """
    Defines a cuboid shape centred around an origin.

    If a margin is applied to the box type full, it is added to all size values. The shape will keep its edges.
    The hollow box type consists of thin boxes that make up its walls.
    If a margin is applied to the box type hollow, its size values are reduced by the margin.

    """

    shape_type: Literal['box'] = 'box'
    size_x: float
    """
    The dimension in x-direction in [mm].
    """
    size_y: float
    """
    The dimension in y-direction in [mm].
    """
    size_z: float
    """
    The dimension in z-direction in [mm].
    """
    box_type: BoxType
    """
    The box type defines if the box is hollow or full.
    """


class Rectangle(BaseModel):
    """
    Defines an x/y-plane with finite size. Centred around the z-axis.
    """

    shape_type: Literal['rectangle'] = 'rectangle'
    size_x: float
    """
    The dimension in x-direction in [mm].
    """
    size_y: float
    """
    The dimension in y-direction in [mm].
    """


class Plane(BaseModel):
    """
    Defines an x/y-plane with infinite size.
    """

    shape_type: Literal['plane'] = 'plane'


class Cylinder(BaseModel):
    """
    Defines a cylindrical shape.
    Centred around origin, symmetric around z-axis.

    If a margin is applied, it is added to radius and height. The shape will keep its edges.

    """

    shape_type: Literal['cylinder'] = 'cylinder'
    radius: float
    """
    The radius of the cylinder in [mm].
    """
    height: float
    """
    The height of the cylinder in [mm].
    """


class Capsule(BaseModel):
    """
    Defines a cylindrical shape with 2 semi-spheres on the top and bottom.
    Centred around origin, symmetric around z-axis.

    """

    shape_type: Literal['capsule'] = 'capsule'
    radius: float
    """
    The radius of the cylinder and semi-spheres in [mm].
    """
    cylinder_height: float
    """
    The height of the inner cylinder in [mm].
    """


class RectangularCapsule(BaseModel):
    """
    Convex hull around four spheres. Sphere center points in x/y-plane, offset by either combination "+/- sizeX" or "+/- sizeY".

    Alternative description: Rectangle in x/y-plane with a 3D padding.

    """

    shape_type: Literal['rectangular_capsule'] = 'rectangular_capsule'
    radius: float
    """
    The radius of the inner spheres in [mm].
    """
    sphere_center_distance_x: float
    """
    The distance of the sphere center in x-direction in [mm].
    """
    sphere_center_distance_y: float
    """
    The distance of the sphere center in y-direction in [mm].
    """


class Vector3d(RootModel):
    """
    A three-dimensional vector [x, y, z] with double precision.

    """

    root: Annotated[list[float], Field(max_length=3, min_length=3, title='Vector3d')]
    """
    A three-dimensional vector [x, y, z] with double precision.

    """

    def __getitem__(self, index: int) -> float:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: float) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class ConvexHull(BaseModel):
    """
    Defines a convex hull encapsulating a set of vertices.
    """

    shape_type: Literal['convex_hull'] = 'convex_hull'
    vertices: list[Vector3d]
    """
    The list of encapsulated points.
    """


class RotationVector(RootModel):
    """
    Defines a rotation in 3D space.
    A three-dimensional Vector [rx, ry, rz] with double precision.
    Rotation is applied around the vector.
    The angle of rotation equals the length of the vector.

    """

    root: Annotated[
        list[float], Field(max_length=3, min_length=3, title='RotationVector')
    ]
    """
    Defines a rotation in 3D space.
    A three-dimensional Vector [rx, ry, rz] with double precision.
    Rotation is applied around the vector.
    The angle of rotation equals the length of the vector.

    """

    def __getitem__(self, index: int) -> float:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: float) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class Pose(BaseModel):
    """
    Defines a pose in 3D space.
    A pose is a combination of a position and an orientation.
    The position is applied before the orientation.

    """

    position: Vector3d | None = None
    orientation: RotationVector | None = None


class Collider(BaseModel):
    """
    Defines a collider with a single shape.

    A collider is an object that is used for collision detection.
    It defines the `shape` that is attached with the offset of `pose` to a reference frame.

    Use colliders to:
    - Define the shape of a workpiece. The reference frame is the scene origin.
    - Define the shape of a link in a motion group. The reference frame is the link coordinate system.
    - Define the shape of a tool. The reference frame is the flange coordinate system.

    """

    shape: Annotated[
        Sphere
        | Box
        | Rectangle
        | Plane
        | Cylinder
        | Capsule
        | RectangularCapsule
        | ConvexHull,
        Field(discriminator='shape_type'),
    ]
    pose: Pose | None = None
    margin: float | None = 0
    """
    Increases the shape's size in all dimensions. Applied in [mm]. Can be used to keep a safe distance to the shape.
    """


class Link(RootModel):
    root: dict[str, Collider]


class LinkChain(RootModel):
    """
    A link chain is a kinematic chain of links that is connected via joints.
    A motion group can be used to control the motion of the joints in a link chain.

    A link is a group of colliders that is attached to the link reference frame.

    The reference frame of a link is obtained after applying all sets of Denavit-Hartenberg-parameters from base to (including) the link index.

    This means that the reference frame of the link is on the rotation axis of the next joint in the kinematic chain.
    Example: For a motion group with 2 joints, the collider reference frame (CRF) for link 1 is on the rotation axis of joint 2. The chain looks like:
    - Origin >> Mounting >> Base >> (CRF Base) Joint 0 >> Link 0 >> (CRF Link 0) Joint 1 >> Link 1 >> (CRF Link 1) Flange (CRF Tool) >> TCP

    Adjacent links in the kinematic chain of the motion group are not checked for mutual collision.

    """

    root: Annotated[
        list[Link],
        Field(
            examples=[
                [
                    {
                        'link_0_sphere': {
                            'shape': {'shape_type': 'sphere', 'radius': 10},
                            'pose': {'position': [0, 0, -10]},
                        },
                        'link_0_capsule': {
                            'shape': {
                                'shape_type': 'capsule',
                                'radius': 5,
                                'cylinder_height': 20,
                            }
                        },
                    },
                    {},
                    {
                        'link_2_capsule': {
                            'shape': {
                                'shape_type': 'capsule',
                                'radius': 5,
                                'cylinder_height': 20,
                            }
                        }
                    },
                ]
            ],
            title='Link Chain',
        ),
    ]
    """
    A link chain is a kinematic chain of links that is connected via joints.
    A motion group can be used to control the motion of the joints in a link chain.

    A link is a group of colliders that is attached to the link reference frame.

    The reference frame of a link is obtained after applying all sets of Denavit-Hartenberg-parameters from base to (including) the link index.

    This means that the reference frame of the link is on the rotation axis of the next joint in the kinematic chain.
    Example: For a motion group with 2 joints, the collider reference frame (CRF) for link 1 is on the rotation axis of joint 2. The chain looks like:
    - Origin >> Mounting >> Base >> (CRF Base) Joint 0 >> Link 0 >> (CRF Link 0) Joint 1 >> Link 1 >> (CRF Link 1) Flange (CRF Tool) >> TCP

    Adjacent links in the kinematic chain of the motion group are not checked for mutual collision.

    """

    def __getitem__(self, index: int) -> Link:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: Link) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class DHParameter(BaseModel):
    """
    A single set of DH parameters.
    """

    alpha: float | None = None
    """
    Angle about x-axis in [rad].
    """
    theta: float | None = None
    """
    Angle about z-axis in [rad].
    """
    a: float | None = None
    """
    Offset along x-axis in [mm].
    """
    d: float | None = None
    """
    Offset along z-axis in [mm].
    """
    reverse_rotation_direction: bool | None = None
    """
    True, if rotation direction of joint is reversed.
    """


class KinematicModel(BaseModel):
    """
    Kinematics model described by Denavit-Hartenberg parameters.
    """

    dh_parameters: list[DHParameter] | None = None
    inverse_solver: str | None = None
    """
    Optional name of the inverse kinematics solver.
    """


class ControllerDescription(BaseModel):
    """
    The data type to describe a robot controller.
    """

    connected_motion_groups: list[str]
    supports_freedrive: bool
    """
    Can this controller be moved through freedrive (true), or not (false).
    """
    supports_control: bool
    """
    Can this controller be controlled with NOVA (true) or is it only possible to read data (false).
    """
    supports_safety_zones: bool
    """
    True if NOVA supports reading safety zone-, tool- and link-geometries for this motion group.
    Safety zones are used to define areas where the robot should slow down or stop.
    If false, NOVA can't guarantee that the executed motions respect safety zones defined on the controller.

    """


class RobotSystemMode(Enum):
    """
    Defines the current system mode of the robot system, including NOVA communicating with the robot controller.

    ### MODE_CONTROLLER_NOT_CONFIGURED

    No controller with the specified identifier is configured. Call [addRobotController](addRobotController) to register a controller.

    ### MODE_INITIALIZING

    Indicates that a connection to the robot controller is established or reestablished in case of a disconnect.
    On success, the controller is set to MODE_MONITOR.
    On failure, the initialization process is retried until successful or cancelled by the user.

    ### MODE_MONITOR

    Read-only mode with an active controller connection.
    - Receives robot state and I/O signals
    - Move requests are rejected
    - No commands are sent to the controller

    ### MODE_CONTROL

    Active control mode.

    **Movement is possible in this mode**

    The robot is cyclically commanded to hold its current position.
    The robot state is received in sync with the controller cycle.
    Motion and jogging requests are accepted and executed.
    Input/Output interaction is enabled.

    ### MODE_FREE_DRIVE

    Read-only mode with servo motors enabled for manual movement (Free Drive).

    Move requests are rejected.

    Not supported by all robots: Use [getSupportedModes](getSupportedModes) to check Free Drive availability.

    """

    MODE_CONTROLLER_NOT_CONFIGURED = 'MODE_CONTROLLER_NOT_CONFIGURED'
    MODE_INITIALIZING = 'MODE_INITIALIZING'
    MODE_MONITOR = 'MODE_MONITOR'
    MODE_CONTROL = 'MODE_CONTROL'
    MODE_FREE_DRIVE = 'MODE_FREE_DRIVE'


class OperationMode(Enum):
    """
    Current operation mode of the configured robot controller.
    Operation modes in which the attached motion groups can be moved are:
    - OPERATION_MODE_MANUAL (if enabling switch is pressed)
    - OPERATION_MODE_MANUAL_T1 (if enabling switch is pressed)
    - OPERATION_MODE_MANUAL_T2 (if enabling switch is pressed)
    - OPERATION_MODE_AUTO (without needing to press enabling switch)
    All other modes are considered as non-operational.

    """

    OPERATION_MODE_UNKNOWN = 'OPERATION_MODE_UNKNOWN'
    OPERATION_MODE_NO_CONTROLLER = 'OPERATION_MODE_NO_CONTROLLER'
    OPERATION_MODE_DISCONNECTED = 'OPERATION_MODE_DISCONNECTED'
    OPERATION_MODE_POWER_ON = 'OPERATION_MODE_POWER_ON'
    OPERATION_MODE_PENDING = 'OPERATION_MODE_PENDING'
    OPERATION_MODE_MANUAL = 'OPERATION_MODE_MANUAL'
    OPERATION_MODE_MANUAL_T1 = 'OPERATION_MODE_MANUAL_T1'
    OPERATION_MODE_MANUAL_T2 = 'OPERATION_MODE_MANUAL_T2'
    OPERATION_MODE_AUTO = 'OPERATION_MODE_AUTO'
    OPERATION_MODE_RECOVERY = 'OPERATION_MODE_RECOVERY'


class SafetyStateType(Enum):
    """
    Current safety state of the configured robot controller.
    Operation modes in which the attached motion groups can be moved are:
    - SAFETY_STATE_NORMAL
    - SAFETY_STATE_REDUCED
    All other modes are considered as non-operational.

    """

    SAFETY_STATE_UNKNOWN = 'SAFETY_STATE_UNKNOWN'
    SAFETY_STATE_FAULT = 'SAFETY_STATE_FAULT'
    SAFETY_STATE_NORMAL = 'SAFETY_STATE_NORMAL'
    SAFETY_STATE_MASTERING = 'SAFETY_STATE_MASTERING'
    SAFETY_STATE_CONFIRM_SAFETY = 'SAFETY_STATE_CONFIRM_SAFETY'
    SAFETY_STATE_OPERATOR_SAFETY = 'SAFETY_STATE_OPERATOR_SAFETY'
    SAFETY_STATE_PROTECTIVE_STOP = 'SAFETY_STATE_PROTECTIVE_STOP'
    SAFETY_STATE_REDUCED = 'SAFETY_STATE_REDUCED'
    SAFETY_STATE_STOP = 'SAFETY_STATE_STOP'
    SAFETY_STATE_STOP_0 = 'SAFETY_STATE_STOP_0'
    SAFETY_STATE_STOP_1 = 'SAFETY_STATE_STOP_1'
    SAFETY_STATE_STOP_2 = 'SAFETY_STATE_STOP_2'
    SAFETY_STATE_RECOVERY = 'SAFETY_STATE_RECOVERY'
    SAFETY_STATE_DEVICE_EMERGENCY_STOP = 'SAFETY_STATE_DEVICE_EMERGENCY_STOP'
    SAFETY_STATE_ROBOT_EMERGENCY_STOP = 'SAFETY_STATE_ROBOT_EMERGENCY_STOP'
    SAFETY_STATE_VIOLATION = 'SAFETY_STATE_VIOLATION'


class Joints(RootModel):
    """
    This structure describes a set of joint values, e.g., positions, currents, torques, of a motion group.

    Float precision is the default.

    """

    root: list[float]
    """
    This structure describes a set of joint values, e.g., positions, currents, torques, of a motion group.

    Float precision is the default.

    """

    def __getitem__(self, index: int) -> float:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: float) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class MotionGroupStateJointLimitReached(BaseModel):
    """
    Indicates which joint of the motion group is in a limit.
    If a joint is in its limit, only this joint can be moved. Movements that affect any other joints are not executed.

    """

    limit_reached: list[bool]
    """
    If true, operational (soft) jointLimit is reached for specific joint.
    """


class JoggingRunning(BaseModel):
    """
    Jogging is active.

    """

    kind: Literal['RUNNING'] = 'RUNNING'


class JoggingPausedByUser(BaseModel):
    """
    User has paused jogging.

    """

    kind: Literal['PAUSED_BY_USER'] = 'PAUSED_BY_USER'


class JoggingPausedOnIO(BaseModel):
    """
    Jogging was paused because of an I/O event.

    """

    kind: Literal['PAUSED_ON_IO'] = 'PAUSED_ON_IO'


class JointIndice(RootModel):
    root: Annotated[int, Field(ge=0, le=2147483647)]


class JoggingPausedNearJointLimit(BaseModel):
    """
    Jogging was paused because a joint is near its limit.

    """

    kind: Literal['PAUSED_NEAR_JOINT_LIMIT'] = 'PAUSED_NEAR_JOINT_LIMIT'
    joint_indices: list[JointIndice]


class JoggingPausedNearCollision(BaseModel):
    """
    Jogging was paused because the motion group neared a collision.

    """

    kind: Literal['PAUSED_NEAR_COLLISION'] = 'PAUSED_NEAR_COLLISION'
    description: str


class JoggingDetails(BaseModel):
    """
    State of jogging execution.
    This state is sent during jogging movement, response-rate closest to the nearest multiple of controller step-rate but not exceeding the configured rate.
    The jogging state can be one of the following:
    - RUNNING: Jogging is active.
    - PAUSED_BY_USER: User has paused jogging.
    - PAUSED_NEAR_JOINT_LIMIT: Jogging was paused because a joint is is near its limit.
    - PAUSED_NEAR_COLLISION: Jogging was paused because the motion group neared a collision.
    - PAUSED_ON_IO: Jogging was paused because of an I/O event.

    """

    state: Annotated[
        JoggingRunning
        | JoggingPausedByUser
        | JoggingPausedOnIO
        | JoggingPausedNearJointLimit
        | JoggingPausedNearCollision,
        Field(discriminator='kind'),
    ]
    kind: Literal['JOGGING'] = 'JOGGING'


class Location(RootModel):
    root: float
    """
    - The location is a scalar value that defines a position along a path, typically ranging from 0 to `n`,
      where `n` denotes the number of motion commands
    - Each integer value of the location corresponds to a specific motion command,
      while non-integer values interpolate positions within the segments.
    - The location is calculated from the joint path

    """


class TrajectoryRunning(BaseModel):
    """
    Trajectory is being executed.

    """

    kind: Literal['RUNNING'] = 'RUNNING'
    time_to_end: Annotated[int, Field(ge=0, le=4294967295)]
    """
    Remaining time in milliseconds (ms) to reach the end of the motion.
    """


class TrajectoryPausedByUser(BaseModel):
    """
    User has paused execution.

    """

    kind: Literal['PAUSED_BY_USER'] = 'PAUSED_BY_USER'


class TrajectoryEnded(BaseModel):
    """
    First or last sample (depending on direction) of trajectory has been sent.

    """

    kind: Literal['END_OF_TRAJECTORY'] = 'END_OF_TRAJECTORY'


class TrajectoryWaitForIO(BaseModel):
    """
    Waiting for an I/O event to start execution.

    """

    kind: Literal['WAIT_FOR_IO'] = 'WAIT_FOR_IO'


class TrajectoryPausedOnIO(BaseModel):
    """
    Execution was paused because of an I/O event.

    """

    kind: Literal['PAUSED_ON_IO'] = 'PAUSED_ON_IO'


class TrajectoryDetails(BaseModel):
    """
    State of trajectory execution.
    This state is sent during trajectory movement, response-rate closest to the nearest multiple of controller step-rate but not exceeding the configured rate.
    The trajectory state can be one of the following:
    - RUNNING: Trajectory is being executed.
    - PAUSED_BY_USER: User has paused execution.
    - END_OF_TRAJECTORY: First or last sample (depending on direction) of trajectory has been sent.
    - WAIT_FOR_IO: Waiting for an I/O event to start execution.
    - PAUSED_ON_IO: Execution was paused because of an I/O event.

    """

    trajectory: str
    """
    Unique identifier of the trajectory being executed.

    """
    location: Location
    """
    Location of current joint position commmand on the trajectory being executed.

    """
    state: Annotated[
        TrajectoryRunning
        | TrajectoryPausedByUser
        | TrajectoryEnded
        | TrajectoryWaitForIO
        | TrajectoryPausedOnIO,
        Field(discriminator='kind'),
    ]
    kind: Literal['TRAJECTORY'] = 'TRAJECTORY'
    """
    Discriminator for OpenApi generators, which is always "TRAJECTORY" for this schema.

    """


class Execute(BaseModel):
    """
    Details about the state of the motion execution.
    The details are either for a jogging or a trajectory.
    If NOVA is not controlling this motion group at the moment, this field is omitted.

    """

    joint_position: list[float]
    """
    Commanded joint position of each joint in [rad]. This command was sent in the time step the corresponding state was received.

    """
    details: Annotated[
        JoggingDetails | TrajectoryDetails | None, Field(discriminator='kind')
    ] = None


class MotionGroupState(BaseModel):
    """
    Presents the current state of the motion group.
    """

    timestamp: AwareDatetime
    """
    Timestamp for when data was received from the robot controller.
    """
    sequence_number: Annotated[int, Field(ge=0, le=4294967295)]
    """
    Sequence number of the controller state. It starts with 0 upon establishing the connection with a physical controller.
    The sequence number is reset when the connection to the physical controller is closed and re-established.

    """
    motion_group: str
    """
    Identifier of the motion group.
    """
    controller: str
    """
    Convenience: Identifier of the robot controller the motion group is attached to.
    """
    joint_position: Joints
    """
    Current joint position of each joint in [rad]

    """
    joint_limit_reached: MotionGroupStateJointLimitReached
    """
    Indicates whether the joint is in a limit for all joints of the motion group.

    """
    joint_torque: Joints | None = None
    """
    Current joint torque of each joint in [Nm].
    Is only available if the robot controller supports it, e.g., available for UR controllers.

    """
    joint_current: Joints | None = None
    """
    Current at TCP in [A].
    Is only available if the robot controller supports it, e.g., available for UR controllers.

    """
    flange_pose: Pose | None = None
    """
    Pose of the flange.
    Positions are in [mm].
    Oriantations are in [rad].
    The pose is relative to the response_coordinate_system specified in the request.
    For robot arms a flange pose is always returned, for positioners the flange might not be available, depending on the model.

    """
    tcp: str | None = None
    """
    Unique identifier addressing the active TCP.
    Might not be returned for positioners as some do not support TCPs, depending on the model.

    """
    tcp_pose: Pose | None = None
    """
    Pose of the TCP selected on the robot control panel.
    Positions are in [mm].
    Oriantations are in [rad].
    The pose is relative to the response_coordinate_system specified in the request.
    Might not be returned for positioners as some do not support TCPs, depending on the model.

    """
    coordinate_system: str | None = None
    """
    Unique identifier addressing the reference coordinate system of the cartesian data.
    Might not be returned for positioners as some do not support TCPs, depending on the model.
    Default: world coordinate system of corresponding controller.

    """
    payload: str | None = None
    """
    Unique identifier addressing the active payload.
    Only fetchable via GET endpoint, not available in WebSocket.

    """
    standstill: bool
    """
    Indicates whether the motion group is in standstill.
    Convenience: Signals that NOVA treats measured joint velocities as 0.

    """
    execute: Execute | None = None
    """
    Data that was commanded to the motion group. Includes additional data on NOVA's execution components for executing trajectories and jogging.
    This is a convenience field to indicate the last command sent to the motion group.
    It is not available in all cases, e.g., if the motion group is not moved by NOVA.

    """


class RobotControllerState(BaseModel):
    """
    Returns the whole current state of robot controller.
    """

    mode: RobotSystemMode
    """
    Mode of communication and control between NOVA and the robot controller.
    """
    last_error: list[str] | None = None
    """
    Last error stack encountered during initialization process or after a controller disconnect.
    At this stage, it's unclear whether the error is fatal.

    Evaluate `last_error` to decide whether to remove the controller using `deleteController`.
    Examples:
    - Delete required: Host resolution fails repeatedly due to an incorrect IP.
    - Delete not required: Temporary network delay caused a disconnect; the system will auto-reconnect.

    """
    timestamp: AwareDatetime
    """
    Timestamp indicating when the represented information was received from the robot controller.
    """
    sequence_number: Annotated[int, Field(ge=0, le=4294967295)]
    """
    Sequence number of the controller state. It starts with 0 upon establishing the connection with a physical controller.
    The sequence number is reset when the connection to the physical controller is closed and re-established.

    """
    controller: str
    """
    Identifier of the configured robot controller.
    """
    operation_mode: OperationMode
    safety_state: SafetyStateType
    velocity_override: Annotated[int | None, Field(ge=1, le=100)] = None
    """
    If made available by the robot controller, returns the current velocity override in
    [percentage] for movements adjusted on robot control panel.
    Valid value range: 1 - 100.

    """
    motion_groups: Annotated[list[MotionGroupState], Field(title='MotionGroupState[]')]
    """
    State of indicated motion groups.
    In case of state request via controller all configured motion groups are returned.
    In case of executing a motion only the affected motion groups are returned.

    """


class IODirection(Enum):
    """
    Identifies the input/output type.
    """

    IO_TYPE_INPUT = 'IO_TYPE_INPUT'
    IO_TYPE_OUTPUT = 'IO_TYPE_OUTPUT'


class IOValueType(Enum):
    """
    Data type of the input/output.
    """

    IO_VALUE_BOOLEAN = 'IO_VALUE_BOOLEAN'
    IO_VALUE_ANALOG_FLOAT = 'IO_VALUE_ANALOG_FLOAT'
    IO_VALUE_ANALOG_INTEGER = 'IO_VALUE_ANALOG_INTEGER'


class UnitType(Enum):
    """
    The unit of input/output value.
    """

    UNIT_NONE = 'UNIT_NONE'
    UNIT_KILOGRAM = 'UNIT_KILOGRAM'
    UNIT_AMPERE = 'UNIT_AMPERE'
    UNIT_KELVIN = 'UNIT_KELVIN'
    UNIT_HERTZ = 'UNIT_HERTZ'
    UNIT_NEWTON = 'UNIT_NEWTON'
    UNIT_VOLT = 'UNIT_VOLT'
    UNIT_CELSIUS = 'UNIT_CELSIUS'
    UNIT_NEWTON_METER = 'UNIT_NEWTON_METER'
    UNIT_METER = 'UNIT_METER'


class BooleanValue(BaseModel):
    """
    Value of a digital input/output.

    """

    value: bool
    value_type: Literal['boolean'] = 'boolean'


class IntegerValue(BaseModel):
    """
    Value of an input/output with integer representation.

    > The integral value is transmitted as a string to avoid precision loss during conversion to JSON.
    > Recommended: Use int64 in your implementation. If you want to interact with int64 in numbers,
    > JS bigint libraries can help you to parse the string into an integral value.

    """

    value: str
    value_type: Literal['integer'] = 'integer'


class FloatValue(BaseModel):
    value: float
    """
    Value of an analog input/output in floating number representation.

    """
    value_type: Literal['float'] = 'float'


class IOBoundary(RootModel):
    root: Annotated[
        BooleanValue | IntegerValue | FloatValue,
        Field(discriminator='value_type', title='IOBoundary'),
    ]


class IODescription(BaseModel):
    io: str
    """
    Unique identifier of the input/output.

    """
    name: str
    """
    Name of the input/output. Customize it on the physical controller or in the virtual robot specification.

    """
    group: str | None = None
    """
    Name of the input/output group. Customize it on the physical controller or in the virtual robot specification.

    """
    direction: IODirection
    value_type: IOValueType
    unit: UnitType | None = None
    min: IOBoundary | None = None
    max: IOBoundary | None = None


class ListIODescriptionsResponse(RootModel):
    root: list[IODescription]

    def __getitem__(self, index: int) -> IODescription:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: IODescription) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class IOBooleanValue(BaseModel):
    """
    Input/Output boolean value representation.
    """

    io: str
    """
    Unique identifier of the input/output.
    """
    value: bool
    """
    Value of a digital input/output.

    """
    value_type: Literal['boolean'] = 'boolean'


class IOIntegerValue(BaseModel):
    io: str
    """
    Unique identifier of the input/output.
    """
    value: str
    """
    Value of an input/output with integer representation.

    > The integral value is transmitted as a string to avoid precision loss during conversion to JSON.
    > Recommended: Use int64 in your implementation. If you want to interact with int64 in numbers,
    > JS bigint libraries can help you to parse the string into an integral value.

    """
    value_type: Literal['integer'] = 'integer'


class IOFloatValue(BaseModel):
    io: str
    """
    Unique identifier of the input/output.
    """
    value: float
    """
    Value of an analog input/output in floating number representation.

    """
    value_type: Literal['float'] = 'float'


class IOValue(RootModel):
    root: Annotated[
        IOBooleanValue | IOIntegerValue | IOFloatValue,
        Field(discriminator='value_type'),
    ]


class StreamIOValuesResponse(BaseModel):
    """
    Array of input/output values.
    """

    io_values: list[IOValue]
    timestamp: AwareDatetime
    """
    Timestamp indicating when the represented information was received from the robot controller.
    """
    sequence_number: Annotated[int, Field(ge=0, le=4294967295)]
    """
    Sequence number of the controller state. It starts with 0 upon establishing the connection with a physical controller.
    The sequence number is reset when the connection to the physical controller is closed and re-established.

    """


class ListIOValuesResponse(RootModel):
    """
    Array of input/output values.
    """

    root: Annotated[
        list[IOValue],
        Field(
            examples=[
                {
                    'io_values': [
                        {'io': 'io1', 'value': True, 'value_type': 'boolean'},
                        {'io': 'io2', 'value': '42', 'value_type': 'integer'},
                        {'io': 'io3', 'value': 3.14, 'value_type': 'float'},
                    ]
                }
            ]
        ),
    ]
    """
    Array of input/output values.
    """

    def __getitem__(self, index: int) -> IOValue:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: IOValue) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class Comparator(Enum):
    """
    Comparator for the comparison of two values.
    The comparator is used to compare two values and return a boolean result.
    The default comparator is unknown.

    """

    COMPARATOR_EQUALS = 'COMPARATOR_EQUALS'
    COMPARATOR_NOT_EQUALS = 'COMPARATOR_NOT_EQUALS'
    COMPARATOR_GREATER = 'COMPARATOR_GREATER'
    COMPARATOR_GREATER_EQUAL = 'COMPARATOR_GREATER_EQUAL'
    COMPARATOR_LESS = 'COMPARATOR_LESS'
    COMPARATOR_LESS_EQUAL = 'COMPARATOR_LESS_EQUAL'


class WaitForIOEventRequest(BaseModel):
    """
    The value to compare with the current value of the input/output.
    """

    io: IOValue
    comparator: Comparator
    """
    Comparator for the comparison of two values.
    Use the measured I/O as the base value (a) and the expected input/output value as the comparator (b): e.g., a > b.

    """


class SettableRobotSystemMode(Enum):
    """
    Defines available system modes of the robot system.
    Short versions (no "ROBOT_SYSTEM_" prefix) are provided, reusing strings from [getMode](getMode) responses.

    """

    ROBOT_SYSTEM_MODE_MONITOR = 'ROBOT_SYSTEM_MODE_MONITOR'
    MODE_MONITOR = 'MODE_MONITOR'
    ROBOT_SYSTEM_MODE_CONTROL = 'ROBOT_SYSTEM_MODE_CONTROL'
    MODE_CONTROL = 'MODE_CONTROL'


class VirtualRobotConfiguration(BaseModel):
    name: str
    """
    Name of the configuration file generated by the unique identifier of the controller and a time stamp.

    """
    content: str
    """
    Content of the configuration file. Copy & paste to the [addRobotController](addRobotController) configuration.json parameter.

    """


class OrientationType(Enum):
    """
    The type of rotation description that is used to specify the orientation.

    **Rotation Vector notation**

    * The rotation is represented using an axis-angle representation:
    > axis = Vector[0:2]
    > angle = |axis| in [rad]
    > axis.normalized * angle

    **Quaternion notation**

    * The rotation is represented using a unit quaternion: [x, y, z, w].
    * The vector part [x, y, z] is the imaginary part of the quaternion, and the scalar part [w] is the real part.

    **Euler notation**

    * *extrinsic* fixed external reference system
    * *intrinsic* reference system fixed to rotation body
    > angles = Vector[0:2] in [rad].
    * ZYX, ZXZ,...
      - mapping of the given angles values to the (either intrinsic
        or extrinsic) axes in the stated order.
     > Example ZYX: Z = Vector[0], Y = Vector[1], X = Vector[2].

    """

    ROTATION_VECTOR = 'ROTATION_VECTOR'
    QUATERNION = 'QUATERNION'
    EULER_ANGLES_INTRINSIC_ZXZ = 'EULER_ANGLES_INTRINSIC_ZXZ'
    EULER_ANGLES_INTRINSIC_XYX = 'EULER_ANGLES_INTRINSIC_XYX'
    EULER_ANGLES_INTRINSIC_YZY = 'EULER_ANGLES_INTRINSIC_YZY'
    EULER_ANGLES_INTRINSIC_ZYZ = 'EULER_ANGLES_INTRINSIC_ZYZ'
    EULER_ANGLES_INTRINSIC_XZX = 'EULER_ANGLES_INTRINSIC_XZX'
    EULER_ANGLES_INTRINSIC_YXY = 'EULER_ANGLES_INTRINSIC_YXY'
    EULER_ANGLES_INTRINSIC_XYZ = 'EULER_ANGLES_INTRINSIC_XYZ'
    EULER_ANGLES_INTRINSIC_YZX = 'EULER_ANGLES_INTRINSIC_YZX'
    EULER_ANGLES_INTRINSIC_ZXY = 'EULER_ANGLES_INTRINSIC_ZXY'
    EULER_ANGLES_INTRINSIC_XZY = 'EULER_ANGLES_INTRINSIC_XZY'
    EULER_ANGLES_INTRINSIC_ZYX = 'EULER_ANGLES_INTRINSIC_ZYX'
    EULER_ANGLES_INTRINSIC_YXZ = 'EULER_ANGLES_INTRINSIC_YXZ'
    EULER_ANGLES_EXTRINSIC_ZXZ = 'EULER_ANGLES_EXTRINSIC_ZXZ'
    EULER_ANGLES_EXTRINSIC_XYX = 'EULER_ANGLES_EXTRINSIC_XYX'
    EULER_ANGLES_EXTRINSIC_YZY = 'EULER_ANGLES_EXTRINSIC_YZY'
    EULER_ANGLES_EXTRINSIC_ZYZ = 'EULER_ANGLES_EXTRINSIC_ZYZ'
    EULER_ANGLES_EXTRINSIC_XZX = 'EULER_ANGLES_EXTRINSIC_XZX'
    EULER_ANGLES_EXTRINSIC_YXY = 'EULER_ANGLES_EXTRINSIC_YXY'
    EULER_ANGLES_EXTRINSIC_ZYX = 'EULER_ANGLES_EXTRINSIC_ZYX'
    EULER_ANGLES_EXTRINSIC_XZY = 'EULER_ANGLES_EXTRINSIC_XZY'
    EULER_ANGLES_EXTRINSIC_YXZ = 'EULER_ANGLES_EXTRINSIC_YXZ'
    EULER_ANGLES_EXTRINSIC_YZX = 'EULER_ANGLES_EXTRINSIC_YZX'
    EULER_ANGLES_EXTRINSIC_XYZ = 'EULER_ANGLES_EXTRINSIC_XYZ'
    EULER_ANGLES_EXTRINSIC_ZXY = 'EULER_ANGLES_EXTRINSIC_ZXY'


class Orientation(RootModel):
    """
    Describes an orientation in 3D space.
    A tree-to-four-dimensional vector [x, y, z, w] with double precision.

    """

    root: Annotated[list[float], Field(max_length=4, min_length=3, title='Orientation')]
    """
    Describes an orientation in 3D space.
    A tree-to-four-dimensional vector [x, y, z, w] with double precision.

    """

    def __getitem__(self, index: int) -> float:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: float) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class CoordinateSystemData(BaseModel):
    name: str | None = None
    """
    Human readable name of this coordinate system.
    """
    reference_coordinate_system: str | None = None
    """
    The identifier of the reference coordinate system. Empty if world is used.
    """
    position: Vector3d | None = None
    orientation: Orientation | None = None
    orientation_type: OrientationType | None = 'ROTATION_VECTOR'


class CoordinateSystem(CoordinateSystemData):
    coordinate_system: str
    """
    Unique identifier of the coordinate system.
    """


class ListCoordinateSystemsResponse(RootModel):
    root: list[CoordinateSystem]

    def __getitem__(self, index: int) -> CoordinateSystem:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: CoordinateSystem) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class MotionGroupModel(RootModel):
    root: Annotated[str, Field(title='MotionGroupModel')]
    """
    String identifiying the model of a motion group.
    """


class TcpOffset(BaseModel):
    name: str
    """
    A readable and changeable name for frontend visualization.
    """
    pose: Pose


class ColliderDictionary(RootModel):
    """
    A collection of identifiable colliders.
    """

    root: dict[str, Collider]


class LimitRange(BaseModel):
    """
    The upper_limit must be greater then the lower_limit.
    """

    lower_limit: float | None = None
    upper_limit: float | None = None


class JointLimits(BaseModel):
    position: LimitRange | None = None
    velocity: float | None = None
    acceleration: float | None = None
    torque: float | None = None


class CartesianLimits(BaseModel):
    velocity: float | None = None
    acceleration: float | None = None
    orientation_velocity: float | None = None
    orientation_acceleration: float | None = None


class LimitSet(BaseModel):
    joints: list[JointLimits] | None = None
    tcp: CartesianLimits | None = None
    elbow: CartesianLimits | None = None
    flange: CartesianLimits | None = None
    coupled_shoulder_elbow_joint: JointLimits | None = None


class OperationLimits(BaseModel):
    auto_limits: LimitSet | None = None
    manual_limits: LimitSet | None = None
    manual_t1_limits: LimitSet | None = None
    manual_t2_limits: LimitSet | None = None


class Payload(BaseModel):
    name: str
    payload: float
    """
    Mass of payload in [kg].
    """
    center_of_mass: Vector3d | None = None
    moment_of_inertia: Vector3d | None = None


class MotionGroupDescription(BaseModel):
    """
    The configuration of a motion-group used for motion planning.
    """

    motion_group_model: MotionGroupModel
    mounting: Pose | None = None
    """
    The offset from the world frame to the motion group base.
    """
    tcps: Annotated[dict[str, TcpOffset] | None, Field(title='TcpOffsetDictionary')] = (
        None
    )
    """
    Maps a TCP name to its offset relative to the flange coordinate system. Key must be a TCP identifier.
    Values are TcpOffsets.

    """
    safety_zones: ColliderDictionary | None = None
    """
    SafetyZones are areas which cannot be entered or where certain limits apply.
    """
    safety_link_colliders: list[ColliderDictionary] | None = None
    """
    The shape of the MotionGroups links to validate against safety zones.
    Indexed along the kinematic chain, starting with a static base shape before first joint.

    """
    safety_tool_colliders: Annotated[
        dict[str, ColliderDictionary] | None, Field(title='SafetyToolColliders')
    ] = None
    """
    Maps a TCP name to its tool collider. Key must be a TCP identifier.
    Values are ColliderDictionaries that make up the shape of one tool to validate against safety zones.

    """
    operation_limits: OperationLimits
    payloads: Annotated[dict[str, Payload] | None, Field(title='PayloadDictionary')] = (
        None
    )
    """
    Maps a payload name to its configuration. Key must be a payload identifier.
    Values are payload objects.

    """
    cycle_time: Annotated[int | None, Field(ge=0, le=2147483647)] = None
    """
    [ms] cycle time of the motion group controller. A trajectory for this motion group should be computed to this resolution.
    """
    dh_parameters: list[DHParameter] | None = None
    """
    The DH parameters describing the motion group geometry, starting from base.
    """
    serial_number: str | None = None
    """
    The serial number of the motion group, if available. If not available, the serial number of the robot controller. If not available, empty.

    """


class Tool(RootModel):
    """
    Defines the shape of a tool.

    A tool is a dictionary of colliders.

    All colliders that make up a tool are attached to the flange frame of the motion group.

    """

    root: dict[str, Collider]


class CollisionSetup(BaseModel):
    colliders: ColliderDictionary | None = None
    """
    Colliders are checked against links and tool.

    """
    link_chain: LinkChain | None = None
    """
    The shape of the motion groups links to validate against colliders.
    Indexed along the kinematic chain, starting with a static base shape before first joint.
    The base of the motion group is not checked for collision against the environment.

    """
    tool: Tool | None = None
    """
    Shape of the tool to validate against colliders.

    """
    self_collision_detection: bool | None = True
    """
    If true, self-collision detection is enabled for the motion group.

    Self-collision detection checks if links in the kinematic chain of the motion group collide with each other.
    Adjacent links in the kinematic chain of the motion group are not checked for mutual collision.
    The tool is treated like a link at the end of the kinematic chain. It is checked against all links except the last one.

    Default is true.

    """


class CollisionSetups(RootModel):
    """
    Collision layers to be respected by the motion planner when planning for a single motion group.
    Each setup represents one layer, e.g., the safety zones and shapes or a fine grained tool and workpiece model.
    Layers are checked individually along the trajectory and independently of other layers.

    To respect the safety zones of the controller and check for collision:
    1. Fetch the safety zones, link and tool shapes from the controller.
    2. Add the fetched zones, links and tools to a layer.
    3. Create other layers from your own 3D data as needed.
    4. Plan trajectory.
    5. The response highlights the layer in which a collision was detected by key.

    """

    root: dict[str, CollisionSetup]


class MotionGroupSetup(BaseModel):
    motion_group_model: MotionGroupModel
    cycle_time: Annotated[int, Field(ge=0, le=2147483647)]
    """
    [ms] cycle time of the motion group controller. A trajectory for this motion group should be computed to this resolution.
    """
    mounting: Pose | None = None
    """
    The offset from the world frame to the motion group base.
    """
    tcp_offset: Pose | None = None
    global_limits: LimitSet | None = None
    payload: Payload | None = None
    collision_setups: CollisionSetups | None = None


class DoubleArray(RootModel):
    root: list[float]

    def __getitem__(self, index: int) -> float:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: float) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class BlendingAuto(BaseModel):
    min_velocity_in_percent: Annotated[int | None, Field(ge=0, le=100)] = None
    """
    Auto-blending is used to keep a constant velocity when blending between two motion commands. To use auto-blending, the TCP velocity limit must be set.
    It changes the TCP path around the target point of the motion command.
    The value represents the percentage of the original velocity. Auto-blending is always performed in cartesian space.

    """
    blending_name: Literal['BlendingAuto'] = 'BlendingAuto'


class BlendingSpace(Enum):
    """
    Defines the space in which blending is performed.
    - `JOINT`: Zone blending is performed in joint space
    - `CARTESIAN`: Auto-blending is performed in cartesian space

    """

    JOINT = 'JOINT'
    CARTESIAN = 'CARTESIAN'


class BlendingPosition(BaseModel):
    position_zone_radius: float | None = None
    """
    Specifies the maximum radius in [mm] around the motion command's target point
    where the TCP path can be altered to blend the motion command into the following one.
    If auto-blending blends too much of the resulting trajectory, use position-blending to restrict the blending zone radius.

    """
    position_zone_percentage: Annotated[float | None, Field(ge=0.0, le=100.0)] = None
    """
    Specifies the maximum blending percentage based on the trajectory length in position space
    around the motion command's target point. Percentage indicated in 0.0 - 100.0.

    """
    orientation_zone_radius: float | None = None
    """
    Specifies the maximum radius in [rad] for orientation blending around the motion command's
    target orientation. At the target's orientation, the TCP orientation can be altered to blend into the following motion.

    """
    orientation_zone_percentage: Annotated[float | None, Field(ge=0.0, le=100.0)] = None
    """
    Specifies the maximum blending percentage for orientation blending
    based on the trajectory length in orientation space. Percentage indicated in 0.0 - 100.0.

    """
    joints_zone_radius: float | None = None
    """
    Specifies the maximum radius in [rad] for joint space blending around the motion command's
    target joint configuration. At the target joint configuration, the joint path can be altered to blend into the following motion.

    """
    joints_zone_percentage: Annotated[float | None, Field(ge=0.0, le=100.0)] = None
    """
    Specifies the maximum blending percentage for joint space blending
    based on the trajectory length in joint space. Percentage indicated in 0.0 to 100.0.

    """
    space: BlendingSpace | None = None
    """
    Defines the space in which blending is performed.

    """
    blending_name: Literal['BlendingPosition'] = 'BlendingPosition'


class LimitsOverride(BaseModel):
    """
    If a limit is not set, the default value will be used.

    """

    joint_velocity_limits: list[float] | None = None
    """
    Maximum joint velocity in [rad/s] for each joint.
    Either leave this field empty or set a value for each joint.

    """
    joint_acceleration_limits: list[float] | None = None
    """
    Maximum joint acceleration in [rad/s^2] for each joint.
    Either leave this field empty or set a value for each joint.

    """
    tcp_velocity_limit: float | None = None
    """
    Maximum allowed TCP velocity in [mm/s].

    """
    tcp_acceleration_limit: float | None = None
    """
    Maximum allowed TCP acceleration in [mm/s^2].

    """
    tcp_orientation_velocity_limit: float | None = None
    """
    Maximum allowed TCP rotation velocity in [rad/s].

    """
    tcp_orientation_acceleration_limit: float | None = None
    """
    Maximum allowed TCP rotation acceleration in [rad/s^2].

    """


class PathCartesianPTP(BaseModel):
    """
    A cartesian point-to-point is representing a joint point-to-point motion from start point to the indicated target pose.
    The target pose is a joint point-to-point given in cartesian space. The target joint configuration will be calculated
    to be in the same kinematic configuration as the start point is. If that is not possible, planning will fail.

    """

    target_pose: Pose
    path_definition_name: Literal['PathCartesianPTP'] = 'PathCartesianPTP'


class CubicSplineParameter(BaseModel):
    pose: Pose
    path_parameter: float


class PathCubicSpline(BaseModel):
    """
    A [cubic spline](https://de.wikipedia.org/wiki/Spline-Interpolation) represents a cartesian cubic spline
    in translative and orientational space from start point to indicated target pose via control points.

    """

    parameters: list[CubicSplineParameter]
    path_definition_name: Literal['PathCubicSpline'] = 'PathCubicSpline'


class PathLine(BaseModel):
    """
    A line represents a straight line from start position to indicated target position.
    The orientation is calculated via a quaternion [slerp](https://en.wikipedia.org/wiki/Slerp) from start orientation to indicated target orientation.

    """

    target_pose: Pose
    path_definition_name: Literal['PathLine'] = 'PathLine'


class PathCircle(BaseModel):
    """
    A circular constructs a circle in translative space from 1) the start position which is provided via position, and 2) the indicated target position.
    The orientation is calculated via a [bezier spline](https://en.wikipedia.org/wiki/B%C3%A9zier_curve) from start orientation to the indicated target orientation.
    The via point defines the control point for the bezier spline.
    Therefore, the control point will not be hit directly.

    """

    via_pose: Pose
    target_pose: Pose
    path_definition_name: Literal['PathCircle'] = 'PathCircle'


class PathJointPTP(BaseModel):
    """
    A joint point-to-point represents a line in joint space. All joints will be moved synchronously.

    """

    target_joint_position: DoubleArray
    path_definition_name: Literal['PathJointPTP'] = 'PathJointPTP'


class MotionCommand(BaseModel):
    blending: Annotated[
        BlendingAuto | BlendingPosition | None, Field(discriminator='blending_name')
    ] = None
    """
    Blending alters the TCP path at the target point of a motion command
    to ensure that the velocity does not drop to zero between two motion commands.

    """
    limits_override: LimitsOverride | None = None
    """
    Limits override is used to override the global limits of the motion group for this segment of the motion.

    """
    path: Annotated[
        PathCartesianPTP | PathCubicSpline | PathLine | PathCircle | PathJointPTP,
        Field(discriminator='path_definition_name'),
    ]


class PlanTrajectoryRequest(BaseModel):
    motion_group_setup: MotionGroupSetup
    """
    The data to assemble the robot setup can be retrieved from [getMotionGroupDescription](getMotionGroupDescription) endpoint.
    """
    start_joint_position: DoubleArray
    """
    To define a motion the start joints have to be indicated.
    Cartesian movements will be in the same kinematic configuration as the start joint position until the first joint point-to-point motion.
    Motions can only be executed if the start joint position is the current joint position of the motion group.
    To retrieve the current joint position use the endpoint [getCurrentMotionGroupState](getCurrentMotionGroupState).
    To move the robot to the start joint position use the endpoint [streamMoveToTrajectoryViaJointP2P](streamMoveToTrajectoryViaJointP2P).

    """
    motion_commands: list[MotionCommand]
    """
    List of motion commands. A command consists of a path definition (line, circle, joint_ptp, cartesian_ptp, cubic_spline), blending, and limits override.

    """


class JointTrajectory(BaseModel):
    joint_positions: list[Joints]
    """
    List of joint positions [rad] for each sample.
    The number of samples must match the number of timestamps provided in the times field.

    """
    times: list[float]
    """
    Timestamp for each sample [s].
    """
    locations: list[Location]


class FeedbackOutOfWorkspace(BaseModel):
    """
    Requested TCP pose is outside of motion group's workspace.
    """

    invalid_tcp_pose: Pose | None = None
    error_feedback_name: Literal['FeedbackOutOfWorkspace'] = 'FeedbackOutOfWorkspace'


class SingularityTypeEnum(Enum):
    WRIST = 'WRIST'
    ELBOW = 'ELBOW'
    SHOULDER = 'SHOULDER'


class FeedbackSingularity(BaseModel):
    """
    A singularity is a point in the robot's workspace where the robot loses one or more degrees of freedom with regards to moving its TCP.
    This means the robot cannot move or rotate the TCP in a certain direction from this specific point.

    Use PTP motions if possible. They will almost never fail due to singularities (only if the target point is at a singularity).

    Alternatively change the robot TCP's path to avoid moving through this point or try to move the TCP through this point in a different direction.

    """

    singularity_type: SingularityTypeEnum | None = None
    singular_joint_position: DoubleArray | None = None
    error_feedback_name: Literal['FeedbackSingularity'] = 'FeedbackSingularity'


class FeedbackJointLimitExceeded(BaseModel):
    """
    This error is returned when a joint position limit is exceeded.
    The joint index denotes which joint is out of its limits, starting with 1 and followed by the full joint position.

    """

    joint_index: Annotated[int | None, Field(ge=0, le=2147483647)] = None
    joint_position: DoubleArray | None = None
    error_feedback_name: Literal['FeedbackJointLimitExceeded'] = (
        'FeedbackJointLimitExceeded'
    )


class CollisionContact(BaseModel):
    local: Vector3d | None = None
    root: Vector3d | None = None


class Collision(BaseModel):
    id_of_a: str | None = None
    id_of_b: str | None = None
    id_of_layer: str | None = None
    normal_root_on_b: Vector3d | None = None
    position_on_a: CollisionContact | None = None
    position_on_b: CollisionContact | None = None


class FeedbackCollision(BaseModel):
    collisions: list[Collision] | None = None
    joint_position: DoubleArray | None = None
    tcp_pose: Pose | None = None
    error_feedback_name: Literal['FeedbackCollision'] = 'FeedbackCollision'


class PlanTrajectoryFailedResponse(BaseModel):
    error_feedback: Annotated[
        FeedbackOutOfWorkspace
        | FeedbackSingularity
        | FeedbackJointLimitExceeded
        | FeedbackCollision,
        Field(discriminator='error_feedback_name'),
    ]
    error_location_on_trajectory: Location
    joint_trajectory: JointTrajectory | None = None
    """
    The joint trajectory from the start joint position to the error.

    """


class PlanTrajectoryResponse(BaseModel):
    response: JointTrajectory | PlanTrajectoryFailedResponse


class ValidationError(BaseModel):
    loc: Annotated[list[str | int], Field(title='Location')]
    msg: Annotated[str, Field(title='Message')]
    type: Annotated[str, Field(title='Error Type')]
    input: dict[str, Any]


class ErrorInvalidJointCount(BaseModel):
    """
    The provided joint data does not match the expected number of joints
    for this motion group.

    """

    expected_joint_count: int
    """
    The expected number of joints for this motion group.

    """
    provided_joint_count: int
    """
    The number of provided joints.

    """
    error_feedback_name: Literal['ErrorInvalidJointCount'] = 'ErrorInvalidJointCount'


class ErrorJointLimitExceeded(BaseModel):
    """
    A reference joint position (start or target) exceeds the configured joint limits.

    """

    joint_index: Annotated[int | None, Field(ge=0, le=2147483647)] = None
    """
    Index of the joint exceeding its limits (0-based).

    """
    joint_position: DoubleArray | None = None
    """
    The joint position violating the limits.

    """
    error_feedback_name: Literal['ErrorJointLimitExceeded'] = 'ErrorJointLimitExceeded'


class ErrorJointPositionCollision(BaseModel):
    """
    A reference joint position, e.g., start or target joint position, results in collisions that prevent processing.

    """

    collisions: list[Collision] | None = None
    joint_position: DoubleArray | None = None
    """
    The joint position that collides.

    """
    error_feedback_name: Literal['ErrorJointPositionCollision'] = (
        'ErrorJointPositionCollision'
    )


class PlanValidationError(ValidationError):
    data: Annotated[
        ErrorInvalidJointCount
        | ErrorJointLimitExceeded
        | ErrorJointPositionCollision
        | None,
        Field(discriminator='error_feedback_name'),
    ] = None
    """
    Optional data further specifying the validation error.

    """


class Plan422Response(BaseModel):
    detail: Annotated[list[PlanValidationError] | None, Field(title='Detail')] = None


class RRTConnectAlgorithm(BaseModel):
    algorithm_name: Literal['RRTConnectAlgorithm'] = 'RRTConnectAlgorithm'
    """
    Algorithm discriminator.

    RRT Connect algorithm configuration for collision-free path planning.
    Rapidly-exploring Random Trees (RRT) builds trees of valid configurations by randomly sampling
    the joint space and connecting feasible points with JointPTP motions.
    RRT Connect grows two trees simultaneously from start and target positions until they meet.
    This is a custom implementation optimized for manipulator kinematics and collision checking in industrial contexts.

    """
    max_iterations: Annotated[int | None, Field(ge=1)] = 10000
    """
    Maximum number of iterations for the RRT Connect algorithm.
    Higher values increase likelihood of success, but also computation time.

    """
    max_step_size: float | None = 1
    """
    Maximum step size for tree extension in joint space.
    """
    adaptive_step_size: bool | None = True
    """
    Adjust the maximum step size during the search based on the recent success rate of tree expansion.
    """
    apply_smoothing: bool | None = True
    """
    Apply smoothing after the search has succeeded. This will remove as many intermediate points as possible while keeping the path valid.
    """
    apply_blending: bool | None = True
    """
    Apply blending after the search has succeeded and smoothing has been applied. This will apply the largest viable blending at each intermediate point.
    """


class MidpointInsertionAlgorithm(BaseModel):
    algorithm_name: Literal['MidpointInsertionAlgorithm'] = 'MidpointInsertionAlgorithm'
    """
    Algorithm discriminator.

    Midpoint insertion algorithm configuration for collision-free path planning.
    This algorithm adds a single midpoint between the start and target joint position to find collision-free paths.

    """
    max_iterations: Annotated[int | None, Field(ge=1)] = 1000
    """
    Maximum number of iterations for the midpoint insertion algorithm.
    Higher values increase likelyhood of success, but also computation time (linear).

    """


class CollisionFreeAlgorithm(RootModel):
    root: Annotated[
        RRTConnectAlgorithm | MidpointInsertionAlgorithm,
        Field(discriminator='algorithm_name', title='CollisionFreeAlgorithm'),
    ]
    """
    Configuration for collision-free path planning algorithms.
    Different algorithms may have different parameters and behavior.

    Recommendation:
    - For **cells with many obstacles**, use the RRTConnect algorithm. Use it as a starting point.
    - For **simple cells with very few obstacles** and when a faster solution is needed, try the MidpointInsertion algorithm.

    """


class PlanCollisionFreeRequest(BaseModel):
    motion_group_setup: MotionGroupSetup
    """
    The data to assemble the robot setup can be retrieved from [getMotionGroupDescription](getMotionGroupDescription) endpoint.
    """
    start_joint_position: DoubleArray
    """
    Starting joint position for the collision-free motion.
    Must contain exactly the same number of values as joints in the motion group.
    To retrieve the current joint position use the endpoint [getCurrentMotionGroupState](getCurrentMotionGroupState).

    """
    target: DoubleArray
    """
    The target joint position of the motion.
    Must contain exactly the same number of values as joints in the motion group.
    To compute target joint position from a TCP pose use the endpoint [inverseKinematics](inverseKinematics).

    """
    algorithm: CollisionFreeAlgorithm


class ErrorMaxIterationsExceeded(BaseModel):
    """
    The collision-free planning algorithm reached its maximum iteration limit
    without finding a valid path. Increase max_iterations or
    modify the start/target positions.

    """

    max_iterations: int | None = None
    """
    The maximum number of iterations that was reached.

    """
    error_feedback_name: Literal['ErrorMaxIterationsExceeded'] = (
        'ErrorMaxIterationsExceeded'
    )


class PlanCollisionFreeFailedResponse(BaseModel):
    """
    Response when collision-free trajectory planning fails.
    Contains specific feedback about why the planning failed.

    """

    error_feedback: ErrorMaxIterationsExceeded


class PlanCollisionFreeResponse(BaseModel):
    """
    Response from collision-free trajectory planning.
    Contains either a successful joint trajectory or failure information.

    """

    response: JointTrajectory | PlanCollisionFreeFailedResponse


class JointPositionLimits(RootModel):
    """
    Joint position limits in [rad], indexed starting from base.

    """

    root: Annotated[list[LimitRange], Field(title='JointPositionLimits')]
    """
    Joint position limits in [rad], indexed starting from base.

    """

    def __getitem__(self, index: int) -> LimitRange:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: LimitRange) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class InverseKinematicsRequest(BaseModel):
    motion_group_model: MotionGroupModel
    tcp_poses: list[Pose]
    """
    List of TCP poses for which the inverse solutions are computed.

    """
    tcp_offset: Pose | None = None
    mounting: Pose | None = None
    """
    Offset from the world frame to the motion group base.
    """
    joint_position_limits: JointPositionLimits | None = None
    collision_setups: CollisionSetups | None = None
    reference_joint_position: DoubleArray | None = None
    """
    If present, all solutions are shifted to the same periodicity
    as the reference: Each individual joint angle is shifted
    by integer multiples of 2 pi (whole revolutions) until it's
    as close to the reference as possible. The solutions are sorted
    by ascending distance (L2 norm) from the reference.

    """


class InverseKinematicsResponse(BaseModel):
    joints: list[list[DoubleArray]]


class InverseKinematicsValidationError(ValidationError):
    data: Annotated[
        ErrorInvalidJointCount | ErrorJointLimitExceeded | None,
        Field(discriminator='error_feedback_name'),
    ] = None
    """
    Optional data further specifying the validation error.

    """


class InverseKinematics422Response(BaseModel):
    detail: Annotated[
        list[InverseKinematicsValidationError] | None, Field(title='Detail')
    ] = None


class ForwardKinematicsRequest(BaseModel):
    motion_group_model: MotionGroupModel
    joint_positions: list[DoubleArray]
    """
    List of joint positions [rad] for which TCP poses are computed.

    """
    tcp_offset: Pose | None = None
    mounting: Pose | None = None
    """
    Offset from the world frame to the motion group base.
    """


class ForwardKinematicsResponse(BaseModel):
    tcp_poses: list[Pose]
    """
    List of computed TCP poses corresponding to the input joint positions.

    """


class ForwardKinematicsValidationError(ValidationError):
    data: ErrorInvalidJointCount | None = None


class ForwardKinematics422Response(BaseModel):
    detail: Annotated[
        list[ForwardKinematicsValidationError] | None, Field(title='Detail')
    ] = None


class ListTrajectoriesResponse(BaseModel):
    trajectories: list[str] | None = None
    """
    Identifiers of trajectories which are currently cached.
    Use [addTrajectory](addTrajectory) to add a new trajectory. Adding trajectories is necessary to execute them.
    Trajectories are removed if the corresponding motion group or controller disconnects.

    """


class AddTrajectoryRequest(BaseModel):
    motion_group: str
    """
    Unique identifier of the motion group the trajectory is planned for.
    """
    trajectory: JointTrajectory
    """
    The trajectory consisting of a list of joint positions and
    an equal number of corresponding timestamps.

    """
    tcp: str | None = None
    """
    Unique identifier of the tool the trajectory is planned for.
    """


class TcpRequiredError(BaseModel):
    """
    Requested motion group requires TCP to be defined.
    """

    tcp_missing: dict[str, Any] | None = None


class InconsistentTrajectorySize(BaseModel):
    joint_position_size: int | None = None
    times_size: int | None = None
    locations_size: int | None = None


class InconsistentTrajectorySizeError(BaseModel):
    """
    Indicates that the trajectory contains an inconsistent number of joint positions, times, or locations.

    """

    inconsistent_trajectory_size: InconsistentTrajectorySize | None = None


class JointLimitExceededError(BaseModel):
    joint_limit_exceeded: FeedbackJointLimitExceeded | None = None


class CollisionError(BaseModel):
    collision: FeedbackCollision | None = None


class TorqueExceeded(BaseModel):
    torque_value: float | None = None
    """
    The torque value that was exceeded.

    """
    torque_limit: float | None = None
    """
    The value of the torque limit that was exceeded.

    """


class TorqueExceededError(BaseModel):
    torque_exceeded: TorqueExceeded | None = None


class InvalidDof(BaseModel):
    valid_dof: int | None = None
    """
    The valid degrees of freedom for the motion group.

    """
    joint_position: list[float] | None = None
    """
    The joint position that is out of its limits.
    """


class InvalidDofError(BaseModel):
    invalid_dof: InvalidDof | None = None


class NanValue(BaseModel):
    """
    Requested joint position contains NaN values.
    """

    joint_position: list[float] | None = None
    """
    The joint position that is out of its limits.
    """


class NanValueError(BaseModel):
    nan_value: NanValue | None = None
    """
    Requested joint position contains NaN values.
    """


class AddTrajectoryError(BaseModel):
    message: str | None = None
    location: Location | None = None
    """
    Location on trajectory where the error occurred.

    """
    data: (
        TcpRequiredError
        | InconsistentTrajectorySizeError
        | JointLimitExceededError
        | CollisionError
        | TorqueExceededError
        | InvalidDofError
        | NanValueError
        | None
    ) = None


class AddTrajectoryResponse(BaseModel):
    """
    The response signals if the trajectory is valid or faulty resulting in an executable, partially executable or not executable state.
    - valid trajectory: response contains only the unique identifier for the trajectory
    - trajectory has error on path: response contains the unique identifier for the trajectory and information about the failure. It is executable up to the point of failure.
    - trajectory has error at start or invalid data: response contains only information about the failure.

    To execute the trajectory use the unique identifier for calling [executeTrajectory](executeTrajectory).
    If you want to validate your trajectory before execution, execute it with a virtual motion group and check the state in the response stream of [executeTrajectory](executeTrajectory).

    """

    trajectory: str | None = None
    """
    The unique identifier of the trajectory. Use this identifier to execute the trajectory with the [executeTrajectory](executeTrajectory) endpoint.

    """
    error: AddTrajectoryError | None = None
    """
    Always check this field first. If this field is present, the trajectory has an error and is only partially or not executable.

    """


class GetTrajectoryResponse(BaseModel):
    motion_group: str
    """
    Unique identifier of the motion group the trajectory is planned for.
    """
    trajectory: JointTrajectory
    """
    The trajectory consisting of a list of joint positions and
    an equal number of corresponding timestamps.

    """
    tcp: str
    """
    Unique identifier of the tool the trajectory is planned for.
    """


class TrajectoryId(BaseModel):
    message_type: Literal['TrajectoryId'] = 'TrajectoryId'
    """
    Type specifier for server, set automatically.

    """
    id: str
    """
    The identifier of the trajectory which was returned by the [addTrajectory](addTrajectory) endpoint.

    """


class TrajectoryData(BaseModel):
    message_type: Literal['TrajectoryData'] = 'TrajectoryData'
    """
    Type specifier for server, set automatically.

    """
    motion_group: str | None = None
    """
    Identifier of the motion-group.
    """
    data: JointTrajectory
    """
    The trajectory consisting of a list of joint positions and
    an equal number of corresponding timestamps.

    """
    tcp: str | None = None
    """
    Unique identifier of the tool the trajectory is planned for.
    """


class InitializeMovementRequest(BaseModel):
    """
    Sets up connection by locking a trajectory for execution. The robot controller mode is set to control mode.
    ATTENTION: This request has to be sent before any StartMovementRequest is sent.
               If initializing the movement was successful, no further movements can be initialized. To execute another trajectory, another connection has to be established.

    """

    message_type: Literal['InitializeMovementRequest'] = 'InitializeMovementRequest'
    """
    Type specifier for server, set automatically.

    """
    trajectory: Annotated[
        TrajectoryId | TrajectoryData, Field(discriminator='message_type')
    ]
    """
    The trajectory which should be executed and locked to the connection.

    """
    initial_location: Location | None = None
    """
    Location on trajectory where the execution will start.
    Defaults to 0.0, start of the trajectory.
    ATTENTION: The robot has to be at the position of the initial location when initializing the movement.
               If not, an error is returned.

    """
    response_coordinate_system: str | None = None
    """
    Unique identifier addressing a coordinate system to which the responses are transformed.
    If not set, world coordinate system is used.

    """


class Direction(Enum):
    """
    The direction in which the trajectory is executed. Default: Forward.

    """

    DIRECTION_FORWARD = 'DIRECTION_FORWARD'
    DIRECTION_BACKWARD = 'DIRECTION_BACKWARD'


class IOOrigin(Enum):
    """
    States the source of the input/output signal.

    """

    CONTROLLER = 'CONTROLLER'
    BUS_IO = 'BUS_IO'


class SetIO(BaseModel):
    """
    Defines an input/output that should be set upon reaching a specified location on the trajectory.
    """

    io: IOValue
    location: float
    """
    The location on the trajectory where the input/output should be set.
    """
    io_origin: IOOrigin


class StartOnIO(BaseModel):
    """
    Defines an input/output that the motion should wait for to start the execution.
    """

    io: IOValue
    comparator: Comparator
    """
    Comparator for the comparison of two values.
    Use the measured I/O as the base value (a) and the expected input/output value as the comparator (b): e.g., a > b.

    """
    io_origin: IOOrigin


class PauseOnIO(BaseModel):
    """
    Defines an input/output that the motion will be paused for. The motion will stop gracefully on path.
    """

    io: IOValue
    comparator: Comparator
    """
    Comparator for the comparison of two values.
    Use the measured I/O as the base value (a) and the expected input/output value as the comparator (b): e.g., a > b.

    """
    io_origin: IOOrigin


class StartMovementRequest(BaseModel):
    """
    Moves the motion group along a trajectory, added via [planTrajectory](planTrajectory) or [planMotion](planMotion).
    Trajectories can be executed forwards or backwards("in reverse").

    Pause the execution with PauseMovementRequest.
    Resume execution with StartMovementRequest.

    Precondition: To start execution, the motion group must be located at the trajectory's start location specified in InitializeMovementRequest.

    """

    message_type: Literal['StartMovementRequest'] = 'StartMovementRequest'
    """
    Type specifier for server, set automatically.

    """
    direction: Direction | None = 'DIRECTION_FORWARD'
    target_location: Location | None = None
    """
    The target location to which the motion group moves along the trajectory to.
    If `direction` and `target_location` are both specified, target location takes precedence.
    If neither is specified, the default is `DIRECTION_FORWARD`.

    """
    set_outputs: list[SetIO] | None = None
    """
    Attaches a list of output commands to the trajectory. The outputs are set to the specified values right after the specified location was reached.
    If the specified location is located before the start location (forward direction: value is smaller, backward direction: value is bigger), the output is not set.

    """
    start_on_io: StartOnIO | None = None
    """
    Defines an input/output that is listened to before the movement. Execution starts if the defined comparator evaluates to `true`.

    """
    pause_on_io: PauseOnIO | None = None
    """
    Defines an input/output that is listened to during the movement. Execution pauses if the defined comparator evaluates to `true`.

    """


class PauseMovementRequest(BaseModel):
    """
    Request to pause the movement execution. Movement pauses as soon as a [Standstill](Standstill.yaml) is sent back to the client.
    Resume movement with StartMovementRequest.

    """

    message_type: Literal['PauseMovementRequest'] = 'PauseMovementRequest'
    """
    Type specifier for server, set automatically.

    """


class PlaybackSpeedRequest(BaseModel):
    """
    Sets velocity for executed movements of the motion, in percent. Send after initializing the connection with InitializeMovementRequest.

    """

    message_type: Literal['PlaybackSpeedRequest'] = 'PlaybackSpeedRequest'
    """
    Type specifier for server, set automatically.

    """
    playback_speed_in_percent: Annotated[int, Field(ge=0, le=100)]
    """
    Sets velocity for executed movements of the trajectory, in percent. 100% means that the motion group moves as
    fast as possible without violating any planning and motion group limits. Setting this value does not affect the overall shape of the velocity profile.
    The velocity profile of the trajectory is scaled down by the same factor. Therefore, this should only be used for teaching and trajectory
    evaluation purposes. To maintain a specific velocity, set the respective limits when planning the trajectory.

    """


class ExecuteTrajectoryRequest(RootModel):
    root: Annotated[
        InitializeMovementRequest
        | StartMovementRequest
        | PauseMovementRequest
        | PlaybackSpeedRequest,
        Field(discriminator='message_type', title='ExecuteTrajectoryRequest'),
    ]


class InitializeMovementResponse(BaseModel):
    """
    Response for InitializeMovementRequest message.

    """

    message: str | None = None
    """
    Error message in case of invalid InitializeMovementRequest.
    """
    add_trajectory_error: AddTrajectoryError | None = None
    """
    Error can occur if joint trajectory was added by [InitializeMovementRequest](InitializeMovementRequest) and the trajectory is invalid.

    """
    kind: Literal['INITIALIZE_RECEIVED'] = 'INITIALIZE_RECEIVED'


class StartMovementResponse(BaseModel):
    """
    Acknowledgment for StartMovementRequest message.
    ATTENTION: No confirmation that the movement was started. Confirmation that the StartMovementRequest was received and is processed.
    Fields `execute` and `standstill` of response of [streamMotionGroupState](streamMotionGroupState) signal start of movement execution.

    """

    message: str | None = None
    """
    Error message in case of invalid StartMovementResquest.
    """
    kind: Literal['START_RECEIVED'] = 'START_RECEIVED'


class PauseMovementResponse(BaseModel):
    """
    Acknowledgment for PauseMovementRequest message.
    ATTENTION: No confirmation that the movement was paused. Confirmation that the PauseMovementRequest was received and is processed.
               End of movement execution is signalled by [StillstandResponse](StillstandResponse).

    """

    message: str | None = None
    """
    Error message in case of invalid PauseMovementResquest.
    """
    kind: Literal['PAUSE_RECEIVED'] = 'PAUSE_RECEIVED'


class PlaybackSpeedResponse(BaseModel):
    """
    Acknowledgment for PlaybackSpeedRequest message.

    """

    message: str | None = None
    """
    Error message in case of invalid PlaybackSpeedRequest.
    """
    kind: Literal['PLAYBACK_SPEED_RECEIVED'] = 'PLAYBACK_SPEED_RECEIVED'


class MovementErrorResponse(BaseModel):
    """
    Error message in case an error occurs during movement execution.

    """

    message: str
    """
    Detailed error message describing the issue encountered during movement execution.
    """
    kind: Literal['MOTION_ERROR'] = 'MOTION_ERROR'


class ExecuteTrajectoryResponse(RootModel):
    root: Annotated[
        InitializeMovementResponse
        | StartMovementResponse
        | PauseMovementResponse
        | PlaybackSpeedResponse
        | MovementErrorResponse,
        Field(discriminator='kind', title='ExecuteTrajectoryResponse'),
    ]


class InitializeJoggingRequest(BaseModel):
    """
    Send this message to start jogging a motion group.
    """

    message_type: Literal['InitializeJoggingRequest'] = 'InitializeJoggingRequest'
    """
    Type specifier for server, set automatically.

    """
    motion_group: str
    """
    Identifier of the motion group.
    """
    tcp: str | None = None
    """
    Identifier of the tool. Required for robots (all limits, including TCP limits, are respected at all times regardless of the motion). Not required for external axes.

    """


class JointVelocityRequest(BaseModel):
    """
    Sets target joint velocities for jogging a motion group.
    """

    message_type: Literal['JointVelocityRequest'] = 'JointVelocityRequest'
    """
    Type specifier for server, set automatically.
    """
    velocity: Joints
    """
    in [rad/s]
    """


class TcpVelocityRequest(BaseModel):
    """
    Sets target TCP velocities for jogging a motion group.
    The motion group needs to have an inverse kinematic solver to be jogged by TCP velocities.
    Check `supports_inverse_kinematics` field in response of [listController](listController) for the motion group.

    """

    message_type: Literal['TcpVelocityRequest'] = 'TcpVelocityRequest'
    """
    Type specifier for server, set automatically.

    """
    translation: Vector3d
    rotation: Vector3d
    use_tool_coordinate_system: bool | None = False
    """
    If true, TCP velocities are interpreted in the tool coordinate system, specified by the TCP.
    If false, TCP velocities are interpreted in the world coordinate system.

    """


class PauseJoggingRequest(BaseModel):
    """
    Request to pause jogging. If successful, `execute` jogging state in [MotionGroupState](MotionGroupState.yaml) is set to `PAUSED_BY_USER`.

    """

    message_type: Literal['PauseJoggingRequest'] = 'PauseJoggingRequest'
    """
    Type specifier for server, set automatically.

    """


class ExecuteJoggingRequest(RootModel):
    root: Annotated[
        InitializeJoggingRequest
        | JointVelocityRequest
        | TcpVelocityRequest
        | PauseJoggingRequest,
        Field(discriminator='message_type', title='ExecuteJoggingRequest'),
    ]


class InitializeJoggingResponse(BaseModel):
    """
    Acknowledgment to an InitializeJoggingRequest.

    """

    message: str | None = None
    """
    Error message in case of invalid InitializeJoggingRequest.
    """
    kind: Literal['INITIALIZE_RECEIVED'] = 'INITIALIZE_RECEIVED'


class PauseJoggingResponse(BaseModel):
    """
    Acknowledgment to a PauseJoggingRequest.

    """

    message: str | None = None
    """
    Error message in case of invalid PauseJoggingRequest.
    """
    kind: Literal['PAUSE_RECEIVED'] = 'PAUSE_RECEIVED'


class TcpVelocityResponse(BaseModel):
    """
    Acknowledgment to a TcpVelocityRequest.

    """

    message: str | None = None
    """
    Error message in case of invalid TcpVelocityRequest.
    """
    kind: Literal['TCP_VELOCITY_RECEIVED'] = 'TCP_VELOCITY_RECEIVED'


class JointVelocityResponse(BaseModel):
    """
    Acknowledgment to a JointVelocityRequest.

    """

    message: str | None = None
    """
    Error message in case of invalid JointVelocityRequest.
    """
    kind: Literal['JOINT_VELOCITY_RECEIVED'] = 'JOINT_VELOCITY_RECEIVED'


class ExecuteJoggingResponse(RootModel):
    root: Annotated[
        InitializeJoggingResponse
        | PauseJoggingResponse
        | TcpVelocityResponse
        | JointVelocityResponse
        | MovementErrorResponse,
        Field(discriminator='kind', title='ExecuteJoggingResponse'),
    ]


class Program(BaseModel):
    """
    A program is a collection of instructions that are executed in the robot cell.
    """

    program: Annotated[
        str,
        Field(
            examples=['my_program'],
            max_length=255,
            min_length=1,
            pattern='^[a-zA-Z0-9_-]+$',
            title='Unique program identifier',
        ),
    ]
    name: Annotated[str | None, Field(title='Program name')] = None
    description: Annotated[str | None, Field(title='Program description')] = None
    app: Annotated[str, Field(title='The app containing the program.')]
    input_schema: Annotated[
        dict[str, Any] | None, Field(title='Program input json schema')
    ] = None
    preconditions: Annotated[
        dict[str, Any] | None,
        Field(title='Preconditions before the program can be started'),
    ] = None


class ProgramStartRequest(BaseModel):
    """
    The state of a program run.
    """

    arguments: dict[str, Any]
    """
    The arguments to pass to the program.
    """


class ProgramRunState(Enum):
    """
    The state of a program run.
    """

    PREPARING = 'PREPARING'
    RUNNING = 'RUNNING'
    COMPLETED = 'COMPLETED'
    FAILED = 'FAILED'
    STOPPED = 'STOPPED'


class ProgramRun(BaseModel):
    """
    Holds the state of a program run.
    """

    run: Annotated[str, Field(title='Run Id')]
    """
    Unique identifier of the program run
    """
    program: Annotated[str, Field(title='Program Id')]
    """
    Unique identifier of the program
    """
    app: Annotated[str | None, Field(title='App Id')] = None
    """
    Identifier of the app that produced the program run
    """
    state: Annotated[ProgramRunState, Field(title='State')]
    """
    State of the program run
    """
    logs: Annotated[str | None, Field(title='Logs')] = None
    """
    Logs of the program run
    """
    stdout: Annotated[str | None, Field(title='Stdout')] = None
    """
    Stdout of the program run
    """
    stderr: Annotated[str | None, Field(title='Stderr')] = None
    """
    Stderr of the program run
    """
    error: Annotated[str | None, Field(title='Error')] = None
    """
    Error message of the program run, if any
    """
    traceback: Annotated[str | None, Field(title='Traceback')] = None
    """
    Traceback of the program run, if any
    """
    start_time: Annotated[AwareDatetime | None, Field(title='Start Time')] = None
    """
    Start time of the program run in RFC3339 format
    """
    end_time: Annotated[AwareDatetime | None, Field(title='End Time')] = None
    """
    End time of the program run in RFC3339 format
    """
    input_data: Annotated[dict[str, Any] | None, Field(title='Input Data')] = None
    """
    Input data of the program run
    """


class ValidationError2(BaseModel):
    """
    A validation error of a program.
    """

    loc: Annotated[list[int], Field(title='Location')]
    msg: Annotated[str, Field(title='Message')]
    type: Annotated[str, Field(title='Error Type')]


class HTTPValidationError(BaseModel):
    detail: Annotated[list[ValidationError2] | None, Field(title='Detail')] = None


class MotionGroupInfo(BaseModel):
    motion_group: str
    """
    The unique identifier of the motion group. Use it to refer to the motion group in other calls.

    """
    name: str
    """
    The name of the motion group for display purposes.

    """
    dof: Annotated[int, Field(ge=0, le=2147483647)]
    """
    The number of joints aka degrees of freedom in the motion group.

    """


class MotionGroupInfos(RootModel):
    root: list[MotionGroupInfo]

    def __getitem__(self, index: int) -> MotionGroupInfo:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: MotionGroupInfo) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class MotionGroupJoints(BaseModel):
    """
    Ensure to provide one value for each joint. See [getMotionGroups](getMotionGroups) for the number of joints.
    Everything but positions is optional.
    """

    positions: list[float]
    """
    The joint positions of the motion group.

    """
    velocities: list[float] | None = None
    """
    The joint velocities of the motion group.

    """
    accelerations: list[float] | None = None
    """
    The joint accelerations of the motion group.

    """
    torques: list[float] | None = None
    """
    The joint torques of the motion group.

    """


class RobotTcpData(BaseModel):
    name: str | None = None
    """
    A readable and changeable name for frontend visualization.
    """
    position: Vector3d
    orientation: Orientation | None = None
    orientation_type: OrientationType | None = 'ROTATION_VECTOR'


class RobotTcp(RobotTcpData):
    id: str
    """
    Identifier of this tcp.
    """


class RobotTcps(RootModel):
    root: Annotated[
        list[RobotTcp],
        Field(
            examples=[
                [
                    {
                        'id': 'BASE/schmalz_gripper',
                        'name': 'BASE/schmalz_gripper',
                        'position': [0, 0, 110],
                        'orientation': [0, 0, 0, 1],
                        'orientation_type': 'QUATERNION',
                    },
                    {
                        'id': 'WB_EGM/egm_tool',
                        'name': 'WB_EGM/egm_tool',
                        'position': [400, 250, 0],
                        'orientation': [1.57079632679, 0, 3.14159265359],
                        'orientation_type': 'ROTATION_VECTOR',
                    },
                ]
            ]
        ),
    ]

    def __getitem__(self, index: int) -> RobotTcp:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: RobotTcp) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class Flag(BaseModel):
    active: bool


class OpMode(BaseModel):
    """
    Controllers have two operating modes: AUTOMATIC and MANUAL.
    MANUAL mode is mainly used for teaching a robot application.
    To ensure safe operation the velocity of the robot is limited to 250 mm/s.
    Running the finished application is done in AUTOMATIC operating mode without the limited velocity of the MANUAL mode.

    """

    mode: OperationMode


class CycleTime(BaseModel):
    cycle_time_ms: Annotated[int, Field(ge=0, le=4294967295)]
    """
    Cycle time of controller communication in [ms].
    """


class Behavior(Enum):
    """
    ## BEHAVIOR_AUTOMATIC
    This is the default behavior.
    The motion groups of the controller take commanded joint configuration as actual joint state.
    Configures the compliance of the virtual robot with the normal ControllerState cycle time. If set, the virtual robot will act like a physical one, e.g., with a cycle time of 8ms to respond to a new joint state command.
    ## BEHAVIOR_AUTOMATIC_NOT_COMPLY_WITH_CYCLETIME
    Configures the compliance of the virtual robot with the normal ControllerState cycle time. If set, the robot will respond as fast as possible, limited only by software execution speed. Because of that the execution of a movement requires less time than with BEHAVIOR_AUTOMATIC.
    ## BEHAVIOR_EXTERNAL_SOURCE
    The external client is the only source of actual joint state changes.
    This mode is used to enable third party software indicating the current joint state via [externalJointsStream](externalJointsStream).

    """

    BEHAVIOR_AUTOMATIC = 'BEHAVIOR_AUTOMATIC'
    BEHAVIOR_AUTOMATIC_NOT_COMPLY_WITH_CYCLETIME = (
        'BEHAVIOR_AUTOMATIC_NOT_COMPLY_WITH_CYCLETIME'
    )
    BEHAVIOR_EXTERNAL_SOURCE = 'BEHAVIOR_EXTERNAL_SOURCE'


class ExternalJointStreamDatapoint(BaseModel):
    """
    A datapoint inside external joint stream.
    """

    motion_group: str
    """
    The unique identifier of the motion group.

    """
    value: MotionGroupJoints


class ExternalJointStreamDatapoints(RootModel):
    root: list[ExternalJointStreamDatapoint]

    def __getitem__(self, index: int) -> ExternalJointStreamDatapoint:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: ExternalJointStreamDatapoint) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class ExternalJointStreamRequest(BaseModel):
    states: ExternalJointStreamDatapoints


class Key(RootModel):
    root: Annotated[str, Field(title='Key')]
    """
    Unique identifier describing to adress an object.

    Special characters, such as `;`, `/`, `?`, `:`, `@`, `=` and `&`, have to be URL encoded.

    """


class MetadataObject(RootModel):
    """
    A metadata object.
    """

    root: dict[str, str]


class BinaryObject(RootModel):
    root: Annotated[bytes, Field(title='BinaryObject')]
    """
    Any value encoded as a binary string.
    """


class BusIODescription(BaseModel):
    io: str
    """
    Unique identifier of the input/output.

    """
    name: str
    """
    Name of the input/output. Customize it using the respective BUS service, e.g., [addProfinetIO](addProfinetIO) for PROFINET service.

    """
    direction: IODirection
    value_type: IOValueType
    unit: UnitType | None = None
    min: IOBoundary | None = None
    max: IOBoundary | None = None


class ListBusIODescriptionsResponse(RootModel):
    root: list[BusIODescription]

    def __getitem__(self, index: int) -> BusIODescription:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: BusIODescription) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class BusIOsStateEnum(Enum):
    """
    Current state of the BUS input/output service.

    """

    BUS_IOS_STATE_UNKNOWN = 'BUS_IOS_STATE_UNKNOWN'
    BUS_IOS_STATE_INITIALIZING = 'BUS_IOS_STATE_INITIALIZING'
    BUS_IOS_STATE_CONNECTED = 'BUS_IOS_STATE_CONNECTED'
    BUS_IOS_STATE_DISCONNECTED = 'BUS_IOS_STATE_DISCONNECTED'


class BusIOsState(BaseModel):
    state: BusIOsStateEnum
    message: str | None = None
    """
    A message providing additional information on the input/output service, e.g., BUS service status, encountered errors.
    May be empty if no additional information is available.

    """


class ProfinetSubSlotDescription(BaseModel):
    number: Annotated[int, Field(ge=0, le=2147483647)]
    """
    The number/index of the PROFINET subslot.

    """
    input_length: Annotated[int, Field(ge=0, le=2147483647)]
    """
    The amount of bytes allocated for the subslot in the input process image buffer.

    """
    output_length: Annotated[int, Field(ge=0, le=2147483647)]
    """
    The amount of bytes allocated for the subslot in the output process image buffer.

    """


class ProfinetSlotDescription(BaseModel):
    """
    An array of PROFINET slots.

    PROFINET models each device’s input/output hardware as a hierarchy of slots (modules) and subslots (submodules).
    A slot can represent a physical or virtual input/output card and each subslot one of its individual channels or functions.
    Every slot and subslot has unique identifiers that the controller uses to map cyclic input/output data and parameter records to its process image.
    This slot/subslot separation enables e.g., addressing each input/output stream when establishing input/output application relations (I/O-AR).

    """

    number: Annotated[int, Field(ge=0, le=2147483647)]
    """
    The number/index of the PROFINET slot. Per default, slot 0 is reserved for the device access point (DAP). Slots that are part of the cyclic input/output data exchange start at number 1.

    """
    api: Annotated[int, Field(ge=0, le=2147483647)]
    """
    The application process identifier (API) number of the PROFINET input.
    The API identifies the application relation (AR) that is using the slot.

    """
    subslots: list[ProfinetSubSlotDescription]
    """
    An array of PROFINET subslots.

    """


class ProfinetDescription(BaseModel):
    vendor_id: str
    """
    The vendor identifier of the PROFINET device, identifying the manufacturer.

    """
    device_id: str
    """
    The device identifier of the PROFINET device, identifying the specific device within the vendor's range.

    """
    slots: list[ProfinetSlotDescription] | None = None
    device_name: Annotated[str | None, Field(examples=['pnDevice'])] = None
    """
    Name of Station (NoS) of the PROFINET device. The NoS is used in combination with IPv4 record to identify your device in the PROFINET network.
    The `device_name` will be used as NoS if no REMA XML file is already present on your NOVA instance and no `rema_xml_content` is provided.

    """
    ip_config: BusIOProfinetIpConfig | None = None


class ProfinetIOTypeEnum(Enum):
    """
    Value type of the PROFINET input/output variable. Is used to interpret the corresponding bits correctly.

    """

    PROFINET_IO_TYPE_UNKNOWN = 'PROFINET_IO_TYPE_UNKNOWN'
    PROFINET_IO_TYPE_BOOL = 'PROFINET_IO_TYPE_BOOL'
    PROFINET_IO_TYPE_USINT = 'PROFINET_IO_TYPE_USINT'
    PROFINET_IO_TYPE_SINT = 'PROFINET_IO_TYPE_SINT'
    PROFINET_IO_TYPE_UINT = 'PROFINET_IO_TYPE_UINT'
    PROFINET_IO_TYPE_INT = 'PROFINET_IO_TYPE_INT'
    PROFINET_IO_TYPE_UDINT = 'PROFINET_IO_TYPE_UDINT'
    PROFINET_IO_TYPE_DINT = 'PROFINET_IO_TYPE_DINT'
    PROFINET_IO_TYPE_REAL = 'PROFINET_IO_TYPE_REAL'
    PROFINET_IO_TYPE_LREAL = 'PROFINET_IO_TYPE_LREAL'


class ProfinetIODirection(Enum):
    """
    The direction of the input/output variable, indicating whether it is an input or output for the PROFINET device, e.g., NOVA's PROFINET service.
    """

    PROFINET_IO_DIRECTION_INPUT = 'PROFINET_IO_DIRECTION_INPUT'
    PROFINET_IO_DIRECTION_OUTPUT = 'PROFINET_IO_DIRECTION_OUTPUT'
    PROFINET_IO_DIRECTION_INOUT = 'PROFINET_IO_DIRECTION_INOUT'


class ProfinetIOData(BaseModel):
    description: str
    """
    Descriptive name or note for the input/output variable.

    """
    type: ProfinetIOTypeEnum
    direction: ProfinetIODirection
    """
    The direction of the input/output variable, indicating whether it is an input or output for the PROFINET device, e.g., NOVA's PROFINET service.

    """
    byte_address: Annotated[int, Field(ge=0, le=65535)]
    """
    The byte address of the input/output variable in the PROFINET device, e.g., NOVA's PROFINET service.
    The byte address is used to locate the specific input/output variable within the device's memory or data structure.

    """
    bit_address: Annotated[int | None, Field(ge=0, le=7)] = None
    """
    The bit address of the input/output variable within the byte or word address.
    The bit address is used to specify the exact bit within the byte or word that corresponds to the input/output variable.

    """


class ProfinetIO(ProfinetIOData):
    io: str
    """
    The unique identifier for the input/output value.
    This identifier is used to reference the specific input/output variable in the PROFINET device, e.g., NOVA's PROFINET service.

    """


class ProfinetIOs(RootModel):
    """
    Array of PROFINET input/output variable configurations.
    """

    root: list[ProfinetIO]
    """
    Array of PROFINET input/output variable configurations.
    """

    def __getitem__(self, index: int) -> ProfinetIO:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: ProfinetIO) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class ProfinetInputOutputConfig(BaseModel):
    config: Annotated[
        str,
        Field(
            examples=[
                '<Tagtable name=\'Standard variable table\'>\\n\n  <Tag type="Bool" hmiVisible="True" hmiWriteable="True" hmiAccessible="True" retain="False" remark="" addr="%I100.0">bLightRed</Tag>\\n\n  <Tag type="Int" hmiVisible="True" hmiWriteable="True" hmiAccessible="True" retain="False" remark="" addr="%QW800">nCounter</Tag>\\n\n</Tagtable>\n'
            ]
        ),
    ]
    """
    Content of the input/output variable configuration XML file.
    The XML File has to be embedded as a string by escaping quotes, line breaks and so forth.

    """
    input_offset: Annotated[int, Field(examples=[100], ge=0, le=2147483647)]
    """
    Offset in bytes for the address of the input (perspective of the controller) variables. The offset will be subtracted from to the byte addresses of the sent XML content.
    """
    output_offset: Annotated[int, Field(examples=[800], ge=0, le=2147483647)]
    """
    Offset in bytes for the address of the output (perspective of the controller) variables. The offset will be subtracted from to the byte addresses of the sent XML content.
    """


class ModbusIOTypeEnum(Enum):
    """
    Value type of the MODBUS input/output variable. Used to interpret the corresponding bits correctly.

    """

    MODBUS_IO_TYPE_UNKNOWN = 'MODBUS_IO_TYPE_UNKNOWN'
    MODBUS_IO_TYPE_BOOL = 'MODBUS_IO_TYPE_BOOL'
    MODBUS_IO_TYPE_UINT16 = 'MODBUS_IO_TYPE_UINT16'
    MODBUS_IO_TYPE_FLOAT32 = 'MODBUS_IO_TYPE_FLOAT32'


class ModbusIOByteOrder(Enum):
    """
    Byte order of the MODBUS input/output variable. Used to interpret the corresponding bits correctly.

    """

    MODBUS_IO_BYTE_ORDER_UNKNOWN = 'MODBUS_IO_BYTE_ORDER_UNKNOWN'
    MODBUS_IO_BYTE_ORDER_ABCD = 'MODBUS_IO_BYTE_ORDER_ABCD'
    MODBUS_IO_BYTE_ORDER_BADC = 'MODBUS_IO_BYTE_ORDER_BADC'
    MODBUS_IO_BYTE_ORDER_CDAB = 'MODBUS_IO_BYTE_ORDER_CDAB'
    MODBUS_IO_BYTE_ORDER_DCBA = 'MODBUS_IO_BYTE_ORDER_DCBA'


class ModbusIOArea(Enum):
    """
    Area of the MODBUS input/output variable. Is used to interpret the corresponding bits correctly.

    """

    MODBUS_IO_AREA_UNKNOWN = 'MODBUS_IO_AREA_UNKNOWN'
    MODBUS_IO_AREA_COILS = 'MODBUS_IO_AREA_COILS'
    MODBUS_IO_AREA_DISCRETE_INPUTS = 'MODBUS_IO_AREA_DISCRETE_INPUTS'
    MODBUS_IO_AREA_HOLDING_REGISTERS = 'MODBUS_IO_AREA_HOLDING_REGISTERS'
    MODBUS_IO_AREA_INPUT_REGISTERS = 'MODBUS_IO_AREA_INPUT_REGISTERS'


class ModbusIOData(BaseModel):
    description: str
    """
    Descriptive name or note for the input/output variable.

    """
    address: Annotated[int, Field(ge=0, le=65535)]
    """
    The byte address of the input/output variable in the MODBUS device, e.g., NOVA's MODBUS service.
    Used to locate the input/output variable within the device's memory or data structure.

    """
    type: ModbusIOTypeEnum
    byte_order: ModbusIOByteOrder
    """
    The byte sequence of the input/output variable, indicating the order of bytes in memory for the MODBUS device, e.g., NOVA's MODBUS service.

    """
    area: ModbusIOArea
    """
    The area of the input/output variable, indicating the memory region it belongs to for the MODBUS device, e.g., NOVA's MODBUS service.

    """


class ModbusIO(ModbusIOData):
    io: str
    """
    The unique identifier for the input/output value.
    Used to reference the input/output variable in the MODBUS device, e.g., NOVA's MODBUS service.

    """


class ModbusIOs(RootModel):
    """
    Array of MODBUS input/output variable configurations.
    """

    root: list[ModbusIO]
    """
    Array of MODBUS input/output variable configurations.
    """

    def __getitem__(self, index: int) -> ModbusIO:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: ModbusIO) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


class ApiVersion(BaseModel):
    version: str
    """
    The version of the API.
    """


class ConfigurationResource(BaseModel):
    """
    Configuration resource object.
    """

    id: ConfigurationResourceId
    name: str
    """
    Human-readable name of the configuration resource.
    """
    children: ConfigurationResourceArray | None = None


class ConfigurationResourceArray(RootModel):
    """
    Array of configuration resources.
    """

    root: list[ConfigurationResource]
    """
    Array of configuration resources.
    """

    def __getitem__(self, index: int) -> ConfigurationResource:
        """
        Make list RootModel directly indexable.
        """
        return self.root[index]

    def __setitem__(self, index: int, value: ConfigurationResource) -> None:
        """
        Make list RootModel directly indexable.
        """
        self.root[index] = value

    def __len__(self) -> int:
        """
        Make list RootModel directly usable with len().
        """
        return len(self.root)

    def __iter__(self):
        """
        Make list RootModel directly iterable.
        """
        return iter(self.root)


ConfigurationResource.model_rebuild()
