# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.models.execution_result import ExecutionResult
from wandelbots_api_client.models.program_run_state import ProgramRunState
from wandelbots_api_client.models.store_value import StoreValue
from typing import Optional, Set
from typing_extensions import Self

class ProgramRun(BaseModel):
    """
    ProgramRun
    """ # noqa: E501
    id: StrictStr 
    state: ProgramRunState 
    logs: Optional[StrictStr] = '' 
    stdout: Optional[StrictStr] = '' 
    store: Optional[Dict[str, StoreValue]] = None 
    error: Optional[StrictStr] = None 
    traceback: Optional[StrictStr] = None 
    start_time: Optional[Union[StrictFloat, StrictInt]] = None 
    end_time: Optional[Union[StrictFloat, StrictInt]] = None 
    execution_results: Optional[List[ExecutionResult]] = None 
    __properties: ClassVar[List[str]] = ["id", "state", "logs", "stdout", "store", "error", "traceback", "start_time", "end_time", "execution_results"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in store (dict)
        # >>> Modified from openapi template
        if self.store:
            _field_dict = {}
            for _key, _value in self.store.items():
                if self.store[_key]:
                    _field_dict[_key] = _value.to_dict()
            _dict['store'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in execution_results (list)
        _items = []
        if self.execution_results:
            for _item in self.execution_results:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['execution_results'] = _items
        # set to None if error (nullable) is None
        # and model_fields_set contains the field
        if self.error is None and "error" in self.model_fields_set:
            _dict['error'] = None

        # set to None if traceback (nullable) is None
        # and model_fields_set contains the field
        if self.traceback is None and "traceback" in self.model_fields_set:
            _dict['traceback'] = None

        # set to None if start_time (nullable) is None
        # and model_fields_set contains the field
        if self.start_time is None and "start_time" in self.model_fields_set:
            _dict['start_time'] = None

        # set to None if end_time (nullable) is None
        # and model_fields_set contains the field
        if self.end_time is None and "end_time" in self.model_fields_set:
            _dict['end_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "state": obj.get("state"),
            "logs": obj.get("logs") if obj.get("logs") is not None else '',
            "stdout": obj.get("stdout") if obj.get("stdout") is not None else '',
            "store": dict(
                (_k, StoreValue.from_dict(_v))
                for _k, _v in obj["store"].items()
            )
            if obj.get("store") is not None
            else None,
            "error": obj.get("error"),
            "traceback": obj.get("traceback"),
            "start_time": obj.get("start_time"),
            "end_time": obj.get("end_time"),
            "execution_results": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                ExecutionResult.from_dict(_item) if hasattr(ExecutionResult, 'from_dict') else _item
                # <<< End modification
                for _item in obj["execution_results"]
            ] if obj.get("execution_results") is not None else None
        })
        return _obj


