# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.2.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.trajectory_ended import TrajectoryEnded
from wandelbots_api_client.v2.models.trajectory_paused_by_user import TrajectoryPausedByUser
from wandelbots_api_client.v2.models.trajectory_paused_on_io import TrajectoryPausedOnIO
from wandelbots_api_client.v2.models.trajectory_running import TrajectoryRunning
from wandelbots_api_client.v2.models.trajectory_wait_for_io import TrajectoryWaitForIO
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

TRAJECTORYDETAILSSTATE_ONE_OF_SCHEMAS = ["TrajectoryEnded", "TrajectoryPausedByUser", "TrajectoryPausedOnIO", "TrajectoryRunning", "TrajectoryWaitForIO"]

class TrajectoryDetailsState(BaseModel):
    """
    TrajectoryDetailsState
    """
    # data type: TrajectoryRunning
    oneof_schema_1_validator: Optional[TrajectoryRunning] = None
    # data type: TrajectoryPausedByUser
    oneof_schema_2_validator: Optional[TrajectoryPausedByUser] = None
    # data type: TrajectoryEnded
    oneof_schema_3_validator: Optional[TrajectoryEnded] = None
    # data type: TrajectoryWaitForIO
    oneof_schema_4_validator: Optional[TrajectoryWaitForIO] = None
    # data type: TrajectoryPausedOnIO
    oneof_schema_5_validator: Optional[TrajectoryPausedOnIO] = None
    actual_instance: Optional[Union[TrajectoryEnded, TrajectoryPausedByUser, TrajectoryPausedOnIO, TrajectoryRunning, TrajectoryWaitForIO]] = None
    one_of_schemas: Set[str] = { "TrajectoryEnded", "TrajectoryPausedByUser", "TrajectoryPausedOnIO", "TrajectoryRunning", "TrajectoryWaitForIO" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = TrajectoryDetailsState.model_construct()
        error_messages = []
        match = 0
        # validate data type: TrajectoryRunning
        if not isinstance(v, TrajectoryRunning):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TrajectoryRunning`")
        else:
            match += 1
        # validate data type: TrajectoryPausedByUser
        if not isinstance(v, TrajectoryPausedByUser):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TrajectoryPausedByUser`")
        else:
            match += 1
        # validate data type: TrajectoryEnded
        if not isinstance(v, TrajectoryEnded):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TrajectoryEnded`")
        else:
            match += 1
        # validate data type: TrajectoryWaitForIO
        if not isinstance(v, TrajectoryWaitForIO):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TrajectoryWaitForIO`")
        else:
            match += 1
        # validate data type: TrajectoryPausedOnIO
        if not isinstance(v, TrajectoryPausedOnIO):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TrajectoryPausedOnIO`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in TrajectoryDetailsState with oneOf schemas: TrajectoryEnded, TrajectoryPausedByUser, TrajectoryPausedOnIO, TrajectoryRunning, TrajectoryWaitForIO. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in TrajectoryDetailsState with oneOf schemas: TrajectoryEnded, TrajectoryPausedByUser, TrajectoryPausedOnIO, TrajectoryRunning, TrajectoryWaitForIO. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("kind")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `kind` in the input.")

        # check if data type is `TrajectoryEnded`
        if _data_type == "END_OF_TRAJECTORY":
            instance.actual_instance = TrajectoryEnded.from_json(json_str)
            return instance

        # check if data type is `TrajectoryPausedByUser`
        if _data_type == "PAUSED_BY_USER":
            instance.actual_instance = TrajectoryPausedByUser.from_json(json_str)
            return instance

        # check if data type is `TrajectoryPausedOnIO`
        if _data_type == "PAUSED_ON_IO":
            instance.actual_instance = TrajectoryPausedOnIO.from_json(json_str)
            return instance

        # check if data type is `TrajectoryRunning`
        if _data_type == "RUNNING":
            instance.actual_instance = TrajectoryRunning.from_json(json_str)
            return instance

        # check if data type is `TrajectoryWaitForIO`
        if _data_type == "WAIT_FOR_IO":
            instance.actual_instance = TrajectoryWaitForIO.from_json(json_str)
            return instance

        # deserialize data into TrajectoryRunning
        try:
            instance.actual_instance = TrajectoryRunning.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TrajectoryPausedByUser
        try:
            instance.actual_instance = TrajectoryPausedByUser.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TrajectoryEnded
        try:
            instance.actual_instance = TrajectoryEnded.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TrajectoryWaitForIO
        try:
            instance.actual_instance = TrajectoryWaitForIO.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TrajectoryPausedOnIO
        try:
            instance.actual_instance = TrajectoryPausedOnIO.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into TrajectoryDetailsState with oneOf schemas: TrajectoryEnded, TrajectoryPausedByUser, TrajectoryPausedOnIO, TrajectoryRunning, TrajectoryWaitForIO. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into TrajectoryDetailsState with oneOf schemas: TrajectoryEnded, TrajectoryPausedByUser, TrajectoryPausedOnIO, TrajectoryRunning, TrajectoryWaitForIO. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], TrajectoryEnded, TrajectoryPausedByUser, TrajectoryPausedOnIO, TrajectoryRunning, TrajectoryWaitForIO]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


