# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ProfinetInputOutputConfig(BaseModel):
    """
    ProfinetInputOutputConfig
    """ # noqa: E501
    config: StrictStr = Field(description="Content of the input/output variable configuration XML file. The XML File has to be embedded as a string by escaping quotes, line breaks and so forth. ") 
    input_offset: Annotated[int, Field(le=2147483647, strict=True, ge=0)] = Field(description="Offset in bytes for the address of the input (perspective of the controller) variables. The offset will be subtracted from to the byte addresses of the sent XML content.") 
    output_offset: Annotated[int, Field(le=2147483647, strict=True, ge=0)] = Field(description="Offset in bytes for the address of the output (perspective of the controller) variables. The offset will be subtracted from to the byte addresses of the sent XML content.") 
    __properties: ClassVar[List[str]] = ["config", "input_offset", "output_offset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProfinetInputOutputConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProfinetInputOutputConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "config": obj.get("config"),
            "input_offset": obj.get("input_offset") if obj.get("input_offset") is not None else 0,
            "output_offset": obj.get("output_offset") if obj.get("output_offset") is not None else 0
        })
        return _obj


