# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class JointJoggingRequest(BaseModel):
    """
    A request to move the joints of a motion group.
    """ # noqa: E501
    motion_group: StrictStr = Field(description="Identifier of the motion group.") 
    joint_velocities: List[Union[StrictFloat, StrictInt]] = Field(description="in [rad/s]") 
    tcp: Optional[Any] = None 
    response_rate: Optional[StrictInt] = Field(default=None, description="Update rate for the response message in ms. If not set 200ms are used.") 
    response_coordinate_system: Optional[StrictStr] = Field(default=None, description="Unique identifier addressing a coordinate system in which the responses should be converted. If not set, world coordinate system is used. ") 
    __properties: ClassVar[List[str]] = ["motion_group", "joint_velocities", "tcp", "response_rate", "response_coordinate_system"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JointJoggingRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tcp (nullable) is None
        # and model_fields_set contains the field
        if self.tcp is None and "tcp" in self.model_fields_set:
            _dict['tcp'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JointJoggingRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group": obj.get("motion_group"),
            "joint_velocities": obj.get("joint_velocities"),
            "tcp": obj.get("tcp"),
            "response_rate": obj.get("response_rate"),
            "response_coordinate_system": obj.get("response_coordinate_system")
        })
        return _obj


