# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.license_status import LicenseStatus
from typing import Optional, Set
from typing_extensions import Self

class License(BaseModel):
    """
    License
    """ # noqa: E501
    product_name: StrictStr = Field(description="Name of the licensed product.") 
    owner_email: StrictStr = Field(description="Mail address of the license owner.") 
    license_key: StrictStr = Field(description="Identification key of the license.") 
    license_expiry_date: Optional[date] = Field(default=None, description="Expiration date of the license.") 
    grace_period_expiry_date: datetime = Field(description="End date of grace period, given if instance is not connected to internet.") 
    consumed_activations: StrictInt = Field(description="Amount of times the license was activated.") 
    allowed_activations: StrictInt = Field(description="Amount of times the license can be activated.") 
    feature_limitations: Optional[Dict[str, StrictInt]] = Field(default=None, description="Feature limitations of the license.") 
    feature_flags: Optional[List[StrictStr]] = Field(default=None, description="Features enabled by a license.") 
    status: LicenseStatus 
    __properties: ClassVar[List[str]] = ["product_name", "owner_email", "license_key", "license_expiry_date", "grace_period_expiry_date", "consumed_activations", "allowed_activations", "feature_limitations", "feature_flags", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of License from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of License from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "product_name": obj.get("product_name"),
            "owner_email": obj.get("owner_email"),
            "license_key": obj.get("license_key"),
            "license_expiry_date": obj.get("license_expiry_date"),
            "grace_period_expiry_date": obj.get("grace_period_expiry_date"),
            "consumed_activations": obj.get("consumed_activations"),
            "allowed_activations": obj.get("allowed_activations"),
            "feature_limitations": obj.get("feature_limitations"),
            "feature_flags": obj.get("feature_flags"),
            "status": LicenseStatus.from_dict(obj["status"]) if obj.get("status") is not None else None
        })
        return _obj


