# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class NetworkState(BaseModel):
    """
    NetworkState
    """ # noqa: E501
    internet_connected: StrictBool = Field(description="Indicates whether the system is connected to the internet. ") 
    connection_type: Optional[StrictStr] = Field(default=None, description="Type of the active network link (e.g., ethernet, wifi, cellular, vpn, unknown). ") 
    signal_strength: Optional[StrictInt] = Field(default=None, description="Received signal strength in dBm for wireless interfaces; negative values indicate weaker signals. ") 
    link_quality: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=None, description="Normalized link quality metric from 0 (poor) to 1 (excellent) when provided by the interface. ") 
    latency_ms: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Round-trip latency to the probe endpoint measured in milliseconds. ") 
    bandwidth_mbps: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Estimated downstream bandwidth in megabits per second based on the probe. ") 
    __properties: ClassVar[List[str]] = ["internet_connected", "connection_type", "signal_strength", "link_quality", "latency_ms", "bandwidth_mbps"]

    @field_validator('connection_type')
    def connection_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ethernet', 'wifi', 'cellular', 'vpn', 'unknown']):
            raise ValueError("must be one of enum values ('ethernet', 'wifi', 'cellular', 'vpn', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "internet_connected": obj.get("internet_connected"),
            "connection_type": obj.get("connection_type"),
            "signal_strength": obj.get("signal_strength"),
            "link_quality": obj.get("link_quality"),
            "latency_ms": obj.get("latency_ms"),
            "bandwidth_mbps": obj.get("bandwidth_mbps")
        })
        return _obj


