# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.joint_trajectory import JointTrajectory
from typing import Optional, Set
from typing_extensions import Self

class TrajectoryData(BaseModel):
    """
    TrajectoryData
    """ # noqa: E501
    message_type: str = "TrajectoryData"
    motion_group: Optional[StrictStr] = Field(default=None, description="Identifier of the motion-group.") 
    data: JointTrajectory = Field(description="The trajectory consisting of a list of joint positions and an equal number of corresponding timestamps. ") 
    tcp: Optional[StrictStr] = Field(default=None, description="Unique identifier of the tool the trajectory is planned for.") 
    __properties: ClassVar[List[str]] = ["message_type", "motion_group", "data", "tcp"]

    @field_validator('message_type')
    def message_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['TrajectoryData']):
            raise ValueError("must be one of enum values ('TrajectoryData')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrajectoryData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrajectoryData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message_type": obj.get("message_type"),
            "motion_group": obj.get("motion_group"),
            "data": JointTrajectory.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "tcp": obj.get("tcp")
        })
        return _obj


