# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.move_response import MoveResponse
from wandelbots_api_client.models.robot_controller_state import RobotControllerState
from wandelbots_api_client.models.stop_response import StopResponse
from typing import Optional, Set
from typing_extensions import Self

class StreamMoveResponse(BaseModel):
    """
    The stream will return MoveResponse repeatedly as long as defined in `response_rate` until the movement is completed. Finally, a single StopResponse is returned and the stream is closed.
    """ # noqa: E501
    move_response: Optional[MoveResponse] = Field(default=None, description="This field is filled during the movement.") 
    stop_response: Optional[StopResponse] = Field(default=None, description="This field is filled when the movement is finished. It is the final response") 
    state: Optional[RobotControllerState] = Field(default=None, description="The current state of the robot controller and motion group in motion.") 
    __properties: ClassVar[List[str]] = ["move_response", "stop_response", "state"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StreamMoveResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of move_response
        if self.move_response:
            _dict['move_response'] = self.move_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stop_response
        if self.stop_response:
            _dict['stop_response'] = self.stop_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StreamMoveResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "move_response": MoveResponse.from_dict(obj["move_response"]) if obj.get("move_response") is not None else None,
            "stop_response": StopResponse.from_dict(obj["stop_response"]) if obj.get("stop_response") is not None else None,
            "state": RobotControllerState.from_dict(obj["state"]) if obj.get("state") is not None else None
        })
        return _obj


