# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel  
from typing import Dict, List



class QueryAdaptiveProtectionRulesRequest(TeaModel):
    def __init__(
        self,
        domains: List[str] = None,
    ):
        # {"en":"domain list", "zh_CN":"域名数组"}
        self.domains = domains

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['domains'] = self.domains
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        return self


class QueryAdaptiveProtectionRulesResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: List[str] = None,
        domain: str = None,
        rule_id: str = None,
        rule_name_cn: str = None,
        rule_name_en: str = None,
        rule_switch: str = None,
        create_time: str = None,
    ):
        # {"en":"code", "zh_CN":"状态码"}
        self.code = code
        # {"en":"msg", "zh_CN":"描述信息"}
        self.msg = msg
        # {"en":"data", "zh_CN":"data"}
        self.data = data
        # {"en":"domain", "zh_CN":"域名"}
        self.domain = domain
        # {"en":"ruleId", "zh_CN":"规则ID"}
        self.rule_id = rule_id
        # {"en":"Chinese Rule Name", "zh_CN":"中文规则名称"}
        self.rule_name_cn = rule_name_cn
        # {"en":"English Rule Name", "zh_CN":"英文规则名称"}
        self.rule_name_en = rule_name_en
        # {"en":"AI rule switch, ON/OFF", "zh_CN":"AI规则开关，ON/OFF"}
        self.rule_switch = rule_switch
        # {"en":"create time", "zh_CN":"生成时间"}
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.rule_name_cn, 'rule_name_cn')
        self.validate_required(self.rule_name_en, 'rule_name_en')
        self.validate_required(self.rule_switch, 'rule_switch')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.rule_name_cn is not None:
            result['ruleNameCn'] = self.rule_name_cn
        if self.rule_name_en is not None:
            result['ruleNameEn'] = self.rule_name_en
        if self.rule_switch is not None:
            result['ruleSwitch'] = self.rule_switch
        if self.create_time is not None:
            result['createTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('ruleNameCn') is not None:
            self.rule_name_cn = m.get('ruleNameCn')
        if m.get('ruleNameEn') is not None:
            self.rule_name_en = m.get('ruleNameEn')
        if m.get('ruleSwitch') is not None:
            self.rule_switch = m.get('ruleSwitch')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        return self


class QueryAdaptiveProtectionRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAdaptiveProtectionRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAdaptiveProtectionRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class QueryAdaptiveProtectionRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteBuiltInRuleRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # {'en':'Template id', 'zh_CN':'模板id'}
        self.id = id

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class DeleteBuiltInRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class DeleteBuiltInRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteBuiltInRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteBuiltInRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteBuiltInRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListIPBlockSettingsRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {"en":"Hostname list.", "zh_CN":"域名列表。"}
        self.domain_list = domain_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class ListIPBlockSettingsIPBlock(TeaModel):
    def __init__(
        self,
        domain: str = None,
        block_conditions: List[str] = None,
    ):
        # {"en":"Hostname.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"The blocked IP/CIDR.", "zh_CN":"已拦截的IP/IP段。"}
        self.block_conditions = block_conditions

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.block_conditions, 'block_conditions')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.block_conditions is not None:
            result['blockConditions'] = self.block_conditions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('blockConditions') is not None:
            self.block_conditions = m.get('blockConditions')
        return self


class ListIPBlockSettingsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListIPBlockSettingsIPBlock] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"出参数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListIPBlockSettingsIPBlock()
                self.data.append(temp_model.from_map(k))
        return self


class ListIPBlockSettingsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListIPBlockSettingsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListIPBlockSettingsRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListIPBlockSettingsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UsingSystemRecommendedAccessDomainWafConfig(TeaModel):
    def __init__(
        self,
        rule_update_mode: str = None,
        config_switch: str = None,
        defend_mode: str = None,
    ):
        # {"en":"Ruleset pattern. 
        # MANUAL: Manual
        # AUTO: Automatic ", "zh_CN":"规则集模式。 
        # MANUAL：手动
        # AUTO：自动"}
        self.rule_update_mode = rule_update_mode
        # {"en":"WAF protection switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"WAF防护开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch
        # {"en":"WAF protection Mode.
        # BLOCK: Interception
        # LOG: Observation", "zh_CN":"WAF防护模式。 
        # BLOCK：拦截 
        # LOG：观察"}
        self.defend_mode = defend_mode

    def validate(self):
        self.validate_required(self.rule_update_mode, 'rule_update_mode')
        self.validate_required(self.config_switch, 'config_switch')
        self.validate_required(self.defend_mode, 'defend_mode')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_update_mode is not None:
            result['ruleUpdateMode'] = self.rule_update_mode
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        if self.defend_mode is not None:
            result['defendMode'] = self.defend_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleUpdateMode') is not None:
            self.rule_update_mode = m.get('ruleUpdateMode')
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        if m.get('defendMode') is not None:
            self.defend_mode = m.get('defendMode')
        return self


class UsingSystemRecommendedAccessDomainCustomizeRuleConfig(TeaModel):
    def __init__(
        self,
        config_switch: str = None,
    ):
        # {"en":"Custom rules switch.
        # ON: Enabled
        # OFF: Disabel", "zh_CN":"自定义规则开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch

    def validate(self):
        self.validate_required(self.config_switch, 'config_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        return self


class UsingSystemRecommendedAccessDomainAPIDefendConfig(TeaModel):
    def __init__(
        self,
        config_switch: str = None,
    ):
        # {"en":"API security switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"API安全开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch

    def validate(self):
        self.validate_required(self.config_switch, 'config_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        return self


class UsingSystemRecommendedAccessDomainWhitelistConfig(TeaModel):
    def __init__(
        self,
        config_switch: str = None,
    ):
        # {"en":"Whitelist switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"白名单开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch

    def validate(self):
        self.validate_required(self.config_switch, 'config_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        return self


class UsingSystemRecommendedAccessDomainBlockConfig(TeaModel):
    def __init__(
        self,
        config_switch: str = None,
    ):
        # {"en":"IP/Geo switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"IP/区域封禁开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch

    def validate(self):
        self.validate_required(self.config_switch, 'config_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        return self


class UsingSystemRecommendedAccessDomainDMSConfig(TeaModel):
    def __init__(
        self,
        config_switch: str = None,
        protection_mode: str = None,
    ):
        # {"en":"DDoS protection switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"DDoS防护开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch
        # {"en":"DDoS protection mode.
        # AI_DEPOSIT: Managed Auto-Protect
        # UNDER_ATTACK: I'm Under Attack", "zh_CN":"DDoS防护模式。 
        # AI_DEPOSIT：智能托管 
        # UNDER_ATTACK：我受到攻击"}
        self.protection_mode = protection_mode

    def validate(self):
        self.validate_required(self.config_switch, 'config_switch')
        self.validate_required(self.protection_mode, 'protection_mode')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        if self.protection_mode is not None:
            result['protectionMode'] = self.protection_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        if m.get('protectionMode') is not None:
            self.protection_mode = m.get('protectionMode')
        return self


class UsingSystemRecommendedAccessDomainAttackRiskType(TeaModel):
    def __init__(
        self,
        attack_source: str = None,
        spec_attack: str = None,
        industry: str = None,
    ):
        # {"en":"Attack resource risk action.
        # NO_USE: Not used
        # BLOCK: Deny
        # LOG: Log", "zh_CN":"攻击资源风险处理动作。
        # NO_USE：不使用
        # BLOCK：拦截
        # LOG：监控"}
        self.attack_source = attack_source
        # {"en":"Specific attack risk action.
        # NO_USE: Not used
        # BLOCK: Deny
        # LOG:Log", "zh_CN":"特定攻击风险处理动作。
        # NO_USE：不使用
        # BLOCK：拦截
        # LOG：监控"}
        self.spec_attack = spec_attack
        # {"en":"Industry attack risk action.
        # NO_USE: Not used
        # BLOCK: Deny
        # LOG: Log", "zh_CN":"重点行业风险处理动作。
        # NO_USE：不使用
        # BLOCK：拦截
        # LOG：监控"}
        self.industry = industry

    def validate(self):
        self.validate_required(self.attack_source, 'attack_source')
        self.validate_required(self.spec_attack, 'spec_attack')
        self.validate_required(self.industry, 'industry')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_source is not None:
            result['attackSource'] = self.attack_source
        if self.spec_attack is not None:
            result['specAttack'] = self.spec_attack
        if self.industry is not None:
            result['industry'] = self.industry
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attackSource') is not None:
            self.attack_source = m.get('attackSource')
        if m.get('specAttack') is not None:
            self.spec_attack = m.get('specAttack')
        if m.get('industry') is not None:
            self.industry = m.get('industry')
        return self


class UsingSystemRecommendedAccessDomainIntelligenceConfig(TeaModel):
    def __init__(
        self,
        info_cate_act: UsingSystemRecommendedAccessDomainAttackRiskType = None,
        config_switch: str = None,
    ):
        # {"en":"Attack risk type action.", "zh_CN":"攻击风险类型处理动作。"}
        self.info_cate_act = info_cate_act
        # {"en":"Threat intelligence switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"威胁情报开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch

    def validate(self):
        self.validate_required(self.info_cate_act, 'info_cate_act')
        if self.info_cate_act:
            self.info_cate_act.validate()
        self.validate_required(self.config_switch, 'config_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info_cate_act is not None:
            result['infoCateAct'] = self.info_cate_act.to_map()
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('infoCateAct') is not None:
            temp_model = UsingSystemRecommendedAccessDomainAttackRiskType()
            self.info_cate_act = temp_model.from_map(m['infoCateAct'])
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        return self


class UsingSystemRecommendedAccessDomainBotWebConfigDefault(TeaModel):
    def __init__(
        self,
        act: str = None,
    ):
        # {"en":"Action.
        # NO_USE: Not used
        # BLOCK: Deny
        # LOG: Log", "zh_CN":"处理动作。
        # NO_USE:不使用
        # BLOCK:拦截
        # LOG:监控"}
        self.act = act

    def validate(self):
        self.validate_required(self.act, 'act')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.act is not None:
            result['act'] = self.act
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('act') is not None:
            self.act = m.get('act')
        return self


class UsingSystemRecommendedAccessDomainBOTConfig(TeaModel):
    def __init__(
        self,
        public_bots_act: str = None,
        config_switch: str = None,
        ua_bots_act: str = None,
        web_risk_config: UsingSystemRecommendedAccessDomainBotWebConfigDefault = None,
        scene_analyse_switch: str = None,
    ):
        # {"en":"Known Bots action.
        # NO_USE: not used
        # BLOCK: Deny
        # LOG: Log
        # ACCEPT: Skip", "zh_CN":"已知Bot处理动作。
        # NO_USE：不使用
        # BLOCK：拦截
        # LOG：监控
        # ACCEPT：放行"}
        self.public_bots_act = public_bots_act
        # {"en":"Bot management switch.
        # ON:Enabled
        # OFF:Disabled", "zh_CN":"Bot管理开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch
        # {"en":"User-Agent based detection action.
        # NO_USE: Not used
        # BLOCK: Deny
        # LOG: Log
        # ACCEPT: Skip", "zh_CN":"User-Agent特征检测处理动作。
        # NO_USE：不使用
        # BLOCK：拦截
        # LOG：监控
        # ACCEPT：放行"}
        self.ua_bots_act = ua_bots_act
        # {"en":"Browser Bot defense.", "zh_CN":"Web风险检测。"}
        self.web_risk_config = web_risk_config
        # {"en":"Client-based detection function switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"客户端风险检测功能开关。
        # ON：开启
        # OFF：关闭"}
        self.scene_analyse_switch = scene_analyse_switch

    def validate(self):
        self.validate_required(self.public_bots_act, 'public_bots_act')
        self.validate_required(self.config_switch, 'config_switch')
        self.validate_required(self.ua_bots_act, 'ua_bots_act')
        self.validate_required(self.web_risk_config, 'web_risk_config')
        if self.web_risk_config:
            self.web_risk_config.validate()
        self.validate_required(self.scene_analyse_switch, 'scene_analyse_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.public_bots_act is not None:
            result['publicBotsAct'] = self.public_bots_act
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        if self.ua_bots_act is not None:
            result['uaBotsAct'] = self.ua_bots_act
        if self.web_risk_config is not None:
            result['webRiskConfig'] = self.web_risk_config.to_map()
        if self.scene_analyse_switch is not None:
            result['sceneAnalyseSwitch'] = self.scene_analyse_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('publicBotsAct') is not None:
            self.public_bots_act = m.get('publicBotsAct')
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        if m.get('uaBotsAct') is not None:
            self.ua_bots_act = m.get('uaBotsAct')
        if m.get('webRiskConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainBotWebConfigDefault()
            self.web_risk_config = temp_model.from_map(m['webRiskConfig'])
        if m.get('sceneAnalyseSwitch') is not None:
            self.scene_analyse_switch = m.get('sceneAnalyseSwitch')
        return self


class UsingSystemRecommendedAccessDomainRateLimitConfig(TeaModel):
    def __init__(
        self,
        config_switch: str = None,
    ):
        # {"en":"Rate limiting switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"频率限制开关。
        # ON：开启
        # OFF：关闭"}
        self.config_switch = config_switch

    def validate(self):
        self.validate_required(self.config_switch, 'config_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_switch is not None:
            result['configSwitch'] = self.config_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configSwitch') is not None:
            self.config_switch = m.get('configSwitch')
        return self


class UsingSystemRecommendedAccessDomainRequest(TeaModel):
    def __init__(
        self,
        waf_defend_config: UsingSystemRecommendedAccessDomainWafConfig = None,
        customize_rule_config: UsingSystemRecommendedAccessDomainCustomizeRuleConfig = None,
        api_defend_config: UsingSystemRecommendedAccessDomainAPIDefendConfig = None,
        whitelist_config: UsingSystemRecommendedAccessDomainWhitelistConfig = None,
        target_domains: List[str] = None,
        block_config: UsingSystemRecommendedAccessDomainBlockConfig = None,
        dms_defend_config: UsingSystemRecommendedAccessDomainDMSConfig = None,
        intelligence_config: UsingSystemRecommendedAccessDomainIntelligenceConfig = None,
        bot_manage_config: UsingSystemRecommendedAccessDomainBOTConfig = None,
        rate_limit_config: UsingSystemRecommendedAccessDomainRateLimitConfig = None,
    ):
        # {"en":"WAF.", "zh_CN":"WAF。"}
        self.waf_defend_config = waf_defend_config
        # {"en":"Custom rules.", "zh_CN":"自定义规则。"}
        self.customize_rule_config = customize_rule_config
        # {"en":"API security.", "zh_CN":"API安全。"}
        self.api_defend_config = api_defend_config
        # {"en":"Whitelist.", "zh_CN":"白名单。"}
        self.whitelist_config = whitelist_config
        # {"en":"Hostnames to be accessed.", "zh_CN":"目标域名。"}
        self.target_domains = target_domains
        # {"en":"IP/Geo blocking.", "zh_CN":"IP/区域封禁。"}
        self.block_config = block_config
        # {"en":"DDoS protection.", "zh_CN":"DDoS防护。"}
        self.dms_defend_config = dms_defend_config
        # {"en":"Threat intelligence.", "zh_CN":"威胁情报。"}
        self.intelligence_config = intelligence_config
        # {"en":"Bot management.", "zh_CN":"Bot管理。"}
        self.bot_manage_config = bot_manage_config
        # {"en":"Rate limiting.", "zh_CN":"频率限制。"}
        self.rate_limit_config = rate_limit_config

    def validate(self):
        if self.waf_defend_config:
            self.waf_defend_config.validate()
        if self.customize_rule_config:
            self.customize_rule_config.validate()
        if self.api_defend_config:
            self.api_defend_config.validate()
        if self.whitelist_config:
            self.whitelist_config.validate()
        self.validate_required(self.target_domains, 'target_domains')
        if self.block_config:
            self.block_config.validate()
        if self.dms_defend_config:
            self.dms_defend_config.validate()
        if self.intelligence_config:
            self.intelligence_config.validate()
        if self.bot_manage_config:
            self.bot_manage_config.validate()
        if self.rate_limit_config:
            self.rate_limit_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.waf_defend_config is not None:
            result['wafDefendConfig'] = self.waf_defend_config.to_map()
        if self.customize_rule_config is not None:
            result['customizeRuleConfig'] = self.customize_rule_config.to_map()
        if self.api_defend_config is not None:
            result['apiDefendConfig'] = self.api_defend_config.to_map()
        if self.whitelist_config is not None:
            result['whitelistConfig'] = self.whitelist_config.to_map()
        if self.target_domains is not None:
            result['targetDomains'] = self.target_domains
        if self.block_config is not None:
            result['blockConfig'] = self.block_config.to_map()
        if self.dms_defend_config is not None:
            result['dmsDefendConfig'] = self.dms_defend_config.to_map()
        if self.intelligence_config is not None:
            result['intelligenceConfig'] = self.intelligence_config.to_map()
        if self.bot_manage_config is not None:
            result['botManageConfig'] = self.bot_manage_config.to_map()
        if self.rate_limit_config is not None:
            result['rateLimitConfig'] = self.rate_limit_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('wafDefendConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainWafConfig()
            self.waf_defend_config = temp_model.from_map(m['wafDefendConfig'])
        if m.get('customizeRuleConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainCustomizeRuleConfig()
            self.customize_rule_config = temp_model.from_map(m['customizeRuleConfig'])
        if m.get('apiDefendConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainAPIDefendConfig()
            self.api_defend_config = temp_model.from_map(m['apiDefendConfig'])
        if m.get('whitelistConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainWhitelistConfig()
            self.whitelist_config = temp_model.from_map(m['whitelistConfig'])
        if m.get('targetDomains') is not None:
            self.target_domains = m.get('targetDomains')
        if m.get('blockConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainBlockConfig()
            self.block_config = temp_model.from_map(m['blockConfig'])
        if m.get('dmsDefendConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainDMSConfig()
            self.dms_defend_config = temp_model.from_map(m['dmsDefendConfig'])
        if m.get('intelligenceConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainIntelligenceConfig()
            self.intelligence_config = temp_model.from_map(m['intelligenceConfig'])
        if m.get('botManageConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainBOTConfig()
            self.bot_manage_config = temp_model.from_map(m['botManageConfig'])
        if m.get('rateLimitConfig') is not None:
            temp_model = UsingSystemRecommendedAccessDomainRateLimitConfig()
            self.rate_limit_config = temp_model.from_map(m['rateLimitConfig'])
        return self


class UsingSystemRecommendedAccessDomainResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UsingSystemRecommendedAccessDomainPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UsingSystemRecommendedAccessDomainParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UsingSystemRecommendedAccessDomainRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UsingSystemRecommendedAccessDomainResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditAndActiveApiAuthConfig(TeaModel):
    def __init__(
        self,
        auth_param_name: str = None,
        auth_param_site: str = None,
        auth_type: str = None,
        auth_validity_time: int = None,
    ):
        # {"en":"Authentication parameter name,default value: authKey.", "zh_CN":"鉴权参数名称，默认值：authKey。"}
        self.auth_param_name = auth_param_name
        # {"en":"Authentication parameter location,default value:1.
        # 1:HTTP header
        # 2:Query string
        # 3:Cookie", "zh_CN":"鉴权参数位置，默认值：1。
        # 1：HTTP header
        # 2：Query string
        # 3：Cookie"}
        self.auth_param_site = auth_param_site
        # {"en":"Authentication method,default value:1.
        # 1:No auth
        # 2:Auth by  wangsu Secret Key.", "zh_CN":"鉴权方法，默认值：1。
        # 1：免鉴权
        # 2：网宿秘钥对鉴权"}
        self.auth_type = auth_type
        # {"en":"Authentication validity time(seconds), default value:8.", "zh_CN":"鉴权有效期（s），默认值：8。"}
        self.auth_validity_time = auth_validity_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_param_name is not None:
            result['authParamName'] = self.auth_param_name
        if self.auth_param_site is not None:
            result['authParamSite'] = self.auth_param_site
        if self.auth_type is not None:
            result['authType'] = self.auth_type
        if self.auth_validity_time is not None:
            result['authValidityTime'] = self.auth_validity_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authParamName') is not None:
            self.auth_param_name = m.get('authParamName')
        if m.get('authParamSite') is not None:
            self.auth_param_site = m.get('authParamSite')
        if m.get('authType') is not None:
            self.auth_type = m.get('authType')
        if m.get('authValidityTime') is not None:
            self.auth_validity_time = m.get('authValidityTime')
        return self


class EditAndActiveApiSecondChildren(TeaModel):
    def __init__(
        self,
        level: int = None,
        node_require: bool = None,
        max: int = None,
        min: int = None,
        name: str = None,
        enumeration: str = None,
        require: bool = None,
        type: str = None,
    ):
        # {"en":"Json node level(EditAndActiveApiBody is Json must pass).", "zh_CN":"Json节点层级（Body为Json必传）。"}
        self.level = level
        # {"en":"Whether the Json node is required to fill in the option(EditAndActiveApiBody is Json must pass).", "zh_CN":"Json节点是否带必填选项（Body为Json必传）。"}
        self.node_require = node_require
        # {"en":"Maximum.", "zh_CN":"最大值。"}
        self.max = max
        # {"en":"Minimum.", "zh_CN":"最小值。"}
        self.min = min
        # {"en":"Parameter name.", "zh_CN":"参数名称。"}
        self.name = name
        # {"en":"Enumeration.", "zh_CN":"参数枚举值，多个用;分隔。"}
        self.enumeration = enumeration
        # {"en":"Required,default value:false.", "zh_CN":"是否必须，默认值：false。"}
        self.require = require
        # {"en":"Parameter Type.
        # integer:Integer
        # number:Number
        # string:String
        # boolean:Boolean
        # enumeration:Enumerate
        # array:Array
        # object:Json object", "zh_CN":"参数类型。
        # integer：整数
        # number：数字
        # string：字符串
        # boolean：布尔
        # enumeration：枚举
        # array：数组
        # object：Json对象"}
        self.type = type

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.node_require is not None:
            result['nodeRequire'] = self.node_require
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.name is not None:
            result['name'] = self.name
        if self.enumeration is not None:
            result['enumeration'] = self.enumeration
        if self.require is not None:
            result['require'] = self.require
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('nodeRequire') is not None:
            self.node_require = m.get('nodeRequire')
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('enumeration') is not None:
            self.enumeration = m.get('enumeration')
        if m.get('require') is not None:
            self.require = m.get('require')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class EditAndActiveApiChildren(TeaModel):
    def __init__(
        self,
        level: int = None,
        node_require: bool = None,
        max: int = None,
        min: int = None,
        name: str = None,
        enumeration: str = None,
        require: bool = None,
        type: str = None,
        children: List[EditAndActiveApiSecondChildren] = None,
    ):
        # {"en":"Json node level(EditAndActiveApiBody is Json must pass).", "zh_CN":"Json节点层级（Body为Json必传）。"}
        self.level = level
        # {"en":"Whether the Json node is required to fill in the option(EditAndActiveApiBody is Json must pass).", "zh_CN":"Json节点是否带必填选项（Body为Json必传）。"}
        self.node_require = node_require
        # {"en":"Maximum.", "zh_CN":"最大值。"}
        self.max = max
        # {"en":"Minimum.", "zh_CN":"最小值。"}
        self.min = min
        # {"en":"Parameter name.", "zh_CN":"参数名称。"}
        self.name = name
        # {"en":"Enumeration.", "zh_CN":"参数枚举值，多个用;分隔。"}
        self.enumeration = enumeration
        # {"en":"Required,default value:false.", "zh_CN":"是否必须，默认值：false。"}
        self.require = require
        # {"en":"Parameter Type.
        # integer:Integer
        # number:Number
        # string:String
        # boolean:Boolean
        # enumeration:Enumerate
        # array:Array
        # object:Json object", "zh_CN":"参数类型。
        # integer：整数
        # number：数字
        # string：字符串
        # boolean：布尔
        # enumeration：枚举
        # array：数组
        # object：Json对象"}
        self.type = type
        # {"en":"Json sub node array(EditAndActiveApiBody is Json must pass).", "zh_CN":"Json子节点数组，类型为Body（Body为Json必传）。"}
        self.children = children

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.node_require is not None:
            result['nodeRequire'] = self.node_require
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.name is not None:
            result['name'] = self.name
        if self.enumeration is not None:
            result['enumeration'] = self.enumeration
        if self.require is not None:
            result['require'] = self.require
        if self.type is not None:
            result['type'] = self.type
        if self.children is not None:
            result['children'] = []
            for k in self.children:
                result['children'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('nodeRequire') is not None:
            self.node_require = m.get('nodeRequire')
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('enumeration') is not None:
            self.enumeration = m.get('enumeration')
        if m.get('require') is not None:
            self.require = m.get('require')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('children') is not None:
            self.children = []
            for k in m.get('children'):
                temp_model = EditAndActiveApiSecondChildren()
                self.children.append(temp_model.from_map(k))
        return self


class EditAndActiveApiBody(TeaModel):
    def __init__(
        self,
        level: int = None,
        node_require: bool = None,
        max: int = None,
        min: int = None,
        name: str = None,
        enumeration: str = None,
        require: bool = None,
        type: str = None,
        children: List[EditAndActiveApiChildren] = None,
    ):
        # {"en":"Json node level(EditAndActiveApiBody is Json must pass).", "zh_CN":"Json节点层级（Body为Json必传）。"}
        self.level = level
        # {"en":"Whether the Json node is required to fill in the option(EditAndActiveApiBody is Json must pass).", "zh_CN":"Json节点是否带必填选项（Body为Json必传）。"}
        self.node_require = node_require
        # {"en":"Maximum.", "zh_CN":"最大值。"}
        self.max = max
        # {"en":"Minimum.", "zh_CN":"最小值。"}
        self.min = min
        # {"en":"Parameter name.", "zh_CN":"参数名称。"}
        self.name = name
        # {"en":"Enumeration.", "zh_CN":"参数枚举值，多个用;分隔。"}
        self.enumeration = enumeration
        # {"en":"Required,default value:false.", "zh_CN":"是否必须，默认值：false。"}
        self.require = require
        # {"en":"Parameter Type.
        # integer:Integer
        # number:Number
        # string:String
        # boolean:Boolean
        # enumeration:Enumerate
        # array:Array
        # object:Json object", "zh_CN":"参数类型。
        # integer：整数
        # number：数字
        # string：字符串
        # boolean：布尔
        # enumeration：枚举
        # array：数组
        # object：Json对象"}
        self.type = type
        # {"en":"Json sub node array(EditAndActiveApiBody is Json must pass).", "zh_CN":"Json子节点数组，类型为Body（Body为Json必传）。"}
        self.children = children

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.node_require is not None:
            result['nodeRequire'] = self.node_require
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.name is not None:
            result['name'] = self.name
        if self.enumeration is not None:
            result['enumeration'] = self.enumeration
        if self.require is not None:
            result['require'] = self.require
        if self.type is not None:
            result['type'] = self.type
        if self.children is not None:
            result['children'] = []
            for k in self.children:
                result['children'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('nodeRequire') is not None:
            self.node_require = m.get('nodeRequire')
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('enumeration') is not None:
            self.enumeration = m.get('enumeration')
        if m.get('require') is not None:
            self.require = m.get('require')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('children') is not None:
            self.children = []
            for k in m.get('children'):
                temp_model = EditAndActiveApiChildren()
                self.children.append(temp_model.from_map(k))
        return self


class EditAndActiveApiRequestParams(TeaModel):
    def __init__(
        self,
        max: int = None,
        min: int = None,
        name: str = None,
        require: bool = None,
        site: str = None,
        type: str = None,
        value: str = None,
    ):
        # {"en":"Maximum.", "zh_CN":"最大值。"}
        self.max = max
        # {"en":"Minimum.", "zh_CN":"最小值。"}
        self.min = min
        # {"en":"Parameter name.", "zh_CN":"参数名称。"}
        self.name = name
        # {"en":"Required,default value:false.", "zh_CN":"是否必须，默认值：false。"}
        self.require = require
        # {"en":"Parameter position,default value:1.
        # 1: HTTP header
        # 2: Query string,
        # 3: Cookie
        # 4: Path parameter", "zh_CN":"参数位置，默认值：1。
        # 1：HTTP header
        # 2：Query string,
        # 3：Cookie
        # 4：路径参数"}
        self.site = site
        # {"en":"Parameter Type,default value:1.
        # 1:integer
        # 2:number
        # 3:string
        # 4:boolean
        # 5:enumerate", "zh_CN":"参数类型，默认值：1。
        # 1：整数
        # 2：数字
        # 3：字符串
        # 4：布尔
        # 5：枚举"}
        self.type = type
        # {"en":"Parameter enumeration,multiple use \";\" split.", "zh_CN":"参数枚举值，多个用;分隔。"}
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.name is not None:
            result['name'] = self.name
        if self.require is not None:
            result['require'] = self.require
        if self.site is not None:
            result['site'] = self.site
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('require') is not None:
            self.require = m.get('require')
        if m.get('site') is not None:
            self.site = m.get('site')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class EditAndActiveApiParamsLimitConfig(TeaModel):
    def __init__(
        self,
        body: List[EditAndActiveApiBody] = None,
        request_method: str = None,
        request_params: List[EditAndActiveApiRequestParams] = None,
        path_match_type: str = None,
        body_flag: bool = None,
        body_type: str = None,
    ):
        # {"en":"Request body parameter restriction configuration.", "zh_CN":"请求Body参数限制配置。"}
        self.body = body
        # {"en":"Request method,default value:GET.
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE", "zh_CN":"请求方法，默认值：GET。
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE"}
        self.request_method = request_method
        # {"en":"Request parameter.", "zh_CN":"请求参数。"}
        self.request_params = request_params
        # {"en":"Path matching type,Default value:DICT.
        # DICT:Complete matching
        #  REGEX:Regular matching", "zh_CN":"路径匹配类型，默认值：DICT。
        # DICT：完整匹配
        #  REGEX：正则匹配"}
        self.path_match_type = path_match_type
        # {"en":"Whether to define the body parameter,default value:false.", "zh_CN":"是否定义Body参数，默认值：false。"}
        self.body_flag = body_flag
        # {"en":"EditAndActiveApiBody parameter type,default value:FORM.
        # FORM:Form
        # JSON_XML:Json format definition", "zh_CN":"Body参数类型，默认值：FORM。
        # FORM：Form表单
        # JSON_XML：Json格式定义"}
        self.body_type = body_type

    def validate(self):
        if self.body:
            for k in self.body:
                if k:
                    k.validate()
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['body'] = []
            for k in self.body:
                result['body'].append(k.to_map() if k else None)
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        if self.request_params is not None:
            result['requestParams'] = []
            for k in self.request_params:
                result['requestParams'].append(k.to_map() if k else None)
        if self.path_match_type is not None:
            result['pathMatchType'] = self.path_match_type
        if self.body_flag is not None:
            result['bodyFlag'] = self.body_flag
        if self.body_type is not None:
            result['bodyType'] = self.body_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('body') is not None:
            self.body = []
            for k in m.get('body'):
                temp_model = EditAndActiveApiBody()
                self.body.append(temp_model.from_map(k))
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        if m.get('requestParams') is not None:
            self.request_params = []
            for k in m.get('requestParams'):
                temp_model = EditAndActiveApiRequestParams()
                self.request_params.append(temp_model.from_map(k))
        if m.get('pathMatchType') is not None:
            self.path_match_type = m.get('pathMatchType')
        if m.get('bodyFlag') is not None:
            self.body_flag = m.get('bodyFlag')
        if m.get('bodyType') is not None:
            self.body_type = m.get('bodyType')
        return self


class EditAndActiveApiRequestBodyConfig(TeaModel):
    def __init__(
        self,
        body_limit_max: int = None,
        content_type: str = None,
        nest_max: int = None,
        params_count_max: int = None,
        params_limit_switch: bool = None,
        params_processing_model: str = None,
        request_body_limit_switch: bool = None,
        request_processing_action: str = None,
    ):
        # {"en":"Maximum body limit(bytes).", "zh_CN":"body最大限制。"}
        self.body_limit_max = body_limit_max
        # {"en":"HTTP content type of the response,default value:1.
        # 1:Form
        # 2:Json
        # 4:Any
        # 5:For empty or no existence.", "zh_CN":"contentType，默认值：1。
        # 1：Form表单
        # 2：Json
        # 4：任意
        # 5：为空或不存在。"}
        self.content_type = content_type
        # {"en":"Maximum nesting depth.", "zh_CN":"最大嵌套层数。"}
        self.nest_max = nest_max
        # {"en":"Maximum number of parameters for JSON.", "zh_CN":"Json最大参数个数。"}
        self.params_count_max = params_count_max
        # {"en":"Parameter limit switch,default value: false.", "zh_CN":"参数限制开关，默认值：false。"}
        self.params_limit_switch = params_limit_switch
        # {"en":"Query string parameter detection modeh,default value:1.
        # 1:Quirk mode
        # 2:Strict mode", "zh_CN":"query string参数检测模式，默认值：1。
        # :1：宽松模式
        # 2：严格模式"}
        self.params_processing_model = params_processing_model
        # {"en":"Request body limit switch,default value:false.", "zh_CN":"请求body限制开关，默认值：false。"}
        self.request_body_limit_switch = request_body_limit_switch
        # {"en":"The action to execute when a rule is matched,default value:2.
        # 1:Block
        # 2:Log
        # 3:Sign", "zh_CN":"处理动作，默认值：2。
        # 1：拦截
        # 2：监控
        # 3：标记"}
        self.request_processing_action = request_processing_action

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body_limit_max is not None:
            result['bodyLimitMax'] = self.body_limit_max
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.nest_max is not None:
            result['nestMax'] = self.nest_max
        if self.params_count_max is not None:
            result['paramsCountMax'] = self.params_count_max
        if self.params_limit_switch is not None:
            result['paramsLimitSwitch'] = self.params_limit_switch
        if self.params_processing_model is not None:
            result['paramsProcessingModel'] = self.params_processing_model
        if self.request_body_limit_switch is not None:
            result['requestBodyLimitSwitch'] = self.request_body_limit_switch
        if self.request_processing_action is not None:
            result['requestProcessingAction'] = self.request_processing_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bodyLimitMax') is not None:
            self.body_limit_max = m.get('bodyLimitMax')
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('nestMax') is not None:
            self.nest_max = m.get('nestMax')
        if m.get('paramsCountMax') is not None:
            self.params_count_max = m.get('paramsCountMax')
        if m.get('paramsLimitSwitch') is not None:
            self.params_limit_switch = m.get('paramsLimitSwitch')
        if m.get('paramsProcessingModel') is not None:
            self.params_processing_model = m.get('paramsProcessingModel')
        if m.get('requestBodyLimitSwitch') is not None:
            self.request_body_limit_switch = m.get('requestBodyLimitSwitch')
        if m.get('requestProcessingAction') is not None:
            self.request_processing_action = m.get('requestProcessingAction')
        return self


class EditAndActiveApiRequest(TeaModel):
    def __init__(
        self,
        api_id: str = None,
        api_case: int = None,
        api_group: str = None,
        api_name: str = None,
        api_conceal: str = None,
        api_type: str = None,
        auth_config: EditAndActiveApiAuthConfig = None,
        auth_key: str = None,
        domains: str = None,
        front_path: str = None,
        path_match_type: str = None,
        front_path_type: int = None,
        params_limit_config: List[EditAndActiveApiParamsLimitConfig] = None,
        remark: str = None,
        request_body_config: EditAndActiveApiRequestBodyConfig = None,
        request_method: str = None,
    ):
        # {"en":"API ID", "zh_CN":"api ID"}
        self.api_id = api_id
        # {"en":"Case sensitive,default value:0.
        # 0:False
        # 1:True", "zh_CN":"大小写敏感，默认值：0。
        #  0：否
        # 1：是"}
        self.api_case = api_case
        # {"en":"API group.", "zh_CN":"API分组。"}
        self.api_group = api_group
        # {"en":"API name.", "zh_CN":"API名称。"}
        self.api_name = api_name
        # {"en":"API privacy,default value:PUBLIC.
        # PUBLIC:Public,the consumer does not need to associate with the API, and can access the public API assets only by passing the authentication.
        # PRIVATE:Private,you need to create a consumer and associate with the API to access private API assets.", "zh_CN":"API隐私，默认值：PUBLIC。
        # PUBLIC：公开，消费方无需绑定API，仅鉴权通过即可访问公开API资产。
        # PRIVATE：私有，需要创建消费方并绑定API，方可访问私有API资产。"}
        self.api_conceal = api_conceal
        # {"en":"API type,default value:NORMAL.
        # NORMAL:Normal API,the path does not contain query string parameters,such as http://www.test.com/api.
        # WHEN_CASE:When case,the path contains query string parameters,such as http://www.test.com/api?action=1 and http://www.test.com/api?action=2 are two different APIs.", "zh_CN":"API类型，默认值：NORMAL。
        # NORMAL：普通接口，路径中不包含query string参数的普通接口，如http://www.test.com/api。
        # WHEN_CASE：when_case接口，路径中包含query string参数，如http://www.test.com/api?action=1与http://www.test.com/api?action=2 是两个不同的接口。"}
        self.api_type = api_type
        # {"en":"Authentication configuration.", "zh_CN":"鉴权配置。"}
        self.auth_config = auth_config
        # {"en":"Authentication key.", "zh_CN":"鉴权秘钥。"}
        self.auth_key = auth_key
        # {"en":"Domain,multiple use \";\" split.", "zh_CN":"所属域名，多个用;隔开。"}
        self.domains = domains
        # {"en":"Endpoint path.", "zh_CN":"前端路径。"}
        self.front_path = front_path
        # {"en":"Path matching type,default value:DICT.
        # DICT:Complete matching
        #  REGEX:Regular matching", "zh_CN":"路径匹配类型，默认值：DICT。
        # DICT：完整匹配
        #  REGEX：正则匹配"}
        self.path_match_type = path_match_type
        # {"en":"Match parameters in the path,default value:0.
        # 0:False
        # 1:True
        # ", "zh_CN":"前端路径类型，默认值：0。
        #  0：否
        # 1：是
        # "}
        self.front_path_type = front_path_type
        # {"en":"Parameter limit configuration.", "zh_CN":"参数限制配置。"}
        self.params_limit_config = params_limit_config
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark
        # {"en":"Request body limit configuration.", "zh_CN":"请求Body配置。"}
        self.request_body_config = request_body_config
        # {"en":"Request Methods,multiple use \";\" split,default value:GET.
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE", "zh_CN":"请求方法，多个用;隔开，默认值：GET。
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE"}
        self.request_method = request_method

    def validate(self):
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.api_group, 'api_group')
        self.validate_required(self.api_name, 'api_name')
        self.validate_required(self.api_type, 'api_type')
        if self.auth_config:
            self.auth_config.validate()
        self.validate_required(self.domains, 'domains')
        self.validate_required(self.front_path, 'front_path')
        self.validate_required(self.path_match_type, 'path_match_type')
        self.validate_required(self.front_path_type, 'front_path_type')
        if self.params_limit_config:
            for k in self.params_limit_config:
                if k:
                    k.validate()
        self.validate_required(self.request_body_config, 'request_body_config')
        if self.request_body_config:
            self.request_body_config.validate()
        self.validate_required(self.request_method, 'request_method')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['apiId'] = self.api_id
        if self.api_case is not None:
            result['apiCase'] = self.api_case
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.api_name is not None:
            result['apiName'] = self.api_name
        if self.api_conceal is not None:
            result['apiConceal'] = self.api_conceal
        if self.api_type is not None:
            result['apiType'] = self.api_type
        if self.auth_config is not None:
            result['authConfig'] = self.auth_config.to_map()
        if self.auth_key is not None:
            result['authKey'] = self.auth_key
        if self.domains is not None:
            result['domains'] = self.domains
        if self.front_path is not None:
            result['frontPath'] = self.front_path
        if self.path_match_type is not None:
            result['pathMatchType'] = self.path_match_type
        if self.front_path_type is not None:
            result['frontPathType'] = self.front_path_type
        if self.params_limit_config is not None:
            result['paramsLimitConfig'] = []
            for k in self.params_limit_config:
                result['paramsLimitConfig'].append(k.to_map() if k else None)
        if self.remark is not None:
            result['remark'] = self.remark
        if self.request_body_config is not None:
            result['requestBodyConfig'] = self.request_body_config.to_map()
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiId') is not None:
            self.api_id = m.get('apiId')
        if m.get('apiCase') is not None:
            self.api_case = m.get('apiCase')
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('apiName') is not None:
            self.api_name = m.get('apiName')
        if m.get('apiConceal') is not None:
            self.api_conceal = m.get('apiConceal')
        if m.get('apiType') is not None:
            self.api_type = m.get('apiType')
        if m.get('authConfig') is not None:
            temp_model = EditAndActiveApiAuthConfig()
            self.auth_config = temp_model.from_map(m['authConfig'])
        if m.get('authKey') is not None:
            self.auth_key = m.get('authKey')
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        if m.get('frontPath') is not None:
            self.front_path = m.get('frontPath')
        if m.get('pathMatchType') is not None:
            self.path_match_type = m.get('pathMatchType')
        if m.get('frontPathType') is not None:
            self.front_path_type = m.get('frontPathType')
        if m.get('paramsLimitConfig') is not None:
            self.params_limit_config = []
            for k in m.get('paramsLimitConfig'):
                temp_model = EditAndActiveApiParamsLimitConfig()
                self.params_limit_config.append(temp_model.from_map(k))
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('requestBodyConfig') is not None:
            temp_model = EditAndActiveApiRequestBodyConfig()
            self.request_body_config = temp_model.from_map(m['requestBodyConfig'])
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        return self


class EditAndActiveApiResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: dict = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class EditAndActiveApiPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditAndActiveApiParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditAndActiveApiRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditAndActiveApiResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeployBehaviorAnalyseReqRows(TeaModel):
    def __init__(
        self,
        req_judge: str = None,
        req_type_1: str = None,
        req_type_2: str = None,
        req_isequal: str = None,
        req_value: int = None,
        api_req_type: str = None,
        api_self_isregex: str = None,
        api_self_url: str = None,
        api_req_isequal: str = None,
        api_req_value: int = None,
        api_req_name: str = None,
    ):
        # {"en":"Request quantity determination.If application_scen =  0,req_judge is required.  
        #  0:Request Number 
        #  1:Request Ratio", "zh_CN":"请求数量判定。若application_scen=0，则req_judge必填。  
        #  0：请求数量判定 
        #  1：请求比例判定"}
        self.req_judge = req_judge
        # {"en":"Request type1. If application_scen = 0,req_type1 is required. 
        #   0:Total requests 
        #  1:Requests of GET method 
        #  2:Requests of POST method 
        #   3:Requests of image resource 
        #  4:Requests of css resource 
        #  5:Requests of js resource 
        #  6:Requests of other static resource", 
        # 	"zh_CN":"请求类型1。若application_scen=0,则req_type1必填。
        #  0：总请求次数 
        #  1：GET请求次 
        #  2：POST请求次数 
        #  3：图片资源请求次: 
        #  4：CSS资源请求次数-4 
        #  5：JS资源请求次数-5 
        #  6：其他静态资源请求次"}
        self.req_type_1 = req_type_1
        # {"en":"Request type2. If application_scen = 0 and req_judge=1,req_type2 is required. 
        #   0:Total request 
        #  1:Requests of GET method 
        #  2：Requests of POST method 
        #   3:Requests of image resource 
        #  4:Requests of css resource 
        #  5:Requests of js resource 
        #  6:Requests of other static resource",
        # 	"zh_CN":"请求类型2。若application_scen=0且req_judge=1，则req_type2必填。
        #  0：总请求次数 
        #  1：GET请求次数 
        #  2：POST请求次数 
        #  3：图片资源请求次数 
        #  4：CSS资源请求次数 
        #  5：JS资源请求次数 
        #  6：其他静态资源请求次数"}
        self.req_type_2 = req_type_2
        # {"en":"Operator.If application_scen = 0,req_isequal is required. 
        #  0:> 
        #  1:< 
        #  2:>=\
        #  3:<= ", 
        # 	"zh_CN":"运算符。 若application_scen=0，则req_isequal必填。 
        #  0：> 
        #   1：< 
        #  2：>=\
        #  3：<= "}
        self.req_isequal = req_isequal
        # {"en":"Threshold. If application_scen=0, req_value is required.", 
        # 	"zh_CN":"阈值。若application_scen=0，则req_value必填。"}
        self.req_value = req_value
        # {"en":"API Case - request type. If application_scen=1, api_req_type is required. 
        #  0:Total requests 
        #  1:Other URL requests
        #  2:Custom URL requests:", 
        #     "zh_CN":"API场景-请求类型。若application_scen=1，则api_req_type必填。 
        #  0：请求总数 
        #  1：其他URL请求数 
        #  2：自定义url请求数"}
        self.api_req_type = api_req_type
        # {"en":"API Case - operator.If api_req_type=2, api_self_isregex is required.  
        #  0:Equals 
        #  1:Regex match 
        # 2:Contains", "zh_CN":"API场景-运算符。若api_req_type=2，则api_self_isregex必填。 
        #  0：相等
        #  1：正则匹配
        #  2：包含"}
        self.api_self_isregex = api_self_isregex
        # {"en":"API Case - Custom URL. If api_req_type=2, api_self_url  is required.", "zh_CN":"API场景-自定义URL。若api_req_type=2，则api_self_url必填。"}
        self.api_self_url = api_self_url
        # {"en":"API Case - operator. If application_scen=1, api_req_isequal is required.  
        #  0:> 
        #  1:< 
        #  2:>=\
        #  3:<= ", 
        # 	"zh_CN":"API场景-运算符。若application_scen=1，则api_req_isequal必填。  
        #  0：> 
        #   1：< 
        #  2：>=\
        #  3：<= "}
        self.api_req_isequal = api_req_isequal
        # {"en":"API Case - threshold. If application_scen=1, api_req_value is required.", "zh_CN":"API-阈值。若application_scen=1，则api_req_value必填。"}
        self.api_req_value = api_req_value
        # {"en":"Match type.If api_req_type=2, api_self_url  is required. 
        # Path:Path
        # URI:URI", "zh_CN":"匹配类型。若api_req_type=2，则api_self_isregex必填。
        # Path:路径
        # URI:URI"}
        self.api_req_name = api_req_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_judge is not None:
            result['req_judge'] = self.req_judge
        if self.req_type_1 is not None:
            result['req_type1'] = self.req_type_1
        if self.req_type_2 is not None:
            result['req_type2'] = self.req_type_2
        if self.req_isequal is not None:
            result['req_isequal'] = self.req_isequal
        if self.req_value is not None:
            result['req_value'] = self.req_value
        if self.api_req_type is not None:
            result['api_req_type'] = self.api_req_type
        if self.api_self_isregex is not None:
            result['api_self_isregex'] = self.api_self_isregex
        if self.api_self_url is not None:
            result['api_self_url'] = self.api_self_url
        if self.api_req_isequal is not None:
            result['api_req_isequal'] = self.api_req_isequal
        if self.api_req_value is not None:
            result['api_req_value'] = self.api_req_value
        if self.api_req_name is not None:
            result['api_req_name'] = self.api_req_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_judge') is not None:
            self.req_judge = m.get('req_judge')
        if m.get('req_type1') is not None:
            self.req_type_1 = m.get('req_type1')
        if m.get('req_type2') is not None:
            self.req_type_2 = m.get('req_type2')
        if m.get('req_isequal') is not None:
            self.req_isequal = m.get('req_isequal')
        if m.get('req_value') is not None:
            self.req_value = m.get('req_value')
        if m.get('api_req_type') is not None:
            self.api_req_type = m.get('api_req_type')
        if m.get('api_self_isregex') is not None:
            self.api_self_isregex = m.get('api_self_isregex')
        if m.get('api_self_url') is not None:
            self.api_self_url = m.get('api_self_url')
        if m.get('api_req_isequal') is not None:
            self.api_req_isequal = m.get('api_req_isequal')
        if m.get('api_req_value') is not None:
            self.api_req_value = m.get('api_req_value')
        if m.get('api_req_name') is not None:
            self.api_req_name = m.get('api_req_name')
        return self


class DeployBehaviorAnalysePtRows(TeaModel):
    def __init__(
        self,
        protection_scope: int = None,
        protection_content: str = None,
        protection_name: str = None,
    ):
        # {"en":"Protection path matching method.
        #  3:Equals 
        #  4:Regex match
        # 5:Contains", "zh_CN":"防护路径匹配方式。
        #  3：等于 
        #  4：正则匹配
        # 5：包含"}
        self.protection_scope = protection_scope
        # {"en":"Protection path content.", "zh_CN":"防护路径内容。"}
        self.protection_content = protection_content
        # {"en":"Protection type. 
        # Path:Path
        # URI:URI", "zh_CN":"防护类型。
        # Path:路径
        # URI:URI"}
        self.protection_name = protection_name

    def validate(self):
        self.validate_required(self.protection_scope, 'protection_scope')
        self.validate_required(self.protection_content, 'protection_content')
        self.validate_required(self.protection_name, 'protection_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.protection_scope is not None:
            result['protection_scope'] = self.protection_scope
        if self.protection_content is not None:
            result['protection_content'] = self.protection_content
        if self.protection_name is not None:
            result['protection_name'] = self.protection_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('protection_scope') is not None:
            self.protection_scope = m.get('protection_scope')
        if m.get('protection_content') is not None:
            self.protection_content = m.get('protection_content')
        if m.get('protection_name') is not None:
            self.protection_name = m.get('protection_name')
        return self


class DeployBehaviorAnalyseRuleContent(TeaModel):
    def __init__(
        self,
        rule_name: str = None,
        rule_description: str = None,
        application_scen: int = None,
        statistical_period: int = None,
        statistical_item: int = None,
        action: int = None,
        req_rows: List[DeployBehaviorAnalyseReqRows] = None,
        fp_rows: List[DeployBehaviorAnalysePtRows] = None,
        deploy_id: str = None,
        content_type: str = None,
        response: str = None,
        customer_code: int = None,
        wl_uri: List[str] = None,
    ):
        # {"en":"Rule  name.", "zh_CN":"规则名称。"}
        self.rule_name = rule_name
        # {"en":"Rule  description.", "zh_CN":"规则描述。"}
        self.rule_description = rule_description
        # {"en":"Application scen. 
        #  0:WEB 
        #  1:API", "zh_CN":"应用场景 。
        #  0：WEB 
        #  1：API"}
        self.application_scen = application_scen
        # {"en":"Trigger condition statistical period.", "zh_CN":"触发条件-统计周期。"}
        self.statistical_period = statistical_period
        # {"en":"Trigger condition - statistical dimension.
        #  0:IP 
        #  1:IP+User-Agent 
        #  2:Client-ID 
        #  3:Device Fingerprint", "zh_CN":"触发条件-统计维度。
        #  0：IP 
        #  1：IP+UA 
        #  2：客户端ID 
        #  3：设备指纹"}
        self.statistical_item = statistical_item
        # {"en":"Action. 
        #  0:Log 
        #  1:Block 
        #  2:Custom Response Content", "zh_CN":"处理动作。
        #  0：监控 
        #  1：拦截 
        #  2：自定义响应"}
        self.action = action
        # {"en":"Request quantity/proportion determination.", "zh_CN":"请求数量/比例判定。"}
        self.req_rows = req_rows
        # {"en":"Protection path.", "zh_CN":"防护路径。"}
        self.fp_rows = fp_rows
        # {"en":"Deployment ID. Not required when creating rules, but required when updating rules.", "zh_CN":"部署ID。创建规则时不填，更新规则时必填。"}
        self.deploy_id = deploy_id
        # {"en":"The file type of the customized response content. The default value is text/html.", "zh_CN":"自定义响应内容的文件类型，默认值：text/html。"}
        self.content_type = content_type
        # {"en":"Customize the response content. If action=2, response is required.", "zh_CN":"自定义响应内容。若action=2，则response必填。"}
        self.response = response
        # {"en":"Custom response status code. Value range: [100, 999]. If action=2, customer_code is required.", "zh_CN":"自定义响应状态码。取值范围：[100, 999]。若action=2，则customer_code必填。"}
        self.customer_code = customer_code
        # {"en":"Exception uri.", "zh_CN":"例外路径。"}
        self.wl_uri = wl_uri

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.application_scen, 'application_scen')
        self.validate_required(self.statistical_period, 'statistical_period')
        self.validate_required(self.statistical_item, 'statistical_item')
        self.validate_required(self.action, 'action')
        self.validate_required(self.req_rows, 'req_rows')
        if self.req_rows:
            for k in self.req_rows:
                if k:
                    k.validate()
        self.validate_required(self.fp_rows, 'fp_rows')
        if self.fp_rows:
            for k in self.fp_rows:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        if self.rule_description is not None:
            result['rule_description'] = self.rule_description
        if self.application_scen is not None:
            result['application_scen'] = self.application_scen
        if self.statistical_period is not None:
            result['statistical_period'] = self.statistical_period
        if self.statistical_item is not None:
            result['statistical_item'] = self.statistical_item
        if self.action is not None:
            result['action'] = self.action
        if self.req_rows is not None:
            result['req_rows'] = []
            for k in self.req_rows:
                result['req_rows'].append(k.to_map() if k else None)
        if self.fp_rows is not None:
            result['fp_rows'] = []
            for k in self.fp_rows:
                result['fp_rows'].append(k.to_map() if k else None)
        if self.deploy_id is not None:
            result['deploy_id'] = self.deploy_id
        if self.content_type is not None:
            result['content_type'] = self.content_type
        if self.response is not None:
            result['response'] = self.response
        if self.customer_code is not None:
            result['customer_code'] = self.customer_code
        if self.wl_uri is not None:
            result['wl_uri'] = self.wl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        if m.get('rule_description') is not None:
            self.rule_description = m.get('rule_description')
        if m.get('application_scen') is not None:
            self.application_scen = m.get('application_scen')
        if m.get('statistical_period') is not None:
            self.statistical_period = m.get('statistical_period')
        if m.get('statistical_item') is not None:
            self.statistical_item = m.get('statistical_item')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('req_rows') is not None:
            self.req_rows = []
            for k in m.get('req_rows'):
                temp_model = DeployBehaviorAnalyseReqRows()
                self.req_rows.append(temp_model.from_map(k))
        if m.get('fp_rows') is not None:
            self.fp_rows = []
            for k in m.get('fp_rows'):
                temp_model = DeployBehaviorAnalysePtRows()
                self.fp_rows.append(temp_model.from_map(k))
        if m.get('deploy_id') is not None:
            self.deploy_id = m.get('deploy_id')
        if m.get('content_type') is not None:
            self.content_type = m.get('content_type')
        if m.get('response') is not None:
            self.response = m.get('response')
        if m.get('customer_code') is not None:
            self.customer_code = m.get('customer_code')
        if m.get('wl_uri') is not None:
            self.wl_uri = m.get('wl_uri')
        return self


class DeployBehaviorAnalyseRow(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        rule_content: DeployBehaviorAnalyseRuleContent = None,
    ):
        # {"en":"Rule  id.", "zh_CN":"规则ID。"}
        self.rule_id = rule_id
        # {"en":"Rule content.", "zh_CN":"规则内容。"}
        self.rule_content = rule_content

    def validate(self):
        self.validate_required(self.rule_content, 'rule_content')
        if self.rule_content:
            self.rule_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.rule_content is not None:
            result['rule_content'] = self.rule_content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('rule_content') is not None:
            temp_model = DeployBehaviorAnalyseRuleContent()
            self.rule_content = temp_model.from_map(m['rule_content'])
        return self


class DeployBehaviorAnalyseRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        al_rows: List[DeployBehaviorAnalyseRow] = None,
    ):
        # {"en":"domain.","zh_CN":"域名。"}
        self.domain = domain
        # {"en":"Rule array.", "zh_CN":"规则数组。"}
        self.al_rows = al_rows

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.al_rows, 'al_rows')
        if self.al_rows:
            for k in self.al_rows:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.al_rows is not None:
            result['al_rows'] = []
            for k in self.al_rows:
                result['al_rows'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('al_rows') is not None:
            self.al_rows = []
            for k in m.get('al_rows'):
                temp_model = DeployBehaviorAnalyseRow()
                self.al_rows.append(temp_model.from_map(k))
        return self


class DeployBehaviorAnalyseResult(TeaModel):
    def __init__(
        self,
        deploy_version: str = None,
        estimatetime: str = None,
    ):
        # {"en":"Deployment version", "zh_CN":"部署版本号"}
        self.deploy_version = deploy_version
        # {"en":"Estimated time", "zh_CN":"预估时间"}
        self.estimatetime = estimatetime

    def validate(self):
        self.validate_required(self.deploy_version, 'deploy_version')
        self.validate_required(self.estimatetime, 'estimatetime')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deploy_version is not None:
            result['deployVersion'] = self.deploy_version
        if self.estimatetime is not None:
            result['estimatetime'] = self.estimatetime
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deployVersion') is not None:
            self.deploy_version = m.get('deployVersion')
        if m.get('estimatetime') is not None:
            self.estimatetime = m.get('estimatetime')
        return self


class DeployBehaviorAnalyseResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: DeployBehaviorAnalyseResult = None,
    ):
        # {"en":"Status code, success is '200'.", "zh_CN":"状态码，成功为“200”。"}
        self.code = code
        # {"en":"Return message, success is 'Success'.", "zh_CN":"返回信息，成功为“Success”。"}
        self.message = message
        # {"en":"Data returned.", "zh_CN":"返回数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = DeployBehaviorAnalyseResult()
            self.data = temp_model.from_map(m['data'])
        return self


class DeployBehaviorAnalysePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeployBehaviorAnalyseParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeployBehaviorAnalyseRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeployBehaviorAnalyseResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetIntelligentAnalysisListRequest(TeaModel):
    def __init__(
        self,
        domain: List[str] = None,
        rule_id: List[int] = None,
        content: str = None,
        status: int = None,
        page_num: int = None,
        page_size: int = None,
        lang: str = None,
    ):
        # {'en':'Array of domain names.', 'zh_CN':'域名数组。'}
        self.domain = domain
        # {'en':'Rule id array.', 'zh_CN':'规则id数组。'}
        self.rule_id = rule_id
        # {'en':'Exceptions.', 'zh_CN':'例外内容。'}
        self.content = content
        # {'en':'Status: 
        #   0: Unprocessed
        #   1: Automatically
        #   2: Manually
        #   3: reject
        #   leave blank and default all.', 'zh_CN':'状态：
        #   0：待处理
        #   1：自动应用
        #   2：手动应用
        #   3：拒绝
        #   置空默认全部。'}
        self.status = status
        # {"en":"Current page number,1 by default.", "zh_CN":"当前页数，默认1。"}
        self.page_num = page_num
        # {"en":"Number each page,the maximum 1000,10 by default.", "zh_CN":"每页数量, 最大1000，默认10。"}
        self.page_size = page_size
        # {"en":"The language of response data, default value: cn.
        #     cn: Chinese
        #     en: English", "zh_CN":"返回内容的语言版本，默认值：cn。
        #     cn：中文
        #     en：英文"}
        self.lang = lang

    def validate(self):
        self.validate_required(self.domain, 'domain')
        if self.page_size is not None:
            self.validate_maximum(self.page_size, 'page_size', 1000)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.content is not None:
            result['content'] = self.content
        if self.status is not None:
            result['status'] = self.status
        if self.page_num is not None:
            result['pageNum'] = self.page_num
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.lang is not None:
            result['lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('pageNum') is not None:
            self.page_num = m.get('pageNum')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('lang') is not None:
            self.lang = m.get('lang')
        return self


class GetIntelligentAnalysisListRuleHosting(TeaModel):
    def __init__(
        self,
        id: int = None,
        domain: str = None,
        rule_id: int = None,
        type: str = None,
        content: str = None,
        msg: str = None,
        status: int = None,
    ):
        # {'en':'Id.', 'zh_CN':'id。'}
        self.id = id
        # {'en':'Associated domain name.', 'zh_CN':'关联域名。'}
        self.domain = domain
        # {'en':'Exception rule id.', 'zh_CN':'例外规则id。'}
        self.rule_id = rule_id
        # {'en':'Exception type.', 'zh_CN':'例外类型。'}
        self.type = type
        # {'en':'Exception content.', 'zh_CN':'例外内容。'}
        self.content = content
        # {'en':'Describe.', 'zh_CN':'描述。'}
        self.msg = msg
        # {'en':'Status: 
        #   0: Unprocessed
        #   1: Automatically
        #   2: Manually
        #   3: reject', 'zh_CN':'状态：
        #   0：待处理
        #   1：自动应用
        #   2：手动应用
        #   3：拒绝'}
        self.status = status

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.content, 'content')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.type is not None:
            result['type'] = self.type
        if self.content is not None:
            result['content'] = self.content
        if self.msg is not None:
            result['msg'] = self.msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class GetIntelligentAnalysisListRuleHostingPage(TeaModel):
    def __init__(
        self,
        total: int = None,
        pages: int = None,
        current: int = None,
        size: int = None,
        records: GetIntelligentAnalysisListRuleHosting = None,
    ):
        # {"en":"The total number of data.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"Total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"Number each page.", "zh_CN":"每页数量。"}
        self.size = size
        # {'en':'Template information,array.', 'zh_CN':'数据列表，数组。'}
        self.records = records

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.current, 'current')
        self.validate_required(self.size, 'size')
        self.validate_required(self.records, 'records')
        if self.records:
            self.records.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['total'] = self.total
        if self.pages is not None:
            result['pages'] = self.pages
        if self.current is not None:
            result['current'] = self.current
        if self.size is not None:
            result['size'] = self.size
        if self.records is not None:
            result['records'] = self.records.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('records') is not None:
            temp_model = GetIntelligentAnalysisListRuleHosting()
            self.records = temp_model.from_map(m['records'])
        return self


class GetIntelligentAnalysisListResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: GetIntelligentAnalysisListRuleHostingPage = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message
        # {'en':'return data.', 'zh_CN':'返回值。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = GetIntelligentAnalysisListRuleHostingPage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetIntelligentAnalysisListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetIntelligentAnalysisListParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetIntelligentAnalysisListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetIntelligentAnalysisListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListWAFCustomRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {'en':'Hostname List.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class ListWAFCustomWafDomainRuleCustomVO(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        domain: str = None,
        rule_name: str = None,
        rule_reg: str = None,
        msg: str = None,
        mode: str = None,
        matchzone_list: List[str] = None,
    ):
        # {"zh_CN":"规则ID。","en":"Rule ID."}
        self.rule_id = rule_id
        # {"zh_CN":"域名。","en":"Hostname."}
        self.domain = domain
        # {"zh_CN":"规则名称。","en":"Rule name."}
        self.rule_name = rule_name
        # {"zh_CN":"匹配条件。","en":"Match conditions."}
        self.rule_reg = rule_reg
        # {"zh_CN":"规则描述。","en":"Rule description."}
        self.msg = msg
        # {"zh_CN":"规则动作。
        # LOG：监控
        # BLOCK：拦截
        # OFF：不使用","en":"Rule actions. 
        # LOG: Monitoring
        # BLOCK: Interception
        # OFF: Not used"}
        self.mode = mode
        # {"zh_CN":"检测区域列表。
        #     path：路径
        #     queryString：Query String
        #     header：完整请求头
        #     body：请求body
        #     uri：URI
        #     fileExt：文件后缀
        #     ","en":"Areas to detect.
        #     path: Path
        #     queryString: Query String
        #     header: Request Header
        #     body: Request Body
        #     uri: URI
        #     fileExt: File Extension"}
        self.matchzone_list = matchzone_list

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_reg, 'rule_reg')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.matchzone_list, 'matchzone_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.rule_reg is not None:
            result['ruleReg'] = self.rule_reg
        if self.msg is not None:
            result['msg'] = self.msg
        if self.mode is not None:
            result['mode'] = self.mode
        if self.matchzone_list is not None:
            result['matchzoneList'] = self.matchzone_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('ruleReg') is not None:
            self.rule_reg = m.get('ruleReg')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('matchzoneList') is not None:
            self.matchzone_list = m.get('matchzoneList')
        return self


class ListWAFCustomResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListWAFCustomWafDomainRuleCustomVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListWAFCustomWafDomainRuleCustomVO()
                self.data.append(temp_model.from_map(k))
        return self


class ListWAFCustomPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListWAFCustomParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListWAFCustomRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListWAFCustomResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class AddCustomizeRuleRequestConditionMethodConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        request_method: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal","zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"Request method.
        # Supported values: GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY.","zh_CN":"请求方法。
        # 支持的值：GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY。"}
        self.request_method = request_method

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.request_method, 'request_method')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        return self


class AddCustomizeRuleRequestConditionJa3Conditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ja_3list: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal","zh_CN":"匹配类型。
        # EQUAL：等于 
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"JA3 Fingerprint List, maximum 300 JA3 Fingerprint.
        # When the match type is EQUAL/NOT_EQUAL, each item's character length must be 32 and can only include numbers and lowercase letters.","zh_CN":"JA3指纹列表，最多300个JA3指纹。
        # 当匹配类型为等于/不等于时，每项字符长度必须为32，且仅限数字和小写字母。"}
        self.ja_3list = ja_3list

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ja_3list, 'ja_3list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ja_3list is not None:
            result['ja3List'] = self.ja_3list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ja3List') is not None:
            self.ja_3list = m.get('ja3List')
        return self


class AddCustomizeRuleRequestConditionAreaConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        areas: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal","zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"Geo.","zh_CN":"区域。"}
        self.areas = areas

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.areas, 'areas')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.areas is not None:
            result['areas'] = self.areas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('areas') is not None:
            self.areas = m.get('areas')
        return self


class AddCustomizeRuleRequestConditionIpOrIpsConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ip_or_ips: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal","zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"IP/CIDR, maximum 500 IP/CIDR.","zh_CN":"IP/IP段，最多500个IP/IP段。"}
        self.ip_or_ips = ip_or_ips

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ip_or_ips, 'ip_or_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ip_or_ips is not None:
            result['ipOrIps'] = self.ip_or_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ipOrIps') is not None:
            self.ip_or_ips = m.get('ipOrIps')
        return self


class AddCustomizeRuleRequestConditionUriConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        uri: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, URI case sensitive
        # NOT_EQUAL: Does not equal, URI case sensitive
        # CONTAIN: Contains, URI case insensitive
        # NOT_CONTAIN: Does not Contains, URI case insensitive
        # REGEX: Regex match, URI case insensitive
        # NOT_REGEX: Regular does not match, URI case insensitive
        # START_WITH: Starts with, URI case insensitive
        # END_WITH: Ends with, URI case insensitive
        # WILDCARD: Wildcard matches, URI case insensitive,* represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, URI case insensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，URI大小写敏感
        # NOT_EQUAL：不等于，URI大小写敏感
        # CONTAIN：包含，URI大小写不敏感
        # NOT_CONTAIN：不包含，URI大小写不敏感
        # REGEX：匹配正则，URI大小写不敏感
        # NOT_REGEX：正则不匹配，URI大小写不敏感
        # START_WITH：开头是，URI大小写不敏感
        # END_WITH：结尾是，URI大小写不敏感
        # WILDCARD：通配符匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {"en":"URI.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, uri needs to start with "/", and includes parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.
        # Example: /test.html?id=1.","zh_CN":"URI。
        # 当匹配类型为等于/不等于/开头是/结尾是，URI必须以”/“开头，含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html?id=1。"}
        self.uri = uri

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.uri, 'uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class AddCustomizeRuleRequestConditionPathConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        paths: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, path case sensitive
        # NOT_EQUAL: Does not equal, path case sensitive
        # CONTAIN: Contains, path case insensitive
        # NOT_CONTAIN: Does not Contains, path case insensitive
        # REGEX: Regex match, path case insensitive
        # NOT_REGEX: Regular does not match, path case sensitive
        # START_WITH: Starts with, path case sensitive
        # END_WITH: Ends with, path case sensitive
        # WILDCARD: Wildcard matches, path case sensitive,* represents zero or more arbitrary characters, ? represents any single character.
        # NOT_WILDCARD: Wildcard does not match, path case sensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，路径大小写敏感
        # NOT_EQUAL：不等于，路径大小写敏感
        # CONTAIN：包含，路径大小写不敏感
        # NOT_CONTAIN：不包含，路径大小写不敏感
        # REGEX：匹配正则，路径大小写不敏感
        # NOT_REGEX：正则不匹配，路径大小写不敏感
        # START_WITH：开头是，路径大小写不敏感
        # END_WITH：结尾是，路径大小写不敏感
        # WILDCARD：通配符匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {"en":"Path.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, path needs to start with "/", and no parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.
        # Example: /test.html.","zh_CN":"路径。
        # 当匹配类型为等于/不等于/开头是/结尾是，路径必须以“/”开头，不含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html。"}
        self.paths = paths

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.paths, 'paths')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.paths is not None:
            result['paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paths') is not None:
            self.paths = m.get('paths')
        return self


class AddCustomizeRuleRequestConditionUriParamConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        param_name: str = None,
        param_value: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL:Equals,param value case sensitive
        # NOT_EQUAL:Does not equal,param value case sensitive
        # CONTAIN:Contains,param value case insensitive
        # NOT_CONTAIN:Does not contains,param value case insensitive
        # REGEX:Regex match,param value case insensitive
        # NONE:Empty or non-existent","zh_CN":"匹配类型。
        # EQUAL：等于，参数值大小写敏感
        # NOT_EQUAL：不等于，参数值大小写敏感
        # CONTAIN：包含，参数值大小写不敏感
        # NOT_CONTAIN：不包含，参数值大小写不敏感
        # REGEX：正则，参数值大小写不敏感
        # NONE：为空或不存在"}
        self.match_type = match_type
        # {"en":"Param name,case sensitive,maximum 100 characters.
        # Example: id.","zh_CN":"参数名，大小写敏感，最多100个字符。
        # 示例：id。"}
        self.param_name = param_name
        # {"en":"Param value.","zh_CN":"参数值。"}
        self.param_value = param_value

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.param_name, 'param_name')
        self.validate_required(self.param_value, 'param_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.param_name is not None:
            result['paramName'] = self.param_name
        if self.param_value is not None:
            result['paramValue'] = self.param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paramName') is not None:
            self.param_name = m.get('paramName')
        if m.get('paramValue') is not None:
            self.param_value = m.get('paramValue')
        return self


class AddCustomizeRuleRequestConditionUaConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ua: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, user agent case sensitive
        # NOT_EQUAL: Does not equal, user agent case sensitive
        # CONTAIN: Contains, user agent case insensitive
        # NOT_CONTAIN: Does not Contains, user agent case insensitive
        # NONE:Empty or non-existent
        # REGEX: Regex match, user agent case insensitive
        # NOT_REGEX: Regular does not match, user agent case insensitive
        # START_WITH: Starts with, user agent case insensitive
        # END_WITH: Ends with, user agent case insensitive
        # WILDCARD: Wildcard matches, user agent case insensitive,* represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, user agent case insensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，User-Agent大小写敏感
        # NOT_EQUAL：不等于，User-Agent大小写敏感
        # CONTAIN：包含，User-Agent大小写不敏感
        # NOT_CONTAIN：不包含，User-Agent大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，User-Agent大小写不敏感
        # NOT_REGEX：正则不匹配，User-Agent大小写不敏感
        # START_WITH：开头是，User-Agent大小写不敏感
        # END_WITH：结尾是，User-Agent大小写不敏感
        # WILDCARD：通配符匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {"en":"User agent.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.
        # Example: go-Http-client/1.1.","zh_CN":"User-Agent。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：go-Http-client/1.1。"}
        self.ua = ua

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ua, 'ua')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ua is not None:
            result['ua'] = self.ua
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ua') is not None:
            self.ua = m.get('ua')
        return self


class AddCustomizeRuleRequestConditionHeaderConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        value_list: List[str] = None,
        key: str = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, request header values case sensitive
        # NOT_EQUAL: Does not equal, request header values case sensitive
        # CONTAIN: Contains, request header values case insensitive
        # NOT_CONTAIN: Does not Contains, request header values case insensitive
        # NONE: Empty or non-existent
        # REGEX: Regex match, request header values case insensitive
        # NOT_REGEX: Regular does not match, request header values case insensitive
        # START_WITH: Starts with, request header values case insensitive
        # END_WITH: Ends with, request header values case insensitive
        # WILDCARD: Wildcard matches, request header values case insensitive,* represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, request header values case insensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，头部值大小写敏感
        # NOT_EQUAL：不等于，头部值大小写敏感
        # CONTAIN：包含，头部值大小写不敏感
        # NOT_CONTAIN：不包含，头部值大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，头部值大小写不敏感
        # NOT_REGEX：正则不匹配，头部值大小写不敏感
        # START_WITH：开头是，头部值大小写不敏感
        # END_WITH：结尾是，头部值大小写不敏感
        # WILDCARD：通配符匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {"en":"Header value.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.","zh_CN":"头部值。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。"}
        self.value_list = value_list
        # {"en":"Header name,case insensitive,up to 100 characters.
        # Example: Accept.","zh_CN":"头部名称，大小写不敏感，最多100个字符。
        # 示例：Accept。"}
        self.key = key

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.value_list, 'value_list')
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.value_list is not None:
            result['valueList'] = self.value_list
        if self.key is not None:
            result['key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('valueList') is not None:
            self.value_list = m.get('valueList')
        if m.get('key') is not None:
            self.key = m.get('key')
        return self


class AddCustomizeRuleRequestConditionRefererConditions(TeaModel):
    def __init__(
        self,
        referer: List[str] = None,
        match_type: str = None,
    ):
        # {"en":"Referer.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.
        # Example: http://test.com.","zh_CN":"Referer。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：http://test.com。"}
        self.referer = referer
        # {"en":"Match type.
        # EQUAL: Equals, referer case sensitive
        # NOT_EQUAL: Does not equal, referer case sensitive
        # CONTAIN: Contains, referer case insensitive
        # NOT_CONTAIN: Does not Contains, referer case insensitive
        # NONE:Empty or non-existent
        # REGEX: Regex match, referer case insensitive
        # NOT_REGEX: Regular does not match, referer case insensitive
        # START_WITH: Starts with, referer case insensitive
        # END_WITH: Ends with, referer case insensitive
        # WILDCARD: Wildcard matches, referer case insensitive,* represents zero or more arbitrary characters, ? represents any single characte
        # NOT_WILDCARD: Wildcard does not match, referer case insensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，referer大小写敏感
        # NOT_EQUAL：不等于，referer大小写敏感
        # CONTAIN：包含，referer大小写不敏感
        # NOT_CONTAIN：不包含，referer大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，referer大小写不敏感
        # NOT_REGEX：正则不匹配，referer大小写不敏感
        # START_WITH：开头是，referer大小写不敏感
        # END_WITH：结尾是，referer大小写不敏感
        # WILDCARD：通配符匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type

    def validate(self):
        self.validate_required(self.referer, 'referer')
        self.validate_required(self.match_type, 'match_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.referer is not None:
            result['referer'] = self.referer
        if self.match_type is not None:
            result['matchType'] = self.match_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('referer') is not None:
            self.referer = m.get('referer')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        return self


class AddCustomizeRuleRequestConditionJa4Conditions(TeaModel):
    def __init__(
        self,
        ja_4list: List[str] = None,
        match_type: str = None,
    ):
        # {"en":"JA4 Fingerprint List, maximum 300 JA4 Fingerprint.
        # When the match type is EQUAL/NOT_EQUAL, each item's format must be 10 characters + 12 characters + 12 characters, separated by underscores, and can only include underscores, numbers, and lowercase letters.
        # When the match type is CONTAIN/NOT_CONTAIN/START_WITH/END_WITH, each item is only allowed to include underscores, numbers, and lowercase letters.
        # When the match type is WILDCARD/NOT_WILDCARD, each item, aside from  ** and ?, is only allowed to include underscores, numbers, and lowercase letters.","zh_CN":"JA4指纹列表，最多300个JA4指纹。
        # 当匹配类型为等于/不等于时，每项格式必须为10位字符+12位字符+12位字符，中间以“_”分隔，且仅限下划线、数字和小写字母。
        # 当匹配类型为包含/不包含/开头是/结尾是时，每项只允许输入下划线、数字和小写字母。
        # 当匹配类型为通配符匹配/通配符不匹配时，每项除*和?外，只允许输入下划线、数字和小写字母。"}
        self.ja_4list = ja_4list
        # {"en":"Match type. 
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal
        # CONTAIN: Contains
        # NOT_CONTAIN: Does not Contains
        # START_WITH: Starts with
        # END_WITH: Ends with
        # WILDCARD: Wildcard matches, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, ** represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type

    def validate(self):
        self.validate_required(self.ja_4list, 'ja_4list')
        self.validate_required(self.match_type, 'match_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ja_4list is not None:
            result['ja4List'] = self.ja_4list
        if self.match_type is not None:
            result['matchType'] = self.match_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ja4List') is not None:
            self.ja_4list = m.get('ja4List')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        return self


class AddCustomizeRuleRequestCondition(TeaModel):
    def __init__(
        self,
        method_conditions: List[AddCustomizeRuleRequestConditionMethodConditions] = None,
        ja_3conditions: List[AddCustomizeRuleRequestConditionJa3Conditions] = None,
        area_conditions: List[AddCustomizeRuleRequestConditionAreaConditions] = None,
        ip_or_ips_conditions: List[AddCustomizeRuleRequestConditionIpOrIpsConditions] = None,
        uri_conditions: List[AddCustomizeRuleRequestConditionUriConditions] = None,
        path_conditions: List[AddCustomizeRuleRequestConditionPathConditions] = None,
        uri_param_conditions: List[AddCustomizeRuleRequestConditionUriParamConditions] = None,
        ua_conditions: List[AddCustomizeRuleRequestConditionUaConditions] = None,
        header_conditions: List[AddCustomizeRuleRequestConditionHeaderConditions] = None,
        referer_conditions: List[AddCustomizeRuleRequestConditionRefererConditions] = None,
        ja_4conditions: List[AddCustomizeRuleRequestConditionJa4Conditions] = None,
    ):
        # {"en":"Request Method.
        # When the business scenario is API,this matching condition is not supported.","zh_CN":"请求方法，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。"}
        self.method_conditions = method_conditions
        # {"en":"JA3 Fingerprint, match type cannot be repeated.","zh_CN":"JA3指纹，匹配类型不可重复。"}
        self.ja_3conditions = ja_3conditions
        # {"en":"Geo, match type cannot be repeated.","zh_CN":"区域，匹配类型不可重复。"}
        self.area_conditions = area_conditions
        # {"en":"IP/CIDR, match type cannot be repeated.","zh_CN":"IP/IP段，匹配类型不可重复。"}
        self.ip_or_ips_conditions = ip_or_ips_conditions
        # {"en":"URI, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.","zh_CN":"URI，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。"}
        self.uri_conditions = uri_conditions
        # {"en":"Path, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.","zh_CN":"路径，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。"}
        self.path_conditions = path_conditions
        # {"en":"URI Parameter, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.","zh_CN":"URI参数，匹配类型不可重复。
        # 当业务场景为网站业务时不支持此匹配条件。"}
        self.uri_param_conditions = uri_param_conditions
        # {"en":"User Agent, match type cannot be repeated.","zh_CN":"User-Agent，匹配类型不可重复。"}
        self.ua_conditions = ua_conditions
        # {"en":"Request Header, match type can be repeated.","zh_CN":"请求头，匹配类型可重复。"}
        self.header_conditions = header_conditions
        # {"en":"Referer, match type cannot be repeated.","zh_CN":"Referer，匹配类型不可重复。"}
        self.referer_conditions = referer_conditions
        # {"en":"JA4 Fingerprint, match type cannot be repeated.","zh_CN":"JA4指纹，匹配类型不可重复。"}
        self.ja_4conditions = ja_4conditions

    def validate(self):
        if self.method_conditions:
            for k in self.method_conditions:
                if k:
                    k.validate()
        if self.ja_3conditions:
            for k in self.ja_3conditions:
                if k:
                    k.validate()
        if self.area_conditions:
            for k in self.area_conditions:
                if k:
                    k.validate()
        if self.ip_or_ips_conditions:
            for k in self.ip_or_ips_conditions:
                if k:
                    k.validate()
        if self.uri_conditions:
            for k in self.uri_conditions:
                if k:
                    k.validate()
        if self.path_conditions:
            for k in self.path_conditions:
                if k:
                    k.validate()
        if self.uri_param_conditions:
            for k in self.uri_param_conditions:
                if k:
                    k.validate()
        if self.ua_conditions:
            for k in self.ua_conditions:
                if k:
                    k.validate()
        if self.header_conditions:
            for k in self.header_conditions:
                if k:
                    k.validate()
        if self.referer_conditions:
            for k in self.referer_conditions:
                if k:
                    k.validate()
        if self.ja_4conditions:
            for k in self.ja_4conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method_conditions is not None:
            result['methodConditions'] = []
            for k in self.method_conditions:
                result['methodConditions'].append(k.to_map() if k else None)
        if self.ja_3conditions is not None:
            result['ja3Conditions'] = []
            for k in self.ja_3conditions:
                result['ja3Conditions'].append(k.to_map() if k else None)
        if self.area_conditions is not None:
            result['areaConditions'] = []
            for k in self.area_conditions:
                result['areaConditions'].append(k.to_map() if k else None)
        if self.ip_or_ips_conditions is not None:
            result['ipOrIpsConditions'] = []
            for k in self.ip_or_ips_conditions:
                result['ipOrIpsConditions'].append(k.to_map() if k else None)
        if self.uri_conditions is not None:
            result['uriConditions'] = []
            for k in self.uri_conditions:
                result['uriConditions'].append(k.to_map() if k else None)
        if self.path_conditions is not None:
            result['pathConditions'] = []
            for k in self.path_conditions:
                result['pathConditions'].append(k.to_map() if k else None)
        if self.uri_param_conditions is not None:
            result['uriParamConditions'] = []
            for k in self.uri_param_conditions:
                result['uriParamConditions'].append(k.to_map() if k else None)
        if self.ua_conditions is not None:
            result['uaConditions'] = []
            for k in self.ua_conditions:
                result['uaConditions'].append(k.to_map() if k else None)
        if self.header_conditions is not None:
            result['headerConditions'] = []
            for k in self.header_conditions:
                result['headerConditions'].append(k.to_map() if k else None)
        if self.referer_conditions is not None:
            result['refererConditions'] = []
            for k in self.referer_conditions:
                result['refererConditions'].append(k.to_map() if k else None)
        if self.ja_4conditions is not None:
            result['ja4Conditions'] = []
            for k in self.ja_4conditions:
                result['ja4Conditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('methodConditions') is not None:
            self.method_conditions = []
            for k in m.get('methodConditions'):
                temp_model = AddCustomizeRuleRequestConditionMethodConditions()
                self.method_conditions.append(temp_model.from_map(k))
        if m.get('ja3Conditions') is not None:
            self.ja_3conditions = []
            for k in m.get('ja3Conditions'):
                temp_model = AddCustomizeRuleRequestConditionJa3Conditions()
                self.ja_3conditions.append(temp_model.from_map(k))
        if m.get('areaConditions') is not None:
            self.area_conditions = []
            for k in m.get('areaConditions'):
                temp_model = AddCustomizeRuleRequestConditionAreaConditions()
                self.area_conditions.append(temp_model.from_map(k))
        if m.get('ipOrIpsConditions') is not None:
            self.ip_or_ips_conditions = []
            for k in m.get('ipOrIpsConditions'):
                temp_model = AddCustomizeRuleRequestConditionIpOrIpsConditions()
                self.ip_or_ips_conditions.append(temp_model.from_map(k))
        if m.get('uriConditions') is not None:
            self.uri_conditions = []
            for k in m.get('uriConditions'):
                temp_model = AddCustomizeRuleRequestConditionUriConditions()
                self.uri_conditions.append(temp_model.from_map(k))
        if m.get('pathConditions') is not None:
            self.path_conditions = []
            for k in m.get('pathConditions'):
                temp_model = AddCustomizeRuleRequestConditionPathConditions()
                self.path_conditions.append(temp_model.from_map(k))
        if m.get('uriParamConditions') is not None:
            self.uri_param_conditions = []
            for k in m.get('uriParamConditions'):
                temp_model = AddCustomizeRuleRequestConditionUriParamConditions()
                self.uri_param_conditions.append(temp_model.from_map(k))
        if m.get('uaConditions') is not None:
            self.ua_conditions = []
            for k in m.get('uaConditions'):
                temp_model = AddCustomizeRuleRequestConditionUaConditions()
                self.ua_conditions.append(temp_model.from_map(k))
        if m.get('headerConditions') is not None:
            self.header_conditions = []
            for k in m.get('headerConditions'):
                temp_model = AddCustomizeRuleRequestConditionHeaderConditions()
                self.header_conditions.append(temp_model.from_map(k))
        if m.get('refererConditions') is not None:
            self.referer_conditions = []
            for k in m.get('refererConditions'):
                temp_model = AddCustomizeRuleRequestConditionRefererConditions()
                self.referer_conditions.append(temp_model.from_map(k))
        if m.get('ja4Conditions') is not None:
            self.ja_4conditions = []
            for k in m.get('ja4Conditions'):
                temp_model = AddCustomizeRuleRequestConditionJa4Conditions()
                self.ja_4conditions.append(temp_model.from_map(k))
        return self


class AddCustomizeRuleRequest(TeaModel):
    def __init__(
        self,
        condition: AddCustomizeRuleRequestCondition = None,
        act: str = None,
        domain: str = None,
        rule_name: str = None,
        description: str = None,
        api_id: str = None,
        scene: str = None,
    ):
        # {"en":"Match Conditions.","zh_CN":"匹配条件。"}
        self.condition = condition
        # {"en":"Action.
        # NO_USE:Not Used
        # LOG:Log
        # DELAY:Delay
        # BLOCK:Deny
        # RESET:Reset Connection","zh_CN":"处理动作。
        # NO_USE：不使用
        # LOG：监控
        # DELAY：延迟响应
        # BLOCK：拦截
        # RESET:断开连接"}
        self.act = act
        # {"en":"Hostname.","zh_CN":"域名。"}
        self.domain = domain
        # {"en":"Rule Name, maximum 50 characters.
        # Does not support special characters and spaces.","zh_CN":"规则名称，最多50个字符。
        # 不支持特殊字符和空格。"}
        self.rule_name = rule_name
        # {"en":"Description, maximum 200 characters.","zh_CN":"规则描述，最多200个字符。"}
        self.description = description
        # {"en":"API ID under API business, multiple separated by ; sign.
        # When the protected target is APIThis field is required.","zh_CN":"API业务下的API ID，多个用 ; 隔开。
        # 当业务场景为API业务时此字段必填。"}
        self.api_id = api_id
        # {"en":"Protected target.
        # WEB:Website
        # API:API","zh_CN":"业务场景。
        # WEB：网站业务
        # API：API业务"}
        self.scene = scene

    def validate(self):
        self.validate_required(self.condition, 'condition')
        if self.condition:
            self.condition.validate()
        self.validate_required(self.act, 'act')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.scene, 'scene')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition.to_map()
        if self.act is not None:
            result['act'] = self.act
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.description is not None:
            result['description'] = self.description
        if self.api_id is not None:
            result['apiId'] = self.api_id
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            temp_model = AddCustomizeRuleRequestCondition()
            self.condition = temp_model.from_map(m['condition'])
        if m.get('act') is not None:
            self.act = m.get('act')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('apiId') is not None:
            self.api_id = m.get('apiId')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class AddCustomizeRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class AddCustomizeRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AddCustomizeRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AddCustomizeRuleResponse(TeaModel):
    def __init__(
        self,
        msg: str = None,
        code: str = None,
        data: str = None,
    ):
        # {"en":"Description.","zh_CN":"描述信息。"}
        self.msg = msg
        # {"dictionary":"belong=WAAP-MS-Ext|dict=waap_retCodeEnum","en":"Please refer to the error code for exceptions.","zh_CN":"请参照错误码。"}
        self.code = code
        # {"en":"Data.","zh_CN":"出参数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.msg is not None:
            result['msg'] = self.msg
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class AddCustomizeRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateWAFCustomRuleRequest(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        rule_name: str = None,
        rule_reg: str = None,
        msg: str = None,
        mode: str = None,
        matchzone_list: List[str] = None,
    ):
        # {"zh_CN":"规则ID。","en":"Rule ID."}
        self.rule_id = rule_id
        # {"zh_CN":"规则名称，最多50个字符。","en":"Rule Name,maximum 50 character."}
        self.rule_name = rule_name
        # {"zh_CN":"匹配条件。","en":"Match conditions."}
        self.rule_reg = rule_reg
        # {"zh_CN":"规则描述。","en":"Rule description,maximum 200 characters."}
        self.msg = msg
        # {"zh_CN":"规则动作。
        # LOG：监控
        # BLOCK：拦截
        # OFF：不使用","en":"Rule actions. 
        # LOG: Monitoring
        # BLOCK: Interception
        # OFF: Not used"}
        self.mode = mode
        # {"zh_CN":"检测区域列表。
        #     path：路径
        #     queryString：Query String
        #     header：完整请求头
        #     body：请求body
        #     uri：URI
        #     fileExt：文件后缀
        #     ","en":"Areas to detect.
        #     path: Path
        #     queryString: Query String
        #     header: Request Header
        #     body: Request Body
        #     uri: URI
        #     fileExt: File Extension"}
        self.matchzone_list = matchzone_list

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.rule_reg is not None:
            result['ruleReg'] = self.rule_reg
        if self.msg is not None:
            result['msg'] = self.msg
        if self.mode is not None:
            result['mode'] = self.mode
        if self.matchzone_list is not None:
            result['matchzoneList'] = self.matchzone_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('ruleReg') is not None:
            self.rule_reg = m.get('ruleReg')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('matchzoneList') is not None:
            self.matchzone_list = m.get('matchzoneList')
        return self


class UpdateWAFCustomRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateWAFCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateWAFCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateWAFCustomRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateWAFCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentConditionAddDto(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        path_list: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL: Equal
        # CONTAIN: Contains
        # REGEX: Regular match', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # CONTAIN：包含
        # REGEX：正则匹配'}
        self.match_type = match_type
        # {'en':'Match path. When matchType=EQUAL, it is case-sensitive and the path must start with "/". When the match type is regular, only one value is allowed.', 'zh_CN':'匹配路径。matchType=EQUAL时，大小写敏感，path必须以"/"开头，当匹配类型为正则，则只允许只有一个值。'}
        self.path_list = path_list

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.path_list, 'path_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.path_list is not None:
            result['pathList'] = self.path_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('pathList') is not None:
            self.path_list = m.get('pathList')
        return self


class UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentConditionEditDto(TeaModel):
    def __init__(
        self,
        id: str = None,
        match_type: str = None,
        path_list: List[str] = None,
    ):
        # {'en':'Match condition ID.', 'zh_CN':'匹配条件ID。'}
        self.id = id
        # {'en':'Match type.
        # EQUAL: Equal
        # CONTAIN: Contains
        # REGEX: Regular match', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # CONTAIN：包含
        # REGEX：正则匹配'}
        self.match_type = match_type
        # {'en':'Match path. When matchType=EQUAL, it is case-sensitive and the path must start with "/". When the match type is regular, only one value is allowed.', 'zh_CN':'匹配路径。matchType=EQUAL时，大小写敏感，path必须以"/"开头，当匹配类型为正则，则只允许只有一个值。'}
        self.path_list = path_list

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.path_list, 'path_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.path_list is not None:
            result['pathList'] = self.path_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('pathList') is not None:
            self.path_list = m.get('pathList')
        return self


class UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentEditDto(TeaModel):
    def __init__(
        self,
        id: str = None,
        period: int = None,
        waf_rule_type: str = None,
        duration: int = None,
        action: str = None,
        interception_count: int = None,
        type: str = None,
        condition_del_id_list: List[str] = None,
        condition_add_dto_list: List[UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentConditionAddDto] = None,
        condition_edit_dto_list: List[UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentConditionEditDto] = None,
    ):
        # {"zh_CN":"规则ID。","en":"Rule ID."}
        self.id = id
        # {"zh_CN":"周期，单位：秒，范围为 1 - 3600。","en":"Period, unit: seconds, the range is 1 - 3600."}
        self.period = period
        # {"zh_CN":"规则类型，多个用;分隔。
        # WAF_XSS：XSS跨站
        # WAF_RFI：文件包含
        # WAF_FILE_UPLOAD：文件上传
        # WAF_CMDI：命令注入
        # WAF_DIR_TRAVERSAL：目录遍历
        # WAF_THIRDCOMP：第三方组件漏洞
        # WAF_XPATH_LDAP_SSI：XPATH/LADP/SSI注入
        # WAF_SCANNER：扫码器
        # WAF_SHELL_BACKDOOR：木马后门
        # WAF_FILE_DOWNLOAD：非法下载
        # WAF_XXE：XML注入
        # WAF_SQLI：SQL注入
        # WAF_SSRF：服务端请求伪造","en":"Rule type, separate multiple ones with ;. 
        # WAF_XSS:X-Site Scripting
        # WAF_RFI:File Inclusion
        # WAF_FILE_UPLOAD:File Uploading
        # WAF_CMDI:Command Injection
        # WAF_DIR_TRAVERSAL:Directory Traversal
        # WAF_THIRDCOMP:3rd Party Component Exploit
        # WAF_XPATH_LDAP_SSI:XPATH/LADP/SSI Injection
        # WAF_SCANNER:Malicious Scan
        # WAF_SHELL_BACKDOOR:Webshell Uploading
        # WAF_FILE_DOWNLOAD:Unauthorized Download
        # WAF_XXE:XML Injection
        # WAF_SQLI:SQL Injection
        # WAF_SSRF:Server-side Request Forge"}
        self.waf_rule_type = waf_rule_type
        # {"zh_CN":"处理动作持续时间，单位：分钟，范围为 1 - 720。","en":"Action duration,  unit: minutes, the range is 1 - 720."}
        self.duration = duration
        # {"zh_CN":"处理动作。
        # BLOCK：拦截
        # NO_USE：不使用","en":"Action.
        # BLOCK: Deny
        # NO_USE: Do not use"}
        self.action = action
        # {"zh_CN":"拦截阈值，范围为 1 - 100。","en":"Interception threshold, the range is 1 - 100."}
        self.interception_count = interception_count
        # {"zh_CN":"路径类型。
        # ALL：所有路径
        # SPECIFY：指定路径
        # ","en":"Path type. 
        # ALL: All paths
        # SPECIFY: Specific paths
        # "}
        self.type = type
        # {"zh_CN":"删除匹配条件ID。","en":"Delete matching condition ID."}
        self.condition_del_id_list = condition_del_id_list
        # {"zh_CN":"新增匹配条件对象。","en":"Add matching condition object."}
        self.condition_add_dto_list = condition_add_dto_list
        # {"zh_CN":"修改匹配条件对象。","en":"Modify matching condition object."}
        self.condition_edit_dto_list = condition_edit_dto_list

    def validate(self):
        self.validate_required(self.id, 'id')
        if self.condition_add_dto_list:
            for k in self.condition_add_dto_list:
                if k:
                    k.validate()
        if self.condition_edit_dto_list:
            for k in self.condition_edit_dto_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.period is not None:
            result['period'] = self.period
        if self.waf_rule_type is not None:
            result['wafRuleType'] = self.waf_rule_type
        if self.duration is not None:
            result['duration'] = self.duration
        if self.action is not None:
            result['action'] = self.action
        if self.interception_count is not None:
            result['interceptionCount'] = self.interception_count
        if self.type is not None:
            result['type'] = self.type
        if self.condition_del_id_list is not None:
            result['conditionDelIdList'] = self.condition_del_id_list
        if self.condition_add_dto_list is not None:
            result['conditionAddDtoList'] = []
            for k in self.condition_add_dto_list:
                result['conditionAddDtoList'].append(k.to_map() if k else None)
        if self.condition_edit_dto_list is not None:
            result['conditionEditDtoList'] = []
            for k in self.condition_edit_dto_list:
                result['conditionEditDtoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('wafRuleType') is not None:
            self.waf_rule_type = m.get('wafRuleType')
        if m.get('duration') is not None:
            self.duration = m.get('duration')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('interceptionCount') is not None:
            self.interception_count = m.get('interceptionCount')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('conditionDelIdList') is not None:
            self.condition_del_id_list = m.get('conditionDelIdList')
        if m.get('conditionAddDtoList') is not None:
            self.condition_add_dto_list = []
            for k in m.get('conditionAddDtoList'):
                temp_model = UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentConditionAddDto()
                self.condition_add_dto_list.append(temp_model.from_map(k))
        if m.get('conditionEditDtoList') is not None:
            self.condition_edit_dto_list = []
            for k in m.get('conditionEditDtoList'):
                temp_model = UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentConditionEditDto()
                self.condition_edit_dto_list.append(temp_model.from_map(k))
        return self


class UpdateConfigurationOfAttackerIPPunishmentRequest(TeaModel):
    def __init__(
        self,
        edit_dto_list: List[UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentEditDto] = None,
    ):
        # {'en':'Attack IP penalty modification object.', 'zh_CN':'攻击IP惩罚修改对象列表。'}
        self.edit_dto_list = edit_dto_list

    def validate(self):
        self.validate_required(self.edit_dto_list, 'edit_dto_list')
        if self.edit_dto_list:
            for k in self.edit_dto_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.edit_dto_list is not None:
            result['editDtoList'] = []
            for k in self.edit_dto_list:
                result['editDtoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('editDtoList') is not None:
            self.edit_dto_list = []
            for k in m.get('editDtoList'):
                temp_model = UpdateConfigurationOfAttackerIPPunishmentWafDomainIpPunishmentEditDto()
                self.edit_dto_list.append(temp_model.from_map(k))
        return self


class UpdateConfigurationOfAttackerIPPunishmentResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: bool = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'修改成功标识。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateConfigurationOfAttackerIPPunishmentPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateConfigurationOfAttackerIPPunishmentParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateConfigurationOfAttackerIPPunishmentRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateConfigurationOfAttackerIPPunishmentResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class RemoveDomainsForCustomRuleRequest(TeaModel):
    def __init__(
        self,
        rule_id_list: List[int] = None,
        domain_list: List[str] = None,
    ):
        # {"en":"Rule ID,array.", "zh_CN":"规则ID，数组。"}
        self.rule_id_list = rule_id_list
        # {"en":"Domain to remove from the specified rule, array.", "zh_CN":"要从指定自定义规则中移除的域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.rule_id_list, 'rule_id_list')
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id_list is not None:
            result['ruleIdList'] = self.rule_id_list
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleIdList') is not None:
            self.rule_id_list = m.get('ruleIdList')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class RemoveDomainsForCustomRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class RemoveDomainsForCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class RemoveDomainsForCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class RemoveDomainsForCustomRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class RemoveDomainsForCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetApiListRequest(TeaModel):
    def __init__(
        self,
        page: str = None,
        size: str = None,
        api_group: str = None,
        api_name: str = None,
        domains: str = None,
        front_path: str = None,
        order: str = None,
        sort_by: str = None,
    ):
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.page = page
        # {"en":"The number of records per page.", "zh_CN":"每页API条数。"}
        self.size = size
        # {"en":"API group,multiple use \";\" split.", "zh_CN":"API分组，多个用;分隔。"}
        self.api_group = api_group
        # {"en":"API name.", "zh_CN":"API名称。"}
        self.api_name = api_name
        # {"en":"Domain,multiple use \";\" split.", "zh_CN":"域名，多个用;分隔。"}
        self.domains = domains
        # {"en":"Endpoint path.", "zh_CN":"前端路径。"}
        self.front_path = front_path
        # {"en":"Sort order.
        # desc:Descending
        # asc:Ascending.", "zh_CN":"排序顺序。
        # desc：降序
        # asc：升序。"}
        self.order = order
        # {"en":"Sort field.
        # Example: updateTime.", "zh_CN":"排序字段。
        # 例：updateTime。"}
        self.sort_by = sort_by

    def validate(self):
        self.validate_required(self.page, 'page')
        self.validate_required(self.size, 'size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.size is not None:
            result['size'] = self.size
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.api_name is not None:
            result['apiName'] = self.api_name
        if self.domains is not None:
            result['domains'] = self.domains
        if self.front_path is not None:
            result['frontPath'] = self.front_path
        if self.order is not None:
            result['order'] = self.order
        if self.sort_by is not None:
            result['sortBy'] = self.sort_by
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('apiName') is not None:
            self.api_name = m.get('apiName')
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        if m.get('frontPath') is not None:
            self.front_path = m.get('frontPath')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('sortBy') is not None:
            self.sort_by = m.get('sortBy')
        return self


class GetApiListApiParamsLimit(TeaModel):
    def __init__(
        self,
        api_id: str = None,
        body: str = None,
        body_flag: bool = None,
        body_type: str = None,
        create_time: str = None,
        id: str = None,
        params_limit: str = None,
        request_method: str = None,
        update_time: str = None,
    ):
        # {"en":"API ID", "zh_CN":"API ID。"}
        self.api_id = api_id
        # {"en":"Body parameter.", "zh_CN":"Body参数。"}
        self.body = body
        # {"en":"Whether to define body parameter.", "zh_CN":"否定义Body参数。"}
        self.body_flag = body_flag
        # {"en":"Body parameter type,default value:FORM.
        # FORM:Form
        # JSON_XML:Json format definition", "zh_CN":"Body参数类型，默认值：FORM。
        # FORM：Form表单
        # JSON_XML：Json格式定义"}
        self.body_type = body_type
        # {"en":"Create time,format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"创建时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.create_time = create_time
        # {"en":"Data ID.", "zh_CN":"数据ID。"}
        self.id = id
        # {"en":"Parameter limit.", "zh_CN":"参数限制。"}
        self.params_limit = params_limit
        # {"en":"Request method,default value:GET.
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE", "zh_CN":"请求方法，默认值：GET。
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE"}
        self.request_method = request_method
        # {"en":"Update time,format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"修改时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.body, 'body')
        self.validate_required(self.body_flag, 'body_flag')
        self.validate_required(self.body_type, 'body_type')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.id, 'id')
        self.validate_required(self.params_limit, 'params_limit')
        self.validate_required(self.request_method, 'request_method')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['apiId'] = self.api_id
        if self.body is not None:
            result['body'] = self.body
        if self.body_flag is not None:
            result['bodyFlag'] = self.body_flag
        if self.body_type is not None:
            result['bodyType'] = self.body_type
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.id is not None:
            result['id'] = self.id
        if self.params_limit is not None:
            result['paramsLimit'] = self.params_limit
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiId') is not None:
            self.api_id = m.get('apiId')
        if m.get('body') is not None:
            self.body = m.get('body')
        if m.get('bodyFlag') is not None:
            self.body_flag = m.get('bodyFlag')
        if m.get('bodyType') is not None:
            self.body_type = m.get('bodyType')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('paramsLimit') is not None:
            self.params_limit = m.get('paramsLimit')
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetApiListAuthConfig(TeaModel):
    def __init__(
        self,
        auth_param_name: str = None,
        auth_param_site: str = None,
        auth_type: str = None,
        auth_validity_time: int = None,
    ):
        # {"en":"Authentication parameter name.", "zh_CN":"鉴权参数名称。"}
        self.auth_param_name = auth_param_name
        # {"en":"Authentication parameter location.", "zh_CN":"鉴权参数位置。"}
        self.auth_param_site = auth_param_site
        # {"en":"Authentication method.", "zh_CN":"鉴权方法。"}
        self.auth_type = auth_type
        # {"en":"Authentication Token Validity Period(second)", "zh_CN":"鉴权有效期（s）。"}
        self.auth_validity_time = auth_validity_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_param_name is not None:
            result['authParamName'] = self.auth_param_name
        if self.auth_param_site is not None:
            result['authParamSite'] = self.auth_param_site
        if self.auth_type is not None:
            result['authType'] = self.auth_type
        if self.auth_validity_time is not None:
            result['authValidityTime'] = self.auth_validity_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authParamName') is not None:
            self.auth_param_name = m.get('authParamName')
        if m.get('authParamSite') is not None:
            self.auth_param_site = m.get('authParamSite')
        if m.get('authType') is not None:
            self.auth_type = m.get('authType')
        if m.get('authValidityTime') is not None:
            self.auth_validity_time = m.get('authValidityTime')
        return self


class GetApiListRequestBodyConfig(TeaModel):
    def __init__(
        self,
        body_limit_max: int = None,
        content_type: str = None,
        nest_max: int = None,
        params_count_max: int = None,
        params_limit_switch: bool = None,
        params_processing_model: str = None,
        request_body_limit_switch: bool = None,
        request_processing_action: str = None,
    ):
        # {"en":"Maximum body limit(bytes).", "zh_CN":"Body最大限制(bytes)。"}
        self.body_limit_max = body_limit_max
        # {"en":"HTTP content type of the response.", "zh_CN":"内容类型Content-Type。"}
        self.content_type = content_type
        # {"en":"Maximum nesting depth.", "zh_CN":"最大嵌套层数。"}
        self.nest_max = nest_max
        # {"en":"Maximum number of parameters for JSON.", "zh_CN":"Json最大参数个数。"}
        self.params_count_max = params_count_max
        # {"en":"Parameter limit switch.", "zh_CN":"参数限制开关。"}
        self.params_limit_switch = params_limit_switch
        # {"en":"Query string parameter detection mode.", "zh_CN":"query string参数检测模式。"}
        self.params_processing_model = params_processing_model
        # {"en":"Request body limit switch.", "zh_CN":"请求Body限制开关。"}
        self.request_body_limit_switch = request_body_limit_switch
        # {"en":"The action to execute when a rule is matched,default value:2.
        # 1:Block
        # 2:Log
        # 3:Sign", "zh_CN":"处理动作，默认值：2。
        # 1：拦截
        # 2：监控
        # 3：标记"}
        self.request_processing_action = request_processing_action

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body_limit_max is not None:
            result['bodyLimitMax'] = self.body_limit_max
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.nest_max is not None:
            result['nestMax'] = self.nest_max
        if self.params_count_max is not None:
            result['paramsCountMax'] = self.params_count_max
        if self.params_limit_switch is not None:
            result['paramsLimitSwitch'] = self.params_limit_switch
        if self.params_processing_model is not None:
            result['paramsProcessingModel'] = self.params_processing_model
        if self.request_body_limit_switch is not None:
            result['requestBodyLimitSwitch'] = self.request_body_limit_switch
        if self.request_processing_action is not None:
            result['requestProcessingAction'] = self.request_processing_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bodyLimitMax') is not None:
            self.body_limit_max = m.get('bodyLimitMax')
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('nestMax') is not None:
            self.nest_max = m.get('nestMax')
        if m.get('paramsCountMax') is not None:
            self.params_count_max = m.get('paramsCountMax')
        if m.get('paramsLimitSwitch') is not None:
            self.params_limit_switch = m.get('paramsLimitSwitch')
        if m.get('paramsProcessingModel') is not None:
            self.params_processing_model = m.get('paramsProcessingModel')
        if m.get('requestBodyLimitSwitch') is not None:
            self.request_body_limit_switch = m.get('requestBodyLimitSwitch')
        if m.get('requestProcessingAction') is not None:
            self.request_processing_action = m.get('requestProcessingAction')
        return self


class GetApiListApiInfo(TeaModel):
    def __init__(
        self,
        api_case: int = None,
        api_conceal: str = None,
        api_type: str = None,
        api_group: str = None,
        api_name: str = None,
        api_params_limit_list: List[GetApiListApiParamsLimit] = None,
        auth_config: GetApiListAuthConfig = None,
        auth_key: str = None,
        create_time: str = None,
        deploy_status: str = None,
        domains: str = None,
        front_path: str = None,
        front_path_type: int = None,
        id: str = None,
        path_match_type: str = None,
        remark: str = None,
        request_body_config: GetApiListRequestBodyConfig = None,
        request_method: str = None,
        status: str = None,
        update_time: str = None,
        version: str = None,
    ):
        # {"en":"Case sensitive,default value:0.
        # 0:False
        # 1:True.", "zh_CN":"大小写敏感，默认值：0。
        #  0：否
        # 1：是。"}
        self.api_case = api_case
        # {"en":"API privacy,default value:PUBLIC.
        # PUBLIC:Public,the consumer does not need to associate with the API, and can access the public API assets only by passing the authentication.
        # PRIVATE:Private,you need to create a consumer and associate with the API to access private API assets.", "zh_CN":"API隐私，默认值：PUBLIC。
        # PUBLIC：公开，消费方无需绑定API，仅鉴权通过即可访问公开API资产。
        # PRIVATE：私有，需要创建消费方并绑定API，方可访问私有API资产。"}
        self.api_conceal = api_conceal
        # {"en":"API type,default value:NORMAL.
        # NORMAL:Normal API,the path does not contain query string parameters,such as http://www.test.com/api.
        # WHEN_CASE:When case,the path contains query string parameters,such as http://www.test.com/api?action=1 and http://www.test.com/api?action=2 are two different APIs.", "zh_CN":"API类型，默认值：NORMAL。
        # NORMAL：普通接口，路径中不包含query string参数的普通接口，如http://www.test.com/api。
        # WHEN_CASE：when_case接口，路径中包含query string参数，如http://www.test.com/api?action=1与http://www.test.com/api?action=2 是两个不同的接口。"}
        self.api_type = api_type
        # {"en":"API group", "zh_CN":"API分组。"}
        self.api_group = api_group
        # {"en":"API name", "zh_CN":"API名称。"}
        self.api_name = api_name
        # {"en":"Parameter limit configuration.", "zh_CN":"参数限制。"}
        self.api_params_limit_list = api_params_limit_list
        # {"en":"Authentication configuration.", "zh_CN":"鉴权配置。"}
        self.auth_config = auth_config
        # {"en":"Authentication key.", "zh_CN":"鉴权秘钥。"}
        self.auth_key = auth_key
        # {"en":"Create time,format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"创建时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.create_time = create_time
        # {"en":"Deployment status, DEPLOYED:Deployment succeeded
        # DEPLOYING:Deploying
        # UNDEPLOY:Not deployed
        # DEPLOY_FAIL:Deployment failed.", "zh_CN":"部署状态，DEPLOYED：部署成功
        # DEPLOYING：部署中
        # UNDEPLOY：未部署
        # DEPLOY_FAIL：部署失败。"}
        self.deploy_status = deploy_status
        # {"en":"Domain,multiple use \";\" split.", "zh_CN":"域名，多个用;隔开。"}
        self.domains = domains
        # {"en":"Endpoint path.", "zh_CN":"前端路径。"}
        self.front_path = front_path
        # {"en":"Match parameters in the path,default value:0.
        # 0:False
        # 1:True
        # ", "zh_CN":"前端路径类型，默认值：0。
        #  0：否
        # 1：是
        # "}
        self.front_path_type = front_path_type
        # {"en":"API ID", "zh_CN":"API ID。"}
        self.id = id
        # {"en":"Path matching type,default value:DICT.
        # DICT:Complete matching
        #  REGEX:Regular matching", "zh_CN":"路径匹配类型，默认值：DICT。
        # DICT：完整匹配
        #  REGEX：正则匹配"}
        self.path_match_type = path_match_type
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark
        # {"en":"Request body limit configuration.", "zh_CN":"请求Body限制配置。"}
        self.request_body_config = request_body_config
        # {"en":"Request Methods,multiple use \";\" split,default value:GET.
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE", "zh_CN":"请求方法，多个用;隔开，默认值：GET。
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE"}
        self.request_method = request_method
        # {"en":"API status,ACTIVE:Active
        # STOP:Deactivate.", "zh_CN":"API状态，ACTIVE：激活
        # STOP：停用"}
        self.status = status
        # {"en":"Update time,format: yyyy-MM-dd HH:mm:ss..", "zh_CN":"修改时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.update_time = update_time
        # {"en":"Version.", "zh_CN":"版本。"}
        self.version = version

    def validate(self):
        self.validate_required(self.api_case, 'api_case')
        self.validate_required(self.api_conceal, 'api_conceal')
        self.validate_required(self.api_type, 'api_type')
        self.validate_required(self.api_group, 'api_group')
        self.validate_required(self.api_name, 'api_name')
        self.validate_required(self.api_params_limit_list, 'api_params_limit_list')
        if self.api_params_limit_list:
            for k in self.api_params_limit_list:
                if k:
                    k.validate()
        self.validate_required(self.auth_config, 'auth_config')
        if self.auth_config:
            self.auth_config.validate()
        self.validate_required(self.auth_key, 'auth_key')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.deploy_status, 'deploy_status')
        self.validate_required(self.domains, 'domains')
        self.validate_required(self.front_path, 'front_path')
        self.validate_required(self.front_path_type, 'front_path_type')
        self.validate_required(self.id, 'id')
        self.validate_required(self.path_match_type, 'path_match_type')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.request_body_config, 'request_body_config')
        if self.request_body_config:
            self.request_body_config.validate()
        self.validate_required(self.request_method, 'request_method')
        self.validate_required(self.status, 'status')
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.version, 'version')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_case is not None:
            result['apiCase'] = self.api_case
        if self.api_conceal is not None:
            result['apiConceal'] = self.api_conceal
        if self.api_type is not None:
            result['apiType'] = self.api_type
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.api_name is not None:
            result['apiName'] = self.api_name
        if self.api_params_limit_list is not None:
            result['apiParamsLimitList'] = []
            for k in self.api_params_limit_list:
                result['apiParamsLimitList'].append(k.to_map() if k else None)
        if self.auth_config is not None:
            result['authConfig'] = self.auth_config.to_map()
        if self.auth_key is not None:
            result['authKey'] = self.auth_key
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.deploy_status is not None:
            result['deployStatus'] = self.deploy_status
        if self.domains is not None:
            result['domains'] = self.domains
        if self.front_path is not None:
            result['frontPath'] = self.front_path
        if self.front_path_type is not None:
            result['frontPathType'] = self.front_path_type
        if self.id is not None:
            result['id'] = self.id
        if self.path_match_type is not None:
            result['pathMatchType'] = self.path_match_type
        if self.remark is not None:
            result['remark'] = self.remark
        if self.request_body_config is not None:
            result['requestBodyConfig'] = self.request_body_config.to_map()
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        if self.status is not None:
            result['status'] = self.status
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiCase') is not None:
            self.api_case = m.get('apiCase')
        if m.get('apiConceal') is not None:
            self.api_conceal = m.get('apiConceal')
        if m.get('apiType') is not None:
            self.api_type = m.get('apiType')
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('apiName') is not None:
            self.api_name = m.get('apiName')
        if m.get('apiParamsLimitList') is not None:
            self.api_params_limit_list = []
            for k in m.get('apiParamsLimitList'):
                temp_model = GetApiListApiParamsLimit()
                self.api_params_limit_list.append(temp_model.from_map(k))
        if m.get('authConfig') is not None:
            temp_model = GetApiListAuthConfig()
            self.auth_config = temp_model.from_map(m['authConfig'])
        if m.get('authKey') is not None:
            self.auth_key = m.get('authKey')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('deployStatus') is not None:
            self.deploy_status = m.get('deployStatus')
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        if m.get('frontPath') is not None:
            self.front_path = m.get('frontPath')
        if m.get('frontPathType') is not None:
            self.front_path_type = m.get('frontPathType')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('pathMatchType') is not None:
            self.path_match_type = m.get('pathMatchType')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('requestBodyConfig') is not None:
            temp_model = GetApiListRequestBodyConfig()
            self.request_body_config = temp_model.from_map(m['requestBodyConfig'])
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class GetApiListPage(TeaModel):
    def __init__(
        self,
        current: int = None,
        pages: int = None,
        size: int = None,
        total: int = None,
        records: List[GetApiListApiInfo] = None,
    ):
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"The total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The number of records per page.", "zh_CN":"每页记录条数。"}
        self.size = size
        # {"en":"The total number of records.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"Records.", "zh_CN":"记录。"}
        self.records = records

    def validate(self):
        self.validate_required(self.current, 'current')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.size, 'size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current is not None:
            result['current'] = self.current
        if self.pages is not None:
            result['pages'] = self.pages
        if self.size is not None:
            result['size'] = self.size
        if self.total is not None:
            result['total'] = self.total
        if self.records is not None:
            result['records'] = []
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('records') is not None:
            self.records = []
            for k in m.get('records'):
                temp_model = GetApiListApiInfo()
                self.records.append(temp_model.from_map(k))
        return self


class GetApiListResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: GetApiListPage = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"List of API datas.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            temp_model = GetApiListPage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetApiListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetApiListParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetApiListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetApiListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetCustomRuleListRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        domain_list: List[str] = None,
        mode_list: List[int] = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # {"en":"Rule name, support fuzzy queries.", "zh_CN":"规则名称，支持模糊查询。"}
        self.name = name
        # {"en":"Correlation domain name, array.", "zh_CN":"关联域名，数组。"}
        self.domain_list = domain_list
        # {"en":"The action to execute when a rule is matched.
        #     0: Off
        #     1: Block
        #     2: Log", "zh_CN":"触发规则时的处理动作。
        #     0：关闭
        #     1：拦截
        #     2：监控"}
        self.mode_list = mode_list
        # {"en":"Current page number,1 by default.", "zh_CN":"当前页数，默认1。"}
        self.page_num = page_num
        # {"en":"Number each page,the maximum 1000,10 by default.", "zh_CN":"每页数量, 最大1000，默认10。"}
        self.page_size = page_size

    def validate(self):
        if self.page_size is not None:
            self.validate_maximum(self.page_size, 'page_size', 1000)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.mode_list is not None:
            result['modeList'] = self.mode_list
        if self.page_num is not None:
            result['pageNum'] = self.page_num
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('modeList') is not None:
            self.mode_list = m.get('modeList')
        if m.get('pageNum') is not None:
            self.page_num = m.get('pageNum')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class GetCustomRuleListCustomRule(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        rule_name: str = None,
        mode: int = None,
        rule_reg: str = None,
        msg: str = None,
        match_zone_merge: List[str] = None,
        status_code: str = None,
        domain_list: List[str] = None,
    ):
        # {"en":"Rule ID.", "zh_CN":"规则ID。"}
        self.rule_id = rule_id
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.rule_name = rule_name
        # {"en":"The action to execute when a rule is matched.
        #     0: Off
        #     1: Block
        #     2: Log", "zh_CN":"触发规则时的处理动作。
        #     0：关闭
        #     1：拦截
        #     2：监控"}
        self.mode = mode
        # {"en":"Regular expressions.", "zh_CN":"正则表达式。"}
        self.rule_reg = rule_reg
        # {"en":"Rule description.", "zh_CN":"规则描述。"}
        self.msg = msg
        # {"en":"Matching area,array,
        #     url:URL(without param)
        #     urlParam:URL Param
        #     headers:Headers
        #     body:Body
        #     response:Response
        #     fileExt:Upload File Extension
        #     fileContent:Upload File Content", "zh_CN":"匹配区域，数组，
        #     url：URL（不含参数）
        #     urlParam：URL参数
        #     headers：请求头
        #     body：请求体
        #     response：响应体
        #     fileExt：上传文件后缀
        #     fileContent：上传文件内容"}
        self.match_zone_merge = match_zone_merge
        # {"en":"Status codek,English half width comma splicing.
        #     2: 2xx
        #     3: 3xx
        #     4: 4xx
        #     5: 5xx", "zh_CN":"状态码，英文半角逗号分隔。
        #     2：2xx
        #     3：3xx
        #     4：4xx
        #     5：5xx"}
        self.status_code = status_code
        # {"en":"Correlation domain name, array.", "zh_CN":"关联域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.rule_reg, 'rule_reg')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.match_zone_merge, 'match_zone_merge')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.mode is not None:
            result['mode'] = self.mode
        if self.rule_reg is not None:
            result['ruleReg'] = self.rule_reg
        if self.msg is not None:
            result['msg'] = self.msg
        if self.match_zone_merge is not None:
            result['matchZoneMerge'] = self.match_zone_merge
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('ruleReg') is not None:
            self.rule_reg = m.get('ruleReg')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('matchZoneMerge') is not None:
            self.match_zone_merge = m.get('matchZoneMerge')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class GetCustomRuleListCustomRulePage(TeaModel):
    def __init__(
        self,
        total: int = None,
        pages: int = None,
        current: int = None,
        size: int = None,
        records: List[GetCustomRuleListCustomRule] = None,
    ):
        # {"en":"The total number of data.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"Total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"Number each page.", "zh_CN":"每页数量。"}
        self.size = size
        # {"en":"Template information,array.", "zh_CN":"数据列表，数组。"}
        self.records = records

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.current, 'current')
        self.validate_required(self.size, 'size')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['total'] = self.total
        if self.pages is not None:
            result['pages'] = self.pages
        if self.current is not None:
            result['current'] = self.current
        if self.size is not None:
            result['size'] = self.size
        if self.records is not None:
            result['records'] = []
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('records') is not None:
            self.records = []
            for k in m.get('records'):
                temp_model = GetCustomRuleListCustomRule()
                self.records.append(temp_model.from_map(k))
        return self


class GetCustomRuleListResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: GetCustomRuleListCustomRulePage = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message
        # {"en":"Return data.", "zh_CN":"返回值。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = GetCustomRuleListCustomRulePage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetCustomRuleListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetCustomRuleListParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetCustomRuleListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetCustomRuleListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteQuotaRuleRequest(TeaModel):
    def __init__(
        self,
        ids: List[str] = None,
    ):
        # {"en":"List of quota rule ID to delete.", "zh_CN":"要删除的配额规则ID列表。"}
        self.ids = ids

    def validate(self):
        self.validate_required(self.ids, 'ids')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ids') is not None:
            self.ids = m.get('ids')
        return self


class DeleteQuotaRuleResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: List[str] = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"List of deleted quota rule name.", "zh_CN":"被删除的配额规则名称列表。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class DeleteQuotaRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteQuotaRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteQuotaRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteQuotaRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryExactRuleListByDomainRequest(TeaModel):
    def __init__(
        self,
        service_type: str = None,
        domain_list: List[str] = None,
    ):
        # {"en":"Service name. 
        #  WAF:Web Application Firewall 
        #  BOT:Bot Shield 
        #  API:API Shield 
        #  DDoS:DDoS Protection ", "zh_CN":"服务名称。
        #  WAF：WEB应用防火墙 
        #  BOT：BotGuard爬虫管理 
        #  API：API安全与管理 
        #  DDoS: DMS"}
        self.service_type = service_type
        # {"en":"Related domain.", "zh_CN":"关联域名。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.service_type, 'service_type')
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class QueryExactRuleListByDomainCondition(TeaModel):
    def __init__(
        self,
        match_condition: str = None,
        operator: str = None,
        first_condition: str = None,
        second_condition: str = None,
    ):
        # {"en":"Matching condition type.
        #  0:IP 
        #  1:IP Segment 
        #  2:URI 
        #  3:User-Agent 
        #  4:Cookie 
        #  5:Referer 
        #  6:HTTP Header 
        #  7:Area 
        #  8:HTTP Method 
        #  9:Path  ", "zh_CN":"匹配条件类型。0：IP 
        #  1：IP段 
        #  2：URI  
        #  3：User-agent 
        #  4：Cookie 
        #  5：Referer 
        #  6：HTTP Header 
        #   7：区域 
        #  8：请求方法 
        #  9：路径 "}
        self.match_condition = match_condition
        # {"en":"Matching condition operation.
        #  0:=\
        #  1:!=\
        #  2:Empty or doesn't exist 
        #  3:=(Regex) 
        #  4:!=(Regex) ", "zh_CN":"匹配条件操作。
        #  0：=\
        #  1：!=\
        #  2：为空或不存在 
        #  3：=正则 
        #  4：!=正则 "}
        self.operator = operator
        # {"en":"First QueryExactRuleListByDomainCondition.", "zh_CN":"第一匹配条件值。"}
        self.first_condition = first_condition
        # {"en":"Second QueryExactRuleListByDomainCondition.", "zh_CN":"第二匹配条件值。"}
        self.second_condition = second_condition

    def validate(self):
        self.validate_required(self.match_condition, 'match_condition')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_condition is not None:
            result['matchCondition'] = self.match_condition
        if self.operator is not None:
            result['operator'] = self.operator
        if self.first_condition is not None:
            result['firstCondition'] = self.first_condition
        if self.second_condition is not None:
            result['secondCondition'] = self.second_condition
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchCondition') is not None:
            self.match_condition = m.get('matchCondition')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('firstCondition') is not None:
            self.first_condition = m.get('firstCondition')
        if m.get('secondCondition') is not None:
            self.second_condition = m.get('secondCondition')
        return self


class QueryExactRuleListByDomainResp(TeaModel):
    def __init__(
        self,
        rule_id: str = None,
        rule_name: str = None,
        rule_description: str = None,
        action: str = None,
        deploy_content: List[QueryExactRuleListByDomainCondition] = None,
    ):
        # {"en":"Rule id.", "zh_CN":"规则ID。"}
        self.rule_id = rule_id
        # {"en":"Rule Name.", "zh_CN":"规则名。"}
        self.rule_name = rule_name
        # {"en":"Rule Description.", "zh_CN":"规则描述。"}
        self.rule_description = rule_description
        # {"en":"Action. 
        #  0:Bypass  
        # 1:Block 
        #  2:Log ", "zh_CN":"处理动作。
        #  0：放行 
        #  1：拦截 
        #  2：监控"}
        self.action = action
        # {"en":"Match QueryExactRuleListByDomainCondition.", "zh_CN":"匹配条件。"}
        self.deploy_content = deploy_content

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.action, 'action')
        self.validate_required(self.deploy_content, 'deploy_content')
        if self.deploy_content:
            for k in self.deploy_content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.rule_description is not None:
            result['ruleDescription'] = self.rule_description
        if self.action is not None:
            result['action'] = self.action
        if self.deploy_content is not None:
            result['deployContent'] = []
            for k in self.deploy_content:
                result['deployContent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('ruleDescription') is not None:
            self.rule_description = m.get('ruleDescription')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('deployContent') is not None:
            self.deploy_content = []
            for k in m.get('deployContent'):
                temp_model = QueryExactRuleListByDomainCondition()
                self.deploy_content.append(temp_model.from_map(k))
        return self


class QueryExactRuleListByDomainResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryExactRuleListByDomainResp = None,
    ):
        # {"en":"Status code, success is '200'.", "zh_CN":"状态码，成功为“200”。"}
        self.code = code
        # {"en":"Return message, success is 'Success'.", "zh_CN":"返回信息，成功为“Success”。"}
        self.message = message
        # {"en":"Data returned", "zh_CN":"返回数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryExactRuleListByDomainResp()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryExactRuleListByDomainPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryExactRuleListByDomainParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryExactRuleListByDomainRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryExactRuleListByDomainResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateDomainBuiltInRulesDTO(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_id: str = None,
        security_level: str = None,
        action: str = None,
    ):
        # {"en":"domain", "zh_CN":"domain"}
        self.domain = domain
        # {"en":"ruleId", "zh_CN":"规则ID"}
        self.rule_id = rule_id
        # {"en":"Security level, default enabled: 'DEFAULT_ ENABLE ', enable during attack:' ATTACK_ ENABLE ', basic off:' BASE_ Close ', permanently closed:' Close '", "zh_CN":"安全级别，默认启用:'DEFAULT_ENABLE'，攻击时启用：'ATTACK_ENABLE'，基本关闭：'BASE_CLOSE'，永久关闭:'CLOSE'"}
        self.security_level = security_level
        # {"en":"Processing actions: 1: 'Interception', 2: 'Monitoring', 4: Human machine verification, 8: 'Reject connection'", "zh_CN":"处理动作:1:'拦截' ,2:'监控', 4:人机校验,8：'拒绝连接'"}
        self.action = action

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.security_level, 'security_level')
        self.validate_required(self.action, 'action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.security_level is not None:
            result['securityLevel'] = self.security_level
        if self.action is not None:
            result['action'] = self.action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('securityLevel') is not None:
            self.security_level = m.get('securityLevel')
        if m.get('action') is not None:
            self.action = m.get('action')
        return self


class UpdateDomainBuiltInRulesRequest(TeaModel):
    def __init__(
        self,
        data: List[UpdateDomainBuiltInRulesDTO] = None,
    ):
        # {"en":"data", "zh_CN":"data"}
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = UpdateDomainBuiltInRulesDTO()
                self.data.append(temp_model.from_map(k))
        return self


class UpdateDomainBuiltInRulesResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
    ):
        # {"en":"code", "zh_CN":"code"}
        self.code = code
        # {"en":"msg", "zh_CN":"msg"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateDomainBuiltInRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainBuiltInRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainBuiltInRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateDomainBuiltInRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class WssMPNetworkServiceDeleteRequest(TeaModel):
    def __init__(
        self,
        ids: str = None,
    ):
        # {"en":"id（cname）", "zh_CN":"id（查询cname）"}
        self.ids = ids

    def validate(self):
        self.validate_required(self.ids, 'ids')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ids') is not None:
            self.ids = m.get('ids')
        return self


class WssMPNetworkServiceDeleteResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {"en":"200:success other code means failed", "zh_CN":"200:成功，其他失败"}
        self.code = code
        # {"en":"SUCCESS or error message", "zh_CN":"成功=SUCCESS，其他返回错误信息"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class WssMPNetworkServiceDeletePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class WssMPNetworkServiceDeleteParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class WssMPNetworkServiceDeleteRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class WssMPNetworkServiceDeleteResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateBotFunctionSwitchRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        scene_analyse_switch: str = None,
        behavior_analyse_switch: str = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Client-based Detection function switch.
        # ON: Enabled
        # OFF: Disabled', 'zh_CN':'客户端风险检测功能开关。
        # ON：开启
        # OFF：关闭'}
        self.scene_analyse_switch = scene_analyse_switch
        # {'en':'Workflow Detection function switch.
        # ON: Enabled
        # OFF: Disabled', 'zh_CN':'业务流检测功能开关。
        # ON：开启
        # OFF：关闭'}
        self.behavior_analyse_switch = behavior_analyse_switch

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.scene_analyse_switch is not None:
            result['sceneAnalyseSwitch'] = self.scene_analyse_switch
        if self.behavior_analyse_switch is not None:
            result['behaviorAnalyseSwitch'] = self.behavior_analyse_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('sceneAnalyseSwitch') is not None:
            self.scene_analyse_switch = m.get('sceneAnalyseSwitch')
        if m.get('behaviorAnalyseSwitch') is not None:
            self.behavior_analyse_switch = m.get('behaviorAnalyseSwitch')
        return self


class UpdateBotFunctionSwitchResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateBotFunctionSwitchPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateBotFunctionSwitchParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateBotFunctionSwitchRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateBotFunctionSwitchResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListRecommendationsRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
        rule_id_list: List[int] = None,
    ):
        # {'en':'Hostname list.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list
        # {'en':'WAF rule ID list.', 'zh_CN':'WAF规则ID列表。'}
        self.rule_id_list = rule_id_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')
        self.validate_required(self.rule_id_list, 'rule_id_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.rule_id_list is not None:
            result['ruleIdList'] = self.rule_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('ruleIdList') is not None:
            self.rule_id_list = m.get('ruleIdList')
        return self


class ListRecommendationsWafDomainAiRuleResultVO(TeaModel):
    def __init__(
        self,
        id: str = None,
        domain: str = None,
        rule_id: int = None,
        type: str = None,
        match_type: str = None,
        content: str = None,
        status: str = None,
        update_time: str = None,
    ):
        # {'en':'Rule suggestion ID.', 'zh_CN':'规则建议ID。'}
        self.id = id
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'WAF rule ID.', 'zh_CN':'WAF规则ID。'}
        self.rule_id = rule_id
        # {'en':'Matching conditions.
        # ip: IP
        # path: Path
        # uri: URI
        # urlParamName: URI Parameter Name
        # urlParamValue: URI Parameter Value
        # userAgent: User Agent
        # httpHeaderName: Request Header Name
        # httpHeaderValue: Request Header Value
        # cookie: Cookie
        # body: Body
        # bodyParamName: Body Parameter Name
        # bodyParamValue: Body Parameter Value', 'zh_CN':'匹配条件。
        # ip：IP
        # path：路径
        # uri：URI
        # urlParamName：URI参数名
        # urlParamValue：URI参数值
        # userAgent：User Agent
        # httpHeaderName：请求头部名称
        # httpHeaderValue：请求头部值
        # cookie：Cookie
        # body：Body
        # bodyParamName：Body参数名
        # bodyParamValue：Body参数值'}
        self.type = type
        # {'en':'Match type,Currently only EQUAL,IP can only be EQUAL.
        # EQUAL: Equal
        # CONTAIN: Contains
        # REGEX: Regular match', 'zh_CN':'匹配类型，当前只有EQUAL，IP只能是EQUAL。
        # EQUAL：等于
        # CONTAIN：包含
        # REGEX：正则匹配'}
        self.match_type = match_type
        # {'en':'Rule exceptions,CONTAIN and REGEX are not case sensitive.', 'zh_CN':'规则例外内容，包含和正则匹配大小写不敏感。'}
        self.content = content
        # {'en':'Status.
        # TODO: Pending
        # REJECTED: Rejected', 'zh_CN':'状态。
        # TODO：待处理
        # REJECTED：已拒绝'}
        self.status = status
        # {'en':'Update time, format: yyyy-MM-dd HH:mm:ss.', 'zh_CN':'更新时间，格式：yyyy-MM-dd HH:mm:ss。'}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.content, 'content')
        self.validate_required(self.status, 'status')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.type is not None:
            result['type'] = self.type
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.content is not None:
            result['content'] = self.content
        if self.status is not None:
            result['status'] = self.status
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class ListRecommendationsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListRecommendationsWafDomainAiRuleResultVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListRecommendationsWafDomainAiRuleResultVO()
                self.data.append(temp_model.from_map(k))
        return self


class ListRecommendationsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListRecommendationsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListRecommendationsRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListRecommendationsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class AssociateDomainsForRuleExceptionRequest(TeaModel):
    def __init__(
        self,
        template_id_list: List[int] = None,
        domain_list: List[str] = None,
    ):
        # {"en":"Exception ID, array.", "zh_CN":"例外ID，数组。"}
        self.template_id_list = template_id_list
        # {"en":"The domains which the rule exception is to be associated, array.", "zh_CN":"要关联规则例外的域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.template_id_list, 'template_id_list')
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id_list is not None:
            result['templateIdList'] = self.template_id_list
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('templateIdList') is not None:
            self.template_id_list = m.get('templateIdList')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class AssociateDomainsForRuleExceptionResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class AssociateDomainsForRuleExceptionPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AssociateDomainsForRuleExceptionParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AssociateDomainsForRuleExceptionRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AssociateDomainsForRuleExceptionResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetBotFunctionSwitchRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {'en':'Hostname list.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class GetBotFunctionSwitchBotManageConfigVO(TeaModel):
    def __init__(
        self,
        domain: str = None,
        scene_analyse_switch: str = None,
        behavior_analyse_switch: str = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Client-based Detection function switch.
        # ON:Enabled
        # OFF:Disabled', 'zh_CN':'客户端风险检测功能开关。
        # ON：开启
        # OFF：关闭'}
        self.scene_analyse_switch = scene_analyse_switch
        # {'en':'Workflow Detection function switch.
        # ON:Enabled
        # OFF:Disabled', 'zh_CN':'业务流检测功能开关。
        # ON：开启
        # OFF：关闭'}
        self.behavior_analyse_switch = behavior_analyse_switch

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.scene_analyse_switch, 'scene_analyse_switch')
        self.validate_required(self.behavior_analyse_switch, 'behavior_analyse_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.scene_analyse_switch is not None:
            result['sceneAnalyseSwitch'] = self.scene_analyse_switch
        if self.behavior_analyse_switch is not None:
            result['behaviorAnalyseSwitch'] = self.behavior_analyse_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('sceneAnalyseSwitch') is not None:
            self.scene_analyse_switch = m.get('sceneAnalyseSwitch')
        if m.get('behaviorAnalyseSwitch') is not None:
            self.behavior_analyse_switch = m.get('behaviorAnalyseSwitch')
        return self


class GetBotFunctionSwitchResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[GetBotFunctionSwitchBotManageConfigVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = GetBotFunctionSwitchBotManageConfigVO()
                self.data.append(temp_model.from_map(k))
        return self


class GetBotFunctionSwitchPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBotFunctionSwitchParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBotFunctionSwitchRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class GetBotFunctionSwitchResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UsingExistingHostnameToAddNewHostnameRequest(TeaModel):
    def __init__(
        self,
        source_domain: str = None,
        target_domains: List[str] = None,
    ):
        # {"en":"The reference hostname.", "zh_CN":"指定域名。"}
        self.source_domain = source_domain
        # {"en":"Hostname to be accessed.", "zh_CN":"目标域名。"}
        self.target_domains = target_domains

    def validate(self):
        self.validate_required(self.source_domain, 'source_domain')
        self.validate_required(self.target_domains, 'target_domains')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_domain is not None:
            result['sourceDomain'] = self.source_domain
        if self.target_domains is not None:
            result['targetDomains'] = self.target_domains
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sourceDomain') is not None:
            self.source_domain = m.get('sourceDomain')
        if m.get('targetDomains') is not None:
            self.target_domains = m.get('targetDomains')
        return self


class UsingExistingHostnameToAddNewHostnameResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UsingExistingHostnameToAddNewHostnamePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UsingExistingHostnameToAddNewHostnameParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UsingExistingHostnameToAddNewHostnameRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UsingExistingHostnameToAddNewHostnameResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetApiAssetListRequest(TeaModel):
    def __init__(
        self,
        domains: List[str] = None,
        path: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # {"en":"List of domain.", "zh_CN":"域名列表。"}
        self.domains = domains
        # {"en":"Endpoint path.", "zh_CN":"前端路径。"}
        self.path = path
        # {"en":"The current page number.", "zh_CN":"当前页。"}
        self.page_num = page_num
        # {"en":"The number of records per page.", "zh_CN":"页大小。"}
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['domains'] = self.domains
        if self.path is not None:
            result['path'] = self.path
        if self.page_num is not None:
            result['pageNum'] = self.page_num
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('pageNum') is not None:
            self.page_num = m.get('pageNum')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class GetApiAssetListDiscoveryApi(TeaModel):
    def __init__(
        self,
        id: str = None,
        domain: str = None,
        path: str = None,
        sensitive_labels: List[str] = None,
        create_time: str = None,
        update_time: str = None,
    ):
        # {"en":"Asset discovery ID.", "zh_CN":"资产发现ID。"}
        self.id = id
        # {"en":"Domain.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"Endpoint path.", "zh_CN":"前端路径。"}
        self.path = path
        # {"en":"Sensitive data labels.", "zh_CN":"敏感标签。"}
        self.sensitive_labels = sensitive_labels
        # {"en":"First discovery time, format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"首次发现时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.create_time = create_time
        # {"en":"Last discovery time, format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"最新出现时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.path, 'path')
        self.validate_required(self.sensitive_labels, 'sensitive_labels')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.path is not None:
            result['path'] = self.path
        if self.sensitive_labels is not None:
            result['sensitiveLabels'] = self.sensitive_labels
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('sensitiveLabels') is not None:
            self.sensitive_labels = m.get('sensitiveLabels')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetApiAssetListPage(TeaModel):
    def __init__(
        self,
        current: int = None,
        pages: int = None,
        size: int = None,
        total: int = None,
        records: List[GetApiAssetListDiscoveryApi] = None,
    ):
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"The total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The number of records per page.", "zh_CN":"每页记录条数。"}
        self.size = size
        # {"en":"The total number of records.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"List of API asset discoverys.", "zh_CN":"记录。"}
        self.records = records

    def validate(self):
        self.validate_required(self.current, 'current')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.size, 'size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current is not None:
            result['current'] = self.current
        if self.pages is not None:
            result['pages'] = self.pages
        if self.size is not None:
            result['size'] = self.size
        if self.total is not None:
            result['total'] = self.total
        if self.records is not None:
            result['records'] = []
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('records') is not None:
            self.records = []
            for k in m.get('records'):
                temp_model = GetApiAssetListDiscoveryApi()
                self.records.append(temp_model.from_map(k))
        return self


class GetApiAssetListResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: GetApiAssetListPage = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            temp_model = GetApiAssetListPage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetApiAssetListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetApiAssetListParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetApiAssetListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetApiAssetListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListHistoricalHostnamesRequest(TeaModel):
    def __init__(
        self,
        start_time: str = None,
        end_time: str = None,
        timezone: str = None,
    ):
        # {"zh_CN":"开始时间，格式：yyyy-MM-dd HH:mm:ss。","en":"Starting time, format: yyyy-MM-dd HH:mm:ss."}
        self.start_time = start_time
        # {"zh_CN":"结束时间，格式：yyyy-MM-dd HH:mm:ss。","en":"End Time, format: yyyy-MM-dd HH:mm:ss."}
        self.end_time = end_time
        # {'en':'Timezone,default value: GTM+8.', 'zh_CN':'时区，默认：GTM+8。','dictionary':'belong=WAAP-MS-Ext|dict=waap_timezone'}
        self.timezone = timezone

    def validate(self):
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.timezone is not None:
            result['timezone'] = self.timezone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('timezone') is not None:
            self.timezone = m.get('timezone')
        return self


class ListHistoricalHostnamesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[str] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ListHistoricalHostnamesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListHistoricalHostnamesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListHistoricalHostnamesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListHistoricalHostnamesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteWhitelistRulesRequest(TeaModel):
    def __init__(
        self,
        id_list: List[str] = None,
    ):
        # {"en":"Rule ID List.", "zh_CN":"规则ID列表。"}
        self.id_list = id_list

    def validate(self):
        self.validate_required(self.id_list, 'id_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_list is not None:
            result['idList'] = self.id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('idList') is not None:
            self.id_list = m.get('idList')
        return self


class DeleteWhitelistRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class DeleteWhitelistRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteWhitelistRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteWhitelistRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class DeleteWhitelistRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteCustomRuleRequest(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
    ):
        # {"en":"Rule ID.", "zh_CN":"规则ID。"}
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        return self


class DeleteCustomRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class DeleteCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteCustomRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class CreateQuotaRuleRequest(TeaModel):
    def __init__(
        self,
        control_action: str = None,
        limit_duration: int = None,
        limit_unit: str = None,
        policy_name: str = None,
        remark: str = None,
        threshold_value: int = None,
    ):
        # {"en":"Control action, default value: INTERCEPT.
        # INTERCEPT: Block
        # MONITOR: Log", "zh_CN":"控制动作，默认值：INTERCEPT。
        # INTERCEPT：拦截
        # MONITOR：监控"}
        self.control_action = control_action
        # {"en":"Time period.", "zh_CN":"限制时长。"}
        self.limit_duration = limit_duration
        # {"en":"Detailing unit. 
        # h: Hour
        # d: Day
        # w: Week
        # m: Month", "zh_CN":"时长单位。
        # h：小时
        # d：天
        # w：周
        # m：月"}
        self.limit_unit = limit_unit
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.policy_name = policy_name
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark
        # {"en":"Consumer quota threshold.", "zh_CN":"消费方配额阈值。"}
        self.threshold_value = threshold_value

    def validate(self):
        self.validate_required(self.limit_duration, 'limit_duration')
        self.validate_required(self.policy_name, 'policy_name')
        self.validate_required(self.threshold_value, 'threshold_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.control_action is not None:
            result['controlAction'] = self.control_action
        if self.limit_duration is not None:
            result['limitDuration'] = self.limit_duration
        if self.limit_unit is not None:
            result['limitUnit'] = self.limit_unit
        if self.policy_name is not None:
            result['policyName'] = self.policy_name
        if self.remark is not None:
            result['remark'] = self.remark
        if self.threshold_value is not None:
            result['thresholdValue'] = self.threshold_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('controlAction') is not None:
            self.control_action = m.get('controlAction')
        if m.get('limitDuration') is not None:
            self.limit_duration = m.get('limitDuration')
        if m.get('limitUnit') is not None:
            self.limit_unit = m.get('limitUnit')
        if m.get('policyName') is not None:
            self.policy_name = m.get('policyName')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('thresholdValue') is not None:
            self.threshold_value = m.get('thresholdValue')
        return self


class CreateQuotaRuleResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: dict = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreateQuotaRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateQuotaRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateQuotaRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateQuotaRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListWhitelistRulesRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
        rule_name: str = None,
    ):
        # {"en":"Hostname list.", "zh_CN":"域名列表。"}
        self.domain_list = domain_list
        # {"en":"Rule name, fuzzy query.", "zh_CN":"规则名称，模糊查询。"}
        self.rule_name = rule_name

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        return self


class ListWhitelistRulesIpOrIpsCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ip_or_ips: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal", "zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"IP/CIDR.", "zh_CN":"IP/IP段。"}
        self.ip_or_ips = ip_or_ips

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ip_or_ips, 'ip_or_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ip_or_ips is not None:
            result['ipOrIps'] = self.ip_or_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ipOrIps') is not None:
            self.ip_or_ips = m.get('ipOrIps')
        return self


class ListWhitelistRulesPathCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        paths: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal
        # CONTAIN: Contains
        # NOT_CONTAIN: Does not Contains
        # REGEX: Regex match
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match", "zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：匹配正则
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配"}
        self.match_type = match_type
        # {"en":"Path.", "zh_CN":"路径。"}
        self.paths = paths

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.paths, 'paths')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.paths is not None:
            result['paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paths') is not None:
            self.paths = m.get('paths')
        return self


class ListWhitelistRulesUriCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        uri: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal
        # CONTAIN: Contains
        # NOT_CONTAIN: Does not Contains
        # REGEX: Regex match
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match", "zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：匹配正则
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配"}
        self.match_type = match_type
        # {"en":"URI.", "zh_CN":"URI。"}
        self.uri = uri

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.uri, 'uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class ListWhitelistRulesUaCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ua: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal
        # CONTAIN: Contains
        # NOT_CONTAIN: Does not Contains
        # REGEX: Regex match
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match", "zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：匹配正则
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配"}
        self.match_type = match_type
        # {"en":"User agent.", "zh_CN":"User-Agent。"}
        self.ua = ua

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ua, 'ua')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ua is not None:
            result['ua'] = self.ua
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ua') is not None:
            self.ua = m.get('ua')
        return self


class ListWhitelistRulesRefererCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        referer: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal
        # CONTAIN: Contains
        # NOT_CONTAIN: Does not Contains
        # REGEX: Regex match
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match", "zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：匹配正则
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配"}
        self.match_type = match_type
        # {"en":"Referer.", "zh_CN":"Referer。"}
        self.referer = referer

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.referer, 'referer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.referer is not None:
            result['referer'] = self.referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('referer') is not None:
            self.referer = m.get('referer')
        return self


class ListWhitelistRulesHeaderCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        key: str = None,
        value_list: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal
        # CONTAIN: Contains
        # NOT_CONTAIN: Does not Contains
        # REGEX: Regex match
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match", "zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：匹配正则
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配"}
        self.match_type = match_type
        # {"en":"Request header key.", "zh_CN":"头部名称。"}
        self.key = key
        # {"en":"List of request header values.", "zh_CN":"头部值列表。"}
        self.value_list = value_list

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.key, 'key')
        self.validate_required(self.value_list, 'value_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.key is not None:
            result['key'] = self.key
        if self.value_list is not None:
            result['valueList'] = self.value_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('valueList') is not None:
            self.value_list = m.get('valueList')
        return self


class ListWhitelistRulesWhitelistRuleCondition(TeaModel):
    def __init__(
        self,
        ip_or_ips_conditions: List[ListWhitelistRulesIpOrIpsCondition] = None,
        path_conditions: List[ListWhitelistRulesPathCondition] = None,
        uri_conditions: List[ListWhitelistRulesUriCondition] = None,
        ua_conditions: List[ListWhitelistRulesUaCondition] = None,
        referer_conditions: List[ListWhitelistRulesRefererCondition] = None,
        header_conditions: List[ListWhitelistRulesHeaderCondition] = None,
    ):
        # {"en":"IP/CIDR match conditions.", "zh_CN":"IP/IP段匹配条件。"}
        self.ip_or_ips_conditions = ip_or_ips_conditions
        # {"en":"Path match conditions.", "zh_CN":"路径匹配条件。"}
        self.path_conditions = path_conditions
        # {"en":"URI match conditions.", "zh_CN":"URI匹配条件。"}
        self.uri_conditions = uri_conditions
        # {"en":"User agent match conditions.", "zh_CN":"User-Agent 匹配条件。"}
        self.ua_conditions = ua_conditions
        # {"en":"Referer match conditions.", "zh_CN":"Referer 匹配条件。"}
        self.referer_conditions = referer_conditions
        # {"en":"Request header match conditions.", "zh_CN":"请求头匹配条件。"}
        self.header_conditions = header_conditions

    def validate(self):
        self.validate_required(self.ip_or_ips_conditions, 'ip_or_ips_conditions')
        if self.ip_or_ips_conditions:
            for k in self.ip_or_ips_conditions:
                if k:
                    k.validate()
        self.validate_required(self.path_conditions, 'path_conditions')
        if self.path_conditions:
            for k in self.path_conditions:
                if k:
                    k.validate()
        self.validate_required(self.uri_conditions, 'uri_conditions')
        if self.uri_conditions:
            for k in self.uri_conditions:
                if k:
                    k.validate()
        self.validate_required(self.ua_conditions, 'ua_conditions')
        if self.ua_conditions:
            for k in self.ua_conditions:
                if k:
                    k.validate()
        self.validate_required(self.referer_conditions, 'referer_conditions')
        if self.referer_conditions:
            for k in self.referer_conditions:
                if k:
                    k.validate()
        self.validate_required(self.header_conditions, 'header_conditions')
        if self.header_conditions:
            for k in self.header_conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_or_ips_conditions is not None:
            result['ipOrIpsConditions'] = []
            for k in self.ip_or_ips_conditions:
                result['ipOrIpsConditions'].append(k.to_map() if k else None)
        if self.path_conditions is not None:
            result['pathConditions'] = []
            for k in self.path_conditions:
                result['pathConditions'].append(k.to_map() if k else None)
        if self.uri_conditions is not None:
            result['uriConditions'] = []
            for k in self.uri_conditions:
                result['uriConditions'].append(k.to_map() if k else None)
        if self.ua_conditions is not None:
            result['uaConditions'] = []
            for k in self.ua_conditions:
                result['uaConditions'].append(k.to_map() if k else None)
        if self.referer_conditions is not None:
            result['refererConditions'] = []
            for k in self.referer_conditions:
                result['refererConditions'].append(k.to_map() if k else None)
        if self.header_conditions is not None:
            result['headerConditions'] = []
            for k in self.header_conditions:
                result['headerConditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipOrIpsConditions') is not None:
            self.ip_or_ips_conditions = []
            for k in m.get('ipOrIpsConditions'):
                temp_model = ListWhitelistRulesIpOrIpsCondition()
                self.ip_or_ips_conditions.append(temp_model.from_map(k))
        if m.get('pathConditions') is not None:
            self.path_conditions = []
            for k in m.get('pathConditions'):
                temp_model = ListWhitelistRulesPathCondition()
                self.path_conditions.append(temp_model.from_map(k))
        if m.get('uriConditions') is not None:
            self.uri_conditions = []
            for k in m.get('uriConditions'):
                temp_model = ListWhitelistRulesUriCondition()
                self.uri_conditions.append(temp_model.from_map(k))
        if m.get('uaConditions') is not None:
            self.ua_conditions = []
            for k in m.get('uaConditions'):
                temp_model = ListWhitelistRulesUaCondition()
                self.ua_conditions.append(temp_model.from_map(k))
        if m.get('refererConditions') is not None:
            self.referer_conditions = []
            for k in m.get('refererConditions'):
                temp_model = ListWhitelistRulesRefererCondition()
                self.referer_conditions.append(temp_model.from_map(k))
        if m.get('headerConditions') is not None:
            self.header_conditions = []
            for k in m.get('headerConditions'):
                temp_model = ListWhitelistRulesHeaderCondition()
                self.header_conditions.append(temp_model.from_map(k))
        return self


class ListWhitelistRulesCommonWhitelistVO(TeaModel):
    def __init__(
        self,
        id: str = None,
        domain: str = None,
        rule_name: str = None,
        description: str = None,
        conditions: ListWhitelistRulesWhitelistRuleCondition = None,
        create_time: str = None,
        update_time: str = None,
    ):
        # {"en":"Rule ID.", "zh_CN":"规则ID。"}
        self.id = id
        # {"en":"Hostname.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.rule_name = rule_name
        # {"en":"Description.", "zh_CN":"描述。"}
        self.description = description
        # {"en":"Match conditions, at least one, at most five.", "zh_CN":"匹配条件，至少一个，至多五个。"}
        self.conditions = conditions
        # {"en":"Created date, format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"创建时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.create_time = create_time
        # {"en":"Update date, format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"更新时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.conditions, 'conditions')
        if self.conditions:
            self.conditions.validate()
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.description is not None:
            result['description'] = self.description
        if self.conditions is not None:
            result['conditions'] = self.conditions.to_map()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('conditions') is not None:
            temp_model = ListWhitelistRulesWhitelistRuleCondition()
            self.conditions = temp_model.from_map(m['conditions'])
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class ListWhitelistRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListWhitelistRulesCommonWhitelistVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"出参数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListWhitelistRulesCommonWhitelistVO()
                self.data.append(temp_model.from_map(k))
        return self


class ListWhitelistRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListWhitelistRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListWhitelistRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListWhitelistRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteCustomRuleRequest(TeaModel):
    def __init__(
        self,
        id_list: List[str] = None,
    ):
        # {'en':'Rule ID List.', 'zh_CN':'规则ID列表。'}
        self.id_list = id_list

    def validate(self):
        self.validate_required(self.id_list, 'id_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_list is not None:
            result['idList'] = self.id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('idList') is not None:
            self.id_list = m.get('idList')
        return self


class DeleteCustomRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class DeleteCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteCustomRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class DeleteCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditConsumerRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        consumer_name: str = None,
        consumer_group: str = None,
        remark: str = None,
    ):
        # {"en":"Consumer ID.", "zh_CN":"消费方ID。"}
        self.id = id
        # {"en":"Consumer name.", "zh_CN":"消费方名称。"}
        self.consumer_name = consumer_name
        # {"en":"Consumer group.", "zh_CN":"消费方分组。"}
        self.consumer_group = consumer_group
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.consumer_name, 'consumer_name')
        self.validate_required(self.consumer_group, 'consumer_group')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.consumer_name is not None:
            result['consumerName'] = self.consumer_name
        if self.consumer_group is not None:
            result['consumerGroup'] = self.consumer_group
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('consumerName') is not None:
            self.consumer_name = m.get('consumerName')
        if m.get('consumerGroup') is not None:
            self.consumer_group = m.get('consumerGroup')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class EditConsumerResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: dict = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class EditConsumerPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditConsumerParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditConsumerRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditConsumerResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetDomainAPISecurityConfigurationRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {"en":"Hostname list.", "zh_CN":"域名列表。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class GetDomainAPISecurityConfigurationApiDefendConfDetailVO(TeaModel):
    def __init__(
        self,
        domain: str = None,
        api_id: str = None,
        name: str = None,
        group_name: str = None,
        path: str = None,
        action: str = None,
    ):
        # {"en":"Hostname.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"API ID.", "zh_CN":"API ID。"}
        self.api_id = api_id
        # {"en":"API name.", "zh_CN":"API名称。"}
        self.name = name
        # {"en":"API group.", "zh_CN":"API分组。"}
        self.group_name = group_name
        # {"en":"Endpoint path.", "zh_CN":"端点路径。"}
        self.path = path
        # {"en":"Action.
        # NO_USE: Not Used
        # LOG: Log
        # BLOCK: Deny", "zh_CN":"处理动作。
        # NO_USE：不使用
        # LOG：监控
        # BLOCK：拦截"}
        self.action = action

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.path, 'path')
        self.validate_required(self.action, 'action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.api_id is not None:
            result['apiId'] = self.api_id
        if self.name is not None:
            result['name'] = self.name
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.path is not None:
            result['path'] = self.path
        if self.action is not None:
            result['action'] = self.action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('apiId') is not None:
            self.api_id = m.get('apiId')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('action') is not None:
            self.action = m.get('action')
        return self


class GetDomainAPISecurityConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[GetDomainAPISecurityConfigurationApiDefendConfDetailVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"出参数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = GetDomainAPISecurityConfigurationApiDefendConfDetailVO()
                self.data.append(temp_model.from_map(k))
        return self


class GetDomainAPISecurityConfigurationPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetDomainAPISecurityConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetDomainAPISecurityConfigurationRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class GetDomainAPISecurityConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class AssociateDomainsForCustomRuleRequest(TeaModel):
    def __init__(
        self,
        rule_id_list: List[int] = None,
        domain_list: List[str] = None,
    ):
        # {"en":"Rule ID,array", "zh_CN":"规则ID，数组"}
        self.rule_id_list = rule_id_list
        # {"en":"The domains which the custom rule is to be associated, array.", "zh_CN":"要关联自定义规则的域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.rule_id_list, 'rule_id_list')
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id_list is not None:
            result['ruleIdList'] = self.rule_id_list
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleIdList') is not None:
            self.rule_id_list = m.get('ruleIdList')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class AssociateDomainsForCustomRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class AssociateDomainsForCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AssociateDomainsForCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AssociateDomainsForCustomRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AssociateDomainsForCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeployCrawlerGoodPgRows(TeaModel):
    def __init__(
        self,
        name: str = None,
        enable: int = None,
    ):
        # {"en":"BOT name.", "zh_CN":"Bot标识。"}
        self.name = name
        # {"en":"Action.
        #  0:Off 
        #  1:Block 
        #  2:Log 
        #  3:Bypass", "zh_CN":"处理动作。
        #  0：关闭
        #  1：拦截
        #  2：告警
        #  3：放行"}
        self.enable = enable

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.enable, 'enable')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.enable is not None:
            result['enable'] = self.enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        return self


class DeployCrawlerGoodIntelligence(TeaModel):
    def __init__(
        self,
        pg_rows: List[DeployCrawlerGoodPgRows] = None,
    ):
        # {"en":"Single BOT record.", "zh_CN":"单条Bot记录。"}
        self.pg_rows = pg_rows

    def validate(self):
        self.validate_required(self.pg_rows, 'pg_rows')
        if self.pg_rows:
            for k in self.pg_rows:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pg_rows is not None:
            result['pg_rows'] = []
            for k in self.pg_rows:
                result['pg_rows'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pg_rows') is not None:
            self.pg_rows = []
            for k in m.get('pg_rows'):
                temp_model = DeployCrawlerGoodPgRows()
                self.pg_rows.append(temp_model.from_map(k))
        return self


class DeployCrawlerGoodPgRowsAgent(TeaModel):
    def __init__(
        self,
        name: str = None,
        enable: int = None,
        check: List[str] = None,
    ):
        # {"en":"BOT name.", "zh_CN":"Bot标识。"}
        self.name = name
        # {"en":"Action.
        #  0:Off 
        #  1:Block 
        #  2:Log 
        #  3:Bypass", "zh_CN":"处理动作。
        #  0：关闭 
        #  1：拦截 
        #  2：告警 
        #  3：放行"}
        self.enable = enable
        # {"en":"HTTP library. 
        #  Python;Python-requests;Python-urllib;PHP;Ruby;GO HttpClient;Guzzle Http Client;Libcurl;Apache ;HttpClient;Jakarta Commons HttpClient;Axios;Other", 
        #     "zh_CN":"HTTP库。
        #  Python;Python-requests;Python-urllib;PHP;Ruby;GO HttpClient;Guzzle Http Client;Libcurl;Apache ;HttpClient;Jakarta Commons HttpClient;Axios;Other"}
        self.check = check

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.enable, 'enable')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.enable is not None:
            result['enable'] = self.enable
        if self.check is not None:
            result['check'] = self.check
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('check') is not None:
            self.check = m.get('check')
        return self


class DeployCrawlerGoodUserAgent(TeaModel):
    def __init__(
        self,
        pg_rows: List[DeployCrawlerGoodPgRowsAgent] = None,
    ):
        # {"en":"Record of single Bots.", "zh_CN":"单条Bot记录。"}
        self.pg_rows = pg_rows

    def validate(self):
        self.validate_required(self.pg_rows, 'pg_rows')
        if self.pg_rows:
            for k in self.pg_rows:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pg_rows is not None:
            result['pg_rows'] = []
            for k in self.pg_rows:
                result['pg_rows'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pg_rows') is not None:
            self.pg_rows = []
            for k in m.get('pg_rows'):
                temp_model = DeployCrawlerGoodPgRowsAgent()
                self.pg_rows.append(temp_model.from_map(k))
        return self


class DeployCrawlerGoodRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        edgebot_crawler_good: DeployCrawlerGoodIntelligence = None,
        edgebot_user_agent: DeployCrawlerGoodUserAgent = None,
        edgebot_bot_intelligence: DeployCrawlerGoodIntelligence = None,
    ):
        # {"en":"domain", "zh_CN":"域名"}
        self.domain = domain
        # {"en":"Public Bots.", "zh_CN":"公开类型Bot。"}
        self.edgebot_crawler_good = edgebot_crawler_good
        # {"en":"User-Agent DeployCrawlerGoodIntelligence.", "zh_CN":"User-Agent情报。"}
        self.edgebot_user_agent = edgebot_user_agent
        # {"en":"IP DeployCrawlerGoodIntelligence.", "zh_CN":"IP情报。"}
        self.edgebot_bot_intelligence = edgebot_bot_intelligence

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.edgebot_crawler_good, 'edgebot_crawler_good')
        if self.edgebot_crawler_good:
            self.edgebot_crawler_good.validate()
        self.validate_required(self.edgebot_user_agent, 'edgebot_user_agent')
        if self.edgebot_user_agent:
            self.edgebot_user_agent.validate()
        self.validate_required(self.edgebot_bot_intelligence, 'edgebot_bot_intelligence')
        if self.edgebot_bot_intelligence:
            self.edgebot_bot_intelligence.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.edgebot_crawler_good is not None:
            result['edgebot_crawler_good'] = self.edgebot_crawler_good.to_map()
        if self.edgebot_user_agent is not None:
            result['edgebot_user_agent'] = self.edgebot_user_agent.to_map()
        if self.edgebot_bot_intelligence is not None:
            result['edgebot_bot_intelligence'] = self.edgebot_bot_intelligence.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('edgebot_crawler_good') is not None:
            temp_model = DeployCrawlerGoodIntelligence()
            self.edgebot_crawler_good = temp_model.from_map(m['edgebot_crawler_good'])
        if m.get('edgebot_user_agent') is not None:
            temp_model = DeployCrawlerGoodUserAgent()
            self.edgebot_user_agent = temp_model.from_map(m['edgebot_user_agent'])
        if m.get('edgebot_bot_intelligence') is not None:
            temp_model = DeployCrawlerGoodIntelligence()
            self.edgebot_bot_intelligence = temp_model.from_map(m['edgebot_bot_intelligence'])
        return self


class DeployCrawlerGoodResult(TeaModel):
    def __init__(
        self,
        deploy_version: str = None,
        estimatetime: str = None,
    ):
        # {"en":"Deployment Version", "zh_CN":"部署版本号"}
        self.deploy_version = deploy_version
        # {"en":"Estimated time", "zh_CN":"预估时间"}
        self.estimatetime = estimatetime

    def validate(self):
        self.validate_required(self.deploy_version, 'deploy_version')
        self.validate_required(self.estimatetime, 'estimatetime')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deploy_version is not None:
            result['deployVersion'] = self.deploy_version
        if self.estimatetime is not None:
            result['estimatetime'] = self.estimatetime
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deployVersion') is not None:
            self.deploy_version = m.get('deployVersion')
        if m.get('estimatetime') is not None:
            self.estimatetime = m.get('estimatetime')
        return self


class DeployCrawlerGoodResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: DeployCrawlerGoodResult = None,
    ):
        # {"en":"Status code, success is '200'.", "zh_CN":"状态码，成功为“200”。"}
        self.code = code
        # {"en":"Return message, success is 'Success'.", "zh_CN":"返回信息，成功为“Success”。"}
        self.message = message
        # {"en":"Data returned.", "zh_CN":"返回数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = DeployCrawlerGoodResult()
            self.data = temp_model.from_map(m['data'])
        return self


class DeployCrawlerGoodPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeployCrawlerGoodParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeployCrawlerGoodRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeployCrawlerGoodResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryDomainListByRuleNameRequest(TeaModel):
    def __init__(
        self,
        service_type: str = None,
        rule_name_list: List[str] = None,
    ):
        # {"en":"Service name. 
        #  WAF:Web Application Firewall 
        #  BOT:Bot Shield 
        #  API:API Shield 
        #  DDoS:DDoS Protection ", "zh_CN":"服务名称。
        #  WAF：WEB应用防火墙 
        #  BOT：BotGuard爬虫管理 
        #  API：API安全与管理 
        #  DDoS: DMS"}
        self.service_type = service_type
        # {"en":"Rule name array.", "zh_CN":"规则名数组。"}
        self.rule_name_list = rule_name_list

    def validate(self):
        self.validate_required(self.service_type, 'service_type')
        self.validate_required(self.rule_name_list, 'rule_name_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        if self.rule_name_list is not None:
            result['ruleNameList'] = self.rule_name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        if m.get('ruleNameList') is not None:
            self.rule_name_list = m.get('ruleNameList')
        return self


class QueryDomainListByRuleNameRespItem(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
        rule_id: str = None,
        rule_name: str = None,
    ):
        # {"en":"Rule association domain.", "zh_CN":"规则关联域名。"}
        self.domain_list = domain_list
        # {"en":"Rule id.", "zh_CN":"规则ID。"}
        self.rule_id = rule_id
        # {"en":"Rule name.", "zh_CN":"规则名。"}
        self.rule_name = rule_name

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.rule_name, 'rule_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        return self


class QueryDomainListByRuleNameResp(TeaModel):
    def __init__(
        self,
        total_num: str = None,
        list: List[QueryDomainListByRuleNameRespItem] = None,
    ):
        # {"en":"Number of records.", "zh_CN":"记录数。"}
        self.total_num = total_num
        # {"en":"Rule array.", "zh_CN":"规则数组。"}
        self.list = list

    def validate(self):
        self.validate_required(self.total_num, 'total_num')
        self.validate_required(self.list, 'list')
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_num is not None:
            result['totalNum'] = self.total_num
        if self.list is not None:
            result['list'] = []
            for k in self.list:
                result['list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('totalNum') is not None:
            self.total_num = m.get('totalNum')
        if m.get('list') is not None:
            self.list = []
            for k in m.get('list'):
                temp_model = QueryDomainListByRuleNameRespItem()
                self.list.append(temp_model.from_map(k))
        return self


class QueryDomainListByRuleNameResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryDomainListByRuleNameResp = None,
    ):
        # {"en":"Status code, success is '200'.", "zh_CN":"状态码，成功为“200”。"}
        self.code = code
        # {"en":"Return message, success is 'Success'.", "zh_CN":"返回信息，成功为“Success”。"}
        self.message = message
        # {"en":"Data returned", "zh_CN":"返回数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryDomainListByRuleNameResp()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryDomainListByRuleNamePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainListByRuleNameParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainListByRuleNameRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainListByRuleNameResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetThreatIntelligenceDomainConfigRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {"en":"Hostname list.", "zh_CN":"域名列表。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class GetThreatIntelligenceDomainConfigIntelligenceDomainConfigVO(TeaModel):
    def __init__(
        self,
        id: str = None,
        domain: str = None,
        info_cate: str = None,
        second_cate: str = None,
        action: str = None,
    ):
        # {"en":"Category ID.", "zh_CN":"分类ID。"}
        self.id = id
        # {"en":"Hostname.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"Category.", "zh_CN":"大类。"}
        self.info_cate = info_cate
        # {"en":"SubCategory.", "zh_CN":"小类。"}
        self.second_cate = second_cate
        # {"en":"Action.
        # NO_USE: Not Used
        # LOG: Log
        # BLOCK: Deny", "zh_CN":"处理动作。
        # NO_USE：不使用
        # LOG：监控
        # BLOCK：拦截"}
        self.action = action

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.info_cate, 'info_cate')
        self.validate_required(self.second_cate, 'second_cate')
        self.validate_required(self.action, 'action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.info_cate is not None:
            result['infoCate'] = self.info_cate
        if self.second_cate is not None:
            result['secondCate'] = self.second_cate
        if self.action is not None:
            result['action'] = self.action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('infoCate') is not None:
            self.info_cate = m.get('infoCate')
        if m.get('secondCate') is not None:
            self.second_cate = m.get('secondCate')
        if m.get('action') is not None:
            self.action = m.get('action')
        return self


class GetThreatIntelligenceDomainConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[GetThreatIntelligenceDomainConfigIntelligenceDomainConfigVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"出参数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = GetThreatIntelligenceDomainConfigIntelligenceDomainConfigVO()
                self.data.append(temp_model.from_map(k))
        return self


class GetThreatIntelligenceDomainConfigPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetThreatIntelligenceDomainConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetThreatIntelligenceDomainConfigRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class GetThreatIntelligenceDomainConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class RemoveProtectedHostnameRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class RemoveProtectedHostnameResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class RemoveProtectedHostnamePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class RemoveProtectedHostnameParameters(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Hostname.", "zh_CN":"域名。"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class RemoveProtectedHostnameRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class RemoveProtectedHostnameResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateBlockPageSettingBlockPage(TeaModel):
    def __init__(
        self,
        switch_conf: int = None,
        status_code: str = None,
        content_type: str = None,
        response_content: str = None,
    ):
        # {"en":"Switch
        #     0: close
        #     1: open", "zh_CN":"开关。
        #     0：关
        #     1：开"}
        self.switch_conf = switch_conf
        # {"en":"Status code, default 403", "zh_CN":"状态码，默认403"}
        self.status_code = status_code
        # {"en":"Content-type, default text/html, support multiple,english half Angle comma splices.", "zh_CN":"Content-Type，默认text/html，多个以英文半角逗号分隔。"}
        self.content_type = content_type
        # {"en":"Customized response content.", "zh_CN":"自定义响应内容。"}
        self.response_content = response_content

    def validate(self):
        self.validate_required(self.switch_conf, 'switch_conf')
        self.validate_required(self.response_content, 'response_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.switch_conf is not None:
            result['switch'] = self.switch_conf
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.response_content is not None:
            result['responseContent'] = self.response_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('switch') is not None:
            self.switch_conf = m.get('switch')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('responseContent') is not None:
            self.response_content = m.get('responseContent')
        return self


class UpdateBlockPageSettingDomainInfo(TeaModel):
    def __init__(
        self,
        domain: str = None,
        block_page: UpdateBlockPageSettingBlockPage = None,
    ):
        # {"en":"domain name", "zh_CN":"域名"}
        self.domain = domain
        # {"en":"Configuration for Block page setting.", "zh_CN":"自定义拦截页面配置"}
        self.block_page = block_page

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.block_page, 'block_page')
        if self.block_page:
            self.block_page.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.block_page is not None:
            result['blockPage'] = self.block_page.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('blockPage') is not None:
            temp_model = UpdateBlockPageSettingBlockPage()
            self.block_page = temp_model.from_map(m['blockPage'])
        return self


class UpdateBlockPageSettingRequest(TeaModel):
    def __init__(
        self,
        config: List[UpdateBlockPageSettingDomainInfo] = None,
    ):
        # {"en":"Domain, array.", "zh_CN":"域名，数组。"}
        self.config = config

    def validate(self):
        self.validate_required(self.config, 'config')
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['config'] = []
            for k in self.config:
                result['config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('config') is not None:
            self.config = []
            for k in m.get('config'):
                temp_model = UpdateBlockPageSettingDomainInfo()
                self.config.append(temp_model.from_map(k))
        return self


class UpdateBlockPageSettingResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class UpdateBlockPageSettingPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateBlockPageSettingParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateBlockPageSettingRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateBlockPageSettingResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetRuleExceptionListRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        domain_list: List[str] = None,
        mode_list: List[int] = None,
        range_type: int = None,
        rule_ids: List[int] = None,
        attack_types: List[str] = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # {"en":"Exception name, support fuzzy queries.", "zh_CN":"例外名称，支持模糊查询。"}
        self.name = name
        # {"en":"Correlation domain name, array.", "zh_CN":"关联域名，数组。"}
        self.domain_list = domain_list
        # {"en":"Exception action,array, 
        #     0: Bypass
        #     2: Log", "zh_CN":"例外动作，数组。
        #     0：放行
        #     2：监控"}
        self.mode_list = mode_list
        # {"en":"Effective scope
        #     2: Specific rule ID
        #     3: Specific attack types", "zh_CN":"生效范围
        #     2：特定规则ID
        #     3：特定攻击类型"}
        self.range_type = range_type
        # {"en":"Effective rule ID.", "zh_CN":"生效的规则ID。"}
        self.rule_ids = rule_ids
        # {"en":"Effective attack types,
        #     RFC: Protocol compliance
        #     WAF_SQLI: SQL Injection
        #     WAF_XSS: X-Site Scripting
        #     WAF_RFI: File Inclusion
        #     WAF_DIR_TRAVERSAL: Directory Traversal
        #     WAF_SHELL_BACKDOOR: Webshell Uploading
        #     WAF_SERVER_ERROR_LEAKAGE: Server Sensitive Info Leakage
        #     WAF_FILE_UPLOAD: File Uploading
        #     WAF_CMDI: Command Injection
        #     WAF_XPATH_LDAP_SSI: XPATH/LADP/SSI Injection
        #     WAF_SCANNER: Malicious Scan
        #     WAF_FILE_DOWNLOAD: Unauthorized Download
        #     WAF_THIRDCOMP: 3rd Party Component Exploit
        #     WAF_XXE: XML Injection
        #     WAF_SSRF: Server-side Request Forge
        #     WAF_CUSTOM_RULE: Custom Rule", "zh_CN":"生效的攻击类型，
        #     RFC：协议合规
        #     WAF_SQLI：SQL注入
        #     WAF_XSS：XSS跨站
        #     WAF_RFI：文件包含
        #     WAF_DIR_TRAVERSAL：目录遍历
        #     WAF_SHELL_BACKDOOR：木马后门
        #     WAF_SERVER_ERROR_LEAKAGE：服务器信息泄漏
        #     WAF_FILE_UPLOAD：文件上传
        #     WAF_CMDI：命令注入
        #     WAF_XPATH_LDAP_SSI：XPATH/LADP/SSI注入
        #     WAF_SCANNER：扫描器
        #     WAF_FILE_DOWNLOAD：非法下载
        #     WAF_THIRDCOMP：第三方组件漏洞
        #     WAF_XXE：XML注入
        #     WAF_SSRF：服务端请求伪造
        #     WAF_CUSTOM_RULE：自定义规则"}
        self.attack_types = attack_types
        # {"en":"Current page number,1 by default.", "zh_CN":"当前页数，默认1。"}
        self.page_num = page_num
        # {"en":"Number each page,the maximum 1000,10 by default.", "zh_CN":"每页数量, 最大1000，默认10。"}
        self.page_size = page_size

    def validate(self):
        if self.page_size is not None:
            self.validate_maximum(self.page_size, 'page_size', 1000)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.mode_list is not None:
            result['modeList'] = self.mode_list
        if self.range_type is not None:
            result['rangeType'] = self.range_type
        if self.rule_ids is not None:
            result['ruleIds'] = self.rule_ids
        if self.attack_types is not None:
            result['attackTypes'] = self.attack_types
        if self.page_num is not None:
            result['pageNum'] = self.page_num
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('modeList') is not None:
            self.mode_list = m.get('modeList')
        if m.get('rangeType') is not None:
            self.range_type = m.get('rangeType')
        if m.get('ruleIds') is not None:
            self.rule_ids = m.get('ruleIds')
        if m.get('attackTypes') is not None:
            self.attack_types = m.get('attackTypes')
        if m.get('pageNum') is not None:
            self.page_num = m.get('pageNum')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class GetRuleExceptionListRuleWhiteCondition(TeaModel):
    def __init__(
        self,
        type: str = None,
        is_reg: int = None,
        content: str = None,
    ):
        # {"en":"Type
        #     path: Path
        #     uri: URI
        #     urlParamName: URL Parameter Name
        #     urlParamValue: URL Parameter Value
        #     clientIP: IP
        #     userAgent: User Agent
        #     httpHeaderName: HTTP Header Name
        #     httpHeaderValue: HTTP Header Value
        #     cookie: Cookie
        #     bodyParamName: Body Parameter Name
        #     bodyParamValue: Body Parameter Value
        #     body: Body", "zh_CN":"类型
        #     path：路径
        #     uri：URI
        #     urlParamName：URL Parameter Name
        #     urlParamValue：URL Parameter Value
        #     clientIP：IP
        #     userAgent：User Agent
        #     httpHeaderName：HTTP Header Name
        #     httpHeaderValue：HTTP Header Value
        #     cookie：Cookie
        #     bodyParamName：Body Parameter Name
        #     bodyParamValue：Body Parameter Value
        #     body：Body"}
        self.type = type
        # {"en":"Regular or not.
        #     0:yes
        #     1:no", "zh_CN":"是否正则。
        #     0：否
        #     1：是"}
        self.is_reg = is_reg
        # {"en":"The exception configuration. Except for Body, multiple values can be set at the same time.The clientIP type uses English half-corner commas to separate multiple values, and other types use newlines to separate multiple values.", "zh_CN":"例外内容，除了body类型以外，支持多个，clientIP类型用英文半角逗号分隔，其他类型用换行符分隔"}
        self.content = content

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.is_reg, 'is_reg')
        self.validate_required(self.content, 'content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.is_reg is not None:
            result['isReg'] = self.is_reg
        if self.content is not None:
            result['content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('isReg') is not None:
            self.is_reg = m.get('isReg')
        if m.get('content') is not None:
            self.content = m.get('content')
        return self


class GetRuleExceptionListRuleWhite(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
        mode: int = None,
        msg: str = None,
        range_type: int = None,
        rule_ids: List[int] = None,
        attack_types: List[str] = None,
        template_rule_white_conditions: List[GetRuleExceptionListRuleWhiteCondition] = None,
        domain_list: List[str] = None,
    ):
        # {"en":"Exception ID.", "zh_CN":"例外ID。"}
        self.id = id
        # {"en":"Exception name.", "zh_CN":"例外名称。"}
        self.name = name
        # {"en":"Exception action.
        #     0: Pass
        #     2: Alert", "zh_CN":"例外动作。
        #     0：放行
        #     2：监控"}
        self.mode = mode
        # {"en":"Description.", "zh_CN":"描述。"}
        self.msg = msg
        # {"en":"Effective scope.
        #     1: All rule
        #     2: Specific rule ids
        #     3: Specific attack types", "zh_CN":"生效范围。
        #     1：全部规则
        #     2：特定规则ID
        #     3：特定攻击类型"}
        self.range_type = range_type
        # {"en":"Effective rule ID.", "zh_CN":"生效的规则ID。"}
        self.rule_ids = rule_ids
        # {"en":"Effective attack types,
        #     RFC: Protocol compliance
        #     WAF_SQLI: SQL Injection
        #     WAF_XSS: X-Site Scripting
        #     WAF_RFI: File Inclusion
        #     WAF_DIR_TRAVERSAL: Directory Traversal
        #     WAF_SHELL_BACKDOOR: Webshell Uploading
        #     WAF_SERVER_ERROR_LEAKAGE: Server Sensitive Info Leakage
        #     WAF_FILE_UPLOAD: File Uploading
        #     WAF_CMDI: Command Injection
        #     WAF_XPATH_LDAP_SSI: XPATH/LADP/SSI Injection
        #     WAF_SCANNER: Malicious Scan
        #     WAF_FILE_DOWNLOAD: Unauthorized Download
        #     WAF_THIRDCOMP: 3rd Party Component Exploit
        #     WAF_XXE: XML Injection
        #     WAF_SSRF: Server-side Request Forge
        #     WAF_CUSTOM_RULE: Custom Rule", "zh_CN":"生效的攻击类型，
        #     RFC：协议合规
        #     WAF_SQLI：SQL注入
        #     WAF_XSS：XSS跨站
        #     WAF_RFI：文件包含
        #     WAF_DIR_TRAVERSAL：目录遍历
        #     WAF_SHELL_BACKDOOR：木马后门
        #     WAF_SERVER_ERROR_LEAKAGE：服务器信息泄漏
        #     WAF_FILE_UPLOAD：文件上传
        #     WAF_CMDI：命令注入
        #     WAF_XPATH_LDAP_SSI：XPATH/LADP/SSI注入
        #     WAF_SCANNER：扫描器
        #     WAF_FILE_DOWNLOAD：非法下载
        #     WAF_THIRDCOMP：第三方组件漏洞
        #     WAF_XXE：XML注入
        #     WAF_SSRF：服务端请求伪造
        #     WAF_CUSTOM_RULE：自定义规则"}
        self.attack_types = attack_types
        # {"en":"Matching conditions,array,Currently only one is supported.", "zh_CN":"匹配条件，数组，目前只支持一个。"}
        self.template_rule_white_conditions = template_rule_white_conditions
        # {"en":"Correlation domain name, array.", "zh_CN":"关联域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.range_type, 'range_type')
        self.validate_required(self.rule_ids, 'rule_ids')
        self.validate_required(self.attack_types, 'attack_types')
        self.validate_required(self.template_rule_white_conditions, 'template_rule_white_conditions')
        if self.template_rule_white_conditions:
            for k in self.template_rule_white_conditions:
                if k:
                    k.validate()
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.mode is not None:
            result['mode'] = self.mode
        if self.msg is not None:
            result['msg'] = self.msg
        if self.range_type is not None:
            result['rangeType'] = self.range_type
        if self.rule_ids is not None:
            result['ruleIds'] = self.rule_ids
        if self.attack_types is not None:
            result['attackTypes'] = self.attack_types
        if self.template_rule_white_conditions is not None:
            result['templateRuleWhiteConditions'] = []
            for k in self.template_rule_white_conditions:
                result['templateRuleWhiteConditions'].append(k.to_map() if k else None)
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('rangeType') is not None:
            self.range_type = m.get('rangeType')
        if m.get('ruleIds') is not None:
            self.rule_ids = m.get('ruleIds')
        if m.get('attackTypes') is not None:
            self.attack_types = m.get('attackTypes')
        if m.get('templateRuleWhiteConditions') is not None:
            self.template_rule_white_conditions = []
            for k in m.get('templateRuleWhiteConditions'):
                temp_model = GetRuleExceptionListRuleWhiteCondition()
                self.template_rule_white_conditions.append(temp_model.from_map(k))
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class GetRuleExceptionListRuleWhitePage(TeaModel):
    def __init__(
        self,
        total: int = None,
        pages: int = None,
        current: int = None,
        size: int = None,
        records: List[GetRuleExceptionListRuleWhite] = None,
    ):
        # {"en":"The total number of data.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"Total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"Number each page.", "zh_CN":"每页数量。"}
        self.size = size
        # {"en":"Template information,array.", "zh_CN":"数据列表，数组。"}
        self.records = records

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.current, 'current')
        self.validate_required(self.size, 'size')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['total'] = self.total
        if self.pages is not None:
            result['pages'] = self.pages
        if self.current is not None:
            result['current'] = self.current
        if self.size is not None:
            result['size'] = self.size
        if self.records is not None:
            result['records'] = []
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('records') is not None:
            self.records = []
            for k in m.get('records'):
                temp_model = GetRuleExceptionListRuleWhite()
                self.records.append(temp_model.from_map(k))
        return self


class GetRuleExceptionListResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: GetRuleExceptionListRuleWhitePage = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message
        # {"en":"Return data.", "zh_CN":"返回值。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = GetRuleExceptionListRuleWhitePage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetRuleExceptionListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetRuleExceptionListParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetRuleExceptionListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetRuleExceptionListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryAccessControlRuleListRequest(TeaModel):
    def __init__(
        self,
        rule_name: str = None,
        domain_list: List[str] = None,
    ):
        # {"en":"QueryAccessControlRuleListRule name.", "zh_CN":"规则名称。"}
        self.rule_name = rule_name
        # {"en":"Domain List.", "zh_CN":"域名列表。"}
        self.domain_list = domain_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class QueryAccessControlRuleListRule(TeaModel):
    def __init__(
        self,
        rule_name: str = None,
        rule_id: str = None,
        rule_descript: str = None,
        rule_value: str = None,
        rule_match: str = None,
        rule_type: str = None,
        domain_list: str = None,
    ):
        # {"en":"QueryAccessControlRuleListRule name.", "zh_CN":"规则名称。"}
        self.rule_name = rule_name
        # {"en":"QueryAccessControlRuleListRule id.", "zh_CN":"规则ID。"}
        self.rule_id = rule_id
        # {"en":"Descript.", "zh_CN":"描述。"}
        self.rule_descript = rule_descript
        # {"en":"QueryAccessControlRuleListRule of value.", "zh_CN":"规则值。"}
        self.rule_value = rule_value
        # {"en":"QueryAccessControlRuleListRule Match.
        #  0:IP 
        #  1:IP segment", "zh_CN":"规则匹配。
        #  0：IP 
        #  1：IP段"}
        self.rule_match = rule_match
        # {"en":"QueryAccessControlRuleListRule type. 
        #  0:whitelist 
        #  1:blacklist  
        #  2:url whitelist 
        #  3:url blacklist 
        #  4:ua whitelist
        #     5:ua blacklist,6:header whitelist 
        #  7:header blacklist 
        #  8:area whitelist 
        #  9:area blacklist", 
        #     "zh_CN":"规则类型。
        #  0：IP白名单 
        #  1：IP黑名单 
        #  2：url白名单 
        #  3：url黑名单 
        #  4：ua白名单 
        #  5：ua黑名单
        #     6：header白名单 
        #  7：header黑名单 
        #  8：区域白名单 
        #  9：区域黑名单"}
        self.rule_type = rule_type
        # {"en":"Domain multiple';'connect.", "zh_CN":"域名多个';'拼接。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.rule_value, 'rule_value')
        self.validate_required(self.rule_match, 'rule_match')
        self.validate_required(self.rule_type, 'rule_type')
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.rule_descript is not None:
            result['ruleDescript'] = self.rule_descript
        if self.rule_value is not None:
            result['ruleValue'] = self.rule_value
        if self.rule_match is not None:
            result['ruleMatch'] = self.rule_match
        if self.rule_type is not None:
            result['ruleType'] = self.rule_type
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('ruleDescript') is not None:
            self.rule_descript = m.get('ruleDescript')
        if m.get('ruleValue') is not None:
            self.rule_value = m.get('ruleValue')
        if m.get('ruleMatch') is not None:
            self.rule_match = m.get('ruleMatch')
        if m.get('ruleType') is not None:
            self.rule_type = m.get('ruleType')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class QueryAccessControlRuleListParams(TeaModel):
    def __init__(
        self,
        params: List[QueryAccessControlRuleListRule] = None,
    ):
        # {"en":"QueryAccessControlRuleListRule name.", "zh_CN":"规则名称。"}
        self.params = params

    def validate(self):
        self.validate_required(self.params, 'params')
        if self.params:
            for k in self.params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.params is not None:
            result['params'] = []
            for k in self.params:
                result['params'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('params') is not None:
            self.params = []
            for k in m.get('params'):
                temp_model = QueryAccessControlRuleListRule()
                self.params.append(temp_model.from_map(k))
        return self


class QueryAccessControlRuleListResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryAccessControlRuleListParams = None,
    ):
        # {"en":"Status code, success is '200'.", "zh_CN":"状态码，成功为“200”。"}
        self.code = code
        # {"en":"Return message, success is 'Success'.", "zh_CN":"返回信息，成功为“Success”。"}
        self.message = message
        # {"en":"Data returned.", "zh_CN":"返回数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryAccessControlRuleListParams()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryAccessControlRuleListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAccessControlRuleListParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAccessControlRuleListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAccessControlRuleListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateUaBotsSelectBotNamesBotPublicBotsDTO(TeaModel):
    def __init__(
        self,
        bot_category: str = None,
        select_bot_names: str = None,
    ):
        # {'en':'User-Agent based detection category. 
        #  http_version: HTTP Library', 'zh_CN':'UA特征检测类别。
        #  http_version：HTTP 库'}
        self.bot_category = bot_category
        # {'en':'Checked Bot subcategory values(Please refer to the documentation: UA Bot Dictionary), multiple separated by ; sign, an empty value means all are unchecked.', 'zh_CN':'勾选的Bot小类值(请参照说明文档：UA Bot字典)，多个以 ; 号分隔，值为空表示全部不勾选。'}
        self.select_bot_names = select_bot_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bot_category is not None:
            result['botCategory'] = self.bot_category
        if self.select_bot_names is not None:
            result['selectBotNames'] = self.select_bot_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('botCategory') is not None:
            self.bot_category = m.get('botCategory')
        if m.get('selectBotNames') is not None:
            self.select_bot_names = m.get('selectBotNames')
        return self


class UpdateUaBotsSelectBotNamesRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        update_list: List[UpdateUaBotsSelectBotNamesBotPublicBotsDTO] = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Modified Bot category data.', 'zh_CN':'修改的Bot类别数据。'}
        self.update_list = update_list

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.update_list, 'update_list')
        if self.update_list:
            for k in self.update_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.update_list is not None:
            result['updateList'] = []
            for k in self.update_list:
                result['updateList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('updateList') is not None:
            self.update_list = []
            for k in m.get('updateList'):
                temp_model = UpdateUaBotsSelectBotNamesBotPublicBotsDTO()
                self.update_list.append(temp_model.from_map(k))
        return self


class UpdateUaBotsSelectBotNamesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateUaBotsSelectBotNamesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateUaBotsSelectBotNamesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateUaBotsSelectBotNamesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateUaBotsSelectBotNamesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetConsumerListRequest(TeaModel):
    def __init__(
        self,
        consumer_id: str = None,
        consumer_name: str = None,
        consumer_group: str = None,
        page: str = None,
        size: str = None,
    ):
        # {"en":"Consumer ID.", "zh_CN":"消费方ID。"}
        self.consumer_id = consumer_id
        # {"en":"Consumer name.", "zh_CN":"消费方名称。"}
        self.consumer_name = consumer_name
        # {"en":"Consumer group, multiple use ; split.", "zh_CN":"消费方分组，多个用分号隔开。"}
        self.consumer_group = consumer_group
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.page = page
        # {"en":"The number of records per page.", "zh_CN":"每页消费方条数。"}
        self.size = size

    def validate(self):
        self.validate_required(self.page, 'page')
        self.validate_required(self.size, 'size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_id is not None:
            result['consumerId'] = self.consumer_id
        if self.consumer_name is not None:
            result['consumerName'] = self.consumer_name
        if self.consumer_group is not None:
            result['consumerGroup'] = self.consumer_group
        if self.page is not None:
            result['page'] = self.page
        if self.size is not None:
            result['size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('consumerId') is not None:
            self.consumer_id = m.get('consumerId')
        if m.get('consumerName') is not None:
            self.consumer_name = m.get('consumerName')
        if m.get('consumerGroup') is not None:
            self.consumer_group = m.get('consumerGroup')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('size') is not None:
            self.size = m.get('size')
        return self


class GetConsumerListConsumerInfo(TeaModel):
    def __init__(
        self,
        id: str = None,
        consumer_name: str = None,
        consumer_group: str = None,
        auth_api_count: int = None,
        create_time: str = None,
        remark: str = None,
    ):
        # {"en":"Consumer ID.", "zh_CN":"消费方ID。"}
        self.id = id
        # {"en":"Consumer name.", "zh_CN":"消费方名称。"}
        self.consumer_name = consumer_name
        # {"en":"Consumer group.", "zh_CN":"消费方分组。"}
        self.consumer_group = consumer_group
        # {"en":"The total number of authorized API.", "zh_CN":"已授权的API数。"}
        self.auth_api_count = auth_api_count
        # {"en":"Create time, format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"创建时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.create_time = create_time
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.consumer_name, 'consumer_name')
        self.validate_required(self.consumer_group, 'consumer_group')
        self.validate_required(self.auth_api_count, 'auth_api_count')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.remark, 'remark')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.consumer_name is not None:
            result['consumerName'] = self.consumer_name
        if self.consumer_group is not None:
            result['consumerGroup'] = self.consumer_group
        if self.auth_api_count is not None:
            result['authApiCount'] = self.auth_api_count
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('consumerName') is not None:
            self.consumer_name = m.get('consumerName')
        if m.get('consumerGroup') is not None:
            self.consumer_group = m.get('consumerGroup')
        if m.get('authApiCount') is not None:
            self.auth_api_count = m.get('authApiCount')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class GetConsumerListPage(TeaModel):
    def __init__(
        self,
        current: int = None,
        pages: int = None,
        size: int = None,
        total: int = None,
        records: List[GetConsumerListConsumerInfo] = None,
    ):
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"The total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The number of records per page.", "zh_CN":"每页消费方条数。"}
        self.size = size
        # {"en":"The total number of records.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"List of consumer.", "zh_CN":"消费方列表。"}
        self.records = records

    def validate(self):
        self.validate_required(self.current, 'current')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.size, 'size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current is not None:
            result['current'] = self.current
        if self.pages is not None:
            result['pages'] = self.pages
        if self.size is not None:
            result['size'] = self.size
        if self.total is not None:
            result['total'] = self.total
        if self.records is not None:
            result['records'] = []
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('records') is not None:
            self.records = []
            for k in m.get('records'):
                temp_model = GetConsumerListConsumerInfo()
                self.records.append(temp_model.from_map(k))
        return self


class GetConsumerListResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: GetConsumerListPage = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            temp_model = GetConsumerListPage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetConsumerListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConsumerListParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConsumerListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConsumerListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteWAFCustomRuleRequest(TeaModel):
    def __init__(
        self,
        rule_id_list: List[int] = None,
    ):
        # {'en':'Rule ID List.', 'zh_CN':'规则ID列表。'}
        self.rule_id_list = rule_id_list

    def validate(self):
        self.validate_required(self.rule_id_list, 'rule_id_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id_list is not None:
            result['ruleIdList'] = self.rule_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleIdList') is not None:
            self.rule_id_list = m.get('ruleIdList')
        return self


class DeleteWAFCustomRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class DeleteWAFCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteWAFCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteWAFCustomRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class DeleteWAFCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class CreateConsumerRequest(TeaModel):
    def __init__(
        self,
        consumer_name: str = None,
        consumer_group: str = None,
        remark: str = None,
    ):
        # {"en":"Consumer name.", "zh_CN":"消费方名称。"}
        self.consumer_name = consumer_name
        # {"en":"Consumer group.", "zh_CN":"消费方分组。"}
        self.consumer_group = consumer_group
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark

    def validate(self):
        self.validate_required(self.consumer_name, 'consumer_name')
        self.validate_required(self.consumer_group, 'consumer_group')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_name is not None:
            result['consumerName'] = self.consumer_name
        if self.consumer_group is not None:
            result['consumerGroup'] = self.consumer_group
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('consumerName') is not None:
            self.consumer_name = m.get('consumerName')
        if m.get('consumerGroup') is not None:
            self.consumer_group = m.get('consumerGroup')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class CreateConsumerResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: dict = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreateConsumerPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateConsumerParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateConsumerRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateConsumerResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetBehaviorAnalyseRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"domain.", "zh_CN":"域名。"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class GetBehaviorAnalyseReqRow(TeaModel):
    def __init__(
        self,
        req_judge: str = None,
        req_type_1: str = None,
        req_type_2: str = None,
        req_isequal: str = None,
        req_value: int = None,
        api_req_type: str = None,
        api_self_isregex: str = None,
        api_self_url: str = None,
        api_req_isequal: str = None,
        api_req_value: int = None,
        api_req_name: str = None,
    ):
        # {"en":"Request quantity determination. 
        #  0:Request Number 
        #  1:Request Ratio", "zh_CN":"请求数量判定。  
        #  0：请求数量判定 
        #  1：请求比例判定"}
        self.req_judge = req_judge
        # {"en":"Request type1. 
        #   0:Total requests 
        #  1:Requests of GET method 
        #  2:Requests of POST method 
        #   3:Requests of image resource 
        #  4:Requests of css resource 
        #  5:Requests of js resource 
        #  6:Requests of other static resource", 
        # 	"zh_CN":"请求类型1。
        #  0：总请求次数 
        #  1：GET请求次 
        #  2：POST请求次数 
        #  3：图片资源请求次: 
        #  4：CSS资源请求次数-4 
        #  5：JS资源请求次数-5 
        #  6：其他静态资源请求次"}
        self.req_type_1 = req_type_1
        # {"en":"Request type2. 
        #   0:Total requests 
        #  1:Requests of GET method 
        #  2:Requests of POST method 
        #   3:Requests of image resource 
        #  4:Requests of css resource 
        #  5:Requests of js resource 
        #  6:Requests of other static resource",
        # 	"zh_CN":"请求类型2。  
        #  0：总请求次数 
        #  1：GET请求次数 
        #  2：POST请求次数 
        #  3：图片资源请求次数 
        #  4：CSS资源请求次数 
        #  5：JS资源请求次数 
        #  6：其他静态资源请求次数"}
        self.req_type_2 = req_type_2
        # {"en":"Operator. 
        #  0:> 
        #  1:< 
        #  2:>=\
        #  3:<= ", 
        # 	"zh_CN":"运算符。 
        #  0：> 
        #   1：< 
        #  2：>=\
        #  3：<= "}
        self.req_isequal = req_isequal
        # {"en":"Threshold. ", "zh_CN":"阈值。"}
        self.req_value = req_value
        # {"en":"API Case - request type. 
        #  0:Total requests 
        #  1:Other URL requests
        #  2:Custom URL requests:", 
        #     "zh_CN":"API场景-请求类型。 
        #  0：请求总数 
        #  1：其他URL请求数 
        #  2：自定义url请求数"}
        self.api_req_type = api_req_type
        # {"en":"API Case - operator. 
        #  0:Equals 
        #  1:Regex match 
        # 2:Contains", "zh_CN":"API场景-运算符。 
        #  0：相等
        #  1：正则匹配
        #  2：包含"}
        self.api_self_isregex = api_self_isregex
        # {"en":"API Case - Custom URL. ", "zh_CN":"API场景-自定义URL。"}
        self.api_self_url = api_self_url
        # {"en":"API Case - Operator. 
        #  0:> 
        #  1:< 
        #  2:>=\
        #  3:<= ", "zh_CN":"API场景-运算符 
        #  0：> 
        #   1：< 
        #  2：>=\
        #  3：<= "}
        self.api_req_isequal = api_req_isequal
        # {"en":"API Case - threshold. ", "zh_CN":"API-阈值。"}
        self.api_req_value = api_req_value
        # {"en":"Match type. 
        # Path:Path
        # URI:URI", "zh_CN":"匹配类型。
        # Path:路径
        # URI:URI"}
        self.api_req_name = api_req_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_judge is not None:
            result['req_judge'] = self.req_judge
        if self.req_type_1 is not None:
            result['req_type1'] = self.req_type_1
        if self.req_type_2 is not None:
            result['req_type2'] = self.req_type_2
        if self.req_isequal is not None:
            result['req_isequal'] = self.req_isequal
        if self.req_value is not None:
            result['req_value'] = self.req_value
        if self.api_req_type is not None:
            result['api_req_type'] = self.api_req_type
        if self.api_self_isregex is not None:
            result['api_self_isregex'] = self.api_self_isregex
        if self.api_self_url is not None:
            result['api_self_url'] = self.api_self_url
        if self.api_req_isequal is not None:
            result['api_req_isequal'] = self.api_req_isequal
        if self.api_req_value is not None:
            result['api_req_value'] = self.api_req_value
        if self.api_req_name is not None:
            result['api_req_name'] = self.api_req_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_judge') is not None:
            self.req_judge = m.get('req_judge')
        if m.get('req_type1') is not None:
            self.req_type_1 = m.get('req_type1')
        if m.get('req_type2') is not None:
            self.req_type_2 = m.get('req_type2')
        if m.get('req_isequal') is not None:
            self.req_isequal = m.get('req_isequal')
        if m.get('req_value') is not None:
            self.req_value = m.get('req_value')
        if m.get('api_req_type') is not None:
            self.api_req_type = m.get('api_req_type')
        if m.get('api_self_isregex') is not None:
            self.api_self_isregex = m.get('api_self_isregex')
        if m.get('api_self_url') is not None:
            self.api_self_url = m.get('api_self_url')
        if m.get('api_req_isequal') is not None:
            self.api_req_isequal = m.get('api_req_isequal')
        if m.get('api_req_value') is not None:
            self.api_req_value = m.get('api_req_value')
        if m.get('api_req_name') is not None:
            self.api_req_name = m.get('api_req_name')
        return self


class GetBehaviorAnalyseFpRow(TeaModel):
    def __init__(
        self,
        protection_scope: int = None,
        protection_content: str = None,
        protection_name: str = None,
    ):
        # {"en":"Protection path matching method.
        #  3:Equals 
        #  4:Regex match
        # 5:Contains", "zh_CN":"防护路径匹配方式。
        #  3：等于 
        #  4：正则匹配
        # 5：包含"}
        self.protection_scope = protection_scope
        # {"en":"Protection path content.", "zh_CN":"防护路径内容。"}
        self.protection_content = protection_content
        # {"en":"Protection type. 
        # Path:Path
        # URI:URI", "zh_CN":"防护类型。
        # Path:路径
        # URI:URI"}
        self.protection_name = protection_name

    def validate(self):
        self.validate_required(self.protection_scope, 'protection_scope')
        self.validate_required(self.protection_content, 'protection_content')
        self.validate_required(self.protection_name, 'protection_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.protection_scope is not None:
            result['protection_scope'] = self.protection_scope
        if self.protection_content is not None:
            result['protection_content'] = self.protection_content
        if self.protection_name is not None:
            result['protection_name'] = self.protection_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('protection_scope') is not None:
            self.protection_scope = m.get('protection_scope')
        if m.get('protection_content') is not None:
            self.protection_content = m.get('protection_content')
        if m.get('protection_name') is not None:
            self.protection_name = m.get('protection_name')
        return self


class GetBehaviorAnalyseRuleContent(TeaModel):
    def __init__(
        self,
        rule_name: str = None,
        rule_description: str = None,
        application_scen: int = None,
        statistical_period: int = None,
        statistical_item: int = None,
        action: int = None,
        req_rows: List[GetBehaviorAnalyseReqRow] = None,
        fp_rows: List[GetBehaviorAnalyseFpRow] = None,
        response: str = None,
        customer_code: str = None,
        deploy_id: str = None,
    ):
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.rule_name = rule_name
        # {"en":"Rule description.", "zh_CN":"规则描述。"}
        self.rule_description = rule_description
        # {"en":"Application scen. 
        #  0:WEB 
        #  1:API", "zh_CN":"应用场景 。
        #  0：WEB 
        #  1：API"}
        self.application_scen = application_scen
        # {"en":"Trigger condition statistical period.", "zh_CN":"触发条件-统计周期。"}
        self.statistical_period = statistical_period
        # {"en":"Trigger condition - statistical dimension.
        #  0:IP 
        #  1:IP+User-Agent 
        #  2:Client-ID 
        #  3:Device Fingerprint", "zh_CN":"触发条件-统计维度。
        #  0：IP 
        #  1：IP+UA 
        #  2：客户端ID 
        #  3：设备指纹"}
        self.statistical_item = statistical_item
        # {"en":"Action. 
        #  0:Log 
        #  1:Block 
        #  2:Custom Response Content", "zh_CN":"处理动作。
        #  0：监控 
        #  1：拦截 
        #  2：自定义响应"}
        self.action = action
        # {"en":"Request quantity/proportion determination.", "zh_CN":"请求数量/比例判定。"}
        self.req_rows = req_rows
        # {"en":"Protection path.", "zh_CN":"防护路径。"}
        self.fp_rows = fp_rows
        # {"en":"Custom response content.", "zh_CN":"自定义响应内容。"}
        self.response = response
        # {"en":"Custom response status code. Value range: [100, 999].", "zh_CN":"自定义响应状态码。"}
        self.customer_code = customer_code
        # {"en":"Deploy id.", "zh_CN":"部署ID。"}
        self.deploy_id = deploy_id

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_description, 'rule_description')
        self.validate_required(self.application_scen, 'application_scen')
        self.validate_required(self.statistical_period, 'statistical_period')
        self.validate_required(self.statistical_item, 'statistical_item')
        self.validate_required(self.action, 'action')
        self.validate_required(self.req_rows, 'req_rows')
        if self.req_rows:
            for k in self.req_rows:
                if k:
                    k.validate()
        self.validate_required(self.fp_rows, 'fp_rows')
        if self.fp_rows:
            for k in self.fp_rows:
                if k:
                    k.validate()
        self.validate_required(self.response, 'response')
        self.validate_required(self.customer_code, 'customer_code')
        self.validate_required(self.deploy_id, 'deploy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        if self.rule_description is not None:
            result['rule_description'] = self.rule_description
        if self.application_scen is not None:
            result['application_scen'] = self.application_scen
        if self.statistical_period is not None:
            result['statistical_period'] = self.statistical_period
        if self.statistical_item is not None:
            result['statistical_item'] = self.statistical_item
        if self.action is not None:
            result['action'] = self.action
        if self.req_rows is not None:
            result['req_rows'] = []
            for k in self.req_rows:
                result['req_rows'].append(k.to_map() if k else None)
        if self.fp_rows is not None:
            result['fp_rows'] = []
            for k in self.fp_rows:
                result['fp_rows'].append(k.to_map() if k else None)
        if self.response is not None:
            result['response'] = self.response
        if self.customer_code is not None:
            result['customer_code'] = self.customer_code
        if self.deploy_id is not None:
            result['deploy_id'] = self.deploy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        if m.get('rule_description') is not None:
            self.rule_description = m.get('rule_description')
        if m.get('application_scen') is not None:
            self.application_scen = m.get('application_scen')
        if m.get('statistical_period') is not None:
            self.statistical_period = m.get('statistical_period')
        if m.get('statistical_item') is not None:
            self.statistical_item = m.get('statistical_item')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('req_rows') is not None:
            self.req_rows = []
            for k in m.get('req_rows'):
                temp_model = GetBehaviorAnalyseReqRow()
                self.req_rows.append(temp_model.from_map(k))
        if m.get('fp_rows') is not None:
            self.fp_rows = []
            for k in m.get('fp_rows'):
                temp_model = GetBehaviorAnalyseFpRow()
                self.fp_rows.append(temp_model.from_map(k))
        if m.get('response') is not None:
            self.response = m.get('response')
        if m.get('customer_code') is not None:
            self.customer_code = m.get('customer_code')
        if m.get('deploy_id') is not None:
            self.deploy_id = m.get('deploy_id')
        return self


class GetBehaviorAnalyseRow(TeaModel):
    def __init__(
        self,
        rule_id: str = None,
        rule_content: GetBehaviorAnalyseRuleContent = None,
    ):
        # {"en":"Rule id.", "zh_CN":"规则ID。"}
        self.rule_id = rule_id
        # {"en":"Rule content.", "zh_CN":"规则内容。"}
        self.rule_content = rule_content

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.rule_content, 'rule_content')
        if self.rule_content:
            self.rule_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.rule_content is not None:
            result['rule_content'] = self.rule_content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('rule_content') is not None:
            temp_model = GetBehaviorAnalyseRuleContent()
            self.rule_content = temp_model.from_map(m['rule_content'])
        return self


class GetBehaviorAnalyseAlRows(TeaModel):
    def __init__(
        self,
        al_rows: List[GetBehaviorAnalyseRow] = None,
    ):
        # {"en":"Rule array.", "zh_CN":"规则数组。"}
        self.al_rows = al_rows

    def validate(self):
        self.validate_required(self.al_rows, 'al_rows')
        if self.al_rows:
            for k in self.al_rows:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.al_rows is not None:
            result['al_rows'] = []
            for k in self.al_rows:
                result['al_rows'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('al_rows') is not None:
            self.al_rows = []
            for k in m.get('al_rows'):
                temp_model = GetBehaviorAnalyseRow()
                self.al_rows.append(temp_model.from_map(k))
        return self


class GetBehaviorAnalyseData(TeaModel):
    def __init__(
        self,
        edgebot_behavior_analyse: GetBehaviorAnalyseAlRows = None,
    ):
        # {"en":"Behavior analyse.", "zh_CN":"业务流分析。"}
        self.edgebot_behavior_analyse = edgebot_behavior_analyse

    def validate(self):
        self.validate_required(self.edgebot_behavior_analyse, 'edgebot_behavior_analyse')
        if self.edgebot_behavior_analyse:
            self.edgebot_behavior_analyse.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.edgebot_behavior_analyse is not None:
            result['edgebot_behavior_analyse'] = self.edgebot_behavior_analyse.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('edgebot_behavior_analyse') is not None:
            temp_model = GetBehaviorAnalyseAlRows()
            self.edgebot_behavior_analyse = temp_model.from_map(m['edgebot_behavior_analyse'])
        return self


class GetBehaviorAnalyseResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: GetBehaviorAnalyseData = None,
    ):
        # {"en":"Status code, success is '200'.", "zh_CN":"状态码，成功为“200”。"}
        self.code = code
        # {"en":"Return message, success is 'Success'.", "zh_CN":"返回信息，成功为“Success”。"}
        self.message = message
        # {"en":"GetBehaviorAnalyseData returned.", "zh_CN":"返回数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = GetBehaviorAnalyseData()
            self.data = temp_model.from_map(m['data'])
        return self


class GetBehaviorAnalysePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBehaviorAnalyseParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBehaviorAnalyseRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBehaviorAnalyseResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListRateLimitingRulesRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
        rule_name: str = None,
    ):
        # {'en':'Hostname list.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list
        # {'en':'Rule name, fuzzy query.', 'zh_CN':'规则名称，模糊查询。'}
        self.rule_name = rule_name

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        return self


class ListRateLimitingRulesRateLimitEffective(TeaModel):
    def __init__(
        self,
        effective: List[str] = None,
        start: str = None,
        end: str = None,
        timezone: str = None,
    ):
        # {'en':'Effective.
        # MON:Monday
        # TUE:Tuesday
        # WED:Wednesday
        # THU:Thursday
        # FRI:Friday
        # SAT:Saturday
        # SUN:Sunday', 'zh_CN':'周期。
        # MON：星期一
        # TUE：星期二
        # WED：星期三
        # THU：星期四
        # FRI：星期五
        # SAT：星期六
        # SUN：星期天'}
        self.effective = effective
        # {'en':'Start time, format: HH:mm.', 'zh_CN':'开始时间，格式：HH:mm。'}
        self.start = start
        # {'en':'End time, format: HH:mm.', 'zh_CN':'结束时间，格式：HH:mm。'}
        self.end = end
        # {'en':'Timezone,default value: GTM+8.', 'zh_CN':'时区，默认：GTM+8。','dictionary':'belong=WAAP-MS-Ext|dict=waap_timezone'}
        self.timezone = timezone

    def validate(self):
        self.validate_required(self.effective, 'effective')
        self.validate_required(self.start, 'start')
        self.validate_required(self.end, 'end')
        self.validate_required(self.timezone, 'timezone')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effective is not None:
            result['effective'] = self.effective
        if self.start is not None:
            result['start'] = self.start
        if self.end is not None:
            result['end'] = self.end
        if self.timezone is not None:
            result['timezone'] = self.timezone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('effective') is not None:
            self.effective = m.get('effective')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('end') is not None:
            self.end = m.get('end')
        if m.get('timezone') is not None:
            self.timezone = m.get('timezone')
        return self


class ListRateLimitingRulesIpOrIpsCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ip_or_ips: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equal
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'IP/CIDR.', 'zh_CN':'IP/IP段。'}
        self.ip_or_ips = ip_or_ips

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ip_or_ips, 'ip_or_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ip_or_ips is not None:
            result['ipOrIps'] = self.ip_or_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ipOrIps') is not None:
            self.ip_or_ips = m.get('ipOrIps')
        return self


class ListRateLimitingRulesPathCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        paths: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal
        # CONTAIN:Contains
        # NOT_CONTAIN:Does not contains
        # REGEX:Regex match
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：正则
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配'}
        self.match_type = match_type
        # {'en':'Path.', 'zh_CN':'路径。'}
        self.paths = paths

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.paths, 'paths')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.paths is not None:
            result['paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paths') is not None:
            self.paths = m.get('paths')
        return self


class ListRateLimitingRulesUriCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        uri: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal
        # CONTAIN:Contains
        # NOT_CONTAIN:Does not contains
        # REGEX:Regex match
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：正则
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配'}
        self.match_type = match_type
        # {'en':'URI.', 'zh_CN':'URI。'}
        self.uri = uri

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.uri, 'uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class ListRateLimitingRulesUriParamCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        param_name: str = None,
        param_value: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal
        # CONTAIN:Contains
        # NOT_CONTAIN:Does not contains
        # REGEX:Regex match
        # NONE:Empty or non-existent', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：正则
        # NONE：为空或不存在'}
        self.match_type = match_type
        # {'en':'Param name.', 'zh_CN':'参数名。'}
        self.param_name = param_name
        # {'en':'Param value.', 'zh_CN':'参数值。'}
        self.param_value = param_value

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.param_name, 'param_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.param_name is not None:
            result['paramName'] = self.param_name
        if self.param_value is not None:
            result['paramValue'] = self.param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paramName') is not None:
            self.param_name = m.get('paramName')
        if m.get('paramValue') is not None:
            self.param_value = m.get('paramValue')
        return self


class ListRateLimitingRulesUaCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ua: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal
        # CONTAIN:Contains
        # NOT_CONTAIN:Does not contains
        # REGEX:Regex match
        # NONE:Empty or non-existent
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：正则
        # NONE：为空或不存在
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配'}
        self.match_type = match_type
        # {'en':'User agent.', 'zh_CN':'User-Agent。'}
        self.ua = ua

    def validate(self):
        self.validate_required(self.match_type, 'match_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ua is not None:
            result['ua'] = self.ua
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ua') is not None:
            self.ua = m.get('ua')
        return self


class ListRateLimitingRulesRequestMethodCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        request_method: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equal
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Request method.
        # Supported values: GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY.', 'zh_CN':'请求方法。
        # 支持的值：GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY。'}
        self.request_method = request_method

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.request_method, 'request_method')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        return self


class ListRateLimitingRulesRefererCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        referer: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal
        # CONTAIN:Contains
        # NOT_CONTAIN:Does not contains
        # REGEX:Regex match
        # NONE:Empty or non-existent
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：正则
        # NONE：为空或不存在
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配'}
        self.match_type = match_type
        # {'en':'Referer.', 'zh_CN':'Referer。'}
        self.referer = referer

    def validate(self):
        self.validate_required(self.match_type, 'match_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.referer is not None:
            result['referer'] = self.referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('referer') is not None:
            self.referer = m.get('referer')
        return self


class ListRateLimitingRulesHeaderCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        key: str = None,
        value_list: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal
        # CONTAIN:Contains
        # NOT_CONTAIN:Does not contains
        # REGEX:Regex match
        # NONE:Empty or non-existent
        # NOT_REGEX: regular does not match
        # START_WITH: starts with
        # END_WITH: ends with
        # WILDCARD: wildcard matches
        # NOT_WILDCARD: wildcard does not match', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # REGEX：正则
        # NONE：为空或不存在
        # NOT_REGEX：正则不匹配
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配
        # NOT_WILDCARD：通配符不匹配'}
        self.match_type = match_type
        # {'en':'Header name.', 'zh_CN':'头部名称。'}
        self.key = key
        # {'en':'Header value.', 'zh_CN':'头部值。'}
        self.value_list = value_list

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.key is not None:
            result['key'] = self.key
        if self.value_list is not None:
            result['valueList'] = self.value_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('valueList') is not None:
            self.value_list = m.get('valueList')
        return self


class ListRateLimitingRulesAreaCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        areas: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equal
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Geo.', 'zh_CN':'区域。','dictionary':'belong=WAAP-MS-Ext|dict=waap_areaCityAndCountry'}
        self.areas = areas

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.areas, 'areas')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.areas is not None:
            result['areas'] = self.areas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('areas') is not None:
            self.areas = m.get('areas')
        return self


class ListRateLimitingRulesStatusCodeCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        status_code: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equal
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Response Code.', 'zh_CN':'状态码。'}
        self.status_code = status_code

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.status_code, 'status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        return self


class ListRateLimitingRulesSchemeCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        scheme: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equal
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'HTTP/S.
        # Supported values: HTTP/HTTPS.', 'zh_CN':'应用层协议。
        # 支持的值：HTTP/HTTPS。'}
        self.scheme = scheme

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.scheme, 'scheme')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.scheme is not None:
            result['scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('scheme') is not None:
            self.scheme = m.get('scheme')
        return self


class ListRateLimitingRulesRateLimitRuleCondition(TeaModel):
    def __init__(
        self,
        ip_or_ips_conditions: List[ListRateLimitingRulesIpOrIpsCondition] = None,
        path_conditions: List[ListRateLimitingRulesPathCondition] = None,
        uri_conditions: List[ListRateLimitingRulesUriCondition] = None,
        uri_param_conditions: List[ListRateLimitingRulesUriParamCondition] = None,
        ua_conditions: List[ListRateLimitingRulesUaCondition] = None,
        method_conditions: List[ListRateLimitingRulesRequestMethodCondition] = None,
        referer_conditions: List[ListRateLimitingRulesRefererCondition] = None,
        header_conditions: List[ListRateLimitingRulesHeaderCondition] = None,
        area_conditions: List[ListRateLimitingRulesAreaCondition] = None,
        status_code_conditions: List[ListRateLimitingRulesStatusCodeCondition] = None,
        scheme_conditions: List[ListRateLimitingRulesSchemeCondition] = None,
    ):
        # {'en':'IP/CIDR.', 'zh_CN':'IP/IP段。'}
        self.ip_or_ips_conditions = ip_or_ips_conditions
        # {'en':'Path.', 'zh_CN':'路径。'}
        self.path_conditions = path_conditions
        # {'en':'URI.', 'zh_CN':'URI。'}
        self.uri_conditions = uri_conditions
        # {'en':'URI Parameter.', 'zh_CN':'URI参数。'}
        self.uri_param_conditions = uri_param_conditions
        # {'en':'User Agent.', 'zh_CN':'User-Agent。'}
        self.ua_conditions = ua_conditions
        # {'en':'Request Method.', 'zh_CN':'请求方法。'}
        self.method_conditions = method_conditions
        # {'en':'Referer.', 'zh_CN':'Referer。'}
        self.referer_conditions = referer_conditions
        # {'en':'Request Header.', 'zh_CN':'请求头。'}
        self.header_conditions = header_conditions
        # {'en':'Geo.', 'zh_CN':'区域。'}
        self.area_conditions = area_conditions
        # {'en':'Response Code.', 'zh_CN':'状态码。'}
        self.status_code_conditions = status_code_conditions
        # {'en':'HTTP/S.', 'zh_CN':'应用层协议。'}
        self.scheme_conditions = scheme_conditions

    def validate(self):
        if self.ip_or_ips_conditions:
            for k in self.ip_or_ips_conditions:
                if k:
                    k.validate()
        if self.path_conditions:
            for k in self.path_conditions:
                if k:
                    k.validate()
        if self.uri_conditions:
            for k in self.uri_conditions:
                if k:
                    k.validate()
        if self.uri_param_conditions:
            for k in self.uri_param_conditions:
                if k:
                    k.validate()
        if self.ua_conditions:
            for k in self.ua_conditions:
                if k:
                    k.validate()
        if self.method_conditions:
            for k in self.method_conditions:
                if k:
                    k.validate()
        if self.referer_conditions:
            for k in self.referer_conditions:
                if k:
                    k.validate()
        if self.header_conditions:
            for k in self.header_conditions:
                if k:
                    k.validate()
        if self.area_conditions:
            for k in self.area_conditions:
                if k:
                    k.validate()
        if self.status_code_conditions:
            for k in self.status_code_conditions:
                if k:
                    k.validate()
        if self.scheme_conditions:
            for k in self.scheme_conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_or_ips_conditions is not None:
            result['ipOrIpsConditions'] = []
            for k in self.ip_or_ips_conditions:
                result['ipOrIpsConditions'].append(k.to_map() if k else None)
        if self.path_conditions is not None:
            result['pathConditions'] = []
            for k in self.path_conditions:
                result['pathConditions'].append(k.to_map() if k else None)
        if self.uri_conditions is not None:
            result['uriConditions'] = []
            for k in self.uri_conditions:
                result['uriConditions'].append(k.to_map() if k else None)
        if self.uri_param_conditions is not None:
            result['uriParamConditions'] = []
            for k in self.uri_param_conditions:
                result['uriParamConditions'].append(k.to_map() if k else None)
        if self.ua_conditions is not None:
            result['uaConditions'] = []
            for k in self.ua_conditions:
                result['uaConditions'].append(k.to_map() if k else None)
        if self.method_conditions is not None:
            result['methodConditions'] = []
            for k in self.method_conditions:
                result['methodConditions'].append(k.to_map() if k else None)
        if self.referer_conditions is not None:
            result['refererConditions'] = []
            for k in self.referer_conditions:
                result['refererConditions'].append(k.to_map() if k else None)
        if self.header_conditions is not None:
            result['headerConditions'] = []
            for k in self.header_conditions:
                result['headerConditions'].append(k.to_map() if k else None)
        if self.area_conditions is not None:
            result['areaConditions'] = []
            for k in self.area_conditions:
                result['areaConditions'].append(k.to_map() if k else None)
        if self.status_code_conditions is not None:
            result['statusCodeConditions'] = []
            for k in self.status_code_conditions:
                result['statusCodeConditions'].append(k.to_map() if k else None)
        if self.scheme_conditions is not None:
            result['schemeConditions'] = []
            for k in self.scheme_conditions:
                result['schemeConditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipOrIpsConditions') is not None:
            self.ip_or_ips_conditions = []
            for k in m.get('ipOrIpsConditions'):
                temp_model = ListRateLimitingRulesIpOrIpsCondition()
                self.ip_or_ips_conditions.append(temp_model.from_map(k))
        if m.get('pathConditions') is not None:
            self.path_conditions = []
            for k in m.get('pathConditions'):
                temp_model = ListRateLimitingRulesPathCondition()
                self.path_conditions.append(temp_model.from_map(k))
        if m.get('uriConditions') is not None:
            self.uri_conditions = []
            for k in m.get('uriConditions'):
                temp_model = ListRateLimitingRulesUriCondition()
                self.uri_conditions.append(temp_model.from_map(k))
        if m.get('uriParamConditions') is not None:
            self.uri_param_conditions = []
            for k in m.get('uriParamConditions'):
                temp_model = ListRateLimitingRulesUriParamCondition()
                self.uri_param_conditions.append(temp_model.from_map(k))
        if m.get('uaConditions') is not None:
            self.ua_conditions = []
            for k in m.get('uaConditions'):
                temp_model = ListRateLimitingRulesUaCondition()
                self.ua_conditions.append(temp_model.from_map(k))
        if m.get('methodConditions') is not None:
            self.method_conditions = []
            for k in m.get('methodConditions'):
                temp_model = ListRateLimitingRulesRequestMethodCondition()
                self.method_conditions.append(temp_model.from_map(k))
        if m.get('refererConditions') is not None:
            self.referer_conditions = []
            for k in m.get('refererConditions'):
                temp_model = ListRateLimitingRulesRefererCondition()
                self.referer_conditions.append(temp_model.from_map(k))
        if m.get('headerConditions') is not None:
            self.header_conditions = []
            for k in m.get('headerConditions'):
                temp_model = ListRateLimitingRulesHeaderCondition()
                self.header_conditions.append(temp_model.from_map(k))
        if m.get('areaConditions') is not None:
            self.area_conditions = []
            for k in m.get('areaConditions'):
                temp_model = ListRateLimitingRulesAreaCondition()
                self.area_conditions.append(temp_model.from_map(k))
        if m.get('statusCodeConditions') is not None:
            self.status_code_conditions = []
            for k in m.get('statusCodeConditions'):
                temp_model = ListRateLimitingRulesStatusCodeCondition()
                self.status_code_conditions.append(temp_model.from_map(k))
        if m.get('schemeConditions') is not None:
            self.scheme_conditions = []
            for k in m.get('schemeConditions'):
                temp_model = ListRateLimitingRulesSchemeCondition()
                self.scheme_conditions.append(temp_model.from_map(k))
        return self


class ListRateLimitingRulesCommonRateLimitVO(TeaModel):
    def __init__(
        self,
        id: str = None,
        domain: str = None,
        rule_name: str = None,
        description: str = None,
        scene: str = None,
        statistical_stage: str = None,
        statistical_item: str = None,
        statistics_key: str = None,
        statistical_period: int = None,
        trigger_threshold: int = None,
        intercept_time: int = None,
        effective_status: str = None,
        rate_limit_effective: ListRateLimitingRulesRateLimitEffective = None,
        asset_api_id: str = None,
        action: str = None,
        rate_limit_rule_condition: ListRateLimitingRulesRateLimitRuleCondition = None,
        update_time: str = None,
    ):
        # {'en':'Rule ID.', 'zh_CN':'规则ID。'}
        self.id = id
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Rule Name.', 'zh_CN':'规则名称。'}
        self.rule_name = rule_name
        # {'en':'Description.', 'zh_CN':'规则描述。'}
        self.description = description
        # {'en':'Protected target.
        # WEB:Website
        # API:API', 'zh_CN':'业务场景。
        # WEB：网站业务
        # API：API业务'}
        self.scene = scene
        # {'en':'Count on.
        # REQUEST:Request
        # RESPONSE:Response', 'zh_CN':'统计阶段。
        # REQUEST：请求
        # RESPONSE：响应'}
        self.statistical_stage = statistical_stage
        # {'en':'Client identifier.
        # IP:Client IP
        # IP_UA:Client IP and User-Agent
        # COOKIE:Cookie
        # IP_COOKIE:Client IP and Cookie
        # HEADER:Request Header
        # IP_HEADER:Client IP and Request Header', 'zh_CN':'统计粒度。
        # IP：客户端IP
        # IP_UA：客户端IP和User-Agent
        # COOKIE：Cookie
        # IP_COOKIE：客户端IP和Cookie
        # HEADER：请求头
        # IP_HEADER：客户端IP和请求头'}
        self.statistical_item = statistical_item
        # {'en':'Statistical key value .', 'zh_CN':'统计key值。'}
        self.statistics_key = statistics_key
        # {'en':'Statistics period, unit: seconds.', 'zh_CN':'统计周期，单位：秒。'}
        self.statistical_period = statistical_period
        # {'en':'Trigger threshold, unit: times.', 'zh_CN':'触发阈值，单位：次。'}
        self.trigger_threshold = trigger_threshold
        # {'en':'Action duration, unit: seconds.', 'zh_CN':'处理动作持续时间，单位：秒。'}
        self.intercept_time = intercept_time
        # {'en':'Cycle effective status.
        # PERMANENT:All time
        # WITHOUT:Excluded time
        # WITHIN:Selected time', 'zh_CN':'周期生效状态。
        # PERMANENT：永久生效
        # WITHOUT：周期内不生效
        # WITHIN：周期内生效'}
        self.effective_status = effective_status
        # {'en':'Effective time period.', 'zh_CN':'规则生效周期。'}
        self.rate_limit_effective = rate_limit_effective
        # {'en':'API ID under API business, multiple separated by ; sign.', 'zh_CN':'API业务下的API ID，多个用 ; 隔开。'}
        self.asset_api_id = asset_api_id
        # {'en':'Action.
        # NO_USE:Not Used
        # LOG:Log
        # COOKIE:Cookie verification
        # JS_CHECK:Javascript verification
        # DELAY:Delay
        # BLOCK:Deny
        # RESET:Reset Connection
        # Custom response ID:Custom response ID', 'zh_CN':'处理动作。
        # NO_USE：不使用
        # LOG：监控
        # COOKIE：Cookie校验
        # JS_CHECK：JavaScript校验
        # DELAY：延迟响应
        # BLOCK：拦截
        # RESET：断开连接
        # 自定义响应ID：自定义响应ID'}
        self.action = action
        # {'en':'Matching conditions.', 'zh_CN':'匹配条件。'}
        self.rate_limit_rule_condition = rate_limit_rule_condition
        # {'en':'Update time.', 'zh_CN':'更新时间。'}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.scene, 'scene')
        self.validate_required(self.statistical_stage, 'statistical_stage')
        self.validate_required(self.statistical_item, 'statistical_item')
        self.validate_required(self.statistics_key, 'statistics_key')
        self.validate_required(self.statistical_period, 'statistical_period')
        self.validate_required(self.trigger_threshold, 'trigger_threshold')
        self.validate_required(self.intercept_time, 'intercept_time')
        self.validate_required(self.effective_status, 'effective_status')
        self.validate_required(self.rate_limit_effective, 'rate_limit_effective')
        if self.rate_limit_effective:
            self.rate_limit_effective.validate()
        self.validate_required(self.asset_api_id, 'asset_api_id')
        self.validate_required(self.action, 'action')
        self.validate_required(self.rate_limit_rule_condition, 'rate_limit_rule_condition')
        if self.rate_limit_rule_condition:
            self.rate_limit_rule_condition.validate()
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.description is not None:
            result['description'] = self.description
        if self.scene is not None:
            result['scene'] = self.scene
        if self.statistical_stage is not None:
            result['statisticalStage'] = self.statistical_stage
        if self.statistical_item is not None:
            result['statisticalItem'] = self.statistical_item
        if self.statistics_key is not None:
            result['statisticsKey'] = self.statistics_key
        if self.statistical_period is not None:
            result['statisticalPeriod'] = self.statistical_period
        if self.trigger_threshold is not None:
            result['triggerThreshold'] = self.trigger_threshold
        if self.intercept_time is not None:
            result['interceptTime'] = self.intercept_time
        if self.effective_status is not None:
            result['effectiveStatus'] = self.effective_status
        if self.rate_limit_effective is not None:
            result['rateLimitEffective'] = self.rate_limit_effective.to_map()
        if self.asset_api_id is not None:
            result['assetApiId'] = self.asset_api_id
        if self.action is not None:
            result['action'] = self.action
        if self.rate_limit_rule_condition is not None:
            result['rateLimitRuleCondition'] = self.rate_limit_rule_condition.to_map()
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('statisticalStage') is not None:
            self.statistical_stage = m.get('statisticalStage')
        if m.get('statisticalItem') is not None:
            self.statistical_item = m.get('statisticalItem')
        if m.get('statisticsKey') is not None:
            self.statistics_key = m.get('statisticsKey')
        if m.get('statisticalPeriod') is not None:
            self.statistical_period = m.get('statisticalPeriod')
        if m.get('triggerThreshold') is not None:
            self.trigger_threshold = m.get('triggerThreshold')
        if m.get('interceptTime') is not None:
            self.intercept_time = m.get('interceptTime')
        if m.get('effectiveStatus') is not None:
            self.effective_status = m.get('effectiveStatus')
        if m.get('rateLimitEffective') is not None:
            temp_model = ListRateLimitingRulesRateLimitEffective()
            self.rate_limit_effective = temp_model.from_map(m['rateLimitEffective'])
        if m.get('assetApiId') is not None:
            self.asset_api_id = m.get('assetApiId')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('rateLimitRuleCondition') is not None:
            temp_model = ListRateLimitingRulesRateLimitRuleCondition()
            self.rate_limit_rule_condition = temp_model.from_map(m['rateLimitRuleCondition'])
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class ListRateLimitingRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListRateLimitingRulesCommonRateLimitVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListRateLimitingRulesCommonRateLimitVO()
                self.data.append(temp_model.from_map(k))
        return self


class ListRateLimitingRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListRateLimitingRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListRateLimitingRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListRateLimitingRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryDomainBuiltInRulesRequest(TeaModel):
    def __init__(
        self,
        domains: List[str] = None,
    ):
        # {"en":"domains", "zh_CN":"域名"}
        self.domains = domains

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['domains'] = self.domains
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        return self


class QueryDomainBuiltInRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[str] = None,
        domain: str = None,
        security_level: str = None,
        rule_name_cn: str = None,
        rule_name_en: str = None,
        action: str = None,
        rule_id: str = None,
    ):
        # {"en":"code", "zh_CN":"code"}
        self.code = code
        # {"en":"msg", "zh_CN":"msg"}
        self.msg = msg
        # {"en":"data.", "zh_CN":"data"}
        self.data = data
        # {"en":"domain", "zh_CN":"域名"}
        self.domain = domain
        # {"en":"Security level, default enabled: 'DEFAULT_ ENABLE ', enable during attack:' ATTACK_ ENABLE ', basic off:' BASE_ Close ', permanently closed:' Close '", "zh_CN":"安全级别， 默认启用:'DEFAULT_ENABLE'，攻击时启用：'ATTACK_ENABLE'，基本关闭：'BASE_CLOSE'，永久关闭:'CLOSE'"}
        self.security_level = security_level
        # {"en":"Chinese Rule Name", "zh_CN":"中文规则名称"}
        self.rule_name_cn = rule_name_cn
        # {"en":"English Rule Name", "zh_CN":"英文规则名称"}
        self.rule_name_en = rule_name_en
        # {"en":"Process action, intercept: 'BLOCK', monitor: 'LOG', human-machine verification: 'RR',: reject connection: 'Denied'", "zh_CN":"处理动作， 拦截:'BLOCK'，监控：'LOG'，人机校验：'RR',：拒绝连接：'DENIED'"}
        self.action = action
        # {"en":"rule id", "zh_CN":"规则ID"}
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.security_level, 'security_level')
        self.validate_required(self.rule_name_cn, 'rule_name_cn')
        self.validate_required(self.rule_name_en, 'rule_name_en')
        self.validate_required(self.action, 'action')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        if self.domain is not None:
            result['domain'] = self.domain
        if self.security_level is not None:
            result['securityLevel'] = self.security_level
        if self.rule_name_cn is not None:
            result['ruleNameCn'] = self.rule_name_cn
        if self.rule_name_en is not None:
            result['ruleNameEn'] = self.rule_name_en
        if self.action is not None:
            result['action'] = self.action
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('securityLevel') is not None:
            self.security_level = m.get('securityLevel')
        if m.get('ruleNameCn') is not None:
            self.rule_name_cn = m.get('ruleNameCn')
        if m.get('ruleNameEn') is not None:
            self.rule_name_en = m.get('ruleNameEn')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        return self


class QueryDomainBuiltInRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainBuiltInRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainBuiltInRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class QueryDomainBuiltInRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetBuiltInRuleListRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        domain_list: List[str] = None,
        lang: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # {"en":"Template name, support fuzzy queries.", "zh_CN":"模板名称，支持模糊查询。"}
        self.name = name
        # {"en":"Correlation domain name, array.", "zh_CN":"关联域名，数组。"}
        self.domain_list = domain_list
        # {"en":"The language of response data, default value: cn.
        #     cn: Chinese
        #     en: English", "zh_CN":"返回内容的语言版本，默认值：cn。
        #     cn：中文
        #     en：英文"}
        self.lang = lang
        # {"en":"Current page number,1 by default.", "zh_CN":"当前页数，默认1。"}
        self.page_num = page_num
        # {"en":"Number each page,the maximum 1000,10 by default.", "zh_CN":"每页数量, 最大1000，默认10。"}
        self.page_size = page_size

    def validate(self):
        if self.page_size is not None:
            self.validate_maximum(self.page_size, 'page_size', 1000)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.lang is not None:
            result['lang'] = self.lang
        if self.page_num is not None:
            result['pageNum'] = self.page_num
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('lang') is not None:
            self.lang = m.get('lang')
        if m.get('pageNum') is not None:
            self.page_num = m.get('pageNum')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class GetBuiltInRuleListRuleTemplate(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
        update_type: int = None,
        update_time: str = None,
        msg: str = None,
        domain_list: List[str] = None,
    ):
        # {"en":"Template ID.", "zh_CN":"模板ID。"}
        self.id = id
        # {"en":"Template name.", "zh_CN":"模板名称。"}
        self.name = name
        # {"en":"Whether to automatically update,1:yes,0:no.", "zh_CN":"是否自动更新，1：是，0：否。"}
        self.update_type = update_type
        # {"en":"Update time,GMT+8.", "zh_CN":"更新时间，GMT+8。"}
        self.update_time = update_time
        # {"en":"Template description.", "zh_CN":"模板描述。"}
        self.msg = msg
        # {"en":"Correlation domain name, array.", "zh_CN":"关联域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.update_type, 'update_type')
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.update_type is not None:
            result['updateType'] = self.update_type
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        if self.msg is not None:
            result['msg'] = self.msg
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('updateType') is not None:
            self.update_type = m.get('updateType')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class GetBuiltInRuleListRuleTemplatePage(TeaModel):
    def __init__(
        self,
        total: int = None,
        pages: int = None,
        current: int = None,
        size: int = None,
        records: List[GetBuiltInRuleListRuleTemplate] = None,
    ):
        # {"en":"The total number of data.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"Total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"Number each page.", "zh_CN":"每页数量。"}
        self.size = size
        # {"en":"Template information,array.", "zh_CN":"模板信息，数组。"}
        self.records = records

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.current, 'current')
        self.validate_required(self.size, 'size')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['total'] = self.total
        if self.pages is not None:
            result['pages'] = self.pages
        if self.current is not None:
            result['current'] = self.current
        if self.size is not None:
            result['size'] = self.size
        if self.records is not None:
            result['records'] = []
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('records') is not None:
            self.records = []
            for k in m.get('records'):
                temp_model = GetBuiltInRuleListRuleTemplate()
                self.records.append(temp_model.from_map(k))
        return self


class GetBuiltInRuleListResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: GetBuiltInRuleListRuleTemplatePage = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message
        # {"en":"Return data.", "zh_CN":"返回值。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = GetBuiltInRuleListRuleTemplatePage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetBuiltInRuleListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBuiltInRuleListParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBuiltInRuleListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBuiltInRuleListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateRateLimitingRuleRateLimitEffective(TeaModel):
    def __init__(
        self,
        effective: List[str] = None,
        start: str = None,
        end: str = None,
        timezone: str = None,
    ):
        # {'en':'Effective.
        # MON:Monday
        # TUE:Tuesday
        # WED:Wednesday
        # THU:Thursday
        # FRI:Friday
        # SAT:Saturday
        # SUN:Sunday', 'zh_CN':'周期。
        # MON：星期一
        # TUE：星期二
        # WED：星期三
        # THU：星期四
        # FRI：星期五
        # SAT：星期六
        # SUN：星期天'}
        self.effective = effective
        # {'en':'Start time, format: HH:mm.', 'zh_CN':'开始时间，格式：HH:mm。'}
        self.start = start
        # {'en':'End time, format: HH:mm.', 'zh_CN':'结束时间，格式：HH:mm。'}
        self.end = end
        # {'en':'Timezone,default value: GTM+8.', 'zh_CN':'时区，默认：GTM+8。','dictionary':'belong=WAAP-MS-Ext|dict=waap_timezone'}
        self.timezone = timezone

    def validate(self):
        self.validate_required(self.effective, 'effective')
        self.validate_required(self.start, 'start')
        self.validate_required(self.end, 'end')
        self.validate_required(self.timezone, 'timezone')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effective is not None:
            result['effective'] = self.effective
        if self.start is not None:
            result['start'] = self.start
        if self.end is not None:
            result['end'] = self.end
        if self.timezone is not None:
            result['timezone'] = self.timezone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('effective') is not None:
            self.effective = m.get('effective')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('end') is not None:
            self.end = m.get('end')
        if m.get('timezone') is not None:
            self.timezone = m.get('timezone')
        return self


class UpdateRateLimitingRuleIpOrIpsCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ip_or_ips: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'IP/CIDR, maximum 500 IP/CIDR.', 'zh_CN':'IP/IP段，最多500个IP/IP段。'}
        self.ip_or_ips = ip_or_ips

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ip_or_ips, 'ip_or_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ip_or_ips is not None:
            result['ipOrIps'] = self.ip_or_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ipOrIps') is not None:
            self.ip_or_ips = m.get('ipOrIps')
        return self


class UpdateRateLimitingRulePathCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        paths: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, path case sensitive
        # NOT_EQUAL: Does not equal, path case sensitive
        # CONTAIN: Contains, path case insensitive
        # NOT_CONTAIN: Does not Contains, path case insensitive
        # REGEX: Regex match, path case insensitive
        # NOT_REGEX: Regular does not match, path case sensitive
        # START_WITH: Starts with, path case sensitive
        # END_WITH: Ends with, path case sensitive
        # WILDCARD: Wildcard matches, path case sensitive, ** represents zero or more arbitrary characters, ? represents any single character.
        # NOT_WILDCARD: Wildcard does not match, path case sensitive, ** represents zero or more arbitrary characters, ? represents any single character ", "zh_CN":"匹配类型。
        # EQUAL：等于，路径大小写敏感
        # NOT_EQUAL：不等于，路径大小写敏感
        # CONTAIN：包含，路径大小写不敏感
        # NOT_CONTAIN：不包含，路径大小写不敏感
        # REGEX：匹配正则，路径大小写不敏感
        # NOT_REGEX：正则不匹配，路径大小写不敏感
        # START_WITH：开头是，路径大小写不敏感
        # END_WITH：结尾是，路径大小写不敏感
        # WILDCARD：通配符匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Path.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, path needs to start with "/", and no parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: /test.html.', 'zh_CN':'路径。
        # 当匹配类型为等于/不等于/开头是/结尾是，路径必须以“/”开头，不含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html。'}
        self.paths = paths

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.paths, 'paths')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.paths is not None:
            result['paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paths') is not None:
            self.paths = m.get('paths')
        return self


class UpdateRateLimitingRuleUriCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        uri: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, URI case sensitive
        # NOT_EQUAL: Does not equal, URI case sensitive
        # CONTAIN: Contains, URI case insensitive
        # NOT_CONTAIN: Does not Contains, URI case insensitive
        # REGEX: Regex match, URI case insensitive
        # NOT_REGEX: Regular does not match, URI case insensitive
        # START_WITH: Starts with, URI case insensitive
        # END_WITH: Ends with, URI case insensitive
        # WILDCARD: Wildcard matches, URI case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, URI case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，URI大小写敏感
        # NOT_EQUAL：不等于，URI大小写敏感
        # CONTAIN：包含，URI大小写不敏感
        # NOT_CONTAIN：不包含，URI大小写不敏感
        # REGEX：匹配正则，URI大小写不敏感
        # NOT_REGEX：正则不匹配，URI大小写不敏感
        # START_WITH：开头是，URI大小写不敏感
        # END_WITH：结尾是，URI大小写不敏感
        # WILDCARD：通配符匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'URI.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, uri needs to start with "/", and includes parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: /test.html?id=1.', 'zh_CN':'URI。
        # 当匹配类型为等于/不等于/开头是/结尾是，URI必须以”/“开头，含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html?id=1。'}
        self.uri = uri

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.uri, 'uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class UpdateRateLimitingRuleUriParamCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        param_name: str = None,
        param_value: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals,param value case sensitive
        # NOT_EQUAL:Does not equal,param value case sensitive
        # CONTAIN:Contains,param value case insensitive
        # NOT_CONTAIN:Does not contains,param value case insensitive
        # REGEX:Regex match,param value case insensitive
        # NONE:Empty or non-existent', 'zh_CN':'匹配类型。
        # EQUAL：等于，参数值大小写敏感
        # NOT_EQUAL：不等于，参数值大小写敏感
        # CONTAIN：包含，参数值大小写不敏感
        # NOT_CONTAIN：不包含，参数值大小写不敏感
        # REGEX：正则，参数值大小写不敏感
        # NONE：为空或不存在'}
        self.match_type = match_type
        # {'en':'Param name,case sensitive,maximum 100 characters.
        # Example: id.', 'zh_CN':'参数名，大小写敏感，最多100个字符。
        # 示例：id。'}
        self.param_name = param_name
        # {'en':'Param value.', 'zh_CN':'参数值。'}
        self.param_value = param_value

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.param_name, 'param_name')
        self.validate_required(self.param_value, 'param_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.param_name is not None:
            result['paramName'] = self.param_name
        if self.param_value is not None:
            result['paramValue'] = self.param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paramName') is not None:
            self.param_name = m.get('paramName')
        if m.get('paramValue') is not None:
            self.param_value = m.get('paramValue')
        return self


class UpdateRateLimitingRuleUaCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ua: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, user agent case sensitive
        # NOT_EQUAL: Does not equal, user agent case sensitive
        # CONTAIN: Contains, user agent case insensitive
        # NOT_CONTAIN: Does not Contains, user agent case insensitive
        # NONE:Empty or non-existent
        # REGEX: Regex match, user agent case insensitive
        # NOT_REGEX: Regular does not match, user agent case insensitive
        # START_WITH: Starts with, user agent case insensitive
        # END_WITH: Ends with, user agent case insensitive
        # WILDCARD: Wildcard matches, user agent case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, user agent case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，User-Agent大小写敏感
        # NOT_EQUAL：不等于，User-Agent大小写敏感
        # CONTAIN：包含，User-Agent大小写不敏感
        # NOT_CONTAIN：不包含，User-Agent大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，User-Agent大小写不敏感
        # NOT_REGEX：正则不匹配，User-Agent大小写不敏感
        # START_WITH：开头是，User-Agent大小写不敏感
        # END_WITH：结尾是，User-Agent大小写不敏感
        # WILDCARD：通配符匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'User agent.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: go-Http-client/1.1.', 'zh_CN':'User-Agent。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：go-Http-client/1.1。'}
        self.ua = ua

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ua, 'ua')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ua is not None:
            result['ua'] = self.ua
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ua') is not None:
            self.ua = m.get('ua')
        return self


class UpdateRateLimitingRuleRequestMethodCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        request_method: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Request method.
        # Supported values: GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY.', 'zh_CN':'请求方法。
        # 支持的值：GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY。'}
        self.request_method = request_method

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.request_method, 'request_method')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        return self


class UpdateRateLimitingRuleRefererCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        referer: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, referer case sensitive
        # NOT_EQUAL: Does not equal, referer case sensitive
        # CONTAIN: Contains, referer case insensitive
        # NOT_CONTAIN: Does not Contains, referer case insensitive
        # NONE:Empty or non-existent
        # REGEX: Regex match, referer case insensitive
        # NOT_REGEX: Regular does not match, referer case insensitive
        # START_WITH: Starts with, referer case insensitive
        # END_WITH: Ends with, referer case insensitive
        # WILDCARD: Wildcard matches, referer case insensitive, ** represents zero or more arbitrary characters, ? represents any single characte
        # NOT_WILDCARD: Wildcard does not match, referer case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，referer大小写敏感
        # NOT_EQUAL：不等于，referer大小写敏感
        # CONTAIN：包含，referer大小写不敏感
        # NOT_CONTAIN：不包含，referer大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，referer大小写不敏感
        # NOT_REGEX：正则不匹配，referer大小写不敏感
        # START_WITH：开头是，referer大小写不敏感
        # END_WITH：结尾是，referer大小写不敏感
        # WILDCARD：通配符匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Referer.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: http://test.com.', 'zh_CN':'Referer。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：http://test.com。'}
        self.referer = referer

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.referer, 'referer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.referer is not None:
            result['referer'] = self.referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('referer') is not None:
            self.referer = m.get('referer')
        return self


class UpdateRateLimitingRuleHeaderCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        key: str = None,
        value_list: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, request header values case sensitive
        # NOT_EQUAL: Does not equal, request header values case sensitive
        # CONTAIN: Contains, request header values case insensitive
        # NOT_CONTAIN: Does not Contains, request header values case insensitive
        # NONE: Empty or non-existent
        # REGEX: Regex match, request header values case insensitive
        # NOT_REGEX: Regular does not match, request header values case insensitive
        # START_WITH: Starts with, request header values case insensitive
        # END_WITH: Ends with, request header values case insensitive
        # WILDCARD: Wildcard matches, request header values case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, request header values case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，头部值大小写敏感
        # NOT_EQUAL：不等于，头部值大小写敏感
        # CONTAIN：包含，头部值大小写不敏感
        # NOT_CONTAIN：不包含，头部值大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，头部值大小写不敏感
        # NOT_REGEX：正则不匹配，头部值大小写不敏感
        # START_WITH：开头是，头部值大小写不敏感
        # END_WITH：结尾是，头部值大小写不敏感
        # WILDCARD：通配符匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Header name,case insensitive,up to 100 characters.
        # Example: Accept.', 'zh_CN':'头部名称，大小写不敏感，最多100个字符。
        # 示例：Accept。'}
        self.key = key
        # {'en':'Header value.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.', 'zh_CN':'头部值。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。'}
        self.value_list = value_list

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.key, 'key')
        self.validate_required(self.value_list, 'value_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.key is not None:
            result['key'] = self.key
        if self.value_list is not None:
            result['valueList'] = self.value_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('valueList') is not None:
            self.value_list = m.get('valueList')
        return self


class UpdateRateLimitingRuleAreaCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        areas: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Geo.', 'zh_CN':'区域。','dictionary':'belong=WAAP-MS-Ext|dict=waap_areaCityAndCountry'}
        self.areas = areas

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.areas, 'areas')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.areas is not None:
            result['areas'] = self.areas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('areas') is not None:
            self.areas = m.get('areas')
        return self


class UpdateRateLimitingRuleStatusCodeCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        status_code: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Response Code.', 'zh_CN':'状态码。'}
        self.status_code = status_code

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.status_code, 'status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        return self


class UpdateRateLimitingRuleSchemeCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        scheme: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'HTTP/S.
        # Supported values: HTTP/HTTPS.', 'zh_CN':'应用层协议。
        # 支持的值：HTTP/HTTPS。'}
        self.scheme = scheme

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.scheme, 'scheme')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.scheme is not None:
            result['scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('scheme') is not None:
            self.scheme = m.get('scheme')
        return self


class UpdateRateLimitingRuleRateLimitRuleCondition(TeaModel):
    def __init__(
        self,
        ip_or_ips_conditions: List[UpdateRateLimitingRuleIpOrIpsCondition] = None,
        path_conditions: List[UpdateRateLimitingRulePathCondition] = None,
        uri_conditions: List[UpdateRateLimitingRuleUriCondition] = None,
        uri_param_conditions: List[UpdateRateLimitingRuleUriParamCondition] = None,
        ua_conditions: List[UpdateRateLimitingRuleUaCondition] = None,
        method_conditions: List[UpdateRateLimitingRuleRequestMethodCondition] = None,
        referer_conditions: List[UpdateRateLimitingRuleRefererCondition] = None,
        header_conditions: List[UpdateRateLimitingRuleHeaderCondition] = None,
        area_conditions: List[UpdateRateLimitingRuleAreaCondition] = None,
        status_code_conditions: List[UpdateRateLimitingRuleStatusCodeCondition] = None,
        scheme_conditions: List[UpdateRateLimitingRuleSchemeCondition] = None,
    ):
        # {'en':'IP/CIDR, match type cannot be repeated.', 'zh_CN':'IP/IP段，匹配类型不可重复。'}
        self.ip_or_ips_conditions = ip_or_ips_conditions
        # {'en':'Path, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.', 'zh_CN':'路径，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。'}
        self.path_conditions = path_conditions
        # {'en':'URI, match type cannot be repeated.
        # 
        # When the business scenario is API, this matching condition is not supported.', 'zh_CN':'URI，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。'}
        self.uri_conditions = uri_conditions
        # {'en':'URI ParameterI, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.', 'zh_CN':'URI参数，匹配类型不可重复。
        # 当业务场景为网站业务时不支持此匹配条件。'}
        self.uri_param_conditions = uri_param_conditions
        # {'en':'User Agent, match type cannot be repeated.', 'zh_CN':'User-Agent，匹配类型不可重复。'}
        self.ua_conditions = ua_conditions
        # {'en':'Request Method.
        # When the business scenario is API,this matching condition is not supported.', 'zh_CN':'请求方法，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。'}
        self.method_conditions = method_conditions
        # {'en':'Referer, match type cannot be repeated.', 'zh_CN':'Referer，匹配类型不可重复。'}
        self.referer_conditions = referer_conditions
        # {'en':'Request Header, match type can be repeated.', 'zh_CN':'请求头，匹配类型可重复。'}
        self.header_conditions = header_conditions
        # {'en':'Geo,match type cannot be repeated.', 'zh_CN':'区域，匹配类型不可重复。'}
        self.area_conditions = area_conditions
        # {'en':'Response Code, match type cannot be repeated.', 'zh_CN':'状态码，匹配类型不可重复。'}
        self.status_code_conditions = status_code_conditions
        # {'en':'HTTP/S, match type cannot be repeated.', 'zh_CN':'应用层协议，匹配类型不可重复。'}
        self.scheme_conditions = scheme_conditions

    def validate(self):
        if self.ip_or_ips_conditions:
            for k in self.ip_or_ips_conditions:
                if k:
                    k.validate()
        if self.path_conditions:
            for k in self.path_conditions:
                if k:
                    k.validate()
        if self.uri_conditions:
            for k in self.uri_conditions:
                if k:
                    k.validate()
        if self.uri_param_conditions:
            for k in self.uri_param_conditions:
                if k:
                    k.validate()
        if self.ua_conditions:
            for k in self.ua_conditions:
                if k:
                    k.validate()
        if self.method_conditions:
            for k in self.method_conditions:
                if k:
                    k.validate()
        if self.referer_conditions:
            for k in self.referer_conditions:
                if k:
                    k.validate()
        if self.header_conditions:
            for k in self.header_conditions:
                if k:
                    k.validate()
        if self.area_conditions:
            for k in self.area_conditions:
                if k:
                    k.validate()
        if self.status_code_conditions:
            for k in self.status_code_conditions:
                if k:
                    k.validate()
        if self.scheme_conditions:
            for k in self.scheme_conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_or_ips_conditions is not None:
            result['ipOrIpsConditions'] = []
            for k in self.ip_or_ips_conditions:
                result['ipOrIpsConditions'].append(k.to_map() if k else None)
        if self.path_conditions is not None:
            result['pathConditions'] = []
            for k in self.path_conditions:
                result['pathConditions'].append(k.to_map() if k else None)
        if self.uri_conditions is not None:
            result['uriConditions'] = []
            for k in self.uri_conditions:
                result['uriConditions'].append(k.to_map() if k else None)
        if self.uri_param_conditions is not None:
            result['uriParamConditions'] = []
            for k in self.uri_param_conditions:
                result['uriParamConditions'].append(k.to_map() if k else None)
        if self.ua_conditions is not None:
            result['uaConditions'] = []
            for k in self.ua_conditions:
                result['uaConditions'].append(k.to_map() if k else None)
        if self.method_conditions is not None:
            result['methodConditions'] = []
            for k in self.method_conditions:
                result['methodConditions'].append(k.to_map() if k else None)
        if self.referer_conditions is not None:
            result['refererConditions'] = []
            for k in self.referer_conditions:
                result['refererConditions'].append(k.to_map() if k else None)
        if self.header_conditions is not None:
            result['headerConditions'] = []
            for k in self.header_conditions:
                result['headerConditions'].append(k.to_map() if k else None)
        if self.area_conditions is not None:
            result['areaConditions'] = []
            for k in self.area_conditions:
                result['areaConditions'].append(k.to_map() if k else None)
        if self.status_code_conditions is not None:
            result['statusCodeConditions'] = []
            for k in self.status_code_conditions:
                result['statusCodeConditions'].append(k.to_map() if k else None)
        if self.scheme_conditions is not None:
            result['schemeConditions'] = []
            for k in self.scheme_conditions:
                result['schemeConditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipOrIpsConditions') is not None:
            self.ip_or_ips_conditions = []
            for k in m.get('ipOrIpsConditions'):
                temp_model = UpdateRateLimitingRuleIpOrIpsCondition()
                self.ip_or_ips_conditions.append(temp_model.from_map(k))
        if m.get('pathConditions') is not None:
            self.path_conditions = []
            for k in m.get('pathConditions'):
                temp_model = UpdateRateLimitingRulePathCondition()
                self.path_conditions.append(temp_model.from_map(k))
        if m.get('uriConditions') is not None:
            self.uri_conditions = []
            for k in m.get('uriConditions'):
                temp_model = UpdateRateLimitingRuleUriCondition()
                self.uri_conditions.append(temp_model.from_map(k))
        if m.get('uriParamConditions') is not None:
            self.uri_param_conditions = []
            for k in m.get('uriParamConditions'):
                temp_model = UpdateRateLimitingRuleUriParamCondition()
                self.uri_param_conditions.append(temp_model.from_map(k))
        if m.get('uaConditions') is not None:
            self.ua_conditions = []
            for k in m.get('uaConditions'):
                temp_model = UpdateRateLimitingRuleUaCondition()
                self.ua_conditions.append(temp_model.from_map(k))
        if m.get('methodConditions') is not None:
            self.method_conditions = []
            for k in m.get('methodConditions'):
                temp_model = UpdateRateLimitingRuleRequestMethodCondition()
                self.method_conditions.append(temp_model.from_map(k))
        if m.get('refererConditions') is not None:
            self.referer_conditions = []
            for k in m.get('refererConditions'):
                temp_model = UpdateRateLimitingRuleRefererCondition()
                self.referer_conditions.append(temp_model.from_map(k))
        if m.get('headerConditions') is not None:
            self.header_conditions = []
            for k in m.get('headerConditions'):
                temp_model = UpdateRateLimitingRuleHeaderCondition()
                self.header_conditions.append(temp_model.from_map(k))
        if m.get('areaConditions') is not None:
            self.area_conditions = []
            for k in m.get('areaConditions'):
                temp_model = UpdateRateLimitingRuleAreaCondition()
                self.area_conditions.append(temp_model.from_map(k))
        if m.get('statusCodeConditions') is not None:
            self.status_code_conditions = []
            for k in m.get('statusCodeConditions'):
                temp_model = UpdateRateLimitingRuleStatusCodeCondition()
                self.status_code_conditions.append(temp_model.from_map(k))
        if m.get('schemeConditions') is not None:
            self.scheme_conditions = []
            for k in m.get('schemeConditions'):
                temp_model = UpdateRateLimitingRuleSchemeCondition()
                self.scheme_conditions.append(temp_model.from_map(k))
        return self


class UpdateRateLimitingRuleRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        rule_name: str = None,
        description: str = None,
        scene: str = None,
        statistical_item: str = None,
        statistics_key: str = None,
        statistical_period: int = None,
        trigger_threshold: int = None,
        intercept_time: int = None,
        effective_status: str = None,
        rate_limit_effective: UpdateRateLimitingRuleRateLimitEffective = None,
        asset_api_id: str = None,
        action: str = None,
        rate_limit_rule_condition: UpdateRateLimitingRuleRateLimitRuleCondition = None,
    ):
        # {'en':'Rule ID.', 'zh_CN':'规则ID。'}
        self.id = id
        # {'en':'Rule Name, maximum 50 characters.
        # Does not support special characters and spaces.', 'zh_CN':'规则名称，最多50个字符。
        # 不支持特殊字符和空格。'}
        self.rule_name = rule_name
        # {'en':'Description, maximum 200 characters.', 'zh_CN':'规则描述，最多200个字符。'}
        self.description = description
        # {'en':'Protected target.
        # WEB:Website
        # API:API', 'zh_CN':'业务场景。
        # WEB：网站业务
        # API：API业务'}
        self.scene = scene
        # {'en':'Client identifier.
        # IP:Client IP
        # IP_UA:Client IP and User-Agent
        # COOKIE:Cookie
        # IP_COOKIE:Client IP and Cookie
        # HEADER:Request Header
        # When there is a status code in the matching condition,this client identifier is not supported.
        # IP_HEADER:Client IP and Request Header
        # When there is a status code in the matching condition,this client identifier is not supported .', 'zh_CN':'统计粒度。
        # IP：客户端IP
        # IP_UA：客户端IP和User-Agent
        # COOKIE：Cookie
        # IP_COOKIE：客户端IP和Cookie
        # HEADER：请求头，当匹配条件中存在状态码时不支持此统计粒度
        # IP_HEADER：客户端IP和请求头，当匹配条件中存在状态码时不支持此统计粒度'}
        self.statistical_item = statistical_item
        # {'en':'Statistical key value.
        # When the client identifier is cookie/header value, the corresponding key value needs to be entered.', 'zh_CN':'统计key值。
        # 当统计粒度cookie/header值，需要输入对应的key值。'}
        self.statistics_key = statistics_key
        # {'en':'Statistics period, unit: seconds, the range is 1 - 3600.', 'zh_CN':'统计周期，单位：秒，范围为 1 - 3600。'}
        self.statistical_period = statistical_period
        # {'en':'Trigger threshold, unit: times.', 'zh_CN':'触发阈值，单位：次。'}
        self.trigger_threshold = trigger_threshold
        # {'en':'Action duration, unit: seconds, the range is 10 - 604800.', 'zh_CN':'处理动作持续时间，单位：秒，范围为 10 - 604800。'}
        self.intercept_time = intercept_time
        # {'en':'Cycle effective status.
        # PERMANENT:All time
        # WITHOUT:Excluded time
        # WITHIN:Selected time', 'zh_CN':'周期生效状态。
        # PERMANENT：永久生效
        # WITHOUT：周期内不生效
        # WITHIN：周期内生效'}
        self.effective_status = effective_status
        # {'en':'Effective time period.
        # When the effective status is effective within the cycle or not effective within the cycle, this field must have a value.', 'zh_CN':'规则生效周期。
        # 生效状态为周期内生效或周期内不生效时，此字段必须有值。'}
        self.rate_limit_effective = rate_limit_effective
        # {'en':'API ID under API business, multiple separated by ; sign.
        # When the protected target is API, this field is required.', 'zh_CN':'API业务下的API ID，多个用 ; 隔开。
        # 当业务场景为API业务时此字段必填。'}
        self.asset_api_id = asset_api_id
        # {'en':'Action.
        # NO_USE:Not Used
        # LOG:Log
        # COOKIE:Cookie verification
        # JS_CHECK:Javascript verification
        # DELAY:Delay
        # BLOCK:Deny
        # RESET:Reset Connection
        # Custom response ID:Custom response ID
        # When there is a status code in the matching condition, the supported actions are Log, Deny, NO_USE, and Reset, Connection.', 'zh_CN':'处理动作。
        # NO_USE：不使用
        # LOG：监控
        # COOKIE：Cookie校验
        # JS_CHECK：JavaScript校验
        # DELAY：延迟响应
        # BLOCK：拦截
        # RESET：断开连接
        # 自定义响应ID：自定义响应ID
        # 当匹配条件中存在状态码时，支持处理动作为监控、拦截、不使用、断开连接。'}
        self.action = action
        # {'en':'Matching conditions.', 'zh_CN':'匹配条件。'}
        self.rate_limit_rule_condition = rate_limit_rule_condition

    def validate(self):
        self.validate_required(self.id, 'id')
        if self.rate_limit_effective:
            self.rate_limit_effective.validate()
        if self.rate_limit_rule_condition:
            self.rate_limit_rule_condition.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.description is not None:
            result['description'] = self.description
        if self.scene is not None:
            result['scene'] = self.scene
        if self.statistical_item is not None:
            result['statisticalItem'] = self.statistical_item
        if self.statistics_key is not None:
            result['statisticsKey'] = self.statistics_key
        if self.statistical_period is not None:
            result['statisticalPeriod'] = self.statistical_period
        if self.trigger_threshold is not None:
            result['triggerThreshold'] = self.trigger_threshold
        if self.intercept_time is not None:
            result['interceptTime'] = self.intercept_time
        if self.effective_status is not None:
            result['effectiveStatus'] = self.effective_status
        if self.rate_limit_effective is not None:
            result['rateLimitEffective'] = self.rate_limit_effective.to_map()
        if self.asset_api_id is not None:
            result['assetApiId'] = self.asset_api_id
        if self.action is not None:
            result['action'] = self.action
        if self.rate_limit_rule_condition is not None:
            result['rateLimitRuleCondition'] = self.rate_limit_rule_condition.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('statisticalItem') is not None:
            self.statistical_item = m.get('statisticalItem')
        if m.get('statisticsKey') is not None:
            self.statistics_key = m.get('statisticsKey')
        if m.get('statisticalPeriod') is not None:
            self.statistical_period = m.get('statisticalPeriod')
        if m.get('triggerThreshold') is not None:
            self.trigger_threshold = m.get('triggerThreshold')
        if m.get('interceptTime') is not None:
            self.intercept_time = m.get('interceptTime')
        if m.get('effectiveStatus') is not None:
            self.effective_status = m.get('effectiveStatus')
        if m.get('rateLimitEffective') is not None:
            temp_model = UpdateRateLimitingRuleRateLimitEffective()
            self.rate_limit_effective = temp_model.from_map(m['rateLimitEffective'])
        if m.get('assetApiId') is not None:
            self.asset_api_id = m.get('assetApiId')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('rateLimitRuleCondition') is not None:
            temp_model = UpdateRateLimitingRuleRateLimitRuleCondition()
            self.rate_limit_rule_condition = temp_model.from_map(m['rateLimitRuleCondition'])
        return self


class UpdateRateLimitingRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateRateLimitingRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateRateLimitingRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateRateLimitingRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateRateLimitingRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpgradeWAFRulesetRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {'en':'Hostname list.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class UpgradeWAFRulesetResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpgradeWAFRulesetPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpgradeWAFRulesetParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpgradeWAFRulesetRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpgradeWAFRulesetResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListGeoBlockSettingsRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {'en':'Hostname list.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class ListGeoBlockSettingsGeoBlock(TeaModel):
    def __init__(
        self,
        domain: str = None,
        block_conditions: List[str] = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'The blocked countries and areas.', 'zh_CN':'已拦截的国家和地区。','dictionary':'belong=WAAP-MS-Ext|dict=waap_areaCityAndCountry'}
        self.block_conditions = block_conditions

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.block_conditions, 'block_conditions')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.block_conditions is not None:
            result['blockConditions'] = self.block_conditions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('blockConditions') is not None:
            self.block_conditions = m.get('blockConditions')
        return self


class ListGeoBlockSettingsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListGeoBlockSettingsGeoBlock] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListGeoBlockSettingsGeoBlock()
                self.data.append(temp_model.from_map(k))
        return self


class ListGeoBlockSettingsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListGeoBlockSettingsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListGeoBlockSettingsRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListGeoBlockSettingsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateDomainBaseInfoDTO(TeaModel):
    def __init__(
        self,
        domain: str = None,
        l_7ddos_switch: str = None,
        inner_switch: str = None,
        ai_switch: str = None,
        protect_mode: str = None,
        ai_action: str = None,
    ):
        # {"en":"domain.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"Layer 7 HTTP DDoS protection switch, on: 'ON', off: 'OFF'", "zh_CN":"7层HTTP DDoS防护开关，开启：'ON'，关闭：'OFF'"}
        self.l_7ddos_switch = l_7ddos_switch
        # {"en":"Built in protective switch, on: 'ON', off: 'OFF'", "zh_CN":"内置防护开关，开启：'ON'，关闭：'OFF'"}
        self.inner_switch = inner_switch
        # {"en":"Is AI intelligent protection enabled? On: 'ON', Off: 'OFF'", "zh_CN":"是否启用AI智能防护, 开启：'ON'，关闭：'OFF'"}
        self.ai_switch = ai_switch
        # {"en":"Protection mode, under attack!: 'INDER_ATTACK', Smart Hosting: 'AI-DEPOSIT'", "zh_CN":"防护模式, 正在被攻击！: 'UNDER_ATTACK',   智能托管: 'AI_DEPOSIT'"}
        self.protect_mode = protect_mode
        # {"en":"AI rule action, intercept: 'BLOCK', monitor: 'LOG',DDoS Managed Challenge: 'RR'", "zh_CN":"ai规则动作，拦截:'BLOCK'，监控：'LOG',DDoS托管：'RR'"}
        self.ai_action = ai_action

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.l_7ddos_switch is not None:
            result['l7DdosSwitch'] = self.l_7ddos_switch
        if self.inner_switch is not None:
            result['innerSwitch'] = self.inner_switch
        if self.ai_switch is not None:
            result['aiSwitch'] = self.ai_switch
        if self.protect_mode is not None:
            result['protectMode'] = self.protect_mode
        if self.ai_action is not None:
            result['aiAction'] = self.ai_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('l7DdosSwitch') is not None:
            self.l_7ddos_switch = m.get('l7DdosSwitch')
        if m.get('innerSwitch') is not None:
            self.inner_switch = m.get('innerSwitch')
        if m.get('aiSwitch') is not None:
            self.ai_switch = m.get('aiSwitch')
        if m.get('protectMode') is not None:
            self.protect_mode = m.get('protectMode')
        if m.get('aiAction') is not None:
            self.ai_action = m.get('aiAction')
        return self


class UpdateDomainBaseInfoRequest(TeaModel):
    def __init__(
        self,
        data: List[UpdateDomainBaseInfoDTO] = None,
    ):
        # {"en":"data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = UpdateDomainBaseInfoDTO()
                self.data.append(temp_model.from_map(k))
        return self


class UpdateDomainBaseInfoResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {"en":"code", "zh_CN":"返回code"}
        self.code = code
        # {"en":"msg", "zh_CN":"msg"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateDomainBaseInfoPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainBaseInfoParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainBaseInfoRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateDomainBaseInfoResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteCustomRuleRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_names: List[str] = None,
    ):
        # {"en":"domain", "zh_CN":"域名"}
        self.domain = domain
        # {"en":"rule name list", "zh_CN":"规则名称列表"}
        self.rule_names = rule_names

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_names, 'rule_names')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_names is not None:
            result['ruleNames'] = self.rule_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleNames') is not None:
            self.rule_names = m.get('ruleNames')
        return self


class DeleteCustomRuleResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
    ):
        # {"en":"response code", "zh_CN":"返回状态码"}
        self.code = code
        # {"en":"response msg", "zh_CN":"返回信息"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class DeleteCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteCustomRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class AddWorkflowRuleProtectionPathDTO(TeaModel):
    def __init__(
        self,
        protection_name: str = None,
        protection_type: str = None,
        protection_path: str = None,
    ):
        # {'en':'Protection type.
        # Path: path 
        # URI:URI', 'zh_CN':'防护路径。
        # Path：路径
        # URI：URI'}
        self.protection_name = protection_name
        # {'en':'Match type.
        # EQUAL: equals 
        # REGEX: regex match
        # CONTAIN: contains', 'zh_CN':'防护路径。
        # EQUAL：相等
        # REGEX：正则匹配
        # CONTAIN：相等'}
        self.protection_type = protection_type
        # {'en':'Protection path.', 'zh_CN':'防护路径。'}
        self.protection_path = protection_path

    def validate(self):
        self.validate_required(self.protection_name, 'protection_name')
        self.validate_required(self.protection_type, 'protection_type')
        self.validate_required(self.protection_path, 'protection_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.protection_name is not None:
            result['protectionName'] = self.protection_name
        if self.protection_type is not None:
            result['protectionType'] = self.protection_type
        if self.protection_path is not None:
            result['protectionPath'] = self.protection_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('protectionName') is not None:
            self.protection_name = m.get('protectionName')
        if m.get('protectionType') is not None:
            self.protection_type = m.get('protectionType')
        if m.get('protectionPath') is not None:
            self.protection_path = m.get('protectionPath')
        return self


class AddWorkflowRuleWebRuleConditionDTO(TeaModel):
    def __init__(
        self,
        request_judge: str = None,
        request_type: str = None,
        request_total_type: str = None,
        judge_type: str = None,
        judge_value: int = None,
    ):
        # {'en':'Request determination. 
        #  NUM: Request quantity determination
        #  PERCENT: Request proportion determination', 'zh_CN':'请求判定。
        #  NUM：请求数量判定
        #  PERCENT：请求比例判定'}
        self.request_judge = request_judge
        # {'en':'Request type. 
        #  TOTAL: Total requests
        #  POST: POST requests
        #  GET: GET requests
        #  PIC: Picture resource requests
        #  CSS: CSS resource requests
        #  JS: JS resource requests
        #  OTHER: Other resource requests', 'zh_CN':'请求类型。
        #  TOTAL：总请求数
        #  POST：POST请求数
        #  GET：GET请求数
        #  PIC ：图片资源请求数
        #  CSS：CSS资源请求数
        #  JS：JS资源请求数
        #  OTHER：其他资源请求数'}
        self.request_type = request_type
        # {'en':'Denominator request type, supported when requestJudge is used to PERCENT. 
        #  TOTAL: total number of requests
        #  POST: number of POST requests
        #  GET: number of GET requests
        #  PIC: number of image resource requests
        #  CSS: number of CSS resource requests
        #  JS: JS resource request Number
        #  OTHER: Number of other resource requests', 'zh_CN':'分母请求类型，requestJudge为请求比例判定的才填写。
        #  TOTAL：总请求数
        #  POST：POST请求数
        #  GET：GET请求数
        #  PIC：图片资源请求数
        #  CSS：CSS资源请求数
        #  JS：JS资源请求数
        #  OTHER：其他资源请求数'}
        self.request_total_type = request_total_type
        # {'en':'Determine comparison conditions. 
        #  GT: greater than
        #  LT: less than
        #  GTE: greater than or equal to
        #  LTE: less than or equal to', 'zh_CN':'判定比较条件。
        #  GT：大于
        #  LT：小于
        #  GTE：大于等于
        #  LTE：小于等于'}
        self.judge_type = judge_type
        # {'en':'Determine comparison value.', 'zh_CN':'判定比较值。'}
        self.judge_value = judge_value

    def validate(self):
        self.validate_required(self.request_judge, 'request_judge')
        self.validate_required(self.request_type, 'request_type')
        self.validate_required(self.judge_type, 'judge_type')
        self.validate_required(self.judge_value, 'judge_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_judge is not None:
            result['requestJudge'] = self.request_judge
        if self.request_type is not None:
            result['requestType'] = self.request_type
        if self.request_total_type is not None:
            result['requestTotalType'] = self.request_total_type
        if self.judge_type is not None:
            result['judgeType'] = self.judge_type
        if self.judge_value is not None:
            result['judgeValue'] = self.judge_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestJudge') is not None:
            self.request_judge = m.get('requestJudge')
        if m.get('requestType') is not None:
            self.request_type = m.get('requestType')
        if m.get('requestTotalType') is not None:
            self.request_total_type = m.get('requestTotalType')
        if m.get('judgeType') is not None:
            self.judge_type = m.get('judgeType')
        if m.get('judgeValue') is not None:
            self.judge_value = m.get('judgeValue')
        return self


class AddWorkflowRuleApiRuleConditionDTO(TeaModel):
    def __init__(
        self,
        request_type: str = None,
        judge_type: str = None,
        judge_value: int = None,
        customize_match_name: str = None,
        customize_path_match: str = None,
        customize_path: str = None,
    ):
        # {'en':'Request type. 
        #  TOTAL: total requests,maximum configuration is 1
        #  OTHER: number of other URL requests,maximum configuration is 1
        #  CUSTOMIZE: number of custom URL requests,configure at least one and a maximum of 20', 'zh_CN':'请求类型。
        #  TOTAL：总请求数，最多配置1条
        #  OTHER：其他URL请求数，最多配置1条
        #  CUSTOMIZE：自定义URL请求数，至少配置一条，最多配置20条'}
        self.request_type = request_type
        # {'en':'Determine comparison conditions. 
        #  GT: greater than
        #  LT: less than
        #  GTE: greater than or equal to
        #  LTE: less than or equal to', 'zh_CN':'判定比较条件。
        #  GT：大于
        #  LT：小于
        #  GTE：大于等于
        #  LTE：小于等于'}
        self.judge_type = judge_type
        # {'en':'Determine comparison value.', 'zh_CN':'判定比较值。'}
        self.judge_value = judge_value
        # {'en':'Customized url match type. Fill in when the request type is custom. 
        #  Path: path
        #  URI: URI', 'zh_CN':'自定义url匹配类型。请求类型为自定义时填写。
        #  Path：路径
        #  URI：URI'}
        self.customize_match_name = customize_match_name
        # {'en':'Customized url matching method. 
        #  DICT: complete matching
        #  REGEX: regular matching
        #  CONTAIN: contains ', 'zh_CN':'自定义url匹配方式。
        #  DICT：完整匹配
        #  REGEX：正则匹配
        # CONTAIN：相等'}
        self.customize_path_match = customize_path_match
        # {'en':'Custom url, Fill in when the request type is custom.', 'zh_CN':'自定义url，请求类型为自定义时填写。'}
        self.customize_path = customize_path

    def validate(self):
        self.validate_required(self.request_type, 'request_type')
        self.validate_required(self.judge_type, 'judge_type')
        self.validate_required(self.judge_value, 'judge_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_type is not None:
            result['requestType'] = self.request_type
        if self.judge_type is not None:
            result['judgeType'] = self.judge_type
        if self.judge_value is not None:
            result['judgeValue'] = self.judge_value
        if self.customize_match_name is not None:
            result['customizeMatchName'] = self.customize_match_name
        if self.customize_path_match is not None:
            result['customizePathMatch'] = self.customize_path_match
        if self.customize_path is not None:
            result['customizePath'] = self.customize_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestType') is not None:
            self.request_type = m.get('requestType')
        if m.get('judgeType') is not None:
            self.judge_type = m.get('judgeType')
        if m.get('judgeValue') is not None:
            self.judge_value = m.get('judgeValue')
        if m.get('customizeMatchName') is not None:
            self.customize_match_name = m.get('customizeMatchName')
        if m.get('customizePathMatch') is not None:
            self.customize_path_match = m.get('customizePathMatch')
        if m.get('customizePath') is not None:
            self.customize_path = m.get('customizePath')
        return self


class AddWorkflowRuleRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_name: str = None,
        rule_description: str = None,
        act: str = None,
        statistical_period: int = None,
        statistical_item: str = None,
        protection_scope: List[AddWorkflowRuleProtectionPathDTO] = None,
        web_rule_condition: List[AddWorkflowRuleWebRuleConditionDTO] = None,
        api_rule_condition: List[AddWorkflowRuleApiRuleConditionDTO] = None,
        mode: str = None,
        wl_uri: List[str] = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Rule name.Does not support special characters and spaces, maximum 50 characters.', 'zh_CN':'规则名称。不支持特殊字符和空格，最多50个字符。'}
        self.rule_name = rule_name
        # {'en':'Rule description.', 'zh_CN':'规则描述。'}
        self.rule_description = rule_description
        # {'en':'Process actions. 
        #  NO_USE: not used
        #  BLOCK: block
        #  LOG: log
        # Custom response ID: Custom response ID', 'zh_CN':'处理动作。
        #  NO_USE：不使用
        #  BLOCK：拦截
        #  LOG：监控 
        #  自定义响应ID:自定义响应ID'}
        self.act = act
        # {'en':'Statistical period, unit is seconds.', 'zh_CN':'统计周期，单位是秒。'}
        self.statistical_period = statistical_period
        # {'en':'Statistical granularity. 
        #  IP: Client IP
        #  IP-UA: Client IP and User-Agent', 'zh_CN':'统计粒度。
        #  IP：客户端IP
        #  IP-UA：客户端IP和User-Agent'}
        self.statistical_item = statistical_item
        # {'en':'Protection scope, supports multiple.', 'zh_CN':'防护范围，支持多个。'}
        self.protection_scope = protection_scope
        # {'en':'Web scene trigger conditions, Need to fill in when mode is WEB.', 'zh_CN':'Web场景触发条件，mode为WEB时需要传。'}
        self.web_rule_condition = web_rule_condition
        # {'en':'API scene trigger conditions. Need to fill in when mode is API.', 'zh_CN':'API场景触发条件，mode为API时需要传。'}
        self.api_rule_condition = api_rule_condition
        # {'en':'Protected target. 
        #  WEB: WEB
        #  API: API', 'zh_CN':'应用场景。
        #  WEB：WEB场景
        #  API：API场景'}
        self.mode = mode
        # {'en':'Exception path is only supported in the Web scenario, but not in the API scenario.', 'zh_CN':'例外路径，只有Web场景时支持，API场景时不支持。'}
        self.wl_uri = wl_uri

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.act, 'act')
        self.validate_required(self.statistical_period, 'statistical_period')
        self.validate_required(self.statistical_item, 'statistical_item')
        self.validate_required(self.protection_scope, 'protection_scope')
        if self.protection_scope:
            for k in self.protection_scope:
                if k:
                    k.validate()
        if self.web_rule_condition:
            for k in self.web_rule_condition:
                if k:
                    k.validate()
        if self.api_rule_condition:
            for k in self.api_rule_condition:
                if k:
                    k.validate()
        self.validate_required(self.mode, 'mode')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.rule_description is not None:
            result['ruleDescription'] = self.rule_description
        if self.act is not None:
            result['act'] = self.act
        if self.statistical_period is not None:
            result['statisticalPeriod'] = self.statistical_period
        if self.statistical_item is not None:
            result['statisticalItem'] = self.statistical_item
        if self.protection_scope is not None:
            result['protectionScope'] = []
            for k in self.protection_scope:
                result['protectionScope'].append(k.to_map() if k else None)
        if self.web_rule_condition is not None:
            result['webRuleCondition'] = []
            for k in self.web_rule_condition:
                result['webRuleCondition'].append(k.to_map() if k else None)
        if self.api_rule_condition is not None:
            result['apiRuleCondition'] = []
            for k in self.api_rule_condition:
                result['apiRuleCondition'].append(k.to_map() if k else None)
        if self.mode is not None:
            result['mode'] = self.mode
        if self.wl_uri is not None:
            result['wlUri'] = self.wl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('ruleDescription') is not None:
            self.rule_description = m.get('ruleDescription')
        if m.get('act') is not None:
            self.act = m.get('act')
        if m.get('statisticalPeriod') is not None:
            self.statistical_period = m.get('statisticalPeriod')
        if m.get('statisticalItem') is not None:
            self.statistical_item = m.get('statisticalItem')
        if m.get('protectionScope') is not None:
            self.protection_scope = []
            for k in m.get('protectionScope'):
                temp_model = AddWorkflowRuleProtectionPathDTO()
                self.protection_scope.append(temp_model.from_map(k))
        if m.get('webRuleCondition') is not None:
            self.web_rule_condition = []
            for k in m.get('webRuleCondition'):
                temp_model = AddWorkflowRuleWebRuleConditionDTO()
                self.web_rule_condition.append(temp_model.from_map(k))
        if m.get('apiRuleCondition') is not None:
            self.api_rule_condition = []
            for k in m.get('apiRuleCondition'):
                temp_model = AddWorkflowRuleApiRuleConditionDTO()
                self.api_rule_condition.append(temp_model.from_map(k))
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('wlUri') is not None:
            self.wl_uri = m.get('wlUri')
        return self


class AddWorkflowRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Rule ID.', 'zh_CN':'规则ID。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class AddWorkflowRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AddWorkflowRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AddWorkflowRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class AddWorkflowRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateWorkflowRuleProtectionPathDTO(TeaModel):
    def __init__(
        self,
        protection_name: str = None,
        protection_type: str = None,
        protection_path: str = None,
    ):
        # {'en':'Protection type.
        # Path: path 
        # URI:URI', 'zh_CN':'防护路径。
        # Path：路径
        # URI：URI'}
        self.protection_name = protection_name
        # {'en':'Match type.
        # EQUAL: equals 
        # REGEX: regex match
        # CONTAIN: contains', 'zh_CN':'防护路径。
        # EQUAL：相等
        # REGEX：正则匹配
        # CONTAIN：相等'}
        self.protection_type = protection_type
        # {'en':'Protection path.', 'zh_CN':'防护路径。'}
        self.protection_path = protection_path

    def validate(self):
        self.validate_required(self.protection_name, 'protection_name')
        self.validate_required(self.protection_type, 'protection_type')
        self.validate_required(self.protection_path, 'protection_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.protection_name is not None:
            result['protectionName'] = self.protection_name
        if self.protection_type is not None:
            result['protectionType'] = self.protection_type
        if self.protection_path is not None:
            result['protectionPath'] = self.protection_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('protectionName') is not None:
            self.protection_name = m.get('protectionName')
        if m.get('protectionType') is not None:
            self.protection_type = m.get('protectionType')
        if m.get('protectionPath') is not None:
            self.protection_path = m.get('protectionPath')
        return self


class UpdateWorkflowRuleWebRuleConditionDTO(TeaModel):
    def __init__(
        self,
        request_judge: str = None,
        request_type: str = None,
        request_total_type: str = None,
        judge_type: str = None,
        judge_value: int = None,
    ):
        # {'en':'Request determination. 
        #  NUM: Request quantity determination
        #  PERCENT: Request proportion determination', 'zh_CN':'请求判定。
        #  NUM：请求数量判定
        #  PERCENT：请求比例判定'}
        self.request_judge = request_judge
        # {'en':'Request type. 
        #  TOTAL: Total requests
        #  POST: POST requests
        #  GET: GET requests
        #  PIC: Picture resource requests
        #  CSS: CSS resource requests
        #  JS: JS resource requests
        #  OTHER: Other resource requests', 'zh_CN':'请求类型。
        #  TOTAL：总请求数
        #  POST：POST请求数
        #  GET：GET请求数
        #  PIC ：图片资源请求数
        #  CSS：CSS资源请求数
        #  JS：JS资源请求数
        #  OTHER：其他资源请求数'}
        self.request_type = request_type
        # {'en':'Denominator request type (supported when requestJudge is used to PERCENT). 
        #  TOTAL: total number of requests
        #  POST: number of POST requests
        #  GET: number of GET requests
        #  PIC: number of image resource requests
        #  CSS: number of CSS resource requests
        #  JS: JS resource request Number
        #  OTHER: Number of other resource requests', 'zh_CN':'分母请求类型（requestJudge为请求比例判定的才填写）。
        #  TOTAL：总请求数
        #  POST：POST请求数
        #  GET：GET请求数
        #  PIC：图片资源请求数
        #  CSS：CSS资源请求数
        #  JS：JS资源请求数
        #  OTHER：其他资源请求数'}
        self.request_total_type = request_total_type
        # {'en':'Determine comparison conditions. 
        #  GT: greater than
        #  LT: less than
        #  GTE: greater than or equal to
        #  LTE: less than or equal to', 'zh_CN':'判定比较条件。
        #  GT：大于
        #  LT：小于
        #  GTE：大于等于
        #  LTE：小于等于'}
        self.judge_type = judge_type
        # {'en':'Determine comparison value.', 'zh_CN':'判定比较值。'}
        self.judge_value = judge_value

    def validate(self):
        self.validate_required(self.request_judge, 'request_judge')
        self.validate_required(self.request_type, 'request_type')
        self.validate_required(self.judge_type, 'judge_type')
        self.validate_required(self.judge_value, 'judge_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_judge is not None:
            result['requestJudge'] = self.request_judge
        if self.request_type is not None:
            result['requestType'] = self.request_type
        if self.request_total_type is not None:
            result['requestTotalType'] = self.request_total_type
        if self.judge_type is not None:
            result['judgeType'] = self.judge_type
        if self.judge_value is not None:
            result['judgeValue'] = self.judge_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestJudge') is not None:
            self.request_judge = m.get('requestJudge')
        if m.get('requestType') is not None:
            self.request_type = m.get('requestType')
        if m.get('requestTotalType') is not None:
            self.request_total_type = m.get('requestTotalType')
        if m.get('judgeType') is not None:
            self.judge_type = m.get('judgeType')
        if m.get('judgeValue') is not None:
            self.judge_value = m.get('judgeValue')
        return self


class UpdateWorkflowRuleApiRuleConditionDTO(TeaModel):
    def __init__(
        self,
        request_type: str = None,
        judge_type: str = None,
        judge_value: int = None,
        customize_match_name: str = None,
        customize_path_match: str = None,
        customize_path: str = None,
    ):
        # {'en':'Request type. 
        #  TOTAL: total requests,maximum configuration is 1
        #  OTHER: number of other URL requests,maximum configuration is 1
        #  CUSTOMIZE: number of custom URL requests,configure at least one and a maximum of 20', 'zh_CN':'请求类型。
        #  TOTAL：总请求数，最多配置1条
        #  OTHER：其他URL请求数，最多配置1条
        #  CUSTOMIZE：自定义URL请求数，至少配置一条，最多配置20条'}
        self.request_type = request_type
        # {'en':'Determine comparison conditions. 
        #  GT: greater than
        #  LT: less than
        #  GTE: greater than or equal to
        #  LTE: less than or equal to', 'zh_CN':'判定比较条件。
        #  GT：大于
        #  LT：小于
        #  GTE：大于等于
        #  LTE：小于等于'}
        self.judge_type = judge_type
        # {'en':'Determine comparison value.', 'zh_CN':'判定比较值。'}
        self.judge_value = judge_value
        # {'en':'Customized url match type. Fill in when the request type is custom. 
        #  Path: path
        #  URI: URI', 'zh_CN':'自定义url匹配类型。请求类型为自定义时填写。
        #  Path：路径
        #  URI：URI'}
        self.customize_match_name = customize_match_name
        # {'en':'Customized url matching method. 
        #  DICT: complete matching
        #  REGEX: regular matching
        #  CONTAIN: contains ', 'zh_CN':'自定义url匹配方式。
        #  DICT：完整匹配
        #  REGEX：正则匹配
        # CONTAIN：相等'}
        self.customize_path_match = customize_path_match
        # {'en':'Custom url, Fill in when the request type is custom.', 'zh_CN':'自定义url，请求类型为自定义时填写。'}
        self.customize_path = customize_path

    def validate(self):
        self.validate_required(self.request_type, 'request_type')
        self.validate_required(self.judge_type, 'judge_type')
        self.validate_required(self.judge_value, 'judge_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_type is not None:
            result['requestType'] = self.request_type
        if self.judge_type is not None:
            result['judgeType'] = self.judge_type
        if self.judge_value is not None:
            result['judgeValue'] = self.judge_value
        if self.customize_match_name is not None:
            result['customizeMatchName'] = self.customize_match_name
        if self.customize_path_match is not None:
            result['customizePathMatch'] = self.customize_path_match
        if self.customize_path is not None:
            result['customizePath'] = self.customize_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestType') is not None:
            self.request_type = m.get('requestType')
        if m.get('judgeType') is not None:
            self.judge_type = m.get('judgeType')
        if m.get('judgeValue') is not None:
            self.judge_value = m.get('judgeValue')
        if m.get('customizeMatchName') is not None:
            self.customize_match_name = m.get('customizeMatchName')
        if m.get('customizePathMatch') is not None:
            self.customize_path_match = m.get('customizePathMatch')
        if m.get('customizePath') is not None:
            self.customize_path = m.get('customizePath')
        return self


class UpdateWorkflowRuleRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        rule_name: str = None,
        rule_description: str = None,
        act: str = None,
        statistical_period: int = None,
        statistical_item: str = None,
        protection_scope: List[UpdateWorkflowRuleProtectionPathDTO] = None,
        web_rule_condition: List[UpdateWorkflowRuleWebRuleConditionDTO] = None,
        api_rule_condition: List[UpdateWorkflowRuleApiRuleConditionDTO] = None,
        mode: str = None,
        wl_uri: List[str] = None,
    ):
        # {'en':'Rule ID.', 'zh_CN':'规则ID。'}
        self.id = id
        # {'en':'Rule name.Does not support special characters and spaces,  maximum 50 characters.', 'zh_CN':'规则名称。不支持特殊字符和空格，最多50个字符。'}
        self.rule_name = rule_name
        # {'en':'Rule description.', 'zh_CN':'规则描述。'}
        self.rule_description = rule_description
        # {'en':'Process actions. 
        #  NO_USE: not used
        #  BLOCK: block
        #  LOG: log
        #  custom action primary key id', 'zh_CN':'处理动作。
        #  NO_USE：不使用
        #  BLOCK：拦截
        #  LOG：监控 
        #  自定义处理动作主键id'}
        self.act = act
        # {'en':'Statistical period, unit is seconds.', 'zh_CN':'统计周期，单位是秒。'}
        self.statistical_period = statistical_period
        # {'en':'Statistical granularity. 
        #  IP: Client IP
        #  IP-UA: Client IP and User-Agent', 'zh_CN':'统计粒度。
        #  IP：客户端IP
        #  IP-UA：客户端IP和User-Agent'}
        self.statistical_item = statistical_item
        # {'en':'Protection scope, supports multiple.', 'zh_CN':'防护范围，支持多个。'}
        self.protection_scope = protection_scope
        # {'en':'Web scene trigger conditions, Need to fill in when mode is WEB.', 'zh_CN':'Web场景触发条件，mode为WEB时需要传。'}
        self.web_rule_condition = web_rule_condition
        # {'en':'API scene trigger conditions. Need to fill in when mode is API.', 'zh_CN':'API场景触发条件，mode为API时需要传。'}
        self.api_rule_condition = api_rule_condition
        # {'en':'Protected target. 
        #  WEB: WEB
        #  API: API', 'zh_CN':'应用场景。
        #  WEB：WEB场景
        #  API：API场景'}
        self.mode = mode
        # {'en':'Exception path is only supported in the Web scenario, but not in the API scenario.', 'zh_CN':'例外路径，只有Web场景时支持，API场景时不支持。'}
        self.wl_uri = wl_uri

    def validate(self):
        self.validate_required(self.id, 'id')
        if self.protection_scope:
            for k in self.protection_scope:
                if k:
                    k.validate()
        if self.web_rule_condition:
            for k in self.web_rule_condition:
                if k:
                    k.validate()
        if self.api_rule_condition:
            for k in self.api_rule_condition:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.rule_description is not None:
            result['ruleDescription'] = self.rule_description
        if self.act is not None:
            result['act'] = self.act
        if self.statistical_period is not None:
            result['statisticalPeriod'] = self.statistical_period
        if self.statistical_item is not None:
            result['statisticalItem'] = self.statistical_item
        if self.protection_scope is not None:
            result['protectionScope'] = []
            for k in self.protection_scope:
                result['protectionScope'].append(k.to_map() if k else None)
        if self.web_rule_condition is not None:
            result['webRuleCondition'] = []
            for k in self.web_rule_condition:
                result['webRuleCondition'].append(k.to_map() if k else None)
        if self.api_rule_condition is not None:
            result['apiRuleCondition'] = []
            for k in self.api_rule_condition:
                result['apiRuleCondition'].append(k.to_map() if k else None)
        if self.mode is not None:
            result['mode'] = self.mode
        if self.wl_uri is not None:
            result['wlUri'] = self.wl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('ruleDescription') is not None:
            self.rule_description = m.get('ruleDescription')
        if m.get('act') is not None:
            self.act = m.get('act')
        if m.get('statisticalPeriod') is not None:
            self.statistical_period = m.get('statisticalPeriod')
        if m.get('statisticalItem') is not None:
            self.statistical_item = m.get('statisticalItem')
        if m.get('protectionScope') is not None:
            self.protection_scope = []
            for k in m.get('protectionScope'):
                temp_model = UpdateWorkflowRuleProtectionPathDTO()
                self.protection_scope.append(temp_model.from_map(k))
        if m.get('webRuleCondition') is not None:
            self.web_rule_condition = []
            for k in m.get('webRuleCondition'):
                temp_model = UpdateWorkflowRuleWebRuleConditionDTO()
                self.web_rule_condition.append(temp_model.from_map(k))
        if m.get('apiRuleCondition') is not None:
            self.api_rule_condition = []
            for k in m.get('apiRuleCondition'):
                temp_model = UpdateWorkflowRuleApiRuleConditionDTO()
                self.api_rule_condition.append(temp_model.from_map(k))
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('wlUri') is not None:
            self.wl_uri = m.get('wlUri')
        return self


class UpdateWorkflowRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateWorkflowRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateWorkflowRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateWorkflowRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateWorkflowRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetResponsePageOfDenyActionDetailRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"zh_CN":"域名。","en":"Hostname."}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class GetResponsePageOfDenyActionDetailBlockResponseDomainVo(TeaModel):
    def __init__(
        self,
        domain: str = None,
        block_response_mode: str = None,
        rate_share_customize_action_id: str = None,
        share_customize_action_name: str = None,
    ):
        # {"zh_CN":"域名。","en":"Hostname."}
        self.domain = domain
        # {"zh_CN":"拦截动作响应模式。
        #   DEFAULT：系统默认
        #   CUSTOMIZE：自定义","en":"Interception action response mode.
        #   DEFAULT:System default
        #   CUSTOMIZE:Custom"}
        self.block_response_mode = block_response_mode
        # {"zh_CN":"关联自定义响应id。","en":"Associated custom response id."}
        self.rate_share_customize_action_id = rate_share_customize_action_id
        # {"zh_CN":"关联自定义响应名称。","en":"Associate a custom response name."}
        self.share_customize_action_name = share_customize_action_name

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.block_response_mode, 'block_response_mode')
        self.validate_required(self.rate_share_customize_action_id, 'rate_share_customize_action_id')
        self.validate_required(self.share_customize_action_name, 'share_customize_action_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.block_response_mode is not None:
            result['blockResponseMode'] = self.block_response_mode
        if self.rate_share_customize_action_id is not None:
            result['rateShareCustomizeActionId'] = self.rate_share_customize_action_id
        if self.share_customize_action_name is not None:
            result['shareCustomizeActionName'] = self.share_customize_action_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('blockResponseMode') is not None:
            self.block_response_mode = m.get('blockResponseMode')
        if m.get('rateShareCustomizeActionId') is not None:
            self.rate_share_customize_action_id = m.get('rateShareCustomizeActionId')
        if m.get('shareCustomizeActionName') is not None:
            self.share_customize_action_name = m.get('shareCustomizeActionName')
        return self


class GetResponsePageOfDenyActionDetailResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: GetResponsePageOfDenyActionDetailBlockResponseDomainVo = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            temp_model = GetResponsePageOfDenyActionDetailBlockResponseDomainVo()
            self.data = temp_model.from_map(m['data'])
        return self


class GetResponsePageOfDenyActionDetailPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetResponsePageOfDenyActionDetailParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetResponsePageOfDenyActionDetailRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class GetResponsePageOfDenyActionDetailResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryFingerprintAnalysisRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"domain.", "zh_CN":"域名。"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryFingerprintAnalysisFpRows(TeaModel):
    def __init__(
        self,
        protection_scope: int = None,
        protection_method: int = None,
        protection_content: str = None,
    ):
        # {"en":"Protection scope.
        #  0:All 
        #  3:Full URI 
        #  4:Regex", "zh_CN":"防护范围。
        #   0：全站 
        #  3：完整URI 
        #  4：正则匹配"}
        self.protection_scope = protection_scope
        # {"en":"Request method for protection.
        #  0:All 
        #  1:GET 
        #  2:POST 
        #  3:GET/POST", "zh_CN":"防护的请求方法 。
        #   0：All 
        #  1：GET 
        #  2：POST 
        #  3：GET/POST"}
        self.protection_method = protection_method
        # {"en":"Content of protection path.", "zh_CN":"防护路径内容。"}
        self.protection_content = protection_content

    def validate(self):
        self.validate_required(self.protection_scope, 'protection_scope')
        self.validate_required(self.protection_method, 'protection_method')
        self.validate_required(self.protection_content, 'protection_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.protection_scope is not None:
            result['protection_scope'] = self.protection_scope
        if self.protection_method is not None:
            result['protection_method'] = self.protection_method
        if self.protection_content is not None:
            result['protection_content'] = self.protection_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('protection_scope') is not None:
            self.protection_scope = m.get('protection_scope')
        if m.get('protection_method') is not None:
            self.protection_method = m.get('protection_method')
        if m.get('protection_content') is not None:
            self.protection_content = m.get('protection_content')
        return self


class QueryFingerprintAnalysisFingerprint(TeaModel):
    def __init__(
        self,
        enable: int = None,
        analysis_frequency: int = None,
        statistical_period: int = None,
        ip_threshold: int = None,
        action_type: int = None,
        action_time: int = None,
        fp_rows: List[QueryFingerprintAnalysisFpRows] = None,
    ):
        # {"en":"Switch for user fingerprint analysis. 
        #  0:OFF 
        #  1:ON", "zh_CN":"指纹开关。 
        #  0：关闭 
        #  1：启用"}
        self.enable = enable
        # {"en":"Analysis frequency. Unit: min", "zh_CN":"分析频率。单位：分"}
        self.analysis_frequency = analysis_frequency
        # {"en":"Trigger condition - statistical period. Unit: min", "zh_CN":"触发条件-统计周期。单位：分"}
        self.statistical_period = statistical_period
        # {"en":"Number of IP.", "zh_CN":"IP个数。"}
        self.ip_threshold = ip_threshold
        # {"en":"Processing action.
        #   1:blok 
        #  2:Log 
        #  5:Reset", "zh_CN":"处理动作。
        #  1：拦截 
        #  2：监控 
        #  5：断开连接"}
        self.action_type = action_type
        # {"en":"Processing action duration. Unit:min", "zh_CN":"处理动作持续时间。单位：分"}
        self.action_time = action_time
        # {"en":"Details of protection path.", "zh_CN":"防护路径内容。"}
        self.fp_rows = fp_rows

    def validate(self):
        self.validate_required(self.enable, 'enable')
        self.validate_required(self.analysis_frequency, 'analysis_frequency')
        self.validate_required(self.statistical_period, 'statistical_period')
        self.validate_required(self.ip_threshold, 'ip_threshold')
        self.validate_required(self.action_type, 'action_type')
        self.validate_required(self.action_time, 'action_time')
        self.validate_required(self.fp_rows, 'fp_rows')
        if self.fp_rows:
            for k in self.fp_rows:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['enable'] = self.enable
        if self.analysis_frequency is not None:
            result['analysis_frequency'] = self.analysis_frequency
        if self.statistical_period is not None:
            result['statistical_period'] = self.statistical_period
        if self.ip_threshold is not None:
            result['ip_threshold'] = self.ip_threshold
        if self.action_type is not None:
            result['action_type'] = self.action_type
        if self.action_time is not None:
            result['action_time'] = self.action_time
        if self.fp_rows is not None:
            result['fp_rows'] = []
            for k in self.fp_rows:
                result['fp_rows'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('analysis_frequency') is not None:
            self.analysis_frequency = m.get('analysis_frequency')
        if m.get('statistical_period') is not None:
            self.statistical_period = m.get('statistical_period')
        if m.get('ip_threshold') is not None:
            self.ip_threshold = m.get('ip_threshold')
        if m.get('action_type') is not None:
            self.action_type = m.get('action_type')
        if m.get('action_time') is not None:
            self.action_time = m.get('action_time')
        if m.get('fp_rows') is not None:
            self.fp_rows = []
            for k in m.get('fp_rows'):
                temp_model = QueryFingerprintAnalysisFpRows()
                self.fp_rows.append(temp_model.from_map(k))
        return self


class QueryFingerprintAnalysisData(TeaModel):
    def __init__(
        self,
        edgebot_user_fingerprint_challenge: QueryFingerprintAnalysisFingerprint = None,
        edgebot_device_fingerprint_challenge: QueryFingerprintAnalysisFingerprint = None,
    ):
        # {"en":"User fingerprint analysis.", "zh_CN":"用户指纹分析。"}
        self.edgebot_user_fingerprint_challenge = edgebot_user_fingerprint_challenge
        # {"en":"Browser fingerprint analysis.", "zh_CN":"浏览器指纹分析。"}
        self.edgebot_device_fingerprint_challenge = edgebot_device_fingerprint_challenge

    def validate(self):
        self.validate_required(self.edgebot_user_fingerprint_challenge, 'edgebot_user_fingerprint_challenge')
        if self.edgebot_user_fingerprint_challenge:
            self.edgebot_user_fingerprint_challenge.validate()
        self.validate_required(self.edgebot_device_fingerprint_challenge, 'edgebot_device_fingerprint_challenge')
        if self.edgebot_device_fingerprint_challenge:
            self.edgebot_device_fingerprint_challenge.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.edgebot_user_fingerprint_challenge is not None:
            result['edgebot_user_fingerprint_challenge'] = self.edgebot_user_fingerprint_challenge.to_map()
        if self.edgebot_device_fingerprint_challenge is not None:
            result['edgebot_device_fingerprint_challenge'] = self.edgebot_device_fingerprint_challenge.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('edgebot_user_fingerprint_challenge') is not None:
            temp_model = QueryFingerprintAnalysisFingerprint()
            self.edgebot_user_fingerprint_challenge = temp_model.from_map(m['edgebot_user_fingerprint_challenge'])
        if m.get('edgebot_device_fingerprint_challenge') is not None:
            temp_model = QueryFingerprintAnalysisFingerprint()
            self.edgebot_device_fingerprint_challenge = temp_model.from_map(m['edgebot_device_fingerprint_challenge'])
        return self


class QueryFingerprintAnalysisResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryFingerprintAnalysisData = None,
    ):
        # {"en":"Status code, success is '200'.", "zh_CN":"状态码，成功为“200”。"}
        self.code = code
        # {"en":"Return message, success is 'Success'.", "zh_CN":"返回信息，成功为“Success”。"}
        self.message = message
        # {"en":"QueryFingerprintAnalysisData returned.", "zh_CN":"返回数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryFingerprintAnalysisData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryFingerprintAnalysisPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryFingerprintAnalysisParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryFingerprintAnalysisRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryFingerprintAnalysisResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteConsumerRequest(TeaModel):
    def __init__(
        self,
        ids: List[str] = None,
    ):
        # {"en":"List of Consumer ID to delete.", "zh_CN":"要删除的消费方ID数组。"}
        self.ids = ids

    def validate(self):
        self.validate_required(self.ids, 'ids')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ids') is not None:
            self.ids = m.get('ids')
        return self


class DeleteConsumerResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: List[str] = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"List of deleted consumer names.", "zh_CN":"被删除的消费方名称数组。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class DeleteConsumerPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteConsumerParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteConsumerRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteConsumerResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateAslConfigRequestDataConditions(TeaModel):
    def __init__(
        self,
        condition: str = None,
        match_type: str = None,
        condition_value: str = None,
    ):
        # {"en":"IP:0,IP_SEG:1,URI:4,URI_REGEX:5,USER_AGENT:6,USER_AGENT_REGEX:7,
        #                          AREA:8,HTTP_METHOD:9,REFERER:10,REFERER_REGEX:11,PROTOCOL:12,HTTP_HEADER:13,HTTP_HEADER_REGEX:14  
        #                          ",
        #                          'zh_CN':'IP:0,IP_SEG:1,URI:4, URI_REGEX:5, USER_AGENT:6, USER_AGENT_REGEX:7, AREA:8,HTTP_METHOD:9,
        #                          REFERER:10,REFERER_REGEX:11,PROTOCOL:12,HTTP_HEADER:13,
        #                          HTTP_HEADER_REGEX:14
        #                          '}
        self.condition = condition
        # {"en":"Not equal:0|Equal:1", "zh_CN":"不等于:0|等于:1"}
        self.match_type = match_type
        # {"en":"Condition value
        #                           1.When condition=0(IP) or condition=1(IP SEG)
        #                           Supports passing in multiple items at once,separate multiple items with semicolons.
        #                           2.When condition=4(URI) or condition=5(URI_REGEX)
        #                           Supports passing in multiple items at once,separate multiple items with semicolons.
        #                           3.When condition=6(USER_AGENT) or condition=7(USER_AGENT_REGEX)
        #                           Supports passing in multiple items at once, separate multiple items with semicolons.
        #                           4.When condition=8(area)
        #                           You need to pass in the ID corresponding to the region. Use semicolons to separate multiple regions. 
        #                           Refer to the API Center: https://www.wangsu.com/document/api-doc/Overview 8.Appendix description,countries,regions and provinces in Attached Table 1.
        #                           5.When condition=9(HTTP_METHOD)
        #                           Supports passing in multiple items at once, separate multiple items with semicolons.
        #                           Data dictionary (case sensitive)
        #                           GET/POST/HEAD/OPTIONS/PUT/DELETE/TRACE/CONNECT
        #                           6.When condition=10(REFERER) or condition=11(REFERER_REGEX)
        #                           Supports passing in multiple items at once,separate multiple items with semicolons.
        #                           7.When condition=12(PROTOCOL)
        #                           Supports passing in multiple items at once,separate multiple items with semicolons.
        #                           Data dictionary (case sensitive)
        #                           HTTP/HTTPS
        #                           8.When condition=13(HTTP_HEADER) or condition=14(HTTP_HEADER_REGEX)
        #                           At this time,the key and value of the HTTP Header need to be separated by colons for transmission.
        # 
        #                          ", "zh_CN":"匹配内容
        #                           1、当condition=0(IP)或者condition=1(IP段)
        #                           支持一次性传入多个，多个使用分号分隔
        #                           2、当condition=4(URI)或者condition=5(URI_REGEX)
        #                           支持一次性传入多个，多个使用分号分隔
        #                           3、当condition=6(USER_AGENT)或者condition=7(USER_AGENT_REGEX)
        #                           支持一次性传入多个，多个使用分号分隔
        #                           4、当condition=8(area)
        #                           需要传入区域对应ID，多个使用分号分隔。数据字典参考：
        #                           参考API中心：https://www.wangsu.com/document/api-doc/Overview 八、附录说明，附表1中的国家地区、省份。
        #                           5、当condition=9(HTTP_METHOD)
        #                           支持一次性传入多个，多个使用分号分隔
        #                           数据字典(区分大小写)：
        #                           GET、POST、HEAD、OPTIONS、PUT、DELETE、TRACE、CONNECT
        #                           6、当condition=10(REFERER)或者condition=11(REFERER_REGEX)
        #                           多个使用分号分隔
        #                           7、当condition=12(PROTOCOL)
        #                           支持一次性传输多个，多个使用分号分隔
        #                           数据字典(区分大小写)：
        #                           HTTP、HTTPS
        #                           8、当condition=13(HTTP_HEADER)或者condition=14(HTTP_HEADER_REGEX)
        #                           此时需要把HTTP Header的key和value用冒号分隔进行传输
        #                           
        #                          "}
        self.condition_value = condition_value

    def validate(self):
        self.validate_required(self.condition, 'condition')
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.condition_value, 'condition_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.condition_value is not None:
            result['conditionValue'] = self.condition_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            self.condition = m.get('condition')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('conditionValue') is not None:
            self.condition_value = m.get('conditionValue')
        return self


class UpdateAslConfigRequestDataApplyLimit(TeaModel):
    def __init__(
        self,
        limit: str = None,
        limit_key: str = None,
        limit_value: str = None,
    ):
        # {"en":"IP:0,IP+UA:1,Cookie:2,IP+Cookie:3,HTTP Header:4,IP+HTTP Header:5", "zh_CN":"IP:0, IP+UA:1, Cookie:2, IP+Cookie:3, HTTP Header:4,IP+HTTP Header:5"}
        self.limit = limit
        # {"en":"Limit key", "zh_CN":"limit key"}
        self.limit_key = limit_key
        # {"en":"Limit value", "zh_CN":"limit value"}
        self.limit_value = limit_value

    def validate(self):
        self.validate_required(self.limit, 'limit')
        self.validate_required(self.limit_key, 'limit_key')
        self.validate_required(self.limit_value, 'limit_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limit is not None:
            result['limit'] = self.limit
        if self.limit_key is not None:
            result['limitKey'] = self.limit_key
        if self.limit_value is not None:
            result['limitValue'] = self.limit_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('limitKey') is not None:
            self.limit_key = m.get('limitKey')
        if m.get('limitValue') is not None:
            self.limit_value = m.get('limitValue')
        return self


class UpdateAslConfigRequestDataTriggerCondition(TeaModel):
    def __init__(
        self,
        second: str = None,
        request: str = None,
    ):
        # {'en':'Statistical period, in seconds', 'zh_CN':'统计周期，单位秒'}
        self.second = second
        # {'en':'Requests', 'zh_CN':'请求数'}
        self.request = request

    def validate(self):
        self.validate_required(self.second, 'second')
        self.validate_required(self.request, 'request')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.second is not None:
            result['second'] = self.second
        if self.request is not None:
            result['request'] = self.request
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('second') is not None:
            self.second = m.get('second')
        if m.get('request') is not None:
            self.request = m.get('request')
        return self


class UpdateAslConfigRequestDataBanHttp(TeaModel):
    def __init__(
        self,
        custom_set: str = None,
        status: str = None,
        content_type: str = None,
        response: str = None,
    ):
        # {'en':'Block page setting switch,open:1|close:0', 'zh_CN':'自定义拦截开关，1：开启，0关闭'}
        self.custom_set = custom_set
        # {'en':'Response Code', 'zh_CN':'响应码'}
        self.status = status
        # {'en':'Content-Type', 'zh_CN':'Content-Type'}
        self.content_type = content_type
        # {'en':'Customized Block Response
        #                     Notice:
        #                     There may be special characters in the response body information. We provide API for protection, so the customer needs to transcode the response body. 
        #                     At the same time, after obtaining the configuration through the API interface, the response body also needs to be decoded or the original response body can be obtained:
        #                     For specific transcoding and decoding methods, please refer to the notes
        #                     ', 'zh_CN':'响应体信息
        #                     注意：
        #                     响应体信息可能会存在特殊字符，我们提供API有进行防护，所以需要客户的对响应体进行转码，同时，通过API接口获取到配置以后也需要对响应体进行解码以后或得原始响应体：
        #                     具体转码跟解码的方法参看备注
        #                     '}
        self.response = response

    def validate(self):
        self.validate_required(self.custom_set, 'custom_set')
        self.validate_required(self.status, 'status')
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.response, 'response')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_set is not None:
            result['customSet'] = self.custom_set
        if self.status is not None:
            result['status'] = self.status
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.response is not None:
            result['response'] = self.response
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customSet') is not None:
            self.custom_set = m.get('customSet')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('response') is not None:
            self.response = m.get('response')
        return self


class UpdateAslConfigRequestData(TeaModel):
    def __init__(
        self,
        rule_name: str = None,
        desc: str = None,
        conditions: List[UpdateAslConfigRequestDataConditions] = None,
        apply_limit: UpdateAslConfigRequestDataApplyLimit = None,
        trigger_condition: UpdateAslConfigRequestDataTriggerCondition = None,
        ban_http: UpdateAslConfigRequestDataBanHttp = None,
        action: str = None,
        action_duration: str = None,
        friendly_url: str = None,
        get_rule: str = None,
        get_second_rule: str = None,
        get_second_rule_condition: str = None,
        post_rule: str = None,
    ):
        # {"en":"Rule name", "zh_CN":"规则名称"}
        self.rule_name = rule_name
        # {"en":"Rule description", "zh_CN":"规则描述"}
        self.desc = desc
        # {'en':'Matching Conditions(Parameter description: When the matching condition is HTTP Header or HTTP Header Regex, 
        #                         the HTTP header and value need to be assembled using colons. Multiple values of other matching conditions are directly separated by semicolons for transmission.)', 'zh_CN':'匹配条件(参数说明：当匹配条件为HTTP Header
        #                         或者HTTP Header Regex时，Http header首部以及value需要使用冒号进行组装。其他匹配条件多个值直接使用分号分隔传输)'}
        self.conditions = conditions
        # {'en':'Statistical Granularity
        #            1. When the statistical granularity is Cookie
        #            	  limitKey and limitValue do not need to be passed as parameters.
        #            2. When the statistical granularity is Cookie or HTTP Header
        #                limitKey: Customer customized.
        #                limitValue: Currently there is only one value,0(Requests without keys will not be counted).
        #            3. When the statistical granularity is IP Cookie or IP HTTP Header
        #                limitKey: Customer customized
        #                limitValue: optional value,0(Requests without keys will not be counted),1(No key value and IP granular protection),Can only choose one.
        #            ', 
        #            'zh_CN':'统计粒度:
        #            1、当统计粒度为Cookie
        #            		limitKey和limitValue不需要传入
        #            2、当统计粒度为Cookie或者HTTP Header时
        #            	    limitKey: 客户自定义
        #                 limitValue: 当前只有一个值: 0(无Key值不防护)
        #            3、当统计粒度为IP Cookie或者IP HTTP Header
        #                 limitKey: 客户自定义
        #                 limitValue可选值：0(无key值不防护)，1(无key值以IP粒度防护),单选且必须选一个
        #            '}
        self.apply_limit = apply_limit
        # {'en':'Trigger Condition', 'zh_CN':'触发条件'}
        self.trigger_condition = trigger_condition
        # {'en':'Block page Setting', 'zh_CN':'自定义拦截'}
        self.ban_http = ban_http
        # {'en':'action,0:Block,1:Log,2:Reset,3:Human Interaction Challenge,4:Redirect
        #            1:When the processing action is BLOCK, LOG, DROP
        #               friendlyUrl, getRule, getSecondRule, getSecondRuleCondition, postRule are invalid and can be omitted
        #            2:When the processing action is human-machine verification
        #               getRule and postRule must select at least one
        #               a)When getRule=null
        #                 At this time, getSecondRule and getSecondRuleCondition are invalid, postRule must be passed, and the transmission content is the postRule dictionary value.
        #               b)When getRule=0(UrlCookie Validation+302 Redirection) or getRule=1(Cookie Validation+302 Redirection)
        #                 getSecondRule and getSecondRuleCondition are invalid, postRule can choose empty or the dictionary value of postRule
        #               c)When getRule=2(UrlCookie Validation+JS Redirection) or getRule=3(Cookie Validation + JS Redirection) or getRule=4(Cookie Validation+Meta-JS Redirection) or getRule=5(Cookie Validation+JS Mouse Monitor)
        #                 getSecondRule and getSecondRuleCondition must be passed, postRule can choose empty or the dictionary value of postRule
        #            3:When the processing action is Redirect
        #               friendlyUrl is a required parameter
        #               The attributes getRule, getSecondRule, getSecondRuleCondition, and postRule are invalid and do not need to be passed.
        #            ', 
        #            'zh_CN':'动作 0:拦截，1:告警，2:断开连接，3:人机校验,4:跳转友好页面
        #            1、当处理动作为BLOCK、LOG、DROP时
        #               friendlyUrl, getRule, getSecondRule, getSecondRuleCondition, postRule这几个属性无效，不用传
        #            2、当处理动作为人机校验
        #               getRule和postRule必须至少选择一项
        #               a)当getRule=空
        #                 此时，getSecondRule和getSecondRuleCondition无效不用传，postRule必须传，传输内容为postRule字典值
        #               a)当getRule=0(UrlCookie参数验证+302跳转)或者getRule=1(Cookie参数验证+302跳转)
        #                 getSecondRule和getSecondRuleCondition无效不用传，postRule可以选择空或者postRule的字典值
        #               b)当getRule=2(UrlCookie参数验证+JS跳转)或者getRule=3(Cookie参数验证+JS跳转)或者getRule=4(Cookie参数验证+Meta-JS跳转)或者getRule=5(Cookie参数验证+JS鼠标监听)
        #                 getSecondRule和getSecondRuleCondition为必传，postRule可以选择空或者postRule的字典值
        #            3、当处理动作为跳转友好页面
        #               friendlyUrl为必传参数
        #               getRule, getSecondRule, getSecondRuleCondition, postRule这几个属性无效，不用传
        #            '}
        self.action = action
        # {'en':'Action expires after,in minutes', 'zh_CN':'处理动作持续时间,单位秒'}
        self.action_duration = action_duration
        # {'en':'URL setting for the redirect page', 'zh_CN':'跳转友好页面地址'}
        self.friendly_url = friendly_url
        # {'en':'GET Flood Rule,0:UrlCookie Validation+302 Redirection,1:Cookie Validation+302 Redirection,2:UrlCookie Validation+JS Redirection,
        #            3:Cookie Validation + JS Redirection,4:Cookie Validation+Meta-JS Redirection,5:Cookie Validation+JS Mouse Monitor', 
        #            'zh_CN':'GET Flood第一策略,0:UrlCookie参数验证+302跳转,1:Cookie参数验证+302跳转,2:UrlCookie参数验证+JS跳转,3:Cookie参数验证+JS跳转,4:Cookie参数验证+Meta-JS跳转,5:Cookie参数验证+JS鼠标监听'}
        self.get_rule = get_rule
        # {'en':'GET Flood Second Rule,0:UrlCookie Verification + 302 Redirection,1:Cookie Verification + 302 Redirection', 
        #            'zh_CN':'GET Flood第二策略,0:UrlCookie参数验证+302跳转，1：Cookie参数验证+302t跳转'}
        self.get_second_rule = get_second_rule
        # {'en':'2nd Rule Enable Condition,0:Non-html Request(Accept!=text/*|text/htm),1:Non-html Request & Static URI Sufix)', 
        #            'zh_CN':'第二策略启用条件,0:非html请求，1：非html请求且URI后缀是静态文件'}
        self.get_second_rule_condition = get_second_rule_condition
        # {"en":"0:Cookie Validation+JS Redirection,1:Cookie Validation + 307 Redirection", "zh_CN":"0:Cookie参数验证+JS跳转,1:Cookie参数验证+307跳转"}
        self.post_rule = post_rule

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.conditions, 'conditions')
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()
        self.validate_required(self.apply_limit, 'apply_limit')
        if self.apply_limit:
            self.apply_limit.validate()
        self.validate_required(self.trigger_condition, 'trigger_condition')
        if self.trigger_condition:
            self.trigger_condition.validate()
        self.validate_required(self.ban_http, 'ban_http')
        if self.ban_http:
            self.ban_http.validate()
        self.validate_required(self.action, 'action')
        self.validate_required(self.action_duration, 'action_duration')
        self.validate_required(self.friendly_url, 'friendly_url')
        self.validate_required(self.get_rule, 'get_rule')
        self.validate_required(self.get_second_rule, 'get_second_rule')
        self.validate_required(self.get_second_rule_condition, 'get_second_rule_condition')
        self.validate_required(self.post_rule, 'post_rule')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.desc is not None:
            result['desc'] = self.desc
        if self.conditions is not None:
            result['conditions'] = []
            for k in self.conditions:
                result['conditions'].append(k.to_map() if k else None)
        if self.apply_limit is not None:
            result['applyLimit'] = self.apply_limit.to_map()
        if self.trigger_condition is not None:
            result['triggerCondition'] = self.trigger_condition.to_map()
        if self.ban_http is not None:
            result['banHttp'] = self.ban_http.to_map()
        if self.action is not None:
            result['action'] = self.action
        if self.action_duration is not None:
            result['actionDuration'] = self.action_duration
        if self.friendly_url is not None:
            result['friendlyUrl'] = self.friendly_url
        if self.get_rule is not None:
            result['getRule'] = self.get_rule
        if self.get_second_rule is not None:
            result['getSecondRule'] = self.get_second_rule
        if self.get_second_rule_condition is not None:
            result['getSecondRuleCondition'] = self.get_second_rule_condition
        if self.post_rule is not None:
            result['postRule'] = self.post_rule
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('conditions') is not None:
            self.conditions = []
            for k in m.get('conditions'):
                temp_model = UpdateAslConfigRequestDataConditions()
                self.conditions.append(temp_model.from_map(k))
        if m.get('applyLimit') is not None:
            temp_model = UpdateAslConfigRequestDataApplyLimit()
            self.apply_limit = temp_model.from_map(m['applyLimit'])
        if m.get('triggerCondition') is not None:
            temp_model = UpdateAslConfigRequestDataTriggerCondition()
            self.trigger_condition = temp_model.from_map(m['triggerCondition'])
        if m.get('banHttp') is not None:
            temp_model = UpdateAslConfigRequestDataBanHttp()
            self.ban_http = temp_model.from_map(m['banHttp'])
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('actionDuration') is not None:
            self.action_duration = m.get('actionDuration')
        if m.get('friendlyUrl') is not None:
            self.friendly_url = m.get('friendlyUrl')
        if m.get('getRule') is not None:
            self.get_rule = m.get('getRule')
        if m.get('getSecondRule') is not None:
            self.get_second_rule = m.get('getSecondRule')
        if m.get('getSecondRuleCondition') is not None:
            self.get_second_rule_condition = m.get('getSecondRuleCondition')
        if m.get('postRule') is not None:
            self.post_rule = m.get('postRule')
        return self


class UpdateAslConfigRequest(TeaModel):
    def __init__(
        self,
        custom_code: str = None,
        domain: str = None,
        custom_switch: str = None,
        mode: str = None,
        data: List[UpdateAslConfigRequestData] = None,
    ):
        # {"en":"Customer code", "zh_CN":"客户code"}
        self.custom_code = custom_code
        # {"en":"Domain name", "zh_CN":"域名名称"}
        self.domain = domain
        # {"en":"Custom rule switch,0:close,1:open", "zh_CN":"客户自定义规则开关，0：关闭，1：开启"}
        self.custom_switch = custom_switch
        # {"en":"Rule adding mode: 0: new, 1: overwrite (Note that the overwrite mode will clear all the original rules, and all the required configurations need to be transmitted at the same time)", 
        #     "zh_CN":"规则添加方式，0：新增，1：覆盖（注意，覆盖模式会把原本的规则都清空，需要同时传全部需要的配置）"}
        self.mode = mode
        # {'en':'Custom Rule Content', 'zh_CN':'自定义规则内容'}
        self.data = data

    def validate(self):
        self.validate_required(self.custom_code, 'custom_code')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.custom_switch, 'custom_switch')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_code is not None:
            result['customCode'] = self.custom_code
        if self.domain is not None:
            result['domain'] = self.domain
        if self.custom_switch is not None:
            result['customSwitch'] = self.custom_switch
        if self.mode is not None:
            result['mode'] = self.mode
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customCode') is not None:
            self.custom_code = m.get('customCode')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('customSwitch') is not None:
            self.custom_switch = m.get('customSwitch')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = UpdateAslConfigRequestData()
                self.data.append(temp_model.from_map(k))
        return self


class UpdateAslConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {"en":"200:success
        # other code means failed", "zh_CN":"200:成功，其他失败"}
        self.code = code
        # {"en":"SUCCESS or error message", "zh_CN":"成功=SUCCESS，其他返回错误信息"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateAslConfigPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateAslConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateAslConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateAslConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryDomainAccessFrequencyConfigurationRequest(TeaModel):
    def __init__(
        self,
        custom_code: str = None,
        domain: str = None,
    ):
        # {"en":"customer code", "zh_CN":"客户code"}
        self.custom_code = custom_code
        # {"en":"domain name", "zh_CN":"域名"}
        self.domain = domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_code is not None:
            result['customCode'] = self.custom_code
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customCode') is not None:
            self.custom_code = m.get('customCode')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryDomainAccessFrequencyConfigurationResponseDataConditions(TeaModel):
    def __init__(
        self,
        condition: str = None,
        match_type: str = None,
        condition_value: str = None,
    ):
        # {"en":"IP:0,IP_SEG:1,URI:4,URI_REGEX:5,USER_AGENT:6,USER_AGENT_REGEX:7,AREA:8,HTTP_METHOD:9,REFERER:10,REFERER_REGEX:11,PROTOCOL:12,HTTP_HEADER:13,HTTP_HEADER_REGEX:14",'zh_CN':'IP:0,IP_SEG:1,URI:4, URI_REGEX:5, USER_AGENT:6, USER_AGENT_REGEX:7, AREA:8,HTTP_METHOD:9,REFERER:10,REFERER_REGEX:11,PROTOCOL:12,HTTP_HEADER:13,HTTP_HEADER_REGEX:14'}
        self.condition = condition
        # {"en":"Not equal:0|Equal:1", "zh_CN":"不等于:0|等于:1"}
        self.match_type = match_type
        # {"en":"Condition value", "zh_CN":"匹配内容"}
        self.condition_value = condition_value

    def validate(self):
        self.validate_required(self.condition, 'condition')
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.condition_value, 'condition_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.condition_value is not None:
            result['conditionValue'] = self.condition_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            self.condition = m.get('condition')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('conditionValue') is not None:
            self.condition_value = m.get('conditionValue')
        return self


class QueryDomainAccessFrequencyConfigurationResponseDataApplyLimit(TeaModel):
    def __init__(
        self,
        limit: str = None,
        limit_key: str = None,
        limit_value: str = None,
    ):
        # {"en":"IP:0, IP+UA:1, Cookie:2, IP+Cookie:3, HTTP Header:4,IP+HTTP Header:5", "zh_CN":"IP:0, IP+UA:1, Cookie:2, IP+Cookie:3, HTTP Header:4,IP+HTTP Header:5"}
        self.limit = limit
        # {"en":"Limit key", "zh_CN":"limit key"}
        self.limit_key = limit_key
        # {"en":"Limit value", "zh_CN":"limit value"}
        self.limit_value = limit_value

    def validate(self):
        self.validate_required(self.limit, 'limit')
        self.validate_required(self.limit_key, 'limit_key')
        self.validate_required(self.limit_value, 'limit_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limit is not None:
            result['limit'] = self.limit
        if self.limit_key is not None:
            result['limitKey'] = self.limit_key
        if self.limit_value is not None:
            result['limitValue'] = self.limit_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('limitKey') is not None:
            self.limit_key = m.get('limitKey')
        if m.get('limitValue') is not None:
            self.limit_value = m.get('limitValue')
        return self


class QueryDomainAccessFrequencyConfigurationResponseDataTriggerCondition(TeaModel):
    def __init__(
        self,
        second: str = None,
        request: str = None,
    ):
        # {'en':'Statistical period, in seconds', 'zh_CN':'统计周期，单位秒'}
        self.second = second
        # {'en':'Requests', 'zh_CN':'请求数'}
        self.request = request

    def validate(self):
        self.validate_required(self.second, 'second')
        self.validate_required(self.request, 'request')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.second is not None:
            result['second'] = self.second
        if self.request is not None:
            result['request'] = self.request
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('second') is not None:
            self.second = m.get('second')
        if m.get('request') is not None:
            self.request = m.get('request')
        return self


class QueryDomainAccessFrequencyConfigurationResponseDataBanHttp(TeaModel):
    def __init__(
        self,
        custom_set: str = None,
        status: str = None,
        content_type: str = None,
        response: str = None,
    ):
        # {'en':'Block page setting switch,open:1|close:0', 'zh_CN':'自定义拦截开关，1：开启，0关闭'}
        self.custom_set = custom_set
        # {'en':'Response Code', 'zh_CN':'响应码'}
        self.status = status
        # {'en':'Content-Type', 'zh_CN':'Content-Type'}
        self.content_type = content_type
        # {'en':'Customized Block Response', 'zh_CN':'响应体信息'}
        self.response = response

    def validate(self):
        self.validate_required(self.custom_set, 'custom_set')
        self.validate_required(self.status, 'status')
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.response, 'response')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_set is not None:
            result['customSet'] = self.custom_set
        if self.status is not None:
            result['status'] = self.status
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.response is not None:
            result['response'] = self.response
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customSet') is not None:
            self.custom_set = m.get('customSet')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('response') is not None:
            self.response = m.get('response')
        return self


class QueryDomainAccessFrequencyConfigurationResponseData(TeaModel):
    def __init__(
        self,
        rule_name: str = None,
        desc: str = None,
        conditions: List[QueryDomainAccessFrequencyConfigurationResponseDataConditions] = None,
        apply_limit: QueryDomainAccessFrequencyConfigurationResponseDataApplyLimit = None,
        trigger_condition: QueryDomainAccessFrequencyConfigurationResponseDataTriggerCondition = None,
        ban_http: QueryDomainAccessFrequencyConfigurationResponseDataBanHttp = None,
        action: str = None,
        action_duration: str = None,
        friendly_url: str = None,
        get_rule: str = None,
        get_second_rule: str = None,
        get_second_rule_condition: str = None,
        post_rule: str = None,
    ):
        # {"en":"Rule name", "zh_CN":"规则名称"}
        self.rule_name = rule_name
        # {"en":"Rule description", "zh_CN":"规则描述"}
        self.desc = desc
        # {'en':'Matching Conditions', 'zh_CN':'匹配条件'}
        self.conditions = conditions
        # {'en':'Statistical Granularity', 'zh_CN':'统计粒度'}
        self.apply_limit = apply_limit
        # {'en':'Trigger Condition', 'zh_CN':'触发条件'}
        self.trigger_condition = trigger_condition
        # {'en':'Block page Setting', 'zh_CN':'自定义拦截'}
        self.ban_http = ban_http
        # {'en':'action 0:Block,1:Log,2:Reset,3:Human Interaction Challenge,4:Redirect', 'zh_CN':'动作 0:拦截，1:告警，2:断开连接，3:人机校验,4:跳转友好页面'}
        self.action = action
        # {'en':'Action expires after,in minutes', 'zh_CN':'处理动作持续时间,单位秒'}
        self.action_duration = action_duration
        # {'en':'URL setting for the redirect page', 'zh_CN':'跳转友好页面地址'}
        self.friendly_url = friendly_url
        # {'en':'GET Flood Rule,0:UrlCookie Validation+302 Redirection,1:Cookie Validation+302 Redirection,2:UrlCookie Validation+JS Redirection,
        #            3:Cookie Validation + JS Redirection,4:Cookie Validation+Meta-JS Redirection,5:Cookie Validation+JS Mouse Monitor', 
        #            'zh_CN':'GET Flood第一策略,0:UrlCookie参数验证+302跳转,1:Cookie参数验证+302跳转,2:UrlCookie参数验证+JS跳转,3:Cookie参数验证+JS跳转,4:Cookie参数验证+Meta-JS跳转,5:Cookie参数验证+JS鼠标监听'}
        self.get_rule = get_rule
        # {'en':'GET Flood Second Rule,0:UrlCookie Verification + 302 Redirection,1:Cookie Verification + 302 Redirection', 
        #            'zh_CN':'GET Flood第二策略,0:UrlCookie参数验证+302跳转，1：Cookie参数验证+302t跳转'}
        self.get_second_rule = get_second_rule
        # {'en':'2nd Rule Enable Condition,0:Non-html Request(Accept!=text/*|text/htm),1:Non-html Request & Static URI Sufix)', 
        #            'zh_CN':'第二策略启用条件,0:非html请求，1：非html请求且URI后缀是静态文件'}
        self.get_second_rule_condition = get_second_rule_condition
        # {"en":"0:Cookie Validation+JS Redirection,1:Cookie Validation + 307 Redirection", "zh_CN":"0:Cookie参数验证+JS跳转,1:Cookie参数验证+307跳转"}
        self.post_rule = post_rule

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.conditions, 'conditions')
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()
        self.validate_required(self.apply_limit, 'apply_limit')
        if self.apply_limit:
            self.apply_limit.validate()
        self.validate_required(self.trigger_condition, 'trigger_condition')
        if self.trigger_condition:
            self.trigger_condition.validate()
        self.validate_required(self.ban_http, 'ban_http')
        if self.ban_http:
            self.ban_http.validate()
        self.validate_required(self.action, 'action')
        self.validate_required(self.action_duration, 'action_duration')
        self.validate_required(self.friendly_url, 'friendly_url')
        self.validate_required(self.get_rule, 'get_rule')
        self.validate_required(self.get_second_rule, 'get_second_rule')
        self.validate_required(self.get_second_rule_condition, 'get_second_rule_condition')
        self.validate_required(self.post_rule, 'post_rule')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.desc is not None:
            result['desc'] = self.desc
        if self.conditions is not None:
            result['conditions'] = []
            for k in self.conditions:
                result['conditions'].append(k.to_map() if k else None)
        if self.apply_limit is not None:
            result['applyLimit'] = self.apply_limit.to_map()
        if self.trigger_condition is not None:
            result['triggerCondition'] = self.trigger_condition.to_map()
        if self.ban_http is not None:
            result['banHttp'] = self.ban_http.to_map()
        if self.action is not None:
            result['action'] = self.action
        if self.action_duration is not None:
            result['actionDuration'] = self.action_duration
        if self.friendly_url is not None:
            result['friendlyUrl'] = self.friendly_url
        if self.get_rule is not None:
            result['getRule'] = self.get_rule
        if self.get_second_rule is not None:
            result['getSecondRule'] = self.get_second_rule
        if self.get_second_rule_condition is not None:
            result['getSecondRuleCondition'] = self.get_second_rule_condition
        if self.post_rule is not None:
            result['postRule'] = self.post_rule
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('conditions') is not None:
            self.conditions = []
            for k in m.get('conditions'):
                temp_model = QueryDomainAccessFrequencyConfigurationResponseDataConditions()
                self.conditions.append(temp_model.from_map(k))
        if m.get('applyLimit') is not None:
            temp_model = QueryDomainAccessFrequencyConfigurationResponseDataApplyLimit()
            self.apply_limit = temp_model.from_map(m['applyLimit'])
        if m.get('triggerCondition') is not None:
            temp_model = QueryDomainAccessFrequencyConfigurationResponseDataTriggerCondition()
            self.trigger_condition = temp_model.from_map(m['triggerCondition'])
        if m.get('banHttp') is not None:
            temp_model = QueryDomainAccessFrequencyConfigurationResponseDataBanHttp()
            self.ban_http = temp_model.from_map(m['banHttp'])
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('actionDuration') is not None:
            self.action_duration = m.get('actionDuration')
        if m.get('friendlyUrl') is not None:
            self.friendly_url = m.get('friendlyUrl')
        if m.get('getRule') is not None:
            self.get_rule = m.get('getRule')
        if m.get('getSecondRule') is not None:
            self.get_second_rule = m.get('getSecondRule')
        if m.get('getSecondRuleCondition') is not None:
            self.get_second_rule_condition = m.get('getSecondRuleCondition')
        if m.get('postRule') is not None:
            self.post_rule = m.get('postRule')
        return self


class QueryDomainAccessFrequencyConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[QueryDomainAccessFrequencyConfigurationResponseData] = None,
        version: str = None,
        custom_switch: str = None,
    ):
        # {"en":"200:success
        # other code means failed", "zh_CN":"200:成功，其他失败"}
        self.code = code
        # {"en":"SUCCESS or error message", "zh_CN":"成功=SUCCESS，其他返回错误信息"}
        self.msg = msg
        # {'en':'Custom Rule Content', 'zh_CN':'自定义规则内容'}
        self.data = data
        # {"en":"domain config version", "zh_CN":"域名版本号"}
        self.version = version
        # {"en":"Custom rule switch,0:close,1:open,default all", "zh_CN":"客户自定义规则开关，0：关闭，1：开启, 默认全部"}
        self.custom_switch = custom_switch

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.version is not None:
            result['version'] = self.version
        if self.custom_switch is not None:
            result['customSwitch'] = self.custom_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = QueryDomainAccessFrequencyConfigurationResponseData()
                self.data.append(temp_model.from_map(k))
        if m.get('version') is not None:
            self.version = m.get('version')
        if m.get('customSwitch') is not None:
            self.custom_switch = m.get('customSwitch')
        return self


class QueryDomainAccessFrequencyConfigurationPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainAccessFrequencyConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainAccessFrequencyConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainAccessFrequencyConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateCustomRuleRequestConditionMethodConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        request_method: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal","zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"Request method.
        # Supported values: GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY.","zh_CN":"请求方法。
        # 支持的值：GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY。"}
        self.request_method = request_method

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.request_method, 'request_method')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        return self


class UpdateCustomRuleRequestConditionJa3Conditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ja_3list: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal","zh_CN":"匹配类型。
        # EQUAL：等于 
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"JA3 Fingerprint List, maximum 300 JA3 Fingerprint.
        # When the match type is EQUAL/NOT_EQUAL, each item's character length must be 32 and can only include numbers and lowercase letters.","zh_CN":"JA3指纹列表，最多300个JA3指纹。
        # 当匹配类型为等于/不等于时，每项字符长度必须为32，且仅限数字和小写字母。"}
        self.ja_3list = ja_3list

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ja_3list, 'ja_3list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ja_3list is not None:
            result['ja3List'] = self.ja_3list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ja3List') is not None:
            self.ja_3list = m.get('ja3List')
        return self


class UpdateCustomRuleRequestConditionAreaConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        areas: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal","zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"Geo.","zh_CN":"区域。"}
        self.areas = areas

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.areas, 'areas')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.areas is not None:
            result['areas'] = self.areas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('areas') is not None:
            self.areas = m.get('areas')
        return self


class UpdateCustomRuleRequestConditionIpOrIpsConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ip_or_ips: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal","zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"IP/CIDR, maximum 500 IP/CIDR.","zh_CN":"IP/IP段，最多500个IP/IP段。"}
        self.ip_or_ips = ip_or_ips

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ip_or_ips, 'ip_or_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ip_or_ips is not None:
            result['ipOrIps'] = self.ip_or_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ipOrIps') is not None:
            self.ip_or_ips = m.get('ipOrIps')
        return self


class UpdateCustomRuleRequestConditionUriConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        uri: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, URI case sensitive
        # NOT_EQUAL: Does not equal, URI case sensitive
        # CONTAIN: Contains, URI case insensitive
        # NOT_CONTAIN: Does not Contains, URI case insensitive
        # REGEX: Regex match, URI case insensitive
        # NOT_REGEX: Regular does not match, URI case insensitive
        # START_WITH: Starts with, URI case insensitive
        # END_WITH: Ends with, URI case insensitive
        # WILDCARD: Wildcard matches, URI case insensitive,* represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, URI case insensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，URI大小写敏感
        # NOT_EQUAL：不等于，URI大小写敏感
        # CONTAIN：包含，URI大小写不敏感
        # NOT_CONTAIN：不包含，URI大小写不敏感
        # REGEX：匹配正则，URI大小写不敏感
        # NOT_REGEX：正则不匹配，URI大小写不敏感
        # START_WITH：开头是，URI大小写不敏感
        # END_WITH：结尾是，URI大小写不敏感
        # WILDCARD：通配符匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {"en":"URI.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, uri needs to start with "/", and includes parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.
        # Example: /test.html?id=1.","zh_CN":"URI。
        # 当匹配类型为等于/不等于/开头是/结尾是，URI必须以”/“开头，含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html?id=1。"}
        self.uri = uri

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.uri, 'uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class UpdateCustomRuleRequestConditionPathConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        paths: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, path case sensitive
        # NOT_EQUAL: Does not equal, path case sensitive
        # CONTAIN: Contains, path case insensitive
        # NOT_CONTAIN: Does not Contains, path case insensitive
        # REGEX: Regex match, path case insensitive
        # NOT_REGEX: Regular does not match, path case sensitive
        # START_WITH: Starts with, path case sensitive
        # END_WITH: Ends with, path case sensitive
        # WILDCARD: Wildcard matches, path case sensitive,* represents zero or more arbitrary characters, ? represents any single character.
        # NOT_WILDCARD: Wildcard does not match, path case sensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，路径大小写敏感
        # NOT_EQUAL：不等于，路径大小写敏感
        # CONTAIN：包含，路径大小写不敏感
        # NOT_CONTAIN：不包含，路径大小写不敏感
        # REGEX：匹配正则，路径大小写不敏感
        # NOT_REGEX：正则不匹配，路径大小写不敏感
        # START_WITH：开头是，路径大小写不敏感
        # END_WITH：结尾是，路径大小写不敏感
        # WILDCARD：通配符匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {"en":"Path.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, path needs to start with "/", and no parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.
        # Example: /test.html.","zh_CN":"路径。
        # 当匹配类型为等于/不等于/开头是/结尾是，路径必须以“/”开头，不含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html。"}
        self.paths = paths

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.paths, 'paths')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.paths is not None:
            result['paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paths') is not None:
            self.paths = m.get('paths')
        return self


class UpdateCustomRuleRequestConditionUriParamConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        param_name: str = None,
        param_value: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL:Equals,param value case sensitive
        # NOT_EQUAL:Does not equal,param value case sensitive
        # CONTAIN:Contains,param value case insensitive
        # NOT_CONTAIN:Does not contains,param value case insensitive
        # REGEX:Regex match,param value case insensitive
        # NONE:Empty or non-existent","zh_CN":"匹配类型。
        # EQUAL：等于，参数值大小写敏感
        # NOT_EQUAL：不等于，参数值大小写敏感
        # CONTAIN：包含，参数值大小写不敏感
        # NOT_CONTAIN：不包含，参数值大小写不敏感
        # REGEX：正则，参数值大小写不敏感
        # NONE：为空或不存在"}
        self.match_type = match_type
        # {"en":"Param name,case sensitive,maximum 100 characters.
        # Example: id.","zh_CN":"参数名，大小写敏感，最多100个字符。
        # 示例：id。"}
        self.param_name = param_name
        # {"en":"Param value.","zh_CN":"参数值。"}
        self.param_value = param_value

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.param_name, 'param_name')
        self.validate_required(self.param_value, 'param_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.param_name is not None:
            result['paramName'] = self.param_name
        if self.param_value is not None:
            result['paramValue'] = self.param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paramName') is not None:
            self.param_name = m.get('paramName')
        if m.get('paramValue') is not None:
            self.param_value = m.get('paramValue')
        return self


class UpdateCustomRuleRequestConditionUaConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ua: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, user agent case sensitive
        # NOT_EQUAL: Does not equal, user agent case sensitive
        # CONTAIN: Contains, user agent case insensitive
        # NOT_CONTAIN: Does not Contains, user agent case insensitive
        # NONE:Empty or non-existent
        # REGEX: Regex match, user agent case insensitive
        # NOT_REGEX: Regular does not match, user agent case insensitive
        # START_WITH: Starts with, user agent case insensitive
        # END_WITH: Ends with, user agent case insensitive
        # WILDCARD: Wildcard matches, user agent case insensitive,* represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, user agent case insensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，User-Agent大小写敏感
        # NOT_EQUAL：不等于，User-Agent大小写敏感
        # CONTAIN：包含，User-Agent大小写不敏感
        # NOT_CONTAIN：不包含，User-Agent大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，User-Agent大小写不敏感
        # NOT_REGEX：正则不匹配，User-Agent大小写不敏感
        # START_WITH：开头是，User-Agent大小写不敏感
        # END_WITH：结尾是，User-Agent大小写不敏感
        # WILDCARD：通配符匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {"en":"User agent.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.
        # Example: go-Http-client/1.1.","zh_CN":"User-Agent。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：go-Http-client/1.1。"}
        self.ua = ua

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ua, 'ua')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ua is not None:
            result['ua'] = self.ua
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ua') is not None:
            self.ua = m.get('ua')
        return self


class UpdateCustomRuleRequestConditionHeaderConditions(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        value_list: List[str] = None,
        key: str = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, request header values case sensitive
        # NOT_EQUAL: Does not equal, request header values case sensitive
        # CONTAIN: Contains, request header values case insensitive
        # NOT_CONTAIN: Does not Contains, request header values case insensitive
        # NONE: Empty or non-existent
        # REGEX: Regex match, request header values case insensitive
        # NOT_REGEX: Regular does not match, request header values case insensitive
        # START_WITH: Starts with, request header values case insensitive
        # END_WITH: Ends with, request header values case insensitive
        # WILDCARD: Wildcard matches, request header values case insensitive,* represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, request header values case insensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，头部值大小写敏感
        # NOT_EQUAL：不等于，头部值大小写敏感
        # CONTAIN：包含，头部值大小写不敏感
        # NOT_CONTAIN：不包含，头部值大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，头部值大小写不敏感
        # NOT_REGEX：正则不匹配，头部值大小写不敏感
        # START_WITH：开头是，头部值大小写不敏感
        # END_WITH：结尾是，头部值大小写不敏感
        # WILDCARD：通配符匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {"en":"Header value.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.","zh_CN":"头部值。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。"}
        self.value_list = value_list
        # {"en":"Header name,case insensitive,up to 100 characters.
        # Example: Accept.","zh_CN":"头部名称，大小写不敏感，最多100个字符。
        # 示例：Accept。"}
        self.key = key

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.value_list, 'value_list')
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.value_list is not None:
            result['valueList'] = self.value_list
        if self.key is not None:
            result['key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('valueList') is not None:
            self.value_list = m.get('valueList')
        if m.get('key') is not None:
            self.key = m.get('key')
        return self


class UpdateCustomRuleRequestConditionRefererConditions(TeaModel):
    def __init__(
        self,
        referer: List[str] = None,
        match_type: str = None,
    ):
        # {"en":"Referer.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.
        # Example: http://test.com.","zh_CN":"Referer。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：http://test.com。"}
        self.referer = referer
        # {"en":"Match type.
        # EQUAL: Equals, referer case sensitive
        # NOT_EQUAL: Does not equal, referer case sensitive
        # CONTAIN: Contains, referer case insensitive
        # NOT_CONTAIN: Does not Contains, referer case insensitive
        # NONE:Empty or non-existent
        # REGEX: Regex match, referer case insensitive
        # NOT_REGEX: Regular does not match, referer case insensitive
        # START_WITH: Starts with, referer case insensitive
        # END_WITH: Ends with, referer case insensitive
        # WILDCARD: Wildcard matches, referer case insensitive,* represents zero or more arbitrary characters, ? represents any single characte
        # NOT_WILDCARD: Wildcard does not match, referer case insensitive,* represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于，referer大小写敏感
        # NOT_EQUAL：不等于，referer大小写敏感
        # CONTAIN：包含，referer大小写不敏感
        # NOT_CONTAIN：不包含，referer大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，referer大小写不敏感
        # NOT_REGEX：正则不匹配，referer大小写不敏感
        # START_WITH：开头是，referer大小写不敏感
        # END_WITH：结尾是，referer大小写不敏感
        # WILDCARD：通配符匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type

    def validate(self):
        self.validate_required(self.referer, 'referer')
        self.validate_required(self.match_type, 'match_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.referer is not None:
            result['referer'] = self.referer
        if self.match_type is not None:
            result['matchType'] = self.match_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('referer') is not None:
            self.referer = m.get('referer')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        return self


class UpdateCustomRuleRequestConditionJa4Conditions(TeaModel):
    def __init__(
        self,
        ja_4list: List[str] = None,
        match_type: str = None,
    ):
        # {"en":"JA4 Fingerprint List, maximum 300 JA4 Fingerprint.
        # When the match type is EQUAL/NOT_EQUAL, each item's format must be 10 characters + 12 characters + 12 characters, separated by underscores, and can only include underscores, numbers, and lowercase letters.
        # When the match type is CONTAIN/NOT_CONTAIN/START_WITH/END_WITH, each item is only allowed to include underscores, numbers, and lowercase letters.
        # When the match type is WILDCARD/NOT_WILDCARD, each item, aside from  ** and ?, is only allowed to include underscores, numbers, and lowercase letters.","zh_CN":"JA4指纹列表，最多300个JA4指纹。
        # 当匹配类型为等于/不等于时，每项格式必须为10位字符+12位字符+12位字符，中间以“_”分隔，且仅限下划线、数字和小写字母。
        # 当匹配类型为包含/不包含/开头是/结尾是时，每项只允许输入下划线、数字和小写字母。
        # 当匹配类型为通配符匹配/通配符不匹配时，每项除*和?外，只允许输入下划线、数字和小写字母。"}
        self.ja_4list = ja_4list
        # {"en":"Match type. 
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal
        # CONTAIN: Contains
        # NOT_CONTAIN: Does not Contains
        # START_WITH: Starts with
        # END_WITH: Ends with
        # WILDCARD: Wildcard matches, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, ** represents zero or more arbitrary characters, ? represents any single character","zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于
        # CONTAIN：包含
        # NOT_CONTAIN：不包含
        # START_WITH：开头是
        # END_WITH：结尾是
        # WILDCARD：通配符匹配，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type

    def validate(self):
        self.validate_required(self.ja_4list, 'ja_4list')
        self.validate_required(self.match_type, 'match_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ja_4list is not None:
            result['ja4List'] = self.ja_4list
        if self.match_type is not None:
            result['matchType'] = self.match_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ja4List') is not None:
            self.ja_4list = m.get('ja4List')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        return self


class UpdateCustomRuleRequestCondition(TeaModel):
    def __init__(
        self,
        method_conditions: List[UpdateCustomRuleRequestConditionMethodConditions] = None,
        ja_3conditions: List[UpdateCustomRuleRequestConditionJa3Conditions] = None,
        area_conditions: List[UpdateCustomRuleRequestConditionAreaConditions] = None,
        ip_or_ips_conditions: List[UpdateCustomRuleRequestConditionIpOrIpsConditions] = None,
        uri_conditions: List[UpdateCustomRuleRequestConditionUriConditions] = None,
        path_conditions: List[UpdateCustomRuleRequestConditionPathConditions] = None,
        uri_param_conditions: List[UpdateCustomRuleRequestConditionUriParamConditions] = None,
        ua_conditions: List[UpdateCustomRuleRequestConditionUaConditions] = None,
        header_conditions: List[UpdateCustomRuleRequestConditionHeaderConditions] = None,
        referer_conditions: List[UpdateCustomRuleRequestConditionRefererConditions] = None,
        ja_4conditions: List[UpdateCustomRuleRequestConditionJa4Conditions] = None,
    ):
        # {"en":"Request Method.
        # When the business scenario is API,this matching condition is not supported.","zh_CN":"请求方法，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。"}
        self.method_conditions = method_conditions
        # {"en":"JA3 Fingerprint, match type cannot be repeated.","zh_CN":"JA3指纹，匹配类型不可重复。"}
        self.ja_3conditions = ja_3conditions
        # {"en":"Geo, match type cannot be repeated.","zh_CN":"区域，匹配类型不可重复。"}
        self.area_conditions = area_conditions
        # {"en":"IP/CIDR, match type cannot be repeated.","zh_CN":"IP/IP段，匹配类型不可重复。"}
        self.ip_or_ips_conditions = ip_or_ips_conditions
        # {"en":"URI, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.","zh_CN":"URI，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。"}
        self.uri_conditions = uri_conditions
        # {"en":"Path, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.","zh_CN":"路径，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。"}
        self.path_conditions = path_conditions
        # {"en":"URI Parameter, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.","zh_CN":"URI参数，匹配类型不可重复。
        # 当业务场景为网站业务时不支持此匹配条件。"}
        self.uri_param_conditions = uri_param_conditions
        # {"en":"User Agent, match type cannot be repeated.","zh_CN":"User-Agent，匹配类型不可重复。"}
        self.ua_conditions = ua_conditions
        # {"en":"Request Header, natch type can be repeated.","zh_CN":"请求头，匹配类型可重复。"}
        self.header_conditions = header_conditions
        # {"en":"Referer, match type cannot be repeated.","zh_CN":"Referer，匹配类型不可重复。"}
        self.referer_conditions = referer_conditions
        # {"en":"JA4 Fingerprint, match type cannot be repeated.","zh_CN":"JA4指纹，匹配类型不可重复。"}
        self.ja_4conditions = ja_4conditions

    def validate(self):
        if self.method_conditions:
            for k in self.method_conditions:
                if k:
                    k.validate()
        if self.ja_3conditions:
            for k in self.ja_3conditions:
                if k:
                    k.validate()
        if self.area_conditions:
            for k in self.area_conditions:
                if k:
                    k.validate()
        if self.ip_or_ips_conditions:
            for k in self.ip_or_ips_conditions:
                if k:
                    k.validate()
        if self.uri_conditions:
            for k in self.uri_conditions:
                if k:
                    k.validate()
        if self.path_conditions:
            for k in self.path_conditions:
                if k:
                    k.validate()
        if self.uri_param_conditions:
            for k in self.uri_param_conditions:
                if k:
                    k.validate()
        if self.ua_conditions:
            for k in self.ua_conditions:
                if k:
                    k.validate()
        if self.header_conditions:
            for k in self.header_conditions:
                if k:
                    k.validate()
        if self.referer_conditions:
            for k in self.referer_conditions:
                if k:
                    k.validate()
        if self.ja_4conditions:
            for k in self.ja_4conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method_conditions is not None:
            result['methodConditions'] = []
            for k in self.method_conditions:
                result['methodConditions'].append(k.to_map() if k else None)
        if self.ja_3conditions is not None:
            result['ja3Conditions'] = []
            for k in self.ja_3conditions:
                result['ja3Conditions'].append(k.to_map() if k else None)
        if self.area_conditions is not None:
            result['areaConditions'] = []
            for k in self.area_conditions:
                result['areaConditions'].append(k.to_map() if k else None)
        if self.ip_or_ips_conditions is not None:
            result['ipOrIpsConditions'] = []
            for k in self.ip_or_ips_conditions:
                result['ipOrIpsConditions'].append(k.to_map() if k else None)
        if self.uri_conditions is not None:
            result['uriConditions'] = []
            for k in self.uri_conditions:
                result['uriConditions'].append(k.to_map() if k else None)
        if self.path_conditions is not None:
            result['pathConditions'] = []
            for k in self.path_conditions:
                result['pathConditions'].append(k.to_map() if k else None)
        if self.uri_param_conditions is not None:
            result['uriParamConditions'] = []
            for k in self.uri_param_conditions:
                result['uriParamConditions'].append(k.to_map() if k else None)
        if self.ua_conditions is not None:
            result['uaConditions'] = []
            for k in self.ua_conditions:
                result['uaConditions'].append(k.to_map() if k else None)
        if self.header_conditions is not None:
            result['headerConditions'] = []
            for k in self.header_conditions:
                result['headerConditions'].append(k.to_map() if k else None)
        if self.referer_conditions is not None:
            result['refererConditions'] = []
            for k in self.referer_conditions:
                result['refererConditions'].append(k.to_map() if k else None)
        if self.ja_4conditions is not None:
            result['ja4Conditions'] = []
            for k in self.ja_4conditions:
                result['ja4Conditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('methodConditions') is not None:
            self.method_conditions = []
            for k in m.get('methodConditions'):
                temp_model = UpdateCustomRuleRequestConditionMethodConditions()
                self.method_conditions.append(temp_model.from_map(k))
        if m.get('ja3Conditions') is not None:
            self.ja_3conditions = []
            for k in m.get('ja3Conditions'):
                temp_model = UpdateCustomRuleRequestConditionJa3Conditions()
                self.ja_3conditions.append(temp_model.from_map(k))
        if m.get('areaConditions') is not None:
            self.area_conditions = []
            for k in m.get('areaConditions'):
                temp_model = UpdateCustomRuleRequestConditionAreaConditions()
                self.area_conditions.append(temp_model.from_map(k))
        if m.get('ipOrIpsConditions') is not None:
            self.ip_or_ips_conditions = []
            for k in m.get('ipOrIpsConditions'):
                temp_model = UpdateCustomRuleRequestConditionIpOrIpsConditions()
                self.ip_or_ips_conditions.append(temp_model.from_map(k))
        if m.get('uriConditions') is not None:
            self.uri_conditions = []
            for k in m.get('uriConditions'):
                temp_model = UpdateCustomRuleRequestConditionUriConditions()
                self.uri_conditions.append(temp_model.from_map(k))
        if m.get('pathConditions') is not None:
            self.path_conditions = []
            for k in m.get('pathConditions'):
                temp_model = UpdateCustomRuleRequestConditionPathConditions()
                self.path_conditions.append(temp_model.from_map(k))
        if m.get('uriParamConditions') is not None:
            self.uri_param_conditions = []
            for k in m.get('uriParamConditions'):
                temp_model = UpdateCustomRuleRequestConditionUriParamConditions()
                self.uri_param_conditions.append(temp_model.from_map(k))
        if m.get('uaConditions') is not None:
            self.ua_conditions = []
            for k in m.get('uaConditions'):
                temp_model = UpdateCustomRuleRequestConditionUaConditions()
                self.ua_conditions.append(temp_model.from_map(k))
        if m.get('headerConditions') is not None:
            self.header_conditions = []
            for k in m.get('headerConditions'):
                temp_model = UpdateCustomRuleRequestConditionHeaderConditions()
                self.header_conditions.append(temp_model.from_map(k))
        if m.get('refererConditions') is not None:
            self.referer_conditions = []
            for k in m.get('refererConditions'):
                temp_model = UpdateCustomRuleRequestConditionRefererConditions()
                self.referer_conditions.append(temp_model.from_map(k))
        if m.get('ja4Conditions') is not None:
            self.ja_4conditions = []
            for k in m.get('ja4Conditions'):
                temp_model = UpdateCustomRuleRequestConditionJa4Conditions()
                self.ja_4conditions.append(temp_model.from_map(k))
        return self


class UpdateCustomRuleRequest(TeaModel):
    def __init__(
        self,
        condition: UpdateCustomRuleRequestCondition = None,
        act: str = None,
        rule_name: str = None,
        description: str = None,
        id: str = None,
        api_id: str = None,
        scene: str = None,
    ):
        # {"en":"Matching conditions. Except for header conditions, there can only be at most one record per match type under each type of condition.","zh_CN":"匹配条件。除了请求头条件，其它类型的条件下一种匹配类型最多只能有一条记录。"}
        self.condition = condition
        # {"en":"Action.
        # NO_USE:Not Used
        # LOG:Log
        # DELAY:Delay
        # BLOCK:Deny
        # RESET:Reset Connection","zh_CN":"处理动作。
        # NO_USE：不使用
        # LOG：监控
        # DELAY：延迟响应
        # BLOCK：拦截
        # RESET:断开连接"}
        self.act = act
        # {"en":"Rule Name, maximum 50 characters.
        # Does not support special characters and spaces.","zh_CN":"规则名称，最多50个字符。
        # 不支持特殊字符和空格。"}
        self.rule_name = rule_name
        # {"en":"Description, maximum 200 characters.","zh_CN":"规则描述，最多200个字符。"}
        self.description = description
        # {"en":"Rule ID.","zh_CN":"规则ID。"}
        self.id = id
        # {"en":"API ID under API business, multiple separated by ; sign.
        # When the protected target is APIThis field is required.","zh_CN":"API业务下的API ID，多个用 ; 隔开。
        # 当业务场景为API业务时此字段必填。"}
        self.api_id = api_id
        # {"en":"Protected target.
        # WEB:Website
        # API:API","zh_CN":"业务场景。
        # WEB：WEB业务
        # API：API业务"}
        self.scene = scene

    def validate(self):
        if self.condition:
            self.condition.validate()
        self.validate_required(self.id, 'id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition.to_map()
        if self.act is not None:
            result['act'] = self.act
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.description is not None:
            result['description'] = self.description
        if self.id is not None:
            result['id'] = self.id
        if self.api_id is not None:
            result['apiId'] = self.api_id
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            temp_model = UpdateCustomRuleRequestCondition()
            self.condition = temp_model.from_map(m['condition'])
        if m.get('act') is not None:
            self.act = m.get('act')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('apiId') is not None:
            self.api_id = m.get('apiId')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class UpdateCustomRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCustomRuleResponse(TeaModel):
    def __init__(
        self,
        msg: str = None,
        code: str = None,
        data: bool = None,
    ):
        # {"en":"Description.","zh_CN":"描述信息。"}
        self.msg = msg
        # {"dictionary":"belong=WAAP-MS-Ext|dict=waap_retCodeEnum","en":"Please refer to the error code for exceptions.","zh_CN":"请参照错误码。"}
        self.code = code
        # {"en":"Data.","zh_CN":"出参数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.msg is not None:
            result['msg'] = self.msg
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditQuotaRuleRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        control_action: str = None,
        limit_duration: int = None,
        limit_unit: str = None,
        policy_name: str = None,
        remark: str = None,
        threshold_value: int = None,
    ):
        # {"en":"Rule ID.", "zh_CN":"规则ID。"}
        self.id = id
        # {"en":"Control action,default value: INTERCEPT.
        # INTERCEPT: interception
        # MONITOR: Monitoring", "zh_CN":"控制动作，默认值：INTERCEPT。
        # INTERCEPT：拦截
        # MONITOR：监控"}
        self.control_action = control_action
        # {"en":"Time period.", "zh_CN":"限制时长。"}
        self.limit_duration = limit_duration
        # {"en":"Detailing unit. 
        # h: Hour
        # d: Day
        # w: Week
        # m: Month", "zh_CN":"时长单位。
        # h：小时
        # d：天
        # w：周
        # m：月"}
        self.limit_unit = limit_unit
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.policy_name = policy_name
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark
        # {"en":"Consumer quota threshold.", "zh_CN":"消费方配额阈值。"}
        self.threshold_value = threshold_value

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.control_action is not None:
            result['controlAction'] = self.control_action
        if self.limit_duration is not None:
            result['limitDuration'] = self.limit_duration
        if self.limit_unit is not None:
            result['limitUnit'] = self.limit_unit
        if self.policy_name is not None:
            result['policyName'] = self.policy_name
        if self.remark is not None:
            result['remark'] = self.remark
        if self.threshold_value is not None:
            result['thresholdValue'] = self.threshold_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('controlAction') is not None:
            self.control_action = m.get('controlAction')
        if m.get('limitDuration') is not None:
            self.limit_duration = m.get('limitDuration')
        if m.get('limitUnit') is not None:
            self.limit_unit = m.get('limitUnit')
        if m.get('policyName') is not None:
            self.policy_name = m.get('policyName')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('thresholdValue') is not None:
            self.threshold_value = m.get('thresholdValue')
        return self


class EditQuotaRuleResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: dict = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class EditQuotaRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditQuotaRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditQuotaRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditQuotaRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateKnownBotsSelectBotNamesBotPublicBotsDTO(TeaModel):
    def __init__(
        self,
        bot_category: str = None,
        select_bot_names: str = None,
    ):
        # {'en':'Known Bot category. 
        #  search_engine_bot: Search Engines
        #  marketing_analysis: Marketing Analysis
        #  site_monitor: Site Monitor
        #  feed_fetcher: Feed Fetcher
        #  tool: Practical Tools
        #  illegal_public_crawler: Illegal Known Bots
        #  other: Other Known Bots', 'zh_CN':'已知Bot类别。
        #  search_engine_bot：搜索引擎
        #  marketing_analysis：市场分析
        #  site_monitor：网站监控
        #  feed_fetcher：信息流聚合
        #  tool：实用工具
        #  illegal_public_crawler：非法的已知Bot
        #  other：其他已知Bot'}
        self.bot_category = bot_category
        # {'en':'Checked Bot subcategory values(Please refer to the documentation: Public Bot Dictionary), multiple separated by ; sign, an empty value means all are unchecked.', 'zh_CN':'勾选的Bot小类值(请参照说明文档：已知Bot字典)，多个以 ; 号分隔，值为空表示全部不勾选。'}
        self.select_bot_names = select_bot_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bot_category is not None:
            result['botCategory'] = self.bot_category
        if self.select_bot_names is not None:
            result['selectBotNames'] = self.select_bot_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('botCategory') is not None:
            self.bot_category = m.get('botCategory')
        if m.get('selectBotNames') is not None:
            self.select_bot_names = m.get('selectBotNames')
        return self


class UpdateKnownBotsSelectBotNamesRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        update_list: List[UpdateKnownBotsSelectBotNamesBotPublicBotsDTO] = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Modified Bot category data.', 'zh_CN':'修改的Bot类别数据。'}
        self.update_list = update_list

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.update_list, 'update_list')
        if self.update_list:
            for k in self.update_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.update_list is not None:
            result['updateList'] = []
            for k in self.update_list:
                result['updateList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('updateList') is not None:
            self.update_list = []
            for k in m.get('updateList'):
                temp_model = UpdateKnownBotsSelectBotNamesBotPublicBotsDTO()
                self.update_list.append(temp_model.from_map(k))
        return self


class UpdateKnownBotsSelectBotNamesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateKnownBotsSelectBotNamesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateKnownBotsSelectBotNamesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateKnownBotsSelectBotNamesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateKnownBotsSelectBotNamesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteWorkflowRuleRequest(TeaModel):
    def __init__(
        self,
        delete_list: List[str] = None,
    ):
        # {'en':'List of deleted rule ID.', 'zh_CN':'删除的规则ID列表。'}
        self.delete_list = delete_list

    def validate(self):
        self.validate_required(self.delete_list, 'delete_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_list is not None:
            result['deleteList'] = self.delete_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteList') is not None:
            self.delete_list = m.get('deleteList')
        return self


class DeleteWorkflowRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class DeleteWorkflowRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteWorkflowRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteWorkflowRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class DeleteWorkflowRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetBlockPageSettingRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {"en":"Domain, array.", "zh_CN":"域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class GetBlockPageSettingBlockPage(TeaModel):
    def __init__(
        self,
        switch_conf: int = None,
        status_code: str = None,
        content_type: str = None,
        response_content: str = None,
    ):
        # {"en":"Switch
        #     0: close
        #     1: open", "zh_CN":"开关。
        #     0：关
        #     1：开"}
        self.switch_conf = switch_conf
        # {"en":"Status code, default 403.", "zh_CN":"状态码，默认403。"}
        self.status_code = status_code
        # {"en":"Content-type, default text/html, support multiple,english half Angle comma splices.", "zh_CN":"Content-Type，默认text/html，多个以英文半角逗号分隔。"}
        self.content_type = content_type
        # {"en":"Customized response content.", "zh_CN":"自定义响应内容。"}
        self.response_content = response_content

    def validate(self):
        self.validate_required(self.switch_conf, 'switch_conf')
        self.validate_required(self.response_content, 'response_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.switch_conf is not None:
            result['switch'] = self.switch_conf
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.response_content is not None:
            result['responseContent'] = self.response_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('switch') is not None:
            self.switch_conf = m.get('switch')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('responseContent') is not None:
            self.response_content = m.get('responseContent')
        return self


class GetBlockPageSettingDomainInfo(TeaModel):
    def __init__(
        self,
        domain: str = None,
        block_page: GetBlockPageSettingBlockPage = None,
    ):
        # {"en":"Domain.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"Configuration for Block page setting.", "zh_CN":"自定义拦截页面配置"}
        self.block_page = block_page

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.block_page, 'block_page')
        if self.block_page:
            self.block_page.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.block_page is not None:
            result['blockPage'] = self.block_page.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('blockPage') is not None:
            temp_model = GetBlockPageSettingBlockPage()
            self.block_page = temp_model.from_map(m['blockPage'])
        return self


class GetBlockPageSettingResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: List[GetBlockPageSettingDomainInfo] = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message
        # {"en":"Return data.", "zh_CN":"返回值。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = GetBlockPageSettingDomainInfo()
                self.data.append(temp_model.from_map(k))
        return self


class GetBlockPageSettingPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBlockPageSettingParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBlockPageSettingRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBlockPageSettingResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateCustomRuleConditionDTO(TeaModel):
    def __init__(
        self,
        condition: str = None,
        match_type: str = None,
        condition_value: str = None,
    ):
        # {"en":"IP:0,IP_SEG:1,URI:4,URI_REGEX:5,USER_AGENT:6,USER_AGENT_REGEX:7,
        #                          AREA:8,HTTP_METHOD:9,REFERER:10,REFERER_REGEX:11,PROTOCOL:12,HTTP_HEADER:13,HTTP_HEADER_REGEX:14  
        #                          ",
        #                          'zh_CN':'IP:0,IP_SEG:1,URI:4, URI_REGEX:5, USER_AGENT:6, USER_AGENT_REGEX:7, AREA:8,HTTP_METHOD:9,
        #                          REFERER:10,REFERER_REGEX:11,PROTOCOL:12,HTTP_HEADER:13,
        #                          HTTP_HEADER_REGEX:14
        #                          '}
        self.condition = condition
        # {"en":"Not equal:0|Equal:1", "zh_CN":"不等于:0|等于:1"}
        self.match_type = match_type
        # {"en":"Condition value
        #                           1.When condition=0(IP) or condition=1(IP SEG)
        #                           Supports passing in multiple items at once,separate multiple items with semicolons.
        #                           2.When condition=4(URI) or condition=5(URI_REGEX)
        #                           Supports passing in multiple items at once,separate multiple items with semicolons.
        #                           3.When condition=6(USER_AGENT) or condition=7(USER_AGENT_REGEX)
        #                           Supports passing in multiple items at once, separate multiple items with semicolons.
        #                           4.When condition=8(area)
        #                           You need to pass in the ID corresponding to the region. Use semicolons to separate multiple regions. 
        #                           Refer to the API Center: https://www.wangsu.com/document/api-doc/Overview 8.Appendix description,countries,regions and provinces in Attached Table 1.
        #                           5.When condition=9(HTTP_METHOD)
        #                           Supports passing in multiple items at once, separate multiple items with semicolons.
        #                           Data dictionary (case sensitive)
        #                           GET/POST/HEAD/OPTIONS/PUT/DELETE/TRACE/CONNECT
        #                           6.When condition=10(REFERER) or condition=11(REFERER_REGEX)
        #                           Supports passing in multiple items at once,separate multiple items with semicolons.
        #                           7.When condition=12(PROTOCOL)
        #                           Supports passing in multiple items at once,separate multiple items with semicolons.
        #                           Data dictionary (case sensitive)
        #                           HTTP/HTTPS
        #                           8.When condition=13(HTTP_HEADER) or condition=14(HTTP_HEADER_REGEX)
        #                           At this time,the key and value of the HTTP Header need to be separated by colons for transmission.
        # 
        #                          ", "zh_CN":"匹配内容
        #                           1、当condition=0(IP)或者condition=1(IP段)
        #                           支持一次性传入多个，多个使用分号分隔
        #                           2、当condition=4(URI)或者condition=5(URI_REGEX)
        #                           支持一次性传入多个，多个使用分号分隔
        #                           3、当condition=6(USER_AGENT)或者condition=7(USER_AGENT_REGEX)
        #                           支持一次性传入多个，多个使用分号分隔
        #                           4、当condition=8(area)
        #                           需要传入区域对应ID，多个使用分号分隔。数据字典参考：
        #                           参考API中心：https://www.wangsu.com/document/api-doc/Overview 八、附录说明，附表1中的国家地区、省份。
        #                           5、当condition=9(HTTP_METHOD)
        #                           支持一次性传入多个，多个使用分号分隔
        #                           数据字典(区分大小写)：
        #                           GET、POST、HEAD、OPTIONS、PUT、DELETE、TRACE、CONNECT
        #                           6、当condition=10(REFERER)或者condition=11(REFERER_REGEX)
        #                           多个使用分号分隔
        #                           7、当condition=12(PROTOCOL)
        #                           支持一次性传输多个，多个使用分号分隔
        #                           数据字典(区分大小写)：
        #                           HTTP、HTTPS
        #                           8、当condition=13(HTTP_HEADER)或者condition=14(HTTP_HEADER_REGEX)
        #                           此时需要把HTTP Header的key和value用冒号分隔进行传输
        #                          "}
        self.condition_value = condition_value

    def validate(self):
        self.validate_required(self.condition, 'condition')
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.condition_value, 'condition_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.condition_value is not None:
            result['conditionValue'] = self.condition_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            self.condition = m.get('condition')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('conditionValue') is not None:
            self.condition_value = m.get('conditionValue')
        return self


class UpdateCustomRuleDataDTO(TeaModel):
    def __init__(
        self,
        rule_name: str = None,
        desc: str = None,
        conditions: List[UpdateCustomRuleConditionDTO] = None,
        apply_limit: 'UpdateCustomRuleApplyLimitDTO' = None,
        trigger_condition: 'UpdateCustomRuleTriggerConditionDTO' = None,
        action: str = None,
        action_duration: str = None,
        friendly_url: str = None,
        get_rule: str = None,
        get_second_rule: str = None,
        get_second_rule_condition: str = None,
        post_rule: str = None,
    ):
        # {"en":"Rule name", "zh_CN":"规则名称"}
        self.rule_name = rule_name
        # {"en":"Rule description", "zh_CN":"规则描述"}
        self.desc = desc
        # {'en':'Matching Conditions(Parameter description: When the matching condition is HTTP Header or HTTP Header Regex, 
        #                         the HTTP header and value need to be assembled using colons. Multiple values of other matching conditions are directly separated by semicolons for transmission.)', 'zh_CN':'匹配条件(参数说明：当匹配条件为HTTP Header
        #                         或者HTTP Header Regex时，Http header首部以及value需要使用冒号进行组装。其他匹配条件多个值直接使用分号分隔传输)'}
        self.conditions = conditions
        # {'en':'Statistical Granularity
        #            1. When the statistical granularity is Cookie
        #            	  limitKey and limitValue do not need to be passed as parameters.
        #            2. When the statistical granularity is Cookie or HTTP Header
        #                limitKey: Customer customized.
        #                limitValue: Currently there is only one value,0(Requests without keys will not be counted).
        #            3. When the statistical granularity is IP Cookie or IP HTTP Header
        #                limitKey: Customer customized
        #                limitValue: optional value,0(Requests without keys will not be counted),1(No key value and IP granular protection),Can only choose one.
        #            ', 
        #            'zh_CN':'统计粒度:
        #            1、当统计粒度为Cookie
        #            		limitKey和limitValue不需要传入
        #            2、当统计粒度为Cookie或者HTTP Header时
        #            	    limitKey: 客户自定义
        #                 limitValue: 当前只有一个值: 0(无Key值不防护)
        #            3、当统计粒度为IP Cookie或者IP HTTP Header
        #                 limitKey: 客户自定义
        #                 limitValue可选值：0(无key值不防护)，1(无key值以IP粒度防护),单选且必须选一个
        #            '}
        self.apply_limit = apply_limit
        # {'en':'Trigger Condition', 'zh_CN':'触发条件'}
        self.trigger_condition = trigger_condition
        # {'en':'action,0:Block,1:Log,2:Reset,3:Human Interaction Challenge,4:Redirect
        #            1:When the processing action is BLOCK, LOG, DROP
        #               friendlyUrl, getRule, getSecondRule, getSecondRuleCondition, postRule are invalid and can be omitted
        #            2:When the processing action is human-machine verification
        #               getRule and postRule must select at least one
        #               a)When getRule=null
        #                 At this time, getSecondRule and getSecondRuleCondition are invalid, postRule must be passed, and the transmission content is the postRule dictionary value.
        #               b)When getRule=0(UrlCookie Validation+302 Redirection) or getRule=1(Cookie Validation+302 Redirection)
        #                 getSecondRule and getSecondRuleCondition are invalid, postRule can choose empty or the dictionary value of postRule
        #               c)When getRule=2(UrlCookie Validation+JS Redirection) or getRule=3(Cookie Validation + JS Redirection) or getRule=4(Cookie Validation+Meta-JS Redirection) or getRule=5(Cookie Validation+JS Mouse Monitor)
        #                 getSecondRule and getSecondRuleCondition must be passed, postRule can choose empty or the dictionary value of postRule
        #            3:When the processing action is Redirect
        #               friendlyUrl is a required parameter
        #               The attributes getRule, getSecondRule, getSecondRuleCondition, and postRule are invalid and do not need to be passed.
        #            ', 
        #            'zh_CN':'动作 0:拦截，1:告警，2:断开连接，3:人机校验,4:跳转友好页面
        #            1、当处理动作为BLOCK、LOG、DROP时
        #               friendlyUrl, getRule, getSecondRule, getSecondRuleCondition, postRule这几个属性无效，不用传
        #            2、当处理动作为人机校验
        #               getRule和postRule必须至少选择一项
        #               a)当getRule=空
        #                 此时，getSecondRule和getSecondRuleCondition无效不用传，postRule必须传，传输内容为postRule字典值
        #               a)当getRule=0(UrlCookie参数验证+302跳转)或者getRule=1(Cookie参数验证+302跳转)
        #                 getSecondRule和getSecondRuleCondition无效不用传，postRule可以选择空或者postRule的字典值
        #               b)当getRule=2(UrlCookie参数验证+JS跳转)或者getRule=3(Cookie参数验证+JS跳转)或者getRule=4(Cookie参数验证+Meta-JS跳转)或者getRule=5(Cookie参数验证+JS鼠标监听)
        #                 getSecondRule和getSecondRuleCondition为必传，postRule可以选择空或者postRule的字典值
        #            3、当处理动作为跳转友好页面
        #               friendlyUrl为必传参数
        #               getRule, getSecondRule, getSecondRuleCondition, postRule这几个属性无效，不用传
        #            '}
        self.action = action
        # {'en':'Action expires after,in minutes', 'zh_CN':'处理动作持续时间,单位秒'}
        self.action_duration = action_duration
        # {'en':'URL setting for the redirect page', 'zh_CN':'跳转友好页面地址'}
        self.friendly_url = friendly_url
        # {'en':'GET Flood Rule,0:UrlCookie Validation+302 Redirection,1:Cookie Validation+302 Redirection,2:UrlCookie Validation+JS Redirection,
        #     3:Cookie Validation + JS Redirection,4:Cookie Validation+Meta-JS Redirection,5:Cookie Validation+JS Mouse Monitor', 
        #            'zh_CN':'GET Flood第一策略,0:UrlCookie参数验证+302跳转,1:Cookie参数验证+302跳转,2:UrlCookie参数验证+JS跳转,3:Cookie参数验证+JS跳转,4:Cookie参数验证+Meta-JS跳转,5:Cookie参数验证+JS鼠标监听'}
        self.get_rule = get_rule
        # {'en':'GET Flood Second Rule,0:UrlCookie Verification + 302 Redirection,1:Cookie Verification + 302 Redirection', 
        #            'zh_CN':'GET Flood第二策略,0:UrlCookie参数验证+302跳转，1：Cookie参数验证+302跳转'}
        self.get_second_rule = get_second_rule
        # {'en':'2nd Rule Enable Condition,0:Non-html Request(Accept!=text/*|text/htm),1:Non-html Request & Static URI Sufix)', 
        #            'zh_CN':'第二策略启用条件,0:非html请求，1：非html请求且URI后缀是静态文件'}
        self.get_second_rule_condition = get_second_rule_condition
        # {"en":"0:Cookie Validation+JS Redirection,1:Cookie Validation + 307 Redirection", "zh_CN":"0:Cookie参数验证+JS跳转,1:Cookie参数验证+307跳转"}
        self.post_rule = post_rule

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.conditions, 'conditions')
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()
        self.validate_required(self.apply_limit, 'apply_limit')
        if self.apply_limit:
            self.apply_limit.validate()
        self.validate_required(self.trigger_condition, 'trigger_condition')
        if self.trigger_condition:
            self.trigger_condition.validate()
        self.validate_required(self.action, 'action')
        self.validate_required(self.action_duration, 'action_duration')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.desc is not None:
            result['desc'] = self.desc
        if self.conditions is not None:
            result['conditions'] = []
            for k in self.conditions:
                result['conditions'].append(k.to_map() if k else None)
        if self.apply_limit is not None:
            result['applyLimit'] = self.apply_limit.to_map()
        if self.trigger_condition is not None:
            result['triggerCondition'] = self.trigger_condition.to_map()
        if self.action is not None:
            result['action'] = self.action
        if self.action_duration is not None:
            result['actionDuration'] = self.action_duration
        if self.friendly_url is not None:
            result['friendlyUrl'] = self.friendly_url
        if self.get_rule is not None:
            result['getRule'] = self.get_rule
        if self.get_second_rule is not None:
            result['getSecondRule'] = self.get_second_rule
        if self.get_second_rule_condition is not None:
            result['getSecondRuleCondition'] = self.get_second_rule_condition
        if self.post_rule is not None:
            result['postRule'] = self.post_rule
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('conditions') is not None:
            self.conditions = []
            for k in m.get('conditions'):
                temp_model = UpdateCustomRuleConditionDTO()
                self.conditions.append(temp_model.from_map(k))
        if m.get('applyLimit') is not None:
            temp_model = UpdateCustomRuleApplyLimitDTO()
            self.apply_limit = temp_model.from_map(m['applyLimit'])
        if m.get('triggerCondition') is not None:
            temp_model = UpdateCustomRuleTriggerConditionDTO()
            self.trigger_condition = temp_model.from_map(m['triggerCondition'])
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('actionDuration') is not None:
            self.action_duration = m.get('actionDuration')
        if m.get('friendlyUrl') is not None:
            self.friendly_url = m.get('friendlyUrl')
        if m.get('getRule') is not None:
            self.get_rule = m.get('getRule')
        if m.get('getSecondRule') is not None:
            self.get_second_rule = m.get('getSecondRule')
        if m.get('getSecondRuleCondition') is not None:
            self.get_second_rule_condition = m.get('getSecondRuleCondition')
        if m.get('postRule') is not None:
            self.post_rule = m.get('postRule')
        return self


class UpdateCustomRuleRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        data: List[UpdateCustomRuleDataDTO] = None,
    ):
        # {"en":"domain", "zh_CN":"域名"}
        self.domain = domain
        # {"en":"data", "zh_CN":"数据列表"}
        self.data = data

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = UpdateCustomRuleDataDTO()
                self.data.append(temp_model.from_map(k))
        return self


class UpdateCustomRuleApplyLimitDTO(TeaModel):
    def __init__(
        self,
        limit: str = None,
        limit_key: str = None,
        limit_value: str = None,
    ):
        # {"en":"IP:0,IP+UA:1,Cookie:2,IP+Cookie:3,HTTP Header:4,IP+HTTP Header:5", "zh_CN":"IP:0, IP+UA:1, Cookie:2, IP+Cookie:3, HTTP Header:4,IP+HTTP Header:5"}
        self.limit = limit
        # {"en":"Limit key", "zh_CN":"键"}
        self.limit_key = limit_key
        # {"en":"Limit value", "zh_CN":"值"}
        self.limit_value = limit_value

    def validate(self):
        self.validate_required(self.limit, 'limit')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limit is not None:
            result['limit'] = self.limit
        if self.limit_key is not None:
            result['limitKey'] = self.limit_key
        if self.limit_value is not None:
            result['limitValue'] = self.limit_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('limitKey') is not None:
            self.limit_key = m.get('limitKey')
        if m.get('limitValue') is not None:
            self.limit_value = m.get('limitValue')
        return self


class UpdateCustomRuleTriggerConditionDTO(TeaModel):
    def __init__(
        self,
        second: str = None,
        request: str = None,
    ):
        # {'en':'Statistical period, in seconds', 'zh_CN':'统计周期，单位秒'}
        self.second = second
        # {'en':'Requests', 'zh_CN':'请求数'}
        self.request = request

    def validate(self):
        self.validate_required(self.second, 'second')
        self.validate_required(self.request, 'request')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.second is not None:
            result['second'] = self.second
        if self.request is not None:
            result['request'] = self.request
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('second') is not None:
            self.second = m.get('second')
        if m.get('request') is not None:
            self.request = m.get('request')
        return self


class UpdateCustomRuleResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
    ):
        # {"en":"code", "zh_CN":"返回code"}
        self.code = code
        # {"en":"msg", "zh_CN":"返回描述信息"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateCustomRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCustomRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCustomRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCustomRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class CreatRateLimitingRuleRateLimitEffective(TeaModel):
    def __init__(
        self,
        effective: List[str] = None,
        start: str = None,
        end: str = None,
        timezone: str = None,
    ):
        # {'en':'Effective.
        # MON:Monday
        # TUE:Tuesday
        # WED:Wednesday
        # THU:Thursday
        # FRI:Friday
        # SAT:Saturday
        # SUN:Sunday', 'zh_CN':'周期。
        # MON：星期一
        # TUE：星期二
        # WED：星期三
        # THU：星期四
        # FRI：星期五
        # SAT：星期六
        # SUN：星期天'}
        self.effective = effective
        # {'en':'Start time, format: HH:mm.', 'zh_CN':'开始时间，格式：HH:mm。'}
        self.start = start
        # {'en':'End time, format: HH:mm.', 'zh_CN':'结束时间，格式：HH:mm。'}
        self.end = end
        # {'en':'Timezone,default value: GTM+8.', 'zh_CN':'时区，默认：GTM+8。','dictionary':'belong=WAAP-MS-Ext|dict=waap_timezone'}
        self.timezone = timezone

    def validate(self):
        self.validate_required(self.effective, 'effective')
        self.validate_required(self.start, 'start')
        self.validate_required(self.end, 'end')
        self.validate_required(self.timezone, 'timezone')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effective is not None:
            result['effective'] = self.effective
        if self.start is not None:
            result['start'] = self.start
        if self.end is not None:
            result['end'] = self.end
        if self.timezone is not None:
            result['timezone'] = self.timezone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('effective') is not None:
            self.effective = m.get('effective')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('end') is not None:
            self.end = m.get('end')
        if m.get('timezone') is not None:
            self.timezone = m.get('timezone')
        return self


class CreatRateLimitingRuleIpOrIpsCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ip_or_ips: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'IP/CIDR, maximum 500 IP/CIDR.', 'zh_CN':'IP/IP段，最多500个IP/IP段。'}
        self.ip_or_ips = ip_or_ips

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ip_or_ips, 'ip_or_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ip_or_ips is not None:
            result['ipOrIps'] = self.ip_or_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ipOrIps') is not None:
            self.ip_or_ips = m.get('ipOrIps')
        return self


class CreatRateLimitingRulePathCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        paths: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, path case sensitive
        # NOT_EQUAL: Does not equal, path case sensitive
        # CONTAIN: Contains, path case insensitive
        # NOT_CONTAIN: Does not Contains, path case insensitive
        # REGEX: Regex match, path case insensitive
        # NOT_REGEX: Regular does not match, path case sensitive
        # START_WITH: Starts with, path case sensitive
        # END_WITH: Ends with, path case sensitive
        # WILDCARD: Wildcard matches, path case sensitive, ** represents zero or more arbitrary characters, ? represents any single character.
        # NOT_WILDCARD: Wildcard does not match, path case sensitive, ** represents zero or more arbitrary characters, ? represents any single character ", "zh_CN":"匹配类型。
        # EQUAL：等于，路径大小写敏感
        # NOT_EQUAL：不等于，路径大小写敏感
        # CONTAIN：包含，路径大小写不敏感
        # NOT_CONTAIN：不包含，路径大小写不敏感
        # REGEX：匹配正则，路径大小写不敏感
        # NOT_REGEX：正则不匹配，路径大小写不敏感
        # START_WITH：开头是，路径大小写不敏感
        # END_WITH：结尾是，路径大小写不敏感
        # WILDCARD：通配符匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Path.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, path needs to start with "/", and no parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: /test.html.', 'zh_CN':'路径。
        # 当匹配类型为等于/不等于/开头是/结尾是，路径必须以“/”开头，不含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html。'}
        self.paths = paths

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.paths, 'paths')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.paths is not None:
            result['paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paths') is not None:
            self.paths = m.get('paths')
        return self


class CreatRateLimitingRuleUriCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        uri: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, URI case sensitive
        # NOT_EQUAL: Does not equal, URI case sensitive
        # CONTAIN: Contains, URI case insensitive
        # NOT_CONTAIN: Does not Contains, URI case insensitive
        # REGEX: Regex match, URI case insensitive
        # NOT_REGEX: Regular does not match, URI case insensitive
        # START_WITH: Starts with, URI case insensitive
        # END_WITH: Ends with, URI case insensitive
        # WILDCARD: Wildcard matches, URI case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, URI case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，URI大小写敏感
        # NOT_EQUAL：不等于，URI大小写敏感
        # CONTAIN：包含，URI大小写不敏感
        # NOT_CONTAIN：不包含，URI大小写不敏感
        # REGEX：匹配正则，URI大小写不敏感
        # NOT_REGEX：正则不匹配，URI大小写不敏感
        # START_WITH：开头是，URI大小写不敏感
        # END_WITH：结尾是，URI大小写不敏感
        # WILDCARD：通配符匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'URI.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, uri needs to start with "/", and includes parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: /test.html?id=1.', 'zh_CN':'URI。
        # 当匹配类型为等于/不等于/开头是/结尾是，URI必须以”/“开头，含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html?id=1。'}
        self.uri = uri

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.uri, 'uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class CreatRateLimitingRuleUriParamCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        param_name: str = None,
        param_value: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals,param value case sensitive
        # NOT_EQUAL:Does not equal,param value case sensitive
        # CONTAIN:Contains,param value case insensitive
        # NOT_CONTAIN:Does not contains,param value case insensitive
        # REGEX:Regex match,param value case insensitive
        # NONE:Empty or non-existent', 'zh_CN':'匹配类型。
        # EQUAL：等于，参数值大小写敏感
        # NOT_EQUAL：不等于，参数值大小写敏感
        # CONTAIN：包含，参数值大小写不敏感
        # NOT_CONTAIN：不包含，参数值大小写不敏感
        # REGEX：正则，参数值大小写不敏感
        # NONE：为空或不存在'}
        self.match_type = match_type
        # {'en':'Param name,case sensitive,maximum 100 characters.
        # Example: id.', 'zh_CN':'参数名，大小写敏感，最多100个字符。
        # 示例：id。'}
        self.param_name = param_name
        # {'en':'Param value.', 'zh_CN':'参数值。'}
        self.param_value = param_value

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.param_name, 'param_name')
        self.validate_required(self.param_value, 'param_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.param_name is not None:
            result['paramName'] = self.param_name
        if self.param_value is not None:
            result['paramValue'] = self.param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paramName') is not None:
            self.param_name = m.get('paramName')
        if m.get('paramValue') is not None:
            self.param_value = m.get('paramValue')
        return self


class CreatRateLimitingRuleUaCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ua: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, user agent case sensitive
        # NOT_EQUAL: Does not equal, user agent case sensitive
        # CONTAIN: Contains, user agent case insensitive
        # NOT_CONTAIN: Does not Contains, user agent case insensitive
        # NONE:Empty or non-existent
        # REGEX: Regex match, user agent case insensitive
        # NOT_REGEX: Regular does not match, user agent case insensitive
        # START_WITH: Starts with, user agent case insensitive
        # END_WITH: Ends with, user agent case insensitive
        # WILDCARD: Wildcard matches, user agent case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, user agent case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，User-Agent大小写敏感
        # NOT_EQUAL：不等于，User-Agent大小写敏感
        # CONTAIN：包含，User-Agent大小写不敏感
        # NOT_CONTAIN：不包含，User-Agent大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，User-Agent大小写不敏感
        # NOT_REGEX：正则不匹配，User-Agent大小写不敏感
        # START_WITH：开头是，User-Agent大小写不敏感
        # END_WITH：结尾是，User-Agent大小写不敏感
        # WILDCARD：通配符匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'User agent.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: go-Http-client/1.1.', 'zh_CN':'User-Agent。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：go-Http-client/1.1。'}
        self.ua = ua

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ua, 'ua')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ua is not None:
            result['ua'] = self.ua
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ua') is not None:
            self.ua = m.get('ua')
        return self


class CreatRateLimitingRuleRequestMethodCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        request_method: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Request method.
        # Supported values: GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY.', 'zh_CN':'请求方法。
        # 支持的值：GET/POST/DELETE/PUT/HEAD/OPTIONS/COPY。'}
        self.request_method = request_method

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.request_method, 'request_method')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        return self


class CreatRateLimitingRuleRefererCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        referer: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, referer case sensitive
        # NOT_EQUAL: Does not equal, referer case sensitive
        # CONTAIN: Contains, referer case insensitive
        # NOT_CONTAIN: Does not Contains, referer case insensitive
        # NONE:Empty or non-existent
        # REGEX: Regex match, referer case insensitive
        # NOT_REGEX: Regular does not match, referer case insensitive
        # START_WITH: Starts with, referer case insensitive
        # END_WITH: Ends with, referer case insensitive
        # WILDCARD: Wildcard matches, referer case insensitive, ** represents zero or more arbitrary characters, ? represents any single characte
        # NOT_WILDCARD: Wildcard does not match, referer case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，referer大小写敏感
        # NOT_EQUAL：不等于，referer大小写敏感
        # CONTAIN：包含，referer大小写不敏感
        # NOT_CONTAIN：不包含，referer大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，referer大小写不敏感
        # NOT_REGEX：正则不匹配，referer大小写不敏感
        # START_WITH：开头是，referer大小写不敏感
        # END_WITH：结尾是，referer大小写不敏感
        # WILDCARD：通配符匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Referer.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: http://test.com.', 'zh_CN':'Referer。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：http://test.com。'}
        self.referer = referer

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.referer, 'referer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.referer is not None:
            result['referer'] = self.referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('referer') is not None:
            self.referer = m.get('referer')
        return self


class CreatRateLimitingRuleHeaderCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        key: str = None,
        value_list: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, request header values case sensitive
        # NOT_EQUAL: Does not equal, request header values case sensitive
        # CONTAIN: Contains, request header values case insensitive
        # NOT_CONTAIN: Does not Contains, request header values case insensitive
        # NONE: Empty or non-existent
        # REGEX: Regex match, request header values case insensitive
        # NOT_REGEX: Regular does not match, request header values case insensitive
        # START_WITH: Starts with, request header values case insensitive
        # END_WITH: Ends with, request header values case insensitive
        # WILDCARD: Wildcard matches, request header values case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, request header values case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，头部值大小写敏感
        # NOT_EQUAL：不等于，头部值大小写敏感
        # CONTAIN：包含，头部值大小写不敏感
        # NOT_CONTAIN：不包含，头部值大小写不敏感
        # NONE：为空或不存在
        # REGEX：匹配正则，头部值大小写不敏感
        # NOT_REGEX：正则不匹配，头部值大小写不敏感
        # START_WITH：开头是，头部值大小写不敏感
        # END_WITH：结尾是，头部值大小写不敏感
        # WILDCARD：通配符匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Header name,case insensitive,up to 100 characters.
        # Example: Accept.', 'zh_CN':'头部名称，大小写不敏感，最多100个字符。
        # 示例：Accept。'}
        self.key = key
        # {'en':'Header value.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.', 'zh_CN':'头部值。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。'}
        self.value_list = value_list

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.key, 'key')
        self.validate_required(self.value_list, 'value_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.key is not None:
            result['key'] = self.key
        if self.value_list is not None:
            result['valueList'] = self.value_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('valueList') is not None:
            self.value_list = m.get('valueList')
        return self


class CreatRateLimitingRuleAreaCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        areas: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Geo.', 'zh_CN':'区域。','dictionary':'belong=WAAP-MS-Ext|dict=waap_areaCityAndCountry'}
        self.areas = areas

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.areas, 'areas')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.areas is not None:
            result['areas'] = self.areas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('areas') is not None:
            self.areas = m.get('areas')
        return self


class CreatRateLimitingRuleStatusCodeCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        status_code: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'Response Code.', 'zh_CN':'状态码。'}
        self.status_code = status_code

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.status_code, 'status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        return self


class CreatRateLimitingRuleSchemeCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        scheme: List[str] = None,
    ):
        # {'en':'Match type.
        # EQUAL:Equals
        # NOT_EQUAL:Does not equal', 'zh_CN':'匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于'}
        self.match_type = match_type
        # {'en':'HTTP/S.
        # Supported values: HTTP/HTTPS.', 'zh_CN':'应用层协议。
        # 支持的值：HTTP/HTTPS。'}
        self.scheme = scheme

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.scheme, 'scheme')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.scheme is not None:
            result['scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('scheme') is not None:
            self.scheme = m.get('scheme')
        return self


class CreatRateLimitingRuleRateLimitRuleCondition(TeaModel):
    def __init__(
        self,
        ip_or_ips_conditions: List[CreatRateLimitingRuleIpOrIpsCondition] = None,
        path_conditions: List[CreatRateLimitingRulePathCondition] = None,
        uri_conditions: List[CreatRateLimitingRuleUriCondition] = None,
        uri_param_conditions: List[CreatRateLimitingRuleUriParamCondition] = None,
        ua_conditions: List[CreatRateLimitingRuleUaCondition] = None,
        method_conditions: List[CreatRateLimitingRuleRequestMethodCondition] = None,
        referer_conditions: List[CreatRateLimitingRuleRefererCondition] = None,
        header_conditions: List[CreatRateLimitingRuleHeaderCondition] = None,
        area_conditions: List[CreatRateLimitingRuleAreaCondition] = None,
        status_code_conditions: List[CreatRateLimitingRuleStatusCodeCondition] = None,
        scheme_conditions: List[CreatRateLimitingRuleSchemeCondition] = None,
    ):
        # {'en':'IP/CIDR, match type cannot be repeated.', 'zh_CN':'IP/IP段，匹配类型不可重复。'}
        self.ip_or_ips_conditions = ip_or_ips_conditions
        # {'en':'Path, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.', 'zh_CN':'路径，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。'}
        self.path_conditions = path_conditions
        # {'en':'URI, match type cannot be repeated.
        # 
        # When the business scenario is API, this matching condition is not supported.', 'zh_CN':'URI，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。'}
        self.uri_conditions = uri_conditions
        # {'en':'URI ParameterI, match type cannot be repeated.
        # When the business scenario is API, this matching condition is not supported.', 'zh_CN':'URI参数，匹配类型不可重复。
        # 当业务场景为网站业务时不支持此匹配条件。'}
        self.uri_param_conditions = uri_param_conditions
        # {'en':'User Agent, match type cannot be repeated.', 'zh_CN':'User-Agent，匹配类型不可重复。'}
        self.ua_conditions = ua_conditions
        # {'en':'Request Method.
        # When the business scenario is API,this matching condition is not supported.', 'zh_CN':'请求方法，匹配类型不可重复。
        # 当业务场景为API业务时不支持此匹配条件。'}
        self.method_conditions = method_conditions
        # {'en':'Referer, match type cannot be repeated.', 'zh_CN':'Referer，匹配类型不可重复。'}
        self.referer_conditions = referer_conditions
        # {'en':'Request Header, match type can be repeated.', 'zh_CN':'请求头，匹配类型可重复。'}
        self.header_conditions = header_conditions
        # {'en':'Geo,match type cannot be repeated.', 'zh_CN':'区域，匹配类型不可重复。'}
        self.area_conditions = area_conditions
        # {'en':'Response Code, match type cannot be repeated.', 'zh_CN':'状态码，匹配类型不可重复。'}
        self.status_code_conditions = status_code_conditions
        # {'en':'HTTP/S, match type cannot be repeated.', 'zh_CN':'应用层协议，匹配类型不可重复。'}
        self.scheme_conditions = scheme_conditions

    def validate(self):
        if self.ip_or_ips_conditions:
            for k in self.ip_or_ips_conditions:
                if k:
                    k.validate()
        if self.path_conditions:
            for k in self.path_conditions:
                if k:
                    k.validate()
        if self.uri_conditions:
            for k in self.uri_conditions:
                if k:
                    k.validate()
        if self.uri_param_conditions:
            for k in self.uri_param_conditions:
                if k:
                    k.validate()
        if self.ua_conditions:
            for k in self.ua_conditions:
                if k:
                    k.validate()
        if self.method_conditions:
            for k in self.method_conditions:
                if k:
                    k.validate()
        if self.referer_conditions:
            for k in self.referer_conditions:
                if k:
                    k.validate()
        if self.header_conditions:
            for k in self.header_conditions:
                if k:
                    k.validate()
        if self.area_conditions:
            for k in self.area_conditions:
                if k:
                    k.validate()
        if self.status_code_conditions:
            for k in self.status_code_conditions:
                if k:
                    k.validate()
        if self.scheme_conditions:
            for k in self.scheme_conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_or_ips_conditions is not None:
            result['ipOrIpsConditions'] = []
            for k in self.ip_or_ips_conditions:
                result['ipOrIpsConditions'].append(k.to_map() if k else None)
        if self.path_conditions is not None:
            result['pathConditions'] = []
            for k in self.path_conditions:
                result['pathConditions'].append(k.to_map() if k else None)
        if self.uri_conditions is not None:
            result['uriConditions'] = []
            for k in self.uri_conditions:
                result['uriConditions'].append(k.to_map() if k else None)
        if self.uri_param_conditions is not None:
            result['uriParamConditions'] = []
            for k in self.uri_param_conditions:
                result['uriParamConditions'].append(k.to_map() if k else None)
        if self.ua_conditions is not None:
            result['uaConditions'] = []
            for k in self.ua_conditions:
                result['uaConditions'].append(k.to_map() if k else None)
        if self.method_conditions is not None:
            result['methodConditions'] = []
            for k in self.method_conditions:
                result['methodConditions'].append(k.to_map() if k else None)
        if self.referer_conditions is not None:
            result['refererConditions'] = []
            for k in self.referer_conditions:
                result['refererConditions'].append(k.to_map() if k else None)
        if self.header_conditions is not None:
            result['headerConditions'] = []
            for k in self.header_conditions:
                result['headerConditions'].append(k.to_map() if k else None)
        if self.area_conditions is not None:
            result['areaConditions'] = []
            for k in self.area_conditions:
                result['areaConditions'].append(k.to_map() if k else None)
        if self.status_code_conditions is not None:
            result['statusCodeConditions'] = []
            for k in self.status_code_conditions:
                result['statusCodeConditions'].append(k.to_map() if k else None)
        if self.scheme_conditions is not None:
            result['schemeConditions'] = []
            for k in self.scheme_conditions:
                result['schemeConditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipOrIpsConditions') is not None:
            self.ip_or_ips_conditions = []
            for k in m.get('ipOrIpsConditions'):
                temp_model = CreatRateLimitingRuleIpOrIpsCondition()
                self.ip_or_ips_conditions.append(temp_model.from_map(k))
        if m.get('pathConditions') is not None:
            self.path_conditions = []
            for k in m.get('pathConditions'):
                temp_model = CreatRateLimitingRulePathCondition()
                self.path_conditions.append(temp_model.from_map(k))
        if m.get('uriConditions') is not None:
            self.uri_conditions = []
            for k in m.get('uriConditions'):
                temp_model = CreatRateLimitingRuleUriCondition()
                self.uri_conditions.append(temp_model.from_map(k))
        if m.get('uriParamConditions') is not None:
            self.uri_param_conditions = []
            for k in m.get('uriParamConditions'):
                temp_model = CreatRateLimitingRuleUriParamCondition()
                self.uri_param_conditions.append(temp_model.from_map(k))
        if m.get('uaConditions') is not None:
            self.ua_conditions = []
            for k in m.get('uaConditions'):
                temp_model = CreatRateLimitingRuleUaCondition()
                self.ua_conditions.append(temp_model.from_map(k))
        if m.get('methodConditions') is not None:
            self.method_conditions = []
            for k in m.get('methodConditions'):
                temp_model = CreatRateLimitingRuleRequestMethodCondition()
                self.method_conditions.append(temp_model.from_map(k))
        if m.get('refererConditions') is not None:
            self.referer_conditions = []
            for k in m.get('refererConditions'):
                temp_model = CreatRateLimitingRuleRefererCondition()
                self.referer_conditions.append(temp_model.from_map(k))
        if m.get('headerConditions') is not None:
            self.header_conditions = []
            for k in m.get('headerConditions'):
                temp_model = CreatRateLimitingRuleHeaderCondition()
                self.header_conditions.append(temp_model.from_map(k))
        if m.get('areaConditions') is not None:
            self.area_conditions = []
            for k in m.get('areaConditions'):
                temp_model = CreatRateLimitingRuleAreaCondition()
                self.area_conditions.append(temp_model.from_map(k))
        if m.get('statusCodeConditions') is not None:
            self.status_code_conditions = []
            for k in m.get('statusCodeConditions'):
                temp_model = CreatRateLimitingRuleStatusCodeCondition()
                self.status_code_conditions.append(temp_model.from_map(k))
        if m.get('schemeConditions') is not None:
            self.scheme_conditions = []
            for k in m.get('schemeConditions'):
                temp_model = CreatRateLimitingRuleSchemeCondition()
                self.scheme_conditions.append(temp_model.from_map(k))
        return self


class CreatRateLimitingRuleRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_name: str = None,
        description: str = None,
        scene: str = None,
        statistical_item: str = None,
        statistics_key: str = None,
        statistical_period: int = None,
        trigger_threshold: int = None,
        intercept_time: int = None,
        effective_status: str = None,
        rate_limit_effective: CreatRateLimitingRuleRateLimitEffective = None,
        asset_api_id: str = None,
        action: str = None,
        rate_limit_rule_condition: CreatRateLimitingRuleRateLimitRuleCondition = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Rule Name, maximum 50 characters.
        # Does not support special characters and spaces.', 'zh_CN':'规则名称，最多50个字符。
        # 不支持特殊字符和空格。'}
        self.rule_name = rule_name
        # {'en':'Description, maximum 200 characters.', 'zh_CN':'规则描述，最多200个字符。'}
        self.description = description
        # {'en':'Protected target.
        # WEB:Website
        # API:API', 'zh_CN':'业务场景。
        # WEB：网站业务
        # API：API业务'}
        self.scene = scene
        # {'en':'Client identifier.
        # IP:Client IP
        # IP_UA:Client IP and User-Agent
        # COOKIE:Cookie
        # IP_COOKIE:Client IP and Cookie
        # HEADER:Request Header
        # When there is a status code in the matching condition,this client identifier is not supported.
        # IP_HEADER:Client IP and Request Header
        # When there is a status code in the matching condition,this client identifier is not supported .', 'zh_CN':'统计粒度。
        # IP：客户端IP
        # IP_UA：客户端IP和User-Agent
        # COOKIE：Cookie
        # IP_COOKIE：客户端IP和Cookie
        # HEADER：请求头，当匹配条件中存在状态码时不支持此统计粒度
        # IP_HEADER：客户端IP和请求头，当匹配条件中存在状态码时不支持此统计粒度'}
        self.statistical_item = statistical_item
        # {'en':'Statistical key value.
        # When the client identifier is cookie/header value, the corresponding key value needs to be entered.', 'zh_CN':'统计key值。
        # 当统计粒度cookie/header值，需要输入对应的key值。'}
        self.statistics_key = statistics_key
        # {'en':'Statistics period, unit: seconds, the range is 1 - 3600.', 'zh_CN':'统计周期，单位：秒，范围为 1 - 3600。'}
        self.statistical_period = statistical_period
        # {'en':'Trigger threshold, unit: times.', 'zh_CN':'触发阈值，单位：次。'}
        self.trigger_threshold = trigger_threshold
        # {'en':'Action duration, unit: seconds, the range is 10 - 604800.', 'zh_CN':'处理动作持续时间，单位：秒，范围为 10 - 604800。'}
        self.intercept_time = intercept_time
        # {'en':'Cycle effective status.
        # PERMANENT:All time
        # WITHOUT:Excluded time
        # WITHIN:Selected time', 'zh_CN':'周期生效状态。
        # PERMANENT：永久生效
        # WITHOUT：周期内不生效
        # WITHIN：周期内生效'}
        self.effective_status = effective_status
        # {'en':'Effective time period.When the effective status is effective within the cycle or not effective within the cycle, this field must have a value.', 'zh_CN':'规则生效周期。
        # 生效状态为周期内生效或周期内不生效时，此字段必须有值。'}
        self.rate_limit_effective = rate_limit_effective
        # {'en':'API ID under API business, multiple separated by ; sign.
        # When the protected target is APIThis field is required.', 'zh_CN':'API业务下的API ID，多个用 ; 隔开。
        # 当业务场景为API业务时此字段必填。'}
        self.asset_api_id = asset_api_id
        # {'en':'Action.
        # NO_USE:Not Used
        # LOG:Log
        # COOKIE:Cookie verification
        # JS_CHECK:Javascript verification
        # DELAY:Delay
        # BLOCK:Deny
        # RESET:Reset Connection
        # Custom response ID:Custom response ID
        # When there is a status code in the matching condition, the supported actions are Log, Deny, NO_USE, and Reset, Connection.', 'zh_CN':'处理动作。
        # NO_USE：不使用
        # LOG：监控
        # COOKIE：Cookie校验
        # JS_CHECK：JavaScript校验
        # DELAY：延迟响应
        # BLOCK：拦截
        # RESET：断开连接
        # 自定义响应ID：自定义响应ID
        # 当匹配条件中存在状态码时，支持处理动作为监控、拦截、不使用、断开连接。'}
        self.action = action
        # {'en':'Matching conditions.', 'zh_CN':'匹配条件。'}
        self.rate_limit_rule_condition = rate_limit_rule_condition

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.scene, 'scene')
        self.validate_required(self.statistical_item, 'statistical_item')
        self.validate_required(self.statistical_period, 'statistical_period')
        self.validate_required(self.trigger_threshold, 'trigger_threshold')
        self.validate_required(self.intercept_time, 'intercept_time')
        self.validate_required(self.effective_status, 'effective_status')
        if self.rate_limit_effective:
            self.rate_limit_effective.validate()
        self.validate_required(self.action, 'action')
        self.validate_required(self.rate_limit_rule_condition, 'rate_limit_rule_condition')
        if self.rate_limit_rule_condition:
            self.rate_limit_rule_condition.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.description is not None:
            result['description'] = self.description
        if self.scene is not None:
            result['scene'] = self.scene
        if self.statistical_item is not None:
            result['statisticalItem'] = self.statistical_item
        if self.statistics_key is not None:
            result['statisticsKey'] = self.statistics_key
        if self.statistical_period is not None:
            result['statisticalPeriod'] = self.statistical_period
        if self.trigger_threshold is not None:
            result['triggerThreshold'] = self.trigger_threshold
        if self.intercept_time is not None:
            result['interceptTime'] = self.intercept_time
        if self.effective_status is not None:
            result['effectiveStatus'] = self.effective_status
        if self.rate_limit_effective is not None:
            result['rateLimitEffective'] = self.rate_limit_effective.to_map()
        if self.asset_api_id is not None:
            result['assetApiId'] = self.asset_api_id
        if self.action is not None:
            result['action'] = self.action
        if self.rate_limit_rule_condition is not None:
            result['rateLimitRuleCondition'] = self.rate_limit_rule_condition.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('statisticalItem') is not None:
            self.statistical_item = m.get('statisticalItem')
        if m.get('statisticsKey') is not None:
            self.statistics_key = m.get('statisticsKey')
        if m.get('statisticalPeriod') is not None:
            self.statistical_period = m.get('statisticalPeriod')
        if m.get('triggerThreshold') is not None:
            self.trigger_threshold = m.get('triggerThreshold')
        if m.get('interceptTime') is not None:
            self.intercept_time = m.get('interceptTime')
        if m.get('effectiveStatus') is not None:
            self.effective_status = m.get('effectiveStatus')
        if m.get('rateLimitEffective') is not None:
            temp_model = CreatRateLimitingRuleRateLimitEffective()
            self.rate_limit_effective = temp_model.from_map(m['rateLimitEffective'])
        if m.get('assetApiId') is not None:
            self.asset_api_id = m.get('assetApiId')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('rateLimitRuleCondition') is not None:
            temp_model = CreatRateLimitingRuleRateLimitRuleCondition()
            self.rate_limit_rule_condition = temp_model.from_map(m['rateLimitRuleCondition'])
        return self


class CreatRateLimitingRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Rule ID.', 'zh_CN':'规则ID。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreatRateLimitingRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreatRateLimitingRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreatRateLimitingRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class CreatRateLimitingRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class HostnameImportAppApiExceptionsDTO(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_id: str = None,
    ):
        # {"en":"domain", "zh_CN":"域名"}
        self.domain = domain
        # {"en":"App/API exceptions rule ID", "zh_CN":"App/API例外的规则ID"}
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        return self


class HostnameImportAppApiExceptionsRequest(TeaModel):
    def __init__(
        self,
        data: List[HostnameImportAppApiExceptionsDTO] = None,
    ):
        # {"en":"data", "zh_CN":"data"}
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = HostnameImportAppApiExceptionsDTO()
                self.data.append(temp_model.from_map(k))
        return self


class HostnameImportAppApiExceptionsResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
    ):
        # {"en":"code", "zh_CN":"状态码"}
        self.code = code
        # {"en":"msg", "zh_CN":"描述信息"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class HostnameImportAppApiExceptionsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class HostnameImportAppApiExceptionsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class HostnameImportAppApiExceptionsRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class HostnameImportAppApiExceptionsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetConsumerInfoRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConsumerInfoConsumerInfo(TeaModel):
    def __init__(
        self,
        account_code: str = None,
        consumer_id: str = None,
        consumer_name: str = None,
        consumer_group: str = None,
        id: str = None,
        create_time: str = None,
        update_time: str = None,
        remark: str = None,
    ):
        # {"en":"Account code.", "zh_CN":"用户账号。"}
        self.account_code = account_code
        # {"en":"Consumer ID.", "zh_CN":"消费方ID。"}
        self.consumer_id = consumer_id
        # {"en":"Consumer name.", "zh_CN":"消费方名称。"}
        self.consumer_name = consumer_name
        # {"en":"Consumer group.", "zh_CN":"消费方分组。"}
        self.consumer_group = consumer_group
        # {"en":"Consumer data ID.", "zh_CN":"消费方数据ID。"}
        self.id = id
        # {"en":"Create time, format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"创建时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.create_time = create_time
        # {"en":"Update time, format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"更新时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.update_time = update_time
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark

    def validate(self):
        self.validate_required(self.account_code, 'account_code')
        self.validate_required(self.consumer_id, 'consumer_id')
        self.validate_required(self.consumer_name, 'consumer_name')
        self.validate_required(self.consumer_group, 'consumer_group')
        self.validate_required(self.id, 'id')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.remark, 'remark')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_code is not None:
            result['accountCode'] = self.account_code
        if self.consumer_id is not None:
            result['consumerId'] = self.consumer_id
        if self.consumer_name is not None:
            result['consumerName'] = self.consumer_name
        if self.consumer_group is not None:
            result['consumerGroup'] = self.consumer_group
        if self.id is not None:
            result['id'] = self.id
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountCode') is not None:
            self.account_code = m.get('accountCode')
        if m.get('consumerId') is not None:
            self.consumer_id = m.get('consumerId')
        if m.get('consumerName') is not None:
            self.consumer_name = m.get('consumerName')
        if m.get('consumerGroup') is not None:
            self.consumer_group = m.get('consumerGroup')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class GetConsumerInfoResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: GetConsumerInfoConsumerInfo = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回消息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            temp_model = GetConsumerInfoConsumerInfo()
            self.data = temp_model.from_map(m['data'])
        return self


class GetConsumerInfoPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConsumerInfoParameters(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # {"en":"Consumer ID.", "zh_CN":"消费方ID。"}
        self.id = id

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class GetConsumerInfoRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConsumerInfoResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateExceptionForWAFManagedRulesRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        match_type: str = None,
        content_list: List[str] = None,
    ):
        # {'en':'Rule exception ID.', 'zh_CN':'规则例外ID。'}
        self.id = id
        # {'en':'Match type,IP can only be EQUAL.
        # EQUAL: Equal
        # CONTAIN: Contains
        # REGEX: Regular match', 'zh_CN':'匹配类型，IP只能是等于。
        # EQUAL：等于
        # CONTAIN：包含
        # REGEX：正则匹配'}
        self.match_type = match_type
        # {'en':'Rule exceptions.
        # When matchType=EQUAL, case-sensitive, path and uri must start with "/", and body can only pass one value;
        # When matchType=REGEX, only one value can be passed.', 'zh_CN':'规则例外内容。
        # matchType=EQUAL时，大小写敏感，path和uri必须以"/"开头，body只能传一个值；
        # matchType=REGEX时，只能传一个值。'}
        self.content_list = content_list

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.content_list, 'content_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.content_list is not None:
            result['contentList'] = self.content_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('contentList') is not None:
            self.content_list = m.get('contentList')
        return self


class UpdateExceptionForWAFManagedRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateExceptionForWAFManagedRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateExceptionForWAFManagedRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateExceptionForWAFManagedRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateExceptionForWAFManagedRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetQuotaRuleListRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetQuotaRuleListVo(TeaModel):
    def __init__(
        self,
        id: str = None,
        api_count: int = None,
        consumer_count: int = None,
        control_action: str = None,
        limit_duration: str = None,
        policy_name: str = None,
        remark: str = None,
        status: str = None,
        threshold_value: str = None,
        update_time: str = None,
    ):
        # {"en":"Rule ID.", "zh_CN":"规则ID。"}
        self.id = id
        # {"en":"The number of APIs.", "zh_CN":"API数。"}
        self.api_count = api_count
        # {"en":"The number of consumer.", "zh_CN":"消费方数。"}
        self.consumer_count = consumer_count
        # {"en":"Control action,default value: INTERCEPT.
        # INTERCEPT:Block
        # MONITOR:Log.", "zh_CN":"控制动作。
        # INTERCEPT：拦截
        # MONITOR：监控。"}
        self.control_action = control_action
        # {"en":"Time period.", "zh_CN":"限制时长。"}
        self.limit_duration = limit_duration
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.policy_name = policy_name
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark
        # {"en":"Status.
        # ON:on
        # OFF:off", "zh_CN":"状态。
        # ON：开
        # OFF：关。"}
        self.status = status
        # {"en":"Consumer square flow control threshold.", "zh_CN":"消费方配额阈值。"}
        self.threshold_value = threshold_value
        # {"en":"Update time,format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"更新时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.api_count, 'api_count')
        self.validate_required(self.consumer_count, 'consumer_count')
        self.validate_required(self.control_action, 'control_action')
        self.validate_required(self.limit_duration, 'limit_duration')
        self.validate_required(self.policy_name, 'policy_name')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.status, 'status')
        self.validate_required(self.threshold_value, 'threshold_value')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.api_count is not None:
            result['apiCount'] = self.api_count
        if self.consumer_count is not None:
            result['consumerCount'] = self.consumer_count
        if self.control_action is not None:
            result['controlAction'] = self.control_action
        if self.limit_duration is not None:
            result['limitDuration'] = self.limit_duration
        if self.policy_name is not None:
            result['policyName'] = self.policy_name
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.threshold_value is not None:
            result['thresholdValue'] = self.threshold_value
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('apiCount') is not None:
            self.api_count = m.get('apiCount')
        if m.get('consumerCount') is not None:
            self.consumer_count = m.get('consumerCount')
        if m.get('controlAction') is not None:
            self.control_action = m.get('controlAction')
        if m.get('limitDuration') is not None:
            self.limit_duration = m.get('limitDuration')
        if m.get('policyName') is not None:
            self.policy_name = m.get('policyName')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thresholdValue') is not None:
            self.threshold_value = m.get('thresholdValue')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetQuotaRuleListPage(TeaModel):
    def __init__(
        self,
        current: int = None,
        pages: int = None,
        size: int = None,
        total: int = None,
        records: List[GetQuotaRuleListVo] = None,
    ):
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"The total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The number of records per page.", "zh_CN":"每页规则条数。"}
        self.size = size
        # {"en":"The total number of records.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"List of quota rule.", "zh_CN":"配额规则列表。"}
        self.records = records

    def validate(self):
        self.validate_required(self.current, 'current')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.size, 'size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current is not None:
            result['current'] = self.current
        if self.pages is not None:
            result['pages'] = self.pages
        if self.size is not None:
            result['size'] = self.size
        if self.total is not None:
            result['total'] = self.total
        if self.records is not None:
            result['records'] = []
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('records') is not None:
            self.records = []
            for k in m.get('records'):
                temp_model = GetQuotaRuleListVo()
                self.records.append(temp_model.from_map(k))
        return self


class GetQuotaRuleListResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: GetQuotaRuleListPage = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            temp_model = GetQuotaRuleListPage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetQuotaRuleListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetQuotaRuleListParameters(TeaModel):
    def __init__(
        self,
        page: int = None,
        size: int = None,
        policy_name: str = None,
    ):
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.page = page
        # {"en":"The number of records per page.", "zh_CN":"每页规则条数。"}
        self.size = size
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.policy_name = policy_name

    def validate(self):
        self.validate_required(self.page, 'page')
        self.validate_required(self.size, 'size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.size is not None:
            result['size'] = self.size
        if self.policy_name is not None:
            result['policyName'] = self.policy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('policyName') is not None:
            self.policy_name = m.get('policyName')
        return self


class GetQuotaRuleListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetQuotaRuleListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryProtectionModeForWAFDomainRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {"en":"Domain, array.", "zh_CN":"域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class QueryProtectionModeForWAFDomainDomainInfo(TeaModel):
    def __init__(
        self,
        domain: str = None,
        def_st: int = None,
    ):
        # {"en":"Domain.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"WAF protection mode.
        #     0: Off
        #     1: Block
        #     2: Alert", "zh_CN":"WAF防护模式。
        #     0：关闭
        #     1：拦截
        #     2：监控"}
        self.def_st = def_st

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.def_st, 'def_st')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.def_st is not None:
            result['def_st'] = self.def_st
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('def_st') is not None:
            self.def_st = m.get('def_st')
        return self


class QueryProtectionModeForWAFDomainResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: List[QueryProtectionModeForWAFDomainDomainInfo] = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message
        # {"en":"Return data.", "zh_CN":"返回值。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = QueryProtectionModeForWAFDomainDomainInfo()
                self.data.append(temp_model.from_map(k))
        return self


class QueryProtectionModeForWAFDomainPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryProtectionModeForWAFDomainParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryProtectionModeForWAFDomainRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryProtectionModeForWAFDomainResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class CreateAndActiveApiAuthConfig(TeaModel):
    def __init__(
        self,
        auth_param_name: str = None,
        auth_param_site: str = None,
        auth_type: str = None,
        auth_validity_time: int = None,
    ):
        # {"en":"Authentication parameter name,default value: authKey.", "zh_CN":"鉴权参数名称，默认值：authKey。"}
        self.auth_param_name = auth_param_name
        # {"en":"Authentication parameter location,default value:1.
        # 1:HTTP header
        # 2:Query string
        # 3:Cookie", "zh_CN":"鉴权参数位置，默认值：1。
        # 1：HTTP header
        # 2：Query string
        # 3：Cookie"}
        self.auth_param_site = auth_param_site
        # {"en":"Authentication method,default value:1.
        # 1:No auth
        # 2:Auth by  wangsu Secret Key.", "zh_CN":"鉴权方法，默认值：1。
        # 1：免鉴权
        # 2：网宿秘钥对鉴权"}
        self.auth_type = auth_type
        # {"en":"Authentication Token Validity Period(second), default value:8.", "zh_CN":"鉴权有效期（s），默认值：8。"}
        self.auth_validity_time = auth_validity_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_param_name is not None:
            result['authParamName'] = self.auth_param_name
        if self.auth_param_site is not None:
            result['authParamSite'] = self.auth_param_site
        if self.auth_type is not None:
            result['authType'] = self.auth_type
        if self.auth_validity_time is not None:
            result['authValidityTime'] = self.auth_validity_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authParamName') is not None:
            self.auth_param_name = m.get('authParamName')
        if m.get('authParamSite') is not None:
            self.auth_param_site = m.get('authParamSite')
        if m.get('authType') is not None:
            self.auth_type = m.get('authType')
        if m.get('authValidityTime') is not None:
            self.auth_validity_time = m.get('authValidityTime')
        return self


class CreateAndActiveApiSecondChildren(TeaModel):
    def __init__(
        self,
        level: int = None,
        node_require: bool = None,
        max: int = None,
        min: int = None,
        name: str = None,
        enumeration: str = None,
        require: bool = None,
        type: str = None,
    ):
        # {"en":"Json node level(CreateAndActiveApiBody is Json must pass).", "zh_CN":"Json节点层级（Body为Json必传）。"}
        self.level = level
        # {"en":"Whether the Json node is required to fill in the option(CreateAndActiveApiBody is Json must pass).", "zh_CN":"Json节点是否带必填选项（Body为Json必传）。"}
        self.node_require = node_require
        # {"en":"Maximum.", "zh_CN":"最大值。"}
        self.max = max
        # {"en":"Minimum.", "zh_CN":"最小值。"}
        self.min = min
        # {"en":"Parameter name.", "zh_CN":"参数名称。"}
        self.name = name
        # {"en":"Enumeration.", "zh_CN":"参数枚举值，多个用;分隔。"}
        self.enumeration = enumeration
        # {"en":"Required,default value:false.", "zh_CN":"是否必须，默认值：false。"}
        self.require = require
        # {"en":"Parameter Type.
        # integer:Integer
        # number:Number
        # string:String
        # boolean:Boolean
        # enumeration:Enumerate
        # array:Array
        # object:Json object", "zh_CN":"参数类型。
        # integer：整数
        # number：数字
        # string：字符串
        # boolean：布尔
        # enumeration：枚举
        # array：数组
        # object：Json对象"}
        self.type = type

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.node_require is not None:
            result['nodeRequire'] = self.node_require
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.name is not None:
            result['name'] = self.name
        if self.enumeration is not None:
            result['enumeration'] = self.enumeration
        if self.require is not None:
            result['require'] = self.require
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('nodeRequire') is not None:
            self.node_require = m.get('nodeRequire')
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('enumeration') is not None:
            self.enumeration = m.get('enumeration')
        if m.get('require') is not None:
            self.require = m.get('require')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateAndActiveApiChildren(TeaModel):
    def __init__(
        self,
        level: int = None,
        node_require: bool = None,
        max: int = None,
        min: int = None,
        name: str = None,
        enumeration: str = None,
        require: bool = None,
        type: str = None,
        children: List[CreateAndActiveApiSecondChildren] = None,
    ):
        # {"en":"Json node level(CreateAndActiveApiBody is Json must pass).", "zh_CN":"Json节点层级（Body为Json必传）。"}
        self.level = level
        # {"en":"Whether the Json node is required to fill in the option(CreateAndActiveApiBody is Json must pass).", "zh_CN":"Json节点是否带必填选项（Body为Json必传）。"}
        self.node_require = node_require
        # {"en":"Maximum.", "zh_CN":"最大值。"}
        self.max = max
        # {"en":"Minimum.", "zh_CN":"最小值。"}
        self.min = min
        # {"en":"Parameter name.", "zh_CN":"参数名称。"}
        self.name = name
        # {"en":"Enumeration.", "zh_CN":"参数枚举值，多个用;分隔。"}
        self.enumeration = enumeration
        # {"en":"Required,default value:false.", "zh_CN":"是否必须，默认值：false。"}
        self.require = require
        # {"en":"Parameter Type.
        # integer:Integer
        # number:Number
        # string:String
        # boolean:Boolean
        # enumeration:Enumerate
        # array:Array
        # object:Json object", "zh_CN":"参数类型。
        # integer：整数
        # number：数字
        # string：字符串
        # boolean：布尔
        # enumeration：枚举
        # array：数组
        # object：Json对象"}
        self.type = type
        # {"en":"Json sub node array(CreateAndActiveApiBody is Json must pass).", "zh_CN":"Json子节点数组，类型为Body（Body为Json必传）。"}
        self.children = children

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.node_require is not None:
            result['nodeRequire'] = self.node_require
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.name is not None:
            result['name'] = self.name
        if self.enumeration is not None:
            result['enumeration'] = self.enumeration
        if self.require is not None:
            result['require'] = self.require
        if self.type is not None:
            result['type'] = self.type
        if self.children is not None:
            result['children'] = []
            for k in self.children:
                result['children'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('nodeRequire') is not None:
            self.node_require = m.get('nodeRequire')
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('enumeration') is not None:
            self.enumeration = m.get('enumeration')
        if m.get('require') is not None:
            self.require = m.get('require')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('children') is not None:
            self.children = []
            for k in m.get('children'):
                temp_model = CreateAndActiveApiSecondChildren()
                self.children.append(temp_model.from_map(k))
        return self


class CreateAndActiveApiBody(TeaModel):
    def __init__(
        self,
        level: int = None,
        node_require: bool = None,
        max: int = None,
        min: int = None,
        name: str = None,
        enumeration: str = None,
        require: bool = None,
        type: str = None,
        children: List[CreateAndActiveApiChildren] = None,
    ):
        # {"en":"Json node level(CreateAndActiveApiBody is Json must pass).", "zh_CN":"Json节点层级（Body为Json必传）。"}
        self.level = level
        # {"en":"Whether the Json node is required to fill in the option(CreateAndActiveApiBody is Json must pass).", "zh_CN":"Json节点是否带必填选项（Body为Json必传）。"}
        self.node_require = node_require
        # {"en":"Maximum.", "zh_CN":"最大值。"}
        self.max = max
        # {"en":"Minimum.", "zh_CN":"最小值。"}
        self.min = min
        # {"en":"Parameter name.", "zh_CN":"参数名称。"}
        self.name = name
        # {"en":"Enumeration.", "zh_CN":"参数枚举值，多个用;分隔。"}
        self.enumeration = enumeration
        # {"en":"Required,default value:false.", "zh_CN":"是否必须，默认值：false。"}
        self.require = require
        # {"en":"Parameter Type.
        # integer:Integer
        # number:Number
        # string:String
        # boolean:Boolean
        # enumeration:Enumerate
        # array:Array
        # object:Json object", "zh_CN":"参数类型。
        # integer：整数
        # number：数字
        # string：字符串
        # boolean：布尔
        # enumeration：枚举
        # array：数组
        # object：Json对象"}
        self.type = type
        # {"en":"Json sub node array(CreateAndActiveApiBody is Json must pass).", "zh_CN":"Json子节点数组，类型为Body（Body为Json必传）。"}
        self.children = children

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.node_require is not None:
            result['nodeRequire'] = self.node_require
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.name is not None:
            result['name'] = self.name
        if self.enumeration is not None:
            result['enumeration'] = self.enumeration
        if self.require is not None:
            result['require'] = self.require
        if self.type is not None:
            result['type'] = self.type
        if self.children is not None:
            result['children'] = []
            for k in self.children:
                result['children'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('nodeRequire') is not None:
            self.node_require = m.get('nodeRequire')
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('enumeration') is not None:
            self.enumeration = m.get('enumeration')
        if m.get('require') is not None:
            self.require = m.get('require')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('children') is not None:
            self.children = []
            for k in m.get('children'):
                temp_model = CreateAndActiveApiChildren()
                self.children.append(temp_model.from_map(k))
        return self


class CreateAndActiveApiRequestParams(TeaModel):
    def __init__(
        self,
        max: int = None,
        min: int = None,
        name: str = None,
        require: bool = None,
        site: str = None,
        type: str = None,
        value: str = None,
    ):
        # {"en":"Maximum.", "zh_CN":"最大值。"}
        self.max = max
        # {"en":"Minimum.", "zh_CN":"最小值。"}
        self.min = min
        # {"en":"Parameter name.", "zh_CN":"参数名称。"}
        self.name = name
        # {"en":"Required parameter,default value:false.", "zh_CN":"是否必须，默认值：false。"}
        self.require = require
        # {"en":"Parameter position,default value:1.
        # 1: HTTP header
        # 2: Query string,
        # 3: Cookie
        # 4: Path parameter", "zh_CN":"参数位置，默认值：1。
        # 1：HTTP header
        # 2：Query string,
        # 3：Cookie
        # 4：路径参数"}
        self.site = site
        # {"en":"Parameter Type,default value:1.
        # 1:integer
        # 2:number
        # 3:string
        # 4:boolean
        # 5:enumerate", "zh_CN":"参数类型，默认值：1。
        # 1：整数
        # 2：数字
        # 3：字符串
        # 4：布尔
        # 5：枚举"}
        self.type = type
        # {"en":"Parameter enumeration,multiple use \";\" split.", "zh_CN":"参数枚举值，多个用;分隔。"}
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.name is not None:
            result['name'] = self.name
        if self.require is not None:
            result['require'] = self.require
        if self.site is not None:
            result['site'] = self.site
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('require') is not None:
            self.require = m.get('require')
        if m.get('site') is not None:
            self.site = m.get('site')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class CreateAndActiveApiParamsLimitConfig(TeaModel):
    def __init__(
        self,
        body: List[CreateAndActiveApiBody] = None,
        request_method: str = None,
        request_params: List[CreateAndActiveApiRequestParams] = None,
        path_match_type: str = None,
        body_flag: bool = None,
        body_type: str = None,
    ):
        # {"en":"Request body parameter limit configuration.", "zh_CN":"请求Body参数限制配置。"}
        self.body = body
        # {"en":"Request methods,default value:GET.
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE", "zh_CN":"请求方法，默认值：GET。
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE"}
        self.request_method = request_method
        # {"en":"Request parameter.", "zh_CN":"请求参数。"}
        self.request_params = request_params
        # {"en":"Path matching type,Default value:DICT.
        # DICT:Complete matching
        #  REGEX:Regular matching", "zh_CN":"路径匹配类型，默认值：DICT。
        # DICT：完整匹配
        #  REGEX：正则匹配"}
        self.path_match_type = path_match_type
        # {"en":"Whether to define the body parameter,default value:false.", "zh_CN":"是否定义Body参数，默认值：false。"}
        self.body_flag = body_flag
        # {"en":"CreateAndActiveApiBody parameter type,default value:FORM.
        # FORM:Form
        # JSON_XML:Json format definition", "zh_CN":"Body参数类型，默认值：FORM。
        # FORM：Form表单
        # JSON_XML：Json格式定义"}
        self.body_type = body_type

    def validate(self):
        if self.body:
            for k in self.body:
                if k:
                    k.validate()
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['body'] = []
            for k in self.body:
                result['body'].append(k.to_map() if k else None)
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        if self.request_params is not None:
            result['requestParams'] = []
            for k in self.request_params:
                result['requestParams'].append(k.to_map() if k else None)
        if self.path_match_type is not None:
            result['pathMatchType'] = self.path_match_type
        if self.body_flag is not None:
            result['bodyFlag'] = self.body_flag
        if self.body_type is not None:
            result['bodyType'] = self.body_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('body') is not None:
            self.body = []
            for k in m.get('body'):
                temp_model = CreateAndActiveApiBody()
                self.body.append(temp_model.from_map(k))
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        if m.get('requestParams') is not None:
            self.request_params = []
            for k in m.get('requestParams'):
                temp_model = CreateAndActiveApiRequestParams()
                self.request_params.append(temp_model.from_map(k))
        if m.get('pathMatchType') is not None:
            self.path_match_type = m.get('pathMatchType')
        if m.get('bodyFlag') is not None:
            self.body_flag = m.get('bodyFlag')
        if m.get('bodyType') is not None:
            self.body_type = m.get('bodyType')
        return self


class CreateAndActiveApiRequestBodyConfig(TeaModel):
    def __init__(
        self,
        body_limit_max: int = None,
        content_type: str = None,
        nest_max: int = None,
        params_count_max: int = None,
        params_limit_switch: bool = None,
        params_processing_model: str = None,
        request_body_limit_switch: bool = None,
        request_processing_action: str = None,
    ):
        # {"en":"Maximum body limit(bytes).", "zh_CN":"body最大限制。"}
        self.body_limit_max = body_limit_max
        # {"en":"HTTP content type of the response,default value:1.
        # 1:Form
        # 2:Json
        # 4:Any
        # 5:For empty or no existence.", "zh_CN":"contentType，默认值：1。
        # 1：Form表单
        # 2：Json
        # 4：任意
        # 5：为空或不存在。"}
        self.content_type = content_type
        # {"en":"Maximum nesting depth.", "zh_CN":"最大嵌套层数。"}
        self.nest_max = nest_max
        # {"en":"Maximum number of parameters for JSON.", "zh_CN":"Json最大参数个数。"}
        self.params_count_max = params_count_max
        # {"en":"Parameter limit switch,default value: false.", "zh_CN":"参数限制开关，默认值：false。"}
        self.params_limit_switch = params_limit_switch
        # {"en":"Query string parameter detection mode,default value:1.
        # 1:Quirk mode
        # 2:Strict mode", "zh_CN":"query string参数检测模式，默认值：1。
        # :1：宽松模式
        # 2：严格模式"}
        self.params_processing_model = params_processing_model
        # {"en":"Request body limit switch,default value:false.", "zh_CN":"请求body限制开关，默认值：false。"}
        self.request_body_limit_switch = request_body_limit_switch
        # {"en":"The action to execute when a rule is matched,default value:2.
        # 1:Block
        # 2:Log
        # 3:Sign", "zh_CN":"处理动作，默认值：2。
        # 1：拦截
        # 2：监控
        # 3：标记"}
        self.request_processing_action = request_processing_action

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body_limit_max is not None:
            result['bodyLimitMax'] = self.body_limit_max
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.nest_max is not None:
            result['nestMax'] = self.nest_max
        if self.params_count_max is not None:
            result['paramsCountMax'] = self.params_count_max
        if self.params_limit_switch is not None:
            result['paramsLimitSwitch'] = self.params_limit_switch
        if self.params_processing_model is not None:
            result['paramsProcessingModel'] = self.params_processing_model
        if self.request_body_limit_switch is not None:
            result['requestBodyLimitSwitch'] = self.request_body_limit_switch
        if self.request_processing_action is not None:
            result['requestProcessingAction'] = self.request_processing_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bodyLimitMax') is not None:
            self.body_limit_max = m.get('bodyLimitMax')
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('nestMax') is not None:
            self.nest_max = m.get('nestMax')
        if m.get('paramsCountMax') is not None:
            self.params_count_max = m.get('paramsCountMax')
        if m.get('paramsLimitSwitch') is not None:
            self.params_limit_switch = m.get('paramsLimitSwitch')
        if m.get('paramsProcessingModel') is not None:
            self.params_processing_model = m.get('paramsProcessingModel')
        if m.get('requestBodyLimitSwitch') is not None:
            self.request_body_limit_switch = m.get('requestBodyLimitSwitch')
        if m.get('requestProcessingAction') is not None:
            self.request_processing_action = m.get('requestProcessingAction')
        return self


class CreateAndActiveApiRequest(TeaModel):
    def __init__(
        self,
        api_case: int = None,
        api_group: str = None,
        api_name: str = None,
        api_conceal: str = None,
        api_type: str = None,
        auth_config: CreateAndActiveApiAuthConfig = None,
        auth_key: str = None,
        domains: str = None,
        front_path: str = None,
        path_match_type: str = None,
        front_path_type: int = None,
        params_limit_config: List[CreateAndActiveApiParamsLimitConfig] = None,
        remark: str = None,
        request_body_config: CreateAndActiveApiRequestBodyConfig = None,
        request_method: str = None,
    ):
        # {"en":"Case sensitive,default value:0.
        # 0:False
        # 1:True", "zh_CN":"大小写敏感，默认值：0。
        #  0：否
        # 1：是"}
        self.api_case = api_case
        # {"en":"API group.", "zh_CN":"API分组。"}
        self.api_group = api_group
        # {"en":"API name.", "zh_CN":"API名称。"}
        self.api_name = api_name
        # {"en":"API privacy,default value:PUBLIC.
        # PUBLIC:Public,the consumer does not need to associate with the API, and can access the public API assets only by passing the authentication.
        # PRIVATE:Private,you need to create a consumer and associate with the API to access private API assets.", "zh_CN":"API隐私，默认值：PUBLIC。
        # PUBLIC：公开，消费方无需绑定API，仅鉴权通过即可访问公开API资产。
        # PRIVATE：私有，需要创建消费方并绑定API，方可访问私有API资产。"}
        self.api_conceal = api_conceal
        # {"en":"API type,default value:NORMAL.
        # NORMAL:Normal API,the path does not contain query string parameters,such as http://www.test.com/api.
        # WHEN_CASE:When case,the path contains query string parameters,such as http://www.test.com/api?action=1 and http://www.test.com/api?action=2 are two different APIs.", "zh_CN":"API类型，默认值：NORMAL。
        # NORMAL：普通接口，路径中不包含query string参数的普通接口，如http://www.test.com/api。
        # WHEN_CASE：when_case接口，路径中包含query string参数，如http://www.test.com/api?action=1与http://www.test.com/api?action=2 是两个不同的接口。"}
        self.api_type = api_type
        # {"en":"Authentication configuration.", "zh_CN":"鉴权配置。"}
        self.auth_config = auth_config
        # {"en":"Authentication key.", "zh_CN":"鉴权秘钥。"}
        self.auth_key = auth_key
        # {"en":"Domain,multiple use \";\" split.", "zh_CN":"所属域名，多个用;隔开。"}
        self.domains = domains
        # {"en":"Endpoint path.", "zh_CN":"前端路径。"}
        self.front_path = front_path
        # {"en":"Path matching type,default value:DICT.
        # DICT:Complete matching
        #  REGEX:Regular matching", "zh_CN":"路径匹配类型，默认值：DICT。
        # DICT：完整匹配
        #  REGEX：正则匹配"}
        self.path_match_type = path_match_type
        # {"en":"Match parameters in the path,default value:0.
        # 0:False
        # 1:True
        # ", "zh_CN":"匹配路径参数，默认值：0。
        #  0：否
        # 1：是
        # "}
        self.front_path_type = front_path_type
        # {"en":"Parameter limit configuration.", "zh_CN":"参数限制配置。"}
        self.params_limit_config = params_limit_config
        # {"en":"Remark.", "zh_CN":"备注。"}
        self.remark = remark
        # {"en":"Request body limit configuration.", "zh_CN":"请求Body限制配置。"}
        self.request_body_config = request_body_config
        # {"en":"Request Methods,multiple use \";\" split,default value:GET.
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE", "zh_CN":"请求方法，多个用;隔开，默认值：GET。
        # GET
        # POST
        # DELETE
        # UPDATE
        # PUT
        # HEAD
        # CONNECT
        # OPTIONS
        # COPY
        # LOCK
        # UNLOCK
        # TRACE
        # PATCH
        # PROPFIND
        # MKCOL
        # MOVE"}
        self.request_method = request_method

    def validate(self):
        self.validate_required(self.api_group, 'api_group')
        self.validate_required(self.api_name, 'api_name')
        self.validate_required(self.api_type, 'api_type')
        if self.auth_config:
            self.auth_config.validate()
        self.validate_required(self.domains, 'domains')
        self.validate_required(self.front_path, 'front_path')
        self.validate_required(self.path_match_type, 'path_match_type')
        self.validate_required(self.front_path_type, 'front_path_type')
        if self.params_limit_config:
            for k in self.params_limit_config:
                if k:
                    k.validate()
        self.validate_required(self.request_body_config, 'request_body_config')
        if self.request_body_config:
            self.request_body_config.validate()
        self.validate_required(self.request_method, 'request_method')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_case is not None:
            result['apiCase'] = self.api_case
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.api_name is not None:
            result['apiName'] = self.api_name
        if self.api_conceal is not None:
            result['apiConceal'] = self.api_conceal
        if self.api_type is not None:
            result['apiType'] = self.api_type
        if self.auth_config is not None:
            result['authConfig'] = self.auth_config.to_map()
        if self.auth_key is not None:
            result['authKey'] = self.auth_key
        if self.domains is not None:
            result['domains'] = self.domains
        if self.front_path is not None:
            result['frontPath'] = self.front_path
        if self.path_match_type is not None:
            result['pathMatchType'] = self.path_match_type
        if self.front_path_type is not None:
            result['frontPathType'] = self.front_path_type
        if self.params_limit_config is not None:
            result['paramsLimitConfig'] = []
            for k in self.params_limit_config:
                result['paramsLimitConfig'].append(k.to_map() if k else None)
        if self.remark is not None:
            result['remark'] = self.remark
        if self.request_body_config is not None:
            result['requestBodyConfig'] = self.request_body_config.to_map()
        if self.request_method is not None:
            result['requestMethod'] = self.request_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiCase') is not None:
            self.api_case = m.get('apiCase')
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('apiName') is not None:
            self.api_name = m.get('apiName')
        if m.get('apiConceal') is not None:
            self.api_conceal = m.get('apiConceal')
        if m.get('apiType') is not None:
            self.api_type = m.get('apiType')
        if m.get('authConfig') is not None:
            temp_model = CreateAndActiveApiAuthConfig()
            self.auth_config = temp_model.from_map(m['authConfig'])
        if m.get('authKey') is not None:
            self.auth_key = m.get('authKey')
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        if m.get('frontPath') is not None:
            self.front_path = m.get('frontPath')
        if m.get('pathMatchType') is not None:
            self.path_match_type = m.get('pathMatchType')
        if m.get('frontPathType') is not None:
            self.front_path_type = m.get('frontPathType')
        if m.get('paramsLimitConfig') is not None:
            self.params_limit_config = []
            for k in m.get('paramsLimitConfig'):
                temp_model = CreateAndActiveApiParamsLimitConfig()
                self.params_limit_config.append(temp_model.from_map(k))
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('requestBodyConfig') is not None:
            temp_model = CreateAndActiveApiRequestBodyConfig()
            self.request_body_config = temp_model.from_map(m['requestBodyConfig'])
        if m.get('requestMethod') is not None:
            self.request_method = m.get('requestMethod')
        return self


class CreateAndActiveApiResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: dict = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreateAndActiveApiPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateAndActiveApiParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateAndActiveApiRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateAndActiveApiResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListUpgradeDetailsRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {'en':'Hostname list.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class ListUpgradeDetailsWafDomainRuleInfoVO(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        mode: str = None,
        name: str = None,
        des: str = None,
        attack_type: str = None,
        owasp_type_list: List[str] = None,
        cve_list: List[str] = None,
        component_list: List[str] = None,
    ):
        # {'en':'WAF rule ID.', 'zh_CN':'WAF规则ID。'}
        self.rule_id = rule_id
        # {'en':'Action.
        #   BLOCK: Deny request by a default 403 response. 
        #   LOG: Log request and continue further detections.
        #   OFF: Select if you do not a policy or rule take effect.', 'zh_CN':'规则动作。
        #   BLOCK：阻断请求并响应403。
        #   LOG：记录请求的攻击行为，并继续做进一步的评估。
        #   OFF：对应规则或策略不生效。'}
        self.mode = mode
        # {'en':'Rule name.', 'zh_CN':'规则名称。'}
        self.name = name
        # {'en':'Describe.', 'zh_CN':'描述。'}
        self.des = des
        # {'en':'Attack type.
        # WAF_XSS: Cross-Site Scripting
        # WAF_RFI: File Inclusion
        # WAF_FILE_UPLOAD: File Uploading
        # WAF_CMDI: Command Injection
        # WAF_DIR_TRAVERSAL: Directory Traversal
        # WAF_THIRDCOMP: 3rd-party Component Vulnerabilities
        # WAF_XPATH_LDAP_SSI: XPATH/LDAP/SSI Injection
        # WAF_SCANNER: Scanners
        # WAF_SHELL_BACKDOOR: Webshell Uploading
        # WAF_FILE_DOWNLOAD: Unauthorized Download
        # WAF_XXE: XML Injection
        # WAF_SQLI: SQL Injection
        # WAF_SSRF: Server-side Request Forge', 'zh_CN':'攻击类型。
        # WAF_XSS：XSS跨站
        # WAF_RFI：文件包含
        # WAF_FILE_UPLOAD：文件上传
        # WAF_CMDI：命令注入
        # WAF_DIR_TRAVERSAL：目录遍历
        # WAF_THIRDCOMP：第三方组件漏洞
        # WAF_XPATH_LDAP_SSI：XPATH/LADP/SSI注入
        # WAF_SCANNER：扫描器
        # WAF_SHELL_BACKDOOR：木马后门
        # WAF_FILE_DOWNLOAD：非法下载
        # WAF_XXE：XML注入
        # WAF_SQLI：SQL注入
        # WAF_SSRF：服务端请求伪造'}
        self.attack_type = attack_type
        # {'en':'OWASP type.
        # A1: Injection
        # A2: Broken Authentication
        # A3: Sensitive Data Exposure
        # A4: XML External Entities(XXE)
        # A5: Broken Access Control
        # A7: Cross-site scripting (XSS)
        # A8: Insecure Deserialization
        # A9: Using Components with Known Vulnerabilities', 'zh_CN':'OWASP类型。
        # A1：注入
        # A2：失效的身份认证和会话管理
        # A3：敏感信息泄露
        # A4：XML外部实体（XEE）
        # A5：失效的访问控制
        # A7：跨站脚本（XSS）
        # A8：不安全的反序列化
        # A9：使用含有已知漏洞的组件'}
        self.owasp_type_list = owasp_type_list
        # {'en':'Vulnerability number.', 'zh_CN':'漏洞编号。'}
        self.cve_list = cve_list
        # {'en':'Components.', 'zh_CN':'关联组件。'}
        self.component_list = component_list

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.name, 'name')
        self.validate_required(self.des, 'des')
        self.validate_required(self.attack_type, 'attack_type')
        self.validate_required(self.owasp_type_list, 'owasp_type_list')
        self.validate_required(self.cve_list, 'cve_list')
        self.validate_required(self.component_list, 'component_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.mode is not None:
            result['mode'] = self.mode
        if self.name is not None:
            result['name'] = self.name
        if self.des is not None:
            result['des'] = self.des
        if self.attack_type is not None:
            result['attackType'] = self.attack_type
        if self.owasp_type_list is not None:
            result['owaspTypeList'] = self.owasp_type_list
        if self.cve_list is not None:
            result['cveList'] = self.cve_list
        if self.component_list is not None:
            result['componentList'] = self.component_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('des') is not None:
            self.des = m.get('des')
        if m.get('attackType') is not None:
            self.attack_type = m.get('attackType')
        if m.get('owaspTypeList') is not None:
            self.owasp_type_list = m.get('owaspTypeList')
        if m.get('cveList') is not None:
            self.cve_list = m.get('cveList')
        if m.get('componentList') is not None:
            self.component_list = m.get('componentList')
        return self


class ListUpgradeDetailsWafDomainRuleUpgradeListVO(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_list: List[ListUpgradeDetailsWafDomainRuleInfoVO] = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Array of rule information to be updated.', 'zh_CN':'待更新规则信息数组。'}
        self.rule_list = rule_list

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_list, 'rule_list')
        if self.rule_list:
            for k in self.rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_list is not None:
            result['ruleList'] = []
            for k in self.rule_list:
                result['ruleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleList') is not None:
            self.rule_list = []
            for k in m.get('ruleList'):
                temp_model = ListUpgradeDetailsWafDomainRuleInfoVO()
                self.rule_list.append(temp_model.from_map(k))
        return self


class ListUpgradeDetailsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListUpgradeDetailsWafDomainRuleUpgradeListVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListUpgradeDetailsWafDomainRuleUpgradeListVO()
                self.data.append(temp_model.from_map(k))
        return self


class ListUpgradeDetailsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListUpgradeDetailsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListUpgradeDetailsRequestHeader(TeaModel):
    def __init__(
        self,
        language: str = None,
        service_type: str = None,
    ):
        # {'en':'The language of response data, default value: en.
        # zh_CN: Chinese
        # en: English', 'zh_CN':'返回内容的语言版本，默认值: en。
        # zh_CN：中文
        # en：英文'}
        self.language = language
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.language is not None:
            result['language'] = self.language
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('language') is not None:
            self.language = m.get('language')
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListUpgradeDetailsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListWorkflowRulesRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_name: str = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Optional, fuzzy query based on rule name.', 'zh_CN':'可选，根据规则名称模糊查询。'}
        self.rule_name = rule_name

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        return self


class ListWorkflowRulesProtectionPathDTO(TeaModel):
    def __init__(
        self,
        protection_name: str = None,
        protection_type: str = None,
        protection_path: str = None,
    ):
        # {'en':'Protection type.
        # Path: path 
        # URI:URI', 'zh_CN':'防护路径。
        # Path：路径
        # URI：URI'}
        self.protection_name = protection_name
        # {'en':'Match type.
        # EQUAL: equals 
        # REGEX: regex match
        # CONTAIN: contains', 'zh_CN':'防护路径。
        # EQUAL：相等
        # REGEX：正则匹配
        # CONTAIN：相等'}
        self.protection_type = protection_type
        # {'en':'Protection path.', 'zh_CN':'防护路径。'}
        self.protection_path = protection_path

    def validate(self):
        self.validate_required(self.protection_name, 'protection_name')
        self.validate_required(self.protection_type, 'protection_type')
        self.validate_required(self.protection_path, 'protection_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.protection_name is not None:
            result['protectionName'] = self.protection_name
        if self.protection_type is not None:
            result['protectionType'] = self.protection_type
        if self.protection_path is not None:
            result['protectionPath'] = self.protection_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('protectionName') is not None:
            self.protection_name = m.get('protectionName')
        if m.get('protectionType') is not None:
            self.protection_type = m.get('protectionType')
        if m.get('protectionPath') is not None:
            self.protection_path = m.get('protectionPath')
        return self


class ListWorkflowRulesWebRuleConditionDTO(TeaModel):
    def __init__(
        self,
        request_judge: str = None,
        request_type: str = None,
        request_total_type: str = None,
        judge_type: str = None,
        judge_value: int = None,
    ):
        # {'en':'Request determination. 
        #  NUM: Request quantity determination
        #  PERCENT: Request proportion determination', 'zh_CN':'请求判定。
        #  NUM：请求数量判定
        #  PERCENT：请求比例判定'}
        self.request_judge = request_judge
        # {'en':'Request type. 
        #  TOTAL: Total requests
        #  POST: POST requests
        #  GET: GET requests
        #  PIC: Picture resource requests
        #  CSS: CSS resource requests
        #  JS: JS resource requests
        #  OTHER: Other resource requests', 'zh_CN':'请求类型。
        #  TOTAL：总请求数
        #  POST：POST请求数
        #  GET：GET请求数
        #  PIC ：图片资源请求数
        #  CSS：CSS资源请求数
        #  JS：JS资源请求数
        #  OTHER：其他资源请求数'}
        self.request_type = request_type
        # {'en':'Denominator request type. 
        #  TOTAL: total number of requests
        #  POST: number of POST requests
        #  GET: number of GET requests
        #  PIC: number of image resource requests
        #  CSS: number of CSS resource requests
        #  JS: JS resource request Number
        #  OTHER: Number of other resource requests', 'zh_CN':'分母请求类型。
        #  TOTAL：总请求数
        #  POST：POST请求数
        #  GET：GET请求数
        #  PIC：图片资源请求数
        #  CSS：CSS资源请求数
        #  JS：JS资源请求数
        #  OTHER：其他资源请求数'}
        self.request_total_type = request_total_type
        # {'en':'Determine comparison conditions. 
        #  GT: greater than
        #  LT: less than
        #  GTE: greater than or equal to
        #  LTE: less than or equal to', 'zh_CN':'判定比较条件。
        #  GT：大于
        #  LT：小于
        #  GTE：大于等于
        #  LTE：小于等于'}
        self.judge_type = judge_type
        # {'en':'Determine comparison value.', 'zh_CN':'判定比较值。'}
        self.judge_value = judge_value

    def validate(self):
        self.validate_required(self.request_judge, 'request_judge')
        self.validate_required(self.request_type, 'request_type')
        self.validate_required(self.request_total_type, 'request_total_type')
        self.validate_required(self.judge_type, 'judge_type')
        self.validate_required(self.judge_value, 'judge_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_judge is not None:
            result['requestJudge'] = self.request_judge
        if self.request_type is not None:
            result['requestType'] = self.request_type
        if self.request_total_type is not None:
            result['requestTotalType'] = self.request_total_type
        if self.judge_type is not None:
            result['judgeType'] = self.judge_type
        if self.judge_value is not None:
            result['judgeValue'] = self.judge_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestJudge') is not None:
            self.request_judge = m.get('requestJudge')
        if m.get('requestType') is not None:
            self.request_type = m.get('requestType')
        if m.get('requestTotalType') is not None:
            self.request_total_type = m.get('requestTotalType')
        if m.get('judgeType') is not None:
            self.judge_type = m.get('judgeType')
        if m.get('judgeValue') is not None:
            self.judge_value = m.get('judgeValue')
        return self


class ListWorkflowRulesApiRuleConditionDTO(TeaModel):
    def __init__(
        self,
        request_type: str = None,
        judge_type: str = None,
        judge_value: int = None,
        customize_match_name: str = None,
        customize_path_match: str = None,
        customize_path: str = None,
    ):
        # {'en':'Request type. 
        #  TOTAL: total requests
        #  OTHER: number of other URL requests
        #  CUSTOMIZE: number of custom URL requests', 'zh_CN':'请求类型。
        #  TOTAL：总请求数
        #  OTHER：其他URL请求数
        #  CUSTOMIZE：自定义URL请求数'}
        self.request_type = request_type
        # {'en':'Determine comparison conditions. 
        #  GT: greater than
        #  LT: less than
        #  GTE: greater than or equal to
        #  LTE: less than or equal to', 'zh_CN':'判定比较条件。
        #  GT：大于
        #  LT：小于
        #  GTE：大于等于
        #  LTE：小于等于'}
        self.judge_type = judge_type
        # {'en':'Determine comparison value.', 'zh_CN':'判定比较值。'}
        self.judge_value = judge_value
        # {'en':'Customized url match type. 
        #  Path: path
        #  URI: URI ', 'zh_CN':'自定义url匹配类型。
        #  Path：路径
        #  URI：URI'}
        self.customize_match_name = customize_match_name
        # {'en':'Customized url matching method. 
        #  DICT: complete matching
        #  REGEX: regular matching
        #  CONTAIN: contains', 'zh_CN':'自定义url匹配方式。
        #  DICT：完整匹配
        #  REGEX：正则匹配
        # CONTAIN：包含'}
        self.customize_path_match = customize_path_match
        # {'en':'Custom url.', 'zh_CN':'自定义url。'}
        self.customize_path = customize_path

    def validate(self):
        self.validate_required(self.request_type, 'request_type')
        self.validate_required(self.judge_type, 'judge_type')
        self.validate_required(self.judge_value, 'judge_value')
        self.validate_required(self.customize_match_name, 'customize_match_name')
        self.validate_required(self.customize_path_match, 'customize_path_match')
        self.validate_required(self.customize_path, 'customize_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_type is not None:
            result['requestType'] = self.request_type
        if self.judge_type is not None:
            result['judgeType'] = self.judge_type
        if self.judge_value is not None:
            result['judgeValue'] = self.judge_value
        if self.customize_match_name is not None:
            result['customizeMatchName'] = self.customize_match_name
        if self.customize_path_match is not None:
            result['customizePathMatch'] = self.customize_path_match
        if self.customize_path is not None:
            result['customizePath'] = self.customize_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestType') is not None:
            self.request_type = m.get('requestType')
        if m.get('judgeType') is not None:
            self.judge_type = m.get('judgeType')
        if m.get('judgeValue') is not None:
            self.judge_value = m.get('judgeValue')
        if m.get('customizeMatchName') is not None:
            self.customize_match_name = m.get('customizeMatchName')
        if m.get('customizePathMatch') is not None:
            self.customize_path_match = m.get('customizePathMatch')
        if m.get('customizePath') is not None:
            self.customize_path = m.get('customizePath')
        return self


class ListWorkflowRulesBotBehaviorAnalyseVO(TeaModel):
    def __init__(
        self,
        id: str = None,
        domain: str = None,
        rule_name: str = None,
        rule_description: str = None,
        act: str = None,
        act_type: str = None,
        statistical_period: int = None,
        statistical_item: str = None,
        protection_scope: List[ListWorkflowRulesProtectionPathDTO] = None,
        web_rule_condition: List[ListWorkflowRulesWebRuleConditionDTO] = None,
        api_rule_condition: List[ListWorkflowRulesApiRuleConditionDTO] = None,
        mode: str = None,
        wl_uri: List[str] = None,
    ):
        # {'en':'Primary key id.', 'zh_CN':'主键id。'}
        self.id = id
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Rule name.', 'zh_CN':'规则名称。'}
        self.rule_name = rule_name
        # {'en':'Rule description.', 'zh_CN':'规则描述。'}
        self.rule_description = rule_description
        # {'en':'Process actions. 
        #  NO_USE: not used
        #  BLOCK: block
        #  LOG: log
        #  custom action primary key id', 'zh_CN':'处理动作。
        #  NO_USE：不使用
        #  BLOCK：拦截
        #  LOG：监控 
        #  自定义处理动作主键id'}
        self.act = act
        # {'en':'Action type 
        #  SYS: system predefined
        #   CUSTOMIZE: customized', 'zh_CN':'处理动作类型。
        #  SYS：系统预定义 
        #  CUSTOMIZE：自定义'}
        self.act_type = act_type
        # {'en':'Statistical period, unit is seconds.', 'zh_CN':'统计周期，单位是秒。'}
        self.statistical_period = statistical_period
        # {'en':'Statistical granularity. 
        #  Client IP: IP
        #  IP-UA: Client IP and User-Agent', 'zh_CN':'统计粒度。
        #  IP：客户端IP
        #  IP-UA：客户端IP和User-Agent'}
        self.statistical_item = statistical_item
        # {'en':'Protection scope.', 'zh_CN':'防护范围。'}
        self.protection_scope = protection_scope
        # {'en':'Web scene trigger conditions.', 'zh_CN':'Web场景触发条件。'}
        self.web_rule_condition = web_rule_condition
        # {'en':'API scene trigger conditions.', 'zh_CN':'API场景触发条件。'}
        self.api_rule_condition = api_rule_condition
        # {'en':'Protected target. 
        #  WEB: WEB
        #  API: API', 'zh_CN':'应用场景。
        #  WEB：WEB场景
        #  API：API场景'}
        self.mode = mode
        # {'en':'Excluded path.', 'zh_CN':'例外路径。'}
        self.wl_uri = wl_uri

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_description, 'rule_description')
        self.validate_required(self.act, 'act')
        self.validate_required(self.act_type, 'act_type')
        self.validate_required(self.statistical_period, 'statistical_period')
        self.validate_required(self.statistical_item, 'statistical_item')
        self.validate_required(self.protection_scope, 'protection_scope')
        if self.protection_scope:
            for k in self.protection_scope:
                if k:
                    k.validate()
        self.validate_required(self.web_rule_condition, 'web_rule_condition')
        if self.web_rule_condition:
            for k in self.web_rule_condition:
                if k:
                    k.validate()
        self.validate_required(self.api_rule_condition, 'api_rule_condition')
        if self.api_rule_condition:
            for k in self.api_rule_condition:
                if k:
                    k.validate()
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.wl_uri, 'wl_uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.rule_description is not None:
            result['ruleDescription'] = self.rule_description
        if self.act is not None:
            result['act'] = self.act
        if self.act_type is not None:
            result['actType'] = self.act_type
        if self.statistical_period is not None:
            result['statisticalPeriod'] = self.statistical_period
        if self.statistical_item is not None:
            result['statisticalItem'] = self.statistical_item
        if self.protection_scope is not None:
            result['protectionScope'] = []
            for k in self.protection_scope:
                result['protectionScope'].append(k.to_map() if k else None)
        if self.web_rule_condition is not None:
            result['webRuleCondition'] = []
            for k in self.web_rule_condition:
                result['webRuleCondition'].append(k.to_map() if k else None)
        if self.api_rule_condition is not None:
            result['apiRuleCondition'] = []
            for k in self.api_rule_condition:
                result['apiRuleCondition'].append(k.to_map() if k else None)
        if self.mode is not None:
            result['mode'] = self.mode
        if self.wl_uri is not None:
            result['wlUri'] = self.wl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('ruleDescription') is not None:
            self.rule_description = m.get('ruleDescription')
        if m.get('act') is not None:
            self.act = m.get('act')
        if m.get('actType') is not None:
            self.act_type = m.get('actType')
        if m.get('statisticalPeriod') is not None:
            self.statistical_period = m.get('statisticalPeriod')
        if m.get('statisticalItem') is not None:
            self.statistical_item = m.get('statisticalItem')
        if m.get('protectionScope') is not None:
            self.protection_scope = []
            for k in m.get('protectionScope'):
                temp_model = ListWorkflowRulesProtectionPathDTO()
                self.protection_scope.append(temp_model.from_map(k))
        if m.get('webRuleCondition') is not None:
            self.web_rule_condition = []
            for k in m.get('webRuleCondition'):
                temp_model = ListWorkflowRulesWebRuleConditionDTO()
                self.web_rule_condition.append(temp_model.from_map(k))
        if m.get('apiRuleCondition') is not None:
            self.api_rule_condition = []
            for k in m.get('apiRuleCondition'):
                temp_model = ListWorkflowRulesApiRuleConditionDTO()
                self.api_rule_condition.append(temp_model.from_map(k))
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('wlUri') is not None:
            self.wl_uri = m.get('wlUri')
        return self


class ListWorkflowRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListWorkflowRulesBotBehaviorAnalyseVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListWorkflowRulesBotBehaviorAnalyseVO()
                self.data.append(temp_model.from_map(k))
        return self


class ListWorkflowRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListWorkflowRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListWorkflowRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListWorkflowRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateResponsePageOfDenyActionDetailRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        block_response_mode: str = None,
        rate_share_customize_action_id: str = None,
    ):
        # {"zh_CN":"域名。","en":"Hostname."}
        self.domain = domain
        # {"zh_CN":"拦截动作响应模式。
        #   DEFAULT：系统默认
        #   CUSTOMIZE：自定义","en":"Interception action response mode.
        #   DEFAULT:System default
        #   CUSTOMIZE:Custom"}
        self.block_response_mode = block_response_mode
        # {"zh_CN":"关联自定义响应id，blockResponseMode=CUSTOMIZE必填。","en":"Associated custom response id, blockResponseMode=CUSTOMIZE is required."}
        self.rate_share_customize_action_id = rate_share_customize_action_id

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.block_response_mode, 'block_response_mode')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.block_response_mode is not None:
            result['blockResponseMode'] = self.block_response_mode
        if self.rate_share_customize_action_id is not None:
            result['rateShareCustomizeActionId'] = self.rate_share_customize_action_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('blockResponseMode') is not None:
            self.block_response_mode = m.get('blockResponseMode')
        if m.get('rateShareCustomizeActionId') is not None:
            self.rate_share_customize_action_id = m.get('rateShareCustomizeActionId')
        return self


class UpdateResponsePageOfDenyActionDetailResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateResponsePageOfDenyActionDetailPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateResponsePageOfDenyActionDetailParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateResponsePageOfDenyActionDetailRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateResponsePageOfDenyActionDetailResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class CreateBuiltInRuleRuleConfig(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        mode: int = None,
        config: str = None,
    ):
        # {"en":"Rule ID.", "zh_CN":"规则ID。"}
        self.rule_id = rule_id
        # {"en":"The action to execute when a rule is matched.
        #     0: Off
        #     1: Block
        #     2: Log", "zh_CN":"触发规则时的处理动作。
        #     0：关闭
        #     1：拦截
        #     2：监控"}
        self.mode = mode
        # {"en":"The rules of RFC can be customized by the config configuration. If left blank, the default configuration will be used, detailed configuration instructions are as follows:
        # 
        #     The config configuration of each rule for RFC is as follows:
        #     rule ID: 7500    rule name: header_miss 
        #     configurable options: Host, User-Agent, Accept, Accept-Language, Accept-Encoding
        #     example config configuration:
        #     {
        #       \"header_miss\": [
        #         \"Accept\",
        #         \"Accept-Encoding\"
        #       ]
        #     }
        # 
        #     rule ID: 7502    rule name: uncommon_request_method 
        #     configurable options: HEAD, PUT, DELETE, CONNECT, OPTIONS, TRACE, PATCH, PROPFIND, MKCOL, COPY, MOVE, LOCK, UNLOCK
        #     example config configuration:
        #     {
        #       \"method\": [
        #         \"CONNECT\",
        #         \"PROPFIND\",
        #         \"PUT\"
        #       ]
        #     }
        # 
        #     rule ID: 7503    rule name: uncommon_protocol 
        #     configurable options: 1.0, 1.1, 2.0 and customized http version, Set protocol_other to 1 if you want to restrict all versions except HTTP1.0, HTTP1.1, HTTP2.0.
        #     1.0: HTTP1.0
        #     1.1: HTTP1.1
        #     2.0: HTTP2.0
        #     example config configuration: 
        #     {
        #       \"protocol\": [
        #         \"1.0\",
        #         \"1.1\",
        #         \"2.0\",
        #         \"3.0\"
        #       ],
        #       \"protocol_other\": 1
        #     }
        # 
        #     rule ID: 7600    rule name: big_request_line 
        #     required fields, Three types of units are available (B,KB,MB).
        #         uri_len: Maximum length of URI (default: 4096B),
        #     example config configuration: 
        #     {
        #       \"header_restrict\": {
        #         \"uri_len\": \"4096KB\"
        #       }
        #     }
        # 
        #     rule ID: 7601    rule name: big_header_line 
        #     required fields, Three types of units are available (B,KB,MB,The default unit is B).
        #         header_name_len: Maximum length of HTTP header field name (default: 64B),
        #         header_value_len: Maximum length of HTTP header field value (default: 4096B),
        #         user_agent_len: Maximum length of User-Agent (default: 1024B),
        #         referer_len: Maximum length of Referer (default: 4096B),
        #         accept_len: Maximum length of Accept (default: 1024B),
        #         accept_charset_len: Maximum length of Accept-Charset (default: 128B),
        #         cookie_len: Maximum length of Cookie (default: 8192B)
        #     example config configuration:
        #     {
        #       \"header_restrict\": {
        #         \"cookie_len\": \"8192\",
        #         \"header_name_len\": \"64\",
        #         \"accept_len\": \"1024\",
        #         \"referer_len\": \"4096\",
        #         \"header_value_len\": \"4096\",
        #         \"accept_charset_len\": \"128MB\",
        #         \"user_agent_len\": \"1024KB\"
        #       }
        #     }
        # 
        #     rule ID: 7603    rule name: big_headers_num 
        #     required fields:
        #         header_num: Maximum length of HTTP header field (default: 50)
        #     example config configuration:
        #     {
        #       \"header_restrict\": {
        #         \"header_num\": \"50\"
        #       }
        #     }
        # 
        #     rule ID: 7605    rule name: big_body_num 
        #     required fields:
        #         body_param_num: Limit on the number of body parameters (default: 0)
        #     example config configuration:
        #     {
        #       \"body_param_num\": \"2\"
        #     }","zh_CN":"归属协议攻击类型的规则可以自定义config配置,config置空将采用默认配置，具体配置说明如下:
        #     规则ID: 7500    规则名称: header_miss 
        #     配置项说明: Host, User-Agent, Accept, Accept-Language, Accept-Encoding
        #     config配置示例:
        #     {
        #       \"header_miss\": [
        #         \"Accept\",
        #         \"Accept-Encoding\"
        #       ]
        #     }
        # 
        #     规则ID: 7502    规则名称: uncommon_request_method 
        #     配置项说明: HEAD, PUT, DELETE, CONNECT, OPTIONS, TRACE, PATCH, PROPFIND, MKCOL, COPY, MOVE, LOCK, UNLOCK
        #     config配置示例:
        #     {
        #       \"method\": [
        #         \"CONNECT\",
        #         \"PROPFIND\",
        #         \"PUT\"
        #       ]
        #     }
        # 
        #     规则ID: 7503    规则名称: uncommon_protocol 
        #     配置项说明: 1.0, 1.1, 2.0, 及自定义版本, 要限制除了HTTP1.0,HTTP1.1,HTTP2.0以外的所有版本请将protocol_other的值配置为1
        #     1.0：HTTP1.0
        #     1.1：HTTP1.1
        #     2.0：HTTP2.0
        #     config配置示例: 
        #     {
        #       \"protocol\": [
        #         \"1.0\",
        #         \"1.1\",
        #         \"2.0\",
        #         \"3.0\"
        #       ],
        #       \"protocol_other\": 1
        #     }
        # 
        #     规则ID: 7600    规则名称: big_request_line 
        #     配置项说明：
        #     uri_len：URI最大长度 (默认值4096B)，单位可选 (B,KB,MB)
        #     config配置示例：
        #     {
        #       \"header_restrict\": {
        #         \"uri_len\": \"4096KB\"
        #       }
        #     }
        # 
        #     规则ID: 7601    规则名称: big_header_line 
        #     配置项说明, 单位可选 (B,KB,MB,默认B): 
        #         header_name_len: 请求头部参数名最大长度 (默认值64B),
        #         header_value_len: 请求头部参数值最大长度 (默认值4096B),
        #         user_agent_len: User-Agent最大长度 (默认值1024B),
        #         referer_len: Referer最大长度 (默认值4096B),
        #         accept_len: Accept最大长度 (默认值1024B),
        #         accept_charset_len: Accept-Charset最大长度 (默认值128B),
        #         cookie_len: Cookie最大长度 (默认值8192B)
        #     config配置示例 (不带单位默认单位为B)：
        #     {
        #       \"header_restrict\": {
        #         \"cookie_len\": \"8192\",
        #         \"header_name_len\": \"64\",
        #         \"accept_len\": \"1024\",
        #         \"referer_len\": \"4096\",
        #         \"header_value_len\": \"4096\",
        #         \"accept_charset_len\": \"128MB\",
        #         \"user_agent_len\": \"1024KB\"
        #       }
        #     }
        # 
        #     规则ID: 7603    规则名称: big_headers_num 
        #     配置项说明:    
        #     header_num: 请求头部参数最大个数 (默认值50)
        #     config配置示例: 
        #     {
        #       \"header_restrict\": {
        #         \"header_num\": \"50\"
        #       }
        #     }
        # 
        #     规则ID: 7605    规则名称: big_body_num 
        #     配置项说明: 
        #     body_param_num: Body参数个数限制 (默认值0)
        #     config配置示例: 
        #     {
        #       \"body_param_num\": \"2\"
        #     }"}
        self.config = config

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.mode, 'mode')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.mode is not None:
            result['mode'] = self.mode
        if self.config is not None:
            result['config'] = self.config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('config') is not None:
            self.config = m.get('config')
        return self


class CreateBuiltInRuleRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        update_type: int = None,
        msg: str = None,
        copy_name: str = None,
        rule_config: List[CreateBuiltInRuleRuleConfig] = None,
    ):
        # {"en":"Template name.", "zh_CN":"模板名称。"}
        self.name = name
        # {"en":"
        #     Enable: The updated rules are automatically added to the template, and the rule action is automatically set to the recommended action;
        #     Disable: The updated rules are automatically added to the template, and the rule action is set to log by default.
        #     1: yes
        #     0: no.", "zh_CN":"
        #     开启：更新的规则自动加入到模板中，规则动作会自动设置为建议动作；
        #     关闭：更新的规则自动加入到模板中，规则动作默认设置为监控。
        #     1：是
        #     0：否。"}
        self.update_type = update_type
        # {"en":"Template description.", "zh_CN":"模板描述。"}
        self.msg = msg
        # {"en":"Enter the name of reference template, the new template will copy the configuration of the reference template.", "zh_CN":"参考模板的名称，新模板将复制参考模板的配置。"}
        self.copy_name = copy_name
        # {"en":"Have to change the rule configuration, array,The default data synchronization from the system", "zh_CN":"缺省状态下默认采用参考模板的配置或者系统默认配置（若参考模板缺省），也可修改指定规则的配置，未指定的规则采用默认配置。"}
        self.rule_config = rule_config

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.update_type, 'update_type')
        self.validate_required(self.msg, 'msg')
        if self.rule_config:
            for k in self.rule_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.update_type is not None:
            result['updateType'] = self.update_type
        if self.msg is not None:
            result['msg'] = self.msg
        if self.copy_name is not None:
            result['copyName'] = self.copy_name
        if self.rule_config is not None:
            result['ruleConfig'] = []
            for k in self.rule_config:
                result['ruleConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('updateType') is not None:
            self.update_type = m.get('updateType')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('copyName') is not None:
            self.copy_name = m.get('copyName')
        if m.get('ruleConfig') is not None:
            self.rule_config = []
            for k in m.get('ruleConfig'):
                temp_model = CreateBuiltInRuleRuleConfig()
                self.rule_config.append(temp_model.from_map(k))
        return self


class CreateBuiltInRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class CreateBuiltInRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateBuiltInRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateBuiltInRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateBuiltInRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class RejectRecommendationsRequest(TeaModel):
    def __init__(
        self,
        id_list: List[str] = None,
    ):
        # {'en':'Recommendation ID.', 'zh_CN':'规则建议ID。'}
        self.id_list = id_list

    def validate(self):
        self.validate_required(self.id_list, 'id_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_list is not None:
            result['idList'] = self.id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('idList') is not None:
            self.id_list = m.get('idList')
        return self


class RejectRecommendationsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class RejectRecommendationsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class RejectRecommendationsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class RejectRecommendationsRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class RejectRecommendationsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListWAFBasicConfigOfHostnamesRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
    ):
        # {'en':'Hostname list.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class ListWAFBasicConfigOfHostnamesWafDomainConfBasicVO(TeaModel):
    def __init__(
        self,
        id: str = None,
        domain: str = None,
        defend_mode: str = None,
        rule_update_mode: str = None,
        rule_version: str = None,
    ):
        # {'en':'ID.', 'zh_CN':'ID。'}
        self.id = id
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'Protection Mode.
        #   BLOCK: Block the attack request directly.
        #   LOG: Only log the attack request without blocking it.', 'zh_CN':'防护模式。
        #   BLOCK：直接拦截攻击请求。
        #   LOG：记录日志，不拦截攻击请求。'}
        self.defend_mode = defend_mode
        # {'en':'Ruleset Mode.
        #   MANUAL:  Check Ruleset update and all Recommendations on the Console, decide to apply them or not, all of these must be done by yourself manually.
        #   AUTO: Automatically upgrade the Ruleset to the latest version and apply the Recommendations learned from your website traffic to Exception, which can keep your website with high-level security anytime.', 'zh_CN':'规则集模式。
        #   MANUAL：规则集有更新，或系统自动学习网站流量生成规则例外建议时，需自主评估是否更新配置。
        #   AUTO：规则集有更新，或系统自动学习网站流量生成规则例外建议时，自动更新配置。'}
        self.rule_update_mode = rule_update_mode
        # {'en':'Ruleset version.', 'zh_CN':'规则集版本。'}
        self.rule_version = rule_version

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.defend_mode, 'defend_mode')
        self.validate_required(self.rule_update_mode, 'rule_update_mode')
        self.validate_required(self.rule_version, 'rule_version')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.defend_mode is not None:
            result['defendMode'] = self.defend_mode
        if self.rule_update_mode is not None:
            result['ruleUpdateMode'] = self.rule_update_mode
        if self.rule_version is not None:
            result['ruleVersion'] = self.rule_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('defendMode') is not None:
            self.defend_mode = m.get('defendMode')
        if m.get('ruleUpdateMode') is not None:
            self.rule_update_mode = m.get('ruleUpdateMode')
        if m.get('ruleVersion') is not None:
            self.rule_version = m.get('ruleVersion')
        return self


class ListWAFBasicConfigOfHostnamesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListWAFBasicConfigOfHostnamesWafDomainConfBasicVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Data.', 'zh_CN':'出参数据。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListWAFBasicConfigOfHostnamesWafDomainConfBasicVO()
                self.data.append(temp_model.from_map(k))
        return self


class ListWAFBasicConfigOfHostnamesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListWAFBasicConfigOfHostnamesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListWAFBasicConfigOfHostnamesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListWAFBasicConfigOfHostnamesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetConcurrencyLimitRuleListRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConcurrencyLimitRuleListVo(TeaModel):
    def __init__(
        self,
        id: str = None,
        api_count: int = None,
        control_action: str = None,
        limit_duration: str = None,
        policy_name: str = None,
        remark: str = None,
        status: str = None,
        threshold_value: str = None,
        update_time: str = None,
    ):
        # {"en":"Rule ID.", "zh_CN":"规则ID。"}
        self.id = id
        # {"en":"The number of APIs.", "zh_CN":"API数。"}
        self.api_count = api_count
        # {"en":"Control action,default value: INTERCEPT.
        # INTERCEPT:Block
        # MONITOR:Log", "zh_CN":"控制动作，默认值：INTERCEPT。
        # INTERCEPT：拦截
        # MONITOR：监控"}
        self.control_action = control_action
        # {"en":"Time period.", "zh_CN":"限制时长。"}
        self.limit_duration = limit_duration
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.policy_name = policy_name
        # {"en":"Note.", "zh_CN":"备注。"}
        self.remark = remark
        # {"en":"Status.
        # ON:on
        # OFF:off", "zh_CN":"状态。
        # ON：开
        # OFF：关"}
        self.status = status
        # {"en":"API current limiting threshold.", "zh_CN":"API限流阈值。"}
        self.threshold_value = threshold_value
        # {"en":"Update time,format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"更新时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.api_count, 'api_count')
        self.validate_required(self.control_action, 'control_action')
        self.validate_required(self.limit_duration, 'limit_duration')
        self.validate_required(self.policy_name, 'policy_name')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.status, 'status')
        self.validate_required(self.threshold_value, 'threshold_value')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.api_count is not None:
            result['apiCount'] = self.api_count
        if self.control_action is not None:
            result['controlAction'] = self.control_action
        if self.limit_duration is not None:
            result['limitDuration'] = self.limit_duration
        if self.policy_name is not None:
            result['policyName'] = self.policy_name
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.threshold_value is not None:
            result['thresholdValue'] = self.threshold_value
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('apiCount') is not None:
            self.api_count = m.get('apiCount')
        if m.get('controlAction') is not None:
            self.control_action = m.get('controlAction')
        if m.get('limitDuration') is not None:
            self.limit_duration = m.get('limitDuration')
        if m.get('policyName') is not None:
            self.policy_name = m.get('policyName')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thresholdValue') is not None:
            self.threshold_value = m.get('thresholdValue')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetConcurrencyLimitRuleListPage(TeaModel):
    def __init__(
        self,
        current: int = None,
        pages: int = None,
        size: int = None,
        total: int = None,
        records: List[GetConcurrencyLimitRuleListVo] = None,
    ):
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.current = current
        # {"en":"The total number of pages.", "zh_CN":"总页数。"}
        self.pages = pages
        # {"en":"The number of records per page.", "zh_CN":"每页规则条数。"}
        self.size = size
        # {"en":"The total number of records.", "zh_CN":"总条数。"}
        self.total = total
        # {"en":"List of high concurrency limit rule.", "zh_CN":"限流规则列表。"}
        self.records = records

    def validate(self):
        self.validate_required(self.current, 'current')
        self.validate_required(self.pages, 'pages')
        self.validate_required(self.size, 'size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current is not None:
            result['current'] = self.current
        if self.pages is not None:
            result['pages'] = self.pages
        if self.size is not None:
            result['size'] = self.size
        if self.total is not None:
            result['total'] = self.total
        if self.records is not None:
            result['records'] = []
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('current') is not None:
            self.current = m.get('current')
        if m.get('pages') is not None:
            self.pages = m.get('pages')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('records') is not None:
            self.records = []
            for k in m.get('records'):
                temp_model = GetConcurrencyLimitRuleListVo()
                self.records.append(temp_model.from_map(k))
        return self


class GetConcurrencyLimitRuleListResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: GetConcurrencyLimitRuleListPage = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            temp_model = GetConcurrencyLimitRuleListPage()
            self.data = temp_model.from_map(m['data'])
        return self


class GetConcurrencyLimitRuleListPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConcurrencyLimitRuleListParameters(TeaModel):
    def __init__(
        self,
        page: int = None,
        size: int = None,
        policy_name: str = None,
    ):
        # {"en":"The current page number.", "zh_CN":"当前页码。"}
        self.page = page
        # {"en":"The number of records per page.", "zh_CN":"每页规则条数。"}
        self.size = size
        # {"en":"Rule name.", "zh_CN":"规则名称。"}
        self.policy_name = policy_name

    def validate(self):
        self.validate_required(self.page, 'page')
        self.validate_required(self.size, 'size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.size is not None:
            result['size'] = self.size
        if self.policy_name is not None:
            result['policyName'] = self.policy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('policyName') is not None:
            self.policy_name = m.get('policyName')
        return self


class GetConcurrencyLimitRuleListRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetConcurrencyLimitRuleListResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class CreateExceptionToWAFManagedRulesRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_id: int = None,
        type: str = None,
        match_type: str = None,
        content_list: List[str] = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'WAF rule ID.', 'zh_CN':'WAF规则ID。'}
        self.rule_id = rule_id
        # {'en':'Matching conditions.
        # ip: IP
        # path: Path
        # uri: URI
        # urlParamName: URI Parameter Name
        # urlParamValue: URI Parameter Value
        # userAgent: User Agent
        # httpHeaderName: Request Header Name
        # httpHeaderValue: Request Header Value
        # cookie: Cookie
        # body: Body
        # bodyParamName: Body Parameter Name
        # bodyParamValue: Body Parameter Value', 'zh_CN':'匹配条件。
        # ip：IP
        # path：路径
        # uri：URI
        # urlParamName：URI参数名
        # urlParamValue：URI参数值
        # userAgent：User Agent
        # httpHeaderName：请求头部名称
        # httpHeaderValue：请求头部值
        # cookie：Cookie
        # body：Body
        # bodyParamName：Body参数名
        # bodyParamValue：Body参数值'}
        self.type = type
        # {'en':'Match type,IP can only be EQUAL.
        # EQUAL: Equal
        # CONTAIN: Contains
        # REGEX: Regular match', 'zh_CN':'匹配类型，IP只能是等于。
        # EQUAL：等于
        # CONTAIN：包含
        # REGEX：正则匹配'}
        self.match_type = match_type
        # {'en':'Rule exceptions.
        # When matchType=EQUAL, case-sensitive, path and uri must start with "/", and body can only pass one value;
        # When matchType=REGEX, only one value can be passed.', 'zh_CN':'规则例外内容。
        # matchType=EQUAL时，大小写敏感，path和uri必须以"/"开头，body只能传一个值；
        # matchType=REGEX时，只能传一个值。'}
        self.content_list = content_list

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.content_list, 'content_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.type is not None:
            result['type'] = self.type
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.content_list is not None:
            result['contentList'] = self.content_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('contentList') is not None:
            self.content_list = m.get('contentList')
        return self


class CreateExceptionToWAFManagedRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg
        # {'en':'Rule exception ID.', 'zh_CN':'规则例外ID。'}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreateExceptionToWAFManagedRulesPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateExceptionToWAFManagedRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateExceptionToWAFManagedRulesRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class CreateExceptionToWAFManagedRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateModeOfWAFRequest(TeaModel):
    def __init__(
        self,
        domain_list: List[str] = None,
        defend_mode: str = None,
        rule_update_mode: str = None,
    ):
        # {'en':'Hostname list.', 'zh_CN':'域名列表。'}
        self.domain_list = domain_list
        # {'en':'Protection Mode.
        #   BLOCK: Block the attack request directly.
        #   LOG: Only log the attack request without blocking it.', 'zh_CN':'防护模式。
        #   BLOCK：直接拦截攻击请求。
        #   LOG：记录日志，不拦截攻击请求。'}
        self.defend_mode = defend_mode
        # {'en':'Ruleset Mode.
        #   MANUAL: Check Ruleset update and all Recommendations on the Console, decide to apply them or not, all of these must be done by yourself manually.
        #   AUTO: Automatically upgrade the Ruleset to the latest version and apply the Recommendations learned from your website traffic to Exception, which can keep your website with high-level security anytime.', 'zh_CN':'规则集模式。
        #   MANUAL：规则集有更新，或系统自动学习网站流量生成规则例外建议时，需自主评估是否更新配置。
        #   AUTO：规则集有更新，或系统自动学习网站流量生成规则例外建议时，自动更新配置。'}
        self.rule_update_mode = rule_update_mode

    def validate(self):
        self.validate_required(self.domain_list, 'domain_list')
        self.validate_required(self.defend_mode, 'defend_mode')
        self.validate_required(self.rule_update_mode, 'rule_update_mode')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.defend_mode is not None:
            result['defendMode'] = self.defend_mode
        if self.rule_update_mode is not None:
            result['ruleUpdateMode'] = self.rule_update_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('defendMode') is not None:
            self.defend_mode = m.get('defendMode')
        if m.get('ruleUpdateMode') is not None:
            self.rule_update_mode = m.get('ruleUpdateMode')
        return self


class UpdateModeOfWAFResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateModeOfWAFPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateModeOfWAFParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateModeOfWAFRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateModeOfWAFResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteConcurrencyLimitRuleRequest(TeaModel):
    def __init__(
        self,
        ids: List[str] = None,
    ):
        # {"en":"List of high concurrency limit rule ID to delete.", "zh_CN":"要删除的限流规则ID列表。"}
        self.ids = ids

    def validate(self):
        self.validate_required(self.ids, 'ids')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ids') is not None:
            self.ids = m.get('ids')
        return self


class DeleteConcurrencyLimitRuleResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        data: List[str] = None,
    ):
        # {"en":"Return 200 means success.", "zh_CN":"200状态码表示请求成功。"}
        self.code = code
        # {"en":"Message.", "zh_CN":"返回信息。"}
        self.msg = msg
        # {"en":"List of deleted high concurrency limit rule name.", "zh_CN":"被删除的规则名称。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class DeleteConcurrencyLimitRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteConcurrencyLimitRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteConcurrencyLimitRuleRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteConcurrencyLimitRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class AssociateShareWAFRuleExceptionWafDomainRuleExceptionShareAddDTO(TeaModel):
    def __init__(
        self,
        domain: str = None,
        rule_id: int = None,
        share_id: str = None,
    ):
        # {'en':'Hostname.', 'zh_CN':'域名。'}
        self.domain = domain
        # {'en':'WAF rule ID.', 'zh_CN':'WAF规则ID。'}
        self.rule_id = rule_id
        # {'en':'Shared configuration WAF rule exception ID.', 'zh_CN':'共享的WAF规则例外ID。'}
        self.share_id = share_id

    def validate(self):
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.share_id, 'share_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        if self.share_id is not None:
            result['shareId'] = self.share_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        if m.get('shareId') is not None:
            self.share_id = m.get('shareId')
        return self


class AssociateShareWAFRuleExceptionRequest(TeaModel):
    def __init__(
        self,
        share_exception_list: List[AssociateShareWAFRuleExceptionWafDomainRuleExceptionShareAddDTO] = None,
    ):
        # {'en':'Introduced sharing.', 'zh_CN':'引入的共享。'}
        self.share_exception_list = share_exception_list

    def validate(self):
        self.validate_required(self.share_exception_list, 'share_exception_list')
        if self.share_exception_list:
            for k in self.share_exception_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.share_exception_list is not None:
            result['shareExceptionList'] = []
            for k in self.share_exception_list:
                result['shareExceptionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('shareExceptionList') is not None:
            self.share_exception_list = []
            for k in m.get('shareExceptionList'):
                temp_model = AssociateShareWAFRuleExceptionWafDomainRuleExceptionShareAddDTO()
                self.share_exception_list.append(temp_model.from_map(k))
        return self


class AssociateShareWAFRuleExceptionResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {'en':'Description.', 'zh_CN':'描述信息。'}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class AssociateShareWAFRuleExceptionPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AssociateShareWAFRuleExceptionParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AssociateShareWAFRuleExceptionRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class AssociateShareWAFRuleExceptionResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListDomainInfosRequest(TeaModel):
    def __init__(
        self,
        defend_status: str = None,
        domain_list: List[str] = None,
        dms_defend_switch: str = None,
        rate_limit_switch: str = None,
        block_switch: str = None,
        waf_defend_switch: str = None,
        intelligence_switch: str = None,
        whitelist_switch: str = None,
        bot_manage_switch: str = None,
        customize_rule_switch: str = None,
        api_defend_switch: str = None,
    ):
        # {"en":"Protection status, If not specified, it means all the protection status.
        # PROTECTING: Protecting
        # UNPROTECTED: Unprotected", "zh_CN":"防护状态，未指定时查询所有防护状态。
        # PROTECTING：防护中
        # UNPROTECTED：未防护"}
        self.defend_status = defend_status
        # {"en":"Hostname list, if not specified, it means all the hostnames of the account.", "zh_CN":"域名列表，未指定时查询账号下的所有域名。"}
        self.domain_list = domain_list
        # {"en":"DDoS protection switch, if not specified, it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"DDoS防护开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.dms_defend_switch = dms_defend_switch
        # {"en":"Rate limiting switch, if not specified,  it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"频率限制开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.rate_limit_switch = rate_limit_switch
        # {"en":"IP/Geo blocking switch, if not specified,  it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"IP/区域封禁开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.block_switch = block_switch
        # {"en":"WAF protection switch, if not specified, it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"WAF防护开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.waf_defend_switch = waf_defend_switch
        # {"en":"Threat intelligence switch, if not specified,  it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"威胁情报开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.intelligence_switch = intelligence_switch
        # {"en":"Whitelist switch, if not specified,  it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"白名单开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.whitelist_switch = whitelist_switch
        # {"en":"Bot management switch, if not specified,  it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"Bot管理开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.bot_manage_switch = bot_manage_switch
        # {"en":"Custom rules switch, if not specified, it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"自定义规则开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.customize_rule_switch = customize_rule_switch
        # {"en":"API security switch, if not specified, it means all the status.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"API安全开关，未指定时查询该开关所有状态。
        # ON：开启
        # OFF：关闭"}
        self.api_defend_switch = api_defend_switch

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defend_status is not None:
            result['defendStatus'] = self.defend_status
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        if self.dms_defend_switch is not None:
            result['dmsDefendSwitch'] = self.dms_defend_switch
        if self.rate_limit_switch is not None:
            result['rateLimitSwitch'] = self.rate_limit_switch
        if self.block_switch is not None:
            result['blockSwitch'] = self.block_switch
        if self.waf_defend_switch is not None:
            result['wafDefendSwitch'] = self.waf_defend_switch
        if self.intelligence_switch is not None:
            result['intelligenceSwitch'] = self.intelligence_switch
        if self.whitelist_switch is not None:
            result['whitelistSwitch'] = self.whitelist_switch
        if self.bot_manage_switch is not None:
            result['botManageSwitch'] = self.bot_manage_switch
        if self.customize_rule_switch is not None:
            result['customizeRuleSwitch'] = self.customize_rule_switch
        if self.api_defend_switch is not None:
            result['apiDefendSwitch'] = self.api_defend_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defendStatus') is not None:
            self.defend_status = m.get('defendStatus')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        if m.get('dmsDefendSwitch') is not None:
            self.dms_defend_switch = m.get('dmsDefendSwitch')
        if m.get('rateLimitSwitch') is not None:
            self.rate_limit_switch = m.get('rateLimitSwitch')
        if m.get('blockSwitch') is not None:
            self.block_switch = m.get('blockSwitch')
        if m.get('wafDefendSwitch') is not None:
            self.waf_defend_switch = m.get('wafDefendSwitch')
        if m.get('intelligenceSwitch') is not None:
            self.intelligence_switch = m.get('intelligenceSwitch')
        if m.get('whitelistSwitch') is not None:
            self.whitelist_switch = m.get('whitelistSwitch')
        if m.get('botManageSwitch') is not None:
            self.bot_manage_switch = m.get('botManageSwitch')
        if m.get('customizeRuleSwitch') is not None:
            self.customize_rule_switch = m.get('customizeRuleSwitch')
        if m.get('apiDefendSwitch') is not None:
            self.api_defend_switch = m.get('apiDefendSwitch')
        return self


class ListDomainInfosSysDomainInfoVO(TeaModel):
    def __init__(
        self,
        id: str = None,
        domain: str = None,
        create_time: str = None,
        deploy_status: str = None,
        block_switch: str = None,
        defend_status: str = None,
        dms_defend_switch: str = None,
        bot_manage_switch: str = None,
        customize_rule_switch: str = None,
        api_defend_switch: str = None,
        rate_limit_switch: str = None,
        whitelist_switch: str = None,
        intelligence_switch: str = None,
        waf_defend_switch: str = None,
    ):
        # {"en":"ID.", "zh_CN":"ID。"}
        self.id = id
        # {"en":"Hostname.", "zh_CN":"域名。"}
        self.domain = domain
        # {"en":"Created time, format: yyyy-MM-dd HH:mm:ss.", "zh_CN":"接入时间，格式：yyyy-MM-dd HH:mm:ss。"}
        self.create_time = create_time
        # {"en":"Deployment status.
        # DEPLOYING: Publishing
        # SUCCESS: Success", "zh_CN":"部署状态。
        # DEPLOYING：部署中
        # SUCCESS：部署成功"}
        self.deploy_status = deploy_status
        # {"en":"IP/Geo blocking switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"IP/区域封禁开关。
        # ON：开启
        # OFF：关闭"}
        self.block_switch = block_switch
        # {"en":"Protection status.
        # PROTECTING: Protecting
        # UNPROTECTED: Unprotected", "zh_CN":"防护状态。
        # PROTECTING：防护中
        # UNPROTECTED：未防护"}
        self.defend_status = defend_status
        # {"en":"DDoS protection switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"DDoS防护开关。
        # ON：开启
        # OFF：关闭"}
        self.dms_defend_switch = dms_defend_switch
        # {"en":"Bot management switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"Bot管理开关。
        # ON：开启
        # OFF：关闭"}
        self.bot_manage_switch = bot_manage_switch
        # {"en":"Custom rules switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"自定义规则开关。
        # ON：开启
        # OFF：关闭"}
        self.customize_rule_switch = customize_rule_switch
        # {"en":"API security switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"API安全开关。
        # ON：开启
        # OFF：关闭"}
        self.api_defend_switch = api_defend_switch
        # {"en":"Rate limiting switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"频率限制开关。
        # ON：开启
        # OFF：关闭"}
        self.rate_limit_switch = rate_limit_switch
        # {"en":"Whitelist switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"白名单开关。
        # ON：开启
        # OFF：关闭"}
        self.whitelist_switch = whitelist_switch
        # {"en":"Threat intelligence switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"威胁情报开关。
        # ON：开启
        # OFF：关闭"}
        self.intelligence_switch = intelligence_switch
        # {"en":"WAF protection switch.
        # ON: Enabled
        # OFF: Disabled", "zh_CN":"WAF防护开关。
        # ON：开启
        # OFF：关闭"}
        self.waf_defend_switch = waf_defend_switch

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.deploy_status, 'deploy_status')
        self.validate_required(self.block_switch, 'block_switch')
        self.validate_required(self.defend_status, 'defend_status')
        self.validate_required(self.dms_defend_switch, 'dms_defend_switch')
        self.validate_required(self.bot_manage_switch, 'bot_manage_switch')
        self.validate_required(self.customize_rule_switch, 'customize_rule_switch')
        self.validate_required(self.api_defend_switch, 'api_defend_switch')
        self.validate_required(self.rate_limit_switch, 'rate_limit_switch')
        self.validate_required(self.whitelist_switch, 'whitelist_switch')
        self.validate_required(self.intelligence_switch, 'intelligence_switch')
        self.validate_required(self.waf_defend_switch, 'waf_defend_switch')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.domain is not None:
            result['domain'] = self.domain
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.deploy_status is not None:
            result['deployStatus'] = self.deploy_status
        if self.block_switch is not None:
            result['blockSwitch'] = self.block_switch
        if self.defend_status is not None:
            result['defendStatus'] = self.defend_status
        if self.dms_defend_switch is not None:
            result['dmsDefendSwitch'] = self.dms_defend_switch
        if self.bot_manage_switch is not None:
            result['botManageSwitch'] = self.bot_manage_switch
        if self.customize_rule_switch is not None:
            result['customizeRuleSwitch'] = self.customize_rule_switch
        if self.api_defend_switch is not None:
            result['apiDefendSwitch'] = self.api_defend_switch
        if self.rate_limit_switch is not None:
            result['rateLimitSwitch'] = self.rate_limit_switch
        if self.whitelist_switch is not None:
            result['whitelistSwitch'] = self.whitelist_switch
        if self.intelligence_switch is not None:
            result['intelligenceSwitch'] = self.intelligence_switch
        if self.waf_defend_switch is not None:
            result['wafDefendSwitch'] = self.waf_defend_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('deployStatus') is not None:
            self.deploy_status = m.get('deployStatus')
        if m.get('blockSwitch') is not None:
            self.block_switch = m.get('blockSwitch')
        if m.get('defendStatus') is not None:
            self.defend_status = m.get('defendStatus')
        if m.get('dmsDefendSwitch') is not None:
            self.dms_defend_switch = m.get('dmsDefendSwitch')
        if m.get('botManageSwitch') is not None:
            self.bot_manage_switch = m.get('botManageSwitch')
        if m.get('customizeRuleSwitch') is not None:
            self.customize_rule_switch = m.get('customizeRuleSwitch')
        if m.get('apiDefendSwitch') is not None:
            self.api_defend_switch = m.get('apiDefendSwitch')
        if m.get('rateLimitSwitch') is not None:
            self.rate_limit_switch = m.get('rateLimitSwitch')
        if m.get('whitelistSwitch') is not None:
            self.whitelist_switch = m.get('whitelistSwitch')
        if m.get('intelligenceSwitch') is not None:
            self.intelligence_switch = m.get('intelligenceSwitch')
        if m.get('wafDefendSwitch') is not None:
            self.waf_defend_switch = m.get('wafDefendSwitch')
        return self


class ListDomainInfosResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
        data: List[ListDomainInfosSysDomainInfoVO] = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg
        # {"en":"Data.", "zh_CN":"出参数据。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListDomainInfosSysDomainInfoVO()
                self.data.append(temp_model.from_map(k))
        return self


class ListDomainInfosPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListDomainInfosParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListDomainInfosRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class ListDomainInfosResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateWhitelistRuleIpOrIpsCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ip_or_ips: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals
        # NOT_EQUAL: Does not equal", "zh_CN":"匹配类型。
        # EQUAL：等于
        # NOT_EQUAL：不等于"}
        self.match_type = match_type
        # {"en":"IP/CIDR, maximum 500 IP/CIDR.", "zh_CN":"IP/IP段，最多500个IP/IP段。"}
        self.ip_or_ips = ip_or_ips

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ip_or_ips, 'ip_or_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ip_or_ips is not None:
            result['ipOrIps'] = self.ip_or_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ipOrIps') is not None:
            self.ip_or_ips = m.get('ipOrIps')
        return self


class UpdateWhitelistRulePathCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        paths: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, path case sensitive
        # NOT_EQUAL: Does not equal, path case sensitive
        # CONTAIN: Contains, path case insensitive
        # NOT_CONTAIN: Does not Contains, path case insensitive
        # REGEX: Regex match, path case insensitive
        # NOT_REGEX: Regular does not match, path case sensitive
        # START_WITH: Starts with, path case sensitive
        # END_WITH: Ends with, path case sensitive
        # WILDCARD: Wildcard matches, path case sensitive, ** represents zero or more arbitrary characters, ? represents any single character.
        # NOT_WILDCARD: Wildcard does not match, path case sensitive, ** represents zero or more arbitrary characters, ? represents any single character ", "zh_CN":"匹配类型。
        # EQUAL：等于，路径大小写敏感
        # NOT_EQUAL：不等于，路径大小写敏感
        # CONTAIN：包含，路径大小写不敏感
        # NOT_CONTAIN：不包含，路径大小写不敏感
        # REGEX：匹配正则，路径大小写不敏感
        # NOT_REGEX：正则不匹配，路径大小写不敏感
        # START_WITH：开头是，路径大小写不敏感
        # END_WITH：结尾是，路径大小写不敏感
        # WILDCARD：通配符匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，路径大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Path.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, path needs to start with "/", and no parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: /test.html.', 'zh_CN':'路径。
        # 当匹配类型为等于/不等于/开头是/结尾是，路径必须以“/”开头，不含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html。'}
        self.paths = paths

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.paths, 'paths')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.paths is not None:
            result['paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('paths') is not None:
            self.paths = m.get('paths')
        return self


class UpdateWhitelistRuleUriCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        uri: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, URI case sensitive
        # NOT_EQUAL: Does not equal, URI case sensitive
        # CONTAIN: Contains, URI case insensitive
        # NOT_CONTAIN: Does not Contains, URI case insensitive
        # REGEX: Regex match, URI case insensitive
        # NOT_REGEX: Regular does not match, URI case insensitive
        # START_WITH: Starts with, URI case insensitive
        # END_WITH: Ends with, URI case insensitive
        # WILDCARD: Wildcard matches, URI case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, URI case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，URI大小写敏感
        # NOT_EQUAL：不等于，URI大小写敏感
        # CONTAIN：包含，URI大小写不敏感
        # NOT_CONTAIN：不包含，URI大小写不敏感
        # REGEX：匹配正则，URI大小写不敏感
        # NOT_REGEX：正则不匹配，URI大小写不敏感
        # START_WITH：开头是，URI大小写不敏感
        # END_WITH：结尾是，URI大小写不敏感
        # WILDCARD：通配符匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，URI大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'URI.
        # When match type is EQUAL/NOT_EQUAL/START_WITH/END_WITH, uri needs to start with "/", and includes parameters.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: /test.html?id=1.', 'zh_CN':'URI。
        # 当匹配类型为等于/不等于/开头是/结尾是，URI必须以”/“开头，含参数。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：/test.html?id=1。'}
        self.uri = uri

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.uri, 'uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class UpdateWhitelistRuleUaCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        ua: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, user agent case sensitive
        # NOT_EQUAL: Does not equal, user agent case sensitive
        # CONTAIN: Contains, user agent case insensitive
        # NOT_CONTAIN: Does not Contains, user agent case insensitive
        # REGEX: Regex match, user agent case insensitive
        # NOT_REGEX: Regular does not match, user agent case insensitive
        # START_WITH: Starts with, user agent case insensitive
        # END_WITH: Ends with, user agent case insensitive
        # WILDCARD: Wildcard matches, user agent case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, user agent case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，User-Agent大小写敏感
        # NOT_EQUAL：不等于，User-Agent大小写敏感
        # CONTAIN：包含，User-Agent大小写不敏感
        # NOT_CONTAIN：不包含，User-Agent大小写不敏感
        # REGEX：匹配正则，User-Agent大小写不敏感
        # NOT_REGEX：正则不匹配，User-Agent大小写不敏感
        # START_WITH：开头是，User-Agent大小写不敏感
        # END_WITH：结尾是，User-Agent大小写不敏感
        # WILDCARD：通配符匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，User-Agent大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'User agent.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: go-Http-client/1.1.', 'zh_CN':'User-Agent。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：go-Http-client/1.1。'}
        self.ua = ua

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.ua, 'ua')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.ua is not None:
            result['ua'] = self.ua
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('ua') is not None:
            self.ua = m.get('ua')
        return self


class UpdateWhitelistRuleRefererCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        referer: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, referer case sensitive
        # NOT_EQUAL: Does not equal, referer case sensitive
        # CONTAIN: Contains, referer case insensitive
        # NOT_CONTAIN: Does not Contains, referer case insensitive
        # REGEX: Regex match, referer case insensitive
        # NOT_REGEX: Regular does not match, referer case insensitive
        # START_WITH: Starts with, referer case insensitive
        # END_WITH: Ends with, referer case insensitive
        # WILDCARD: Wildcard matches, referer case insensitive, ** represents zero or more arbitrary characters, ? represents any single characte
        # NOT_WILDCARD: Wildcard does not match, referer case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，referer大小写敏感
        # NOT_EQUAL：不等于，referer大小写敏感
        # CONTAIN：包含，referer大小写不敏感
        # NOT_CONTAIN：不包含，referer大小写不敏感
        # REGEX：匹配正则，referer大小写不敏感
        # NOT_REGEX：正则不匹配，referer大小写不敏感
        # START_WITH：开头是，referer大小写不敏感
        # END_WITH：结尾是，referer大小写不敏感
        # WILDCARD：通配符匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，referer大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Referer.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed. 
        # Example: http://test.com.', 'zh_CN':'Referer。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。
        # 示例：http://test.com。'}
        self.referer = referer

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.referer, 'referer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.referer is not None:
            result['referer'] = self.referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('referer') is not None:
            self.referer = m.get('referer')
        return self


class UpdateWhitelistRuleHeaderCondition(TeaModel):
    def __init__(
        self,
        match_type: str = None,
        key: str = None,
        value_list: List[str] = None,
    ):
        # {"en":"Match type.
        # EQUAL: Equals, request header values case sensitive
        # NOT_EQUAL: Does not equal, request header values case sensitive
        # CONTAIN: Contains, request header values case insensitive
        # NOT_CONTAIN: Does not Contains, request header values case insensitive
        # REGEX: Regex match, request header values case insensitive
        # NOT_REGEX: Regular does not match, request header values case insensitive
        # START_WITH: Starts with, request header values case insensitive
        # END_WITH: Ends with, request header values case insensitive
        # WILDCARD: Wildcard matches, request header values case insensitive, ** represents zero or more arbitrary characters, ? represents any single character
        # NOT_WILDCARD: Wildcard does not match, request header values case insensitive, ** represents zero or more arbitrary characters, ? represents any single character", "zh_CN":"匹配类型。
        # EQUAL：等于，头部值大小写敏感
        # NOT_EQUAL：不等于，头部值大小写敏感
        # CONTAIN：包含，头部值大小写不敏感
        # NOT_CONTAIN：不包含，头部值大小写不敏感
        # REGEX：匹配正则，头部值大小写不敏感
        # NOT_REGEX：正则不匹配，头部值大小写不敏感
        # START_WITH：开头是，头部值大小写不敏感
        # END_WITH：结尾是，头部值大小写不敏感
        # WILDCARD：通配符匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符
        # NOT_WILDCARD：通配符不匹配，头部值大小写不敏感，*代表零个或多个任意字符，?代表任意单个字符"}
        self.match_type = match_type
        # {'en':'Header name,case insensitive,up to 100 characters.
        # Example: Accept.', 'zh_CN':'头部名称，大小写不敏感，最多100个字符。
        # 示例：Accept。'}
        self.key = key
        # {'en':'Header value.
        # When the match type is REGEX/NOT_REGEX, only one value is allowed.', 'zh_CN':'头部值。
        # 当匹配类型为正则/正则不匹配，则只允许只有一个值。'}
        self.value_list = value_list

    def validate(self):
        self.validate_required(self.match_type, 'match_type')
        self.validate_required(self.key, 'key')
        self.validate_required(self.value_list, 'value_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_type is not None:
            result['matchType'] = self.match_type
        if self.key is not None:
            result['key'] = self.key
        if self.value_list is not None:
            result['valueList'] = self.value_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchType') is not None:
            self.match_type = m.get('matchType')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('valueList') is not None:
            self.value_list = m.get('valueList')
        return self


class UpdateWhitelistRuleWhitelistRuleCondition(TeaModel):
    def __init__(
        self,
        ip_or_ips_conditions: List[UpdateWhitelistRuleIpOrIpsCondition] = None,
        path_conditions: List[UpdateWhitelistRulePathCondition] = None,
        uri_conditions: List[UpdateWhitelistRuleUriCondition] = None,
        ua_conditions: List[UpdateWhitelistRuleUaCondition] = None,
        referer_conditions: List[UpdateWhitelistRuleRefererCondition] = None,
        header_conditions: List[UpdateWhitelistRuleHeaderCondition] = None,
    ):
        # {"en":"IP/CIDR match conditions, match type cannot be repeated.", "zh_CN":"IP/IP段匹配条件，匹配类型不可重复。"}
        self.ip_or_ips_conditions = ip_or_ips_conditions
        # {"en":"Path match conditions, match type cannot be repeated.", "zh_CN":"路径匹配条件，匹配类型不可重复。"}
        self.path_conditions = path_conditions
        # {"en":"URI match conditions, match type cannot be repeated.", "zh_CN":"URI匹配条件，匹配类型不可重复。"}
        self.uri_conditions = uri_conditions
        # {"en":"User agent match conditions, match type cannot be repeated.", "zh_CN":"User-Agent 匹配条件，匹配类型不可重复。"}
        self.ua_conditions = ua_conditions
        # {"en":"Referer match conditions, match type cannot be repeated.", "zh_CN":"Referer 匹配条件，匹配类型不可重复。"}
        self.referer_conditions = referer_conditions
        # {"en":"Request header match conditions.", "zh_CN":"请求头匹配条件。"}
        self.header_conditions = header_conditions

    def validate(self):
        if self.ip_or_ips_conditions:
            for k in self.ip_or_ips_conditions:
                if k:
                    k.validate()
        if self.path_conditions:
            for k in self.path_conditions:
                if k:
                    k.validate()
        if self.uri_conditions:
            for k in self.uri_conditions:
                if k:
                    k.validate()
        if self.ua_conditions:
            for k in self.ua_conditions:
                if k:
                    k.validate()
        if self.referer_conditions:
            for k in self.referer_conditions:
                if k:
                    k.validate()
        if self.header_conditions:
            for k in self.header_conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_or_ips_conditions is not None:
            result['ipOrIpsConditions'] = []
            for k in self.ip_or_ips_conditions:
                result['ipOrIpsConditions'].append(k.to_map() if k else None)
        if self.path_conditions is not None:
            result['pathConditions'] = []
            for k in self.path_conditions:
                result['pathConditions'].append(k.to_map() if k else None)
        if self.uri_conditions is not None:
            result['uriConditions'] = []
            for k in self.uri_conditions:
                result['uriConditions'].append(k.to_map() if k else None)
        if self.ua_conditions is not None:
            result['uaConditions'] = []
            for k in self.ua_conditions:
                result['uaConditions'].append(k.to_map() if k else None)
        if self.referer_conditions is not None:
            result['refererConditions'] = []
            for k in self.referer_conditions:
                result['refererConditions'].append(k.to_map() if k else None)
        if self.header_conditions is not None:
            result['headerConditions'] = []
            for k in self.header_conditions:
                result['headerConditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipOrIpsConditions') is not None:
            self.ip_or_ips_conditions = []
            for k in m.get('ipOrIpsConditions'):
                temp_model = UpdateWhitelistRuleIpOrIpsCondition()
                self.ip_or_ips_conditions.append(temp_model.from_map(k))
        if m.get('pathConditions') is not None:
            self.path_conditions = []
            for k in m.get('pathConditions'):
                temp_model = UpdateWhitelistRulePathCondition()
                self.path_conditions.append(temp_model.from_map(k))
        if m.get('uriConditions') is not None:
            self.uri_conditions = []
            for k in m.get('uriConditions'):
                temp_model = UpdateWhitelistRuleUriCondition()
                self.uri_conditions.append(temp_model.from_map(k))
        if m.get('uaConditions') is not None:
            self.ua_conditions = []
            for k in m.get('uaConditions'):
                temp_model = UpdateWhitelistRuleUaCondition()
                self.ua_conditions.append(temp_model.from_map(k))
        if m.get('refererConditions') is not None:
            self.referer_conditions = []
            for k in m.get('refererConditions'):
                temp_model = UpdateWhitelistRuleRefererCondition()
                self.referer_conditions.append(temp_model.from_map(k))
        if m.get('headerConditions') is not None:
            self.header_conditions = []
            for k in m.get('headerConditions'):
                temp_model = UpdateWhitelistRuleHeaderCondition()
                self.header_conditions.append(temp_model.from_map(k))
        return self


class UpdateWhitelistRuleRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        rule_name: str = None,
        description: str = None,
        conditions: UpdateWhitelistRuleWhitelistRuleCondition = None,
    ):
        # {"en":"Rule ID.", "zh_CN":"规则ID。"}
        self.id = id
        # {"en":"Rule name, maximum 50 characters.
        #  Does not support special characters and spaces.", "zh_CN":"规则名称，最多50个字符。
        # 不支持特殊字符和空格。"}
        self.rule_name = rule_name
        # {"en":"Description, maximum 200 characters.", "zh_CN":"描述，最多200个字符。"}
        self.description = description
        # {"en":"Match conditions, at least one, at most five.", "zh_CN":"匹配条件，至少一个，至多五个。"}
        self.conditions = conditions

    def validate(self):
        self.validate_required(self.id, 'id')
        if self.conditions:
            self.conditions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.rule_name is not None:
            result['ruleName'] = self.rule_name
        if self.description is not None:
            result['description'] = self.description
        if self.conditions is not None:
            result['conditions'] = self.conditions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('ruleName') is not None:
            self.rule_name = m.get('ruleName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('conditions') is not None:
            temp_model = UpdateWhitelistRuleWhitelistRuleCondition()
            self.conditions = temp_model.from_map(m['conditions'])
        return self


class UpdateWhitelistRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        msg: str = None,
    ):
        # {'en':'Please refer to the error code for exceptions.', 'zh_CN':'请参照错误码。','dictionary':'belong=WAAP-MS-Ext|dict=waap_retCodeEnum'}
        self.code = code
        # {"en":"Description.", "zh_CN":"描述信息。"}
        self.msg = msg

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class UpdateWhitelistRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateWhitelistRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateWhitelistRuleRequestHeader(TeaModel):
    def __init__(
        self,
        service_type: str = None,
    ):
        # {"zh_CN":"安全服务类型。有使用多个不同的安全服务时，需要填写具体的服务类型。","en":"Security service type. Please enter a specific service type, if you purchase multiple security services.","dictionary":"belong=WAAP-MS-Ext|dict=waap_serviceType"}
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        return self


class UpdateWhitelistRuleResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class RemoveDomainsForBuiltInRuleRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        domain_list: List[str] = None,
    ):
        # {"en":"Template name.", "zh_CN":"模板名称。"}
        self.name = name
        # {"en":"Cancel the associated domain name, array.", "zh_CN":"取消关联域名，数组。"}
        self.domain_list = domain_list

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.domain_list, 'domain_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.domain_list is not None:
            result['domainList'] = self.domain_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('domainList') is not None:
            self.domain_list = m.get('domainList')
        return self


class RemoveDomainsForBuiltInRuleResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Return 0 means success, please see <Error code> to check other status code.", "zh_CN":"0状态码表示请求成功，其他状态码说明请参见《错误码》。"}
        self.code = code
        # {"en":"Error message or Success.", "zh_CN":"错误信息或Success。"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class RemoveDomainsForBuiltInRulePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class RemoveDomainsForBuiltInRuleParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _ma