# openapi-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.8.2
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import openapi_client
from pprint import pprint
from openapi_client.api import conversions_api
from openapi_client.model.http_validation_error import HTTPValidationError
from openapi_client.model.map_id_request import MapIdRequest
from openapi_client.model.owm_text_request import OwmTextRequest
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = conversions_api.ConversionsApi(api_client)
    map_id_request = MapIdRequest(
        map_id="map_id_example",
    ) # MapIdRequest | 

    try:
        # Convert Id 2 Png
        api_response = api_instance.convert_id2_png_v2_convertid2png_post(map_id_request)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConversionsApi->convert_id2_png_v2_convertid2png_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConversionsApi* | [**convert_id2_png_v2_convertid2png_post**](docs/ConversionsApi.md#convert_id2_png_v2_convertid2png_post) | **POST** /v2/convertid2png | Convert Id 2 Png
*ConversionsApi* | [**convert_owm2_json_v2_convertowm2json_post**](docs/ConversionsApi.md#convert_owm2_json_v2_convertowm2json_post) | **POST** /v2/convertowm2json | Convert Owm 2 Json
*ConversionsApi* | [**convert_owm2_png_v2_convertowm2png_post**](docs/ConversionsApi.md#convert_owm2_png_v2_convertowm2png_post) | **POST** /v2/convertowm2png | Convert Owm 2 Png
*ConversionsApi* | [**convert_owm2_svg_v2_convertowm2svg_post**](docs/ConversionsApi.md#convert_owm2_svg_v2_convertowm2svg_post) | **POST** /v2/convertowm2svg | Convert Owm 2 Svg
*ConversionsApi* | [**convert_owm2_toml_v2_convertowm2toml_post**](docs/ConversionsApi.md#convert_owm2_toml_v2_convertowm2toml_post) | **POST** /v2/convertowm2toml | Convert Owm 2 Toml
*ConversionsApi* | [**convert_owm2_yaml_v2_convertowm2yaml_post**](docs/ConversionsApi.md#convert_owm2_yaml_v2_convertowm2yaml_post) | **POST** /v2/convertowm2yaml | Convert Owm 2 Yaml
*OpenWardleyMapsApi* | [**generate_map_from_id_v2_generate_mapfromid_post**](docs/OpenWardleyMapsApi.md#generate_map_from_id_v2_generate_mapfromid_post) | **POST** /v2/generate-mapfromid | Generate Map From Id
*OpenWardleyMapsApi* | [**generate_map_from_text_v2_generate_mapfromtext_post**](docs/OpenWardleyMapsApi.md#generate_map_from_text_v2_generate_mapfromtext_post) | **POST** /v2/generate-mapfromtext | Generate Map From Text
*OpenWardleyMapsApi* | [**generate_svg_map_v2_generate_svgmap_post**](docs/OpenWardleyMapsApi.md#generate_svg_map_v2_generate_svgmap_post) | **POST** /v2/generate-svgmap | Generate Svg Map
*OpenWardleyMapsApi* | [**get_owm_anchors_v2_get_owm_anchors_post**](docs/OpenWardleyMapsApi.md#get_owm_anchors_v2_get_owm_anchors_post) | **POST** /v2/get-owm-anchors | Get Owm Anchors
*OpenWardleyMapsApi* | [**get_owm_annotations_v2_get_owm_annotations_post**](docs/OpenWardleyMapsApi.md#get_owm_annotations_v2_get_owm_annotations_post) | **POST** /v2/get-owm-annotations | Get Owm Annotations
*OpenWardleyMapsApi* | [**get_owm_component_v2_get_owm_component_post**](docs/OpenWardleyMapsApi.md#get_owm_component_v2_get_owm_component_post) | **POST** /v2/get-owm-component | Get Owm Component
*OpenWardleyMapsApi* | [**get_owm_components_v2_get_owm_components_post**](docs/OpenWardleyMapsApi.md#get_owm_components_v2_get_owm_components_post) | **POST** /v2/get-owm-components | Get Owm Components
*OpenWardleyMapsApi* | [**get_owm_map_text_v2_get_owm_text_post**](docs/OpenWardleyMapsApi.md#get_owm_map_text_v2_get_owm_text_post) | **POST** /v2/get-owm-text | Get Owm Map Text
*OpenWardleyMapsApi* | [**get_owm_notes_v2_get_owm_notes_post**](docs/OpenWardleyMapsApi.md#get_owm_notes_v2_get_owm_notes_post) | **POST** /v2/get-owm-notes | Get Owm Notes
*OpenWardleyMapsApi* | [**get_owm_pipelines_v2_get_owm_pipelines_post**](docs/OpenWardleyMapsApi.md#get_owm_pipelines_v2_get_owm_pipelines_post) | **POST** /v2/get-owm-pipelines | Get Owm Pipelines
*OpenWardleyMapsApi* | [**get_owm_warnings_v2_get_owm_warnings_post**](docs/OpenWardleyMapsApi.md#get_owm_warnings_v2_get_owm_warnings_post) | **POST** /v2/get-owm-warnings | Get Owm Warnings
*OpenWardleyMapsApi* | [**search_owm_components_v2_search_owm_components_post**](docs/OpenWardleyMapsApi.md#search_owm_components_v2_search_owm_components_post) | **POST** /v2/search-owm-components | Search Owm Components
*ToolsApi* | [**get_github_map_v2_get_github_map_get**](docs/ToolsApi.md#get_github_map_v2_get_github_map_get) | **GET** /v2/get-github-map | Get Github Map
*ToolsApi* | [**list_github_maps_v2_list_github_maps_get**](docs/ToolsApi.md#list_github_maps_v2_list_github_maps_get) | **GET** /v2/list-github-maps | List Github Maps
*ToolsApi* | [**open_map_v2_openmap_get**](docs/ToolsApi.md#open_map_v2_openmap_get) | **GET** /v2/openmap | Open Map
*ToolsApi* | [**privacy_statement_v2_privacy_get**](docs/ToolsApi.md#privacy_statement_v2_privacy_get) | **GET** /v2/privacy | Privacy Statement
*WardleyMapsOnlineApi* | [**fetch_wardley_data_v2_maps_fetch_get**](docs/WardleyMapsOnlineApi.md#fetch_wardley_data_v2_maps_fetch_get) | **GET** /v2/maps/fetch | Fetch Wardley Data
*WardleyMapsOnlineApi* | [**get_image_v2_image_filename_get**](docs/WardleyMapsOnlineApi.md#get_image_v2_image_filename_get) | **GET** /v2/image/{filename} | Get Image
*WardleyMapsOnlineApi* | [**save_wardley_map_v2_maps_save_post**](docs/WardleyMapsOnlineApi.md#save_wardley_map_v2_maps_save_post) | **POST** /v2/maps/save | Save Wardley Map


## Documentation For Models

 - [ComponentRequest](docs/ComponentRequest.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [MapIdRequest](docs/MapIdRequest.md)
 - [MapTextAndWarnings](docs/MapTextAndWarnings.md)
 - [OwmTextRequest](docs/OwmTextRequest.md)
 - [SearchComponentRequest](docs/SearchComponentRequest.md)
 - [TextRequest](docs/TextRequest.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in openapi_client.apis and openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from openapi_client.api.default_api import DefaultApi`
- `from openapi_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import openapi_client
from openapi_client.apis import *
from openapi_client.models import *
```

