# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.28.0
# source: queries.sql
import dataclasses
from typing import AsyncIterator, Iterator, List, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from weave.datamanagement.db import models


GET_FOREIGN_KEY_RELATIONSHIPS = """-- name: get_foreign_key_relationships \\:many
SELECT 
    cr.source_dataset_id,
    cr.target_dataset_id,
    sc.name AS source_column_name,
    tc.name AS target_column_name
FROM 
    synthesize_v1.column_relationship cr
JOIN 
    synthesize_v1.data_column sc ON cr.source_column_id = sc.id
JOIN 
    synthesize_v1.data_column tc ON cr.target_column_id = tc.id
WHERE 
    cr.relationship_type IN ('context_foreign_key', 'non_context_foreign_key')
    AND cr.source_dataset_id = ANY(:p1\\:\\:UUID[])
    AND cr.target_dataset_id = ANY(:p1\\:\\:UUID[])
"""


@dataclasses.dataclass()
class GetForeignKeyRelationshipsRow:
    source_dataset_id: uuid.UUID
    target_dataset_id: uuid.UUID
    source_column_name: str
    target_column_name: str


GET_STORAGE_CONNECTION = """-- name: get_storage_connection \\:one
SELECT id, organization_id, name, description, category, variant, details
FROM storage_connection
WHERE id = :p1
"""


GET_STORAGE_CONNECTION_BY_DATASET_ID = """-- name: get_storage_connection_by_dataset_id \\:one
SELECT sc.id, sc.organization_id, sc.name, sc.description, sc.category, sc.variant, sc.details
FROM storage_connection sc
JOIN synthesize_v1.dataset d ON d.storage_connection_id = sc.id
WHERE d.id = :p1
"""


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_foreign_key_relationships(self, *, dataset_ids: List[uuid.UUID]) -> Iterator[GetForeignKeyRelationshipsRow]:
        result = self._conn.execute(sqlalchemy.text(GET_FOREIGN_KEY_RELATIONSHIPS), {"p1": dataset_ids})
        for row in result:
            yield GetForeignKeyRelationshipsRow(
                source_dataset_id=row[0],
                target_dataset_id=row[1],
                source_column_name=row[2],
                target_column_name=row[3],
            )

    def get_storage_connection(self, *, id: uuid.UUID) -> Optional[models.StorageConnection]:
        row = self._conn.execute(sqlalchemy.text(GET_STORAGE_CONNECTION), {"p1": id}).first()
        if row is None:
            return None
        return models.StorageConnection(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            category=row[4],
            variant=row[5],
            details=row[6],
        )

    def get_storage_connection_by_dataset_id(self, *, dataset_id: uuid.UUID) -> Optional[models.StorageConnection]:
        row = self._conn.execute(sqlalchemy.text(GET_STORAGE_CONNECTION_BY_DATASET_ID), {"p1": dataset_id}).first()
        if row is None:
            return None
        return models.StorageConnection(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            category=row[4],
            variant=row[5],
            details=row[6],
        )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_foreign_key_relationships(self, *, dataset_ids: List[uuid.UUID]) -> AsyncIterator[GetForeignKeyRelationshipsRow]:
        result = await self._conn.stream(sqlalchemy.text(GET_FOREIGN_KEY_RELATIONSHIPS), {"p1": dataset_ids})
        async for row in result:
            yield GetForeignKeyRelationshipsRow(
                source_dataset_id=row[0],
                target_dataset_id=row[1],
                source_column_name=row[2],
                target_column_name=row[3],
            )

    async def get_storage_connection(self, *, id: uuid.UUID) -> Optional[models.StorageConnection]:
        row = (await self._conn.execute(sqlalchemy.text(GET_STORAGE_CONNECTION), {"p1": id})).first()
        if row is None:
            return None
        return models.StorageConnection(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            category=row[4],
            variant=row[5],
            details=row[6],
        )

    async def get_storage_connection_by_dataset_id(self, *, dataset_id: uuid.UUID) -> Optional[models.StorageConnection]:
        row = (await self._conn.execute(sqlalchemy.text(GET_STORAGE_CONNECTION_BY_DATASET_ID), {"p1": dataset_id})).first()
        if row is None:
            return None
        return models.StorageConnection(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            category=row[4],
            variant=row[5],
            details=row[6],
        )
