"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import weave.datamanagement.storage.v1.storage_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class StorageDetails(google.protobuf.message.Message):
    """StorageConfig represents a named storage configuration with metadata"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STORAGE_CONNECTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier for the storage configuration"""
    name: builtins.str
    """User-friendly name for the storage configuration"""
    description: builtins.str
    """Optional description"""
    @property
    def storage_connection(self) -> weave.datamanagement.storage.v1.storage_pb2.StorageConnection:
        """The actual storage configuration"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        storage_connection: weave.datamanagement.storage.v1.storage_pb2.StorageConnection | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["storage_connection", b"storage_connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "id", b"id", "name", b"name", "storage_connection", b"storage_connection"]) -> None: ...

global___StorageDetails = StorageDetails

@typing.final
class CreateStorageRequest(google.protobuf.message.Message):
    """CreateStorageRequest is used to create a new storage configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STORAGE_CONNECTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """User-friendly name for the storage configuration"""
    description: builtins.str
    """Optional description"""
    @property
    def storage_connection(self) -> weave.datamanagement.storage.v1.storage_pb2.StorageConnection:
        """The storage configuration to create"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        storage_connection: weave.datamanagement.storage.v1.storage_pb2.StorageConnection | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["storage_connection", b"storage_connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "name", b"name", "storage_connection", b"storage_connection"]) -> None: ...

global___CreateStorageRequest = CreateStorageRequest

@typing.final
class CreateStorageResponse(google.protobuf.message.Message):
    """CreateStorageResponse contains the created storage configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORAGE_DETAILS_FIELD_NUMBER: builtins.int
    @property
    def storage_details(self) -> global___StorageDetails:
        """The created storage configuration"""

    def __init__(
        self,
        *,
        storage_details: global___StorageDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["storage_details", b"storage_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["storage_details", b"storage_details"]) -> None: ...

global___CreateStorageResponse = CreateStorageResponse

@typing.final
class GetStorageRequest(google.protobuf.message.Message):
    """GetStorageRequest is used to retrieve a storage configuration by ID"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the storage configuration to retrieve"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___GetStorageRequest = GetStorageRequest

@typing.final
class GetStorageResponse(google.protobuf.message.Message):
    """GetStorageResponse contains the requested storage configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORAGE_DETAILS_FIELD_NUMBER: builtins.int
    @property
    def storage_details(self) -> global___StorageDetails:
        """The requested storage configuration"""

    def __init__(
        self,
        *,
        storage_details: global___StorageDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["storage_details", b"storage_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["storage_details", b"storage_details"]) -> None: ...

global___GetStorageResponse = GetStorageResponse

@typing.final
class ListStoragesRequest(google.protobuf.message.Message):
    """ListStoragesRequest is used to list storage configurations with optional filtering"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    STORAGE_TYPE_FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Maximum number of results to return"""
    page_token: builtins.str
    """Token for pagination"""
    @property
    def storage_type_filter(self) -> global___StorageTypeFilter:
        """Optional filter by storage type"""

    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        storage_type_filter: global___StorageTypeFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["storage_type_filter", b"storage_type_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "storage_type_filter", b"storage_type_filter"]) -> None: ...

global___ListStoragesRequest = ListStoragesRequest

@typing.final
class StorageTypeFilter(google.protobuf.message.Message):
    """StorageTypeFilter allows filtering storage configurations by type"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCLUDE_OBJECT_STORES_FIELD_NUMBER: builtins.int
    INCLUDE_SQL_DATABASES_FIELD_NUMBER: builtins.int
    INCLUDE_NOSQL_DATABASES_FIELD_NUMBER: builtins.int
    include_object_stores: builtins.bool
    """If true, include object stores"""
    include_sql_databases: builtins.bool
    """If true, include SQL databases"""
    include_nosql_databases: builtins.bool
    """If true, include NoSQL databases"""
    def __init__(
        self,
        *,
        include_object_stores: builtins.bool = ...,
        include_sql_databases: builtins.bool = ...,
        include_nosql_databases: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["include_nosql_databases", b"include_nosql_databases", "include_object_stores", b"include_object_stores", "include_sql_databases", b"include_sql_databases"]) -> None: ...

global___StorageTypeFilter = StorageTypeFilter

@typing.final
class ListStoragesResponse(google.protobuf.message.Message):
    """ListStoragesResponse contains the list of storage configurations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORAGE_DETAILS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for pagination"""
    total_count: builtins.int
    """Total count of storage configurations matching the request"""
    @property
    def storage_details(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StorageDetails]:
        """List of storage configurations"""

    def __init__(
        self,
        *,
        storage_details: collections.abc.Iterable[global___StorageDetails] | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "storage_details", b"storage_details", "total_count", b"total_count"]) -> None: ...

global___ListStoragesResponse = ListStoragesResponse

@typing.final
class UpdateStorageRequest(google.protobuf.message.Message):
    """UpdateStorageRequest is used to update an existing storage configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STORAGE_CONNECTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the storage configuration to update"""
    name: builtins.str
    """New name (optional)"""
    description: builtins.str
    """New description (optional)"""
    @property
    def storage_connection(self) -> weave.datamanagement.storage.v1.storage_pb2.StorageConnection:
        """New storage configuration (optional)"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        storage_connection: weave.datamanagement.storage.v1.storage_pb2.StorageConnection | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["storage_connection", b"storage_connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "id", b"id", "name", b"name", "storage_connection", b"storage_connection"]) -> None: ...

global___UpdateStorageRequest = UpdateStorageRequest

@typing.final
class UpdateStorageResponse(google.protobuf.message.Message):
    """UpdateStorageResponse contains the updated storage configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORAGE_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def storage_config(self) -> global___StorageDetails:
        """The updated storage configuration"""

    def __init__(
        self,
        *,
        storage_config: global___StorageDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["storage_config", b"storage_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["storage_config", b"storage_config"]) -> None: ...

global___UpdateStorageResponse = UpdateStorageResponse

@typing.final
class DeleteStorageRequest(google.protobuf.message.Message):
    """DeleteStorageRequest is used to delete a storage configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the storage configuration to delete"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___DeleteStorageRequest = DeleteStorageRequest

@typing.final
class DeleteStorageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteStorageResponse = DeleteStorageResponse

@typing.final
class TestStorageConnectionRequest(google.protobuf.message.Message):
    """TestStorageConnectionRequest is used to test a storage connection"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    STORAGE_CONNECTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of an existing storage configuration"""
    @property
    def storage_connection(self) -> weave.datamanagement.storage.v1.storage_pb2.StorageConnection:
        """A new storage configuration to test"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        storage_connection: weave.datamanagement.storage.v1.storage_pb2.StorageConnection | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["id", b"id", "storage_connection", b"storage_connection", "storage_spec", b"storage_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "storage_connection", b"storage_connection", "storage_spec", b"storage_spec"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["storage_spec", b"storage_spec"]) -> typing.Literal["id", "storage_connection"] | None: ...

global___TestStorageConnectionRequest = TestStorageConnectionRequest

@typing.final
class TestStorageConnectionResponse(google.protobuf.message.Message):
    """TestStorageConnectionResponse contains the result of a connection test"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    CONNECTION_DETAILS_FIELD_NUMBER: builtins.int
    success: builtins.bool
    """Whether the connection was successful"""
    error_message: builtins.str
    """Error message if the connection failed"""
    @property
    def connection_details(self) -> global___ConnectionDetails:
        """Additional details about the connection test"""

    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        error_message: builtins.str = ...,
        connection_details: global___ConnectionDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection_details", b"connection_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["connection_details", b"connection_details", "error_message", b"error_message", "success", b"success"]) -> None: ...

global___TestStorageConnectionResponse = TestStorageConnectionResponse

@typing.final
class ConnectionDetails(google.protobuf.message.Message):
    """ConnectionDetails provides additional information about a storage connection"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LATENCY_MS_FIELD_NUMBER: builtins.int
    AVAILABLE_RESOURCES_FIELD_NUMBER: builtins.int
    AVAILABLE_CONTAINERS_FIELD_NUMBER: builtins.int
    latency_ms: builtins.int
    """Connection latency in milliseconds"""
    @property
    def available_resources(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """For SQL/NoSQL databases: available tables/collections"""

    @property
    def available_containers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """For object stores: available buckets/containers"""

    def __init__(
        self,
        *,
        latency_ms: builtins.int = ...,
        available_resources: collections.abc.Iterable[builtins.str] | None = ...,
        available_containers: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["available_containers", b"available_containers", "available_resources", b"available_resources", "latency_ms", b"latency_ms"]) -> None: ...

global___ConnectionDetails = ConnectionDetails
