"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ModelType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModelTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ModelType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MODEL_TYPE_UNSPECIFIED: _ModelType.ValueType  # 0
    MODEL_TYPE_CTGAN: _ModelType.ValueType  # 1
    """Conditional Tabular GAN"""
    MODEL_TYPE_TVAE: _ModelType.ValueType  # 2
    """Tabular Variational Autoencoder"""
    MODEL_TYPE_COPULA: _ModelType.ValueType  # 3
    """Gaussian Copula"""
    MODEL_TYPE_FAST: _ModelType.ValueType  # 4
    """Fast mode (less accurate but quicker)"""
    MODEL_TYPE_GAN: _ModelType.ValueType  # 5
    """Generic GAN implementation"""
    MODEL_TYPE_WGAN: _ModelType.ValueType  # 6
    """Wasserstein GAN"""
    MODEL_TYPE_SMOTE: _ModelType.ValueType  # 7
    """Synthetic Minority Over-sampling Technique"""
    MODEL_TYPE_BAYESIAN: _ModelType.ValueType  # 8
    """Bayesian Network"""
    MODEL_TYPE_HMA: _ModelType.ValueType  # 9
    """Hierarchical Modeling Algorithm"""

class ModelType(_ModelType, metaclass=_ModelTypeEnumTypeWrapper):
    """ModelType defines the available synthetic data generation models"""

MODEL_TYPE_UNSPECIFIED: ModelType.ValueType  # 0
MODEL_TYPE_CTGAN: ModelType.ValueType  # 1
"""Conditional Tabular GAN"""
MODEL_TYPE_TVAE: ModelType.ValueType  # 2
"""Tabular Variational Autoencoder"""
MODEL_TYPE_COPULA: ModelType.ValueType  # 3
"""Gaussian Copula"""
MODEL_TYPE_FAST: ModelType.ValueType  # 4
"""Fast mode (less accurate but quicker)"""
MODEL_TYPE_GAN: ModelType.ValueType  # 5
"""Generic GAN implementation"""
MODEL_TYPE_WGAN: ModelType.ValueType  # 6
"""Wasserstein GAN"""
MODEL_TYPE_SMOTE: ModelType.ValueType  # 7
"""Synthetic Minority Over-sampling Technique"""
MODEL_TYPE_BAYESIAN: ModelType.ValueType  # 8
"""Bayesian Network"""
MODEL_TYPE_HMA: ModelType.ValueType  # 9
"""Hierarchical Modeling Algorithm"""
global___ModelType = ModelType

@typing.final
class Configuration(google.protobuf.message.Message):
    """SynthesizerConfig defines customization options for synthetic data generation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_RECORDS_FIELD_NUMBER: builtins.int
    DATASET_NAME_FIELD_NUMBER: builtins.int
    DATA_QUALITY_FIELD_NUMBER: builtins.int
    PRIVACY_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    num_records: builtins.int
    """Basic configuration
    Number of synthetic records to generate
    """
    dataset_name: builtins.str
    """Name for the generated dataset"""
    @property
    def data_quality(self) -> global___DataQualityConfig:
        """Data quality settings
        Controls data quality aspects
        """

    @property
    def privacy(self) -> global___PrivacyConfig:
        """Privacy settings
        Privacy and anonymization settings
        """

    @property
    def model(self) -> global___ModelConfig:
        """Advanced model configuration
        ML model configuration options
        """

    def __init__(
        self,
        *,
        num_records: builtins.int = ...,
        dataset_name: builtins.str = ...,
        data_quality: global___DataQualityConfig | None = ...,
        privacy: global___PrivacyConfig | None = ...,
        model: global___ModelConfig | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "data_quality", b"data_quality", "model", b"model", "privacy", b"privacy"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "data_quality",
            b"data_quality",
            "dataset_name",
            b"dataset_name",
            "model",
            b"model",
            "num_records",
            b"num_records",
            "privacy",
            b"privacy",
        ],
    ) -> None: ...

global___Configuration = Configuration

@typing.final
class DataQualityConfig(google.protobuf.message.Message):
    """DataQualityConfig controls the quality of generated data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CORRELATION_ACCURACY_FIELD_NUMBER: builtins.int
    STATISTICAL_SIMILARITY_FIELD_NUMBER: builtins.int
    PRESERVE_OUTLIERS_FIELD_NUMBER: builtins.int
    ENFORCE_CONSTRAINTS_FIELD_NUMBER: builtins.int
    CONSTRAINTS_FIELD_NUMBER: builtins.int
    correlation_accuracy: builtins.float
    """How closely to maintain correlations (0.0-1.0)"""
    statistical_similarity: builtins.float
    """Statistical similarity to original data (0.0-1.0)"""
    preserve_outliers: builtins.bool
    """Whether to preserve outlier patterns"""
    enforce_constraints: builtins.bool
    """Whether to enforce data constraints"""
    @property
    def constraints(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ColumnConstraint
    ]:
        """Column-specific constraints"""

    def __init__(
        self,
        *,
        correlation_accuracy: builtins.float = ...,
        statistical_similarity: builtins.float = ...,
        preserve_outliers: builtins.bool = ...,
        enforce_constraints: builtins.bool = ...,
        constraints: collections.abc.Iterable[global___ColumnConstraint] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "constraints",
            b"constraints",
            "correlation_accuracy",
            b"correlation_accuracy",
            "enforce_constraints",
            b"enforce_constraints",
            "preserve_outliers",
            b"preserve_outliers",
            "statistical_similarity",
            b"statistical_similarity",
        ],
    ) -> None: ...

global___DataQualityConfig = DataQualityConfig

@typing.final
class ColumnConstraint(google.protobuf.message.Message):
    """ColumnConstraint defines constraints for specific columns"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLUMN_NAME_FIELD_NUMBER: builtins.int
    CONSTRAINT_TYPE_FIELD_NUMBER: builtins.int
    MIN_VALUE_FIELD_NUMBER: builtins.int
    MAX_VALUE_FIELD_NUMBER: builtins.int
    REGEX_PATTERN_FIELD_NUMBER: builtins.int
    ALLOWED_VALUES_FIELD_NUMBER: builtins.int
    column_name: builtins.str
    """Name of the column"""
    constraint_type: builtins.str
    """Type of constraint (e.g., "range", "regex", "categorical")"""
    min_value: builtins.str
    """Minimum value (for numeric constraints)"""
    max_value: builtins.str
    """Maximum value (for numeric constraints)"""
    regex_pattern: builtins.str
    """Regex pattern (for string constraints)"""
    @property
    def allowed_values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of allowed values (for categorical constraints)"""

    def __init__(
        self,
        *,
        column_name: builtins.str = ...,
        constraint_type: builtins.str = ...,
        min_value: builtins.str = ...,
        max_value: builtins.str = ...,
        regex_pattern: builtins.str = ...,
        allowed_values: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "allowed_values",
            b"allowed_values",
            "column_name",
            b"column_name",
            "constraint_type",
            b"constraint_type",
            "max_value",
            b"max_value",
            "min_value",
            b"min_value",
            "regex_pattern",
            b"regex_pattern",
        ],
    ) -> None: ...

global___ColumnConstraint = ColumnConstraint

@typing.final
class PrivacyConfig(google.protobuf.message.Message):
    """PrivacyConfig controls privacy aspects of synthetic data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPSILON_FIELD_NUMBER: builtins.int
    K_ANONYMITY_CHECK_FIELD_NUMBER: builtins.int
    K_VALUE_FIELD_NUMBER: builtins.int
    SENSITIVE_COLUMNS_FIELD_NUMBER: builtins.int
    ENABLE_PRIVACY_METRICS_FIELD_NUMBER: builtins.int
    epsilon: builtins.float
    """Differential privacy epsilon parameter"""
    k_anonymity_check: builtins.bool
    """Whether to enforce k-anonymity"""
    k_value: builtins.int
    """k value for k-anonymity (if enabled)"""
    enable_privacy_metrics: builtins.bool
    """Whether to compute privacy metrics"""
    @property
    def sensitive_columns(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns that contain sensitive information"""

    def __init__(
        self,
        *,
        epsilon: builtins.float = ...,
        k_anonymity_check: builtins.bool = ...,
        k_value: builtins.int = ...,
        sensitive_columns: collections.abc.Iterable[builtins.str] | None = ...,
        enable_privacy_metrics: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "enable_privacy_metrics",
            b"enable_privacy_metrics",
            "epsilon",
            b"epsilon",
            "k_anonymity_check",
            b"k_anonymity_check",
            "k_value",
            b"k_value",
            "sensitive_columns",
            b"sensitive_columns",
        ],
    ) -> None: ...

global___PrivacyConfig = PrivacyConfig

@typing.final
class ModelConfig(google.protobuf.message.Message):
    """ModelConfig controls the ML model used for synthesis"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CustomParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    MODEL_TYPE_FIELD_NUMBER: builtins.int
    EPOCHS_FIELD_NUMBER: builtins.int
    LEARNING_RATE_FIELD_NUMBER: builtins.int
    BATCH_SIZE_FIELD_NUMBER: builtins.int
    CUSTOM_PARAMETERS_FIELD_NUMBER: builtins.int
    model_type: global___ModelType.ValueType
    """Type of model to use for synthesis"""
    epochs: builtins.int
    """Training epochs"""
    learning_rate: builtins.float
    """Learning rate for training"""
    batch_size: builtins.int
    """Batch size for training"""
    @property
    def custom_parameters(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional model-specific parameters"""

    def __init__(
        self,
        *,
        model_type: global___ModelType.ValueType = ...,
        epochs: builtins.int = ...,
        learning_rate: builtins.float = ...,
        batch_size: builtins.int = ...,
        custom_parameters: collections.abc.Mapping[builtins.str, builtins.str]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "batch_size",
            b"batch_size",
            "custom_parameters",
            b"custom_parameters",
            "epochs",
            b"epochs",
            "learning_rate",
            b"learning_rate",
            "model_type",
            b"model_type",
        ],
    ) -> None: ...

global___ModelConfig = ModelConfig
