# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.28.0
import dataclasses
import enum
from typing import Any, Optional
import uuid


class StorageCategory(enum.StrEnum):
    OBJECT_STORE = "object_store"
    SQL_DATABASE = "sql_database"
    NOSQL_DATABASE = "nosql_database"


class StorageVariant(enum.StrEnum):
    AWS_S3 = "aws_s3"
    AZURE_BLOB_STORAGE = "azure_blob_storage"
    GOOGLE_CLOUD_STORAGE = "google_cloud_storage"
    MYSQL = "mysql"
    POSTGRES = "postgres"
    SQL_SERVER = "sql_server"
    ORACLE = "oracle"
    MARIADB = "mariadb"
    SNOWFLAKE = "snowflake"
    BIGQUERY = "bigquery"
    DATABRICKS = "databricks"
    CASSANDRA = "cassandra"
    MONGODB = "mongodb"
    DYNAMODB = "dynamodb"
    COSMOSDB = "cosmosdb"
    REDIS = "redis"
    VALKEY = "valkey"
    ELASTICSEARCH = "elasticsearch"
    OPENSEARCH = "opensearch"


class SynthesizeV1ColumnDataType(enum.StrEnum):
    STRING = "string"
    INTEGER = "integer"
    FLOAT = "float"
    BOOLEAN = "boolean"
    TIMESTAMP = "timestamp"
    DATE = "date"
    BINARY = "binary"
    CATEGORICAL = "categorical"
    ORDINAL = "ordinal"


class SynthesizeV1ColumnRelationshipType(enum.StrEnum):
    CONTEXT_FOREIGN_KEY = "context_foreign_key"
    NON_CONTEXT_FOREIGN_KEY = "non_context_foreign_key"
    ONE_TO_MANY = "one_to_many"
    MANY_TO_ONE = "many_to_one"
    MANY_TO_MANY = "many_to_many"
    SELF_REFERENCE = "self_reference"


@dataclasses.dataclass()
class Organization:
    id: uuid.UUID
    name: str
    description: Optional[str]


@dataclasses.dataclass()
class StorageConnection:
    id: uuid.UUID
    organization_id: uuid.UUID
    name: str
    description: Optional[str]
    category: StorageCategory
    variant: StorageVariant
    details: Any


@dataclasses.dataclass()
class SynthesizeV1ColumnRelationship:
    id: uuid.UUID
    source_column_id: uuid.UUID
    source_dataset_id: uuid.UUID
    target_column_id: uuid.UUID
    target_dataset_id: uuid.UUID
    relationship_type: Any


@dataclasses.dataclass()
class SynthesizeV1DataColumn:
    id: uuid.UUID
    schema_id: uuid.UUID
    name: str
    data_type: Any
    is_primary_key: Optional[bool]
    description: Optional[str]


@dataclasses.dataclass()
class SynthesizeV1DataSchema:
    id: uuid.UUID
    organization_id: uuid.UUID
    name: str
    description: Optional[str]


@dataclasses.dataclass()
class SynthesizeV1Dataset:
    id: uuid.UUID
    organization_id: uuid.UUID
    name: str
    description: Optional[str]
    storage_connection_id: uuid.UUID
    schema_id: uuid.UUID
    model_id: Optional[uuid.UUID]
    is_synthetic: Optional[bool]


@dataclasses.dataclass()
class SynthesizeV1Model:
    id: uuid.UUID
    organization_id: uuid.UUID
    name: str
    description: Optional[str]
    storage_connection_id: uuid.UUID
    metadata: Optional[Any]
