# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.28.0
# source: queries.sql
import dataclasses
from typing import Any, AsyncIterator, Iterator, List, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from weave.datamanagement.db import models


GET_FOREIGN_KEY_RELATIONSHIPS = """-- name: get_foreign_key_relationships \\:many
SELECT cr.source_dataset_id,
       cr.target_dataset_id,
       sc.name AS source_column_name,
       tc.name AS target_column_name
FROM synthesize_v1.column_relationship cr
         JOIN
     synthesize_v1.data_column sc ON cr.source_column_id = sc.id
         JOIN
     synthesize_v1.data_column tc ON cr.target_column_id = tc.id
WHERE cr.relationship_type IN ('context_foreign_key', 'non_context_foreign_key')
  AND cr.source_dataset_id = ANY (:p1\\:\\:UUID[])
  AND cr.target_dataset_id = ANY (:p1\\:\\:UUID[])
"""


@dataclasses.dataclass()
class GetForeignKeyRelationshipsRow:
    source_dataset_id: uuid.UUID
    target_dataset_id: uuid.UUID
    source_column_name: str
    target_column_name: str


GET_STORAGE_CONNECTION = """-- name: get_storage_connection \\:one
SELECT id, organization_id, name, description, category, variant, details
FROM storage_connection
WHERE id = :p1
"""


GET_STORAGE_CONNECTION_BY_DATASET_ID = """-- name: get_storage_connection_by_dataset_id \\:one
SELECT sc.id, sc.organization_id, sc.name, sc.description, sc.category, sc.variant, sc.details
FROM storage_connection sc
         JOIN synthesize_v1.dataset d ON d.storage_connection_id = sc.id
WHERE d.id = :p1
"""


GET_SYNTHESIZER = """-- name: get_synthesizer \\:one
SELECT id, organization_id, name, description, storage_connection_id, metadata
FROM synthesize_v1.synthesizer
WHERE id = :p1
"""


UPSERT_DATASET = """-- name: upsert_dataset \\:exec
INSERT INTO synthesize_v1.dataset (id, organization_id, name, description, storage_connection_id, schema_id, model_id,
                                   is_synthetic)
VALUES (:p1, :p2, :p3, :p4, :p5, :p6, :p7, :p8)
ON CONFLICT (id) DO UPDATE SET name                  = EXCLUDED.name,
                               description           = EXCLUDED.description,
                               storage_connection_id = EXCLUDED.storage_connection_id,
                               schema_id             = EXCLUDED.schema_id,
                               model_id              = EXCLUDED.model_id,
                               is_synthetic          = EXCLUDED.is_synthetic
"""


@dataclasses.dataclass()
class UpsertDatasetParams:
    id: uuid.UUID
    organization_id: uuid.UUID
    name: str
    description: Optional[str]
    storage_connection_id: uuid.UUID
    schema_id: uuid.UUID
    model_id: Optional[uuid.UUID]
    is_synthetic: Optional[bool]


UPSERT_SYNTHESIZER = """-- name: upsert_synthesizer \\:exec
INSERT INTO synthesize_v1.synthesizer (id, organization_id, name, description, storage_connection_id, metadata)
VALUES (:p1, :p2, :p3, :p4, :p5, :p6)
ON CONFLICT (id) DO UPDATE SET name                  = EXCLUDED.name,
                               description           = EXCLUDED.description,
                               storage_connection_id = EXCLUDED.storage_connection_id,
                               metadata              = EXCLUDED.metadata
"""


@dataclasses.dataclass()
class UpsertSynthesizerParams:
    id: uuid.UUID
    organization_id: uuid.UUID
    name: str
    description: Optional[str]
    storage_connection_id: uuid.UUID
    metadata: Optional[Any]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_foreign_key_relationships(
        self, *, dataset_ids: List[uuid.UUID]
    ) -> Iterator[GetForeignKeyRelationshipsRow]:
        result = self._conn.execute(
            sqlalchemy.text(GET_FOREIGN_KEY_RELATIONSHIPS), {"p1": dataset_ids}
        )
        for row in result:
            yield GetForeignKeyRelationshipsRow(
                source_dataset_id=row[0],
                target_dataset_id=row[1],
                source_column_name=row[2],
                target_column_name=row[3],
            )

    def get_storage_connection(
        self, *, id: uuid.UUID
    ) -> Optional[models.StorageConnection]:
        row = self._conn.execute(
            sqlalchemy.text(GET_STORAGE_CONNECTION), {"p1": id}
        ).first()
        if row is None:
            return None
        return models.StorageConnection(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            category=row[4],
            variant=row[5],
            details=row[6],
        )

    def get_storage_connection_by_dataset_id(
        self, *, dataset_id: uuid.UUID
    ) -> Optional[models.StorageConnection]:
        row = self._conn.execute(
            sqlalchemy.text(GET_STORAGE_CONNECTION_BY_DATASET_ID), {"p1": dataset_id}
        ).first()
        if row is None:
            return None
        return models.StorageConnection(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            category=row[4],
            variant=row[5],
            details=row[6],
        )

    def get_synthesizer(
        self, *, id: uuid.UUID
    ) -> Optional[models.SynthesizeV1Synthesizer]:
        row = self._conn.execute(sqlalchemy.text(GET_SYNTHESIZER), {"p1": id}).first()
        if row is None:
            return None
        return models.SynthesizeV1Synthesizer(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            storage_connection_id=row[4],
            metadata=row[5],
        )

    def upsert_dataset(self, arg: UpsertDatasetParams) -> None:
        self._conn.execute(
            sqlalchemy.text(UPSERT_DATASET),
            {
                "p1": arg.id,
                "p2": arg.organization_id,
                "p3": arg.name,
                "p4": arg.description,
                "p5": arg.storage_connection_id,
                "p6": arg.schema_id,
                "p7": arg.model_id,
                "p8": arg.is_synthetic,
            },
        )

    def upsert_synthesizer(self, arg: UpsertSynthesizerParams) -> None:
        self._conn.execute(
            sqlalchemy.text(UPSERT_SYNTHESIZER),
            {
                "p1": arg.id,
                "p2": arg.organization_id,
                "p3": arg.name,
                "p4": arg.description,
                "p5": arg.storage_connection_id,
                "p6": arg.metadata,
            },
        )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_foreign_key_relationships(
        self, *, dataset_ids: List[uuid.UUID]
    ) -> AsyncIterator[GetForeignKeyRelationshipsRow]:
        result = await self._conn.stream(
            sqlalchemy.text(GET_FOREIGN_KEY_RELATIONSHIPS), {"p1": dataset_ids}
        )
        async for row in result:
            yield GetForeignKeyRelationshipsRow(
                source_dataset_id=row[0],
                target_dataset_id=row[1],
                source_column_name=row[2],
                target_column_name=row[3],
            )

    async def get_storage_connection(
        self, *, id: uuid.UUID
    ) -> Optional[models.StorageConnection]:
        row = (
            await self._conn.execute(
                sqlalchemy.text(GET_STORAGE_CONNECTION), {"p1": id}
            )
        ).first()
        if row is None:
            return None
        return models.StorageConnection(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            category=row[4],
            variant=row[5],
            details=row[6],
        )

    async def get_storage_connection_by_dataset_id(
        self, *, dataset_id: uuid.UUID
    ) -> Optional[models.StorageConnection]:
        row = (
            await self._conn.execute(
                sqlalchemy.text(GET_STORAGE_CONNECTION_BY_DATASET_ID),
                {"p1": dataset_id},
            )
        ).first()
        if row is None:
            return None
        return models.StorageConnection(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            category=row[4],
            variant=row[5],
            details=row[6],
        )

    async def get_synthesizer(
        self, *, id: uuid.UUID
    ) -> Optional[models.SynthesizeV1Synthesizer]:
        row = (
            await self._conn.execute(sqlalchemy.text(GET_SYNTHESIZER), {"p1": id})
        ).first()
        if row is None:
            return None
        return models.SynthesizeV1Synthesizer(
            id=row[0],
            organization_id=row[1],
            name=row[2],
            description=row[3],
            storage_connection_id=row[4],
            metadata=row[5],
        )

    async def upsert_dataset(self, arg: UpsertDatasetParams) -> None:
        await self._conn.execute(
            sqlalchemy.text(UPSERT_DATASET),
            {
                "p1": arg.id,
                "p2": arg.organization_id,
                "p3": arg.name,
                "p4": arg.description,
                "p5": arg.storage_connection_id,
                "p6": arg.schema_id,
                "p7": arg.model_id,
                "p8": arg.is_synthetic,
            },
        )

    async def upsert_synthesizer(self, arg: UpsertSynthesizerParams) -> None:
        await self._conn.execute(
            sqlalchemy.text(UPSERT_SYNTHESIZER),
            {
                "p1": arg.id,
                "p2": arg.organization_id,
                "p3": arg.name,
                "p4": arg.description,
                "p5": arg.storage_connection_id,
                "p6": arg.metadata,
            },
        )
