"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import weaveapi.llmx.v1.capabilities_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _BaseArchitecture:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BaseArchitectureEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _BaseArchitecture.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BASE_ARCHITECTURE_UNSPECIFIED: _BaseArchitecture.ValueType  # 0
    BASE_ARCHITECTURE_TRANSFORMER: _BaseArchitecture.ValueType  # 1
    BASE_ARCHITECTURE_MAMBA: _BaseArchitecture.ValueType  # 2
    BASE_ARCHITECTURE_HYBRID: _BaseArchitecture.ValueType  # 3
    BASE_ARCHITECTURE_RECURRENT_NEURAL_NETWORK: _BaseArchitecture.ValueType  # 4
    BASE_ARCHITECTURE_CONVOLUTIONAL_NEURAL_NETWORK: _BaseArchitecture.ValueType  # 5
    BASE_ARCHITECTURE_DIFFUSION: _BaseArchitecture.ValueType  # 6
    BASE_ARCHITECTURE_GENERATIVE_ADVERSARIAL_NETWORK: _BaseArchitecture.ValueType  # 7

class BaseArchitecture(_BaseArchitecture, metaclass=_BaseArchitectureEnumTypeWrapper):
    """Base architecture types"""

BASE_ARCHITECTURE_UNSPECIFIED: BaseArchitecture.ValueType  # 0
BASE_ARCHITECTURE_TRANSFORMER: BaseArchitecture.ValueType  # 1
BASE_ARCHITECTURE_MAMBA: BaseArchitecture.ValueType  # 2
BASE_ARCHITECTURE_HYBRID: BaseArchitecture.ValueType  # 3
BASE_ARCHITECTURE_RECURRENT_NEURAL_NETWORK: BaseArchitecture.ValueType  # 4
BASE_ARCHITECTURE_CONVOLUTIONAL_NEURAL_NETWORK: BaseArchitecture.ValueType  # 5
BASE_ARCHITECTURE_DIFFUSION: BaseArchitecture.ValueType  # 6
BASE_ARCHITECTURE_GENERATIVE_ADVERSARIAL_NETWORK: BaseArchitecture.ValueType  # 7
global___BaseArchitecture = BaseArchitecture

class _ModelArchitecture:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModelArchitectureEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _ModelArchitecture.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MODEL_ARCHITECTURE_UNSPECIFIED: _ModelArchitecture.ValueType  # 0
    MODEL_ARCHITECTURE_GPT: _ModelArchitecture.ValueType  # 1
    MODEL_ARCHITECTURE_BERT: _ModelArchitecture.ValueType  # 2
    MODEL_ARCHITECTURE_T5: _ModelArchitecture.ValueType  # 3
    MODEL_ARCHITECTURE_LLAMA: _ModelArchitecture.ValueType  # 4
    MODEL_ARCHITECTURE_MISTRAL: _ModelArchitecture.ValueType  # 5
    MODEL_ARCHITECTURE_GEMMA: _ModelArchitecture.ValueType  # 6
    MODEL_ARCHITECTURE_QWEN: _ModelArchitecture.ValueType  # 7
    MODEL_ARCHITECTURE_PHI: _ModelArchitecture.ValueType  # 8
    MODEL_ARCHITECTURE_CLAUDE: _ModelArchitecture.ValueType  # 9
    MODEL_ARCHITECTURE_COMMAND: _ModelArchitecture.ValueType  # 10
    MODEL_ARCHITECTURE_PALM: _ModelArchitecture.ValueType  # 11
    MODEL_ARCHITECTURE_FALCON: _ModelArchitecture.ValueType  # 12
    MODEL_ARCHITECTURE_STARCODER: _ModelArchitecture.ValueType  # 13
    MODEL_ARCHITECTURE_CODEGEN: _ModelArchitecture.ValueType  # 14
    MODEL_ARCHITECTURE_DEEPSEEK: _ModelArchitecture.ValueType  # 15
    MODEL_ARCHITECTURE_YI: _ModelArchitecture.ValueType  # 16
    MODEL_ARCHITECTURE_MIXTRAL: _ModelArchitecture.ValueType  # 17
    MODEL_ARCHITECTURE_GEMINI: _ModelArchitecture.ValueType  # 18

class ModelArchitecture(
    _ModelArchitecture, metaclass=_ModelArchitectureEnumTypeWrapper
):
    """Model architecture types"""

MODEL_ARCHITECTURE_UNSPECIFIED: ModelArchitecture.ValueType  # 0
MODEL_ARCHITECTURE_GPT: ModelArchitecture.ValueType  # 1
MODEL_ARCHITECTURE_BERT: ModelArchitecture.ValueType  # 2
MODEL_ARCHITECTURE_T5: ModelArchitecture.ValueType  # 3
MODEL_ARCHITECTURE_LLAMA: ModelArchitecture.ValueType  # 4
MODEL_ARCHITECTURE_MISTRAL: ModelArchitecture.ValueType  # 5
MODEL_ARCHITECTURE_GEMMA: ModelArchitecture.ValueType  # 6
MODEL_ARCHITECTURE_QWEN: ModelArchitecture.ValueType  # 7
MODEL_ARCHITECTURE_PHI: ModelArchitecture.ValueType  # 8
MODEL_ARCHITECTURE_CLAUDE: ModelArchitecture.ValueType  # 9
MODEL_ARCHITECTURE_COMMAND: ModelArchitecture.ValueType  # 10
MODEL_ARCHITECTURE_PALM: ModelArchitecture.ValueType  # 11
MODEL_ARCHITECTURE_FALCON: ModelArchitecture.ValueType  # 12
MODEL_ARCHITECTURE_STARCODER: ModelArchitecture.ValueType  # 13
MODEL_ARCHITECTURE_CODEGEN: ModelArchitecture.ValueType  # 14
MODEL_ARCHITECTURE_DEEPSEEK: ModelArchitecture.ValueType  # 15
MODEL_ARCHITECTURE_YI: ModelArchitecture.ValueType  # 16
MODEL_ARCHITECTURE_MIXTRAL: ModelArchitecture.ValueType  # 17
MODEL_ARCHITECTURE_GEMINI: ModelArchitecture.ValueType  # 18
global___ModelArchitecture = ModelArchitecture

class _PositionEmbedding:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PositionEmbeddingEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _PositionEmbedding.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    POSITION_EMBEDDING_UNSPECIFIED: _PositionEmbedding.ValueType  # 0
    POSITION_EMBEDDING_ABSOLUTE: _PositionEmbedding.ValueType  # 1
    POSITION_EMBEDDING_RELATIVE: _PositionEmbedding.ValueType  # 2
    POSITION_EMBEDDING_ROTARY: _PositionEmbedding.ValueType  # 3
    POSITION_EMBEDDING_ALIBI: _PositionEmbedding.ValueType  # 4
    POSITION_EMBEDDING_LEARNED: _PositionEmbedding.ValueType  # 5
    POSITION_EMBEDDING_SINUSOIDAL: _PositionEmbedding.ValueType  # 6

class PositionEmbedding(
    _PositionEmbedding, metaclass=_PositionEmbeddingEnumTypeWrapper
):
    """Position embedding types"""

POSITION_EMBEDDING_UNSPECIFIED: PositionEmbedding.ValueType  # 0
POSITION_EMBEDDING_ABSOLUTE: PositionEmbedding.ValueType  # 1
POSITION_EMBEDDING_RELATIVE: PositionEmbedding.ValueType  # 2
POSITION_EMBEDDING_ROTARY: PositionEmbedding.ValueType  # 3
POSITION_EMBEDDING_ALIBI: PositionEmbedding.ValueType  # 4
POSITION_EMBEDDING_LEARNED: PositionEmbedding.ValueType  # 5
POSITION_EMBEDDING_SINUSOIDAL: PositionEmbedding.ValueType  # 6
global___PositionEmbedding = PositionEmbedding

class _ActivationFunction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ActivationFunctionEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _ActivationFunction.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ACTIVATION_FUNCTION_UNSPECIFIED: _ActivationFunction.ValueType  # 0
    ACTIVATION_FUNCTION_GELU: _ActivationFunction.ValueType  # 1
    ACTIVATION_FUNCTION_SWIGLU: _ActivationFunction.ValueType  # 2
    ACTIVATION_FUNCTION_RELU: _ActivationFunction.ValueType  # 3
    ACTIVATION_FUNCTION_SILU: _ActivationFunction.ValueType  # 4
    ACTIVATION_FUNCTION_TANH: _ActivationFunction.ValueType  # 5
    ACTIVATION_FUNCTION_SIGMOID: _ActivationFunction.ValueType  # 6
    ACTIVATION_FUNCTION_MISH: _ActivationFunction.ValueType  # 7
    ACTIVATION_FUNCTION_LEAKY_RELU: _ActivationFunction.ValueType  # 8

class ActivationFunction(
    _ActivationFunction, metaclass=_ActivationFunctionEnumTypeWrapper
):
    """Activation function types"""

ACTIVATION_FUNCTION_UNSPECIFIED: ActivationFunction.ValueType  # 0
ACTIVATION_FUNCTION_GELU: ActivationFunction.ValueType  # 1
ACTIVATION_FUNCTION_SWIGLU: ActivationFunction.ValueType  # 2
ACTIVATION_FUNCTION_RELU: ActivationFunction.ValueType  # 3
ACTIVATION_FUNCTION_SILU: ActivationFunction.ValueType  # 4
ACTIVATION_FUNCTION_TANH: ActivationFunction.ValueType  # 5
ACTIVATION_FUNCTION_SIGMOID: ActivationFunction.ValueType  # 6
ACTIVATION_FUNCTION_MISH: ActivationFunction.ValueType  # 7
ACTIVATION_FUNCTION_LEAKY_RELU: ActivationFunction.ValueType  # 8
global___ActivationFunction = ActivationFunction

class _TrainingTechnique:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TrainingTechniqueEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _TrainingTechnique.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TRAINING_TECHNIQUE_UNSPECIFIED: _TrainingTechnique.ValueType  # 0
    TRAINING_TECHNIQUE_SUPERVISED: _TrainingTechnique.ValueType  # 1
    TRAINING_TECHNIQUE_REINFORCEMENT_LEARNING_FROM_HUMAN_FEEDBACK: (
        _TrainingTechnique.ValueType
    )  # 2
    TRAINING_TECHNIQUE_CONSTITUTIONAL_AI: _TrainingTechnique.ValueType  # 3
    TRAINING_TECHNIQUE_DIRECT_PREFERENCE_OPTIMIZATION: _TrainingTechnique.ValueType  # 4
    TRAINING_TECHNIQUE_PROXIMAL_POLICY_OPTIMIZATION: _TrainingTechnique.ValueType  # 5
    TRAINING_TECHNIQUE_SUPERVISED_FINE_TUNING: _TrainingTechnique.ValueType  # 6
    TRAINING_TECHNIQUE_INSTRUCTION_TUNING: _TrainingTechnique.ValueType  # 7
    TRAINING_TECHNIQUE_FEW_SHOT: _TrainingTechnique.ValueType  # 8
    TRAINING_TECHNIQUE_CHAIN_OF_THOUGHT: _TrainingTechnique.ValueType  # 9

class TrainingTechnique(
    _TrainingTechnique, metaclass=_TrainingTechniqueEnumTypeWrapper
):
    """Training technique types"""

TRAINING_TECHNIQUE_UNSPECIFIED: TrainingTechnique.ValueType  # 0
TRAINING_TECHNIQUE_SUPERVISED: TrainingTechnique.ValueType  # 1
TRAINING_TECHNIQUE_REINFORCEMENT_LEARNING_FROM_HUMAN_FEEDBACK: (
    TrainingTechnique.ValueType
)  # 2
TRAINING_TECHNIQUE_CONSTITUTIONAL_AI: TrainingTechnique.ValueType  # 3
TRAINING_TECHNIQUE_DIRECT_PREFERENCE_OPTIMIZATION: TrainingTechnique.ValueType  # 4
TRAINING_TECHNIQUE_PROXIMAL_POLICY_OPTIMIZATION: TrainingTechnique.ValueType  # 5
TRAINING_TECHNIQUE_SUPERVISED_FINE_TUNING: TrainingTechnique.ValueType  # 6
TRAINING_TECHNIQUE_INSTRUCTION_TUNING: TrainingTechnique.ValueType  # 7
TRAINING_TECHNIQUE_FEW_SHOT: TrainingTechnique.ValueType  # 8
TRAINING_TECHNIQUE_CHAIN_OF_THOUGHT: TrainingTechnique.ValueType  # 9
global___TrainingTechnique = TrainingTechnique

class _Quantization:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _QuantizationEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _Quantization.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    QUANTIZATION_UNSPECIFIED: _Quantization.ValueType  # 0
    QUANTIZATION_NONE: _Quantization.ValueType  # 1
    QUANTIZATION_INT8: _Quantization.ValueType  # 2
    QUANTIZATION_INT4: _Quantization.ValueType  # 3
    QUANTIZATION_FP8: _Quantization.ValueType  # 4
    QUANTIZATION_GPTQ: _Quantization.ValueType  # 5
    QUANTIZATION_AWQ: _Quantization.ValueType  # 6
    QUANTIZATION_GGUF: _Quantization.ValueType  # 7
    QUANTIZATION_BITSANDBYTES: _Quantization.ValueType  # 8

class Quantization(_Quantization, metaclass=_QuantizationEnumTypeWrapper):
    """Quantization types"""

QUANTIZATION_UNSPECIFIED: Quantization.ValueType  # 0
QUANTIZATION_NONE: Quantization.ValueType  # 1
QUANTIZATION_INT8: Quantization.ValueType  # 2
QUANTIZATION_INT4: Quantization.ValueType  # 3
QUANTIZATION_FP8: Quantization.ValueType  # 4
QUANTIZATION_GPTQ: Quantization.ValueType  # 5
QUANTIZATION_AWQ: Quantization.ValueType  # 6
QUANTIZATION_GGUF: Quantization.ValueType  # 7
QUANTIZATION_BITSANDBYTES: Quantization.ValueType  # 8
global___Quantization = Quantization

class _Precision:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PrecisionEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Precision.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PRECISION_UNSPECIFIED: _Precision.ValueType  # 0
    PRECISION_FP32: _Precision.ValueType  # 1
    PRECISION_FP16: _Precision.ValueType  # 2
    PRECISION_BF16: _Precision.ValueType  # 3
    PRECISION_INT8: _Precision.ValueType  # 4
    PRECISION_MIXED: _Precision.ValueType  # 5

class Precision(_Precision, metaclass=_PrecisionEnumTypeWrapper):
    """Precision types"""

PRECISION_UNSPECIFIED: Precision.ValueType  # 0
PRECISION_FP32: Precision.ValueType  # 1
PRECISION_FP16: Precision.ValueType  # 2
PRECISION_BF16: Precision.ValueType  # 3
PRECISION_INT8: Precision.ValueType  # 4
PRECISION_MIXED: Precision.ValueType  # 5
global___Precision = Precision

class _InferenceFramework:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InferenceFrameworkEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _InferenceFramework.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INFERENCE_FRAMEWORK_UNSPECIFIED: _InferenceFramework.ValueType  # 0
    INFERENCE_FRAMEWORK_VLLM: _InferenceFramework.ValueType  # 1
    INFERENCE_FRAMEWORK_TGI: _InferenceFramework.ValueType  # 2
    INFERENCE_FRAMEWORK_TRITON: _InferenceFramework.ValueType  # 3
    INFERENCE_FRAMEWORK_TENSORRT: _InferenceFramework.ValueType  # 4
    INFERENCE_FRAMEWORK_ONNX: _InferenceFramework.ValueType  # 5
    INFERENCE_FRAMEWORK_TORCHSERVE: _InferenceFramework.ValueType  # 6
    INFERENCE_FRAMEWORK_TENSORFLOW_SERVING: _InferenceFramework.ValueType  # 7
    INFERENCE_FRAMEWORK_RAY_SERVE: _InferenceFramework.ValueType  # 8
    INFERENCE_FRAMEWORK_DEEPSPEED: _InferenceFramework.ValueType  # 9
    INFERENCE_FRAMEWORK_FASTERTRANSFORMER: _InferenceFramework.ValueType  # 10

class InferenceFramework(
    _InferenceFramework, metaclass=_InferenceFrameworkEnumTypeWrapper
):
    """Inference framework types"""

INFERENCE_FRAMEWORK_UNSPECIFIED: InferenceFramework.ValueType  # 0
INFERENCE_FRAMEWORK_VLLM: InferenceFramework.ValueType  # 1
INFERENCE_FRAMEWORK_TGI: InferenceFramework.ValueType  # 2
INFERENCE_FRAMEWORK_TRITON: InferenceFramework.ValueType  # 3
INFERENCE_FRAMEWORK_TENSORRT: InferenceFramework.ValueType  # 4
INFERENCE_FRAMEWORK_ONNX: InferenceFramework.ValueType  # 5
INFERENCE_FRAMEWORK_TORCHSERVE: InferenceFramework.ValueType  # 6
INFERENCE_FRAMEWORK_TENSORFLOW_SERVING: InferenceFramework.ValueType  # 7
INFERENCE_FRAMEWORK_RAY_SERVE: InferenceFramework.ValueType  # 8
INFERENCE_FRAMEWORK_DEEPSPEED: InferenceFramework.ValueType  # 9
INFERENCE_FRAMEWORK_FASTERTRANSFORMER: InferenceFramework.ValueType  # 10
global___InferenceFramework = InferenceFramework

class _ModelFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModelFormatEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ModelFormat.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MODEL_FORMAT_UNSPECIFIED: _ModelFormat.ValueType  # 0
    MODEL_FORMAT_SAFETENSORS: _ModelFormat.ValueType  # 1
    MODEL_FORMAT_GGUF: _ModelFormat.ValueType  # 2
    MODEL_FORMAT_ONNX: _ModelFormat.ValueType  # 3
    MODEL_FORMAT_PYTORCH: _ModelFormat.ValueType  # 4
    MODEL_FORMAT_TENSORFLOW: _ModelFormat.ValueType  # 5
    MODEL_FORMAT_JAX: _ModelFormat.ValueType  # 6
    MODEL_FORMAT_COREML: _ModelFormat.ValueType  # 7
    MODEL_FORMAT_OPENVINO: _ModelFormat.ValueType  # 8
    MODEL_FORMAT_TENSORRT: _ModelFormat.ValueType  # 9

class ModelFormat(_ModelFormat, metaclass=_ModelFormatEnumTypeWrapper):
    """Model format types"""

MODEL_FORMAT_UNSPECIFIED: ModelFormat.ValueType  # 0
MODEL_FORMAT_SAFETENSORS: ModelFormat.ValueType  # 1
MODEL_FORMAT_GGUF: ModelFormat.ValueType  # 2
MODEL_FORMAT_ONNX: ModelFormat.ValueType  # 3
MODEL_FORMAT_PYTORCH: ModelFormat.ValueType  # 4
MODEL_FORMAT_TENSORFLOW: ModelFormat.ValueType  # 5
MODEL_FORMAT_JAX: ModelFormat.ValueType  # 6
MODEL_FORMAT_COREML: ModelFormat.ValueType  # 7
MODEL_FORMAT_OPENVINO: ModelFormat.ValueType  # 8
MODEL_FORMAT_TENSORRT: ModelFormat.ValueType  # 9
global___ModelFormat = ModelFormat

class _CheckpointFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CheckpointFormatEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _CheckpointFormat.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CHECKPOINT_FORMAT_UNSPECIFIED: _CheckpointFormat.ValueType  # 0
    CHECKPOINT_FORMAT_PYTORCH: _CheckpointFormat.ValueType  # 1
    CHECKPOINT_FORMAT_TENSORFLOW: _CheckpointFormat.ValueType  # 2
    CHECKPOINT_FORMAT_SAFETENSORS: _CheckpointFormat.ValueType  # 3
    CHECKPOINT_FORMAT_HF: _CheckpointFormat.ValueType  # 4
    CHECKPOINT_FORMAT_MEGATRON: _CheckpointFormat.ValueType  # 5
    CHECKPOINT_FORMAT_DEEPSPEED: _CheckpointFormat.ValueType  # 6

class CheckpointFormat(_CheckpointFormat, metaclass=_CheckpointFormatEnumTypeWrapper):
    """Checkpoint format types"""

CHECKPOINT_FORMAT_UNSPECIFIED: CheckpointFormat.ValueType  # 0
CHECKPOINT_FORMAT_PYTORCH: CheckpointFormat.ValueType  # 1
CHECKPOINT_FORMAT_TENSORFLOW: CheckpointFormat.ValueType  # 2
CHECKPOINT_FORMAT_SAFETENSORS: CheckpointFormat.ValueType  # 3
CHECKPOINT_FORMAT_HF: CheckpointFormat.ValueType  # 4
CHECKPOINT_FORMAT_MEGATRON: CheckpointFormat.ValueType  # 5
CHECKPOINT_FORMAT_DEEPSPEED: CheckpointFormat.ValueType  # 6
global___CheckpointFormat = CheckpointFormat

class _GPUType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GPUTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GPUType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    GPU_TYPE_UNSPECIFIED: _GPUType.ValueType  # 0
    GPU_TYPE_A100: _GPUType.ValueType  # 1
    """Datacenter/Enterprise GPUs"""
    GPU_TYPE_H100: _GPUType.ValueType  # 2
    GPU_TYPE_V100: _GPUType.ValueType  # 3
    GPU_TYPE_T4: _GPUType.ValueType  # 4
    GPU_TYPE_L4: _GPUType.ValueType  # 5
    GPU_TYPE_L40: _GPUType.ValueType  # 6
    GPU_TYPE_A10: _GPUType.ValueType  # 7
    GPU_TYPE_A40: _GPUType.ValueType  # 8
    GPU_TYPE_RTX_A6000: _GPUType.ValueType  # 9
    GPU_TYPE_RTX_A5000: _GPUType.ValueType  # 10
    GPU_TYPE_RTX_A4000: _GPUType.ValueType  # 11
    GPU_TYPE_RTX_4090: _GPUType.ValueType  # 20
    """Consumer GPUs (40 series)"""
    GPU_TYPE_RTX_4080: _GPUType.ValueType  # 21
    GPU_TYPE_RTX_4070_TI: _GPUType.ValueType  # 22
    GPU_TYPE_RTX_4070: _GPUType.ValueType  # 23
    GPU_TYPE_RTX_4060_TI: _GPUType.ValueType  # 24
    GPU_TYPE_RTX_4060: _GPUType.ValueType  # 25
    GPU_TYPE_RTX_3090_TI: _GPUType.ValueType  # 30
    """Consumer GPUs (30 series)"""
    GPU_TYPE_RTX_3090: _GPUType.ValueType  # 31
    GPU_TYPE_RTX_3080_TI: _GPUType.ValueType  # 32
    GPU_TYPE_RTX_3080: _GPUType.ValueType  # 33
    GPU_TYPE_RTX_3070_TI: _GPUType.ValueType  # 34
    GPU_TYPE_RTX_3070: _GPUType.ValueType  # 35
    GPU_TYPE_RTX_3060_TI: _GPUType.ValueType  # 36
    GPU_TYPE_RTX_3060: _GPUType.ValueType  # 37
    GPU_TYPE_MI300: _GPUType.ValueType  # 50
    """AMD GPUs"""
    GPU_TYPE_MI250: _GPUType.ValueType  # 51
    GPU_TYPE_MI210: _GPUType.ValueType  # 52
    GPU_TYPE_RX_7900_XTX: _GPUType.ValueType  # 53
    GPU_TYPE_RX_7900_XT: _GPUType.ValueType  # 54
    GPU_TYPE_RX_6900_XT: _GPUType.ValueType  # 55
    GPU_TYPE_M3_MAX: _GPUType.ValueType  # 60
    """Apple Silicon (unified memory)"""
    GPU_TYPE_M3_PRO: _GPUType.ValueType  # 61
    GPU_TYPE_M3: _GPUType.ValueType  # 62
    GPU_TYPE_M2_ULTRA: _GPUType.ValueType  # 63
    GPU_TYPE_M2_MAX: _GPUType.ValueType  # 64
    GPU_TYPE_M2_PRO: _GPUType.ValueType  # 65
    GPU_TYPE_M2: _GPUType.ValueType  # 66
    GPU_TYPE_M1_ULTRA: _GPUType.ValueType  # 67
    GPU_TYPE_M1_MAX: _GPUType.ValueType  # 68
    GPU_TYPE_M1_PRO: _GPUType.ValueType  # 69
    GPU_TYPE_M1: _GPUType.ValueType  # 70
    GPU_TYPE_RTX_2080_TI: _GPUType.ValueType  # 80
    """Older but still relevant"""
    GPU_TYPE_TITAN_RTX: _GPUType.ValueType  # 81
    GPU_TYPE_GTX_1080_TI: _GPUType.ValueType  # 82

class GPUType(_GPUType, metaclass=_GPUTypeEnumTypeWrapper):
    """GPU types"""

GPU_TYPE_UNSPECIFIED: GPUType.ValueType  # 0
GPU_TYPE_A100: GPUType.ValueType  # 1
"""Datacenter/Enterprise GPUs"""
GPU_TYPE_H100: GPUType.ValueType  # 2
GPU_TYPE_V100: GPUType.ValueType  # 3
GPU_TYPE_T4: GPUType.ValueType  # 4
GPU_TYPE_L4: GPUType.ValueType  # 5
GPU_TYPE_L40: GPUType.ValueType  # 6
GPU_TYPE_A10: GPUType.ValueType  # 7
GPU_TYPE_A40: GPUType.ValueType  # 8
GPU_TYPE_RTX_A6000: GPUType.ValueType  # 9
GPU_TYPE_RTX_A5000: GPUType.ValueType  # 10
GPU_TYPE_RTX_A4000: GPUType.ValueType  # 11
GPU_TYPE_RTX_4090: GPUType.ValueType  # 20
"""Consumer GPUs (40 series)"""
GPU_TYPE_RTX_4080: GPUType.ValueType  # 21
GPU_TYPE_RTX_4070_TI: GPUType.ValueType  # 22
GPU_TYPE_RTX_4070: GPUType.ValueType  # 23
GPU_TYPE_RTX_4060_TI: GPUType.ValueType  # 24
GPU_TYPE_RTX_4060: GPUType.ValueType  # 25
GPU_TYPE_RTX_3090_TI: GPUType.ValueType  # 30
"""Consumer GPUs (30 series)"""
GPU_TYPE_RTX_3090: GPUType.ValueType  # 31
GPU_TYPE_RTX_3080_TI: GPUType.ValueType  # 32
GPU_TYPE_RTX_3080: GPUType.ValueType  # 33
GPU_TYPE_RTX_3070_TI: GPUType.ValueType  # 34
GPU_TYPE_RTX_3070: GPUType.ValueType  # 35
GPU_TYPE_RTX_3060_TI: GPUType.ValueType  # 36
GPU_TYPE_RTX_3060: GPUType.ValueType  # 37
GPU_TYPE_MI300: GPUType.ValueType  # 50
"""AMD GPUs"""
GPU_TYPE_MI250: GPUType.ValueType  # 51
GPU_TYPE_MI210: GPUType.ValueType  # 52
GPU_TYPE_RX_7900_XTX: GPUType.ValueType  # 53
GPU_TYPE_RX_7900_XT: GPUType.ValueType  # 54
GPU_TYPE_RX_6900_XT: GPUType.ValueType  # 55
GPU_TYPE_M3_MAX: GPUType.ValueType  # 60
"""Apple Silicon (unified memory)"""
GPU_TYPE_M3_PRO: GPUType.ValueType  # 61
GPU_TYPE_M3: GPUType.ValueType  # 62
GPU_TYPE_M2_ULTRA: GPUType.ValueType  # 63
GPU_TYPE_M2_MAX: GPUType.ValueType  # 64
GPU_TYPE_M2_PRO: GPUType.ValueType  # 65
GPU_TYPE_M2: GPUType.ValueType  # 66
GPU_TYPE_M1_ULTRA: GPUType.ValueType  # 67
GPU_TYPE_M1_MAX: GPUType.ValueType  # 68
GPU_TYPE_M1_PRO: GPUType.ValueType  # 69
GPU_TYPE_M1: GPUType.ValueType  # 70
GPU_TYPE_RTX_2080_TI: GPUType.ValueType  # 80
"""Older but still relevant"""
GPU_TYPE_TITAN_RTX: GPUType.ValueType  # 81
GPU_TYPE_GTX_1080_TI: GPUType.ValueType  # 82
global___GPUType = GPUType

class _CPUType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CPUTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CPUType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CPU_TYPE_UNSPECIFIED: _CPUType.ValueType  # 0
    CPU_TYPE_X86_64: _CPUType.ValueType  # 1
    CPU_TYPE_ARM64: _CPUType.ValueType  # 2
    CPU_TYPE_APPLE_SILICON: _CPUType.ValueType  # 3
    CPU_TYPE_AMD64: _CPUType.ValueType  # 4
    CPU_TYPE_GRAVITON: _CPUType.ValueType  # 5

class CPUType(_CPUType, metaclass=_CPUTypeEnumTypeWrapper):
    """CPU architecture types"""

CPU_TYPE_UNSPECIFIED: CPUType.ValueType  # 0
CPU_TYPE_X86_64: CPUType.ValueType  # 1
CPU_TYPE_ARM64: CPUType.ValueType  # 2
CPU_TYPE_APPLE_SILICON: CPUType.ValueType  # 3
CPU_TYPE_AMD64: CPUType.ValueType  # 4
CPU_TYPE_GRAVITON: CPUType.ValueType  # 5
global___CPUType = CPUType

class _ModerationLevel:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModerationLevelEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _ModerationLevel.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MODERATION_LEVEL_UNSPECIFIED: _ModerationLevel.ValueType  # 0
    MODERATION_LEVEL_NONE: _ModerationLevel.ValueType  # 1
    MODERATION_LEVEL_LOW: _ModerationLevel.ValueType  # 2
    MODERATION_LEVEL_MEDIUM: _ModerationLevel.ValueType  # 3
    MODERATION_LEVEL_HIGH: _ModerationLevel.ValueType  # 4
    MODERATION_LEVEL_STRICT: _ModerationLevel.ValueType  # 5

class ModerationLevel(_ModerationLevel, metaclass=_ModerationLevelEnumTypeWrapper):
    """Moderation level"""

MODERATION_LEVEL_UNSPECIFIED: ModerationLevel.ValueType  # 0
MODERATION_LEVEL_NONE: ModerationLevel.ValueType  # 1
MODERATION_LEVEL_LOW: ModerationLevel.ValueType  # 2
MODERATION_LEVEL_MEDIUM: ModerationLevel.ValueType  # 3
MODERATION_LEVEL_HIGH: ModerationLevel.ValueType  # 4
MODERATION_LEVEL_STRICT: ModerationLevel.ValueType  # 5
global___ModerationLevel = ModerationLevel

class _LicenseType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LicenseTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LicenseType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LICENSE_TYPE_UNSPECIFIED: _LicenseType.ValueType  # 0
    LICENSE_TYPE_MIT: _LicenseType.ValueType  # 1
    LICENSE_TYPE_APACHE_2_0: _LicenseType.ValueType  # 2
    LICENSE_TYPE_GPL: _LicenseType.ValueType  # 3
    LICENSE_TYPE_BSD: _LicenseType.ValueType  # 4
    LICENSE_TYPE_COMMERCIAL: _LicenseType.ValueType  # 5
    LICENSE_TYPE_PROPRIETARY: _LicenseType.ValueType  # 6
    LICENSE_TYPE_CUSTOM: _LicenseType.ValueType  # 7
    LICENSE_TYPE_CC_BY: _LicenseType.ValueType  # 8
    LICENSE_TYPE_CC_BY_NC: _LicenseType.ValueType  # 9
    LICENSE_TYPE_CC_BY_SA: _LicenseType.ValueType  # 10
    LICENSE_TYPE_LLAMA: _LicenseType.ValueType  # 11
    LICENSE_TYPE_OPENAI: _LicenseType.ValueType  # 12

class LicenseType(_LicenseType, metaclass=_LicenseTypeEnumTypeWrapper):
    """License types"""

LICENSE_TYPE_UNSPECIFIED: LicenseType.ValueType  # 0
LICENSE_TYPE_MIT: LicenseType.ValueType  # 1
LICENSE_TYPE_APACHE_2_0: LicenseType.ValueType  # 2
LICENSE_TYPE_GPL: LicenseType.ValueType  # 3
LICENSE_TYPE_BSD: LicenseType.ValueType  # 4
LICENSE_TYPE_COMMERCIAL: LicenseType.ValueType  # 5
LICENSE_TYPE_PROPRIETARY: LicenseType.ValueType  # 6
LICENSE_TYPE_CUSTOM: LicenseType.ValueType  # 7
LICENSE_TYPE_CC_BY: LicenseType.ValueType  # 8
LICENSE_TYPE_CC_BY_NC: LicenseType.ValueType  # 9
LICENSE_TYPE_CC_BY_SA: LicenseType.ValueType  # 10
LICENSE_TYPE_LLAMA: LicenseType.ValueType  # 11
LICENSE_TYPE_OPENAI: LicenseType.ValueType  # 12
global___LicenseType = LicenseType

@typing.final
class Architecture(google.protobuf.message.Message):
    """Architecture describes the technical architecture of an AI model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASE_ARCHITECTURE_FIELD_NUMBER: builtins.int
    MODEL_ARCHITECTURE_FIELD_NUMBER: builtins.int
    PARAMETER_COUNT_FIELD_NUMBER: builtins.int
    ACTIVE_PARAMETERS_FIELD_NUMBER: builtins.int
    TOTAL_PARAMETERS_FIELD_NUMBER: builtins.int
    LAYER_COUNT_FIELD_NUMBER: builtins.int
    HIDDEN_SIZE_FIELD_NUMBER: builtins.int
    ATTENTION_HEADS_FIELD_NUMBER: builtins.int
    VOCABULARY_SIZE_FIELD_NUMBER: builtins.int
    POSITION_EMBEDDING_FIELD_NUMBER: builtins.int
    ACTIVATION_FUNCTION_FIELD_NUMBER: builtins.int
    IS_MIXTURE_OF_EXPERTS_FIELD_NUMBER: builtins.int
    EXPERT_COUNT_FIELD_NUMBER: builtins.int
    EXPERTS_PER_TOKEN_FIELD_NUMBER: builtins.int
    base_architecture: global___BaseArchitecture.ValueType
    """Fundamental architecture type (Transformer, Mamba, etc.).
    Example: BASE_ARCHITECTURE_TRANSFORMER for GPT models
    """
    model_architecture: global___ModelArchitecture.ValueType
    """Specific model family/variant.
    Example: MODEL_ARCHITECTURE_GPT for GPT-4, MODEL_ARCHITECTURE_LLAMA for LLaMA
    """
    parameter_count: builtins.int
    """Total learnable parameters in billions.
    Example: 175 for GPT-3 (175B parameters)
    """
    active_parameters: builtins.int
    """Parameters activated per forward pass (for MoE models).
    Example: 8B active out of 141B total for Mixtral-8x7B
    """
    total_parameters: builtins.int
    """Total parameters including non-trainable (embeddings, etc.).
    May be slightly higher than parameter_count
    """
    layer_count: builtins.int
    """Number of transformer/attention layers.
    Example: 96 for GPT-3, 32 for 7B models
    """
    hidden_size: builtins.int
    """Hidden dimension size of the model.
    Example: 12288 for GPT-3, 4096 for smaller models
    """
    attention_heads: builtins.int
    """Number of attention heads in multi-head attention.
    Example: 96 for GPT-3, 32 for 7B models
    """
    vocabulary_size: builtins.int
    """Size of the token vocabulary.
    Example: 50257 for GPT-2/3, 32000 for LLaMA
    """
    position_embedding: global___PositionEmbedding.ValueType
    """Type of position encoding used.
    Example: POSITION_EMBEDDING_ROTARY for modern models (RoPE)
    """
    activation_function: global___ActivationFunction.ValueType
    """Activation function in feed-forward layers.
    Example: ACTIVATION_FUNCTION_SWIGLU for LLaMA models
    """
    is_mixture_of_experts: builtins.bool
    """Whether this is a Mixture of Experts model.
    Example: true for Mixtral, GPT-4 (rumored), false for dense models
    """
    expert_count: builtins.int
    """Total number of expert networks (for MoE).
    Example: 8 for Mixtral-8x7B
    """
    experts_per_token: builtins.int
    """Number of experts activated per token (for MoE).
    Example: 2 for Mixtral (2 experts per token out of 8)
    """
    def __init__(
        self,
        *,
        base_architecture: global___BaseArchitecture.ValueType = ...,
        model_architecture: global___ModelArchitecture.ValueType = ...,
        parameter_count: builtins.int = ...,
        active_parameters: builtins.int = ...,
        total_parameters: builtins.int = ...,
        layer_count: builtins.int = ...,
        hidden_size: builtins.int = ...,
        attention_heads: builtins.int = ...,
        vocabulary_size: builtins.int = ...,
        position_embedding: global___PositionEmbedding.ValueType = ...,
        activation_function: global___ActivationFunction.ValueType = ...,
        is_mixture_of_experts: builtins.bool = ...,
        expert_count: builtins.int = ...,
        experts_per_token: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "activation_function",
            b"activation_function",
            "active_parameters",
            b"active_parameters",
            "attention_heads",
            b"attention_heads",
            "base_architecture",
            b"base_architecture",
            "expert_count",
            b"expert_count",
            "experts_per_token",
            b"experts_per_token",
            "hidden_size",
            b"hidden_size",
            "is_mixture_of_experts",
            b"is_mixture_of_experts",
            "layer_count",
            b"layer_count",
            "model_architecture",
            b"model_architecture",
            "parameter_count",
            b"parameter_count",
            "position_embedding",
            b"position_embedding",
            "total_parameters",
            b"total_parameters",
            "vocabulary_size",
            b"vocabulary_size",
        ],
    ) -> None: ...

global___Architecture = Architecture

@typing.final
class Training(google.protobuf.message.Message):
    """Training contains information about how the model was trained."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAINING_DATA_SIZE_FIELD_NUMBER: builtins.int
    TRAINING_DATA_SOURCES_FIELD_NUMBER: builtins.int
    DATA_MIXTURE_FIELD_NUMBER: builtins.int
    TRAINING_DURATION_FIELD_NUMBER: builtins.int
    TRAINING_HARDWARE_FIELD_NUMBER: builtins.int
    TRAINING_COST_FIELD_NUMBER: builtins.int
    TRAINING_TECHNIQUE_FIELD_NUMBER: builtins.int
    BATCH_SIZE_FIELD_NUMBER: builtins.int
    LEARNING_RATE_FIELD_NUMBER: builtins.int
    TRAINING_STEPS_FIELD_NUMBER: builtins.int
    WARMUP_STEPS_FIELD_NUMBER: builtins.int
    FINE_TUNING_AVAILABLE_FIELD_NUMBER: builtins.int
    MIN_FINE_TUNE_EXAMPLES_FIELD_NUMBER: builtins.int
    MAX_FINE_TUNE_EXAMPLES_FIELD_NUMBER: builtins.int
    FINE_TUNE_FORMATS_FIELD_NUMBER: builtins.int
    training_data_size: builtins.str
    """Size of training dataset.
    Examples: "1T tokens", "45TB text", "100B tokens"
    """
    data_mixture: builtins.str
    """Description of data mixture/proportions.
    Example: "60% web, 20% books, 10% code, 10% reference"
    """
    training_duration: builtins.str
    """Total training time.
    Examples: "3 months", "6 weeks", "90 days"
    """
    training_hardware: builtins.str
    """Hardware used for training.
    Examples: "10000 H100 GPUs", "512 A100 80GB", "TPU v4 pods"
    """
    training_cost: builtins.str
    """Estimated training cost.
    Examples: "$100M", "$4.6M", "Not disclosed"
    """
    training_technique: global___TrainingTechnique.ValueType
    """Primary training technique used.
    Example: TRAINING_TECHNIQUE_REINFORCEMENT_LEARNING_FROM_HUMAN_FEEDBACK
    """
    batch_size: builtins.int
    """Training batch size per step.
    Example: 2048, 4096
    """
    learning_rate: builtins.float
    """Peak learning rate used.
    Example: 0.0001, 3e-4
    """
    training_steps: builtins.int
    """Total number of training steps/iterations.
    Example: 1000000
    """
    warmup_steps: builtins.int
    """Number of warmup steps for learning rate schedule.
    Example: 2000
    """
    fine_tuning_available: builtins.bool
    """Whether model supports fine-tuning via API.
    Example: true for GPT-3.5, false for GPT-4
    """
    min_fine_tune_examples: builtins.int
    """Minimum training examples required for fine-tuning.
    Example: 10 for OpenAI models
    """
    max_fine_tune_examples: builtins.int
    """Maximum training examples allowed for fine-tuning.
    Example: 100000 for GPT-3.5
    """
    @property
    def training_data_sources(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of data sources used for training.
        Examples: ["Common Crawl", "Wikipedia", "Books", "GitHub", "ArXiv"]
        """

    @property
    def fine_tune_formats(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        weaveapi.llmx.v1.capabilities_pb2.DataFormat.ValueType
    ]:
        """Supported data formats for fine-tuning.
        Example: [DATA_FORMAT_JSONL, DATA_FORMAT_CSV]
        """

    def __init__(
        self,
        *,
        training_data_size: builtins.str = ...,
        training_data_sources: collections.abc.Iterable[builtins.str] | None = ...,
        data_mixture: builtins.str = ...,
        training_duration: builtins.str = ...,
        training_hardware: builtins.str = ...,
        training_cost: builtins.str = ...,
        training_technique: global___TrainingTechnique.ValueType = ...,
        batch_size: builtins.int = ...,
        learning_rate: builtins.float = ...,
        training_steps: builtins.int = ...,
        warmup_steps: builtins.int = ...,
        fine_tuning_available: builtins.bool = ...,
        min_fine_tune_examples: builtins.int = ...,
        max_fine_tune_examples: builtins.int = ...,
        fine_tune_formats: collections.abc.Iterable[
            weaveapi.llmx.v1.capabilities_pb2.DataFormat.ValueType
        ]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "batch_size",
            b"batch_size",
            "data_mixture",
            b"data_mixture",
            "fine_tune_formats",
            b"fine_tune_formats",
            "fine_tuning_available",
            b"fine_tuning_available",
            "learning_rate",
            b"learning_rate",
            "max_fine_tune_examples",
            b"max_fine_tune_examples",
            "min_fine_tune_examples",
            b"min_fine_tune_examples",
            "training_cost",
            b"training_cost",
            "training_data_size",
            b"training_data_size",
            "training_data_sources",
            b"training_data_sources",
            "training_duration",
            b"training_duration",
            "training_hardware",
            b"training_hardware",
            "training_steps",
            b"training_steps",
            "training_technique",
            b"training_technique",
            "warmup_steps",
            b"warmup_steps",
        ],
    ) -> None: ...

global___Training = Training

@typing.final
class TechnicalSpecs(google.protobuf.message.Message):
    """TechnicalSpecs contains hardware and software requirements for running the model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_MEMORY_GB_FIELD_NUMBER: builtins.int
    RECOMMENDED_MEMORY_GB_FIELD_NUMBER: builtins.int
    MIN_GPU_MEMORY_GB_FIELD_NUMBER: builtins.int
    STORAGE_GB_FIELD_NUMBER: builtins.int
    QUANTIZATION_FIELD_NUMBER: builtins.int
    PRECISION_FIELD_NUMBER: builtins.int
    OPTIMIZATION_LEVEL_FIELD_NUMBER: builtins.int
    SUPPORTED_GPUS_FIELD_NUMBER: builtins.int
    REQUIRES_CUDA_FIELD_NUMBER: builtins.int
    CUDA_VERSION_FIELD_NUMBER: builtins.int
    INFERENCE_FRAMEWORK_FIELD_NUMBER: builtins.int
    MODEL_FORMAT_FIELD_NUMBER: builtins.int
    MODEL_SIZE_GB_FIELD_NUMBER: builtins.int
    CHECKPOINT_FORMAT_FIELD_NUMBER: builtins.int
    NUMBER_OF_FILES_FIELD_NUMBER: builtins.int
    SUPPORTED_CPUS_FIELD_NUMBER: builtins.int
    SERVING_FRAMEWORK_FIELD_NUMBER: builtins.int
    CONTAINER_IMAGE_FIELD_NUMBER: builtins.int
    MINIMUM_GPU_FIELD_NUMBER: builtins.int
    MINIMUM_GPU_MEMORY_GB_FIELD_NUMBER: builtins.int
    CPU_COMPATIBLE_FIELD_NUMBER: builtins.int
    RECOMMENDED_GPU_MEMORY_GB_FIELD_NUMBER: builtins.int
    min_memory_gb: builtins.int
    """Minimum system RAM required in GB.
    Example: 32 for 7B models, 64 for 13B models
    """
    recommended_memory_gb: builtins.int
    """Recommended system RAM for optimal performance in GB.
    Example: 64 for 7B models, 128 for 13B models
    """
    min_gpu_memory_gb: builtins.int
    """Minimum GPU VRAM required in GB.
    Example: 24 for 7B fp16, 48 for 13B fp16
    """
    storage_gb: builtins.int
    """Disk storage required for model files in GB.
    Example: 15 for 7B models, 30 for 13B models
    """
    quantization: global___Quantization.ValueType
    """Quantization method if applicable.
    Example: QUANTIZATION_INT8 for 8-bit quantized models
    """
    precision: global___Precision.ValueType
    """Numerical precision used.
    Example: PRECISION_FP16 for half-precision inference
    """
    optimization_level: builtins.str
    """Optimization level/profile.
    Examples: "O3", "fast", "balanced", "memory-optimized"
    """
    requires_cuda: builtins.bool
    """Whether CUDA is required for GPU inference.
    Example: true for NVIDIA GPUs, false for CPU-only
    """
    cuda_version: builtins.str
    """Minimum CUDA version required.
    Examples: "11.8", "12.0"
    """
    inference_framework: global___InferenceFramework.ValueType
    """Recommended inference framework.
    Example: INFERENCE_FRAMEWORK_VLLM for high-throughput serving
    """
    model_format: global___ModelFormat.ValueType
    """Format of distributed model files.
    Example: MODEL_FORMAT_SAFETENSORS for HuggingFace models
    """
    model_size_gb: builtins.float
    """Total size of model files in GB.
    Example: 13.5 for 7B model in fp16
    """
    checkpoint_format: global___CheckpointFormat.ValueType
    """Format of model checkpoint files.
    Example: CHECKPOINT_FORMAT_PYTORCH for .pt files
    """
    number_of_files: builtins.int
    """Number of model shard files.
    Example: 2 for models split across multiple files
    """
    serving_framework: builtins.str
    """Serving framework/stack.
    Examples: "TGI", "vLLM", "llama.cpp"
    """
    container_image: builtins.str
    """Pre-built container image if available.
    Example: "nvcr.io/nvidia/pytorch:23.10-py3"
    """
    minimum_gpu: global___GPUType.ValueType
    """Minimum GPU for reasonable performance.
    Example: GPU_TYPE_RTX_3090 for 7B models
    """
    minimum_gpu_memory_gb: builtins.int
    """Minimum GPU memory for basic inference in GB.
    Example: 16 for 7B int8 models
    """
    cpu_compatible: builtins.bool
    """Whether model can run on CPU (even if slowly).
    Example: true for smaller quantized models
    """
    recommended_gpu_memory_gb: builtins.int
    """Recommended GPU memory for good performance in GB.
    Example: 24 for 7B fp16 with reasonable batch size
    """
    @property
    def supported_gpus(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___GPUType.ValueType
    ]:
        """List of compatible GPU types.
        Example: [GPU_TYPE_A100, GPU_TYPE_H100, GPU_TYPE_RTX_4090]
        """

    @property
    def supported_cpus(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___CPUType.ValueType
    ]:
        """List of compatible CPU architectures.
        Example: [CPU_TYPE_X86_64, CPU_TYPE_ARM64]
        """

    def __init__(
        self,
        *,
        min_memory_gb: builtins.int = ...,
        recommended_memory_gb: builtins.int = ...,
        min_gpu_memory_gb: builtins.int = ...,
        storage_gb: builtins.int = ...,
        quantization: global___Quantization.ValueType = ...,
        precision: global___Precision.ValueType = ...,
        optimization_level: builtins.str = ...,
        supported_gpus: collections.abc.Iterable[global___GPUType.ValueType]
        | None = ...,
        requires_cuda: builtins.bool = ...,
        cuda_version: builtins.str = ...,
        inference_framework: global___InferenceFramework.ValueType = ...,
        model_format: global___ModelFormat.ValueType = ...,
        model_size_gb: builtins.float = ...,
        checkpoint_format: global___CheckpointFormat.ValueType = ...,
        number_of_files: builtins.int = ...,
        supported_cpus: collections.abc.Iterable[global___CPUType.ValueType]
        | None = ...,
        serving_framework: builtins.str = ...,
        container_image: builtins.str = ...,
        minimum_gpu: global___GPUType.ValueType = ...,
        minimum_gpu_memory_gb: builtins.int = ...,
        cpu_compatible: builtins.bool = ...,
        recommended_gpu_memory_gb: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "checkpoint_format",
            b"checkpoint_format",
            "container_image",
            b"container_image",
            "cpu_compatible",
            b"cpu_compatible",
            "cuda_version",
            b"cuda_version",
            "inference_framework",
            b"inference_framework",
            "min_gpu_memory_gb",
            b"min_gpu_memory_gb",
            "min_memory_gb",
            b"min_memory_gb",
            "minimum_gpu",
            b"minimum_gpu",
            "minimum_gpu_memory_gb",
            b"minimum_gpu_memory_gb",
            "model_format",
            b"model_format",
            "model_size_gb",
            b"model_size_gb",
            "number_of_files",
            b"number_of_files",
            "optimization_level",
            b"optimization_level",
            "precision",
            b"precision",
            "quantization",
            b"quantization",
            "recommended_gpu_memory_gb",
            b"recommended_gpu_memory_gb",
            "recommended_memory_gb",
            b"recommended_memory_gb",
            "requires_cuda",
            b"requires_cuda",
            "serving_framework",
            b"serving_framework",
            "storage_gb",
            b"storage_gb",
            "supported_cpus",
            b"supported_cpus",
            "supported_gpus",
            b"supported_gpus",
        ],
    ) -> None: ...

global___TechnicalSpecs = TechnicalSpecs

@typing.final
class Safety(google.protobuf.message.Message):
    """Safety contains safety, moderation, and compliance features."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODERATION_LEVEL_FIELD_NUMBER: builtins.int
    CONTENT_FILTERING_FIELD_NUMBER: builtins.int
    SAFETY_FILTERS_FIELD_NUMBER: builtins.int
    BIAS_RATING_FIELD_NUMBER: builtins.int
    TOXICITY_SCORE_FIELD_NUMBER: builtins.int
    GDPR_COMPLIANT_FIELD_NUMBER: builtins.int
    HIPAA_COMPLIANT_FIELD_NUMBER: builtins.int
    SOC2_COMPLIANT_FIELD_NUMBER: builtins.int
    ISO_CERTIFIED_FIELD_NUMBER: builtins.int
    REFUSAL_CAPABILITY_FIELD_NUMBER: builtins.int
    WATERMARK_OUTPUT_FIELD_NUMBER: builtins.int
    BUILT_IN_GUARDRAILS_FIELD_NUMBER: builtins.int
    CUSTOM_GUARDRAILS_FIELD_NUMBER: builtins.int
    moderation_level: global___ModerationLevel.ValueType
    """Built-in content moderation strictness.
    Example: MODERATION_LEVEL_HIGH for family-friendly models
    """
    content_filtering: builtins.bool
    """Whether automatic content filtering is enabled.
    Example: true for models that block harmful content
    """
    bias_rating: builtins.str
    """Bias assessment rating.
    Examples: "Low", "Medium", "High", "Evaluated"
    """
    toxicity_score: builtins.float
    """Toxicity score from evaluations (0-1).
    Example: 0.02 for well-aligned models (lower is better)
    """
    gdpr_compliant: builtins.bool
    """GDPR (General Data Protection Regulation) compliance.
    Example: true for models that don't retain user data
    """
    hipaa_compliant: builtins.bool
    """HIPAA (Health Insurance Portability and Accountability Act) compliance.
    Example: true for medical-safe models
    """
    soc2_compliant: builtins.bool
    """SOC 2 (Service Organization Control 2) compliance.
    Example: true for enterprise-grade security
    """
    iso_certified: builtins.bool
    """ISO certification status.
    Example: true for ISO 27001 certified services
    """
    refusal_capability: builtins.bool
    """Can refuse harmful or inappropriate requests.
    Example: true for models trained to decline harmful tasks
    """
    watermark_output: builtins.bool
    """Whether outputs include watermarking.
    Example: true for models with detectible AI signatures
    """
    custom_guardrails: builtins.bool
    """Supports custom safety guardrails.
    Example: true if users can add their own safety rules
    """
    @property
    def safety_filters(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of active safety filters.
        Examples: ["violence", "sexual", "hate", "self-harm", "illegal"]
        """

    @property
    def built_in_guardrails(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Built-in safety guardrails.
        Examples: ["constitutional-ai", "harmlessness", "helpfulness"]
        """

    def __init__(
        self,
        *,
        moderation_level: global___ModerationLevel.ValueType = ...,
        content_filtering: builtins.bool = ...,
        safety_filters: collections.abc.Iterable[builtins.str] | None = ...,
        bias_rating: builtins.str = ...,
        toxicity_score: builtins.float = ...,
        gdpr_compliant: builtins.bool = ...,
        hipaa_compliant: builtins.bool = ...,
        soc2_compliant: builtins.bool = ...,
        iso_certified: builtins.bool = ...,
        refusal_capability: builtins.bool = ...,
        watermark_output: builtins.bool = ...,
        built_in_guardrails: collections.abc.Iterable[builtins.str] | None = ...,
        custom_guardrails: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "bias_rating",
            b"bias_rating",
            "built_in_guardrails",
            b"built_in_guardrails",
            "content_filtering",
            b"content_filtering",
            "custom_guardrails",
            b"custom_guardrails",
            "gdpr_compliant",
            b"gdpr_compliant",
            "hipaa_compliant",
            b"hipaa_compliant",
            "iso_certified",
            b"iso_certified",
            "moderation_level",
            b"moderation_level",
            "refusal_capability",
            b"refusal_capability",
            "safety_filters",
            b"safety_filters",
            "soc2_compliant",
            b"soc2_compliant",
            "toxicity_score",
            b"toxicity_score",
            "watermark_output",
            b"watermark_output",
        ],
    ) -> None: ...

global___Safety = Safety

@typing.final
class Licensing(google.protobuf.message.Message):
    """Licensing contains license and usage terms for the model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LICENSE_TYPE_FIELD_NUMBER: builtins.int
    LICENSE_URL_FIELD_NUMBER: builtins.int
    IS_OPEN_SOURCE_FIELD_NUMBER: builtins.int
    IS_OPEN_WEIGHTS_FIELD_NUMBER: builtins.int
    COMMERCIAL_USE_FIELD_NUMBER: builtins.int
    RESEARCH_USE_FIELD_NUMBER: builtins.int
    ATTRIBUTION_REQUIRED_FIELD_NUMBER: builtins.int
    SHARE_ALIKE_REQUIRED_FIELD_NUMBER: builtins.int
    USAGE_RESTRICTIONS_FIELD_NUMBER: builtins.int
    license_type: global___LicenseType.ValueType
    """Type of license governing model use.
    Example: LICENSE_TYPE_APACHE_2_0, LICENSE_TYPE_PROPRIETARY
    """
    license_url: builtins.str
    """URL to full license text.
    Example: "https://github.com/meta-llama/llama/blob/main/LICENSE"
    """
    is_open_source: builtins.bool
    """Whether source code is openly available.
    Example: true for research papers with code
    """
    is_open_weights: builtins.bool
    """Whether model weights are publicly downloadable.
    Example: true for LLaMA, Mistral; false for GPT-4
    """
    commercial_use: builtins.bool
    """Allowed for commercial/business use.
    Example: true for Apache/MIT licensed models
    """
    research_use: builtins.bool
    """Allowed for research purposes.
    Example: true for most models, even proprietary ones
    """
    attribution_required: builtins.bool
    """Must attribute/cite when using.
    Example: true for CC-BY licenses
    """
    share_alike_required: builtins.bool
    """Derivatives must use same license.
    Example: true for GPL, CC-BY-SA licenses
    """
    @property
    def usage_restrictions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Specific usage restrictions or conditions.
        Examples: ["No use for surveillance", "Monthly active user limits",
                  "No competitive use against provider"]
        """

    def __init__(
        self,
        *,
        license_type: global___LicenseType.ValueType = ...,
        license_url: builtins.str = ...,
        is_open_source: builtins.bool = ...,
        is_open_weights: builtins.bool = ...,
        commercial_use: builtins.bool = ...,
        research_use: builtins.bool = ...,
        attribution_required: builtins.bool = ...,
        share_alike_required: builtins.bool = ...,
        usage_restrictions: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "attribution_required",
            b"attribution_required",
            "commercial_use",
            b"commercial_use",
            "is_open_source",
            b"is_open_source",
            "is_open_weights",
            b"is_open_weights",
            "license_type",
            b"license_type",
            "license_url",
            b"license_url",
            "research_use",
            b"research_use",
            "share_alike_required",
            b"share_alike_required",
            "usage_restrictions",
            b"usage_restrictions",
        ],
    ) -> None: ...

global___Licensing = Licensing
