# Weave Python SDK

Weave Python provides client utilities for integrating with Weave platform services,
covering authentication, generation, synthesis, storage, and more. It is intended
for Python applications that need to orchestrate Weave workflows without managing
low-level HTTP plumbing.

## Installation

```bash
pip install weave-python
```

The package requires Python 3.8 or newer.

## Quick Start

```python
from weave.weaveapi import auth, generate

# Authenticate with your Weave credentials
session = auth.login_with_api_key("your-api-key")

# Send a generation request
result = generate.text(session=session, prompt="Hello Weave!")
print(result.text)
```

Refer to the individual subpackages under `weave.weaveapi` (for example `auth`,
`synthesize`, `storage`, and `payment`) for domain-specific helpers.

## Contributing

1. Create a virtual environment and install dev dependencies with `uv pip sync uv.lock`.
2. Run formatting and linting via `task format` and `task lint`.
3. Open a pull request with context on the workflow or service you changed.

## License

Distributed under the Apache Software License and MIT License. See `LICENSE` for
additional licensing details.
