# Pentest

To prove the security of the *WebScripts Server*, I ran *web scanners* and tools for *web pentest* and printed the results.

You are not impacted by:
 - SSL warnings (certificat generation)
 - The "Server" header (NGINX configuration)

## SkipFish

```bash
skipfish -H Api-Key=AdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdmin -o ~/Documents/skipfish https://127.0.0.1/web/auth/
```

Scanner version: 2.10b

### Warnings and informations
Low:
 - SSL certificate host name mismatch *(1)*
 - Self-signed SSL certificate *(1)*

Internal warning:
 - Node should be a directory, detection error? *(1)*
 - Resource fetch failed *(11)*

Information note:
 - Incorrect or missing charset (low risk) *(12)*
 - Generic MIME used (low risk) *(5)*
 - Incorrect or missing MIME type (low risk) *(6)*
 - Hidden files / directories *(3)*
 - Server error triggered *(2)*
 - Resource not directly accessible *(2)*
 - New 404 signature seen *(1)*
 - New 'X-\*' header value seen *(3)*
 - New 'Server' header value seen *(1)*

### Pages and ressources
application/javascript (3)
 - https://127.0.0.1/js/webscripts_js_scripts.js
 - https://127.0.0.1/js/webscripts_script_js_scripts.js
 - https://127.0.0.1/web/auth/

image/jpeg (1)
 - https://127.0.0.1/static/webscripts_header.jpg

text/css (2)
 - https://127.0.0.1/static/webscripts_script_style.css
 - https://127.0.0.1/static/webscripts_style.css

text/html (1)
 - https://127.0.0.1/

text/plain (2)
 - https://127.0.0.1/
 - https://127.0.0.1/js/

## WhatWeb

```bash
whatweb -a 3 127.0.0.1
```

```text
http://127.0.0.1 [301 Moved Permanently] Country[RESERVED][ZZ], HTTPServer[nginx/1.18.0], IP[127.0.0.1], RedirectLocation[https://127.0.0.1/], Title[301 Moved Permanently], nginx[1.18.0]                                                                                                                                
https://127.0.0.1/ [302 Found] Country[RESERVED][ZZ], HTTPServer[nginx/1.18.0], IP[127.0.0.1], RedirectLocation[/web/auth/], Strict-Transport-Security[max-age=63072000; includeSubDomains; preload], UncommonHeaders[content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy], X-Frame-Options[deny], X-XSS-Protection[1; mode=block], nginx[1.18.0]
https://127.0.0.1/web/auth/ [200 OK] Country[RESERVED][ZZ], HTML5, HTTPServer[nginx/1.18.0], IP[127.0.0.1], Script[text/javascript], Strict-Transport-Security[max-age=63072000; includeSubDomains; preload], Title[/auth/ of WebScripts Server], UncommonHeaders[content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy], X-Frame-Options[deny], X-XSS-Protection[1; mode=block], nginx[1.18.0]
```

## Test RCE (Remote Code Execution) on /API/

```text
[!] Start tests RCE (Remote Code Execution)... 
[+] Injection: [';', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |cat /etc/passwd
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&cat /etc/passwd
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\n', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: 
cat /etc/passwd
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', 'cat', ' ', '/etc/passwd', '&&']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&cat /etc/passwd&&
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', 'cat', ' ', '/etc/passwd', ';']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd;
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', 'cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |cat /etc/passwd|
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', 'cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd|
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\n', 'cat', ' ', '/etc/passwd', '\n']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: 
cat /etc/passwd

[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\\etc\\passwd']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: \etc\passwd
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: .|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['../../../../../../../bin/cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ../../../../../../../bin/cat /etc/passwd|
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['"', ';', 'system(cat /etc/passwd);']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ";system(cat /etc/passwd);
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['`cat /etc/passwd`']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: `cat /etc/passwd`
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', "system('cat /etc/passwd');"]
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |system('cat /etc/passwd');
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['perl', ' ', '-e"system(\'cat /etc/passwd\');"', "\n'"]
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: perl -e"system('cat /etc/passwd');"
'
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['/bin/cat', '/etc/passwd', '|', "'\n'"]
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: /bin/cat/etc/passwd|'
'
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['/bin/cat', '/etc/passwd', "|'"]
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: /bin/cat/etc/passwd|'
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['system("cat /etc/passwd")', ';', 'die']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: system("cat /etc/passwd");die
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['";cat /etc/passwd;echo "']
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ";cat /etc/passwd;echo "
[*] Response: {'stdout': '<table>\n</table>\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[!] End.
```

## Dirb

```bash
dirb https://127.0.0.1/web/ -u Admin:Admin
```

```text
-----------------
DIRB v2.22    
By The Dark Raver
-----------------

START_TIME: Thu Jul 22 13:49:35 2021
URL_BASE: https://127.0.0.1/web/
WORDLIST_FILES: /usr/share/dirb/wordlists/common.txt
AUTHORIZATION: Admin:Admin

-----------------

GENERATED WORDS: 4612                                                          

---- Scanning URL: https://127.0.0.1/web/ ----
                                                                                                                                                            
-----------------
END_TIME: Thu Jul 22 13:57:39 2021
DOWNLOADED: 4612 - FOUND: 0

```

## Nikto

```bash
nikto -o nikto.json -Format json -Tuning x -evasion 12345678AB -id Admin:Admin -C all -h https://kali/web/auth/
```

```text
- Nikto v2.1.6
---------------------------------------------------------------------------
+ Target IP:          127.0.1.1
+ Target Hostname:    kali
+ Target Port:        443
---------------------------------------------------------------------------
+ SSL Info:        Subject:  /C=EN/ST=Some-State/L=London/O=WebScripts/OU=WebScripts/CN=kali/emailAddress=webscripts@localhost
                   Ciphers:  ECDHE-RSA-AES256-GCM-SHA384
                   Issuer:   /C=EN/ST=Some-State/L=London/O=WebScripts/OU=WebScripts/CN=kali/emailAddress=webscripts@localhost
+ Using Encoding:     Random URI encoding (non-UTF8)
+ Using Encoding:     Directory self-reference (/./)
+ Using Encoding:     Premature URL ending
+ Using Encoding:     Prepend long random string
+ Using Encoding:     Fake parameter
+ Using Encoding:     TAB as request spacer
+ Using Encoding:     Change the case of the URL
+ Using Encoding:     Use Windows directory separator (\)
+ Start Time:         2021-07-21 13:38:02 (GMT-4)
---------------------------------------------------------------------------
+ Server: nginx/1.18.0
+ The anti-clickjacking X-Frame-Options header is not present.
+ The X-XSS-Protection header is not defined. This header can hint to the user agent to protect against some forms of XSS
+ The site uses SSL and the Strict-Transport-Security HTTP header is not defined.
+ The site uses SSL and Expect-CT header is not present.
+ The X-Content-Type-Options header is not set. This could allow the user agent to render the content of the site in a different fashion to the MIME type
+ 26287 requests: 0 error(s) and 5 item(s) reported on remote host
+ End Time:           2021-07-21 13:52:39 (GMT-4) (877 seconds)
---------------------------------------------------------------------------
+ 1 host(s) tested
```

```json
[
    {
        "host": "127.0.0.1",
        "ip": "127.0.0.1",
        "port": "443",
        "banner": "nginx/1.18.0",
        "vulnerabilities": [
            {
                "id": "999957",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20wNtjxXhaVxGiv7/../../Elsz9PAmSSp.html%3FG88cFmwsstoSY7Kql=/..//.\\Vm%57%43%75%57Ms%4bLevvmwCuWMS%6bLe%76v%6d%57%63%75%77m%73k%6c%65V%76M%77%63%75%77m%53k%4ceVV%4dW%63%75%77%6d%53%4b%4cE%56%56%4dWC%75wmS%6b%4cev%76%6d%57%43%55wm%73%6bL%45%76VmWCUW%6dSKLEvV%4d%77cu%57%6d%53Kl%65%56vm%57c%55%77%4dS%4b%4cE%76%56%6dW%43%55%57%6dsK%4ce%76vMw%63%75wM%53K%6cE%76%56%4d%57cuw%4d%73k%4c%65%56V%4d%77%43UWM%53%4b%4ce%76%56MWCU%57mS%4b%4cE%56v%4d%57%43UW%6d%73KLE%76%56%4d%77%63%55w%6d%53k%6c%65V%76%6dW%63%75w%4d%53%6b%4ce%76%56M%77cU%77%6dS%4bLe%56Vm%57%63U%57m%73%6bl%45%76%76%6dw%43uw%4dsklEvVm%77C%55%77m%53%6bLevV%6d%57%63%75%57%6dsklE%56%76%4d%77%63u%77%6dS%6b%6c%65%56VmWC%55%77%4dsK%6c%65vVm%77%63u%77m%73k%4cE%76%76m%77C%55%57msk%4c%65v%56%4d%57%43%55%77m%73%6blEv%56mWc%55wm%73%6ble%56v%4d%77%63uw%4d%53%6bLE%56%56%6d%57C%55w%4dS%4bleV%76Mw%43%75%77ms%6blEVV%4dWCUWm%73kleV%76M%77cuWM%73%6b%4cev%76%4dwC%75%57%4dsKle%76V%4d%57CuW%4d%73kL%45v%76mwCUWmS%4bL%45%76%56%4d%77cUWMS%6b%4ceV%76mwc%55W%4d%53k%4cEvV%4dw%63%75%57m%73K%4c%45%76%56%4d%77%63u%77%6d%53kL%65vv%6dw%43uwm%73k%4ceVvm%57%63%55w%6d%53k%4c%65%76\\.%5c.%2e%5c.\\wEB\\%2e%5c%41%75t%48\\./",
                "msg": "The anti-clickjacking X-Frame-Options header is not present."
            },
            {
                "id": "999102",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20wNtjxXhaVxGiv7/../../Elsz9PAmSSp.html%3FG88cFmwsstoSY7Kql=/..//.\\Vm%57%43%75%57Ms%4bLevvmwCuWMS%6bLe%76v%6d%57%63%75%77m%73k%6c%65V%76M%77%63%75%77m%53k%4ceVV%4dW%63%75%77%6d%53%4b%4cE%56%56%4dWC%75wmS%6b%4cev%76%6d%57%43%55wm%73%6bL%45%76VmWCUW%6dSKLEvV%4d%77cu%57%6d%53Kl%65%56vm%57c%55%77%4dS%4b%4cE%76%56%6dW%43%55%57%6dsK%4ce%76vMw%63%75wM%53K%6cE%76%56%4d%57cuw%4d%73k%4c%65%56V%4d%77%43UWM%53%4b%4ce%76%56MWCU%57mS%4b%4cE%56v%4d%57%43UW%6d%73KLE%76%56%4d%77%63%55w%6d%53k%6c%65V%76%6dW%63%75w%4d%53%6b%4ce%76%56M%77cU%77%6dS%4bLe%56Vm%57%63U%57m%73%6bl%45%76%76%6dw%43uw%4dsklEvVm%77C%55%77m%53%6bLevV%6d%57%63%75%57%6dsklE%56%76%4d%77%63u%77%6dS%6b%6c%65%56VmWC%55%77%4dsK%6c%65vVm%77%63u%77m%73k%4cE%76%76m%77C%55%57msk%4c%65v%56%4d%57%43%55%77m%73%6blEv%56mWc%55wm%73%6ble%56v%4d%77%63uw%4d%53%6bLE%56%56%6d%57C%55w%4dS%4bleV%76Mw%43%75%77ms%6blEVV%4dWCUWm%73kleV%76M%77cuWM%73%6b%4cev%76%4dwC%75%57%4dsKle%76V%4d%57CuW%4d%73kL%45v%76mwCUWmS%4bL%45%76%56%4d%77cUWMS%6b%4ceV%76mwc%55W%4d%53k%4cEvV%4dw%63%75%57m%73K%4c%45%76%56%4d%77%63u%77%6d%53kL%65vv%6dw%43uwm%73k%4ceVvm%57%63%55w%6d%53k%4c%65%76\\.%5c.%2e%5c.\\wEB\\%2e%5c%41%75t%48\\./",
                "msg": "The X-XSS-Protection header is not defined. This header can hint to the user agent to protect against some forms of XSS"
            },
            {
                "id": "999970",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20wNtjxXhaVxGiv7/../../Elsz9PAmSSp.html%3FG88cFmwsstoSY7Kql=/..//.\\Vm%57%43%75%57Ms%4bLevvmwCuWMS%6bLe%76v%6d%57%63%75%77m%73k%6c%65V%76M%77%63%75%77m%53k%4ceVV%4dW%63%75%77%6d%53%4b%4cE%56%56%4dWC%75wmS%6b%4cev%76%6d%57%43%55wm%73%6bL%45%76VmWCUW%6dSKLEvV%4d%77cu%57%6d%53Kl%65%56vm%57c%55%77%4dS%4b%4cE%76%56%6dW%43%55%57%6dsK%4ce%76vMw%63%75wM%53K%6cE%76%56%4d%57cuw%4d%73k%4c%65%56V%4d%77%43UWM%53%4b%4ce%76%56MWCU%57mS%4b%4cE%56v%4d%57%43UW%6d%73KLE%76%56%4d%77%63%55w%6d%53k%6c%65V%76%6dW%63%75w%4d%53%6b%4ce%76%56M%77cU%77%6dS%4bLe%56Vm%57%63U%57m%73%6bl%45%76%76%6dw%43uw%4dsklEvVm%77C%55%77m%53%6bLevV%6d%57%63%75%57%6dsklE%56%76%4d%77%63u%77%6dS%6b%6c%65%56VmWC%55%77%4dsK%6c%65vVm%77%63u%77m%73k%4cE%76%76m%77C%55%57msk%4c%65v%56%4d%57%43%55%77m%73%6blEv%56mWc%55wm%73%6ble%56v%4d%77%63uw%4d%53%6bLE%56%56%6d%57C%55w%4dS%4bleV%76Mw%43%75%77ms%6blEVV%4dWCUWm%73kleV%76M%77cuWM%73%6b%4cev%76%4dwC%75%57%4dsKle%76V%4d%57CuW%4d%73kL%45v%76mwCUWmS%4bL%45%76%56%4d%77cUWMS%6b%4ceV%76mwc%55W%4d%53k%4cEvV%4dw%63%75%57m%73K%4c%45%76%56%4d%77%63u%77%6d%53kL%65vv%6dw%43uwm%73k%4ceVvm%57%63%55w%6d%53k%4c%65%76\\.%5c.%2e%5c.\\wEB\\%2e%5c%41%75t%48\\./",
                "msg": "The site uses SSL and the Strict-Transport-Security HTTP header is not defined."
            },
            {
                "id": "999955",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20wNtjxXhaVxGiv7/../../Elsz9PAmSSp.html%3FG88cFmwsstoSY7Kql=/..//.\\Vm%57%43%75%57Ms%4bLevvmwCuWMS%6bLe%76v%6d%57%63%75%77m%73k%6c%65V%76M%77%63%75%77m%53k%4ceVV%4dW%63%75%77%6d%53%4b%4cE%56%56%4dWC%75wmS%6b%4cev%76%6d%57%43%55wm%73%6bL%45%76VmWCUW%6dSKLEvV%4d%77cu%57%6d%53Kl%65%56vm%57c%55%77%4dS%4b%4cE%76%56%6dW%43%55%57%6dsK%4ce%76vMw%63%75wM%53K%6cE%76%56%4d%57cuw%4d%73k%4c%65%56V%4d%77%43UWM%53%4b%4ce%76%56MWCU%57mS%4b%4cE%56v%4d%57%43UW%6d%73KLE%76%56%4d%77%63%55w%6d%53k%6c%65V%76%6dW%63%75w%4d%53%6b%4ce%76%56M%77cU%77%6dS%4bLe%56Vm%57%63U%57m%73%6bl%45%76%76%6dw%43uw%4dsklEvVm%77C%55%77m%53%6bLevV%6d%57%63%75%57%6dsklE%56%76%4d%77%63u%77%6dS%6b%6c%65%56VmWC%55%77%4dsK%6c%65vVm%77%63u%77m%73k%4cE%76%76m%77C%55%57msk%4c%65v%56%4d%57%43%55%77m%73%6blEv%56mWc%55wm%73%6ble%56v%4d%77%63uw%4d%53%6bLE%56%56%6d%57C%55w%4dS%4bleV%76Mw%43%75%77ms%6blEVV%4dWCUWm%73kleV%76M%77cuWM%73%6b%4cev%76%4dwC%75%57%4dsKle%76V%4d%57CuW%4d%73kL%45v%76mwCUWmS%4bL%45%76%56%4d%77cUWMS%6b%4ceV%76mwc%55W%4d%53k%4cEvV%4dw%63%75%57m%73K%4c%45%76%56%4d%77%63u%77%6d%53kL%65vv%6dw%43uwm%73k%4ceVvm%57%63%55w%6d%53k%4c%65%76\\.%5c.%2e%5c.\\wEB\\%2e%5c%41%75t%48\\./",
                "msg": "The site uses SSL and Expect-CT header is not present."
            },
            {
                "id": "999103",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20wNtjxXhaVxGiv7/../../Elsz9PAmSSp.html%3FG88cFmwsstoSY7Kql=/..//.\\Vm%57%43%75%57Ms%4bLevvmwCuWMS%6bLe%76v%6d%57%63%75%77m%73k%6c%65V%76M%77%63%75%77m%53k%4ceVV%4dW%63%75%77%6d%53%4b%4cE%56%56%4dWC%75wmS%6b%4cev%76%6d%57%43%55wm%73%6bL%45%76VmWCUW%6dSKLEvV%4d%77cu%57%6d%53Kl%65%56vm%57c%55%77%4dS%4b%4cE%76%56%6dW%43%55%57%6dsK%4ce%76vMw%63%75wM%53K%6cE%76%56%4d%57cuw%4d%73k%4c%65%56V%4d%77%43UWM%53%4b%4ce%76%56MWCU%57mS%4b%4cE%56v%4d%57%43UW%6d%73KLE%76%56%4d%77%63%55w%6d%53k%6c%65V%76%6dW%63%75w%4d%53%6b%4ce%76%56M%77cU%77%6dS%4bLe%56Vm%57%63U%57m%73%6bl%45%76%76%6dw%43uw%4dsklEvVm%77C%55%77m%53%6bLevV%6d%57%63%75%57%6dsklE%56%76%4d%77%63u%77%6dS%6b%6c%65%56VmWC%55%77%4dsK%6c%65vVm%77%63u%77m%73k%4cE%76%76m%77C%55%57msk%4c%65v%56%4d%57%43%55%77m%73%6blEv%56mWc%55wm%73%6ble%56v%4d%77%63uw%4d%53%6bLE%56%56%6d%57C%55w%4dS%4bleV%76Mw%43%75%77ms%6blEVV%4dWCUWm%73kleV%76M%77cuWM%73%6b%4cev%76%4dwC%75%57%4dsKle%76V%4d%57CuW%4d%73kL%45v%76mwCUWmS%4bL%45%76%56%4d%77cUWMS%6b%4ceV%76mwc%55W%4d%53k%4cEvV%4dw%63%75%57m%73K%4c%45%76%56%4d%77%63u%77%6d%53kL%65vv%6dw%43uwm%73k%4ceVvm%57%63%55w%6d%53k%4c%65%76\\.%5c.%2e%5c.\\wEB\\%2e%5c%41%75t%48\\./",
                "msg": "The X-Content-Type-Options header is not set. This could allow the user agent to render the content of the site in a different fashion to the MIME type"
            },
            {
                "id": "999993",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/",
                "msg": "Hostname '127.0.0.1' does not match certificate's names: kali"
            }
        ]
    },
    {
        "host": "127.0.0.1",
        "ip": "127.0.0.1",
        "port": "443",
        "banner": "nginx/1.18.0",
        "vulnerabilities": [
            {
                "id": "999957",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20flUaEydiPiUfD1xfn/../../FslHaXgw1nO.html%3FGFMRwyfBdiZ2lbSkE6i=/..//%2e%5cK%52%32%48%75K%31T1%772%39%6b%61%38F%30%43Kr2%68Uk1%541W%32%39kA8f0%63%6b%52%32%48%55%6b1%741w29KA8%460%63%6br%32HU%4b1T1%5729KA%38F%30%43%6bR%32Huk%31%54%31W2%39Ka8f0%43k%722%48u%4b%31%741%772%39K%41%38%660ck%722h%55k1%741w29%4ba8%66%30C%4b%722%48u%6b%31t1W%329%6b%618F%30%43kr2%48Uk1T1W%32%39%6ba8F0%43KR2hU%4b%31%541%57%329k%418%460CKR2%68%55K%31%54%31w2%39%4b%618%46%30%43kR%32h%55%6b1%741%7729%4bA%38%66%30%43kR%32%68%55k%31T1%57%329K%618F0cK%72%32h%75%4b1%54%31%572%39%6b%41%38f%30%43K%522hUK%31t1%7729%4ba%38%460C%4b%52%32%68uk%31%74%31%57%329%4bA8%460CK%522h%75%4b1%741%572%39ka%38%460C%6br%32%48%55k1%74%31w29%4b%618%460C%6br2Hu%4b%31t%31%572%39kA%38%46%30Ck%522h%55K%31T1%5729%4b%41%38f%30c%4bR2%48%75%4b1%74%31W2%39%6b%41%38F%30%43%6b%72%32hU%4b%31T%31W%32%39KA%38%46%30c%6br%32h%55K1T1w2%39%6b%418%460%43%4b%72%32hU%6b1T%31%5729K%41%38%46%30c%4br%32%48%75%6b%31T1w29KA%38%46%30%63kr%32h%75K%31%74%31%77%329%6b%61%38F0%43%6bR2H%75k1t1w2%39KA%38%46%30%43%6b%72%32%68u%4b%31%741w%329%6b%418%660%63%6b%52%32hU%4b1%741%5729%6b%41%38%46%30C%5c%2e\\..\\%2e\\%57EB\\%2e%5c%61%75%74h\\%2e%2f",
                "msg": "The anti-clickjacking X-Frame-Options header is not present."
            },
            {
                "id": "999102",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20flUaEydiPiUfD1xfn/../../FslHaXgw1nO.html%3FGFMRwyfBdiZ2lbSkE6i=/..//%2e%5cK%52%32%48%75K%31T1%772%39%6b%61%38F%30%43Kr2%68Uk1%541W%32%39kA8f0%63%6b%52%32%48%55%6b1%741w29KA8%460%63%6br%32HU%4b1T1%5729KA%38F%30%43%6bR%32Huk%31%54%31W2%39Ka8f0%43k%722%48u%4b%31%741%772%39K%41%38%660ck%722h%55k1%741w29%4ba8%66%30C%4b%722%48u%6b%31t1W%329%6b%618F%30%43kr2%48Uk1T1W%32%39%6ba8F0%43KR2hU%4b%31%541%57%329k%418%460CKR2%68%55K%31%54%31w2%39%4b%618%46%30%43kR%32h%55%6b1%741%7729%4bA%38%66%30%43kR%32%68%55k%31T1%57%329K%618F0cK%72%32h%75%4b1%54%31%572%39%6b%41%38f%30%43K%522hUK%31t1%7729%4ba%38%460C%4b%52%32%68uk%31%74%31%57%329%4bA8%460CK%522h%75%4b1%741%572%39ka%38%460C%6br%32%48%55k1%74%31w29%4b%618%460C%6br2Hu%4b%31t%31%572%39kA%38%46%30Ck%522h%55K%31T1%5729%4b%41%38f%30c%4bR2%48%75%4b1%74%31W2%39%6b%41%38F%30%43%6b%72%32hU%4b%31T%31W%32%39KA%38%46%30c%6br%32h%55K1T1w2%39%6b%418%460%43%4b%72%32hU%6b1T%31%5729K%41%38%46%30c%4br%32%48%75%6b%31T1w29KA%38%46%30%63kr%32h%75K%31%74%31%77%329%6b%61%38F0%43%6bR2H%75k1t1w2%39KA%38%46%30%43%6b%72%32%68u%4b%31%741w%329%6b%418%660%63%6b%52%32hU%4b1%741%5729%6b%41%38%46%30C%5c%2e\\..\\%2e\\%57EB\\%2e%5c%61%75%74h\\%2e%2f",
                "msg": "The X-XSS-Protection header is not defined. This header can hint to the user agent to protect against some forms of XSS"
            },
            {
                "id": "999970",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20flUaEydiPiUfD1xfn/../../FslHaXgw1nO.html%3FGFMRwyfBdiZ2lbSkE6i=/..//%2e%5cK%52%32%48%75K%31T1%772%39%6b%61%38F%30%43Kr2%68Uk1%541W%32%39kA8f0%63%6b%52%32%48%55%6b1%741w29KA8%460%63%6br%32HU%4b1T1%5729KA%38F%30%43%6bR%32Huk%31%54%31W2%39Ka8f0%43k%722%48u%4b%31%741%772%39K%41%38%660ck%722h%55k1%741w29%4ba8%66%30C%4b%722%48u%6b%31t1W%329%6b%618F%30%43kr2%48Uk1T1W%32%39%6ba8F0%43KR2hU%4b%31%541%57%329k%418%460CKR2%68%55K%31%54%31w2%39%4b%618%46%30%43kR%32h%55%6b1%741%7729%4bA%38%66%30%43kR%32%68%55k%31T1%57%329K%618F0cK%72%32h%75%4b1%54%31%572%39%6b%41%38f%30%43K%522hUK%31t1%7729%4ba%38%460C%4b%52%32%68uk%31%74%31%57%329%4bA8%460CK%522h%75%4b1%741%572%39ka%38%460C%6br%32%48%55k1%74%31w29%4b%618%460C%6br2Hu%4b%31t%31%572%39kA%38%46%30Ck%522h%55K%31T1%5729%4b%41%38f%30c%4bR2%48%75%4b1%74%31W2%39%6b%41%38F%30%43%6b%72%32hU%4b%31T%31W%32%39KA%38%46%30c%6br%32h%55K1T1w2%39%6b%418%460%43%4b%72%32hU%6b1T%31%5729K%41%38%46%30c%4br%32%48%75%6b%31T1w29KA%38%46%30%63kr%32h%75K%31%74%31%77%329%6b%61%38F0%43%6bR2H%75k1t1w2%39KA%38%46%30%43%6b%72%32%68u%4b%31%741w%329%6b%418%660%63%6b%52%32hU%4b1%741%5729%6b%41%38%46%30C%5c%2e\\..\\%2e\\%57EB\\%2e%5c%61%75%74h\\%2e%2f",
                "msg": "The site uses SSL and the Strict-Transport-Security HTTP header is not defined."
            },
            {
                "id": "999955",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20flUaEydiPiUfD1xfn/../../FslHaXgw1nO.html%3FGFMRwyfBdiZ2lbSkE6i=/..//%2e%5cK%52%32%48%75K%31T1%772%39%6b%61%38F%30%43Kr2%68Uk1%541W%32%39kA8f0%63%6b%52%32%48%55%6b1%741w29KA8%460%63%6br%32HU%4b1T1%5729KA%38F%30%43%6bR%32Huk%31%54%31W2%39Ka8f0%43k%722%48u%4b%31%741%772%39K%41%38%660ck%722h%55k1%741w29%4ba8%66%30C%4b%722%48u%6b%31t1W%329%6b%618F%30%43kr2%48Uk1T1W%32%39%6ba8F0%43KR2hU%4b%31%541%57%329k%418%460CKR2%68%55K%31%54%31w2%39%4b%618%46%30%43kR%32h%55%6b1%741%7729%4bA%38%66%30%43kR%32%68%55k%31T1%57%329K%618F0cK%72%32h%75%4b1%54%31%572%39%6b%41%38f%30%43K%522hUK%31t1%7729%4ba%38%460C%4b%52%32%68uk%31%74%31%57%329%4bA8%460CK%522h%75%4b1%741%572%39ka%38%460C%6br%32%48%55k1%74%31w29%4b%618%460C%6br2Hu%4b%31t%31%572%39kA%38%46%30Ck%522h%55K%31T1%5729%4b%41%38f%30c%4bR2%48%75%4b1%74%31W2%39%6b%41%38F%30%43%6b%72%32hU%4b%31T%31W%32%39KA%38%46%30c%6br%32h%55K1T1w2%39%6b%418%460%43%4b%72%32hU%6b1T%31%5729K%41%38%46%30c%4br%32%48%75%6b%31T1w29KA%38%46%30%63kr%32h%75K%31%74%31%77%329%6b%61%38F0%43%6bR2H%75k1t1w2%39KA%38%46%30%43%6b%72%32%68u%4b%31%741w%329%6b%418%660%63%6b%52%32hU%4b1%741%5729%6b%41%38%46%30C%5c%2e\\..\\%2e\\%57EB\\%2e%5c%61%75%74h\\%2e%2f",
                "msg": "The site uses SSL and Expect-CT header is not present."
            },
            {
                "id": "999103",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20flUaEydiPiUfD1xfn/../../FslHaXgw1nO.html%3FGFMRwyfBdiZ2lbSkE6i=/..//%2e%5cK%52%32%48%75K%31T1%772%39%6b%61%38F%30%43Kr2%68Uk1%541W%32%39kA8f0%63%6b%52%32%48%55%6b1%741w29KA8%460%63%6br%32HU%4b1T1%5729KA%38F%30%43%6bR%32Huk%31%54%31W2%39Ka8f0%43k%722%48u%4b%31%741%772%39K%41%38%660ck%722h%55k1%741w29%4ba8%66%30C%4b%722%48u%6b%31t1W%329%6b%618F%30%43kr2%48Uk1T1W%32%39%6ba8F0%43KR2hU%4b%31%541%57%329k%418%460CKR2%68%55K%31%54%31w2%39%4b%618%46%30%43kR%32h%55%6b1%741%7729%4bA%38%66%30%43kR%32%68%55k%31T1%57%329K%618F0cK%72%32h%75%4b1%54%31%572%39%6b%41%38f%30%43K%522hUK%31t1%7729%4ba%38%460C%4b%52%32%68uk%31%74%31%57%329%4bA8%460CK%522h%75%4b1%741%572%39ka%38%460C%6br%32%48%55k1%74%31w29%4b%618%460C%6br2Hu%4b%31t%31%572%39kA%38%46%30Ck%522h%55K%31T1%5729%4b%41%38f%30c%4bR2%48%75%4b1%74%31W2%39%6b%41%38F%30%43%6b%72%32hU%4b%31T%31W%32%39KA%38%46%30c%6br%32h%55K1T1w2%39%6b%418%460%43%4b%72%32hU%6b1T%31%5729K%41%38%46%30c%4br%32%48%75%6b%31T1w29KA%38%46%30%63kr%32h%75K%31%74%31%77%329%6b%61%38F0%43%6bR2H%75k1t1w2%39KA%38%46%30%43%6b%72%32%68u%4b%31%741w%329%6b%418%660%63%6b%52%32hU%4b1%741%5729%6b%41%38%46%30C%5c%2e\\..\\%2e\\%57EB\\%2e%5c%61%75%74h\\%2e%2f",
                "msg": "The X-Content-Type-Options header is not set. This could allow the user agent to render the content of the site in a different fashion to the MIME type"
            },
            {
                "id": "999993",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/",
                "msg": "Hostname '127.0.0.1' does not match certificate's names: kali"
            }
        ]
    },
    {
        "host": "127.0.0.1",
        "ip": "127.0.0.1",
        "port": "443",
        "banner": "nginx/1.18.0",
        "vulnerabilities": [
            {
                "id": "999957",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20VoDa9qlQCvxXFK/../../wPbZSnkCSBrln4gg.html%3FkGvcbkh1ckcu5NBPYb9=/../%2f%2e\\s%6c%66Cw%52L%63kNR%51%53%4c%66C%77%52Lc%4b%4e%52%71s%4c%66%43wR%4ccKNRqSLFcWrl%63%4bn%52qsl%46C%57rLC%6b%4erQs%4cFC%57%52%6c%63k%6erq%53l%66%43w%72L%43%4b%6e%72q%53lFC%77%72%6cc%6b%4e%52%51%73%4c%46%43w%52L%43%6b%4eRq%73%6cF%63%77R%6c%43KNrQsL%66%43wR%6cckn%72%71%53%6cFCw%52%6c%63%4bnr%51slf%63w%72%6cc%6bNrQ%73L%46%63%57R%6cCk%4er%71%73%4cFCWrLC%6bN%72QsLFcWr%6c%43%6b%6e%72qS%4c%46c%77%52LC%4bNR%51%53lFC%77%52lckn%52q%73l%66C%77%72%4ccKN%72q%73L%66c%77%72%4c%63%4b%6e%52%51s%6cfc%57r%6c%43%4bnr%71SL%46%63%77rL%43%6b%6e%72%71%73l%66%43W%52%4c%43%4bn%72qs%4cFCWrL%43kNr%71%73%4cF%43w%72lCk%6e%52%71SLF%43%77%72LC%4bn%52QsLF%63Wr%4c%43KnR%71s%6c%66C%57rlCKNRQsL%66%63%57%52%6cCKnr%71S%4c%66%63%57%72Lc%4bnRQ%53%6c%66C%77r%6cCk%4e%72%51SLF%43W%52%6ccK%4e%52QS%6cf%63%77%72lc%6b%6er%51s%6c%66%43W%52LcK%6e%52Q%73%4cF%43wRl%43kNrqs%6cFc%77r%6c%63kn%52%71%53LFC%77R%6cC%4b%4e%52%71%73lfC%77%72%6c%43%4b%6e%72%51%73%4cFc%77RLckn%52%71S%6cFC%77%52LCK%4erQ%73lf%63%77RL%63%4bNrQsl%46Cwr%4cckn%52%51%73LFCw%52lc%6b%6er%51%5c.\\%2e.%5c.\\%57E%62%5c%2e%5caU%54h\\./",
                "msg": "The anti-clickjacking X-Frame-Options header is not present."
            },
            {
                "id": "999102",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20VoDa9qlQCvxXFK/../../wPbZSnkCSBrln4gg.html%3FkGvcbkh1ckcu5NBPYb9=/../%2f%2e\\s%6c%66Cw%52L%63kNR%51%53%4c%66C%77%52Lc%4b%4e%52%71s%4c%66%43wR%4ccKNRqSLFcWrl%63%4bn%52qsl%46C%57rLC%6b%4erQs%4cFC%57%52%6c%63k%6erq%53l%66%43w%72L%43%4b%6e%72q%53lFC%77%72%6cc%6b%4e%52%51%73%4c%46%43w%52L%43%6b%4eRq%73%6cF%63%77R%6c%43KNrQsL%66%43wR%6cckn%72%71%53%6cFCw%52%6c%63%4bnr%51slf%63w%72%6cc%6bNrQ%73L%46%63%57R%6cCk%4er%71%73%4cFCWrLC%6bN%72QsLFcWr%6c%43%6b%6e%72qS%4c%46c%77%52LC%4bNR%51%53lFC%77%52lckn%52q%73l%66C%77%72%4ccKN%72q%73L%66c%77%72%4c%63%4b%6e%52%51s%6cfc%57r%6c%43%4bnr%71SL%46%63%77rL%43%6b%6e%72%71%73l%66%43W%52%4c%43%4bn%72qs%4cFCWrL%43kNr%71%73%4cF%43w%72lCk%6e%52%71SLF%43%77%72LC%4bn%52QsLF%63Wr%4c%43KnR%71s%6c%66C%57rlCKNRQsL%66%63%57%52%6cCKnr%71S%4c%66%63%57%72Lc%4bnRQ%53%6c%66C%77r%6cCk%4e%72%51SLF%43W%52%6ccK%4e%52QS%6cf%63%77%72lc%6b%6er%51s%6c%66%43W%52LcK%6e%52Q%73%4cF%43wRl%43kNrqs%6cFc%77r%6c%63kn%52%71%53LFC%77R%6cC%4b%4e%52%71%73lfC%77%72%6c%43%4b%6e%72%51%73%4cFc%77RLckn%52%71S%6cFC%77%52LCK%4erQ%73lf%63%77RL%63%4bNrQsl%46Cwr%4cckn%52%51%73LFCw%52lc%6b%6er%51%5c.\\%2e.%5c.\\%57E%62%5c%2e%5caU%54h\\./",
                "msg": "The X-XSS-Protection header is not defined. This header can hint to the user agent to protect against some forms of XSS"
            },
            {
                "id": "999970",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20VoDa9qlQCvxXFK/../../wPbZSnkCSBrln4gg.html%3FkGvcbkh1ckcu5NBPYb9=/../%2f%2e\\s%6c%66Cw%52L%63kNR%51%53%4c%66C%77%52Lc%4b%4e%52%71s%4c%66%43wR%4ccKNRqSLFcWrl%63%4bn%52qsl%46C%57rLC%6b%4erQs%4cFC%57%52%6c%63k%6erq%53l%66%43w%72L%43%4b%6e%72q%53lFC%77%72%6cc%6b%4e%52%51%73%4c%46%43w%52L%43%6b%4eRq%73%6cF%63%77R%6c%43KNrQsL%66%43wR%6cckn%72%71%53%6cFCw%52%6c%63%4bnr%51slf%63w%72%6cc%6bNrQ%73L%46%63%57R%6cCk%4er%71%73%4cFCWrLC%6bN%72QsLFcWr%6c%43%6b%6e%72qS%4c%46c%77%52LC%4bNR%51%53lFC%77%52lckn%52q%73l%66C%77%72%4ccKN%72q%73L%66c%77%72%4c%63%4b%6e%52%51s%6cfc%57r%6c%43%4bnr%71SL%46%63%77rL%43%6b%6e%72%71%73l%66%43W%52%4c%43%4bn%72qs%4cFCWrL%43kNr%71%73%4cF%43w%72lCk%6e%52%71SLF%43%77%72LC%4bn%52QsLF%63Wr%4c%43KnR%71s%6c%66C%57rlCKNRQsL%66%63%57%52%6cCKnr%71S%4c%66%63%57%72Lc%4bnRQ%53%6c%66C%77r%6cCk%4e%72%51SLF%43W%52%6ccK%4e%52QS%6cf%63%77%72lc%6b%6er%51s%6c%66%43W%52LcK%6e%52Q%73%4cF%43wRl%43kNrqs%6cFc%77r%6c%63kn%52%71%53LFC%77R%6cC%4b%4e%52%71%73lfC%77%72%6c%43%4b%6e%72%51%73%4cFc%77RLckn%52%71S%6cFC%77%52LCK%4erQ%73lf%63%77RL%63%4bNrQsl%46Cwr%4cckn%52%51%73LFCw%52lc%6b%6er%51%5c.\\%2e.%5c.\\%57E%62%5c%2e%5caU%54h\\./",
                "msg": "The site uses SSL and the Strict-Transport-Security HTTP header is not defined."
            },
            {
                "id": "999955",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20VoDa9qlQCvxXFK/../../wPbZSnkCSBrln4gg.html%3FkGvcbkh1ckcu5NBPYb9=/../%2f%2e\\s%6c%66Cw%52L%63kNR%51%53%4c%66C%77%52Lc%4b%4e%52%71s%4c%66%43wR%4ccKNRqSLFcWrl%63%4bn%52qsl%46C%57rLC%6b%4erQs%4cFC%57%52%6c%63k%6erq%53l%66%43w%72L%43%4b%6e%72q%53lFC%77%72%6cc%6b%4e%52%51%73%4c%46%43w%52L%43%6b%4eRq%73%6cF%63%77R%6c%43KNrQsL%66%43wR%6cckn%72%71%53%6cFCw%52%6c%63%4bnr%51slf%63w%72%6cc%6bNrQ%73L%46%63%57R%6cCk%4er%71%73%4cFCWrLC%6bN%72QsLFcWr%6c%43%6b%6e%72qS%4c%46c%77%52LC%4bNR%51%53lFC%77%52lckn%52q%73l%66C%77%72%4ccKN%72q%73L%66c%77%72%4c%63%4b%6e%52%51s%6cfc%57r%6c%43%4bnr%71SL%46%63%77rL%43%6b%6e%72%71%73l%66%43W%52%4c%43%4bn%72qs%4cFCWrL%43kNr%71%73%4cF%43w%72lCk%6e%52%71SLF%43%77%72LC%4bn%52QsLF%63Wr%4c%43KnR%71s%6c%66C%57rlCKNRQsL%66%63%57%52%6cCKnr%71S%4c%66%63%57%72Lc%4bnRQ%53%6c%66C%77r%6cCk%4e%72%51SLF%43W%52%6ccK%4e%52QS%6cf%63%77%72lc%6b%6er%51s%6c%66%43W%52LcK%6e%52Q%73%4cF%43wRl%43kNrqs%6cFc%77r%6c%63kn%52%71%53LFC%77R%6cC%4b%4e%52%71%73lfC%77%72%6c%43%4b%6e%72%51%73%4cFc%77RLckn%52%71S%6cFC%77%52LCK%4erQ%73lf%63%77RL%63%4bNrQsl%46Cwr%4cckn%52%51%73LFCw%52lc%6b%6er%51%5c.\\%2e.%5c.\\%57E%62%5c%2e%5caU%54h\\./",
                "msg": "The site uses SSL and Expect-CT header is not present."
            },
            {
                "id": "999103",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20VoDa9qlQCvxXFK/../../wPbZSnkCSBrln4gg.html%3FkGvcbkh1ckcu5NBPYb9=/../%2f%2e\\s%6c%66Cw%52L%63kNR%51%53%4c%66C%77%52Lc%4b%4e%52%71s%4c%66%43wR%4ccKNRqSLFcWrl%63%4bn%52qsl%46C%57rLC%6b%4erQs%4cFC%57%52%6c%63k%6erq%53l%66%43w%72L%43%4b%6e%72q%53lFC%77%72%6cc%6b%4e%52%51%73%4c%46%43w%52L%43%6b%4eRq%73%6cF%63%77R%6c%43KNrQsL%66%43wR%6cckn%72%71%53%6cFCw%52%6c%63%4bnr%51slf%63w%72%6cc%6bNrQ%73L%46%63%57R%6cCk%4er%71%73%4cFCWrLC%6bN%72QsLFcWr%6c%43%6b%6e%72qS%4c%46c%77%52LC%4bNR%51%53lFC%77%52lckn%52q%73l%66C%77%72%4ccKN%72q%73L%66c%77%72%4c%63%4b%6e%52%51s%6cfc%57r%6c%43%4bnr%71SL%46%63%77rL%43%6b%6e%72%71%73l%66%43W%52%4c%43%4bn%72qs%4cFCWrL%43kNr%71%73%4cF%43w%72lCk%6e%52%71SLF%43%77%72LC%4bn%52QsLF%63Wr%4c%43KnR%71s%6c%66C%57rlCKNRQsL%66%63%57%52%6cCKnr%71S%4c%66%63%57%72Lc%4bnRQ%53%6c%66C%77r%6cCk%4e%72%51SLF%43W%52%6ccK%4e%52QS%6cf%63%77%72lc%6b%6er%51s%6c%66%43W%52LcK%6e%52Q%73%4cF%43wRl%43kNrqs%6cFc%77r%6c%63kn%52%71%53LFC%77R%6cC%4b%4e%52%71%73lfC%77%72%6c%43%4b%6e%72%51%73%4cFc%77RLckn%52%71S%6cFC%77%52LCK%4erQ%73lf%63%77RL%63%4bNrQsl%46Cwr%4cckn%52%51%73LFCw%52lc%6b%6er%51%5c.\\%2e.%5c.\\%57E%62%5c%2e%5caU%54h\\./",
                "msg": "The X-Content-Type-Options header is not set. This could allow the user agent to render the content of the site in a different fashion to the MIME type"
            },
            {
                "id": "999993",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/",
                "msg": "Hostname '127.0.0.1' does not match certificate's names: kali"
            }
        ]
    },
    {
        "host": "127.0.0.1",
        "ip": "127.0.0.1",
        "port": "443",
        "banner": "nginx/1.18.0",
        "vulnerabilities": [
            {
                "id": "999957",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20XM2mtlNCOO38Du0YSkS/../../D16H3OUNbNs.html%3FgYBXUGJDkR=/..//.%5c%64%6eD%59%62%6261%48Xi%36D%6e%64%79bB%361%48x%49%36%64n%44YB%426%31Hx%69%36%44n%44YBb%36%31hXi6DND%79B%42%36%31HXi%36%64%6ed%79BB61%68%78%696D%6ed%59%62b%36%31%68%58%496%44%4e%44%59bB%361%48X%49%36%64%6eDyb%62%361hxI6%64N%44%59B%42%36%31hXI%36d%4e%44%59b%42%361hxi6%44n%44%79Bb%36%31%48x%69%36%64nDY%62%4261hXi%36%44NdYb%426%31hXi6dn%64%79%62B61HX%696%64ND%59%42b%36%31%48xI6%44nD%59b%426%31%68XI6DND%59%62B6%31%68%58%696%44N%44yBB%36%31%68%78%69%36%64nd%79%62%626%31%48%58i6%64%4e%64%59Bb%36%31%48%58%496dnD%79b%4261h%78I%36D%6e%44%59Bb%36%31%48%58i%36%64%6e%44%59b%62%361H%78i%36%64%4edY%62b61H%78%49%36DnDy%42%4261hX%496%64%6e%44%79%42b61h%78%496dnD%79%42%62%36%31h%58I%36dnD%79B%626%31Hxi6%64%4e%44yBB%36%31%48xi%36%44nD%79%42B61h%78I%36D%4ed%59%42%626%31%68X%49%36D%4e%44%59Bb%36%31%68x%496DN%64%59B%626%31hxI%36%44N%44%59%42%62%361Hx%49%36%44%4e%44Y%42b6%31%68%78%49%36%44%6ed%79BB%361%48XI%36d%4eDy%62%4261hX%49%36dN%44YBb%361%68x%496%64ndy%42B%36%31%68x%49%36%44N%64%59%42b61Hx%496dn%64Y%62b%36%31%68X%49%36dNdy%62%42%36%31HXI%36%5c.%5c%2e%2e\\.\\%57eb%5c.%5caUT%68\\./",
                "msg": "The anti-clickjacking X-Frame-Options header is not present."
            },
            {
                "id": "999102",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20XM2mtlNCOO38Du0YSkS/../../D16H3OUNbNs.html%3FgYBXUGJDkR=/..//.%5c%64%6eD%59%62%6261%48Xi%36D%6e%64%79bB%361%48x%49%36%64n%44YB%426%31Hx%69%36%44n%44YBb%36%31hXi6DND%79B%42%36%31HXi%36%64%6ed%79BB61%68%78%696D%6ed%59%62b%36%31%68%58%496%44%4e%44%59bB%361%48X%49%36%64%6eDyb%62%361hxI6%64N%44%59B%42%36%31hXI%36d%4e%44%59b%42%361hxi6%44n%44%79Bb%36%31%48x%69%36%64nDY%62%4261hXi%36%44NdYb%426%31hXi6dn%64%79%62B61HX%696%64ND%59%42b%36%31%48xI6%44nD%59b%426%31%68XI6DND%59%62B6%31%68%58%696%44N%44yBB%36%31%68%78%69%36%64nd%79%62%626%31%48%58i6%64%4e%64%59Bb%36%31%48%58%496dnD%79b%4261h%78I%36D%6e%44%59Bb%36%31%48%58i%36%64%6e%44%59b%62%361H%78i%36%64%4edY%62b61H%78%49%36DnDy%42%4261hX%496%64%6e%44%79%42b61h%78%496dnD%79%42%62%36%31h%58I%36dnD%79B%626%31Hxi6%64%4e%44yBB%36%31%48xi%36%44nD%79%42B61h%78I%36D%4ed%59%42%626%31%68X%49%36D%4e%44%59Bb%36%31%68x%496DN%64%59B%626%31hxI%36%44N%44%59%42%62%361Hx%49%36%44%4e%44Y%42b6%31%68%78%49%36%44%6ed%79BB%361%48XI%36d%4eDy%62%4261hX%49%36dN%44YBb%361%68x%496%64ndy%42B%36%31%68x%49%36%44N%64%59%42b61Hx%496dn%64Y%62b%36%31%68X%49%36dNdy%62%42%36%31HXI%36%5c.%5c%2e%2e\\.\\%57eb%5c.%5caUT%68\\./",
                "msg": "The X-XSS-Protection header is not defined. This header can hint to the user agent to protect against some forms of XSS"
            },
            {
                "id": "999970",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20XM2mtlNCOO38Du0YSkS/../../D16H3OUNbNs.html%3FgYBXUGJDkR=/..//.%5c%64%6eD%59%62%6261%48Xi%36D%6e%64%79bB%361%48x%49%36%64n%44YB%426%31Hx%69%36%44n%44YBb%36%31hXi6DND%79B%42%36%31HXi%36%64%6ed%79BB61%68%78%696D%6ed%59%62b%36%31%68%58%496%44%4e%44%59bB%361%48X%49%36%64%6eDyb%62%361hxI6%64N%44%59B%42%36%31hXI%36d%4e%44%59b%42%361hxi6%44n%44%79Bb%36%31%48x%69%36%64nDY%62%4261hXi%36%44NdYb%426%31hXi6dn%64%79%62B61HX%696%64ND%59%42b%36%31%48xI6%44nD%59b%426%31%68XI6DND%59%62B6%31%68%58%696%44N%44yBB%36%31%68%78%69%36%64nd%79%62%626%31%48%58i6%64%4e%64%59Bb%36%31%48%58%496dnD%79b%4261h%78I%36D%6e%44%59Bb%36%31%48%58i%36%64%6e%44%59b%62%361H%78i%36%64%4edY%62b61H%78%49%36DnDy%42%4261hX%496%64%6e%44%79%42b61h%78%496dnD%79%42%62%36%31h%58I%36dnD%79B%626%31Hxi6%64%4e%44yBB%36%31%48xi%36%44nD%79%42B61h%78I%36D%4ed%59%42%626%31%68X%49%36D%4e%44%59Bb%36%31%68x%496DN%64%59B%626%31hxI%36%44N%44%59%42%62%361Hx%49%36%44%4e%44Y%42b6%31%68%78%49%36%44%6ed%79BB%361%48XI%36d%4eDy%62%4261hX%49%36dN%44YBb%361%68x%496%64ndy%42B%36%31%68x%49%36%44N%64%59%42b61Hx%496dn%64Y%62b%36%31%68X%49%36dNdy%62%42%36%31HXI%36%5c.%5c%2e%2e\\.\\%57eb%5c.%5caUT%68\\./",
                "msg": "The site uses SSL and the Strict-Transport-Security HTTP header is not defined."
            },
            {
                "id": "999955",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20XM2mtlNCOO38Du0YSkS/../../D16H3OUNbNs.html%3FgYBXUGJDkR=/..//.%5c%64%6eD%59%62%6261%48Xi%36D%6e%64%79bB%361%48x%49%36%64n%44YB%426%31Hx%69%36%44n%44YBb%36%31hXi6DND%79B%42%36%31HXi%36%64%6ed%79BB61%68%78%696D%6ed%59%62b%36%31%68%58%496%44%4e%44%59bB%361%48X%49%36%64%6eDyb%62%361hxI6%64N%44%59B%42%36%31hXI%36d%4e%44%59b%42%361hxi6%44n%44%79Bb%36%31%48x%69%36%64nDY%62%4261hXi%36%44NdYb%426%31hXi6dn%64%79%62B61HX%696%64ND%59%42b%36%31%48xI6%44nD%59b%426%31%68XI6DND%59%62B6%31%68%58%696%44N%44yBB%36%31%68%78%69%36%64nd%79%62%626%31%48%58i6%64%4e%64%59Bb%36%31%48%58%496dnD%79b%4261h%78I%36D%6e%44%59Bb%36%31%48%58i%36%64%6e%44%59b%62%361H%78i%36%64%4edY%62b61H%78%49%36DnDy%42%4261hX%496%64%6e%44%79%42b61h%78%496dnD%79%42%62%36%31h%58I%36dnD%79B%626%31Hxi6%64%4e%44yBB%36%31%48xi%36%44nD%79%42B61h%78I%36D%4ed%59%42%626%31%68X%49%36D%4e%44%59Bb%36%31%68x%496DN%64%59B%626%31hxI%36%44N%44%59%42%62%361Hx%49%36%44%4e%44Y%42b6%31%68%78%49%36%44%6ed%79BB%361%48XI%36d%4eDy%62%4261hX%49%36dN%44YBb%361%68x%496%64ndy%42B%36%31%68x%49%36%44N%64%59%42b61Hx%496dn%64Y%62b%36%31%68X%49%36dNdy%62%42%36%31HXI%36%5c.%5c%2e%2e\\.\\%57eb%5c.%5caUT%68\\./",
                "msg": "The site uses SSL and Expect-CT header is not present."
            },
            {
                "id": "999103",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20XM2mtlNCOO38Du0YSkS/../../D16H3OUNbNs.html%3FgYBXUGJDkR=/..//.%5c%64%6eD%59%62%6261%48Xi%36D%6e%64%79bB%361%48x%49%36%64n%44YB%426%31Hx%69%36%44n%44YBb%36%31hXi6DND%79B%42%36%31HXi%36%64%6ed%79BB61%68%78%696D%6ed%59%62b%36%31%68%58%496%44%4e%44%59bB%361%48X%49%36%64%6eDyb%62%361hxI6%64N%44%59B%42%36%31hXI%36d%4e%44%59b%42%361hxi6%44n%44%79Bb%36%31%48x%69%36%64nDY%62%4261hXi%36%44NdYb%426%31hXi6dn%64%79%62B61HX%696%64ND%59%42b%36%31%48xI6%44nD%59b%426%31%68XI6DND%59%62B6%31%68%58%696%44N%44yBB%36%31%68%78%69%36%64nd%79%62%626%31%48%58i6%64%4e%64%59Bb%36%31%48%58%496dnD%79b%4261h%78I%36D%6e%44%59Bb%36%31%48%58i%36%64%6e%44%59b%62%361H%78i%36%64%4edY%62b61H%78%49%36DnDy%42%4261hX%496%64%6e%44%79%42b61h%78%496dnD%79%42%62%36%31h%58I%36dnD%79B%626%31Hxi6%64%4e%44yBB%36%31%48xi%36%44nD%79%42B61h%78I%36D%4ed%59%42%626%31%68X%49%36D%4e%44%59Bb%36%31%68x%496DN%64%59B%626%31hxI%36%44N%44%59%42%62%361Hx%49%36%44%4e%44Y%42b6%31%68%78%49%36%44%6ed%79BB%361%48XI%36d%4eDy%62%4261hX%49%36dN%44YBb%361%68x%496%64ndy%42B%36%31%68x%49%36%44N%64%59%42b61Hx%496dn%64Y%62b%36%31%68X%49%36dNdy%62%42%36%31HXI%36%5c.%5c%2e%2e\\.\\%57eb%5c.%5caUT%68\\./",
                "msg": "The X-Content-Type-Options header is not set. This could allow the user agent to render the content of the site in a different fashion to the MIME type"
            },
            {
                "id": "999993",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/",
                "msg": "Hostname '127.0.0.1' does not match certificate's names: kali"
            }
        ]
    },
    {
        "host": "kali",
        "ip": "127.0.1.1",
        "port": "443",
        "banner": "nginx/1.18.0",
        "vulnerabilities": [
            {
                "id": "999957",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20BbxxWTIFgAe2tLRMKo/../../pJlJOIFzmdm7u5i.html%3FBacraZZVH0sWx=/..//%2e%5c%454%587%7aITktv%39b%6c%41%4cU%74%6a6%65%34x%37ZiTk%74v9%42%4c%61%4c%55%54%4a%36%454%78%37%7a%69T%4b%54v9b%6cAlUT%4a6e4X%37%5a%49%74k%54V%39%62%6cALU%74%6a%36E%34x%37%7aITk%54V%39%42la%6c%55%54%4a6%654X%37%5a%49%74%6b%54%569B%4cA%6cut%6a6%65%34X%37%7a%49T%4bt%569BL%41%6c%75%54%6a6E4%58%37z%49%54K%54v%39bL%61L%55%74%6a%36%654%587%5aIt%4b%74%56%39B%4ca%4cU%54j%36e4X7%5aIt%6b%54V%39%62%6cAL%75tJ6%454%58%37z%69tkTv9%62%4cal%75%74%6a6E4%787Z%49T%4bt%569b%4ca%4c%55%74%4a%36e4%78%37z%49%74%4b%74v9%62%4caL%55tJ6%65%34%587Zi%54%4b%74v%39%42%4cA%6c%55%74%4a%36%654X%37zI%74K%74v%39%62LAl%75%54j%36%454%587%5aIt%6b%74%56%39%42%4ca%6cu%54%4a%36%654X%37zITKTv%39%62%6c%41L%75Tj%36E4%587z%69tKT%769b%6cAlu%54J%36%45%34%78%37%7a%49%54ktV%39%42La%6c%75Tj6%45%34%78%37%7aIT%4b%54%769%62%4c%61LUtJ%36e%34%787Z%69%74%4btv9%62%4c%61lutJ%36e%34x%37%5aI%54%6bT%769B%4ca%4cUtJ6E%34X7%5ai%54kt%569Bla%4c%55tj6e%34X7zi%54K%74%56%39%42La%6cUt%6a%36e%34%78%37%7a%49%74KT%56%39%62la%4cu%74%6a6e%34X7ZI%54%6bT%769%42LalutJ6%45%34%587ZI%74%4bTV%39%42%4c%61%4cu%54J6\\%2e\\%2e.\\%2e\\%57E%42%5c%2e%5c%61U%74%48%5c%2e/",
                "msg": "The anti-clickjacking X-Frame-Options header is not present."
            },
            {
                "id": "999102",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20BbxxWTIFgAe2tLRMKo/../../pJlJOIFzmdm7u5i.html%3FBacraZZVH0sWx=/..//%2e%5c%454%587%7aITktv%39b%6c%41%4cU%74%6a6%65%34x%37ZiTk%74v9%42%4c%61%4c%55%54%4a%36%454%78%37%7a%69T%4b%54v9b%6cAlUT%4a6e4X%37%5a%49%74k%54V%39%62%6cALU%74%6a%36E%34x%37%7aITk%54V%39%42la%6c%55%54%4a6%654X%37%5a%49%74%6b%54%569B%4cA%6cut%6a6%65%34X%37%7a%49T%4bt%569BL%41%6c%75%54%6a6E4%58%37z%49%54K%54v%39bL%61L%55%74%6a%36%654%587%5aIt%4b%74%56%39B%4ca%4cU%54j%36e4X7%5aIt%6b%54V%39%62%6cAL%75tJ6%454%58%37z%69tkTv9%62%4cal%75%74%6a6E4%787Z%49T%4bt%569b%4ca%4c%55%74%4a%36e4%78%37z%49%74%4b%74v9%62%4caL%55tJ6%65%34%587Zi%54%4b%74v%39%42%4cA%6c%55%74%4a%36%654X%37zI%74K%74v%39%62LAl%75%54j%36%454%587%5aIt%6b%74%56%39%42%4ca%6cu%54%4a%36%654X%37zITKTv%39%62%6c%41L%75Tj%36E4%587z%69tKT%769b%6cAlu%54J%36%45%34%78%37%7a%49%54ktV%39%42La%6c%75Tj6%45%34%78%37%7aIT%4b%54%769%62%4c%61LUtJ%36e%34%787Z%69%74%4btv9%62%4c%61lutJ%36e%34x%37%5aI%54%6bT%769B%4ca%4cUtJ6E%34X7%5ai%54kt%569Bla%4c%55tj6e%34X7zi%54K%74%56%39%42La%6cUt%6a%36e%34%78%37%7a%49%74KT%56%39%62la%4cu%74%6a6e%34X7ZI%54%6bT%769%42LalutJ6%45%34%587ZI%74%4bTV%39%42%4c%61%4cu%54J6\\%2e\\%2e.\\%2e\\%57E%42%5c%2e%5c%61U%74%48%5c%2e/",
                "msg": "The X-XSS-Protection header is not defined. This header can hint to the user agent to protect against some forms of XSS"
            },
            {
                "id": "999970",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20BbxxWTIFgAe2tLRMKo/../../pJlJOIFzmdm7u5i.html%3FBacraZZVH0sWx=/..//%2e%5c%454%587%7aITktv%39b%6c%41%4cU%74%6a6%65%34x%37ZiTk%74v9%42%4c%61%4c%55%54%4a%36%454%78%37%7a%69T%4b%54v9b%6cAlUT%4a6e4X%37%5a%49%74k%54V%39%62%6cALU%74%6a%36E%34x%37%7aITk%54V%39%42la%6c%55%54%4a6%654X%37%5a%49%74%6b%54%569B%4cA%6cut%6a6%65%34X%37%7a%49T%4bt%569BL%41%6c%75%54%6a6E4%58%37z%49%54K%54v%39bL%61L%55%74%6a%36%654%587%5aIt%4b%74%56%39B%4ca%4cU%54j%36e4X7%5aIt%6b%54V%39%62%6cAL%75tJ6%454%58%37z%69tkTv9%62%4cal%75%74%6a6E4%787Z%49T%4bt%569b%4ca%4c%55%74%4a%36e4%78%37z%49%74%4b%74v9%62%4caL%55tJ6%65%34%587Zi%54%4b%74v%39%42%4cA%6c%55%74%4a%36%654X%37zI%74K%74v%39%62LAl%75%54j%36%454%587%5aIt%6b%74%56%39%42%4ca%6cu%54%4a%36%654X%37zITKTv%39%62%6c%41L%75Tj%36E4%587z%69tKT%769b%6cAlu%54J%36%45%34%78%37%7a%49%54ktV%39%42La%6c%75Tj6%45%34%78%37%7aIT%4b%54%769%62%4c%61LUtJ%36e%34%787Z%69%74%4btv9%62%4c%61lutJ%36e%34x%37%5aI%54%6bT%769B%4ca%4cUtJ6E%34X7%5ai%54kt%569Bla%4c%55tj6e%34X7zi%54K%74%56%39%42La%6cUt%6a%36e%34%78%37%7a%49%74KT%56%39%62la%4cu%74%6a6e%34X7ZI%54%6bT%769%42LalutJ6%45%34%587ZI%74%4bTV%39%42%4c%61%4cu%54J6\\%2e\\%2e.\\%2e\\%57E%42%5c%2e%5c%61U%74%48%5c%2e/",
                "msg": "The site uses SSL and the Strict-Transport-Security HTTP header is not defined."
            },
            {
                "id": "999955",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20BbxxWTIFgAe2tLRMKo/../../pJlJOIFzmdm7u5i.html%3FBacraZZVH0sWx=/..//%2e%5c%454%587%7aITktv%39b%6c%41%4cU%74%6a6%65%34x%37ZiTk%74v9%42%4c%61%4c%55%54%4a%36%454%78%37%7a%69T%4b%54v9b%6cAlUT%4a6e4X%37%5a%49%74k%54V%39%62%6cALU%74%6a%36E%34x%37%7aITk%54V%39%42la%6c%55%54%4a6%654X%37%5a%49%74%6b%54%569B%4cA%6cut%6a6%65%34X%37%7a%49T%4bt%569BL%41%6c%75%54%6a6E4%58%37z%49%54K%54v%39bL%61L%55%74%6a%36%654%587%5aIt%4b%74%56%39B%4ca%4cU%54j%36e4X7%5aIt%6b%54V%39%62%6cAL%75tJ6%454%58%37z%69tkTv9%62%4cal%75%74%6a6E4%787Z%49T%4bt%569b%4ca%4c%55%74%4a%36e4%78%37z%49%74%4b%74v9%62%4caL%55tJ6%65%34%587Zi%54%4b%74v%39%42%4cA%6c%55%74%4a%36%654X%37zI%74K%74v%39%62LAl%75%54j%36%454%587%5aIt%6b%74%56%39%42%4ca%6cu%54%4a%36%654X%37zITKTv%39%62%6c%41L%75Tj%36E4%587z%69tKT%769b%6cAlu%54J%36%45%34%78%37%7a%49%54ktV%39%42La%6c%75Tj6%45%34%78%37%7aIT%4b%54%769%62%4c%61LUtJ%36e%34%787Z%69%74%4btv9%62%4c%61lutJ%36e%34x%37%5aI%54%6bT%769B%4ca%4cUtJ6E%34X7%5ai%54kt%569Bla%4c%55tj6e%34X7zi%54K%74%56%39%42La%6cUt%6a%36e%34%78%37%7a%49%74KT%56%39%62la%4cu%74%6a6e%34X7ZI%54%6bT%769%42LalutJ6%45%34%587ZI%74%4bTV%39%42%4c%61%4cu%54J6\\%2e\\%2e.\\%2e\\%57E%42%5c%2e%5c%61U%74%48%5c%2e/",
                "msg": "The site uses SSL and Expect-CT header is not present."
            },
            {
                "id": "999103",
                "OSVDB": "0",
                "method": "GET",
                "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20BbxxWTIFgAe2tLRMKo/../../pJlJOIFzmdm7u5i.html%3FBacraZZVH0sWx=/..//%2e%5c%454%587%7aITktv%39b%6c%41%4cU%74%6a6%65%34x%37ZiTk%74v9%42%4c%61%4c%55%54%4a%36%454%78%37%7a%69T%4b%54v9b%6cAlUT%4a6e4X%37%5a%49%74k%54V%39%62%6cALU%74%6a%36E%34x%37%7aITk%54V%39%42la%6c%55%54%4a6%654X%37%5a%49%74%6b%54%569B%4cA%6cut%6a6%65%34X%37%7a%49T%4bt%569BL%41%6c%75%54%6a6E4%58%37z%49%54K%54v%39bL%61L%55%74%6a%36%654%587%5aIt%4b%74%56%39B%4ca%4cU%54j%36e4X7%5aIt%6b%54V%39%62%6cAL%75tJ6%454%58%37z%69tkTv9%62%4cal%75%74%6a6E4%787Z%49T%4bt%569b%4ca%4c%55%74%4a%36e4%78%37z%49%74%4b%74v9%62%4caL%55tJ6%65%34%587Zi%54%4b%74v%39%42%4cA%6c%55%74%4a%36%654X%37zI%74K%74v%39%62LAl%75%54j%36%454%587%5aIt%6b%74%56%39%42%4ca%6cu%54%4a%36%654X%37zITKTv%39%62%6c%41L%75Tj%36E4%587z%69tKT%769b%6cAlu%54J%36%45%34%78%37%7a%49%54ktV%39%42La%6c%75Tj6%45%34%78%37%7aIT%4b%54%769%62%4c%61LUtJ%36e%34%787Z%69%74%4btv9%62%4c%61lutJ%36e%34x%37%5aI%54%6bT%769B%4ca%4cUtJ6E%34X7%5ai%54kt%569Bla%4c%55tj6e%34X7zi%54K%74%56%39%42La%6cUt%6a%36e%34%78%37%7a%49%74KT%56%39%62la%4cu%74%6a6e%34X7ZI%54%6bT%769%42LalutJ6%45%34%587ZI%74%4bTV%39%42%4c%61%4cu%54J6\\%2e\\%2e.\\%2e\\%57E%42%5c%2e%5c%61U%74%48%5c%2e/",
                "msg": "The X-Content-Type-Options header is not set. This could allow the user agent to render the content of the site in a different fashion to the MIME type"
            }
        ]
    }
]
```

## ZAP

```json
{
    "@version": "2.10.0",
    "@generated": "Wed, 21 Jul 2021 14:05:12",
    "site": [
        {
            "@name": "https://kali",
            "@host": "kali",
            "@port": "443",
            "@ssl": "true",
            "alerts": [
                {
                    "pluginid": "10055",
                    "alertRef": "10055",
                    "alert": "CSP: Wildcard Directive",
                    "name": "CSP: Wildcard Directive",
                    "riskcode": "2",
                    "confidence": "2",
                    "riskdesc": "Medium (Medium)",
                    "desc": "<p>The following directives either allow wildcard sources (or ancestors), are not defined, or are overly broadly defined: <\\/p><p>frame-ancestors<\\/p><p><\\/p><p>The directive(s): frame-ancestors are among the directives that do not fallback to default-src, missing/excluding them is the same as allowing anything.<\\/p>",
                    "instances": [
                        {
                            "uri": "https://kali/web/auth/",
                            "method": "GET",
                            "param": "Content-Security-Policy",
                            "evidence": "default-src 'self'; form-action 'none'; script-src 'self' 'nonce-dd0cc681cdad26f4bafa'"
                        },
                        {
                            "uri": "https://kali/robots.txt",
                            "method": "GET",
                            "param": "Content-Security-Policy",
                            "evidence": "default-src 'self'; form-action 'none'"
                        },
                        {
                            "uri": "https://kali/web/auth",
                            "method": "GET",
                            "param": "Content-Security-Policy",
                            "evidence": "default-src 'self'; form-action 'none'"
                        },
                        {
                            "uri": "https://kali/sitemap.xml",
                            "method": "GET",
                            "param": "Content-Security-Policy",
                            "evidence": "default-src 'self'; form-action 'none'"
                        },
                        {
                            "uri": "https://kali/web/auth/",
                            "method": "GET",
                            "param": "Content-Security-Policy",
                            "evidence": "default-src 'self'; form-action 'none'; script-src 'self' 'nonce-bae817a109bb03fb6761'"
                        },
                        {
                            "uri": "https://kali/web/doc/auth/",
                            "method": "GET",
                            "param": "Content-Security-Policy",
                            "evidence": "default-src 'self'; form-action 'none'"
                        }
                    ],
                    "count": "6",
                    "solution": "<p>Ensure that your web server, application server, load balancer, etc. is properly configured to set the Content-Security-Policy header.<\\/p>",
                    "reference": "<p>http://www.w3.org/TR/CSP2/<\\/p><p>http://www.w3.org/TR/CSP/<\\/p><p>http://caniuse.com/#search=content+security+policy<\\/p><p>http://content-security-policy.com/<\\/p><p>https://github.com/shapesecurity/salvation<\\/p><p>https://developers.google.com/web/fundamentals/security/csp#policy_applies_to_a_wide_variety_of_resources<\\/p>",
                    "cweid": "16",
                    "wascid": "15",
                    "sourceid": "3"
                },
                {
                    "pluginid": "10015",
                    "alertRef": "10015",
                    "alert": "Incomplete or No Cache-control and Pragma HTTP Header Set",
                    "name": "Incomplete or No Cache-control and Pragma HTTP Header Set",
                    "riskcode": "1",
                    "confidence": "2",
                    "riskdesc": "Low (Medium)",
                    "desc": "<p>The cache-control and pragma HTTP header have not been set properly or are missing allowing the browser and proxies to cache content.<\\/p>",
                    "instances": [
                        {
                            "uri": "https://kali/static/webscripts_script_style.css",
                            "method": "GET",
                            "param": "Cache-Control",
                            "evidence": "no-store"
                        },
                        {
                            "uri": "https://kali/static/webscripts_style.css",
                            "method": "GET",
                            "param": "Cache-Control",
                            "evidence": "no-store"
                        },
                        {
                            "uri": "https://kali/web/auth/",
                            "method": "GET",
                            "param": "Cache-Control",
                            "evidence": "no-store"
                        }
                    ],
                    "count": "3",
                    "solution": "<p>Whenever possible ensure the cache-control HTTP header is set with no-cache, no-store, must-revalidate; and that the pragma HTTP header is set with no-cache.<\\/p>",
                    "reference": "<p>https://cheatsheetseries.owasp.org/cheatsheets/Session_Management_Cheat_Sheet.html#web-content-caching<\\/p>",
                    "cweid": "525",
                    "wascid": "13",
                    "sourceid": "3"
                },
                {
                    "pluginid": "10027",
                    "alertRef": "10027",
                    "alert": "Information Disclosure - Suspicious Comments",
                    "name": "Information Disclosure - Suspicious Comments",
                    "riskcode": "0",
                    "confidence": "1",
                    "riskdesc": "Informational (Low)",
                    "desc": "<p>The response appears to contain suspicious comments which may help an attacker. Note: Matches made within script blocks or files are against the entire content not only comments.<\\/p>",
                    "instances": [
                        {
                            "uri": "https://kali/js/webscripts_script_js_scripts.js",
                            "method": "GET"
                        },
                        {
                            "uri": "https://kali/js/webscripts_js_scripts.js",
                            "method": "GET"
                        }
                    ],
                    "count": "2",
                    "solution": "<p>Remove all comments that return information that may help an attacker and fix any underlying problems they refer to.<\\/p>",
                    "otherinfo": "<p>The following comment/snippet was identified via the pattern: \\bLATER\\b<\\/p><p>    (at your option) any later version.<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\tlet input, select, option;<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\tlet selects = document.getElementsByTagName('select');<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\t\tselect = selects[i];<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\t\tfor (let l in select.options) {<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\t\t\toption = select.options[l];<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\t\t\t\targuments_ = add_value_for_request(arguments_, select.name, option.value);<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\tlet select = document.createElement(\"select\");<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\tselect.name = argument.name;<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\t\tselect.multiple=true;<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\t\tselect.value = argument.default_value;<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\t\tselect.appendChild(option);<\\/p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b<\\/p><p>\treturn select;<\\/p><p><\\/p>",
                    "reference": "<p><\\/p>",
                    "cweid": "200",
                    "wascid": "13",
                    "sourceid": "3"
                },
                {
                    "pluginid": "10027",
                    "alertRef": "10027",
                    "alert": "Information Disclosure - Suspicious Comments",
                    "name": "Information Disclosure - Suspicious Comments",
                    "riskcode": "0",
                    "confidence": "2",
                    "riskdesc": "Informational (Medium)",
                    "desc": "<p>The response appears to contain suspicious comments which may help an attacker. Note: Matches made within script blocks or files are against the entire content not only comments.<\\/p>",
                    "instances": [
                        {
                            "uri": "https://kali/web/auth/",
                            "method": "GET"
                        }
                    ],
                    "count": "1",
                    "solution": "<p>Remove all comments that return information that may help an attacker and fix any underlying problems they refer to.<\\/p>",
                    "otherinfo": "<p>The following comment/snippet was identified via the pattern: \\bLATER\\b<\\/p><p><!--<\\/p><p><\\/p><p>    HTML page to launch scripts.<\\/p><p>    Copyright (C) 2021  Maurice Lambert<\\/p><p><\\/p><p>    This program is free software: you can redistribute it and/or modify<\\/p><p>    it under the terms of the GNU General Public License as published by<\\/p><p>    the Free Software Foundation, either version 3 of the License, or<\\/p><p>    (at your option) any later version.<\\/p><p><\\/p><p>    This program is distributed in the hope that it will be useful,<\\/p><p>    but WITHOUT ANY WARRANTY; without even the implied warranty of<\\/p><p>    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the<\\/p><p>    GNU General Public License for more details.<\\/p><p><\\/p><p>    You should have received a copy of the GNU General Public License<\\/p><p>    along with this program.  If not, see <https://www.gnu.org/licenses/>.<\\/p><p><\\/p><p>--><\\/p><p><\\/p>",
                    "reference": "<p><\\/p>",
                    "cweid": "200",
                    "wascid": "13",
                    "sourceid": "3"
                },
                {
                    "pluginid": "10055",
                    "alertRef": "10055",
                    "alert": "CSP: Notices",
                    "name": "CSP: Notices",
                    "riskcode": "1",
                    "confidence": "2",
                    "riskdesc": "Low (Medium)",
                    "desc": "<p>Warnings:<\\/p><p>1:59: CSP specification recommends nonce-value to be at least 128 bits long (before encoding).<\\/p><p><\\/p>",
                    "instances": [
                        {
                            "uri": "https://kali/web/auth/",
                            "method": "GET",
                            "param": "Content-Security-Policy",
                            "evidence": "default-src 'self'; form-action 'none'; script-src 'self' 'nonce-dd0cc681cdad26f4bafa'"
                        },
                        {
                            "uri": "https://kali/web/auth/",
                            "method": "GET",
                            "param": "Content-Security-Policy",
                            "evidence": "default-src 'self'; form-action 'none'; script-src 'self' 'nonce-bae817a109bb03fb6761'"
                        }
                    ],
                    "count": "2",
                    "solution": "<p>Ensure that your web server, application server, load balancer, etc. is properly configured to set the Content-Security-Policy header.<\\/p>",
                    "reference": "<p>http://www.w3.org/TR/CSP2/<\\/p><p>http://www.w3.org/TR/CSP/<\\/p><p>http://caniuse.com/#search=content+security+policy<\\/p><p>http://content-security-policy.com/<\\/p><p>https://github.com/shapesecurity/salvation<\\/p><p>https://developers.google.com/web/fundamentals/security/csp#policy_applies_to_a_wide_variety_of_resources<\\/p>",
                    "cweid": "16",
                    "wascid": "15",
                    "sourceid": "3"
                }
            ]
        }
    ]
}
```