# coding: utf-8

"""
    WP Engine API

    The API described in this document is subject to change. 

    The version of the OpenAPI document: 1.6.7
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wp_engine_api.generated.models.account_user_installs_inner import AccountUserInstallsInner
from typing import Optional, Set
from typing_extensions import Self

class AccountUser(BaseModel):
    """
    AccountUser
    """ # noqa: E501
    user_id: StrictStr = Field(description="The user ID")
    account_id: StrictStr = Field(description="The account ID")
    first_name: StrictStr = Field(description="The first name of the user")
    last_name: StrictStr = Field(description="The last name of the user")
    email: StrictStr = Field(description="The email of the user")
    phone: Optional[StrictStr] = Field(description="The phone number of the user")
    invite_accepted: StrictBool = Field(description="Whether or not the user has accepted their invitation")
    mfa_enabled: StrictBool = Field(description="Whether or not the user has multi-factor authentication enabled")
    roles: StrictStr = Field(description="The user roles")
    last_owner: Optional[StrictBool] = Field(default=None, description="Whether or not this owner is the last on the account. Only shows with users that have owner level roles.")
    installs: Optional[List[AccountUserInstallsInner]] = Field(default=None, description="An array of installs tied to a partial user.")
    __properties: ClassVar[List[str]] = ["user_id", "account_id", "first_name", "last_name", "email", "phone", "invite_accepted", "mfa_enabled", "roles", "last_owner", "installs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in installs (list)
        _items = []
        if self.installs:
            for _item_installs in self.installs:
                if _item_installs:
                    _items.append(_item_installs.to_dict())
            _dict['installs'] = _items
        # set to None if phone (nullable) is None
        # and model_fields_set contains the field
        if self.phone is None and "phone" in self.model_fields_set:
            _dict['phone'] = None

        # set to None if last_owner (nullable) is None
        # and model_fields_set contains the field
        if self.last_owner is None and "last_owner" in self.model_fields_set:
            _dict['last_owner'] = None

        # set to None if installs (nullable) is None
        # and model_fields_set contains the field
        if self.installs is None and "installs" in self.model_fields_set:
            _dict['installs'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "account_id": obj.get("account_id"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "invite_accepted": obj.get("invite_accepted"),
            "mfa_enabled": obj.get("mfa_enabled"),
            "roles": obj.get("roles"),
            "last_owner": obj.get("last_owner"),
            "installs": [AccountUserInstallsInner.from_dict(_item) for _item in obj["installs"]] if obj.get("installs") is not None else None
        })
        return _obj


