# coding: utf-8

"""
    WP Engine API

    The API described in this document is subject to change. 

    The version of the OpenAPI document: 1.6.7
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateInstallRequest(BaseModel):
    """
    CreateInstallRequest
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the install")
    account_id: StrictStr = Field(description="The ID of the account that the install will belong to")
    site_id: Optional[StrictStr] = Field(default=None, description="The ID of the site that the install will belong to")
    environment: Optional[StrictStr] = Field(default=None, description="The site environment that the install will fill")
    __properties: ClassVar[List[str]] = ["name", "account_id", "site_id", "environment"]

    @field_validator('environment')
    def environment_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['production', 'staging', 'development']):
            raise ValueError("must be one of enum values ('production', 'staging', 'development')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInstallRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if site_id (nullable) is None
        # and model_fields_set contains the field
        if self.site_id is None and "site_id" in self.model_fields_set:
            _dict['site_id'] = None

        # set to None if environment (nullable) is None
        # and model_fields_set contains the field
        if self.environment is None and "environment" in self.model_fields_set:
            _dict['environment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInstallRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "account_id": obj.get("account_id"),
            "site_id": obj.get("site_id"),
            "environment": obj.get("environment")
        })
        return _obj


