/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/affinematrix2dbase.h>

        #include <wx/geometry.h>
        #include <wx/affinematrix2dbase.h>


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_IsEqual, "IsEqual(t) -> bool\n"
"\n"
"Check that this matrix is identical with t.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_IsEqual(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_IsEqual(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxAffineMatrix2DBase* t;
        const  ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_t,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxAffineMatrix2DBase, &t))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_IsEqual);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEqual(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_IsEqual, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Set, "Set(mat2D, tr)\n"
"\n"
"Set all elements of this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxMatrix2D* mat2D;
        const  ::wxPoint2DDouble* tr;
        int trState = 0;
         ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mat2D,
            sipName_tr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxMatrix2D, &mat2D, sipType_wxPoint2DDouble, &tr, &trState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Set);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(*mat2D,*tr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2DDouble *>(tr),sipType_wxPoint2DDouble,trState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Set, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Get, "Get() -> (mat2D, tr)\n"
"\n"
"Get the component values of the matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Get(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Get(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxMatrix2D* mat2D;
         ::wxPoint2DDouble* tr;
        const  ::wxAffineMatrix2DBase *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp))
        {
            mat2D = new  ::wxMatrix2D();
            tr = new  ::wxPoint2DDouble();

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Get);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Get(mat2D,tr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(NN)",mat2D,sipType_wxMatrix2D,NULL,tr,sipType_wxPoint2DDouble,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Get, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Concat, "Concat(t)\n"
"\n"
"Concatenate this matrix with another one.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Concat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Concat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxAffineMatrix2DBase* t;
         ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_t,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxAffineMatrix2DBase, &t))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Concat);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Concat(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Concat, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Invert, "Invert() -> bool\n"
"\n"
"Invert this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Invert(PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Invert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxAffineMatrix2DBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Invert);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Invert();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Invert, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_IsIdentity, "IsIdentity() -> bool\n"
"\n"
"Check if this is the identity matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_IsIdentity(PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_IsIdentity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxAffineMatrix2DBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_IsIdentity);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsIdentity();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_IsIdentity, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Translate, "Translate(dx, dy)\n"
"\n"
"Add the translation to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Translate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Translate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxDouble dx;
         ::wxDouble dy;
         ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &dx, &dy))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Translate);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Translate(dx,dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Translate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Scale, "Scale(xScale, yScale)\n"
"\n"
"Add scaling to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Scale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Scale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxDouble xScale;
         ::wxDouble yScale;
         ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xScale,
            sipName_yScale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &xScale, &yScale))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Scale);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Scale(xScale,yScale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Scale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Rotate, "Rotate(cRadians)\n"
"\n"
"Add clockwise rotation to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Rotate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Rotate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxDouble cRadians;
         ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cRadians,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &cRadians))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Rotate);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Rotate(cRadians);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Rotate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Mirror, "Mirror(direction=HORIZONTAL)\n"
"\n"
"Add mirroring to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Mirror(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Mirror(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int direction = wxHORIZONTAL;
         ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &direction))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Mirror(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Mirror, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_TransformPoint, "TransformPoint(p) -> Point2DDouble\n"
"TransformPoint(x, y) -> (x, y)\n"
"\n"
"Applies this matrix to the point.\n"
"");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_TransformPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_TransformPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint2DDouble* p;
        int pState = 0;
        const  ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
             ::wxPoint2DDouble*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint2DDouble(sipCpp->TransformPoint(*p));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2DDouble *>(p),sipType_wxPoint2DDouble,pState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint2DDouble,NULL);
        }
    }

    {
         ::wxDouble x;
         ::wxDouble y;
        const  ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->TransformPoint(&x,&y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dd)",x,y);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_TransformPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_TransformDistance, "TransformDistance(p) -> Point2DDouble\n"
"TransformDistance(dx, dy) -> (dx, dy)\n"
"\n"
"Applies the linear part of this matrix, i.e. without translation.\n"
"");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_TransformDistance(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_TransformDistance(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint2DDouble* p;
        int pState = 0;
        const  ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
             ::wxPoint2DDouble*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint2DDouble(sipCpp->TransformDistance(*p));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2DDouble *>(p),sipType_wxPoint2DDouble,pState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint2DDouble,NULL);
        }
    }

    {
         ::wxDouble dx;
         ::wxDouble dy;
        const  ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &dx, &dy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->TransformDistance(&dx,&dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dd)",dx,dy);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_TransformDistance, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxAffineMatrix2DBase___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxAffineMatrix2DBase___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxAffineMatrix2DBase *sipCpp = reinterpret_cast< ::wxAffineMatrix2DBase *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxAffineMatrix2DBase));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxAffineMatrix2DBase* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxAffineMatrix2DBase, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxAffineMatrix2DBase::operator!=(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxAffineMatrix2DBase, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxAffineMatrix2DBase___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxAffineMatrix2DBase___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxAffineMatrix2DBase *sipCpp = reinterpret_cast< ::wxAffineMatrix2DBase *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxAffineMatrix2DBase));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxAffineMatrix2DBase* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxAffineMatrix2DBase, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxAffineMatrix2DBase::operator==(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxAffineMatrix2DBase, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAffineMatrix2DBase(void *, int);}
static void release_wxAffineMatrix2DBase(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAffineMatrix2DBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxAffineMatrix2DBase(sipSimpleWrapper *);}
static void dealloc_wxAffineMatrix2DBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAffineMatrix2DBase(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxAffineMatrix2DBase[] = {
    {(void *)slot_wxAffineMatrix2DBase___ne__, ne_slot},
    {(void *)slot_wxAffineMatrix2DBase___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxAffineMatrix2DBase[] = {
    {SIP_MLNAME_CAST(sipName_Concat), (PyCFunction)meth_wxAffineMatrix2DBase_Concat, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_Concat)},
    {SIP_MLNAME_CAST(sipName_Get), (PyCFunction)meth_wxAffineMatrix2DBase_Get, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_Get)},
    {SIP_MLNAME_CAST(sipName_Invert), meth_wxAffineMatrix2DBase_Invert, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_Invert)},
    {SIP_MLNAME_CAST(sipName_IsEqual), (PyCFunction)meth_wxAffineMatrix2DBase_IsEqual, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_IsEqual)},
    {SIP_MLNAME_CAST(sipName_IsIdentity), meth_wxAffineMatrix2DBase_IsIdentity, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_IsIdentity)},
    {SIP_MLNAME_CAST(sipName_Mirror), (PyCFunction)meth_wxAffineMatrix2DBase_Mirror, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_Mirror)},
    {SIP_MLNAME_CAST(sipName_Rotate), (PyCFunction)meth_wxAffineMatrix2DBase_Rotate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_Rotate)},
    {SIP_MLNAME_CAST(sipName_Scale), (PyCFunction)meth_wxAffineMatrix2DBase_Scale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_Scale)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxAffineMatrix2DBase_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_Set)},
    {SIP_MLNAME_CAST(sipName_TransformDistance), (PyCFunction)meth_wxAffineMatrix2DBase_TransformDistance, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_TransformDistance)},
    {SIP_MLNAME_CAST(sipName_TransformPoint), (PyCFunction)meth_wxAffineMatrix2DBase_TransformPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_TransformPoint)},
    {SIP_MLNAME_CAST(sipName_Translate), (PyCFunction)meth_wxAffineMatrix2DBase_Translate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAffineMatrix2DBase_Translate)}
};

PyDoc_STRVAR(doc_wxAffineMatrix2DBase, "AffineMatrix2DBase()\n"
"\n"
"A 2x3 matrix representing an affine 2D transformation.");


sipClassTypeDef sipTypeDef__core_wxAffineMatrix2DBase = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxAffineMatrix2DBase,
        {0},
        0
    },
    {
        sipNameNr_AffineMatrix2DBase,
        {0, 0, 1},
        12, methods_wxAffineMatrix2DBase,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxAffineMatrix2DBase,
    -1,
    -1,
    0,
    slots_wxAffineMatrix2DBase,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxAffineMatrix2DBase,
    0,
    0,
    0,
    release_wxAffineMatrix2DBase,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
