/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/clipbrd.h>

        #include <wx/dataobj.h>
        #include <wx/dataobj.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxClipboard : public  ::wxClipboard
{
public:
    sipwxClipboard();
    sipwxClipboard(const  ::wxClipboard&);
    virtual ~sipwxClipboard();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void UsePrimarySelection(bool);
    bool SetData( ::wxDataObject*);
    bool Open();
    bool IsSupported(const  ::wxDataFormat&);
    bool IsOpened() const;
    bool GetData( ::wxDataObject&);
    bool Flush();
    void Close();
    void Clear();
    bool AddData( ::wxDataObject*);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxClipboard(const sipwxClipboard &);
    sipwxClipboard &operator = (const sipwxClipboard &);

    char sipPyMethods[10];
};

sipwxClipboard::sipwxClipboard():  ::wxClipboard(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxClipboard::sipwxClipboard(const  ::wxClipboard& a0):  ::wxClipboard(a0), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxClipboard::~sipwxClipboard()
{
    sipInstanceDestroyed(sipPySelf);
}

void sipwxClipboard::UsePrimarySelection(bool primary)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_UsePrimarySelection);

    if (!sipMeth)
    {
         ::wxClipboard::UsePrimarySelection(primary);
        return;
    }

    extern void sipVH__core_74(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    sipVH__core_74(sipGILState, 0, sipPySelf, sipMeth, primary);
}

bool sipwxClipboard::SetData( ::wxDataObject*data)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_SetData);

    if (!sipMeth)
        return  ::wxClipboard::SetData(data);

    extern bool sipVH__core_71(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataObject*);

    return sipVH__core_71(sipGILState, 0, sipPySelf, sipMeth, data);
}

bool sipwxClipboard::Open()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_Open);

    if (!sipMeth)
        return  ::wxClipboard::Open();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxClipboard::IsSupported(const  ::wxDataFormat& format)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_IsSupported);

    if (!sipMeth)
        return  ::wxClipboard::IsSupported(format);

    extern bool sipVH__core_73(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxDataFormat&);

    return sipVH__core_73(sipGILState, 0, sipPySelf, sipMeth, format);
}

bool sipwxClipboard::IsOpened() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[4]),sipPySelf,NULL,sipName_IsOpened);

    if (!sipMeth)
        return  ::wxClipboard::IsOpened();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxClipboard::GetData( ::wxDataObject& data)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,NULL,sipName_GetData);

    if (!sipMeth)
        return  ::wxClipboard::GetData(data);

    extern bool sipVH__core_72(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataObject&);

    return sipVH__core_72(sipGILState, 0, sipPySelf, sipMeth, data);
}

bool sipwxClipboard::Flush()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[6],sipPySelf,NULL,sipName_Flush);

    if (!sipMeth)
        return  ::wxClipboard::Flush();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxClipboard::Close()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,NULL,sipName_Close);

    if (!sipMeth)
    {
         ::wxClipboard::Close();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxClipboard::Clear()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,NULL,sipName_Clear);

    if (!sipMeth)
    {
         ::wxClipboard::Clear();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxClipboard::AddData( ::wxDataObject*data)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[9],sipPySelf,NULL,sipName_AddData);

    if (!sipMeth)
        return  ::wxClipboard::AddData(data);

    extern bool sipVH__core_71(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataObject*);

    return sipVH__core_71(sipGILState, 0, sipPySelf, sipMeth, data);
}


PyDoc_STRVAR(doc_wxClipboard_AddData, "AddData(data) -> bool\n"
"\n"
"Call this function to add the data object to the clipboard.");

extern "C" {static PyObject *meth_wxClipboard_AddData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_AddData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataObject* data;
         ::wxClipboard *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxClipboard, &sipCpp, sipType_wxDataObject, &data))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxClipboard::AddData(data) : sipCpp->AddData(data));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_AddData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_Clear, "Clear()\n"
"\n"
"Clears the global clipboard object and the system's clipboard if\n"
"possible.");

extern "C" {static PyObject *meth_wxClipboard_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxClipboard *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClipboard, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxClipboard::Clear() : sipCpp->Clear());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_Close, "Close()\n"
"\n"
"Call this function to close the clipboard, having opened it with\n"
"Open().");

extern "C" {static PyObject *meth_wxClipboard_Close(PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_Close(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxClipboard *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClipboard, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxClipboard::Close() : sipCpp->Close());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_Close, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_Flush, "Flush() -> bool\n"
"\n"
"Flushes the clipboard: this means that the data which is currently on\n"
"clipboard will stay available even after the application exits\n"
"(possibly eating memory), otherwise the clipboard will be emptied on\n"
"exit.");

extern "C" {static PyObject *meth_wxClipboard_Flush(PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_Flush(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxClipboard *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClipboard, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxClipboard::Flush() : sipCpp->Flush());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_Flush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_GetData, "GetData(data) -> bool\n"
"\n"
"Call this function to fill data with data on the clipboard, if\n"
"available in the required format.");

extern "C" {static PyObject *meth_wxClipboard_GetData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_GetData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataObject* data;
         ::wxClipboard *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxClipboard, &sipCpp, sipType_wxDataObject, &data))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxClipboard::GetData(*data) : sipCpp->GetData(*data));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_GetData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_IsOpened, "IsOpened() -> bool\n"
"\n"
"Returns true if the clipboard has been opened.");

extern "C" {static PyObject *meth_wxClipboard_IsOpened(PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_IsOpened(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxClipboard *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClipboard, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxClipboard::IsOpened() : sipCpp->IsOpened());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_IsOpened, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_IsSupported, "IsSupported(format) -> bool\n"
"\n"
"Returns true if there is data which matches the data format of the\n"
"given data object currently available on the clipboard.");

extern "C" {static PyObject *meth_wxClipboard_IsSupported(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_IsSupported(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxDataFormat* format;
         ::wxClipboard *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxClipboard, &sipCpp, sipType_wxDataFormat, &format))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxClipboard::IsSupported(*format) : sipCpp->IsSupported(*format));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_IsSupported, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_IsUsingPrimarySelection, "IsUsingPrimarySelection() -> bool\n"
"\n"
"Returns true if we are using the primary selection, false if clipboard\n"
"one.");

extern "C" {static PyObject *meth_wxClipboard_IsUsingPrimarySelection(PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_IsUsingPrimarySelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxClipboard *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClipboard, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsUsingPrimarySelection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_IsUsingPrimarySelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_Open, "Open() -> bool\n"
"\n"
"Call this function to open the clipboard before calling SetData() and\n"
"GetData().");

extern "C" {static PyObject *meth_wxClipboard_Open(PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_Open(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxClipboard *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClipboard, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxClipboard::Open() : sipCpp->Open());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_Open, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_SetData, "SetData(data) -> bool\n"
"\n"
"Call this function to set the data object to the clipboard.");

extern "C" {static PyObject *meth_wxClipboard_SetData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_SetData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataObject* data;
         ::wxClipboard *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxClipboard, &sipCpp, sipType_wxDataObject, &data))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxClipboard::SetData(data) : sipCpp->SetData(data));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_SetData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_UsePrimarySelection, "UsePrimarySelection(primary=False)\n"
"\n"
"On platforms supporting it (all X11-based ports), wxClipboard uses the\n"
"CLIPBOARD X11 selection by default.");

extern "C" {static PyObject *meth_wxClipboard_UsePrimarySelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_UsePrimarySelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        bool primary = 0;
         ::wxClipboard *sipCpp;

        static const char *sipKwdList[] = {
            sipName_primary,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxClipboard, &sipCpp, &primary))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxClipboard::UsePrimarySelection(primary) : sipCpp->UsePrimarySelection(primary));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_UsePrimarySelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxClipboard_Get, "Get() -> Clipboard\n"
"\n"
"Returns the global instance (wxTheClipboard) of the clipboard object.");

extern "C" {static PyObject *meth_wxClipboard_Get(PyObject *, PyObject *);}
static PyObject *meth_wxClipboard_Get(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxClipboard*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxClipboard::Get();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxClipboard,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Clipboard, sipName_Get, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxClipboard(void *, const sipTypeDef *);}
static void *cast_wxClipboard(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxClipboard *sipCpp = reinterpret_cast< ::wxClipboard *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxClipboard(void *, int);}
static void release_wxClipboard(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxClipboard *>(sipCppV);
    else
        delete reinterpret_cast< ::wxClipboard *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxClipboard(void *, SIP_SSIZE_T, void *);}
static void assign_wxClipboard(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxClipboard *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxClipboard *>(sipSrc);
}


extern "C" {static void *array_wxClipboard(SIP_SSIZE_T);}
static void *array_wxClipboard(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxClipboard[sipNrElem];
}


extern "C" {static void *copy_wxClipboard(const void *, SIP_SSIZE_T);}
static void *copy_wxClipboard(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxClipboard(reinterpret_cast<const  ::wxClipboard *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxClipboard(sipSimpleWrapper *);}
static void dealloc_wxClipboard(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxClipboard *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxClipboard(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxClipboard(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxClipboard(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxClipboard *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxClipboard();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxClipboard* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxClipboard, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxClipboard(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxClipboard[] = {{348, 255, 1}};


static PyMethodDef methods_wxClipboard[] = {
    {SIP_MLNAME_CAST(sipName_AddData), (PyCFunction)meth_wxClipboard_AddData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxClipboard_AddData)},
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxClipboard_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxClipboard_Clear)},
    {SIP_MLNAME_CAST(sipName_Close), meth_wxClipboard_Close, METH_VARARGS, SIP_MLDOC_CAST(doc_wxClipboard_Close)},
    {SIP_MLNAME_CAST(sipName_Flush), meth_wxClipboard_Flush, METH_VARARGS, SIP_MLDOC_CAST(doc_wxClipboard_Flush)},
    {SIP_MLNAME_CAST(sipName_Get), meth_wxClipboard_Get, METH_VARARGS, SIP_MLDOC_CAST(doc_wxClipboard_Get)},
    {SIP_MLNAME_CAST(sipName_GetData), (PyCFunction)meth_wxClipboard_GetData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxClipboard_GetData)},
    {SIP_MLNAME_CAST(sipName_IsOpened), meth_wxClipboard_IsOpened, METH_VARARGS, SIP_MLDOC_CAST(doc_wxClipboard_IsOpened)},
    {SIP_MLNAME_CAST(sipName_IsSupported), (PyCFunction)meth_wxClipboard_IsSupported, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxClipboard_IsSupported)},
    {SIP_MLNAME_CAST(sipName_IsUsingPrimarySelection), meth_wxClipboard_IsUsingPrimarySelection, METH_VARARGS, SIP_MLDOC_CAST(doc_wxClipboard_IsUsingPrimarySelection)},
    {SIP_MLNAME_CAST(sipName_Open), meth_wxClipboard_Open, METH_VARARGS, SIP_MLDOC_CAST(doc_wxClipboard_Open)},
    {SIP_MLNAME_CAST(sipName_SetData), (PyCFunction)meth_wxClipboard_SetData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxClipboard_SetData)},
    {SIP_MLNAME_CAST(sipName_UsePrimarySelection), (PyCFunction)meth_wxClipboard_UsePrimarySelection, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxClipboard_UsePrimarySelection)}
};

PyDoc_STRVAR(doc_wxClipboard, "Clipboard()\n"
"\n"
"A class for manipulating the clipboard.");


sipClassTypeDef sipTypeDef__core_wxClipboard = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxClipboard,
        {0},
        0
    },
    {
        sipNameNr_Clipboard,
        {0, 0, 1},
        12, methods_wxClipboard,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxClipboard,
    -1,
    -1,
    supers_wxClipboard,
    0,
    init_type_wxClipboard,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxClipboard,
    assign_wxClipboard,
    array_wxClipboard,
    copy_wxClipboard,
    release_wxClipboard,
    cast_wxClipboard,
    0,
    0,
    0,
    0,
    0,
    0
};
