/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/datetime.h>
            #include <wx/datetime.h>

        #include <wx/datetime.h>


PyDoc_STRVAR(doc_wxDateTime_TimeZone_GetOffset, "GetOffset() -> long\n"
"\n"
"Return the offset of this time zone from UTC, in seconds.");

extern "C" {static PyObject *meth_wxDateTime_TimeZone_GetOffset(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_TimeZone_GetOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime_TimeZone, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOffset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeZone, sipName_GetOffset, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_TimeZone_Make, "Make(offset) -> DateTime.TimeZone\n"
"\n"
"Create a time zone with the given offset in seconds.");

extern "C" {static PyObject *meth_wxDateTime_TimeZone_Make(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_TimeZone_Make(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long offset;

        static const char *sipKwdList[] = {
            sipName_offset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &offset))
        {
             ::wxDateTime::TimeZone*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime::TimeZone( ::wxDateTime::TimeZone::Make(offset));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime_TimeZone,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeZone, sipName_Make, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDateTime_TimeZone(void *, int);}
static void release_wxDateTime_TimeZone(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDateTime::TimeZone *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxDateTime_TimeZone(void *, SIP_SSIZE_T, void *);}
static void assign_wxDateTime_TimeZone(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxDateTime::TimeZone *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxDateTime::TimeZone *>(sipSrc);
}


extern "C" {static void *array_wxDateTime_TimeZone(SIP_SSIZE_T);}
static void *array_wxDateTime_TimeZone(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxDateTime::TimeZone[sipNrElem];
}


extern "C" {static void *copy_wxDateTime_TimeZone(const void *, SIP_SSIZE_T);}
static void *copy_wxDateTime_TimeZone(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxDateTime::TimeZone(reinterpret_cast<const  ::wxDateTime::TimeZone *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxDateTime_TimeZone(sipSimpleWrapper *);}
static void dealloc_wxDateTime_TimeZone(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDateTime_TimeZone(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxDateTime_TimeZone(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDateTime_TimeZone(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxDateTime::TimeZone *sipCpp = 0;

    {
         ::wxDateTime::TZ tz;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "E", sipType_wxDateTime_TZ, &tz))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime::TimeZone(tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        long offset = 0;

        static const char *sipKwdList[] = {
            sipName_offset,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|l", &offset))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime::TimeZone(offset);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxDateTime::TimeZone* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxDateTime_TimeZone, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime::TimeZone(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxDateTime_TimeZone[] = {
    {SIP_MLNAME_CAST(sipName_GetOffset), meth_wxDateTime_TimeZone_GetOffset, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_TimeZone_GetOffset)},
    {SIP_MLNAME_CAST(sipName_Make), (PyCFunction)meth_wxDateTime_TimeZone_Make, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_TimeZone_Make)}
};

sipVariableDef variables_wxDateTime_TimeZone[] = {
    {PropertyVariable, sipName_Offset, &methods_wxDateTime_TimeZone[0], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxDateTime_TimeZone, "TimeZone(tz)\n"
"TimeZone(offset=0)\n"
"\n"
"Class representing a time zone.");


sipClassTypeDef sipTypeDef__core_wxDateTime_TimeZone = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxDateTime__TimeZone,
        {0},
        0
    },
    {
        sipNameNr_TimeZone,
        {103, 255, 0},
        2, methods_wxDateTime_TimeZone,
        0, 0,
        1, variables_wxDateTime_TimeZone,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxDateTime_TimeZone,
    -1,
    -1,
    0,
    0,
    init_type_wxDateTime_TimeZone,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxDateTime_TimeZone,
    assign_wxDateTime_TimeZone,
    array_wxDateTime_TimeZone,
    copy_wxDateTime_TimeZone,
    release_wxDateTime_TimeZone,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
