/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/font.h>

        #include <wx/font.h>
        #include <wx/gdicmn.h>
        #include <wx/fontutil.h>
        #include <wx/object.h>
        #include <wx/object.h>
    int _wxFont___nonzero__(wxFont* self)
    {
        return self->IsOk();
    }
    void* _wxFont_GetHFONT(wxFont* self)
    {
        #ifdef __WXMSW__
            return self->GetHFONT();
        #else
            return 0;
        #endif
    }
    void* _wxFont_OSXGetCGFont(wxFont* self)
    {
        #ifdef __WXMAC__
            return self->OSXGetCGFont();
        #else
            return 0;
        #endif
    }
    void* _wxFont_GetPangoFontDescription(wxFont* self)
    {
        #ifdef __WXGTK__
            return self->GetNativeFontInfo()->description;
        #else
            return 0;
        #endif
    }
    void _wxFont__copyFrom(wxFont* self, const wxFont* other)
    {
        *self = *other;
    }


PyDoc_STRVAR(doc_wxFont_GetEncoding, "GetEncoding() -> FontEncoding\n"
"\n"
"Returns the encoding of this font.");

extern "C" {static PyObject *meth_wxFont_GetEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetEncoding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFontEncoding sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEncoding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontEncoding);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetFaceName, "GetFaceName() -> String\n"
"\n"
"Returns the face name associated with the font, or the empty string if\n"
"there is no face information.");

extern "C" {static PyObject *meth_wxFont_GetFaceName(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetFaceName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetFaceName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetFaceName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetFamily, "GetFamily() -> FontFamily\n"
"\n"
"Gets the font family if possible.");

extern "C" {static PyObject *meth_wxFont_GetFamily(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetFamily(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFontFamily sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFamily();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontFamily);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetFamily, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetNativeFontInfoDesc, "GetNativeFontInfoDesc() -> String\n"
"\n"
"Returns the platform-dependent string completely describing this font.");

extern "C" {static PyObject *meth_wxFont_GetNativeFontInfoDesc(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetNativeFontInfoDesc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetNativeFontInfoDesc());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetNativeFontInfoDesc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetNativeFontInfoUserDesc, "GetNativeFontInfoUserDesc() -> String\n"
"\n"
"Returns a user-friendly string for this font object.");

extern "C" {static PyObject *meth_wxFont_GetNativeFontInfoUserDesc(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetNativeFontInfoUserDesc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetNativeFontInfoUserDesc());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetNativeFontInfoUserDesc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetNativeFontInfo, "GetNativeFontInfo() -> NativeFontInfo\n"
"\n"
"Returns the encoding of this font.");

extern "C" {static PyObject *meth_wxFont_GetNativeFontInfo(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetNativeFontInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            const  ::wxNativeFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNativeFontInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxNativeFontInfo *>(sipRes),sipType_wxNativeFontInfo,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetNativeFontInfo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetPointSize, "GetPointSize() -> int\n"
"\n"
"Gets the point size.");

extern "C" {static PyObject *meth_wxFont_GetPointSize(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetPointSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPointSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetPointSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetPixelSize, "GetPixelSize() -> Size\n"
"\n"
"Gets the pixel size.");

extern "C" {static PyObject *meth_wxFont_GetPixelSize(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetPixelSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetPixelSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetPixelSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetStyle, "GetStyle() -> FontStyle\n"
"\n"
"Gets the font style.");

extern "C" {static PyObject *meth_wxFont_GetStyle(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFontStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontStyle);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetUnderlined, "GetUnderlined() -> bool\n"
"\n"
"Returns true if the font is underlined, false otherwise.");

extern "C" {static PyObject *meth_wxFont_GetUnderlined(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetUnderlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUnderlined();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetUnderlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetStrikethrough, "GetStrikethrough() -> bool\n"
"\n"
"Returns true if the font is stricken-through, false otherwise.");

extern "C" {static PyObject *meth_wxFont_GetStrikethrough(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetStrikethrough(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStrikethrough();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetStrikethrough, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetWeight, "GetWeight() -> FontWeight\n"
"\n"
"Gets the font weight.");

extern "C" {static PyObject *meth_wxFont_GetWeight(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetWeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFontWeight sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontWeight);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetWeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_IsFixedWidth, "IsFixedWidth() -> bool\n"
"\n"
"Returns true if the font is a fixed width (or monospaced) font, false\n"
"if it is a proportional one or font is invalid.");

extern "C" {static PyObject *meth_wxFont_IsFixedWidth(PyObject *, PyObject *);}
static PyObject *meth_wxFont_IsFixedWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFixedWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_IsFixedWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if this object is a valid font, false otherwise.");

extern "C" {static PyObject *meth_wxFont_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxFont_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_Bold, "Bold() -> Font\n"
"\n"
"Returns a bold version of this font.");

extern "C" {static PyObject *meth_wxFont_Bold(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Bold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->Bold());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_Bold, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_Italic, "Italic() -> Font\n"
"\n"
"Returns an italic version of this font.");

extern "C" {static PyObject *meth_wxFont_Italic(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Italic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->Italic());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_Italic, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_Larger, "Larger() -> Font\n"
"\n"
"Returns a larger version of this font.");

extern "C" {static PyObject *meth_wxFont_Larger(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Larger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->Larger());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_Larger, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_Smaller, "Smaller() -> Font\n"
"\n"
"Returns a smaller version of this font.");

extern "C" {static PyObject *meth_wxFont_Smaller(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Smaller(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->Smaller());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_Smaller, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_Underlined, "Underlined() -> Font\n"
"\n"
"Returns underlined version of this font.");

extern "C" {static PyObject *meth_wxFont_Underlined(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Underlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->Underlined());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_Underlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_Strikethrough, "Strikethrough() -> Font\n"
"\n"
"Returns stricken-through version of this font.");

extern "C" {static PyObject *meth_wxFont_Strikethrough(PyObject *, PyObject *);}
static PyObject *meth_wxFont_Strikethrough(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->Strikethrough());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_Strikethrough, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_MakeBold, "MakeBold() -> Font\n"
"\n"
"Changes this font to be bold.");

extern "C" {static PyObject *meth_wxFont_MakeBold(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeBold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeBold();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeBold, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_MakeItalic, "MakeItalic() -> Font\n"
"\n"
"Changes this font to be italic.");

extern "C" {static PyObject *meth_wxFont_MakeItalic(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeItalic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeItalic();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeItalic, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_MakeLarger, "MakeLarger() -> Font\n"
"\n"
"Changes this font to be larger.");

extern "C" {static PyObject *meth_wxFont_MakeLarger(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeLarger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeLarger();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeLarger, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_MakeSmaller, "MakeSmaller() -> Font\n"
"\n"
"Changes this font to be smaller.");

extern "C" {static PyObject *meth_wxFont_MakeSmaller(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeSmaller(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeSmaller();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeSmaller, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_MakeUnderlined, "MakeUnderlined() -> Font\n"
"\n"
"Changes this font to be underlined.");

extern "C" {static PyObject *meth_wxFont_MakeUnderlined(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeUnderlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeUnderlined();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeUnderlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_MakeStrikethrough, "MakeStrikethrough() -> Font\n"
"\n"
"Changes this font to be stricken-through.");

extern "C" {static PyObject *meth_wxFont_MakeStrikethrough(PyObject *, PyObject *);}
static PyObject *meth_wxFont_MakeStrikethrough(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeStrikethrough();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_MakeStrikethrough, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_Scale, "Scale(x) -> Font\n"
"\n"
"Changes the size of this font.");

extern "C" {static PyObject *meth_wxFont_Scale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_Scale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        float x;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bf", &sipSelf, sipType_wxFont, &sipCpp, &x))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Scale(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_Scale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_Scaled, "Scaled(x) -> Font\n"
"\n"
"Returns a scaled version of this font.");

extern "C" {static PyObject *meth_wxFont_Scaled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_Scaled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        float x;
        const  ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bf", &sipSelf, sipType_wxFont, &sipCpp, &x))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->Scaled(x));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_Scaled, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetEncoding, "SetEncoding(encoding)\n"
"\n"
"Sets the encoding for this font.");

extern "C" {static PyObject *meth_wxFont_SetEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontEncoding encoding;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontEncoding, &encoding))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEncoding(encoding);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetFaceName, "SetFaceName(faceName) -> bool\n"
"\n"
"Sets the facename for the font.");

extern "C" {static PyObject *meth_wxFont_SetFaceName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetFaceName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* faceName;
        int faceNameState = 0;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_faceName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxString,&faceName, &faceNameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetFaceName(*faceName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetFaceName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetFamily, "SetFamily(family)\n"
"\n"
"Sets the font family.");

extern "C" {static PyObject *meth_wxFont_SetFamily(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetFamily(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontFamily family;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_family,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontFamily, &family))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFamily(family);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetFamily, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetNativeFontInfo, "SetNativeFontInfo(info) -> bool\n"
"SetNativeFontInfo(info)\n"
"\n"
"Creates the font corresponding to the given native font description\n"
"string which must have been previously returned by\n"
"GetNativeFontInfoDesc().\n"
"");

extern "C" {static PyObject *meth_wxFont_SetNativeFontInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetNativeFontInfo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* info;
        int infoState = 0;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxString,&info, &infoState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetNativeFontInfo(*info);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(info),sipType_wxString,infoState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxNativeFontInfo* info;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxNativeFontInfo, &info))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNativeFontInfo(*info);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetNativeFontInfo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetNativeFontInfoUserDesc, "SetNativeFontInfoUserDesc(info) -> bool\n"
"\n"
"Creates the font corresponding to the given native font description\n"
"string and returns true if the creation was successful.");

extern "C" {static PyObject *meth_wxFont_SetNativeFontInfoUserDesc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetNativeFontInfoUserDesc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* info;
        int infoState = 0;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxString,&info, &infoState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetNativeFontInfoUserDesc(*info);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(info),sipType_wxString,infoState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetNativeFontInfoUserDesc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetPointSize, "SetPointSize(pointSize)\n"
"\n"
"Sets the point size.");

extern "C" {static PyObject *meth_wxFont_SetPointSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetPointSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int pointSize;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pointSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxFont, &sipCpp, &pointSize))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPointSize(pointSize);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetPointSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetPixelSize, "SetPixelSize(pixelSize)\n"
"\n"
"Sets the pixel size.");

extern "C" {static PyObject *meth_wxFont_SetPixelSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetPixelSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* pixelSize;
        int pixelSizeState = 0;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxSize, &pixelSize, &pixelSizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPixelSize(*pixelSize);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize),sipType_wxSize,pixelSizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetPixelSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetStyle, "SetStyle(style)\n"
"\n"
"Sets the font style.");

extern "C" {static PyObject *meth_wxFont_SetStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontStyle style;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontStyle, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStyle(style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetSymbolicSize, "SetSymbolicSize(size)\n"
"\n"
"Sets the font size using a predefined symbolic size name.");

extern "C" {static PyObject *meth_wxFont_SetSymbolicSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetSymbolicSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontSymbolicSize size;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontSymbolicSize, &size))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSymbolicSize(size);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetSymbolicSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetSymbolicSizeRelativeTo, "SetSymbolicSizeRelativeTo(size, base)\n"
"\n"
"Sets the font size compared to the base font size.");

extern "C" {static PyObject *meth_wxFont_SetSymbolicSizeRelativeTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetSymbolicSizeRelativeTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontSymbolicSize size;
        int base;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BEi", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontSymbolicSize, &size, &base))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSymbolicSizeRelativeTo(size,base);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetSymbolicSizeRelativeTo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetUnderlined, "SetUnderlined(underlined)\n"
"\n"
"Sets underlining.");

extern "C" {static PyObject *meth_wxFont_SetUnderlined(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetUnderlined(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool underlined;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_underlined,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxFont, &sipCpp, &underlined))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUnderlined(underlined);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetUnderlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetStrikethrough, "SetStrikethrough(strikethrough)\n"
"\n"
"Sets strike-through attribute of the font.");

extern "C" {static PyObject *meth_wxFont_SetStrikethrough(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetStrikethrough(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool strikethrough;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strikethrough,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxFont, &sipCpp, &strikethrough))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStrikethrough(strikethrough);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetStrikethrough, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetWeight, "SetWeight(weight)\n"
"\n"
"Sets the font weight.");

extern "C" {static PyObject *meth_wxFont_SetWeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetWeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontWeight weight;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFontWeight, &weight))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWeight(weight);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetWeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_New, "New(pointSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font\n"
"New(pointSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font\n"
"New(pixelSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font\n"
"New(pixelSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font\n"
"New(nativeInfo) -> Font\n"
"New(nativeInfoString) -> Font\n"
"\n"
"This function takes the same parameters as the relative wxFont\n"
"constructor and returns a new font object allocated on the heap.\n"
"\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxFont_New(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_New(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int pointSize;
         ::wxFontFamily family;
         ::wxFontStyle style;
         ::wxFontWeight weight;
        bool underline = 0;
        const  ::wxString& faceNamedef = wxEmptyString;
        const  ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
         ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pointSize,
            sipName_family,
            sipName_style,
            sipName_weight,
            sipName_underline,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "iEEE|bJ1E", &pointSize, sipType_wxFontFamily, &family, sipType_wxFontStyle, &style, sipType_wxFontWeight, &weight, &underline, sipType_wxString,&faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
             ::wxFont*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFont::New(pointSize,family,style,weight,underline,*faceName,encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    {
        int pointSize;
         ::wxFontFamily family;
        int flags = wxFONTFLAG_DEFAULT;
        const  ::wxString& faceNamedef = wxEmptyString;
        const  ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
         ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pointSize,
            sipName_family,
            sipName_flags,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "iE|iJ1E", &pointSize, sipType_wxFontFamily, &family, &flags, sipType_wxString,&faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
             ::wxFont*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFont::New(pointSize,family,flags,*faceName,encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    {
        const  ::wxSize* pixelSize;
        int pixelSizeState = 0;
         ::wxFontFamily family;
         ::wxFontStyle style;
         ::wxFontWeight weight;
        bool underline = 0;
        const  ::wxString& faceNamedef = wxEmptyString;
        const  ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
         ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
            sipName_family,
            sipName_style,
            sipName_weight,
            sipName_underline,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1EEE|bJ1E", sipType_wxSize, &pixelSize, &pixelSizeState, sipType_wxFontFamily, &family, sipType_wxFontStyle, &style, sipType_wxFontWeight, &weight, &underline, sipType_wxString,&faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
             ::wxFont*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFont::New(*pixelSize,family,style,weight,underline,*faceName,encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize),sipType_wxSize,pixelSizeState);
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    {
        const  ::wxSize* pixelSize;
        int pixelSizeState = 0;
         ::wxFontFamily family;
        int flags = wxFONTFLAG_DEFAULT;
        const  ::wxString& faceNamedef = wxEmptyString;
        const  ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
         ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
            sipName_family,
            sipName_flags,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1E|iJ1E", sipType_wxSize, &pixelSize, &pixelSizeState, sipType_wxFontFamily, &family, &flags, sipType_wxString,&faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {
             ::wxFont*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFont::New(*pixelSize,family,flags,*faceName,encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize),sipType_wxSize,pixelSizeState);
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    {
        const  ::wxNativeFontInfo* nativeInfo;

        static const char *sipKwdList[] = {
            sipName_nativeInfo,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J9", sipType_wxNativeFontInfo, &nativeInfo))
        {
             ::wxFont*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFont::New(*nativeInfo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    {
        const  ::wxString* nativeInfoString;
        int nativeInfoStringState = 0;

        static const char *sipKwdList[] = {
            sipName_nativeInfoString,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&nativeInfoString, &nativeInfoStringState))
        {
             ::wxFont*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFont::New(*nativeInfoString);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(nativeInfoString),sipType_wxString,nativeInfoStringState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_New, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetDefaultEncoding, "GetDefaultEncoding() -> FontEncoding\n"
"\n"
"Returns the current application's default encoding.");

extern "C" {static PyObject *meth_wxFont_GetDefaultEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetDefaultEncoding(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxFontEncoding sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFont::GetDefaultEncoding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontEncoding);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetDefaultEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_SetDefaultEncoding, "SetDefaultEncoding(encoding)\n"
"\n"
"Sets the default font encoding.");

extern "C" {static PyObject *meth_wxFont_SetDefaultEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont_SetDefaultEncoding(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontEncoding encoding;

        static const char *sipKwdList[] = {
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E", sipType_wxFontEncoding, &encoding))
        {

        if (!wxPyCheckForApp()) return NULL;
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxFont::SetDefaultEncoding(encoding);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_SetDefaultEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetHFONT, "GetHFONT() -> void\n"
"\n"
"Returns the font's native handle.");

extern "C" {static PyObject *meth_wxFont_GetHFONT(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetHFONT(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            void*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont_GetHFONT(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetHFONT, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_OSXGetCGFont, "OSXGetCGFont() -> void\n"
"\n"
"Returns the font's native handle.");

extern "C" {static PyObject *meth_wxFont_OSXGetCGFont(PyObject *, PyObject *);}
static PyObject *meth_wxFont_OSXGetCGFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            void*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont_OSXGetCGFont(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_OSXGetCGFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont_GetPangoFontDescription, "GetPangoFontDescription() -> void\n"
"\n"
"Returns the font's native handle.");

extern "C" {static PyObject *meth_wxFont_GetPangoFontDescription(PyObject *, PyObject *);}
static PyObject *meth_wxFont_GetPangoFontDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFont, &sipCpp))
        {
            void*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont_GetPangoFontDescription(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName_GetPangoFontDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFont__copyFrom, "_copyFrom(other)\n"
"\n"
"For internal use only.");

extern "C" {static PyObject *meth_wxFont__copyFrom(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFont__copyFrom(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* other;
         ::wxFont *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxFont, &sipCpp, sipType_wxFont, &other))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxFont__copyFrom(sipCpp, other);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Font, sipName__copyFrom, NULL);

    return NULL;
}


extern "C" {static int slot_wxFont___nonzero__(PyObject *);}
static int slot_wxFont___nonzero__(PyObject *sipSelf)
{
     ::wxFont *sipCpp = reinterpret_cast< ::wxFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxFont));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFont___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxFont___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxFont___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxFont *sipCpp = reinterpret_cast< ::wxFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxFont));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxFont, &font))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxFont::operator==(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxFont, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxFont___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxFont___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxFont *sipCpp = reinterpret_cast< ::wxFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxFont));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxFont, &font))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxFont::operator!=(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxFont, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFont(void *, const sipTypeDef *);}
static void *cast_wxFont(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFont *sipCpp = reinterpret_cast< ::wxFont *>(sipCppV);

    if (targetType == sipType_wxGDIObject)
        return static_cast< ::wxGDIObject *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFont(void *, int);}
static void release_wxFont(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxFont *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxFont(void *, SIP_SSIZE_T, void *);}
static void assign_wxFont(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxFont *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxFont *>(sipSrc);
}


extern "C" {static void *array_wxFont(SIP_SSIZE_T);}
static void *array_wxFont(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxFont[sipNrElem];
}


extern "C" {static void *copy_wxFont(const void *, SIP_SSIZE_T);}
static void *copy_wxFont(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxFont(reinterpret_cast<const  ::wxFont *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxFont(sipSimpleWrapper *);}
static void dealloc_wxFont(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFont(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxFont(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFont(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxFont *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFont();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxFont* font;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxFont, &font))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxFontInfo* fontInfo;

        static const char *sipKwdList[] = {
            sipName_fontInfo,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxFontInfo, &fontInfo))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFont(*fontInfo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        int pointSize;
         ::wxFontFamily family;
         ::wxFontStyle style;
         ::wxFontWeight weight;
        bool underline = 0;
        const  ::wxString& faceNamedef = wxEmptyString;
        const  ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
         ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pointSize,
            sipName_family,
            sipName_style,
            sipName_weight,
            sipName_underline,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iEEE|bJ1E", &pointSize, sipType_wxFontFamily, &family, sipType_wxFontStyle, &style, sipType_wxFontWeight, &weight, &underline, sipType_wxString,&faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFont(pointSize,family,style,weight,underline,*faceName,encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxSize* pixelSize;
        int pixelSizeState = 0;
         ::wxFontFamily family;
         ::wxFontStyle style;
         ::wxFontWeight weight;
        bool underline = 0;
        const  ::wxString& faceNamedef = wxEmptyString;
        const  ::wxString* faceName = &faceNamedef;
        int faceNameState = 0;
         ::wxFontEncoding encoding = wxFONTENCODING_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
            sipName_family,
            sipName_style,
            sipName_weight,
            sipName_underline,
            sipName_faceName,
            sipName_encoding,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1EEE|bJ1E", sipType_wxSize, &pixelSize, &pixelSizeState, sipType_wxFontFamily, &family, sipType_wxFontStyle, &style, sipType_wxFontWeight, &weight, &underline, sipType_wxString,&faceName, &faceNameState, sipType_wxFontEncoding, &encoding))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFont(*pixelSize,family,style,weight,underline,*faceName,encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize),sipType_wxSize,pixelSizeState);
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxString* nativeInfoString;
        int nativeInfoStringState = 0;

        static const char *sipKwdList[] = {
            sipName_nativeInfoString,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxString,&nativeInfoString, &nativeInfoStringState))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFont(*nativeInfoString);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(nativeInfoString),sipType_wxString,nativeInfoStringState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxNativeFontInfo* nativeInfo;

        static const char *sipKwdList[] = {
            sipName_nativeInfo,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxNativeFontInfo, &nativeInfo))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFont(*nativeInfo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFont[] = {{199, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxFont[] = {
    {(void *)slot_wxFont___nonzero__, bool_slot},
    {(void *)slot_wxFont___eq__, eq_slot},
    {(void *)slot_wxFont___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxFont[] = {
    {SIP_MLNAME_CAST(sipName_Bold), meth_wxFont_Bold, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_Bold)},
    {SIP_MLNAME_CAST(sipName_GetDefaultEncoding), meth_wxFont_GetDefaultEncoding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetDefaultEncoding)},
    {SIP_MLNAME_CAST(sipName_GetEncoding), meth_wxFont_GetEncoding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetEncoding)},
    {SIP_MLNAME_CAST(sipName_GetFaceName), meth_wxFont_GetFaceName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetFaceName)},
    {SIP_MLNAME_CAST(sipName_GetFamily), meth_wxFont_GetFamily, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetFamily)},
    {SIP_MLNAME_CAST(sipName_GetHFONT), meth_wxFont_GetHFONT, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetHFONT)},
    {SIP_MLNAME_CAST(sipName_GetNativeFontInfo), meth_wxFont_GetNativeFontInfo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetNativeFontInfo)},
    {SIP_MLNAME_CAST(sipName_GetNativeFontInfoDesc), meth_wxFont_GetNativeFontInfoDesc, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetNativeFontInfoDesc)},
    {SIP_MLNAME_CAST(sipName_GetNativeFontInfoUserDesc), meth_wxFont_GetNativeFontInfoUserDesc, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetNativeFontInfoUserDesc)},
    {SIP_MLNAME_CAST(sipName_GetPangoFontDescription), meth_wxFont_GetPangoFontDescription, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetPangoFontDescription)},
    {SIP_MLNAME_CAST(sipName_GetPixelSize), meth_wxFont_GetPixelSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetPixelSize)},
    {SIP_MLNAME_CAST(sipName_GetPointSize), meth_wxFont_GetPointSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetPointSize)},
    {SIP_MLNAME_CAST(sipName_GetStrikethrough), meth_wxFont_GetStrikethrough, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetStrikethrough)},
    {SIP_MLNAME_CAST(sipName_GetStyle), meth_wxFont_GetStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetStyle)},
    {SIP_MLNAME_CAST(sipName_GetUnderlined), meth_wxFont_GetUnderlined, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetUnderlined)},
    {SIP_MLNAME_CAST(sipName_GetWeight), meth_wxFont_GetWeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_GetWeight)},
    {SIP_MLNAME_CAST(sipName_IsFixedWidth), meth_wxFont_IsFixedWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_IsFixedWidth)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxFont_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_IsOk)},
    {SIP_MLNAME_CAST(sipName_Italic), meth_wxFont_Italic, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_Italic)},
    {SIP_MLNAME_CAST(sipName_Larger), meth_wxFont_Larger, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_Larger)},
    {SIP_MLNAME_CAST(sipName_MakeBold), meth_wxFont_MakeBold, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_MakeBold)},
    {SIP_MLNAME_CAST(sipName_MakeItalic), meth_wxFont_MakeItalic, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_MakeItalic)},
    {SIP_MLNAME_CAST(sipName_MakeLarger), meth_wxFont_MakeLarger, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_MakeLarger)},
    {SIP_MLNAME_CAST(sipName_MakeSmaller), meth_wxFont_MakeSmaller, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_MakeSmaller)},
    {SIP_MLNAME_CAST(sipName_MakeStrikethrough), meth_wxFont_MakeStrikethrough, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_MakeStrikethrough)},
    {SIP_MLNAME_CAST(sipName_MakeUnderlined), meth_wxFont_MakeUnderlined, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_MakeUnderlined)},
    {SIP_MLNAME_CAST(sipName_New), (PyCFunction)meth_wxFont_New, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_New)},
    {SIP_MLNAME_CAST(sipName_OSXGetCGFont), meth_wxFont_OSXGetCGFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_OSXGetCGFont)},
    {SIP_MLNAME_CAST(sipName_Scale), (PyCFunction)meth_wxFont_Scale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_Scale)},
    {SIP_MLNAME_CAST(sipName_Scaled), (PyCFunction)meth_wxFont_Scaled, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_Scaled)},
    {SIP_MLNAME_CAST(sipName_SetDefaultEncoding), (PyCFunction)meth_wxFont_SetDefaultEncoding, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetDefaultEncoding)},
    {SIP_MLNAME_CAST(sipName_SetEncoding), (PyCFunction)meth_wxFont_SetEncoding, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetEncoding)},
    {SIP_MLNAME_CAST(sipName_SetFaceName), (PyCFunction)meth_wxFont_SetFaceName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetFaceName)},
    {SIP_MLNAME_CAST(sipName_SetFamily), (PyCFunction)meth_wxFont_SetFamily, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetFamily)},
    {SIP_MLNAME_CAST(sipName_SetNativeFontInfo), (PyCFunction)meth_wxFont_SetNativeFontInfo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetNativeFontInfo)},
    {SIP_MLNAME_CAST(sipName_SetNativeFontInfoUserDesc), (PyCFunction)meth_wxFont_SetNativeFontInfoUserDesc, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetNativeFontInfoUserDesc)},
    {SIP_MLNAME_CAST(sipName_SetPixelSize), (PyCFunction)meth_wxFont_SetPixelSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetPixelSize)},
    {SIP_MLNAME_CAST(sipName_SetPointSize), (PyCFunction)meth_wxFont_SetPointSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetPointSize)},
    {SIP_MLNAME_CAST(sipName_SetStrikethrough), (PyCFunction)meth_wxFont_SetStrikethrough, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetStrikethrough)},
    {SIP_MLNAME_CAST(sipName_SetStyle), (PyCFunction)meth_wxFont_SetStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetStyle)},
    {SIP_MLNAME_CAST(sipName_SetSymbolicSize), (PyCFunction)meth_wxFont_SetSymbolicSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetSymbolicSize)},
    {SIP_MLNAME_CAST(sipName_SetSymbolicSizeRelativeTo), (PyCFunction)meth_wxFont_SetSymbolicSizeRelativeTo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetSymbolicSizeRelativeTo)},
    {SIP_MLNAME_CAST(sipName_SetUnderlined), (PyCFunction)meth_wxFont_SetUnderlined, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetUnderlined)},
    {SIP_MLNAME_CAST(sipName_SetWeight), (PyCFunction)meth_wxFont_SetWeight, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont_SetWeight)},
    {SIP_MLNAME_CAST(sipName_Smaller), meth_wxFont_Smaller, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_Smaller)},
    {SIP_MLNAME_CAST(sipName_Strikethrough), meth_wxFont_Strikethrough, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_Strikethrough)},
    {SIP_MLNAME_CAST(sipName_Underlined), meth_wxFont_Underlined, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFont_Underlined)},
    {SIP_MLNAME_CAST(sipName__copyFrom), (PyCFunction)meth_wxFont__copyFrom, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFont__copyFrom)}
};

sipVariableDef variables_wxFont[] = {
    {PropertyVariable, sipName_Weight, &methods_wxFont[15], &methods_wxFont[43], NULL, NULL},
    {PropertyVariable, sipName_Style, &methods_wxFont[13], &methods_wxFont[39], NULL, NULL},
    {PropertyVariable, sipName_PixelSize, &methods_wxFont[10], &methods_wxFont[36], NULL, NULL},
    {PropertyVariable, sipName_PointSize, &methods_wxFont[11], &methods_wxFont[37], NULL, NULL},
    {PropertyVariable, sipName_NativeFontInfoUserDesc, &methods_wxFont[8], &methods_wxFont[35], NULL, NULL},
    {PropertyVariable, sipName_NativeFontInfoDesc, &methods_wxFont[7], &methods_wxFont[34], NULL, NULL},
    {PropertyVariable, sipName_Family, &methods_wxFont[4], &methods_wxFont[33], NULL, NULL},
    {PropertyVariable, sipName_FaceName, &methods_wxFont[3], &methods_wxFont[32], NULL, NULL},
    {PropertyVariable, sipName_Encoding, &methods_wxFont[2], &methods_wxFont[31], NULL, NULL},
};

PyDoc_STRVAR(doc_wxFont, "Font()\n"
"Font(font)\n"
"Font(fontInfo)\n"
"Font(pointSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)\n"
"Font(pixelSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)\n"
"Font(nativeInfoString)\n"
"Font(nativeInfo)\n"
"\n"
"A font is an object which determines the appearance of text.");


sipClassTypeDef sipTypeDef__core_wxFont = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFont,
        {0},
        0
    },
    {
        sipNameNr_Font,
        {0, 0, 1},
        48, methods_wxFont,
        0, 0,
        9, variables_wxFont,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFont,
    -1,
    -1,
    supers_wxFont,
    slots_wxFont,
    init_type_wxFont,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFont,
    assign_wxFont,
    array_wxFont,
    copy_wxFont,
    release_wxFont,
    cast_wxFont,
    0,
    0,
    0,
    0,
    0,
    0
};
