/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/fontdata.h>

        #include <wx/font.h>
        #include <wx/colour.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxFontData_EnableEffects, "EnableEffects(enable)\n"
"\n"
"Enables or disables \"effects\" under Windows or generic only.");

extern "C" {static PyObject *meth_wxFontData_EnableEffects(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_EnableEffects(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool enable;
         ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxFontData, &sipCpp, &enable))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnableEffects(enable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_EnableEffects, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_GetAllowSymbols, "GetAllowSymbols() -> bool\n"
"\n"
"Under Windows, returns a flag determining whether symbol fonts can be\n"
"selected.");

extern "C" {static PyObject *meth_wxFontData_GetAllowSymbols(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetAllowSymbols(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAllowSymbols();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetAllowSymbols, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_GetChosenFont, "GetChosenFont() -> Font\n"
"\n"
"Gets the font chosen by the user if the user pressed OK\n"
"(wxFontDialog::ShowModal() returned wxID_OK).");

extern "C" {static PyObject *meth_wxFontData_GetChosenFont(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetChosenFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->GetChosenFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetChosenFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_GetColour, "GetColour() -> Colour\n"
"\n"
"Gets the colour associated with the font dialog.");

extern "C" {static PyObject *meth_wxFontData_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_GetEnableEffects, "GetEnableEffects() -> bool\n"
"\n"
"Determines whether \"effects\" are enabled under Windows.");

extern "C" {static PyObject *meth_wxFontData_GetEnableEffects(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetEnableEffects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEnableEffects();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetEnableEffects, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_GetInitialFont, "GetInitialFont() -> Font\n"
"\n"
"Gets the font that will be initially used by the font dialog.");

extern "C" {static PyObject *meth_wxFontData_GetInitialFont(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetInitialFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->GetInitialFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetInitialFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_GetShowHelp, "GetShowHelp() -> bool\n"
"\n"
"Returns true if the Help button will be shown (Windows only).");

extern "C" {static PyObject *meth_wxFontData_GetShowHelp(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetShowHelp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetShowHelp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetShowHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_SetAllowSymbols, "SetAllowSymbols(allowSymbols)\n"
"\n"
"Under Windows, determines whether symbol fonts can be selected.");

extern "C" {static PyObject *meth_wxFontData_SetAllowSymbols(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetAllowSymbols(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool allowSymbols;
         ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_allowSymbols,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxFontData, &sipCpp, &allowSymbols))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAllowSymbols(allowSymbols);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetAllowSymbols, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_SetChosenFont, "SetChosenFont(font)\n"
"\n"
"Sets the font that will be returned to the user (for internal use\n"
"only).");

extern "C" {static PyObject *meth_wxFontData_SetChosenFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetChosenFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
         ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxFontData, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetChosenFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetChosenFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_SetColour, "SetColour(colour)\n"
"\n"
"Sets the colour that will be used for the font foreground colour.");

extern "C" {static PyObject *meth_wxFontData_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFontData, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_SetInitialFont, "SetInitialFont(font)\n"
"\n"
"Sets the font that will be initially used by the font dialog.");

extern "C" {static PyObject *meth_wxFontData_SetInitialFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetInitialFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
         ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxFontData, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetInitialFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetInitialFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_SetRange, "SetRange(min, max)\n"
"\n"
"Sets the valid range for the font point size (Windows only).");

extern "C" {static PyObject *meth_wxFontData_SetRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int min;
        int max;
         ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_min,
            sipName_max,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxFontData, &sipCpp, &min, &max))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRange(min,max);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetRange, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontData_SetShowHelp, "SetShowHelp(showHelp)\n"
"\n"
"Determines whether the Help button will be displayed in the font\n"
"dialog (Windows only).");

extern "C" {static PyObject *meth_wxFontData_SetShowHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetShowHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool showHelp;
         ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_showHelp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxFontData, &sipCpp, &showHelp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetShowHelp(showHelp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetShowHelp, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFontData(void *, const sipTypeDef *);}
static void *cast_wxFontData(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFontData *sipCpp = reinterpret_cast< ::wxFontData *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFontData(void *, int);}
static void release_wxFontData(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxFontData *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxFontData(void *, SIP_SSIZE_T, void *);}
static void assign_wxFontData(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxFontData *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxFontData *>(sipSrc);
}


extern "C" {static void *array_wxFontData(SIP_SSIZE_T);}
static void *array_wxFontData(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxFontData[sipNrElem];
}


extern "C" {static void *copy_wxFontData(const void *, SIP_SSIZE_T);}
static void *copy_wxFontData(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxFontData(reinterpret_cast<const  ::wxFontData *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxFontData(sipSimpleWrapper *);}
static void dealloc_wxFontData(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFontData(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxFontData(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFontData(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxFontData *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFontData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxFontData* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxFontData, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFontData(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFontData[] = {{348, 255, 1}};


static PyMethodDef methods_wxFontData[] = {
    {SIP_MLNAME_CAST(sipName_EnableEffects), (PyCFunction)meth_wxFontData_EnableEffects, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontData_EnableEffects)},
    {SIP_MLNAME_CAST(sipName_GetAllowSymbols), meth_wxFontData_GetAllowSymbols, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFontData_GetAllowSymbols)},
    {SIP_MLNAME_CAST(sipName_GetChosenFont), meth_wxFontData_GetChosenFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFontData_GetChosenFont)},
    {SIP_MLNAME_CAST(sipName_GetColour), meth_wxFontData_GetColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFontData_GetColour)},
    {SIP_MLNAME_CAST(sipName_GetEnableEffects), meth_wxFontData_GetEnableEffects, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFontData_GetEnableEffects)},
    {SIP_MLNAME_CAST(sipName_GetInitialFont), meth_wxFontData_GetInitialFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFontData_GetInitialFont)},
    {SIP_MLNAME_CAST(sipName_GetShowHelp), meth_wxFontData_GetShowHelp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFontData_GetShowHelp)},
    {SIP_MLNAME_CAST(sipName_SetAllowSymbols), (PyCFunction)meth_wxFontData_SetAllowSymbols, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontData_SetAllowSymbols)},
    {SIP_MLNAME_CAST(sipName_SetChosenFont), (PyCFunction)meth_wxFontData_SetChosenFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontData_SetChosenFont)},
    {SIP_MLNAME_CAST(sipName_SetColour), (PyCFunction)meth_wxFontData_SetColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontData_SetColour)},
    {SIP_MLNAME_CAST(sipName_SetInitialFont), (PyCFunction)meth_wxFontData_SetInitialFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontData_SetInitialFont)},
    {SIP_MLNAME_CAST(sipName_SetRange), (PyCFunction)meth_wxFontData_SetRange, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontData_SetRange)},
    {SIP_MLNAME_CAST(sipName_SetShowHelp), (PyCFunction)meth_wxFontData_SetShowHelp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontData_SetShowHelp)}
};

sipVariableDef variables_wxFontData[] = {
    {PropertyVariable, sipName_ShowHelp, &methods_wxFontData[6], &methods_wxFontData[12], NULL, NULL},
    {PropertyVariable, sipName_InitialFont, &methods_wxFontData[5], &methods_wxFontData[10], NULL, NULL},
    {PropertyVariable, sipName_Colour, &methods_wxFontData[3], &methods_wxFontData[9], NULL, NULL},
    {PropertyVariable, sipName_ChosenFont, &methods_wxFontData[2], &methods_wxFontData[8], NULL, NULL},
    {PropertyVariable, sipName_AllowSymbols, &methods_wxFontData[1], &methods_wxFontData[7], NULL, NULL},
};

PyDoc_STRVAR(doc_wxFontData, "FontData()\n"
"\n"
"This class holds a variety of information related to font dialogs.");


sipClassTypeDef sipTypeDef__core_wxFontData = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFontData,
        {0},
        0
    },
    {
        sipNameNr_FontData,
        {0, 0, 1},
        13, methods_wxFontData,
        0, 0,
        5, variables_wxFontData,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFontData,
    -1,
    -1,
    supers_wxFontData,
    0,
    init_type_wxFontData,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFontData,
    assign_wxFontData,
    array_wxFontData,
    copy_wxFontData,
    release_wxFontData,
    cast_wxFontData,
    0,
    0,
    0,
    0,
    0,
    0
};
