/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/iconbndl.h>

        #include <wx/stream.h>
        #include <wx/icon.h>
    #include <wxpy_api.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxIconBundle : public  ::wxIconBundle
{
public:
    sipwxIconBundle();
    sipwxIconBundle(const  ::wxString&, ::wxBitmapType);
    sipwxIconBundle( ::wxInputStream&, ::wxBitmapType);
    sipwxIconBundle(const  ::wxIcon&);
    sipwxIconBundle(const  ::wxIconBundle&);
    ~sipwxIconBundle();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxIconBundle(const sipwxIconBundle &);
    sipwxIconBundle &operator = (const sipwxIconBundle &);
};

sipwxIconBundle::sipwxIconBundle():  ::wxIconBundle(), sipPySelf(0)
{
}

sipwxIconBundle::sipwxIconBundle(const  ::wxString& file, ::wxBitmapType type):  ::wxIconBundle(file,type), sipPySelf(0)
{
}

sipwxIconBundle::sipwxIconBundle( ::wxInputStream& stream, ::wxBitmapType type):  ::wxIconBundle(stream,type), sipPySelf(0)
{
}

sipwxIconBundle::sipwxIconBundle(const  ::wxIcon& icon):  ::wxIconBundle(icon), sipPySelf(0)
{
}

sipwxIconBundle::sipwxIconBundle(const  ::wxIconBundle& ic):  ::wxIconBundle(ic), sipPySelf(0)
{
}

sipwxIconBundle::~sipwxIconBundle()
{
    sipInstanceDestroyed(sipPySelf);
}


PyDoc_STRVAR(doc_wxIconBundle_AddIcon, "AddIcon(file, type=BITMAP_TYPE_ANY)\n"
"AddIcon(stream, type=BITMAP_TYPE_ANY)\n"
"AddIcon(icon)\n"
"\n"
"Adds all the icons contained in the file to the bundle; if the\n"
"collection already contains icons with the same width and height, they\n"
"are replaced by the new ones.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxIconBundle_AddIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIconBundle_AddIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* file;
        int fileState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
         ::wxIconBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|E", &sipSelf, sipType_wxIconBundle, &sipCpp, sipType_wxString,&file, &fileState, sipType_wxBitmapType, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddIcon(*file,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(file),sipType_wxString,fileState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
         ::wxIconBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|E", &sipSelf, sipType_wxIconBundle, &sipCpp, sipType_wxInputStream, &stream, &streamState, sipType_wxBitmapType, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddIcon(*stream,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxIcon* icon;
         ::wxIconBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxIconBundle, &sipCpp, sipType_wxIcon, &icon))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddIcon(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_IconBundle, sipName_AddIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxIconBundle_GetIcon, "GetIcon(size, flags=FALLBACK_SYSTEM) -> Icon\n"
"GetIcon(size=DefaultCoord, flags=FALLBACK_SYSTEM) -> Icon\n"
"\n"
"Returns the icon with the given size.\n"
"");

extern "C" {static PyObject *meth_wxIconBundle_GetIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIconBundle_GetIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* size;
        int sizeState = 0;
        int flags =  ::wxIconBundle::FALLBACK_SYSTEM;
        const  ::wxIconBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxIconBundle, &sipCpp, sipType_wxSize, &size, &sizeState, &flags))
        {
             ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxIcon(sipCpp->GetIcon(*size,flags));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxIcon,NULL);
        }
    }

    {
         ::wxCoord size = wxDefaultCoord;
        int flags =  ::wxIconBundle::FALLBACK_SYSTEM;
        const  ::wxIconBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|ii", &sipSelf, sipType_wxIconBundle, &sipCpp, &size, &flags))
        {
             ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxIcon(sipCpp->GetIcon(size,flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxIcon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_IconBundle, sipName_GetIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxIconBundle_GetIconOfExactSize, "GetIconOfExactSize(size) -> Icon\n"
"\n"
"Returns the icon with exactly the given size or wxNullIcon if this\n"
"size is not available.");

extern "C" {static PyObject *meth_wxIconBundle_GetIconOfExactSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIconBundle_GetIconOfExactSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* size;
        int sizeState = 0;
        const  ::wxIconBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxIconBundle, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
             ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxIcon(sipCpp->GetIconOfExactSize(*size));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxIcon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_IconBundle, sipName_GetIconOfExactSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxIconBundle_GetIconCount, "GetIconCount() -> size_t\n"
"\n"
"return the number of available icons");

extern "C" {static PyObject *meth_wxIconBundle_GetIconCount(PyObject *, PyObject *);}
static PyObject *meth_wxIconBundle_GetIconCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxIconBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIconBundle, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetIconCount());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_IconBundle, sipName_GetIconCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxIconBundle_GetIconByIndex, "GetIconByIndex(n) -> Icon\n"
"\n"
"return the icon at index (must be < GetIconCount())");

extern "C" {static PyObject *meth_wxIconBundle_GetIconByIndex(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIconBundle_GetIconByIndex(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* n;
        int nState = 0;
        const  ::wxIconBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxIconBundle, &sipCpp, sipType_size_t,&n, &nState))
        {
             ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxIcon(sipCpp->GetIconByIndex(*n));
            Py_END_ALLOW_THREADS
            sipReleaseType(n,sipType_size_t,nState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxIcon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_IconBundle, sipName_GetIconByIndex, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxIconBundle_IsEmpty, "IsEmpty() -> bool\n"
"\n"
"Returns true if the bundle doesn't contain any icons, false otherwise\n"
"(in which case a call to GetIcon() with default parameter should\n"
"return a valid icon).");

extern "C" {static PyObject *meth_wxIconBundle_IsEmpty(PyObject *, PyObject *);}
static PyObject *meth_wxIconBundle_IsEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxIconBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIconBundle, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEmpty();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_IconBundle, sipName_IsEmpty, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxIconBundle(void *, const sipTypeDef *);}
static void *cast_wxIconBundle(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxIconBundle *sipCpp = reinterpret_cast< ::wxIconBundle *>(sipCppV);

    if (targetType == sipType_wxGDIObject)
        return static_cast< ::wxGDIObject *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxIconBundle(void *, int);}
static void release_wxIconBundle(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxIconBundle *>(sipCppV);
    else
        delete reinterpret_cast< ::wxIconBundle *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxIconBundle(void *, SIP_SSIZE_T, void *);}
static void assign_wxIconBundle(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxIconBundle *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxIconBundle *>(sipSrc);
}


extern "C" {static void *array_wxIconBundle(SIP_SSIZE_T);}
static void *array_wxIconBundle(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxIconBundle[sipNrElem];
}


extern "C" {static void *copy_wxIconBundle(const void *, SIP_SSIZE_T);}
static void *copy_wxIconBundle(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxIconBundle(reinterpret_cast<const  ::wxIconBundle *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxIconBundle(sipSimpleWrapper *);}
static void dealloc_wxIconBundle(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxIconBundle *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxIconBundle(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxIconBundle(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxIconBundle(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxIconBundle *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxIconBundle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxString* file;
        int fileState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;

        static const char *sipKwdList[] = {
            sipName_file,
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|E", sipType_wxString,&file, &fileState, sipType_wxBitmapType, &type))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxIconBundle(*file,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(file),sipType_wxString,fileState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|E", sipType_wxInputStream, &stream, &streamState, sipType_wxBitmapType, &type))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxIconBundle(*stream,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxIcon* icon;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxIcon, &icon))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxIconBundle(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxIconBundle* ic;

        static const char *sipKwdList[] = {
            sipName_ic,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxIconBundle, &ic))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxIconBundle(*ic);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxIconBundle[] = {{199, 255, 1}};


static PyMethodDef methods_wxIconBundle[] = {
    {SIP_MLNAME_CAST(sipName_AddIcon), (PyCFunction)meth_wxIconBundle_AddIcon, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIconBundle_AddIcon)},
    {SIP_MLNAME_CAST(sipName_GetIcon), (PyCFunction)meth_wxIconBundle_GetIcon, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIconBundle_GetIcon)},
    {SIP_MLNAME_CAST(sipName_GetIconByIndex), (PyCFunction)meth_wxIconBundle_GetIconByIndex, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIconBundle_GetIconByIndex)},
    {SIP_MLNAME_CAST(sipName_GetIconCount), meth_wxIconBundle_GetIconCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxIconBundle_GetIconCount)},
    {SIP_MLNAME_CAST(sipName_GetIconOfExactSize), (PyCFunction)meth_wxIconBundle_GetIconOfExactSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIconBundle_GetIconOfExactSize)},
    {SIP_MLNAME_CAST(sipName_IsEmpty), meth_wxIconBundle_IsEmpty, METH_VARARGS, SIP_MLDOC_CAST(doc_wxIconBundle_IsEmpty)}
};

static sipEnumMemberDef enummembers_wxIconBundle[] = {
    {sipName_FALLBACK_NEAREST_LARGER, static_cast<int>( ::wxIconBundle::FALLBACK_NEAREST_LARGER), -1},
    {sipName_FALLBACK_NONE, static_cast<int>( ::wxIconBundle::FALLBACK_NONE), -1},
    {sipName_FALLBACK_SYSTEM, static_cast<int>( ::wxIconBundle::FALLBACK_SYSTEM), -1},
};

sipVariableDef variables_wxIconBundle[] = {
    {PropertyVariable, sipName_IconCount, &methods_wxIconBundle[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_Icon, &methods_wxIconBundle[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxIconBundle, "IconBundle()\n"
"IconBundle(file, type=BITMAP_TYPE_ANY)\n"
"IconBundle(stream, type=BITMAP_TYPE_ANY)\n"
"IconBundle(icon)\n"
"IconBundle(ic)\n"
"\n"
"This class contains multiple copies of an icon in different sizes.");


sipClassTypeDef sipTypeDef__core_wxIconBundle = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxIconBundle,
        {0},
        0
    },
    {
        sipNameNr_IconBundle,
        {0, 0, 1},
        6, methods_wxIconBundle,
        3, enummembers_wxIconBundle,
        2, variables_wxIconBundle,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxIconBundle,
    -1,
    -1,
    supers_wxIconBundle,
    0,
    init_type_wxIconBundle,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxIconBundle,
    assign_wxIconBundle,
    array_wxIconBundle,
    copy_wxIconBundle,
    release_wxIconBundle,
    cast_wxIconBundle,
    0,
    0,
    0,
    0,
    0,
    0
};
