/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/image.h>

        #include <wx/stream.h>
        #include <wx/image.h>
        #include <wx/stream.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxImageHandler : public  ::wxImageHandler
{
public:
    sipwxImageHandler();
    virtual ~sipwxImageHandler();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    int sipProtectVirt_DoGetImageCount(bool, ::wxInputStream&);
    bool sipProtect_DoCanRead( ::wxInputStream&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool DoCanRead( ::wxInputStream&);
    int DoGetImageCount( ::wxInputStream&);
    bool SaveFile( ::wxImage*, ::wxOutputStream&,bool);
    bool LoadFile( ::wxImage*, ::wxInputStream&,bool,int);
    int GetImageCount( ::wxInputStream&);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxImageHandler(const sipwxImageHandler &);
    sipwxImageHandler &operator = (const sipwxImageHandler &);

    char sipPyMethods[5];
};

sipwxImageHandler::sipwxImageHandler():  ::wxImageHandler(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImageHandler::~sipwxImageHandler()
{
    sipInstanceDestroyed(sipPySelf);
}

bool sipwxImageHandler::DoCanRead( ::wxInputStream& stream)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,sipName_ImageHandler,sipName_DoCanRead);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_26(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxInputStream&);

    return sipVH__core_26(sipGILState, 0, sipPySelf, sipMeth, stream);
}

int sipwxImageHandler::DoGetImageCount( ::wxInputStream& stream)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_DoGetImageCount);

    if (!sipMeth)
        return  ::wxImageHandler::DoGetImageCount(stream);

    extern int sipVH__core_23(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxInputStream&);

    return sipVH__core_23(sipGILState, 0, sipPySelf, sipMeth, stream);
}

bool sipwxImageHandler::SaveFile( ::wxImage*image, ::wxOutputStream& stream,bool verbose)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_SaveFile);

    if (!sipMeth)
        return  ::wxImageHandler::SaveFile(image,stream,verbose);

    extern bool sipVH__core_25(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxImage*, ::wxOutputStream&,bool);

    return sipVH__core_25(sipGILState, 0, sipPySelf, sipMeth, image, stream, verbose);
}

bool sipwxImageHandler::LoadFile( ::wxImage*image, ::wxInputStream& stream,bool verbose,int index)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_LoadFile);

    if (!sipMeth)
        return  ::wxImageHandler::LoadFile(image,stream,verbose,index);

    extern bool sipVH__core_24(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxImage*, ::wxInputStream&,bool,int);

    return sipVH__core_24(sipGILState, 0, sipPySelf, sipMeth, image, stream, verbose, index);
}

int sipwxImageHandler::GetImageCount( ::wxInputStream& stream)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[4],sipPySelf,NULL,sipName_GetImageCount);

    if (!sipMeth)
        return  ::wxImageHandler::GetImageCount(stream);

    extern int sipVH__core_23(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxInputStream&);

    return sipVH__core_23(sipGILState, 0, sipPySelf, sipMeth, stream);
}

int sipwxImageHandler::sipProtectVirt_DoGetImageCount(bool sipSelfWasArg, ::wxInputStream& stream)
{
    return (sipSelfWasArg ?  ::wxImageHandler::DoGetImageCount(stream) : DoGetImageCount(stream));
}

bool sipwxImageHandler::sipProtect_DoCanRead( ::wxInputStream& stream)
{
    return DoCanRead(stream);
}


PyDoc_STRVAR(doc_wxImageHandler_CanRead, "CanRead(stream) -> bool\n"
"CanRead(filename) -> bool\n"
"\n"
"Returns true if this handler supports the image format contained in\n"
"the given stream.\n"
"");

extern "C" {static PyObject *meth_wxImageHandler_CanRead(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_CanRead(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxInputStream, &stream, &streamState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanRead(*stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* filename;
        int filenameState = 0;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxString,&filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanRead(*filename);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_CanRead, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_GetExtension, "GetExtension() -> String\n"
"\n"
"Gets the preferred file extension associated with this handler.");

extern "C" {static PyObject *meth_wxImageHandler_GetExtension(PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_GetExtension(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImageHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageHandler, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetExtension());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_GetExtension, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_GetAltExtensions, "GetAltExtensions() -> ArrayString\n"
"\n"
"Returns the other file extensions associated with this handler.");

extern "C" {static PyObject *meth_wxImageHandler_GetAltExtensions(PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_GetAltExtensions(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImageHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageHandler, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetAltExtensions());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_GetAltExtensions, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_GetImageCount, "GetImageCount(stream) -> int\n"
"\n"
"If the image file contains more than one image and the image handler\n"
"is capable of retrieving these individually, this function will return\n"
"the number of available images.");

extern "C" {static PyObject *meth_wxImageHandler_GetImageCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_GetImageCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxInputStream, &stream, &streamState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImageHandler::GetImageCount(*stream) : sipCpp->GetImageCount(*stream));
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_GetImageCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_GetMimeType, "GetMimeType() -> String\n"
"\n"
"Gets the MIME type associated with this handler.");

extern "C" {static PyObject *meth_wxImageHandler_GetMimeType(PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_GetMimeType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImageHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageHandler, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetMimeType());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_GetMimeType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_GetName, "GetName() -> String\n"
"\n"
"Gets the name of this handler.");

extern "C" {static PyObject *meth_wxImageHandler_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImageHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageHandler, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_GetType, "GetType() -> BitmapType\n"
"\n"
"Gets the image type associated with this handler.");

extern "C" {static PyObject *meth_wxImageHandler_GetType(PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_GetType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImageHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageHandler, &sipCpp))
        {
             ::wxBitmapType sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxBitmapType);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_GetType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_LoadFile, "LoadFile(image, stream, verbose=True, index=-1) -> bool\n"
"\n"
"Loads a image from a stream, putting the resulting data into image.");

extern "C" {static PyObject *meth_wxImageHandler_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxImage* image;
         ::wxInputStream* stream;
        int streamState = 0;
        bool verbose = 1;
        int index = -1;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_image,
            sipName_stream,
            sipName_verbose,
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1|bi", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxImage, &image, sipType_wxInputStream, &stream, &streamState, &verbose, &index))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImageHandler::LoadFile(image,*stream,verbose,index) : sipCpp->LoadFile(image,*stream,verbose,index));
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_LoadFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_SaveFile, "SaveFile(image, stream, verbose=True) -> bool\n"
"\n"
"Saves a image in the output stream.");

extern "C" {static PyObject *meth_wxImageHandler_SaveFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_SaveFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxImage* image;
         ::wxOutputStream* stream;
        int streamState = 0;
        bool verbose = 1;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_image,
            sipName_stream,
            sipName_verbose,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1|b", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxImage, &image, sipType_wxOutputStream, &stream, &streamState, &verbose))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImageHandler::SaveFile(image,*stream,verbose) : sipCpp->SaveFile(image,*stream,verbose));
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxOutputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_SaveFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_SetExtension, "SetExtension(extension)\n"
"\n"
"Sets the preferred file extension associated with this handler.");

extern "C" {static PyObject *meth_wxImageHandler_SetExtension(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_SetExtension(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* extension;
        int extensionState = 0;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_extension,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxString,&extension, &extensionState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetExtension(*extension);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(extension),sipType_wxString,extensionState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_SetExtension, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_SetAltExtensions, "SetAltExtensions(extensions)\n"
"\n"
"Sets the alternative file extensions associated with this handler.");

extern "C" {static PyObject *meth_wxImageHandler_SetAltExtensions(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_SetAltExtensions(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* extensions;
        int extensionsState = 0;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_extensions,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxArrayString,&extensions, &extensionsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAltExtensions(*extensions);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(extensions),sipType_wxArrayString,extensionsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_SetAltExtensions, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_SetMimeType, "SetMimeType(mimetype)\n"
"\n"
"Sets the handler MIME type.");

extern "C" {static PyObject *meth_wxImageHandler_SetMimeType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_SetMimeType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* mimetype;
        int mimetypeState = 0;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mimetype,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxString,&mimetype, &mimetypeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMimeType(*mimetype);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_SetMimeType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_SetName, "SetName(name)\n"
"\n"
"Sets the handler name.");

extern "C" {static PyObject *meth_wxImageHandler_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_SetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_SetType, "SetType(type)\n"
"\n"
"Sets the bitmap type for the handler.");

extern "C" {static PyObject *meth_wxImageHandler_SetType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_SetType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxBitmapType type;
         ::wxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxBitmapType, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetType(type);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_SetType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_DoGetImageCount, "DoGetImageCount(stream) -> int\n"
"\n"
"Called to get the number of images available in a multi-image file\n"
"type, if supported.");

extern "C" {static PyObject *meth_wxImageHandler_DoGetImageCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_DoGetImageCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxInputStream* stream;
        int streamState = 0;
        sipwxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxInputStream, &stream, &streamState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_DoGetImageCount(sipSelfWasArg,*stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_DoGetImageCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageHandler_DoCanRead, "DoCanRead(stream) -> bool\n"
"\n"
"Called to test if this handler can read an image from the given\n"
"stream.");

extern "C" {static PyObject *meth_wxImageHandler_DoCanRead(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageHandler_DoCanRead(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxInputStream* stream;
        int streamState = 0;
        sipwxImageHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImageHandler, &sipCpp, sipType_wxInputStream, &stream, &streamState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ImageHandler, sipName_DoCanRead);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_DoCanRead(*stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageHandler, sipName_DoCanRead, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxImageHandler(void *, const sipTypeDef *);}
static void *cast_wxImageHandler(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxImageHandler *sipCpp = reinterpret_cast< ::wxImageHandler *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxImageHandler(void *, int);}
static void release_wxImageHandler(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxImageHandler *>(sipCppV);
    else
        delete reinterpret_cast< ::wxImageHandler *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxImageHandler(sipSimpleWrapper *);}
static void dealloc_wxImageHandler(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxImageHandler *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxImageHandler(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxImageHandler(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxImageHandler(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxImageHandler *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImageHandler();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxImageHandler[] = {{348, 255, 1}};


static PyMethodDef methods_wxImageHandler[] = {
    {SIP_MLNAME_CAST(sipName_CanRead), (PyCFunction)meth_wxImageHandler_CanRead, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_CanRead)},
    {SIP_MLNAME_CAST(sipName_DoCanRead), (PyCFunction)meth_wxImageHandler_DoCanRead, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_DoCanRead)},
    {SIP_MLNAME_CAST(sipName_DoGetImageCount), (PyCFunction)meth_wxImageHandler_DoGetImageCount, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_DoGetImageCount)},
    {SIP_MLNAME_CAST(sipName_GetAltExtensions), meth_wxImageHandler_GetAltExtensions, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImageHandler_GetAltExtensions)},
    {SIP_MLNAME_CAST(sipName_GetExtension), meth_wxImageHandler_GetExtension, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImageHandler_GetExtension)},
    {SIP_MLNAME_CAST(sipName_GetImageCount), (PyCFunction)meth_wxImageHandler_GetImageCount, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_GetImageCount)},
    {SIP_MLNAME_CAST(sipName_GetMimeType), meth_wxImageHandler_GetMimeType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImageHandler_GetMimeType)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxImageHandler_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImageHandler_GetName)},
    {SIP_MLNAME_CAST(sipName_GetType), meth_wxImageHandler_GetType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImageHandler_GetType)},
    {SIP_MLNAME_CAST(sipName_LoadFile), (PyCFunction)meth_wxImageHandler_LoadFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_LoadFile)},
    {SIP_MLNAME_CAST(sipName_SaveFile), (PyCFunction)meth_wxImageHandler_SaveFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_SaveFile)},
    {SIP_MLNAME_CAST(sipName_SetAltExtensions), (PyCFunction)meth_wxImageHandler_SetAltExtensions, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_SetAltExtensions)},
    {SIP_MLNAME_CAST(sipName_SetExtension), (PyCFunction)meth_wxImageHandler_SetExtension, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_SetExtension)},
    {SIP_MLNAME_CAST(sipName_SetMimeType), (PyCFunction)meth_wxImageHandler_SetMimeType, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_SetMimeType)},
    {SIP_MLNAME_CAST(sipName_SetName), (PyCFunction)meth_wxImageHandler_SetName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_SetName)},
    {SIP_MLNAME_CAST(sipName_SetType), (PyCFunction)meth_wxImageHandler_SetType, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageHandler_SetType)}
};

sipVariableDef variables_wxImageHandler[] = {
    {PropertyVariable, sipName_Type, &methods_wxImageHandler[8], &methods_wxImageHandler[15], NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxImageHandler[7], &methods_wxImageHandler[14], NULL, NULL},
    {PropertyVariable, sipName_MimeType, &methods_wxImageHandler[6], &methods_wxImageHandler[13], NULL, NULL},
    {PropertyVariable, sipName_Extension, &methods_wxImageHandler[4], &methods_wxImageHandler[12], NULL, NULL},
    {PropertyVariable, sipName_AltExtensions, &methods_wxImageHandler[3], &methods_wxImageHandler[11], NULL, NULL},
};

PyDoc_STRVAR(doc_wxImageHandler, "ImageHandler()\n"
"\n"
"This is the base class for implementing image file loading/saving, and\n"
"image creation from data.");


sipClassTypeDef sipTypeDef__core_wxImageHandler = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxImageHandler,
        {0},
        0
    },
    {
        sipNameNr_ImageHandler,
        {0, 0, 1},
        16, methods_wxImageHandler,
        0, 0,
        5, variables_wxImageHandler,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxImageHandler,
    -1,
    -1,
    supers_wxImageHandler,
    0,
    init_type_wxImageHandler,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxImageHandler,
    0,
    0,
    0,
    release_wxImageHandler,
    cast_wxImageHandler,
    0,
    0,
    0,
    0,
    0,
    0
};
