/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/imaglist.h>

        #include <wx/bitmap.h>
        #include <wx/icon.h>
        #include <wx/dc.h>
        #include <wx/colour.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxImageList_Add, "Add(bitmap, mask=NullBitmap) -> int\n"
"Add(bitmap, maskColour) -> int\n"
"Add(icon) -> int\n"
"\n"
"Adds a new image or images using a bitmap and optional mask bitmap.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxImageList_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* bitmap;
        const  ::wxBitmap& maskdef = wxNullBitmap;
        const  ::wxBitmap* mask = &maskdef;
         ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
            sipName_mask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|J9", &sipSelf, sipType_wxImageList, &sipCpp, sipType_wxBitmap, &bitmap, sipType_wxBitmap, &mask))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(*bitmap,*mask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const  ::wxBitmap* bitmap;
        const  ::wxColour* maskColour;
        int maskColourState = 0;
         ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
            sipName_maskColour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1", &sipSelf, sipType_wxImageList, &sipCpp, sipType_wxBitmap, &bitmap, sipType_wxColour, &maskColour, &maskColourState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(*bitmap,*maskColour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(maskColour),sipType_wxColour,maskColourState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const  ::wxIcon* icon;
         ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxImageList, &sipCpp, sipType_wxIcon, &icon))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Add(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Add, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_Create, "Create(width, height, mask=True, initialCount=1) -> bool\n"
"\n"
"Initializes the list.");

extern "C" {static PyObject *meth_wxImageList_Create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Create(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
        int height;
        bool mask = 1;
        int initialCount = 1;
         ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_mask,
            sipName_initialCount,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii|bi", &sipSelf, sipType_wxImageList, &sipCpp, &width, &height, &mask, &initialCount))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Create(width,height,mask,initialCount);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Create, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_Draw, "Draw(index, dc, x, y, flags=IMAGELIST_DRAW_NORMAL, solidBackground=False) -> bool\n"
"\n"
"Draws a specified image onto a device context.");

extern "C" {static PyObject *meth_wxImageList_Draw(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Draw(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int index;
         ::wxDC* dc;
        int x;
        int y;
        int flags = wxIMAGELIST_DRAW_NORMAL;
        bool solidBackground = 0;
         ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_dc,
            sipName_x,
            sipName_y,
            sipName_flags,
            sipName_solidBackground,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ9ii|ib", &sipSelf, sipType_wxImageList, &sipCpp, &index, sipType_wxDC, &dc, &x, &y, &flags, &solidBackground))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Draw(index,*dc,x,y,flags,solidBackground);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Draw, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_GetBitmap, "GetBitmap(index) -> Bitmap\n"
"\n"
"Returns the bitmap corresponding to the given index.");

extern "C" {static PyObject *meth_wxImageList_GetBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_GetBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int index;
        const  ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxImageList, &sipCpp, &index))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->GetBitmap(index));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_GetBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_GetIcon, "GetIcon(index) -> Icon\n"
"\n"
"Returns the icon corresponding to the given index.");

extern "C" {static PyObject *meth_wxImageList_GetIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_GetIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int index;
        const  ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxImageList, &sipCpp, &index))
        {
             ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxIcon(sipCpp->GetIcon(index));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxIcon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_GetIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_GetImageCount, "GetImageCount() -> int\n"
"\n"
"Returns the number of images in the list.");

extern "C" {static PyObject *meth_wxImageList_GetImageCount(PyObject *, PyObject *);}
static PyObject *meth_wxImageList_GetImageCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImageList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageList, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetImageCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_GetImageCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_GetSize, "GetSize(index) -> (width, height)\n"
"\n"
"Retrieves the size of the images in the list.");

extern "C" {static PyObject *meth_wxImageList_GetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_GetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int index;
        int width;
        int height;
        const  ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxImageList, &sipCpp, &index))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetSize(index,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(ii)",width,height);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_GetSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_Remove, "Remove(index) -> bool\n"
"\n"
"Removes the image at the given position.");

extern "C" {static PyObject *meth_wxImageList_Remove(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Remove(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int index;
         ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxImageList, &sipCpp, &index))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Remove(index);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Remove, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_RemoveAll, "RemoveAll() -> bool\n"
"\n"
"Removes all the images in the list.");

extern "C" {static PyObject *meth_wxImageList_RemoveAll(PyObject *, PyObject *);}
static PyObject *meth_wxImageList_RemoveAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImageList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageList, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_RemoveAll, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImageList_Replace, "Replace(index, bitmap, mask=NullBitmap) -> bool\n"
"Replace(index, icon) -> bool\n"
"\n"
"Replaces the existing image with the new image.\n"
"");

extern "C" {static PyObject *meth_wxImageList_Replace(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageList_Replace(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int index;
        const  ::wxBitmap* bitmap;
        const  ::wxBitmap& maskdef = wxNullBitmap;
        const  ::wxBitmap* mask = &maskdef;
         ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_bitmap,
            sipName_mask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ9|J9", &sipSelf, sipType_wxImageList, &sipCpp, &index, sipType_wxBitmap, &bitmap, sipType_wxBitmap, &mask))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Replace(index,*bitmap,*mask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int index;
        const  ::wxIcon* icon;
         ::wxImageList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ9", &sipSelf, sipType_wxImageList, &sipCpp, &index, sipType_wxIcon, &icon))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Replace(index,*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageList, sipName_Replace, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxImageList(void *, const sipTypeDef *);}
static void *cast_wxImageList(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxImageList *sipCpp = reinterpret_cast< ::wxImageList *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxImageList(void *, int);}
static void release_wxImageList(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxImageList *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxImageList(sipSimpleWrapper *);}
static void dealloc_wxImageList(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxImageList(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxImageList(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxImageList(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxImageList *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxImageList();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        int width;
        int height;
        bool mask = 1;
        int initialCount = 1;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_mask,
            sipName_initialCount,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii|bi", &width, &height, &mask, &initialCount))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxImageList(width,height,mask,initialCount);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxImageList[] = {{348, 255, 1}};


static PyMethodDef methods_wxImageList[] = {
    {SIP_MLNAME_CAST(sipName_Add), (PyCFunction)meth_wxImageList_Add, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageList_Add)},
    {SIP_MLNAME_CAST(sipName_Create), (PyCFunction)meth_wxImageList_Create, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageList_Create)},
    {SIP_MLNAME_CAST(sipName_Draw), (PyCFunction)meth_wxImageList_Draw, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageList_Draw)},
    {SIP_MLNAME_CAST(sipName_GetBitmap), (PyCFunction)meth_wxImageList_GetBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageList_GetBitmap)},
    {SIP_MLNAME_CAST(sipName_GetIcon), (PyCFunction)meth_wxImageList_GetIcon, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageList_GetIcon)},
    {SIP_MLNAME_CAST(sipName_GetImageCount), meth_wxImageList_GetImageCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImageList_GetImageCount)},
    {SIP_MLNAME_CAST(sipName_GetSize), (PyCFunction)meth_wxImageList_GetSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageList_GetSize)},
    {SIP_MLNAME_CAST(sipName_Remove), (PyCFunction)meth_wxImageList_Remove, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageList_Remove)},
    {SIP_MLNAME_CAST(sipName_RemoveAll), meth_wxImageList_RemoveAll, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImageList_RemoveAll)},
    {SIP_MLNAME_CAST(sipName_Replace), (PyCFunction)meth_wxImageList_Replace, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageList_Replace)}
};

sipVariableDef variables_wxImageList[] = {
    {PropertyVariable, sipName_ImageCount, &methods_wxImageList[5], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxImageList, "ImageList()\n"
"ImageList(width, height, mask=True, initialCount=1)\n"
"\n"
"A wxImageList contains a list of images, which are stored in an\n"
"unspecified form.");


sipClassTypeDef sipTypeDef__core_wxImageList = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxImageList,
        {0},
        0
    },
    {
        sipNameNr_ImageList,
        {0, 0, 1},
        10, methods_wxImageList,
        0, 0,
        1, variables_wxImageList,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxImageList,
    -1,
    -1,
    supers_wxImageList,
    0,
    init_type_wxImageList,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxImageList,
    0,
    0,
    0,
    release_wxImageList,
    cast_wxImageList,
    0,
    0,
    0,
    0,
    0,
    0
};
